/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import io.vertx.core.Future;
import java.util.concurrent.CompletableFuture;
import java.util.function.LongConsumer;

public class StopWatch {
    private StopWatch() {
        throw new UnsupportedOperationException();
    }

    public static void measureTimeTaken(Runnable runnable, LongConsumer intervalConsumer) {
        long start = System.nanoTime();
        boolean success = true;
        try {
            runnable.run();
        }
        catch (RuntimeException rte) {
            success = false;
            throw rte;
        }
        finally {
            if (success) {
                intervalConsumer.accept(System.nanoTime() - start);
            }
        }
    }

    public static <V> Future<V> measureTimeTaken(Future<V> future, LongConsumer intervalConsumer) {
        long start = System.nanoTime();
        return future.onSuccess(v -> intervalConsumer.accept(System.nanoTime() - start));
    }

    public static <V> CompletableFuture<V> measureTimeTaken(CompletableFuture<V> future, LongConsumer intervalConsumer) {
        long start = System.nanoTime();
        return future.thenApply(v -> {
            intervalConsumer.accept(System.nanoTime() - start);
            return v;
        });
    }
}

