/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;

public class SidecarRolePermissionsSchema
extends TableSchema {
    private static final String ROLE_PERMISSIONS_TABLE = "role_permissions_v1";
    private final SchemaKeyspaceConfiguration keyspaceConfig;
    private PreparedStatement allRolesAndPermissions;

    public SidecarRolePermissionsSchema(SidecarConfiguration sidecarConfiguration) {
        this.keyspaceConfig = sidecarConfiguration.serviceConfiguration().schemaKeyspaceConfiguration();
    }

    protected String tableName() {
        return ROLE_PERMISSIONS_TABLE;
    }

    protected String keyspaceName() {
        return this.keyspaceConfig.keyspace();
    }

    protected void prepareStatements(@NotNull Session session) {
        this.allRolesAndPermissions = this.prepare(this.allRolesAndPermissions, session, CqlLiterals.allRolesAndPermissions(this.keyspaceConfig));
    }

    protected String createSchemaStatement() {
        return String.format("CREATE TABLE IF NOT EXISTS %s.%s (role text,resource text,permissions set<text>,PRIMARY KEY(role, resource))", this.keyspaceConfig.keyspace(), ROLE_PERMISSIONS_TABLE);
    }

    public PreparedStatement allRolesPermissions() {
        return this.allRolesAndPermissions;
    }

    private static class CqlLiterals {
        private CqlLiterals() {
        }

        static String allRolesAndPermissions(SchemaKeyspaceConfiguration config) {
            return String.format("SELECT * FROM %s.%s", config.keyspace(), SidecarRolePermissionsSchema.ROLE_PERMISSIONS_TABLE);
        }
    }
}

