/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Future;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.cassandra.sidecar.client.SidecarClient;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.coordination.SidecarPeerHealthProvider;
import org.apache.cassandra.sidecar.utils.SidecarClientProvider;

@Singleton
public class SidecarHttpHealthProvider
implements SidecarPeerHealthProvider {
    private final SidecarClientProvider clientProvider;

    @Inject
    public SidecarHttpHealthProvider(SidecarClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Override
    public Future<SidecarPeerHealthProvider.Health> health(SidecarInstance instance) {
        try {
            SidecarClient client = this.clientProvider.get();
            CompletableFuture healthRequest = client.sidecarHealth(instance);
            return Future.fromCompletionStage((CompletionStage)healthRequest).map(healthResponse -> healthResponse.isOk() ? SidecarPeerHealthProvider.Health.UP : SidecarPeerHealthProvider.Health.DOWN);
        }
        catch (Exception e) {
            return Future.succeededFuture((Object)((Object)SidecarPeerHealthProvider.Health.DOWN));
        }
    }
}

