/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base.db.schema;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import org.apache.cassandra.sidecar.db.schema.CassandraSystemTableSchema;
import org.jetbrains.annotations.NotNull;

public class ConnectedClientsSchema
extends CassandraSystemTableSchema {
    private static final String TABLE_NAME = "clients";
    private static final String KEYSPACE_NAME = "system_views";
    private PreparedStatement statsStatement;
    private PreparedStatement connectionsByUserStatement;

    protected String keyspaceName() {
        return KEYSPACE_NAME;
    }

    public void prepareStatements(@NotNull Session session) {
        this.statsStatement = this.prepare(this.statsStatement, session, ConnectedClientsSchema.statsStatement());
        this.connectionsByUserStatement = this.prepare(this.connectionsByUserStatement, session, ConnectedClientsSchema.selectConnectionsByUserStatement());
    }

    protected String tableName() {
        return TABLE_NAME;
    }

    public PreparedStatement stats() {
        return this.statsStatement;
    }

    public PreparedStatement connectionsByUser() {
        return this.connectionsByUserStatement;
    }

    static String statsStatement() {
        return String.format("SELECT * FROM %s.%s", KEYSPACE_NAME, TABLE_NAME);
    }

    static String selectConnectionsByUserStatement() {
        return String.format("SELECT username, COUNT(*) AS connection_count FROM %s.%s", KEYSPACE_NAME, TABLE_NAME);
    }
}

