/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicationFactor;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.utils.FBUtilities;

public class LocalStrategy
extends AbstractReplicationStrategy {
    private static final ReplicationFactor RF = ReplicationFactor.fullOnly(1);
    private final EndpointsForRange replicas = EndpointsForRange.of(new Replica(FBUtilities.getBroadcastAddressAndPort(), DatabaseDescriptor.getPartitioner().getMinimumToken(), DatabaseDescriptor.getPartitioner().getMinimumToken(), true));

    public LocalStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
    }

    @Override
    public EndpointsForRange getNaturalReplicas(RingPosition<?> searchPosition) {
        return this.replicas;
    }

    @Override
    public EndpointsForRange calculateNaturalReplicas(Token token, TokenMetadata metadata) {
        return this.replicas;
    }

    @Override
    public ReplicationFactor getReplicationFactor() {
        return RF;
    }

    @Override
    public void validateOptions() throws ConfigurationException {
    }

    @Override
    public void maybeWarnOnOptions() {
    }

    @Override
    public Collection<String> recognizedOptions() {
        return Collections.emptySet();
    }
}

