/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Tables;

public class VirtualKeyspace {
    private final String name;
    private final KeyspaceMetadata metadata;
    private final ImmutableCollection<VirtualTable> tables;

    public VirtualKeyspace(String name, Collection<VirtualTable> tables) {
        this.name = name;
        this.tables = ImmutableList.copyOf(tables);
        this.metadata = KeyspaceMetadata.virtual(name, Tables.of(Iterables.transform(tables, VirtualTable::metadata)));
    }

    public String name() {
        return this.name;
    }

    public KeyspaceMetadata metadata() {
        return this.metadata;
    }

    public ImmutableCollection<VirtualTable> tables() {
        return this.tables;
    }
}

