/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Communicate with external systems using the MLLP protocol.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MllpEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the MLLP component.
     */
    public interface MllpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMllpEndpointConsumerBuilder advanced() {
            return (AdvancedMllpEndpointConsumerBuilder) this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Sets the default charset to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param charsetName the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder charsetName(String charsetName) {
            doSetProperty("charsetName", charsetName);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param hl7Headers the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder hl7Headers(boolean hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param hl7Headers the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder hl7Headers(String hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param requireEndOfData the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder requireEndOfData(boolean requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param requireEndOfData the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder requireEndOfData(String requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stringPayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder stringPayload(boolean stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stringPayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder stringPayload(String stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param validatePayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder validatePayload(boolean validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param validatePayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder validatePayload(String validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * receive incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. If disabled, the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions by logging them at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * receive incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. If disabled, the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions by logging them at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the SSLContextParameters for securing TCP connections. If set,
         * the MLLP component will use SSL/TLS for securing both producer and
         * consumer TCP connections. This allows the configuration of trust
         * stores, key stores, protocols, and other SSL/TLS settings. If not
         * set, the MLLP component will use plain TCP communication.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the SSLContextParameters for securing TCP connections. If set,
         * the MLLP component will use SSL/TLS for securing both producer and
         * consumer TCP connections. This allows the configuration of trust
         * stores, key stores, protocols, and other SSL/TLS settings. If not
         * set, the MLLP component will use plain TCP communication.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MllpEndpointConsumerBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the MLLP component.
     */
    public interface AdvancedMllpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MllpEndpointConsumerBuilder basic() {
            return (MllpEndpointConsumerBuilder) this;
        }
        /**
         * Timeout (in milliseconds) while waiting for a TCP connection TCP
         * Server Only.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param acceptTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder acceptTimeout(int acceptTimeout) {
            doSetProperty("acceptTimeout", acceptTimeout);
            return this;
        }
        /**
         * Timeout (in milliseconds) while waiting for a TCP connection TCP
         * Server Only.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param acceptTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder acceptTimeout(String acceptTimeout) {
            doSetProperty("acceptTimeout", acceptTimeout);
            return this;
        }
        /**
         * The maximum queue length for incoming connection indications (a
         * request to connect) is set to the backlog parameter. If a connection
         * indication arrives when the queue is full, the connection is refused.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: consumer
         * 
         * @param backlog the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder backlog(Integer backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * The maximum queue length for incoming connection indications (a
         * request to connect) is set to the backlog parameter. If a connection
         * indication arrives when the queue is full, the connection is refused.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5
         * Group: consumer
         * 
         * @param backlog the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder backlog(String backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to wait between bind
         * attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param bindRetryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder bindRetryInterval(int bindRetryInterval) {
            doSetProperty("bindRetryInterval", bindRetryInterval);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to wait between bind
         * attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param bindRetryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder bindRetryInterval(String bindRetryInterval) {
            doSetProperty("bindRetryInterval", bindRetryInterval);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to retry binding to a
         * server port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param bindTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder bindTimeout(int bindTimeout) {
            doSetProperty("bindTimeout", bindTimeout);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to retry binding to a
         * server port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param bindTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder bindTimeout(String bindTimeout) {
            doSetProperty("bindTimeout", bindTimeout);
            return this;
        }
        /**
         * TCP Server Only - Allow the endpoint to start before the TCP
         * ServerSocket is bound. In some environments, it may be desirable to
         * allow the endpoint to start before the TCP ServerSocket is bound.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param lenientBind the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder lenientBind(boolean lenientBind) {
            doSetProperty("lenientBind", lenientBind);
            return this;
        }
        /**
         * TCP Server Only - Allow the endpoint to start before the TCP
         * ServerSocket is bound. In some environments, it may be desirable to
         * allow the endpoint to start before the TCP ServerSocket is bound.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param lenientBind the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder lenientBind(String lenientBind) {
            doSetProperty("lenientBind", lenientBind);
            return this;
        }
        /**
         * The maximum number of concurrent MLLP Consumer connections that will
         * be allowed. If a new connection is received and the maximum is number
         * are already established, the new connection will be reset
         * immediately.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5
         * Group: consumer
         * 
         * @param maxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder maxConcurrentConsumers(int maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * The maximum number of concurrent MLLP Consumer connections that will
         * be allowed. If a new connection is received and the maximum is number
         * are already established, the new connection will be reset
         * immediately.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5
         * Group: consumer
         * 
         * @param maxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder maxConcurrentConsumers(String maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * Enable/disable the SO_REUSEADDR socket option.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder reuseAddress(Boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Enable/disable the SO_REUSEADDR socket option.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder reuseAddress(String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Default: InOut
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Default: InOut
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Maximum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1073741824
         * Group: advanced
         * 
         * @param maxBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder maxBufferSize(int maxBufferSize) {
            doSetProperty("maxBufferSize", maxBufferSize);
            return this;
        }
        /**
         * Maximum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1073741824
         * Group: advanced
         * 
         * @param maxBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder maxBufferSize(String maxBufferSize) {
            doSetProperty("maxBufferSize", maxBufferSize);
            return this;
        }
        /**
         * Minimum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: advanced
         * 
         * @param minBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder minBufferSize(int minBufferSize) {
            doSetProperty("minBufferSize", minBufferSize);
            return this;
        }
        /**
         * Minimum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: advanced
         * 
         * @param minBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder minBufferSize(String minBufferSize) {
            doSetProperty("minBufferSize", minBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder readTimeout(int readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder receiveBufferSize(Integer receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder receiveBufferSize(String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 15000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder receiveTimeout(int receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 15000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder receiveTimeout(String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder sendBufferSize(Integer sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder sendBufferSize(String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         * 
         * @param idleTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder idleTimeout(Integer idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         * 
         * @param idleTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointConsumerBuilder idleTimeout(String idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the MLLP component.
     */
    public interface MllpEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMllpEndpointProducerBuilder advanced() {
            return (AdvancedMllpEndpointProducerBuilder) this;
        }

        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Sets the default charset to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param charsetName the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder charsetName(String charsetName) {
            doSetProperty("charsetName", charsetName);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param hl7Headers the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder hl7Headers(boolean hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param hl7Headers the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder hl7Headers(String hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param requireEndOfData the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder requireEndOfData(boolean requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param requireEndOfData the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder requireEndOfData(String requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stringPayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder stringPayload(boolean stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stringPayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder stringPayload(String stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param validatePayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder validatePayload(boolean validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param validatePayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder validatePayload(String validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Sets the SSLContextParameters for securing TCP connections. If set,
         * the MLLP component will use SSL/TLS for securing both producer and
         * consumer TCP connections. This allows the configuration of trust
         * stores, key stores, protocols, and other SSL/TLS settings. If not
         * set, the MLLP component will use plain TCP communication.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the SSLContextParameters for securing TCP connections. If set,
         * the MLLP component will use SSL/TLS for securing both producer and
         * consumer TCP connections. This allows the configuration of trust
         * stores, key stores, protocols, and other SSL/TLS settings. If not
         * set, the MLLP component will use plain TCP communication.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MllpEndpointProducerBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the MLLP component.
     */
    public interface AdvancedMllpEndpointProducerBuilder extends EndpointProducerBuilder {
        default MllpEndpointProducerBuilder basic() {
            return (MllpEndpointProducerBuilder) this;
        }

        /**
         * Timeout (in milliseconds) for establishing for a TCP connection TCP
         * Client only.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder connectTimeout(int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Timeout (in milliseconds) for establishing for a TCP connection TCP
         * Client only.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder connectTimeout(String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * decide what action to take when idle timeout occurs. Possible values
         * are : RESET: set SO_LINGER to 0 and reset the socket CLOSE: close the
         * socket gracefully default is RESET.
         * 
         * The option is a:
         * <code>org.apache.camel.component.mllp.MllpIdleTimeoutStrategy</code>
         * type.
         * 
         * Default: RESET
         * Group: producer
         * 
         * @param idleTimeoutStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder idleTimeoutStrategy(org.apache.camel.component.mllp.MllpIdleTimeoutStrategy idleTimeoutStrategy) {
            doSetProperty("idleTimeoutStrategy", idleTimeoutStrategy);
            return this;
        }
        /**
         * decide what action to take when idle timeout occurs. Possible values
         * are : RESET: set SO_LINGER to 0 and reset the socket CLOSE: close the
         * socket gracefully default is RESET.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.mllp.MllpIdleTimeoutStrategy</code>
         * type.
         * 
         * Default: RESET
         * Group: producer
         * 
         * @param idleTimeoutStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder idleTimeoutStrategy(String idleTimeoutStrategy) {
            doSetProperty("idleTimeoutStrategy", idleTimeoutStrategy);
            return this;
        }
        /**
         * Enable/disable the SO_KEEPALIVE socket option.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder keepAlive(Boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Enable/disable the SO_KEEPALIVE socket option.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Enable/disable the TCP_NODELAY socket option.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder tcpNoDelay(Boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Enable/disable the TCP_NODELAY socket option.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Maximum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1073741824
         * Group: advanced
         * 
         * @param maxBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder maxBufferSize(int maxBufferSize) {
            doSetProperty("maxBufferSize", maxBufferSize);
            return this;
        }
        /**
         * Maximum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1073741824
         * Group: advanced
         * 
         * @param maxBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder maxBufferSize(String maxBufferSize) {
            doSetProperty("maxBufferSize", maxBufferSize);
            return this;
        }
        /**
         * Minimum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: advanced
         * 
         * @param minBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder minBufferSize(int minBufferSize) {
            doSetProperty("minBufferSize", minBufferSize);
            return this;
        }
        /**
         * Minimum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: advanced
         * 
         * @param minBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder minBufferSize(String minBufferSize) {
            doSetProperty("minBufferSize", minBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder readTimeout(int readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder receiveBufferSize(Integer receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder receiveBufferSize(String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 15000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder receiveTimeout(int receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 15000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder receiveTimeout(String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder sendBufferSize(Integer sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder sendBufferSize(String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         * 
         * @param idleTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder idleTimeout(Integer idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         * 
         * @param idleTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointProducerBuilder idleTimeout(String idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint for the MLLP component.
     */
    public interface MllpEndpointBuilder
            extends
                MllpEndpointConsumerBuilder,
                MllpEndpointProducerBuilder {
        default AdvancedMllpEndpointBuilder advanced() {
            return (AdvancedMllpEndpointBuilder) this;
        }

        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Sets the default charset to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param charsetName the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder charsetName(String charsetName) {
            doSetProperty("charsetName", charsetName);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param hl7Headers the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder hl7Headers(boolean hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param hl7Headers the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder hl7Headers(String hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param requireEndOfData the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder requireEndOfData(boolean requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param requireEndOfData the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder requireEndOfData(String requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stringPayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder stringPayload(boolean stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stringPayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder stringPayload(String stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param validatePayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder validatePayload(boolean validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param validatePayload the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder validatePayload(String validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Sets the SSLContextParameters for securing TCP connections. If set,
         * the MLLP component will use SSL/TLS for securing both producer and
         * consumer TCP connections. This allows the configuration of trust
         * stores, key stores, protocols, and other SSL/TLS settings. If not
         * set, the MLLP component will use plain TCP communication.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the SSLContextParameters for securing TCP connections. If set,
         * the MLLP component will use SSL/TLS for securing both producer and
         * consumer TCP connections. This allows the configuration of trust
         * stores, key stores, protocols, and other SSL/TLS settings. If not
         * set, the MLLP component will use plain TCP communication.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MllpEndpointBuilder sslContextParameters(String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the MLLP component.
     */
    public interface AdvancedMllpEndpointBuilder
            extends
                AdvancedMllpEndpointConsumerBuilder,
                AdvancedMllpEndpointProducerBuilder {
        default MllpEndpointBuilder basic() {
            return (MllpEndpointBuilder) this;
        }

        /**
         * Maximum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1073741824
         * Group: advanced
         * 
         * @param maxBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder maxBufferSize(int maxBufferSize) {
            doSetProperty("maxBufferSize", maxBufferSize);
            return this;
        }
        /**
         * Maximum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1073741824
         * Group: advanced
         * 
         * @param maxBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder maxBufferSize(String maxBufferSize) {
            doSetProperty("maxBufferSize", maxBufferSize);
            return this;
        }
        /**
         * Minimum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: advanced
         * 
         * @param minBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder minBufferSize(int minBufferSize) {
            doSetProperty("minBufferSize", minBufferSize);
            return this;
        }
        /**
         * Minimum buffer size used when receiving or sending data over the
         * wire.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: advanced
         * 
         * @param minBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder minBufferSize(String minBufferSize) {
            doSetProperty("minBufferSize", minBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder readTimeout(int readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder receiveBufferSize(Integer receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder receiveBufferSize(String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 15000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder receiveTimeout(int receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 15000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder receiveTimeout(String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder sendBufferSize(Integer sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 8192
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder sendBufferSize(String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         * 
         * @param idleTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder idleTimeout(Integer idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         * 
         * @param idleTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMllpEndpointBuilder idleTimeout(String idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
    }

    public interface MllpBuilders {
        /**
         * MLLP (camel-mllp)
         * Communicate with external systems using the MLLP protocol.
         * 
         * Category: health
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-mllp
         * 
         * @return the dsl builder for the headers' name.
         */
        default MllpHeaderNameBuilder mllp() {
            return MllpHeaderNameBuilder.INSTANCE;
        }
        /**
         * MLLP (camel-mllp)
         * Communicate with external systems using the MLLP protocol.
         * 
         * Category: health
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-mllp
         * 
         * Syntax: <code>mllp:hostname:port</code>
         * 
         * Path parameter: hostname (required)
         * Hostname or IP for connection for the TCP connection. The default
         * value is null, which means any local IP address
         * 
         * Path parameter: port (required)
         * Port number for the TCP connection
         * 
         * @param path hostname:port
         * @return the dsl builder
         */
        default MllpEndpointBuilder mllp(String path) {
            return MllpEndpointBuilderFactory.endpointBuilder("mllp", path);
        }
        /**
         * MLLP (camel-mllp)
         * Communicate with external systems using the MLLP protocol.
         * 
         * Category: health
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-mllp
         * 
         * Syntax: <code>mllp:hostname:port</code>
         * 
         * Path parameter: hostname (required)
         * Hostname or IP for connection for the TCP connection. The default
         * value is null, which means any local IP address
         * 
         * Path parameter: port (required)
         * Port number for the TCP connection
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path hostname:port
         * @return the dsl builder
         */
        default MllpEndpointBuilder mllp(String componentName, String path) {
            return MllpEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the MLLP component.
     */
    public static class MllpHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final MllpHeaderNameBuilder INSTANCE = new MllpHeaderNameBuilder();

        /**
         * The local TCP Address of the Socket.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MllpLocalAddress}.
         */
        public String mllpLocalAddress() {
            return "CamelMllpLocalAddress";
        }
        /**
         * The remote TCP Address of the Socket.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MllpRemoteAddress}.
         */
        public String mllpRemoteAddress() {
            return "CamelMllpRemoteAddress";
        }
        /**
         * The SSL client certificate subject name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSslClientCertSubjectName}.
         */
        public String mllpSslClientCertSubjectName() {
            return "CamelMllpSslClientCertSubjectName";
        }
        /**
         * The SSL client certificate issuer name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSslClientCertIssuerName}.
         */
        public String mllpSslClientCertIssuerName() {
            return "CamelMllpSslClientCertIssuerName";
        }
        /**
         * The SSL client certificate serial number.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSslClientCertSerialNo}.
         */
        public String mllpSslClientCertSerialNo() {
            return "CamelMllpSslClientCertSerialNo";
        }
        /**
         * The SSL client certificate not before.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSslClientCertNotBefore}.
         */
        public String mllpSslClientCertNotBefore() {
            return "CamelMllpSslClientCertNotBefore";
        }
        /**
         * The SSL client certificate not after.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSslClientCertNotAfter}.
         */
        public String mllpSslClientCertNotAfter() {
            return "CamelMllpSslClientCertNotAfter";
        }
        /**
         * The HL7 Acknowledgment received in bytes.
         * 
         * The option is a: {@code byte[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MllpAcknowledgement}.
         */
        public String mllpAcknowledgement() {
            return "CamelMllpAcknowledgement";
        }
        /**
         * The HL7 Acknowledgment received, converted to a String.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MllpAcknowledgementString}.
         */
        public String mllpAcknowledgementString() {
            return "CamelMllpAcknowledgementString";
        }
        /**
         * The HL7 acknowledgement type (AA, AE, AR, etc).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MllpAcknowledgementType}.
         */
        public String mllpAcknowledgementType() {
            return "CamelMllpAcknowledgementType";
        }
        /**
         * MSH-3 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSendingApplication}.
         */
        public String mllpSendingApplication() {
            return "CamelMllpSendingApplication";
        }
        /**
         * MSH-4 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSendingFacility}.
         */
        public String mllpSendingFacility() {
            return "CamelMllpSendingFacility";
        }
        /**
         * MSH-5 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpReceivingApplication}.
         */
        public String mllpReceivingApplication() {
            return "CamelMllpReceivingApplication";
        }
        /**
         * MSH-6 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpReceivingFacility}.
         */
        public String mllpReceivingFacility() {
            return "CamelMllpReceivingFacility";
        }
        /**
         * MSH-7 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpTimestamp}.
         */
        public String mllpTimestamp() {
            return "CamelMllpTimestamp";
        }
        /**
         * MSH-8 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpSecurity}.
         */
        public String mllpSecurity() {
            return "CamelMllpSecurity";
        }
        /**
         * MSH-9 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpMessageType}.
         */
        public String mllpMessageType() {
            return "CamelMllpMessageType";
        }
        /**
         * MSH-9.1 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpEventType}.
         */
        public String mllpEventType() {
            return "CamelMllpEventType";
        }
        /**
         * MSH-9.2 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpTriggerEvent}.
         */
        public String mllpTriggerEvent() {
            return "CamelMllpTriggerEvent";
        }
        /**
         * MSH-10 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpMessageControlId}.
         */
        public String mllpMessageControlId() {
            return "CamelMllpMessageControlId";
        }
        /**
         * MSH-11 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpProcessingId}.
         */
        public String mllpProcessingId() {
            return "CamelMllpProcessingId";
        }
        /**
         * MSH-12 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpVersionId}.
         */
        public String mllpVersionId() {
            return "CamelMllpVersionId";
        }
        /**
         * MSH-18 value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MllpCharset}.
         */
        public String mllpCharset() {
            return "CamelMllpCharset";
        }
    }
    static MllpEndpointBuilder endpointBuilder(String componentName, String path) {
        class MllpEndpointBuilderImpl extends AbstractEndpointBuilder implements MllpEndpointBuilder, AdvancedMllpEndpointBuilder {
            public MllpEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new MllpEndpointBuilderImpl(path);
    }
}