/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.notification;

import java.util.HashMap;
import java.util.Map;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.notification.Client;
import org.jolokia.server.core.service.notification.NotificationBackend;

public class NotificationBackendManager {
    private final JolokiaContext context;

    public NotificationBackendManager(JolokiaContext pContext) {
        this.context = pContext;
    }

    public Map<String, ?> getBackendConfig() {
        HashMap configMap = new HashMap();
        for (NotificationBackend backend : this.context.getServices(NotificationBackend.class)) {
            configMap.put(backend.getNotifType(), backend.getConfig());
        }
        return configMap;
    }

    public NotificationBackend getBackend(String pType) {
        for (NotificationBackend backend : this.context.getServices(NotificationBackend.class)) {
            if (!backend.getNotifType().equalsIgnoreCase(pType)) continue;
            return backend;
        }
        throw new IllegalArgumentException("No notification backend of type '" + pType + "' registered. Known backends: " + String.valueOf(this.context.getServices(NotificationBackend.class)));
    }

    public void unsubscribe(String pType, String pClient, String pHandle) {
        NotificationBackend backend = this.getBackend(pType);
        backend.unsubscribe(pClient, pHandle);
    }

    public void unregister(Client pClient) {
        for (String mode : pClient.getUsedBackendModes()) {
            NotificationBackend backend = this.getBackend(mode);
            backend.unregister(pClient);
        }
    }
}

