/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

@Deprecated(since="2.1.0")
public class ScriptCommand
extends Shell.Command {
    protected Option list;
    protected Option engine;
    protected Option script;
    protected Option file;
    protected Option args;
    protected Option out;
    protected Option function;
    protected Option object;
    private static final String DEFAULT_ENGINE = "rhino";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="app is run in same security context as user providing the filename")
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        FileWriter writer;
        block36: {
            ScriptEngine engine;
            boolean invoke = false;
            Shell.log.warn("The script command is deprecated; use jshell for scripting instead");
            ScriptEngineManager mgr = new ScriptEngineManager();
            if (cl.hasOption(this.list.getOpt())) {
                this.listJSREngineInfo(mgr, shellState);
                return 0;
            }
            if (!cl.hasOption(this.file.getOpt()) && !cl.hasOption(this.script.getOpt())) {
                this.printHelp(shellState);
                return 0;
            }
            String engineName = DEFAULT_ENGINE;
            if (cl.hasOption(this.engine.getOpt())) {
                engineName = cl.getOptionValue(this.engine.getOpt());
            }
            if ((engine = mgr.getEngineByName(engineName)) == null) {
                shellState.printException(new Exception(engineName + " not found"));
                return 1;
            }
            if (cl.hasOption(this.object.getOpt()) || cl.hasOption(this.function.getOpt())) {
                if (!(engine instanceof Invocable)) {
                    shellState.printException(new Exception(engineName + " does not support invoking functions or methods"));
                    return 1;
                }
                invoke = true;
            }
            SimpleScriptContext ctx = new SimpleScriptContext();
            Bindings b = engine.getBindings(100);
            this.putConnector(b, shellState.getAccumuloClient());
            b.put("client", (Object)shellState.getAccumuloClient());
            ArrayList<String> argValues = new ArrayList<String>();
            if (cl.hasOption(this.args.getOpt())) {
                String[] argList;
                for (String string : argList = cl.getOptionValue(this.args.getOpt()).split(",")) {
                    String[] parts = string.split("=");
                    if (parts.length == 0) continue;
                    if (parts.length == 1) {
                        b.put(parts[0], (Object)null);
                        argValues.add(null);
                        continue;
                    }
                    if (parts.length != 2) continue;
                    b.put(parts[0], (Object)parts[1]);
                    argValues.add(parts[1]);
                }
            }
            ctx.setBindings(b, 100);
            Object[] argArray = argValues.toArray(new Object[argValues.size()]);
            writer = null;
            if (cl.hasOption(this.out.getOpt())) {
                File f = new File(cl.getOptionValue(this.out.getOpt()));
                writer = new FileWriter(f, StandardCharsets.UTF_8);
                ctx.setWriter(writer);
            }
            if (cl.hasOption(this.file.getOpt())) {
                File f = new File(cl.getOptionValue(this.file.getOpt()));
                if (!f.exists()) {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                    shellState.printException(new Exception(f.getAbsolutePath() + " not found"));
                    return 1;
                }
                FileReader reader = new FileReader(f, StandardCharsets.UTF_8);
                try (FileReader fileReader = reader;){
                    engine.eval((Reader)reader, (ScriptContext)ctx);
                    if (invoke) {
                        this.invokeFunctionOrMethod(shellState, engine, cl, argArray);
                    }
                    break block36;
                }
                catch (ScriptException scriptException) {
                    shellState.printException(scriptException);
                    int n = 1;
                    return n;
                }
                finally {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
            }
            if (cl.hasOption(this.script.getOpt())) {
                String inlineScript = cl.getOptionValue(this.script.getOpt());
                try {
                    if (engine instanceof Compilable) {
                        Compilable compiledEng = (Compilable)((Object)engine);
                        CompiledScript compiledScript = compiledEng.compile(inlineScript);
                        compiledScript.eval(ctx);
                        if (invoke) {
                            this.invokeFunctionOrMethod(shellState, engine, cl, argArray);
                        }
                        break block36;
                    }
                    engine.eval(inlineScript, (ScriptContext)ctx);
                    if (invoke) {
                        this.invokeFunctionOrMethod(shellState, engine, cl, argArray);
                    }
                }
                catch (ScriptException ex) {
                    shellState.printException(ex);
                    int n = 1;
                    return n;
                }
                finally {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        if (writer == null) return 0;
        ((Writer)writer).close();
        return 0;
    }

    private void putConnector(Bindings b, AccumuloClient client) {
        try {
            b.put("connection", (Object)Connector.from((AccumuloClient)client));
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String description() {
        return "(deprecated) execute JSR-223 scripts";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.engine = new Option("e", "engine", false, "engine name, defaults to JDK default (Rhino)");
        this.engine.setArgName("engineName");
        this.engine.setArgs(1);
        this.engine.setRequired(false);
        o.addOption(this.engine);
        OptionGroup inputGroup = new OptionGroup();
        this.list = new Option("l", "list", false, "list available script engines");
        inputGroup.addOption(this.list);
        this.script = new Option("s", "script", true, "use inline script");
        this.script.setArgName("script text");
        this.script.setArgs(1);
        this.script.setRequired(false);
        inputGroup.addOption(this.script);
        this.file = new Option("f", "file", true, "use script file");
        this.file.setArgName("fileName");
        this.file.setArgs(1);
        this.file.setRequired(false);
        inputGroup.addOption(this.file);
        inputGroup.setRequired(true);
        o.addOptionGroup(inputGroup);
        OptionGroup invokeGroup = new OptionGroup();
        this.object = new Option("obj", "object", true, "name of object");
        this.object.setArgs(1);
        this.object.setArgName("objectName:methodName");
        this.object.setRequired(false);
        invokeGroup.addOption(this.object);
        this.function = new Option("fx", "function", true, "invoke a script function");
        this.function.setArgName("functionName");
        this.function.setArgs(1);
        this.function.setRequired(false);
        invokeGroup.addOption(this.function);
        invokeGroup.setRequired(false);
        o.addOptionGroup(invokeGroup);
        this.args = new Option("a", "args", true, "comma separated list of key=value arguments");
        this.args.setArgName("property1=value1,propert2=value2,...");
        this.args.setArgs(-2);
        this.args.setRequired(false);
        o.addOption(this.args);
        this.out = new Option("o", "output", true, "output file");
        this.out.setArgName("fileName");
        this.out.setArgs(1);
        this.out.setRequired(false);
        o.addOption(this.out);
        return o;
    }

    private void listJSREngineInfo(ScriptEngineManager mgr, Shell shellState) throws IOException {
        List<ScriptEngineFactory> factories = mgr.getEngineFactories();
        TreeSet<Object> lines = new TreeSet<Object>();
        for (ScriptEngineFactory factory : factories) {
            lines.add("ScriptEngineFactory Info");
            String engName = factory.getEngineName();
            String engVersion = factory.getEngineVersion();
            String langName = factory.getLanguageName();
            String langVersion = factory.getLanguageVersion();
            lines.add("\tScript Engine: " + engName + " (" + engVersion + ")");
            List<String> engNames = factory.getNames();
            for (String name : engNames) {
                lines.add("\tEngine Alias: " + name);
            }
            lines.add("\tLanguage: " + langName + " (" + langVersion + ")");
        }
        shellState.printLines(lines.iterator(), true);
    }

    private void invokeFunctionOrMethod(Shell shellState, ScriptEngine engine, CommandLine cl, Object[] args) {
        try {
            Invocable inv = (Invocable)((Object)engine);
            if (cl.hasOption(this.function.getOpt())) {
                inv.invokeFunction(cl.getOptionValue(this.function.getOpt()), args);
            } else if (cl.hasOption(this.object.getOpt())) {
                String objectMethod = cl.getOptionValue(this.object.getOpt());
                String[] parts = objectMethod.split(":");
                if (parts.length != 2) {
                    shellState.printException(new Exception("Object and Method must be supplied"));
                    return;
                }
                String objectName = parts[0];
                String methodName = parts[1];
                Object obj = engine.get(objectName);
                inv.invokeMethod(obj, methodName, args);
            }
        }
        catch (Exception e) {
            shellState.printException(e);
        }
    }
}

