/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.shell.Shell;

public class QuotedStringTokenizer
implements Iterable<String> {
    private ArrayList<String> tokens = new ArrayList();
    private String input;

    public QuotedStringTokenizer(String t) throws BadArgumentException {
        this.input = t;
        try {
            this.createTokens();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String[] getTokens() {
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    private void createTokens() throws BadArgumentException, UnsupportedEncodingException {
        boolean inQuote = false;
        boolean inValue = false;
        boolean inEscapeSequence = false;
        Object hexChars = null;
        char inQuoteChar = '\"';
        byte[] token = new byte[this.input.length()];
        int tokenLength = 0;
        byte[] inputBytes = this.input.getBytes(StandardCharsets.UTF_8);
        block16: for (int i = 0; i < this.input.length(); ++i) {
            char ch = this.input.charAt(i);
            if (inEscapeSequence) {
                inEscapeSequence = false;
                switch (ch) {
                    case 'x': {
                        hexChars = "";
                        continue block16;
                    }
                    case ' ': 
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        token[tokenLength++] = inputBytes[i];
                        continue block16;
                    }
                    default: {
                        throw new BadArgumentException("can only escape single quotes, double quotes, the space character, the backslash, and hex input", this.input, i);
                    }
                }
            }
            if (hexChars != null) {
                byte b;
                int digit = Character.digit(ch, 16);
                if (digit < 0) {
                    throw new BadArgumentException("expected hex character", this.input, i);
                }
                if (((String)(hexChars = (String)hexChars + ch)).length() != 2) continue;
                try {
                    b = (byte)(0xFF & Short.parseShort((String)hexChars, 16));
                    if (!Character.isValidCodePoint(0xFF & b)) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new BadArgumentException("unsupported non-ascii character", this.input, i);
                }
                token[tokenLength++] = b;
                hexChars = null;
                continue;
            }
            if (inQuote) {
                if (ch == inQuoteChar) {
                    inQuote = false;
                    this.tokens.add(new String(token, 0, tokenLength, Shell.CHARSET));
                    tokenLength = 0;
                    continue;
                }
                if (ch == '\\') {
                    inEscapeSequence = true;
                    continue;
                }
                token[tokenLength++] = inputBytes[i];
                continue;
            }
            if (inValue) {
                switch (ch) {
                    case '\\': {
                        inEscapeSequence = true;
                        break;
                    }
                    case ' ': {
                        inValue = false;
                        this.tokens.add(new String(token, 0, tokenLength, Shell.CHARSET));
                        tokenLength = 0;
                        break;
                    }
                    default: {
                        token[tokenLength++] = inputBytes[i];
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '=': {
                    inValue = true;
                    token[tokenLength++] = inputBytes[i];
                    continue block16;
                }
                case '\"': 
                case '\'': {
                    if (tokenLength > 0) {
                        this.tokens.add(new String(token, 0, tokenLength, Shell.CHARSET));
                        tokenLength = 0;
                    }
                    inQuote = true;
                    inQuoteChar = ch;
                    continue block16;
                }
                case ' ': {
                    if (tokenLength <= 0) continue block16;
                    this.tokens.add(new String(token, 0, tokenLength, Shell.CHARSET));
                    tokenLength = 0;
                    continue block16;
                }
                case '\\': {
                    inEscapeSequence = true;
                    continue block16;
                }
                default: {
                    token[tokenLength++] = inputBytes[i];
                }
            }
        }
        if (inQuote) {
            throw new BadArgumentException("missing terminating quote", this.input, this.input.length());
        }
        if (inEscapeSequence || hexChars != null) {
            throw new BadArgumentException("escape sequence not complete", this.input, this.input.length());
        }
        if (tokenLength > 0) {
            this.tokens.add(new String(token, 0, tokenLength, Shell.CHARSET));
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.tokens.iterator();
    }
}

