/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.util.Timer;
import org.apache.accumulo.server.rpc.TServerUtils;

public class Session {
    public final String client;
    public long lastAccessTime;
    public long startTime;
    private State state = State.NEW;
    boolean allowReservation = true;
    private final Timer stateChangeTimer = Timer.startNew();
    private final TCredentials credentials;

    Session(TCredentials credentials) {
        this.credentials = credentials;
        this.client = (String)TServerUtils.clientAddress.get();
    }

    public String getUser() {
        return this.credentials.getPrincipal();
    }

    public TCredentials getCredentials() {
        return this.credentials;
    }

    public boolean cleanup() {
        return true;
    }

    public void setState(State state) {
        if (this.state != state) {
            this.state = state;
            this.stateChangeTimer.restart();
        }
    }

    public State getState() {
        return this.state;
    }

    public long elaspedSinceStateChange(TimeUnit unit) {
        return this.stateChangeTimer.elapsed(unit);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + String.valueOf((Object)this.state) + " startTime:" + this.startTime + " lastAccessTime:" + this.lastAccessTime + " client:" + this.client;
    }

    static enum State {
        NEW,
        UNRESERVED,
        RESERVED,
        REMOVED;

    }
}

