/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public abstract class SynchronizedServerFilter
implements SortedKeyValueIterator<Key, Value> {
    protected final SortedKeyValueIterator<Key, Value> source;

    public SynchronizedServerFilter(SortedKeyValueIterator<Key, Value> source) {
        this.source = source;
    }

    @Override
    public abstract SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment var1);

    @Override
    public synchronized void next() throws IOException {
        this.source.next();
        this.findTop();
    }

    @Override
    public synchronized void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.findTop();
    }

    @Override
    public synchronized Key getTopKey() {
        return this.source.getTopKey();
    }

    @Override
    public synchronized Value getTopValue() {
        return this.source.getTopValue();
    }

    @Override
    public synchronized boolean hasTop() {
        return this.source.hasTop();
    }

    private void findTop() throws IOException {
        Key top;
        while (this.source.hasTop() && !(top = this.source.getTopKey()).isDeleted() && !this.accept(top, this.source.getTopValue())) {
            this.source.next();
        }
    }

    protected abstract boolean accept(Key var1, Value var2);

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }
}

