/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.cache.impl.ClassSize;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.MultiLevelIndex;
import org.apache.accumulo.core.file.rfile.RelativeKey;
import org.apache.accumulo.core.spi.cache.CacheEntry;

public class BlockIndex
implements CacheEntry.Weighable {
    private final AtomicInteger accessCount = new AtomicInteger(0);
    private volatile BlockIndexEntry[] blockIndex = null;

    private BlockIndex() {
    }

    public static BlockIndex getIndex(CachableBlockFile.CachedBlockRead cacheBlock, MultiLevelIndex.IndexEntry indexEntry) throws IOException {
        BlockIndex blockIndex = cacheBlock.getIndex(BlockIndex::new);
        if (blockIndex == null) {
            return null;
        }
        int accessCount = blockIndex.accessCount.incrementAndGet();
        if (accessCount >= 2 && BlockIndex.isPowerOfTwo(accessCount)) {
            blockIndex.buildIndex(accessCount, cacheBlock, indexEntry);
            cacheBlock.indexWeightChanged();
        }
        if (blockIndex.blockIndex != null) {
            return blockIndex;
        }
        return null;
    }

    private static boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public BlockIndexEntry seekBlock(Key startKey, CachableBlockFile.CachedBlockRead cacheBlock) {
        int index;
        Object[] blockIndex = this.blockIndex;
        int pos = Arrays.binarySearch(blockIndex, new BlockIndexEntry(startKey));
        if (pos < 0) {
            if (pos == -1) {
                return null;
            }
            index = pos * -1 - 2;
        } else {
            for (index = pos; index > 0 && ((BlockIndexEntry)blockIndex[index]).getPrevKey().equals(startKey); --index) {
            }
        }
        while (index - 1 > 0 && ((BlockIndexEntry)blockIndex[index]).getPrevKey().equals(((BlockIndexEntry)blockIndex[index - 1]).getPrevKey())) {
            --index;
        }
        if (index == 0 && ((BlockIndexEntry)blockIndex[index]).getPrevKey().equals(startKey)) {
            return null;
        }
        Object bie = blockIndex[index];
        cacheBlock.seek(((BlockIndexEntry)bie).pos);
        return bie;
    }

    private synchronized void buildIndex(int indexEntries, CachableBlockFile.CachedBlockRead cacheBlock, MultiLevelIndex.IndexEntry indexEntry) throws IOException {
        cacheBlock.seek(0);
        RelativeKey rk = new RelativeKey();
        Value val = new Value();
        int interval = indexEntry.getNumEntries() / indexEntries;
        if (interval <= 32) {
            return;
        }
        if (this.blockIndex != null && this.blockIndex.length > indexEntries - 1) {
            return;
        }
        ArrayList<BlockIndexEntry> index = new ArrayList<BlockIndexEntry>(indexEntries - 1);
        for (int count = 0; count < indexEntry.getNumEntries() - interval + 1; ++count) {
            Key myPrevKey = rk.getKey();
            int pos = cacheBlock.getPosition();
            rk.readFields(cacheBlock);
            val.readFields(cacheBlock);
            if (count <= 0 || count % interval != 0) continue;
            index.add(new BlockIndexEntry(pos, indexEntry.getNumEntries() - count, myPrevKey));
        }
        this.blockIndex = index.toArray(new BlockIndexEntry[index.size()]);
        cacheBlock.seek(0);
    }

    BlockIndexEntry[] getIndexEntries() {
        return this.blockIndex;
    }

    @Override
    public synchronized int weight() {
        int weight = 0;
        if (this.blockIndex != null) {
            for (BlockIndexEntry blockIndexEntry : this.blockIndex) {
                weight += blockIndexEntry.weight();
            }
        }
        return weight += ClassSize.ATOMIC_INTEGER + ClassSize.OBJECT + 2 * ClassSize.REFERENCE + ClassSize.ARRAY;
    }

    public static class BlockIndexEntry
    implements Comparable<BlockIndexEntry> {
        private final Key prevKey;
        private int entriesLeft;
        private int pos;

        public BlockIndexEntry(int pos, int entriesLeft, Key prevKey) {
            this.pos = pos;
            this.entriesLeft = entriesLeft;
            this.prevKey = prevKey;
        }

        public BlockIndexEntry(Key key) {
            this.prevKey = key;
        }

        public int getEntriesLeft() {
            return this.entriesLeft;
        }

        @Override
        public int compareTo(BlockIndexEntry o) {
            return this.prevKey.compareTo(o.prevKey);
        }

        public boolean equals(Object o) {
            if (o instanceof BlockIndexEntry) {
                return this.compareTo((BlockIndexEntry)o) == 0;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.prevKey) + " " + this.entriesLeft + " " + this.pos;
        }

        public Key getPrevKey() {
            return this.prevKey;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not designed");
        }

        int weight() {
            int keyWeight = ClassSize.align(this.prevKey.getSize()) + ClassSize.OBJECT + 8 + 4 * (ClassSize.ARRAY + ClassSize.REFERENCE);
            return 8 + ClassSize.REFERENCE + ClassSize.OBJECT + keyWeight;
        }
    }
}

