/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.util.HostAndPort;

public class ActiveCompactionImpl
extends ActiveCompaction {
    private final org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac;
    private final ClientContext context;
    private final HostAndPort hostport;
    private final ActiveCompaction.CompactionHost.Type type;

    ActiveCompactionImpl(ClientContext context, org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac, HostAndPort hostport, ActiveCompaction.CompactionHost.Type type) {
        this.tac = tac;
        this.context = context;
        this.hostport = hostport;
        this.type = type;
    }

    @Override
    public String getTable() throws TableNotFoundException {
        return this.context.getTableName(KeyExtent.fromThrift(this.tac.getExtent()).tableId());
    }

    @Override
    public TabletId getTablet() {
        return new TabletIdImpl(KeyExtent.fromThrift(this.tac.getExtent()));
    }

    @Override
    public long getAge() {
        return this.tac.getAge();
    }

    @Override
    public List<String> getInputFiles() {
        return this.tac.getInputFiles();
    }

    @Override
    public String getOutputFile() {
        return this.tac.getOutputFile();
    }

    @Override
    public ActiveCompaction.CompactionType getType() {
        return ActiveCompaction.CompactionType.valueOf(this.tac.getType().name());
    }

    @Override
    public ActiveCompaction.CompactionReason getReason() {
        return ActiveCompaction.CompactionReason.valueOf(this.tac.getReason().name());
    }

    @Override
    public String getLocalityGroup() {
        return this.tac.getLocalityGroup();
    }

    @Override
    public long getEntriesRead() {
        return this.tac.getEntriesRead();
    }

    @Override
    public long getEntriesWritten() {
        return this.tac.getEntriesWritten();
    }

    @Override
    public List<IteratorSetting> getIterators() {
        ArrayList<IteratorSetting> ret = new ArrayList<IteratorSetting>();
        for (IterInfo ii : this.tac.getSsiList()) {
            IteratorSetting settings = new IteratorSetting(ii.getPriority(), ii.getIterName(), ii.getClassName());
            Map<String, String> options = this.tac.getSsio().get(ii.getIterName());
            settings.addOptions(options);
            ret.add(settings);
        }
        return ret;
    }

    @Override
    public ActiveCompaction.CompactionHost getHost() {
        return new ActiveCompaction.CompactionHost(){

            @Override
            public ActiveCompaction.CompactionHost.Type getType() {
                return ActiveCompactionImpl.this.type;
            }

            @Override
            public String getAddress() {
                return ActiveCompactionImpl.this.hostport.getHost();
            }

            @Override
            public int getPort() {
                return ActiveCompactionImpl.this.hostport.getPort();
            }
        };
    }
}

