/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class WayPoint
extends WithAttributes
implements Comparable<WayPoint>,
TemplateEngineDataProvider,
ILatLon {
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    private final double lat;
    private final double lon;
    private double east = Double.NaN;
    private double north = Double.NaN;
    private Object eastNorthCacheKey;

    public WayPoint(WayPoint p) {
        this.attr = new LegacyMap();
        this.attr.putAll(p.attr);
        this.attr.put("time", p.getDate());
        this.lat = p.lat;
        this.lon = p.lon;
        this.east = p.east;
        this.north = p.north;
        this.eastNorthCacheKey = p.eastNorthCacheKey;
        this.customColoring = p.customColoring;
        this.drawLine = p.drawLine;
        this.dir = p.dir;
    }

    public WayPoint(LatLon ll) {
        this.attr = new LegacyMap();
        this.lat = ll.lat();
        this.lon = ll.lon();
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }

    public final LatLon getCoor() {
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public double lon() {
        return this.lon;
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public final EastNorth getEastNorth(Projecting projecting) {
        Object newCacheKey = projecting.getCacheKey();
        if (Double.isNaN(this.east) || Double.isNaN(this.north) || !Objects.equals(newCacheKey, this.eastNorthCacheKey)) {
            EastNorth en = projecting.latlon2eastNorth(this);
            this.east = en.east();
            this.north = en.north();
            this.eastNorthCacheKey = newCacheKey;
        }
        return new EastNorth(this.east, this.north);
    }

    public String toString() {
        return "WayPoint (" + (this.attr.containsKey("name") ? this.get("name") + ", " : "") + this.getCoor() + ", " + this.attr + ')';
    }

    public void setTime(Date time) {
        this.setTimeInMillis(time.getTime());
    }

    @Deprecated
    public void setTime() {
        this.setTimeFromAttribute();
    }

    public void setTime(long ts) {
        this.setTimeInMillis(ts * 1000L);
    }

    public void setTimeInMillis(long ts) {
        this.attr.put("time", new Date(ts));
    }

    @Deprecated
    public Date setTimeFromAttribute() {
        Logging.warn("WayPoint.setTimeFromAttribute() is deprecated, please fix calling code");
        return this.getDate();
    }

    @Override
    public int compareTo(WayPoint w) {
        return Long.compare(this.getTimeInMillis(), w.getTimeInMillis());
    }

    public double getTime() {
        return (double)this.getTimeInMillis() / 1000.0;
    }

    public long getTimeInMillis() {
        Date d = this.getDateImpl();
        return d == null ? 0L : d.getTime();
    }

    public boolean hasDate() {
        return this.attr.get("time") instanceof Date;
    }

    public Date getDate() {
        return DateUtils.cloneDate(this.getDateImpl());
    }

    private Date getDateImpl() {
        if (this.attr != null) {
            Object obj = this.attr.get("time");
            if (obj instanceof Date) {
                return (Date)obj;
            }
            if (obj == null) {
                Logging.info("Waypoint {0} value unset", "time");
            } else {
                Logging.warn("Unsupported waypoint {0} value: {1}", "time", obj);
            }
        }
        return null;
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (!special) {
            return this.get(name);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTemplateKeys() {
        return new ArrayList<String>(this.attr.keySet());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.getTimeInMillis();
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        WayPoint other = (WayPoint)obj;
        return Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(other.lat) && Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(other.lon) && this.getTimeInMillis() == other.getTimeInMillis();
    }

    private static class LegacyMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        LegacyMap() {
            super(0);
        }

        @Override
        public Object put(String key, Object value) {
            Object ret = null;
            if (!"time".equals(key) || value instanceof Date) {
                ret = super.put(key, value);
            } else if (value instanceof String) {
                ret = super.put("time", DateUtils.fromString((String)value));
                List<String> lastErrorAndWarnings = Logging.getLastErrorAndWarnings();
                if (!lastErrorAndWarnings.isEmpty() && !lastErrorAndWarnings.get(0).contains("calling WayPoint.put")) {
                    int n;
                    StackTraceElement[] e = Thread.currentThread().getStackTrace();
                    for (n = 1; n < e.length && "put".equals(e[n].getMethodName()); ++n) {
                    }
                    if (n < e.length) {
                        Logging.warn("{0}:{1} calling WayPoint.put(PT_TIME, ..) is deprecated. Use WayPoint.setTime(..) instead.", e[n].getClassName(), e[n].getMethodName());
                    }
                }
            }
            return ret;
        }
    }
}

