/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.time.Instant;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.Item;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public interface DateTimeGroupFunction
extends GroupFunction {

    public static class Earliest
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items != null && !items.isEmpty()) {
                Instant max = null;
                for (Item item : items) {
                    DateTimeType itemState = item.getStateAs(DateTimeType.class);
                    if (itemState == null || max != null && !max.isAfter(itemState.getInstant())) continue;
                    max = itemState.getInstant();
                }
                if (max != null) {
                    return new DateTimeType(max);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Latest
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items != null && !items.isEmpty()) {
                Instant max = null;
                for (Item item : items) {
                    DateTimeType itemState = item.getStateAs(DateTimeType.class);
                    if (itemState == null || max != null && !max.isBefore(itemState.getInstant())) continue;
                    max = itemState.getInstant();
                }
                if (max != null) {
                    return new DateTimeType(max);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }
}

