/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Arrays;
import java.util.List;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BooleanCommandLineOptionConfiguration;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

public class ParallelismBuildOptions
extends BuildOptionSet<ParallelismConfiguration> {
    private static List<BuildOption<ParallelismConfiguration>> options = Arrays.asList(new BuildOption[]{new ParallelOption(), new MaxWorkersOption()});

    public List<? extends BuildOption<? super ParallelismConfiguration>> getAllOptions() {
        return options;
    }

    public static class ParallelOption
    extends BooleanBuildOption<ParallelismConfiguration> {
        public static final String GRADLE_PROPERTY = "org.gradle.parallel";

        public ParallelOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)"parallel", (String)"Build projects in parallel. Gradle will attempt to determine the optimal number of executor threads to use.", (String)"Disables parallel execution to build projects.")});
        }

        public void applyTo(boolean value, ParallelismConfiguration settings, Origin origin) {
            settings.setParallelProjectExecutionEnabled(value);
        }
    }

    public static class MaxWorkersOption
    extends StringBuildOption<ParallelismConfiguration> {
        public static final String GRADLE_PROPERTY = "org.gradle.workers.max";
        public static final String LONG_OPTION = "max-workers";
        public static final String HINT = "must be a positive, non-zero, integer";

        public MaxWorkersOption() {
            super(GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Configure the number of concurrent workers Gradle is allowed to use.")});
        }

        public void applyTo(String value, ParallelismConfiguration settings, Origin origin) {
            try {
                int workerCount = Integer.parseInt(value);
                if (workerCount < 1) {
                    origin.handleInvalidValue(value, HINT);
                }
                settings.setMaxWorkerCount(workerCount);
            }
            catch (NumberFormatException e) {
                origin.handleInvalidValue(value, HINT);
            }
        }
    }
}

