/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ChangingValue;
import org.gradle.api.internal.provider.ChangingValueHandler;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public abstract class DefaultArtifactPublicationSet {
    private final DefaultArtifactProvider defaultArtifactProvider;

    @Inject
    public DefaultArtifactPublicationSet(ConfigurationContainer configurations, String aggregateArtifactsConfName) {
        this.defaultArtifactProvider = new DefaultArtifactProvider(configurations, aggregateArtifactsConfName);
        configurations.getByName(aggregateArtifactsConfName).getArtifacts().addAllLater((Provider)this.defaultArtifactProvider);
    }

    @Deprecated
    public void addCandidate(PublishArtifact artifact) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateInternalApi)DeprecationLogger.deprecateInternalApi((String)"DefaultArtifactPublicationSet.addCandidate(PublishArtifact)").withAdvice("Add the artifact as a direct dependency of the assemble task instead.")).willBeRemovedInGradle9().undocumented()).nagUser();
        this.addCandidateInternal(artifact);
    }

    public void addCandidateInternal(PublishArtifact artifact) {
        this.defaultArtifactProvider.addArtifact(artifact);
    }

    DefaultArtifactProvider getDefaultArtifactProvider() {
        return this.defaultArtifactProvider;
    }

    private static class DefaultArtifactProvider
    extends AbstractMinimalProvider<Set<PublishArtifact>>
    implements CollectionProviderInternal<PublishArtifact, Set<PublishArtifact>>,
    ChangingValue<Set<PublishArtifact>> {
        private final ConfigurationContainer configurations;
        private final String aggregateArtifactsConfName;
        private Set<PublishArtifact> defaultArtifacts;
        private Set<PublishArtifact> explicitArtifacts;
        private ImmutableSet<PublishArtifact> aggregateArtifacts;
        private final ChangingValueHandler<Set<PublishArtifact>> changingValue = new ChangingValueHandler();

        public DefaultArtifactProvider(ConfigurationContainer configurations, String aggregateArtifactsConfName) {
            this.configurations = configurations;
            this.aggregateArtifactsConfName = aggregateArtifactsConfName;
            configurations.configureEach(conf -> {
                if (!conf.getName().equals(aggregateArtifactsConfName)) {
                    conf.getArtifacts().configureEach(artifact -> this.reset());
                }
            });
        }

        void addArtifact(PublishArtifact artifact) {
            if (this.explicitArtifacts == null) {
                this.explicitArtifacts = new LinkedHashSet<PublishArtifact>();
            }
            if (this.explicitArtifacts.add(artifact)) {
                this.reset();
            }
        }

        private void reset() {
            if (this.defaultArtifacts != null) {
                this.aggregateArtifacts = null;
                LinkedHashSet<PublishArtifact> previousArtifacts = new LinkedHashSet<PublishArtifact>(this.defaultArtifacts);
                this.defaultArtifacts = null;
                this.changingValue.handle(previousArtifacts);
            }
        }

        public Class<? extends PublishArtifact> getElementType() {
            return PublishArtifact.class;
        }

        public int size() {
            if (this.explicitArtifacts == null) {
                return this.getAggregateConfigurationArtifacts().size();
            }
            return this.explicitArtifacts.size() + this.getAggregateConfigurationArtifacts().size();
        }

        @Nullable
        public Class<Set<PublishArtifact>> getType() {
            return null;
        }

        protected ValueSupplier.Value<Set<PublishArtifact>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            if (this.defaultArtifacts == null) {
                PublishArtifact currentDefault = null;
                LinkedHashSet<PublishArtifact> newDefaultArtifacts = new LinkedHashSet<PublishArtifact>();
                if (this.explicitArtifacts != null) {
                    for (PublishArtifact artifact : this.explicitArtifacts) {
                        currentDefault = DefaultArtifactProvider.processArtifact(artifact, currentDefault, newDefaultArtifacts);
                    }
                }
                for (PublishArtifact artifact : this.getAggregateConfigurationArtifacts()) {
                    currentDefault = DefaultArtifactProvider.processArtifact(artifact, currentDefault, newDefaultArtifacts);
                }
                this.defaultArtifacts = newDefaultArtifacts;
            }
            return ValueSupplier.Value.of(this.defaultArtifacts);
        }

        private ImmutableSet<PublishArtifact> getAggregateConfigurationArtifacts() {
            if (this.aggregateArtifacts == null) {
                this.aggregateArtifacts = (ImmutableSet)this.configurations.stream().filter(conf -> !conf.getName().equals(this.aggregateArtifactsConfName) && conf.isVisible()).flatMap(conf -> conf.getArtifacts().stream()).collect(ImmutableSet.toImmutableSet());
            }
            return this.aggregateArtifacts;
        }

        private static PublishArtifact processArtifact(PublishArtifact artifact, @Nullable PublishArtifact currentDefault, Set<PublishArtifact> defaultArtifacts) {
            String thisType = artifact.getType();
            if (currentDefault == null) {
                defaultArtifacts.add(artifact);
                return artifact;
            }
            String currentType = currentDefault.getType();
            if (thisType.equals("ear")) {
                defaultArtifacts.remove(currentDefault);
                defaultArtifacts.add(artifact);
                return artifact;
            }
            if (thisType.equals("war")) {
                if (currentType.equals("jar")) {
                    defaultArtifacts.remove(currentDefault);
                    defaultArtifacts.add(artifact);
                    return artifact;
                }
            } else if (!thisType.equals("jar")) {
                defaultArtifacts.add(artifact);
            }
            return currentDefault;
        }

        public void onValueChange(Action<Set<PublishArtifact>> action) {
            this.changingValue.onValueChange(action);
        }
    }
}

