#   This is an implementation of PKWARE format decompression for vanilla
# Arx Fatalis models. It is not suitable for use as a general-purpose PKWARE
# decompressor, because it does not support decoding of literals. It has only
# enough functionality (and is only fast enough) for importing individual
# compressed FTLs shipped with the game.

def mk_length_dict():
    result = {}
    lengths = [
        [1,0,1],
        [1,1],
        [1,0,0],
        [0,1,1],
        [0,1,0,1],
        [0,1,0,0],
        [0,0,1,1],
        [0,0,1,0,1],
        [0,0,1,0,0,0],
        [0,0,1,0,0,1],
        [0,0,0,1,1,0,0],
        [0,0,0,1,1,1,0],
        [0,0,0,1,1,0,1],
        [0,0,0,1,1,1,1],
        [0,0,0,1,0,0,0,0],
        [0,0,0,1,0,1,0,0],
        [0,0,0,1,0,0,1,0],
        [0,0,0,1,0,1,1,0],
        [0,0,0,1,0,0,0,1],
        [0,0,0,1,0,1,0,1],
        [0,0,0,1,0,0,1,1],
        [0,0,0,1,0,1,1,1],
        [0,0,0,0,1,1,0,0,0,0],
        [0,0,0,0,1,1,1,0,0,0],
        [0,0,0,0,1,1,0,1,0,0],
        [0,0,0,0,1,1,1,1,0,0],
        [0,0,0,0,1,1,0,0,1,0],
        [0,0,0,0,1,1,1,0,1,0],
        [0,0,0,0,1,1,0,1,1,0],
        [0,0,0,0,1,1,1,1,1,0],
        [0,0,0,0,1,1,0,0,0,1],
        [0,0,0,0,1,1,1,0,0,1],
        [0,0,0,0,1,1,0,1,0,1],
        [0,0,0,0,1,1,1,1,0,1],
        [0,0,0,0,1,1,0,0,1,1],
        [0,0,0,0,1,1,1,0,1,1],
        [0,0,0,0,1,1,0,1,1,1],
        [0,0,0,0,1,1,1,1,1,1],
        [0,0,0,0,1,0,0,0,0,0,0],
        [0,0,0,0,1,0,1,0,0,0,0],
        [0,0,0,0,1,0,0,1,0,0,0],
        [0,0,0,0,1,0,1,1,0,0,0],
        [0,0,0,0,1,0,0,0,1,0,0],
        [0,0,0,0,1,0,1,0,1,0,0],
        [0,0,0,0,1,0,0,1,1,0,0],
        [0,0,0,0,1,0,1,1,1,0,0],
        [0,0,0,0,1,0,0,0,0,1,0],
        [0,0,0,0,1,0,1,0,0,1,0],
        [0,0,0,0,1,0,0,1,0,1,0],
        [0,0,0,0,1,0,1,1,0,1,0],
        [0,0,0,0,1,0,0,0,1,1,0],
        [0,0,0,0,1,0,1,0,1,1,0],
        [0,0,0,0,1,0,0,1,1,1,0],
        [0,0,0,0,1,0,1,1,1,1,0],
        [0,0,0,0,1,0,0,0,0,0,1],
        [0,0,0,0,1,0,1,0,0,0,1],
        [0,0,0,0,1,0,0,1,0,0,1],
        [0,0,0,0,1,0,1,1,0,0,1],
        [0,0,0,0,1,0,0,0,1,0,1],
        [0,0,0,0,1,0,1,0,1,0,1],
        [0,0,0,0,1,0,0,1,1,0,1],
        [0,0,0,0,1,0,1,1,1,0,1],
        [0,0,0,0,1,0,0,0,0,1,1],
        [0,0,0,0,1,0,1,0,0,1,1],
        [0,0,0,0,1,0,0,1,0,1,1],
        [0,0,0,0,1,0,1,1,0,1,1],
        [0,0,0,0,1,0,0,0,1,1,1],
        [0,0,0,0,1,0,1,0,1,1,1],
        [0,0,0,0,1,0,0,1,1,1,1],
        [0,0,0,0,1,0,1,1,1,1,1],
        [0,0,0,0,0,1,0,0,0,0,0,0],
        [0,0,0,0,0,1,1,0,0,0,0,0],
        [0,0,0,0,0,1,0,1,0,0,0,0],
        [0,0,0,0,0,1,1,1,0,0,0,0],
        [0,0,0,0,0,1,0,0,1,0,0,0],
        [0,0,0,0,0,1,1,0,1,0,0,0],
        [0,0,0,0,0,1,0,1,1,0,0,0],
        [0,0,0,0,0,1,1,1,1,0,0,0],
        [0,0,0,0,0,1,0,0,0,1,0,0],
        [0,0,0,0,0,1,1,0,0,1,0,0],
        [0,0,0,0,0,1,0,1,0,1,0,0],
        [0,0,0,0,0,1,1,1,0,1,0,0],
        [0,0,0,0,0,1,0,0,1,1,0,0],
        [0,0,0,0,0,1,1,0,1,1,0,0],
        [0,0,0,0,0,1,0,1,1,1,0,0],
        [0,0,0,0,0,1,1,1,1,1,0,0],
        [0,0,0,0,0,1,0,0,0,0,1,0],
        [0,0,0,0,0,1,1,0,0,0,1,0],
        [0,0,0,0,0,1,0,1,0,0,1,0],
        [0,0,0,0,0,1,1,1,0,0,1,0],
        [0,0,0,0,0,1,0,0,1,0,1,0],
        [0,0,0,0,0,1,1,0,1,0,1,0],
        [0,0,0,0,0,1,0,1,1,0,1,0],
        [0,0,0,0,0,1,1,1,1,0,1,0],
        [0,0,0,0,0,1,0,0,0,1,1,0],
        [0,0,0,0,0,1,1,0,0,1,1,0],
        [0,0,0,0,0,1,0,1,0,1,1,0],
        [0,0,0,0,0,1,1,1,0,1,1,0],
        [0,0,0,0,0,1,0,0,1,1,1,0],
        [0,0,0,0,0,1,1,0,1,1,1,0],
        [0,0,0,0,0,1,0,1,1,1,1,0],
        [0,0,0,0,0,1,1,1,1,1,1,0],
        [0,0,0,0,0,1,0,0,0,0,0,1],
        [0,0,0,0,0,1,1,0,0,0,0,1],
        [0,0,0,0,0,1,0,1,0,0,0,1],
        [0,0,0,0,0,1,1,1,0,0,0,1],
        [0,0,0,0,0,1,0,0,1,0,0,1],
        [0,0,0,0,0,1,1,0,1,0,0,1],
        [0,0,0,0,0,1,0,1,1,0,0,1],
        [0,0,0,0,0,1,1,1,1,0,0,1],
        [0,0,0,0,0,1,0,0,0,1,0,1],
        [0,0,0,0,0,1,1,0,0,1,0,1],
        [0,0,0,0,0,1,0,1,0,1,0,1],
        [0,0,0,0,0,1,1,1,0,1,0,1],
        [0,0,0,0,0,1,0,0,1,1,0,1],
        [0,0,0,0,0,1,1,0,1,1,0,1],
        [0,0,0,0,0,1,0,1,1,1,0,1],
        [0,0,0,0,0,1,1,1,1,1,0,1],
        [0,0,0,0,0,1,0,0,0,0,1,1],
        [0,0,0,0,0,1,1,0,0,0,1,1],
        [0,0,0,0,0,1,0,1,0,0,1,1],
        [0,0,0,0,0,1,1,1,0,0,1,1],
        [0,0,0,0,0,1,0,0,1,0,1,1],
        [0,0,0,0,0,1,1,0,1,0,1,1],
        [0,0,0,0,0,1,0,1,1,0,1,1],
        [0,0,0,0,0,1,1,1,1,0,1,1],
        [0,0,0,0,0,1,0,0,0,1,1,1],
        [0,0,0,0,0,1,1,0,0,1,1,1],
        [0,0,0,0,0,1,0,1,0,1,1,1],
        [0,0,0,0,0,1,1,1,0,1,1,1],
        [0,0,0,0,0,1,0,0,1,1,1,1],
        [0,0,0,0,0,1,1,0,1,1,1,1],
        [0,0,0,0,0,1,0,1,1,1,1,1],
        [0,0,0,0,0,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,1,0,0,0,0,0,0,0],
        [0,0,0,0,0,0,1,1,0,0,0,0,0,0],
        [0,0,0,0,0,0,1,0,1,0,0,0,0,0],
        [0,0,0,0,0,0,1,1,1,0,0,0,0,0],
        [0,0,0,0,0,0,1,0,0,1,0,0,0,0],
        [0,0,0,0,0,0,1,1,0,1,0,0,0,0],
        [0,0,0,0,0,0,1,0,1,1,0,0,0,0],
        [0,0,0,0,0,0,1,1,1,1,0,0,0,0],
        [0,0,0,0,0,0,1,0,0,0,1,0,0,0],
        [0,0,0,0,0,0,1,1,0,0,1,0,0,0],
        [0,0,0,0,0,0,1,0,1,0,1,0,0,0],
        [0,0,0,0,0,0,1,1,1,0,1,0,0,0],
        [0,0,0,0,0,0,1,0,0,1,1,0,0,0],
        [0,0,0,0,0,0,1,1,0,1,1,0,0,0],
        [0,0,0,0,0,0,1,0,1,1,1,0,0,0],
        [0,0,0,0,0,0,1,1,1,1,1,0,0,0],
        [0,0,0,0,0,0,1,0,0,0,0,1,0,0],
        [0,0,0,0,0,0,1,1,0,0,0,1,0,0],
        [0,0,0,0,0,0,1,0,1,0,0,1,0,0],
        [0,0,0,0,0,0,1,1,1,0,0,1,0,0],
        [0,0,0,0,0,0,1,0,0,1,0,1,0,0],
        [0,0,0,0,0,0,1,1,0,1,0,1,0,0],
        [0,0,0,0,0,0,1,0,1,1,0,1,0,0],
        [0,0,0,0,0,0,1,1,1,1,0,1,0,0],
        [0,0,0,0,0,0,1,0,0,0,1,1,0,0],
        [0,0,0,0,0,0,1,1,0,0,1,1,0,0],
        [0,0,0,0,0,0,1,0,1,0,1,1,0,0],
        [0,0,0,0,0,0,1,1,1,0,1,1,0,0],
        [0,0,0,0,0,0,1,0,0,1,1,1,0,0],
        [0,0,0,0,0,0,1,1,0,1,1,1,0,0],
        [0,0,0,0,0,0,1,0,1,1,1,1,0,0],
        [0,0,0,0,0,0,1,1,1,1,1,1,0,0],
        [0,0,0,0,0,0,1,0,0,0,0,0,1,0],
        [0,0,0,0,0,0,1,1,0,0,0,0,1,0],
        [0,0,0,0,0,0,1,0,1,0,0,0,1,0],
        [0,0,0,0,0,0,1,1,1,0,0,0,1,0],
        [0,0,0,0,0,0,1,0,0,1,0,0,1,0],
        [0,0,0,0,0,0,1,1,0,1,0,0,1,0],
        [0,0,0,0,0,0,1,0,1,1,0,0,1,0],
        [0,0,0,0,0,0,1,1,1,1,0,0,1,0],
        [0,0,0,0,0,0,1,0,0,0,1,0,1,0],
        [0,0,0,0,0,0,1,1,0,0,1,0,1,0],
        [0,0,0,0,0,0,1,0,1,0,1,0,1,0],
        [0,0,0,0,0,0,1,1,1,0,1,0,1,0],
        [0,0,0,0,0,0,1,0,0,1,1,0,1,0],
        [0,0,0,0,0,0,1,1,0,1,1,0,1,0],
        [0,0,0,0,0,0,1,0,1,1,1,0,1,0],
        [0,0,0,0,0,0,1,1,1,1,1,0,1,0],
        [0,0,0,0,0,0,1,0,0,0,0,1,1,0],
        [0,0,0,0,0,0,1,1,0,0,0,1,1,0],
        [0,0,0,0,0,0,1,0,1,0,0,1,1,0],
        [0,0,0,0,0,0,1,1,1,0,0,1,1,0],
        [0,0,0,0,0,0,1,0,0,1,0,1,1,0],
        [0,0,0,0,0,0,1,1,0,1,0,1,1,0],
        [0,0,0,0,0,0,1,0,1,1,0,1,1,0],
        [0,0,0,0,0,0,1,1,1,1,0,1,1,0],
        [0,0,0,0,0,0,1,0,0,0,1,1,1,0],
        [0,0,0,0,0,0,1,1,0,0,1,1,1,0],
        [0,0,0,0,0,0,1,0,1,0,1,1,1,0],
        [0,0,0,0,0,0,1,1,1,0,1,1,1,0],
        [0,0,0,0,0,0,1,0,0,1,1,1,1,0],
        [0,0,0,0,0,0,1,1,0,1,1,1,1,0],
        [0,0,0,0,0,0,1,0,1,1,1,1,1,0],
        [0,0,0,0,0,0,1,1,1,1,1,1,1,0],
        [0,0,0,0,0,0,1,0,0,0,0,0,0,1],
        [0,0,0,0,0,0,1,1,0,0,0,0,0,1],
        [0,0,0,0,0,0,1,0,1,0,0,0,0,1],
        [0,0,0,0,0,0,1,1,1,0,0,0,0,1],
        [0,0,0,0,0,0,1,0,0,1,0,0,0,1],
        [0,0,0,0,0,0,1,1,0,1,0,0,0,1],
        [0,0,0,0,0,0,1,0,1,1,0,0,0,1],
        [0,0,0,0,0,0,1,1,1,1,0,0,0,1],
        [0,0,0,0,0,0,1,0,0,0,1,0,0,1],
        [0,0,0,0,0,0,1,1,0,0,1,0,0,1],
        [0,0,0,0,0,0,1,0,1,0,1,0,0,1],
        [0,0,0,0,0,0,1,1,1,0,1,0,0,1],
        [0,0,0,0,0,0,1,0,0,1,1,0,0,1],
        [0,0,0,0,0,0,1,1,0,1,1,0,0,1],
        [0,0,0,0,0,0,1,0,1,1,1,0,0,1],
        [0,0,0,0,0,0,1,1,1,1,1,0,0,1],
        [0,0,0,0,0,0,1,0,0,0,0,1,0,1],
        [0,0,0,0,0,0,1,1,0,0,0,1,0,1],
        [0,0,0,0,0,0,1,0,1,0,0,1,0,1],
        [0,0,0,0,0,0,1,1,1,0,0,1,0,1],
        [0,0,0,0,0,0,1,0,0,1,0,1,0,1],
        [0,0,0,0,0,0,1,1,0,1,0,1,0,1],
        [0,0,0,0,0,0,1,0,1,1,0,1,0,1],
        [0,0,0,0,0,0,1,1,1,1,0,1,0,1],
        [0,0,0,0,0,0,1,0,0,0,1,1,0,1],
        [0,0,0,0,0,0,1,1,0,0,1,1,0,1],
        [0,0,0,0,0,0,1,0,1,0,1,1,0,1],
        [0,0,0,0,0,0,1,1,1,0,1,1,0,1],
        [0,0,0,0,0,0,1,0,0,1,1,1,0,1],
        [0,0,0,0,0,0,1,1,0,1,1,1,0,1],
        [0,0,0,0,0,0,1,0,1,1,1,1,0,1],
        [0,0,0,0,0,0,1,1,1,1,1,1,0,1],
        [0,0,0,0,0,0,1,0,0,0,0,0,1,1],
        [0,0,0,0,0,0,1,1,0,0,0,0,1,1],
        [0,0,0,0,0,0,1,0,1,0,0,0,1,1],
        [0,0,0,0,0,0,1,1,1,0,0,0,1,1],
        [0,0,0,0,0,0,1,0,0,1,0,0,1,1],
        [0,0,0,0,0,0,1,1,0,1,0,0,1,1],
        [0,0,0,0,0,0,1,0,1,1,0,0,1,1],
        [0,0,0,0,0,0,1,1,1,1,0,0,1,1],
        [0,0,0,0,0,0,1,0,0,0,1,0,1,1],
        [0,0,0,0,0,0,1,1,0,0,1,0,1,1],
        [0,0,0,0,0,0,1,0,1,0,1,0,1,1],
        [0,0,0,0,0,0,1,1,1,0,1,0,1,1],
        [0,0,0,0,0,0,1,0,0,1,1,0,1,1],
        [0,0,0,0,0,0,1,1,0,1,1,0,1,1],
        [0,0,0,0,0,0,1,0,1,1,1,0,1,1],
        [0,0,0,0,0,0,1,1,1,1,1,0,1,1],
        [0,0,0,0,0,0,1,0,0,0,0,1,1,1],
        [0,0,0,0,0,0,1,1,0,0,0,1,1,1],
        [0,0,0,0,0,0,1,0,1,0,0,1,1,1],
        [0,0,0,0,0,0,1,1,1,0,0,1,1,1],
        [0,0,0,0,0,0,1,0,0,1,0,1,1,1],
        [0,0,0,0,0,0,1,1,0,1,0,1,1,1],
        [0,0,0,0,0,0,1,0,1,1,0,1,1,1],
        [0,0,0,0,0,0,1,1,1,1,0,1,1,1],
        [0,0,0,0,0,0,1,0,0,0,1,1,1,1],
        [0,0,0,0,0,0,1,1,0,0,1,1,1,1],
        [0,0,0,0,0,0,1,0,1,0,1,1,1,1],
        [0,0,0,0,0,0,1,1,1,0,1,1,1,1],
        [0,0,0,0,0,0,1,0,0,1,1,1,1,1],
        [0,0,0,0,0,0,1,1,0,1,1,1,1,1],
        [0,0,0,0,0,0,1,0,1,1,1,1,1,1],
        [0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
        [0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],
        [0,0,0,0,0,0,0,1,1,0,0,0,0,0,0],
        [0,0,0,0,0,0,0,0,0,1,0,0,0,0,0],
        [0,0,0,0,0,0,0,1,0,1,0,0,0,0,0],
        [0,0,0,0,0,0,0,0,1,1,0,0,0,0,0],
        [0,0,0,0,0,0,0,1,1,1,0,0,0,0,0],
        [0,0,0,0,0,0,0,0,0,0,1,0,0,0,0],
        [0,0,0,0,0,0,0,1,0,0,1,0,0,0,0],
        [0,0,0,0,0,0,0,0,1,0,1,0,0,0,0],
        [0,0,0,0,0,0,0,1,1,0,1,0,0,0,0],
        [0,0,0,0,0,0,0,0,0,1,1,0,0,0,0],
        [0,0,0,0,0,0,0,1,0,1,1,0,0,0,0],
        [0,0,0,0,0,0,0,0,1,1,1,0,0,0,0],
        [0,0,0,0,0,0,0,1,1,1,1,0,0,0,0],
        [0,0,0,0,0,0,0,0,0,0,0,1,0,0,0],
        [0,0,0,0,0,0,0,1,0,0,0,1,0,0,0],
        [0,0,0,0,0,0,0,0,1,0,0,1,0,0,0],
        [0,0,0,0,0,0,0,1,1,0,0,1,0,0,0],
        [0,0,0,0,0,0,0,0,0,1,0,1,0,0,0],
        [0,0,0,0,0,0,0,1,0,1,0,1,0,0,0],
        [0,0,0,0,0,0,0,0,1,1,0,1,0,0,0],
        [0,0,0,0,0,0,0,1,1,1,0,1,0,0,0],
        [0,0,0,0,0,0,0,0,0,0,1,1,0,0,0],
        [0,0,0,0,0,0,0,1,0,0,1,1,0,0,0],
        [0,0,0,0,0,0,0,0,1,0,1,1,0,0,0],
        [0,0,0,0,0,0,0,1,1,0,1,1,0,0,0],
        [0,0,0,0,0,0,0,0,0,1,1,1,0,0,0],
        [0,0,0,0,0,0,0,1,0,1,1,1,0,0,0],
        [0,0,0,0,0,0,0,0,1,1,1,1,0,0,0],
        [0,0,0,0,0,0,0,1,1,1,1,1,0,0,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,1,0,0],
        [0,0,0,0,0,0,0,1,0,0,0,0,1,0,0],
        [0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],
        [0,0,0,0,0,0,0,1,1,0,0,0,1,0,0],
        [0,0,0,0,0,0,0,0,0,1,0,0,1,0,0],
        [0,0,0,0,0,0,0,1,0,1,0,0,1,0,0],
        [0,0,0,0,0,0,0,0,1,1,0,0,1,0,0],
        [0,0,0,0,0,0,0,1,1,1,0,0,1,0,0],
        [0,0,0,0,0,0,0,0,0,0,1,0,1,0,0],
        [0,0,0,0,0,0,0,1,0,0,1,0,1,0,0],
        [0,0,0,0,0,0,0,0,1,0,1,0,1,0,0],
        [0,0,0,0,0,0,0,1,1,0,1,0,1,0,0],
        [0,0,0,0,0,0,0,0,0,1,1,0,1,0,0],
        [0,0,0,0,0,0,0,1,0,1,1,0,1,0,0],
        [0,0,0,0,0,0,0,0,1,1,1,0,1,0,0],
        [0,0,0,0,0,0,0,1,1,1,1,0,1,0,0],
        [0,0,0,0,0,0,0,0,0,0,0,1,1,0,0],
        [0,0,0,0,0,0,0,1,0,0,0,1,1,0,0],
        [0,0,0,0,0,0,0,0,1,0,0,1,1,0,0],
        [0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
        [0,0,0,0,0,0,0,0,0,1,0,1,1,0,0],
        [0,0,0,0,0,0,0,1,0,1,0,1,1,0,0],
        [0,0,0,0,0,0,0,0,1,1,0,1,1,0,0],
        [0,0,0,0,0,0,0,1,1,1,0,1,1,0,0],
        [0,0,0,0,0,0,0,0,0,0,1,1,1,0,0],
        [0,0,0,0,0,0,0,1,0,0,1,1,1,0,0],
        [0,0,0,0,0,0,0,0,1,0,1,1,1,0,0],
        [0,0,0,0,0,0,0,1,1,0,1,1,1,0,0],
        [0,0,0,0,0,0,0,0,0,1,1,1,1,0,0],
        [0,0,0,0,0,0,0,1,0,1,1,1,1,0,0],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,0,0],
        [0,0,0,0,0,0,0,1,1,1,1,1,1,0,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,1,0],
        [0,0,0,0,0,0,0,1,0,0,0,0,0,1,0],
        [0,0,0,0,0,0,0,0,1,0,0,0,0,1,0],
        [0,0,0,0,0,0,0,1,1,0,0,0,0,1,0],
        [0,0,0,0,0,0,0,0,0,1,0,0,0,1,0],
        [0,0,0,0,0,0,0,1,0,1,0,0,0,1,0],
        [0,0,0,0,0,0,0,0,1,1,0,0,0,1,0],
        [0,0,0,0,0,0,0,1,1,1,0,0,0,1,0],
        [0,0,0,0,0,0,0,0,0,0,1,0,0,1,0],
        [0,0,0,0,0,0,0,1,0,0,1,0,0,1,0],
        [0,0,0,0,0,0,0,0,1,0,1,0,0,1,0],
        [0,0,0,0,0,0,0,1,1,0,1,0,0,1,0],
        [0,0,0,0,0,0,0,0,0,1,1,0,0,1,0],
        [0,0,0,0,0,0,0,1,0,1,1,0,0,1,0],
        [0,0,0,0,0,0,0,0,1,1,1,0,0,1,0],
        [0,0,0,0,0,0,0,1,1,1,1,0,0,1,0],
        [0,0,0,0,0,0,0,0,0,0,0,1,0,1,0],
        [0,0,0,0,0,0,0,1,0,0,0,1,0,1,0],
        [0,0,0,0,0,0,0,0,1,0,0,1,0,1,0],
        [0,0,0,0,0,0,0,1,1,0,0,1,0,1,0],
        [0,0,0,0,0,0,0,0,0,1,0,1,0,1,0],
        [0,0,0,0,0,0,0,1,0,1,0,1,0,1,0],
        [0,0,0,0,0,0,0,0,1,1,0,1,0,1,0],
        [0,0,0,0,0,0,0,1,1,1,0,1,0,1,0],
        [0,0,0,0,0,0,0,0,0,0,1,1,0,1,0],
        [0,0,0,0,0,0,0,1,0,0,1,1,0,1,0],
        [0,0,0,0,0,0,0,0,1,0,1,1,0,1,0],
        [0,0,0,0,0,0,0,1,1,0,1,1,0,1,0],
        [0,0,0,0,0,0,0,0,0,1,1,1,0,1,0],
        [0,0,0,0,0,0,0,1,0,1,1,1,0,1,0],
        [0,0,0,0,0,0,0,0,1,1,1,1,0,1,0],
        [0,0,0,0,0,0,0,1,1,1,1,1,0,1,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,1,1,0],
        [0,0,0,0,0,0,0,1,0,0,0,0,1,1,0],
        [0,0,0,0,0,0,0,0,1,0,0,0,1,1,0],
        [0,0,0,0,0,0,0,1,1,0,0,0,1,1,0],
        [0,0,0,0,0,0,0,0,0,1,0,0,1,1,0],
        [0,0,0,0,0,0,0,1,0,1,0,0,1,1,0],
        [0,0,0,0,0,0,0,0,1,1,0,0,1,1,0],
        [0,0,0,0,0,0,0,1,1,1,0,0,1,1,0],
        [0,0,0,0,0,0,0,0,0,0,1,0,1,1,0],
        [0,0,0,0,0,0,0,1,0,0,1,0,1,1,0],
        [0,0,0,0,0,0,0,0,1,0,1,0,1,1,0],
        [0,0,0,0,0,0,0,1,1,0,1,0,1,1,0],
        [0,0,0,0,0,0,0,0,0,1,1,0,1,1,0],
        [0,0,0,0,0,0,0,1,0,1,1,0,1,1,0],
        [0,0,0,0,0,0,0,0,1,1,1,0,1,1,0],
        [0,0,0,0,0,0,0,1,1,1,1,0,1,1,0],
        [0,0,0,0,0,0,0,0,0,0,0,1,1,1,0],
        [0,0,0,0,0,0,0,1,0,0,0,1,1,1,0],
        [0,0,0,0,0,0,0,0,1,0,0,1,1,1,0],
        [0,0,0,0,0,0,0,1,1,0,0,1,1,1,0],
        [0,0,0,0,0,0,0,0,0,1,0,1,1,1,0],
        [0,0,0,0,0,0,0,1,0,1,0,1,1,1,0],
        [0,0,0,0,0,0,0,0,1,1,0,1,1,1,0],
        [0,0,0,0,0,0,0,1,1,1,0,1,1,1,0],
        [0,0,0,0,0,0,0,0,0,0,1,1,1,1,0],
        [0,0,0,0,0,0,0,1,0,0,1,1,1,1,0],
        [0,0,0,0,0,0,0,0,1,0,1,1,1,1,0],
        [0,0,0,0,0,0,0,1,1,0,1,1,1,1,0],
        [0,0,0,0,0,0,0,0,0,1,1,1,1,1,0],
        [0,0,0,0,0,0,0,1,0,1,1,1,1,1,0],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,0],
        [0,0,0,0,0,0,0,1,1,1,1,1,1,1,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
        [0,0,0,0,0,0,0,1,0,0,0,0,0,0,1],
        [0,0,0,0,0,0,0,0,1,0,0,0,0,0,1],
        [0,0,0,0,0,0,0,1,1,0,0,0,0,0,1],
        [0,0,0,0,0,0,0,0,0,1,0,0,0,0,1],
        [0,0,0,0,0,0,0,1,0,1,0,0,0,0,1],
        [0,0,0,0,0,0,0,0,1,1,0,0,0,0,1],
        [0,0,0,0,0,0,0,1,1,1,0,0,0,0,1],
        [0,0,0,0,0,0,0,0,0,0,1,0,0,0,1],
        [0,0,0,0,0,0,0,1,0,0,1,0,0,0,1],
        [0,0,0,0,0,0,0,0,1,0,1,0,0,0,1],
        [0,0,0,0,0,0,0,1,1,0,1,0,0,0,1],
        [0,0,0,0,0,0,0,0,0,1,1,0,0,0,1],
        [0,0,0,0,0,0,0,1,0,1,1,0,0,0,1],
        [0,0,0,0,0,0,0,0,1,1,1,0,0,0,1],
        [0,0,0,0,0,0,0,1,1,1,1,0,0,0,1],
        [0,0,0,0,0,0,0,0,0,0,0,1,0,0,1],
        [0,0,0,0,0,0,0,1,0,0,0,1,0,0,1],
        [0,0,0,0,0,0,0,0,1,0,0,1,0,0,1],
        [0,0,0,0,0,0,0,1,1,0,0,1,0,0,1],
        [0,0,0,0,0,0,0,0,0,1,0,1,0,0,1],
        [0,0,0,0,0,0,0,1,0,1,0,1,0,0,1],
        [0,0,0,0,0,0,0,0,1,1,0,1,0,0,1],
        [0,0,0,0,0,0,0,1,1,1,0,1,0,0,1],
        [0,0,0,0,0,0,0,0,0,0,1,1,0,0,1],
        [0,0,0,0,0,0,0,1,0,0,1,1,0,0,1],
        [0,0,0,0,0,0,0,0,1,0,1,1,0,0,1],
        [0,0,0,0,0,0,0,1,1,0,1,1,0,0,1],
        [0,0,0,0,0,0,0,0,0,1,1,1,0,0,1],
        [0,0,0,0,0,0,0,1,0,1,1,1,0,0,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,0,0,1],
        [0,0,0,0,0,0,0,1,1,1,1,1,0,0,1],
        [0,0,0,0,0,0,0,0,0,0,0,0,1,0,1],
        [0,0,0,0,0,0,0,1,0,0,0,0,1,0,1],
        [0,0,0,0,0,0,0,0,1,0,0,0,1,0,1],
        [0,0,0,0,0,0,0,1,1,0,0,0,1,0,1],
        [0,0,0,0,0,0,0,0,0,1,0,0,1,0,1],
        [0,0,0,0,0,0,0,1,0,1,0,0,1,0,1],
        [0,0,0,0,0,0,0,0,1,1,0,0,1,0,1],
        [0,0,0,0,0,0,0,1,1,1,0,0,1,0,1],
        [0,0,0,0,0,0,0,0,0,0,1,0,1,0,1],
        [0,0,0,0,0,0,0,1,0,0,1,0,1,0,1],
        [0,0,0,0,0,0,0,0,1,0,1,0,1,0,1],
        [0,0,0,0,0,0,0,1,1,0,1,0,1,0,1],
        [0,0,0,0,0,0,0,0,0,1,1,0,1,0,1],
        [0,0,0,0,0,0,0,1,0,1,1,0,1,0,1],
        [0,0,0,0,0,0,0,0,1,1,1,0,1,0,1],
        [0,0,0,0,0,0,0,1,1,1,1,0,1,0,1],
        [0,0,0,0,0,0,0,0,0,0,0,1,1,0,1],
        [0,0,0,0,0,0,0,1,0,0,0,1,1,0,1],
        [0,0,0,0,0,0,0,0,1,0,0,1,1,0,1],
        [0,0,0,0,0,0,0,1,1,0,0,1,1,0,1],
        [0,0,0,0,0,0,0,0,0,1,0,1,1,0,1],
        [0,0,0,0,0,0,0,1,0,1,0,1,1,0,1],
        [0,0,0,0,0,0,0,0,1,1,0,1,1,0,1],
        [0,0,0,0,0,0,0,1,1,1,0,1,1,0,1],
        [0,0,0,0,0,0,0,0,0,0,1,1,1,0,1],
        [0,0,0,0,0,0,0,1,0,0,1,1,1,0,1],
        [0,0,0,0,0,0,0,0,1,0,1,1,1,0,1],
        [0,0,0,0,0,0,0,1,1,0,1,1,1,0,1],
        [0,0,0,0,0,0,0,0,0,1,1,1,1,0,1],
        [0,0,0,0,0,0,0,1,0,1,1,1,1,0,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,0,1],
        [0,0,0,0,0,0,0,1,1,1,1,1,1,0,1],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,1,1],
        [0,0,0,0,0,0,0,1,0,0,0,0,0,1,1],
        [0,0,0,0,0,0,0,0,1,0,0,0,0,1,1],
        [0,0,0,0,0,0,0,1,1,0,0,0,0,1,1],
        [0,0,0,0,0,0,0,0,0,1,0,0,0,1,1],
        [0,0,0,0,0,0,0,1,0,1,0,0,0,1,1],
        [0,0,0,0,0,0,0,0,1,1,0,0,0,1,1],
        [0,0,0,0,0,0,0,1,1,1,0,0,0,1,1],
        [0,0,0,0,0,0,0,0,0,0,1,0,0,1,1],
        [0,0,0,0,0,0,0,1,0,0,1,0,0,1,1],
        [0,0,0,0,0,0,0,0,1,0,1,0,0,1,1],
        [0,0,0,0,0,0,0,1,1,0,1,0,0,1,1],
        [0,0,0,0,0,0,0,0,0,1,1,0,0,1,1],
        [0,0,0,0,0,0,0,1,0,1,1,0,0,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,0,0,1,1],
        [0,0,0,0,0,0,0,1,1,1,1,0,0,1,1],
        [0,0,0,0,0,0,0,0,0,0,0,1,0,1,1],
        [0,0,0,0,0,0,0,1,0,0,0,1,0,1,1],
        [0,0,0,0,0,0,0,0,1,0,0,1,0,1,1],
        [0,0,0,0,0,0,0,1,1,0,0,1,0,1,1],
        [0,0,0,0,0,0,0,0,0,1,0,1,0,1,1],
        [0,0,0,0,0,0,0,1,0,1,0,1,0,1,1],
        [0,0,0,0,0,0,0,0,1,1,0,1,0,1,1],
        [0,0,0,0,0,0,0,1,1,1,0,1,0,1,1],
        [0,0,0,0,0,0,0,0,0,0,1,1,0,1,1],
        [0,0,0,0,0,0,0,1,0,0,1,1,0,1,1],
        [0,0,0,0,0,0,0,0,1,0,1,1,0,1,1],
        [0,0,0,0,0,0,0,1,1,0,1,1,0,1,1],
        [0,0,0,0,0,0,0,0,0,1,1,1,0,1,1],
        [0,0,0,0,0,0,0,1,0,1,1,1,0,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,0,1,1],
        [0,0,0,0,0,0,0,1,1,1,1,1,0,1,1],
        [0,0,0,0,0,0,0,0,0,0,0,0,1,1,1],
        [0,0,0,0,0,0,0,1,0,0,0,0,1,1,1],
        [0,0,0,0,0,0,0,0,1,0,0,0,1,1,1],
        [0,0,0,0,0,0,0,1,1,0,0,0,1,1,1],
        [0,0,0,0,0,0,0,0,0,1,0,0,1,1,1],
        [0,0,0,0,0,0,0,1,0,1,0,0,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,0,0,1,1,1],
        [0,0,0,0,0,0,0,1,1,1,0,0,1,1,1],
        [0,0,0,0,0,0,0,0,0,0,1,0,1,1,1],
        [0,0,0,0,0,0,0,1,0,0,1,0,1,1,1],
        [0,0,0,0,0,0,0,0,1,0,1,0,1,1,1],
        [0,0,0,0,0,0,0,1,1,0,1,0,1,1,1],
        [0,0,0,0,0,0,0,0,0,1,1,0,1,1,1],
        [0,0,0,0,0,0,0,1,0,1,1,0,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,0,1,1,1],
        [0,0,0,0,0,0,0,1,1,1,1,0,1,1,1],
        [0,0,0,0,0,0,0,0,0,0,0,1,1,1,1],
        [0,0,0,0,0,0,0,1,0,0,0,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,0,0,1,1,1,1],
        [0,0,0,0,0,0,0,1,1,0,0,1,1,1,1],
        [0,0,0,0,0,0,0,0,0,1,0,1,1,1,1],
        [0,0,0,0,0,0,0,1,0,1,0,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,0,1,1,1,1],
        [0,0,0,0,0,0,0,1,1,1,0,1,1,1,1],
        [0,0,0,0,0,0,0,0,0,0,1,1,1,1,1],
        [0,0,0,0,0,0,0,1,0,0,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,0,1,1,1,1,1],
        [0,0,0,0,0,0,0,1,1,0,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,1,0,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1]]
    for l, b in zip(lengths, range(2, 519)):
        result[bytes(l)] = b
    result[bytes([0,0,0,0,0,0,0,1,1,1,1,1,1,1,1])] = 0 # end marker
    return result

def mk_offset_dict():
    codes = [
        [1,1],
        [1,0,1,1],
        [1,0,1,0],
        [1,0,0,1,1],
        [1,0,0,1,0],
        [1,0,0,0,1],
        [1,0,0,0,0],
        [0,1,1,1,1,1],
        [0,1,1,1,1,0],
        [0,1,1,1,0,1],
        [0,1,1,1,0,0],
        [0,1,1,0,1,1],
        [0,1,1,0,1,0],
        [0,1,1,0,0,1],
        [0,1,1,0,0,0],
        [0,1,0,1,1,1],
        [0,1,0,1,1,0],
        [0,1,0,1,0,1],
        [0,1,0,1,0,0],
        [0,1,0,0,1,1],
        [0,1,0,0,1,0],
        [0,1,0,0,0,1],
        [0,1,0,0,0,0,1],
        [0,1,0,0,0,0,0],
        [0,0,1,1,1,1,1],
        [0,0,1,1,1,1,0],
        [0,0,1,1,1,0,1],
        [0,0,1,1,1,0,0],
        [0,0,1,1,0,1,1],
        [0,0,1,1,0,1,0],
        [0,0,1,1,0,0,1],
        [0,0,1,1,0,0,0],
        [0,0,1,0,1,1,1],
        [0,0,1,0,1,1,0],
        [0,0,1,0,1,0,1],
        [0,0,1,0,1,0,0],
        [0,0,1,0,0,1,1],
        [0,0,1,0,0,1,0],
        [0,0,1,0,0,0,1],
        [0,0,1,0,0,0,0],
        [0,0,0,1,1,1,1],
        [0,0,0,1,1,1,0],
        [0,0,0,1,1,0,1],
        [0,0,0,1,1,0,0],
        [0,0,0,1,0,1,1],
        [0,0,0,1,0,1,0],
        [0,0,0,1,0,0,1],
        [0,0,0,1,0,0,0],
        [0,0,0,0,1,1,1,1],
        [0,0,0,0,1,1,1,0],
        [0,0,0,0,1,1,0,1],
        [0,0,0,0,1,1,0,0],
        [0,0,0,0,1,0,1,1],
        [0,0,0,0,1,0,1,0],
        [0,0,0,0,1,0,0,1],
        [0,0,0,0,1,0,0,0],
        [0,0,0,0,0,1,1,1],
        [0,0,0,0,0,1,1,0],
        [0,0,0,0,0,1,0,1],
        [0,0,0,0,0,1,0,0],
        [0,0,0,0,0,0,1,1],
        [0,0,0,0,0,0,1,0],
        [0,0,0,0,0,0,0,1],
        [0,0,0,0,0,0,0,0]]
    return dict(zip(map(bytes, codes), range(len(codes))))

class BitStream(object):
    def __init__(self, bs, pos):
        self.bs    = bs
        self.pos   = pos
        self.byte  = bs[pos]
        self.shift = 0
        self.size   = len(bs)
    def pop(self):
        a = 2 ** self.shift
        res = ((a & self.byte) == a)
        self.shift = (self.shift + 1) % 8
        if not self.shift:
            self.pos = (self.pos + 1) % self.size
            self.byte = self.bs[self.pos]
        return res

def lookbehind(seq, pos, length):
    part = seq[-pos:]
    return (part * ((length // pos) + 1))[:length]
    
def decompress_ftl(bin):
    dict_size = bin[1]
    result = bytes()
    bs = BitStream(bin, 2)
    len_d = mk_length_dict()
    off_d = mk_offset_dict()
    while True:
        if bs.pop(): # length/offset pair follows
            key = bytes([bs.pop(),bs.pop()])
            while not (key in len_d):
                key += bytes([bs.pop()])
            length = len_d[key]
            if not length: # return value 0 means end of stream
                break
            shift = dict_size
            if length == 2:
                shift = 2
            key = bytes([bs.pop(),bs.pop()])
            while not (key in off_d):
                key += bytes([bs.pop()])
            part1 = off_d[key]
            part2 = 0
            for i in range(shift):
                part2 |= (bs.pop() << i)
            offset = (part1 << shift) + part2 + 1
            new = lookbehind(result, offset, length)
            result += new
        else: # literal follows; Arx uses only unencoded chars
            ch = 0
            for i in range(8):
                ch |= (bs.pop() << i)
            result += bytes([ch])
    return result
