/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.jps;

import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.jps.RunningVM;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

public class JpsProxy {
    public static RunningVM[] getRunningVMs() {
        String hostname = null;
        ArrayList<RunningVM> vret = new ArrayList<RunningVM>();
        try {
            HostIdentifier hostId = new HostIdentifier(hostname);
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(hostId);
            String selfName = ManagementFactory.getRuntimeMXBean().getName();
            Set<Integer> jvms = monitoredHost.activeVms();
            if (jvms.isEmpty()) {
                return null;
            }
            for (int lvmid : jvms) {
                if (selfName.startsWith(lvmid + "@")) continue;
                VmIdentifier id = null;
                MonitoredVm vm = null;
                String uriString = "//" + lvmid + "?mode=r";
                try {
                    id = new VmIdentifier(uriString);
                    vm = monitoredHost.getMonitoredVm(id, 0);
                }
                catch (URISyntaxException e) {
                    MiscUtils.printWarningMessage("in jvmps, detected malformed VM Identifier: " + uriString + "; ignored");
                    continue;
                }
                catch (MonitorException e) {
                    System.out.println("Ex " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    MiscUtils.printWarningMessage("in jvmps, for VM = " + String.valueOf(lvmid) + " got exception: " + e);
                    continue;
                }
                if (!JpsProxy.isAttachable(vm)) {
                    monitoredHost.detach(vm);
                    continue;
                }
                String cmdString = MonitoredVmUtil.commandLine(vm);
                String mainClass = MonitoredVmUtil.mainClass(vm, true);
                String mainArgs = MonitoredVmUtil.mainArgs(vm);
                String vmArgs = MonitoredVmUtil.jvmArgs(vm);
                String vmFlags = MonitoredVmUtil.jvmFlags(vm);
                monitoredHost.detach(vm);
                RunningVM rvm = new RunningVM(lvmid, vmFlags, vmArgs, mainClass, mainArgs);
                vret.add(rvm);
            }
        }
        catch (MonitorException e) {
            String report = "in jvmps, got MonitorException";
            if (e.getMessage() != null) {
                report = report + " with message + " + e.getMessage();
            }
            MiscUtils.printWarningMessage(report);
            return null;
        }
        catch (URISyntaxException e) {
            MiscUtils.printWarningMessage("in jvmps, got malformed Host Identifier: " + hostname);
            return null;
        }
        return vret.toArray(new RunningVM[0]);
    }

    private static boolean isAttachable(MonitoredVm vm) {
        try {
            return MonitoredVmUtil.isAttachable(vm);
        }
        catch (MonitorException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

