/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Collections;
import java.util.Map;
import org.jruby.DelegatedModule;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.RefinedMarker;
import org.jruby.runtime.builtin.IRubyObject;

public class PrependedModule
extends RubyClass
implements DelegatedModule {
    private RubyModule origin;

    public PrependedModule(Ruby runtime2, RubyClass superClass, RubyModule prependedClass) {
        super(runtime2, superClass, false);
        this.origin = prependedClass;
        this.metaClass = this.origin.metaClass;
        if (superClass != null) {
            this.setClassIndex(superClass.getClassIndex());
        }
        this.methods = prependedClass.methods;
        prependedClass.methods = Collections.EMPTY_MAP;
        prependedClass.methodLocation = this;
        for (Map.Entry entry : this.methods.entrySet()) {
            DynamicMethod method2 = (DynamicMethod)entry.getValue();
            if (!this.moveRefinedMethod((String)entry.getKey(), method2, prependedClass)) continue;
            this.methods.remove(entry.getKey());
        }
    }

    private boolean moveRefinedMethod(String key2, DynamicMethod method2, RubyModule klass) {
        if (method2.isRefined()) {
            if (method2 instanceof RefinedMarker) {
                klass.getMethodsForWrite().put(key2, method2);
                return true;
            }
            klass.getMethodsForWrite().put(key2, new RefinedMarker(klass, method2.getVisibility(), method2.getName()));
            return false;
        }
        return false;
    }

    @Override
    public boolean isPrepended() {
        return true;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public void setMetaClass(RubyClass newRubyClass) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public RubyModule getOrigin() {
        return this.origin;
    }

    @Override
    public RubyModule getDelegate() {
        return this.origin;
    }

    @Override
    @Deprecated
    public RubyModule getNonIncludedClass() {
        return this.origin;
    }

    @Override
    public IRubyObject id() {
        return this.origin.id();
    }

    @Override
    public void addMethod(String id2, DynamicMethod method2) {
        super.addMethod(id2, method2);
        method2.setDefinedClass(this.origin);
    }

    @Override
    protected synchronized Map<String, IRubyObject> getClassVariables() {
        return this.origin.getClassVariables();
    }

    @Override
    protected Map<String, IRubyObject> getClassVariablesForRead() {
        return this.origin.getClassVariablesForRead();
    }

    @Override
    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        return this.origin.constantTableStore(name2, value2);
    }

    @Override
    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden) {
        return this.origin.constantTableStore(name2, value2, hidden);
    }

    @Override
    protected RubyModule.ConstantEntry constantEntryFetch(String name2) {
        return this.origin.constantEntryFetch(name2);
    }

    @Override
    protected IRubyObject constantTableRemove(String name2) {
        return this.origin.constantTableRemove(name2);
    }

    @Override
    protected IRubyObject getAutoloadConstant(String name2, boolean forceLoad) {
        return this.origin.getAutoloadConstant(name2, forceLoad);
    }

    @Override
    protected Map<String, RubyModule.Autoload> getAutoloadMap() {
        return this.origin.getAutoloadMap();
    }

    @Override
    protected Map<String, RubyModule.Autoload> getAutoloadMapForWrite() {
        return this.origin.getAutoloadMapForWrite();
    }
}

