/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.start.TextFile;

public class StartIni
extends TextFile {
    private Path basedir;

    public StartIni(Path file) throws IOException {
        super(file);
    }

    @Override
    public void addUniqueLine(String line) {
        if (line.startsWith("--module=")) {
            int idx = line.indexOf(61);
            String value = line.substring(idx + 1);
            for (String part : value.split(",")) {
                super.addUniqueLine("--module=" + this.expandBaseDir(part));
            }
        } else {
            super.addUniqueLine(this.expandBaseDir(line));
        }
    }

    private String expandBaseDir(String line) {
        if (line == null) {
            return line;
        }
        return line.replace("${start.basedir}", this.basedir.toString());
    }

    @Override
    public void init() {
        try {
            this.basedir = this.getFile().getParent().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            this.basedir = this.getFile().getParent().normalize().toAbsolutePath();
        }
    }

    public Path getBaseDir() {
        return this.basedir;
    }
}

