package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariableSet;
import java.net.URL;

public interface ProcessContext extends ExprContext {
  void process(NodeIterator nodes, Name modeName,
	       Name[] paramNames, Variant[] paramValues, Result result) throws XSLException;
  void invoke(NodeIterator nodes, Action action, Result result) throws XSLException;
  Variant getParam(Name name) throws XSLException;
  void applyImports(Node node, Result result) throws XSLException;
  void bindLocalVariable(Name name, Variant variant) throws XSLException;
  void unbindLocalVariables(int n);
  void invokeWithParams(Action action, Name[] paramNames, Variant[] paramValues,
			Node node, Result result) throws XSLException;
  static interface Memento {
    void invoke(Action action, Node node, Result result) throws XSLException;
  }
  Memento createMemento();
  void useAttributeSet(Name name, Node node, Result result) throws XSLException;
  Name unaliasName(Name name);
  NamespacePrefixMap unaliasNamespacePrefixMap(NamespacePrefixMap map);
  void put(Object key, Object value);
  Object get(Object key);
  Result createNodeResult(Node baseNode, Node[] rootNodeRef) throws XSLException;
}
