package com.jclark.xsl.sax;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.*;

public class ServletDestination extends GenericDestination {
  private final ServletResponse response;

  public ServletDestination(ServletResponse response) {
    this.response = response;
  }

  public OutputStream getOutputStream(String contentType, String encoding)
    throws IOException {
    setEncoding(encoding);
    String lowerContentType = contentType.toLowerCase().trim();
    if (lowerContentType.startsWith("text")
	&& lowerContentType.indexOf("charset") < 0) {
      contentType = contentType + "; charset=" + getEncoding();
      response.setContentType(contentType);
      if (false) {
	// Disabled because getCharacterEncoding is broken in JSDK 2.1
	encoding = response.getCharacterEncoding();
	System.err.println("Set content-type to " + contentType + "; encoding was " + encoding);
	if (encoding != null)
	  setEncoding(encoding);
      }
    }
    else
      response.setContentType(contentType);
    return response.getOutputStream();
  }
}
