/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/graphics.h>
        #include <wx/image.h>
        #include <wx/graphics.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxGraphicsBitmap_ConvertToImage, "ConvertToImage() -> Image\n"
"\n"
"Return the contents of this bitmap as wxImage.");

extern "C" {static PyObject *meth_wxGraphicsBitmap_ConvertToImage(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsBitmap_ConvertToImage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGraphicsBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsBitmap, &sipCpp))
        {
            ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxImage(sipCpp->ConvertToImage());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxImage, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsBitmap, sipName_ConvertToImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsBitmap_GetNativeBitmap, "GetNativeBitmap() -> Any\n"
"\n"
"Return the pointer to the native bitmap data.");

extern "C" {static PyObject *meth_wxGraphicsBitmap_GetNativeBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsBitmap_GetNativeBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGraphicsBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsBitmap, &sipCpp))
        {
            void*sipRes;
        if (sipCpp->IsNull()) {
            wxPyErr_SetString(PyExc_ValueError, "The GraphicsBitmap is not valid (likely an uninitialized or null instance)");
            return NULL;
        }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNativeBitmap();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsBitmap, sipName_GetNativeBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxGraphicsBitmap(void *, const sipTypeDef *);}
static void *cast_wxGraphicsBitmap(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxGraphicsBitmap *sipCpp = reinterpret_cast<::wxGraphicsBitmap *>(sipCppV);

    if (targetType == sipType_wxGraphicsBitmap)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGraphicsObject)->ctd_cast(static_cast<::wxGraphicsObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGraphicsBitmap(void *, int);}
static void release_wxGraphicsBitmap(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxGraphicsBitmap *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxGraphicsBitmap(Py_ssize_t);}
static void *array_wxGraphicsBitmap(Py_ssize_t sipNrElem)
{
    return new ::wxGraphicsBitmap[sipNrElem];
}


extern "C" {static void array_delete_wxGraphicsBitmap(void *);}
static void array_delete_wxGraphicsBitmap(void *sipCpp)
{
    delete[] reinterpret_cast<::wxGraphicsBitmap *>(sipCpp);
}


extern "C" {static void assign_wxGraphicsBitmap(void *, Py_ssize_t, void *);}
static void assign_wxGraphicsBitmap(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxGraphicsBitmap *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxGraphicsBitmap *>(sipSrc);
}


extern "C" {static void *copy_wxGraphicsBitmap(const void *, Py_ssize_t);}
static void *copy_wxGraphicsBitmap(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxGraphicsBitmap(reinterpret_cast<const ::wxGraphicsBitmap *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGraphicsBitmap(sipSimpleWrapper *);}
static void dealloc_wxGraphicsBitmap(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGraphicsBitmap(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGraphicsBitmap(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGraphicsBitmap(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxGraphicsBitmap *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGraphicsBitmap();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxGraphicsBitmap* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxGraphicsBitmap, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGraphicsBitmap(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxGraphicsBitmap[] = {{246, 255, 1}};


static PyMethodDef methods_wxGraphicsBitmap[] = {
    {sipName_ConvertToImage, meth_wxGraphicsBitmap_ConvertToImage, METH_VARARGS, doc_wxGraphicsBitmap_ConvertToImage},
    {sipName_GetNativeBitmap, meth_wxGraphicsBitmap_GetNativeBitmap, METH_VARARGS, doc_wxGraphicsBitmap_GetNativeBitmap}
};

sipVariableDef variables_wxGraphicsBitmap[] = {
    {PropertyVariable, sipName_NativeBitmap, &methods_wxGraphicsBitmap[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxGraphicsBitmap, "GraphicsBitmap() -> None\n"
"\n"
"Represents a bitmap.");


sipClassTypeDef sipTypeDef__core_wxGraphicsBitmap = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxGraphicsBitmap,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_GraphicsBitmap,
        {0, 0, 1},
        2, methods_wxGraphicsBitmap,
        0, SIP_NULLPTR,
        1, variables_wxGraphicsBitmap,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGraphicsBitmap,
    -1,
    -1,
    supers_wxGraphicsBitmap,
    SIP_NULLPTR,
    init_type_wxGraphicsBitmap,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGraphicsBitmap,
    assign_wxGraphicsBitmap,
    array_wxGraphicsBitmap,
    copy_wxGraphicsBitmap,
    release_wxGraphicsBitmap,
    cast_wxGraphicsBitmap,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxGraphicsBitmap,
    sizeof (::wxGraphicsBitmap),
};
