package web

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ContainerAppsRevisionsClient is the webSite Management Client
type ContainerAppsRevisionsClient struct {
	BaseClient
}

// NewContainerAppsRevisionsClient creates an instance of the ContainerAppsRevisionsClient client.
func NewContainerAppsRevisionsClient(subscriptionID string) ContainerAppsRevisionsClient {
	return NewContainerAppsRevisionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewContainerAppsRevisionsClientWithBaseURI creates an instance of the ContainerAppsRevisionsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewContainerAppsRevisionsClientWithBaseURI(baseURI string, subscriptionID string) ContainerAppsRevisionsClient {
	return ContainerAppsRevisionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ActivateRevision sends the activate revision request.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// containerAppName - name of the Container App.
// name - name of the Container App Revision to activate
func (client ContainerAppsRevisionsClient) ActivateRevision(ctx context.Context, resourceGroupName string, containerAppName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerAppsRevisionsClient.ActivateRevision")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.ContainerAppsRevisionsClient", "ActivateRevision", err.Error())
	}

	req, err := client.ActivateRevisionPreparer(ctx, resourceGroupName, containerAppName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "ActivateRevision", nil, "Failure preparing request")
		return
	}

	resp, err := client.ActivateRevisionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "ActivateRevision", resp, "Failure sending request")
		return
	}

	result, err = client.ActivateRevisionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "ActivateRevision", resp, "Failure responding to request")
		return
	}

	return
}

// ActivateRevisionPreparer prepares the ActivateRevision request.
func (client ContainerAppsRevisionsClient) ActivateRevisionPreparer(ctx context.Context, resourceGroupName string, containerAppName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"containerAppName":  autorest.Encode("path", containerAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/containerApps/{containerAppName}/revisions/{name}/activate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ActivateRevisionSender sends the ActivateRevision request. The method will close the
// http.Response Body if it receives an error.
func (client ContainerAppsRevisionsClient) ActivateRevisionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ActivateRevisionResponder handles the response to the ActivateRevision request. The method always
// closes the http.Response Body.
func (client ContainerAppsRevisionsClient) ActivateRevisionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeactivateRevision sends the deactivate revision request.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// containerAppName - name of the Container App.
// name - name of the Container App Revision to deactivate
func (client ContainerAppsRevisionsClient) DeactivateRevision(ctx context.Context, resourceGroupName string, containerAppName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerAppsRevisionsClient.DeactivateRevision")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.ContainerAppsRevisionsClient", "DeactivateRevision", err.Error())
	}

	req, err := client.DeactivateRevisionPreparer(ctx, resourceGroupName, containerAppName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "DeactivateRevision", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeactivateRevisionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "DeactivateRevision", resp, "Failure sending request")
		return
	}

	result, err = client.DeactivateRevisionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "DeactivateRevision", resp, "Failure responding to request")
		return
	}

	return
}

// DeactivateRevisionPreparer prepares the DeactivateRevision request.
func (client ContainerAppsRevisionsClient) DeactivateRevisionPreparer(ctx context.Context, resourceGroupName string, containerAppName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"containerAppName":  autorest.Encode("path", containerAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/containerApps/{containerAppName}/revisions/{name}/deactivate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeactivateRevisionSender sends the DeactivateRevision request. The method will close the
// http.Response Body if it receives an error.
func (client ContainerAppsRevisionsClient) DeactivateRevisionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeactivateRevisionResponder handles the response to the DeactivateRevision request. The method always
// closes the http.Response Body.
func (client ContainerAppsRevisionsClient) DeactivateRevisionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetRevision sends the get revision request.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// containerAppName - name of the Container App.
// name - name of the Container App Revision.
func (client ContainerAppsRevisionsClient) GetRevision(ctx context.Context, resourceGroupName string, containerAppName string, name string) (result Revision, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerAppsRevisionsClient.GetRevision")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.ContainerAppsRevisionsClient", "GetRevision", err.Error())
	}

	req, err := client.GetRevisionPreparer(ctx, resourceGroupName, containerAppName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "GetRevision", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRevisionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "GetRevision", resp, "Failure sending request")
		return
	}

	result, err = client.GetRevisionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "GetRevision", resp, "Failure responding to request")
		return
	}

	return
}

// GetRevisionPreparer prepares the GetRevision request.
func (client ContainerAppsRevisionsClient) GetRevisionPreparer(ctx context.Context, resourceGroupName string, containerAppName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"containerAppName":  autorest.Encode("path", containerAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/containerApps/{containerAppName}/revisions/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRevisionSender sends the GetRevision request. The method will close the
// http.Response Body if it receives an error.
func (client ContainerAppsRevisionsClient) GetRevisionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetRevisionResponder handles the response to the GetRevision request. The method always
// closes the http.Response Body.
func (client ContainerAppsRevisionsClient) GetRevisionResponder(resp *http.Response) (result Revision, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRevisions sends the list revisions request.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// containerAppName - name of the Container App for which Revisions are needed.
func (client ContainerAppsRevisionsClient) ListRevisions(ctx context.Context, resourceGroupName string, containerAppName string) (result RevisionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerAppsRevisionsClient.ListRevisions")
		defer func() {
			sc := -1
			if result.rc.Response.Response != nil {
				sc = result.rc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.ContainerAppsRevisionsClient", "ListRevisions", err.Error())
	}

	result.fn = client.listRevisionsNextResults
	req, err := client.ListRevisionsPreparer(ctx, resourceGroupName, containerAppName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "ListRevisions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRevisionsSender(req)
	if err != nil {
		result.rc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "ListRevisions", resp, "Failure sending request")
		return
	}

	result.rc, err = client.ListRevisionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "ListRevisions", resp, "Failure responding to request")
		return
	}
	if result.rc.hasNextLink() && result.rc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListRevisionsPreparer prepares the ListRevisions request.
func (client ContainerAppsRevisionsClient) ListRevisionsPreparer(ctx context.Context, resourceGroupName string, containerAppName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"containerAppName":  autorest.Encode("path", containerAppName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/containerApps/{containerAppName}/revisions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRevisionsSender sends the ListRevisions request. The method will close the
// http.Response Body if it receives an error.
func (client ContainerAppsRevisionsClient) ListRevisionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListRevisionsResponder handles the response to the ListRevisions request. The method always
// closes the http.Response Body.
func (client ContainerAppsRevisionsClient) ListRevisionsResponder(resp *http.Response) (result RevisionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listRevisionsNextResults retrieves the next set of results, if any.
func (client ContainerAppsRevisionsClient) listRevisionsNextResults(ctx context.Context, lastResults RevisionCollection) (result RevisionCollection, err error) {
	req, err := lastResults.revisionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "listRevisionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListRevisionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "listRevisionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListRevisionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "listRevisionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListRevisionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ContainerAppsRevisionsClient) ListRevisionsComplete(ctx context.Context, resourceGroupName string, containerAppName string) (result RevisionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerAppsRevisionsClient.ListRevisions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListRevisions(ctx, resourceGroupName, containerAppName)
	return
}

// RestartRevision sends the restart revision request.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// containerAppName - name of the Container App.
// name - name of the Container App Revision to restart
func (client ContainerAppsRevisionsClient) RestartRevision(ctx context.Context, resourceGroupName string, containerAppName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerAppsRevisionsClient.RestartRevision")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.ContainerAppsRevisionsClient", "RestartRevision", err.Error())
	}

	req, err := client.RestartRevisionPreparer(ctx, resourceGroupName, containerAppName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "RestartRevision", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartRevisionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "RestartRevision", resp, "Failure sending request")
		return
	}

	result, err = client.RestartRevisionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ContainerAppsRevisionsClient", "RestartRevision", resp, "Failure responding to request")
		return
	}

	return
}

// RestartRevisionPreparer prepares the RestartRevision request.
func (client ContainerAppsRevisionsClient) RestartRevisionPreparer(ctx context.Context, resourceGroupName string, containerAppName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"containerAppName":  autorest.Encode("path", containerAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/containerApps/{containerAppName}/revisions/{name}/restart", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RestartRevisionSender sends the RestartRevision request. The method will close the
// http.Response Body if it receives an error.
func (client ContainerAppsRevisionsClient) RestartRevisionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RestartRevisionResponder handles the response to the RestartRevision request. The method always
// closes the http.Response Body.
func (client ContainerAppsRevisionsClient) RestartRevisionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
