package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// GovernanceAssignmentsClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type GovernanceAssignmentsClient struct {
	BaseClient
}

// NewGovernanceAssignmentsClient creates an instance of the GovernanceAssignmentsClient client.
func NewGovernanceAssignmentsClient(subscriptionID string) GovernanceAssignmentsClient {
	return NewGovernanceAssignmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewGovernanceAssignmentsClientWithBaseURI creates an instance of the GovernanceAssignmentsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewGovernanceAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) GovernanceAssignmentsClient {
	return GovernanceAssignmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or update a security GovernanceAssignment on the given subscription.
// Parameters:
// scope - scope of the query, can be subscription (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or
// management group (/providers/Microsoft.Management/managementGroups/mgName).
// assessmentName - the Assessment Key - Unique key for the assessment type
// assignmentKey - the security governance assignment key - the assessment key of the required governance
// assignment
// governanceAssignment - governanceAssignment over a subscription scope
func (client GovernanceAssignmentsClient) CreateOrUpdate(ctx context.Context, scope string, assessmentName string, assignmentKey string, governanceAssignment GovernanceAssignment) (result GovernanceAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceAssignmentsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: governanceAssignment,
			Constraints: []validation.Constraint{{Target: "governanceAssignment.GovernanceAssignmentProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "governanceAssignment.GovernanceAssignmentProperties.RemediationDueDate", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "governanceAssignment.GovernanceAssignmentProperties.RemediationEta", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "governanceAssignment.GovernanceAssignmentProperties.RemediationEta.Eta", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "governanceAssignment.GovernanceAssignmentProperties.RemediationEta.Justification", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "governanceAssignment.GovernanceAssignmentProperties.AdditionalData", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "governanceAssignment.GovernanceAssignmentProperties.AdditionalData.TicketNumber", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "governanceAssignment.GovernanceAssignmentProperties.AdditionalData.TicketNumber", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("security.GovernanceAssignmentsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, scope, assessmentName, assignmentKey, governanceAssignment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client GovernanceAssignmentsClient) CreateOrUpdatePreparer(ctx context.Context, scope string, assessmentName string, assignmentKey string, governanceAssignment GovernanceAssignment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"assessmentName": autorest.Encode("path", assessmentName),
		"assignmentKey":  autorest.Encode("path", assignmentKey),
		"scope":          scope,
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", pathParameters),
		autorest.WithJSON(governanceAssignment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client GovernanceAssignmentsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client GovernanceAssignmentsClient) CreateOrUpdateResponder(resp *http.Response) (result GovernanceAssignment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a GovernanceAssignment over a given scope
// Parameters:
// scope - scope of the query, can be subscription (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or
// management group (/providers/Microsoft.Management/managementGroups/mgName).
// assessmentName - the Assessment Key - Unique key for the assessment type
// assignmentKey - the security governance assignment key - the assessment key of the required governance
// assignment
func (client GovernanceAssignmentsClient) Delete(ctx context.Context, scope string, assessmentName string, assignmentKey string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceAssignmentsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, scope, assessmentName, assignmentKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client GovernanceAssignmentsClient) DeletePreparer(ctx context.Context, scope string, assessmentName string, assignmentKey string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"assessmentName": autorest.Encode("path", assessmentName),
		"assignmentKey":  autorest.Encode("path", assignmentKey),
		"scope":          scope,
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client GovernanceAssignmentsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client GovernanceAssignmentsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get a specific governanceAssignment for the requested scope by AssignmentKey
// Parameters:
// scope - scope of the query, can be subscription (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or
// management group (/providers/Microsoft.Management/managementGroups/mgName).
// assessmentName - the Assessment Key - Unique key for the assessment type
// assignmentKey - the security governance assignment key - the assessment key of the required governance
// assignment
func (client GovernanceAssignmentsClient) Get(ctx context.Context, scope string, assessmentName string, assignmentKey string) (result GovernanceAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceAssignmentsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, assessmentName, assignmentKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client GovernanceAssignmentsClient) GetPreparer(ctx context.Context, scope string, assessmentName string, assignmentKey string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"assessmentName": autorest.Encode("path", assessmentName),
		"assignmentKey":  autorest.Encode("path", assignmentKey),
		"scope":          scope,
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client GovernanceAssignmentsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client GovernanceAssignmentsClient) GetResponder(resp *http.Response) (result GovernanceAssignment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get security governanceAssignments on all your resources inside a scope
// Parameters:
// scope - scope of the query, can be subscription (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or
// management group (/providers/Microsoft.Management/managementGroups/mgName).
// assessmentName - the Assessment Key - Unique key for the assessment type
func (client GovernanceAssignmentsClient) List(ctx context.Context, scope string, assessmentName string) (result GovernanceAssignmentsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceAssignmentsClient.List")
		defer func() {
			sc := -1
			if result.gal.Response.Response != nil {
				sc = result.gal.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, scope, assessmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.gal.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "List", resp, "Failure sending request")
		return
	}

	result.gal, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.gal.hasNextLink() && result.gal.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client GovernanceAssignmentsClient) ListPreparer(ctx context.Context, scope string, assessmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"assessmentName": autorest.Encode("path", assessmentName),
		"scope":          scope,
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client GovernanceAssignmentsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client GovernanceAssignmentsClient) ListResponder(resp *http.Response) (result GovernanceAssignmentsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client GovernanceAssignmentsClient) listNextResults(ctx context.Context, lastResults GovernanceAssignmentsList) (result GovernanceAssignmentsList, err error) {
	req, err := lastResults.governanceAssignmentsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceAssignmentsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client GovernanceAssignmentsClient) ListComplete(ctx context.Context, scope string, assessmentName string) (result GovernanceAssignmentsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceAssignmentsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, scope, assessmentName)
	return
}
