
#ifdef HAVE_CONFIG_H
#include "../../../ext_config.h"
#endif

#include <php.h>
#include "../../../php_ext.h"
#include "../../../ext.h"

#include <Zend/zend_exceptions.h>

#include "kernel/main.h"


/**
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the LICENSE.txt
 * file that was distributed with this source code.
 */
/**
 * Phalcon\Mvc\Model\QueryInterface
 *
 * Interface for Phalcon\Mvc\Model\Query
 */
ZEPHIR_INIT_CLASS(Phalcon_Mvc_Model_QueryInterface) {

	ZEPHIR_REGISTER_INTERFACE(Phalcon\\Mvc\\Model, QueryInterface, phalcon, mvc_model_queryinterface, phalcon_mvc_model_queryinterface_method_entry);

	return SUCCESS;

}

/**
 * Sets the cache parameters of the query
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, cache);

/**
 * Executes a parsed PHQL statement
 *
 * @return mixed
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, execute);

/**
 * Returns default bind params
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, getBindParams);

/**
 * Returns the current cache options
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, getCacheOptions);

/**
 * Returns default bind types
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, getBindTypes);

/**
 * Returns the SQL to be generated by the internal PHQL (only works in SELECT statements)
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, getSql);

/**
 * Executes the query returning the first result
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, getSingleResult);

/**
 * Check if the query is programmed to get only the first row in the resultset
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, getUniqueRow);

/**
 * Parses the intermediate code produced by Phalcon\Mvc\Model\Query\Lang generating another
 * intermediate representation that could be executed by Phalcon\Mvc\Model\Query
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, parse);

/**
 * Set default bind parameters
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, setBindParams);

/**
 * Set default bind parameters
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, setBindTypes);

/**
 * Set SHARED LOCK clause
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, setSharedLock);

/**
 * Tells to the query if only the first row in the resultset must be returned
 */
ZEPHIR_DOC_METHOD(Phalcon_Mvc_Model_QueryInterface, setUniqueRow);

