
/**
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the LICENSE.txt
 * file that was distributed with this source code.
 */

#ifndef PHALCON_ANNOTATIONS_SCANNER_H
#define PHALCON_ANNOTATIONS_SCANNER_H

#define PHANNOT_SCANNER_RETCODE_EOF -1
#define PHANNOT_SCANNER_RETCODE_ERR -2
#define PHANNOT_SCANNER_RETCODE_IMPOSSIBLE -3

/** Modes */
#define PHANNOT_MODE_RAW 0
#define PHANNOT_MODE_ANNOTATION 1

#define PHANNOT_T_IGNORE 297

#define PHANNOT_T_DOCBLOCK_ANNOTATION 299
#define PHANNOT_T_ANNOTATION 300

/* Literals & Identifiers */
#define PHANNOT_T_INTEGER 301
#define PHANNOT_T_DOUBLE 302
#define PHANNOT_T_STRING 303
#define PHANNOT_T_NULL 304
#define PHANNOT_T_FALSE 305
#define PHANNOT_T_TRUE 306
#define PHANNOT_T_IDENTIFIER 307
#define PHANNOT_T_ARRAY 308
#define PHANNOT_T_ARBITRARY_TEXT 309

/* Operators */
#define PHANNOT_T_AT '@'
#define PHANNOT_T_DOT '.'
#define PHANNOT_T_COMMA ','
#define PHANNOT_T_EQUALS '='
#define PHANNOT_T_COLON ':'
#define PHANNOT_T_BRACKET_OPEN '{'
#define PHANNOT_T_BRACKET_CLOSE '}'
#define PHANNOT_T_SBRACKET_OPEN '['
#define PHANNOT_T_SBRACKET_CLOSE ']'
#define PHANNOT_T_PARENTHESES_OPEN '('
#define PHANNOT_T_PARENTHESES_CLOSE ')'

/* List of tokens and their names */
typedef struct _phannot_token_names {
	char *name;
	unsigned int code;
} phannot_token_names;

/* Active token state */
typedef struct _phannot_scanner_state {
	char* start;
	char* end;
	int active_token;
	unsigned int start_length;
	int mode;
	unsigned int active_line;
	const char *active_file;
} phannot_scanner_state;

/* Extra information tokens */
typedef struct _phannot_scanner_token {
	char *value;
	int opcode;
	int len;
} phannot_scanner_token;

int phannot_get_token(phannot_scanner_state *s, phannot_scanner_token *token);

extern const phannot_token_names phannot_tokens[];

#endif /* PHALCON_ANNOTATIONS_SCANNER_H */
