--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner:
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;

--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner:
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';

SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;

--
-- Name: customers; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS customers;
CREATE TABLE customers (
  id SERIAL,
  document_id integer NOT NULL,
  customer_id char(15) NOT NULL,
  first_name varchar(100) DEFAULT NULL,
  last_name varchar(100) DEFAULT NULL,
  phone varchar(20) DEFAULT NULL,
  email varchar(70) NOT NULL,
  instructions varchar(100) DEFAULT NULL,
  status CHAR(1) NOT NULL,
  birth_date date DEFAULT '1970-01-01',
  credit_line decimal(16,2) DEFAULT '0.00',
  created_at timestamp NOT NULL,
  created_at_user_id integer DEFAULT '0',
  PRIMARY KEY (id)
);

CREATE INDEX customers_document_id_idx ON customers (document_id);
CREATE INDEX customers_customer_id_idx ON customers (customer_id);
CREATE INDEX customers_credit_line_idx ON customers (credit_line);
CREATE INDEX customers_status_idx ON customers (status);

ALTER TABLE public.customers OWNER TO postgres;

--
-- Name: parts; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS parts CASCADE;
CREATE TABLE parts (
    id integer NOT NULL,
    name character varying(70) NOT NULL
);

ALTER TABLE public.parts OWNER TO postgres;

--
-- Name: images; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS images;
CREATE TABLE images (
  id BIGSERIAL,
  base64 TEXT
);

ALTER TABLE public.images OWNER TO postgres;

--
-- Name: personas; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS personas;
CREATE TABLE personas (
    cedula character(15) NOT NULL,
    tipo_documento_id integer NOT NULL,
    nombres character varying(100) DEFAULT ''::character varying NOT NULL,
    telefono character varying(20) DEFAULT NULL::character varying,
    direccion character varying(100) DEFAULT NULL::character varying,
    email character varying(50) DEFAULT NULL::character varying,
    fecha_nacimiento date DEFAULT '1970-01-01'::date,
    ciudad_id integer DEFAULT 0,
    creado_at date,
    cupo numeric(16,2) NOT NULL,
    estado character(1) NOT NULL
);

ALTER TABLE public.personas OWNER TO postgres;

--
-- Name: personnes; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS personnes;
CREATE TABLE personnes (
    cedula character(15) NOT NULL,
    tipo_documento_id integer NOT NULL,
    nombres character varying(100) DEFAULT ''::character varying NOT NULL,
    telefono character varying(20) DEFAULT NULL::character varying,
    direccion character varying(100) DEFAULT NULL::character varying,
    email character varying(50) DEFAULT NULL::character varying,
    fecha_nacimiento date DEFAULT '1970-01-01'::date,
    ciudad_id integer DEFAULT 0,
    creado_at date,
    cupo numeric(16,2) NOT NULL,
    estado character(1) NOT NULL
);

ALTER TABLE public.personnes OWNER TO postgres;

--
-- Name: prueba; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS prueba;
CREATE TABLE prueba (
    id integer NOT NULL,
    nombre character varying(120) NOT NULL,
    estado character(1) NOT NULL
);

ALTER TABLE public.prueba OWNER TO postgres;

--
-- Name: prueba_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

DROP SEQUENCE IF EXISTS prueba_id_seq;
CREATE SEQUENCE prueba_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE public.prueba_id_seq OWNER TO postgres;

--
-- Name: prueba_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE prueba_id_seq OWNED BY prueba.id;

--
-- Name: prueba_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('prueba_id_seq', 636, true);

--
-- Name: robots; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS robots CASCADE;
CREATE TABLE robots (
    id integer NOT NULL,
    name character varying(70) NOT NULL,
    type character varying(32) DEFAULT 'mechanical'::character varying NOT NULL,
    year integer DEFAULT 1900 NOT NULL,
    datetime timestamp NOT NULL,
    deleted timestamp DEFAULT NULL,
    text text NOT NULL
);

ALTER TABLE public.robots OWNER TO postgres;

--
-- Name: robots_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

DROP SEQUENCE IF EXISTS robots_id_seq;
CREATE SEQUENCE robots_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE public.robots_id_seq OWNER TO postgres;

--
-- Name: robots_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE robots_id_seq OWNED BY robots.id;

--
-- Name: robots_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('robots_id_seq', 1, false);

--
-- Name: robots_parts; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS robots_parts;
CREATE TABLE robots_parts (
    id integer NOT NULL,
    robots_id integer NOT NULL,
    parts_id integer NOT NULL
);

ALTER TABLE public.robots_parts OWNER TO postgres;

--
-- Name: robots_parts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

DROP SEQUENCE IF EXISTS robots_parts_id_seq;
CREATE SEQUENCE robots_parts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE public.robots_parts_id_seq OWNER TO postgres;

--
-- Name: robots_parts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE robots_parts_id_seq OWNED BY robots_parts.id;

--
-- Name: robots_parts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('robots_parts_id_seq', 1, false);

--
-- Name: subscriptores; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS subscriptores;
CREATE TABLE subscriptores (
    id integer NOT NULL,
    email character varying(70) NOT NULL,
    created_at timestamp without time zone,
    status character(1) NOT NULL
);

ALTER TABLE public.subscriptores OWNER TO postgres;

--
-- Name: subscriptores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

DROP SEQUENCE IF EXISTS subscriptores_id_seq;
CREATE SEQUENCE subscriptores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE public.subscriptores_id_seq OWNER TO postgres;

--
-- Name: subscriptores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE subscriptores_id_seq OWNED BY subscriptores.id;

--
-- Name: subscriptores_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('subscriptores_id_seq', 1, false);

--
-- Name: tipo_documento; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS tipo_documento;
CREATE TABLE tipo_documento (
    id integer NOT NULL,
    detalle character varying(32) NOT NULL
);

ALTER TABLE public.tipo_documento OWNER TO postgres;

--
-- Name: tipo_documento_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

DROP SEQUENCE IF EXISTS tipo_documento_id_seq;
CREATE SEQUENCE tipo_documento_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

--
-- Name: foreign_key_parent; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS foreign_key_parent;
CREATE TABLE foreign_key_parent (
    id SERIAL,
    name character varying(70) NOT NULL,
    refer_int integer NOT NULL,
    PRIMARY KEY (id),
    UNIQUE (refer_int)
);

ALTER TABLE public.foreign_key_parent OWNER TO postgres;

--
-- Name: ph_select; Type: TABLE TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS ph_select;
CREATE TABLE ph_select (
    sel_id SERIAL,
    sel_name character varying(16) NOT NULL,
    sel_text character varying(32) DEFAULT NULL,
    PRIMARY KEY (sel_id)
);

INSERT INTO ph_select (sel_id, sel_name, sel_text) VALUES
    (1, 'Sun', 'The one and only'),
    (2, 'Mercury', 'Cold and hot'),
    (3, 'Venus', 'Yeah baby she''s got it'),
    (4, 'Earth', 'Home'),
    (5, 'Mars', 'The God of War'),
    (6, 'Jupiter', NULL),
    (7, 'Saturn', 'A car'),
    (8, 'Uranus', 'Loads of jokes for this one');

ALTER TABLE public.ph_select OWNER TO postgres;

--
-- Name: foreign_key_child; Type: TABLE; Schema: public; Owner: postgres; Tablespace:
--

DROP TABLE IF EXISTS foreign_key_child;
CREATE TABLE foreign_key_child (
    id SERIAL,
    name character varying(70) NOT NULL,
    child_int integer NOT NULL,
    PRIMARY KEY (id),
    UNIQUE (child_int)
);

ALTER TABLE public.foreign_key_child OWNER TO postgres;
ALTER TABLE public.tipo_documento_id_seq OWNER TO postgres;

--
-- Name: tipo_documento_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tipo_documento_id_seq OWNED BY tipo_documento.id;

--
-- Name: tipo_documento_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tipo_documento_id_seq', 1, false);

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY prueba ALTER COLUMN id SET DEFAULT nextval('prueba_id_seq'::regclass);

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY robots ALTER COLUMN id SET DEFAULT nextval('robots_id_seq'::regclass);

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY robots_parts ALTER COLUMN id SET DEFAULT nextval('robots_parts_id_seq'::regclass);

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY subscriptores ALTER COLUMN id SET DEFAULT nextval('subscriptores_id_seq'::regclass);

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tipo_documento ALTER COLUMN id SET DEFAULT nextval('tipo_documento_id_seq'::regclass);

--
-- Data for Name: parts; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO parts (id, name) VALUES
    (1, 'Head'),
    (2, 'Body'),
    (3, 'Arms'),
    (4, 'Legs'),
    (5, 'CPU');

--
-- Data for Name: personas; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO personas (cedula, tipo_documento_id, nombres, telefono, direccion, email, fecha_nacimiento, ciudad_id, creado_at, cupo, estado) VALUES
    (1, 3, 'HUANG ZHENGQUIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-18', 6930.00, 'I'),
    (100, 1, 'USME FERNANDEZ JUAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-04-15', 439480.00, 'A'),
    (1003, 8, 'SINMON PEREZ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-25', 468610.00, 'A'),
    (1009, 8, 'ARCINIEGAS Y VILLAMIZAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-08-12', 967680.00, 'A'),
    (101, 1, 'CRANE DE NARVAEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-06-09', 790540.00, 'A'),
    (1011, 8, 'EL EVENTO', 191821112, 'CRA 25 CALLE 100', '596@terra.com.co', '2011-02-03', 127591, '2011-05-24', 820390.00, 'A'),
    (1020, 7, 'OSPINA YOLANDA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-02', 222970.00, 'A'),
    (1025, 7, 'CHEMIPLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-08', 918670.00, 'A'),
    (1034, 1, 'TAXI FILMS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-09-01', 962580.00, 'A'),
    (104, 1, 'CASTELLANOS JIMENEZ NOE', 191821112, 'CRA 25 CALLE 100', '127@yahoo.es', '2011-02-03', 127591, '2011-10-05', 95230.00, 'A'),
    (1046, 3, 'JACQUET PIERRE MICHEL ALAIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 263489, '2011-07-23', 90810.00, 'A'),
    (1048, 5, 'SPOERER VELEZ CARLOS JORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-02-03', 184920.00, 'A'),
    (1049, 3, 'SIDNEI DA SILVA LUIZ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117630, '2011-07-02', 850180.00, 'A'),
    (105, 1, 'HERRERA SEQUERA ALVARO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-26', 77390.00, 'A'),
    (1050, 3, 'CAVALCANTI YUE CARLA HANLI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-31', 696130.00, 'A'),
    (1052, 1, 'BARRETO RIVAS ELKIN MARTIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 131508, '2011-09-19', 562160.00, 'A'),
    (1053, 3, 'WANDERLEY ANTONIO ERNESTO THOME', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150617, '2011-01-31', 20490.00, 'A'),
    (1054, 3, 'HE SHAN', 191821112, 'CRA 25 CALLE 100', '715@yahoo.es', '2011-02-03', 132958, '2010-10-05', 415970.00, 'A'),
    (1055, 3, 'ZHRNG XIM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-05', 18380.00, 'A'),
    (1057, 3, 'NICKEL GEB. STUTZ KARIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-10-08', 164850.00, 'A'),
    (1058, 1, 'VELEZ PAREJA IGNACIO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132775, '2011-06-24', 292250.00, 'A'),
    (1059, 3, 'GURKE RALF ERNST', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 287570, '2011-06-15', 966700.00, 'A'),
    (106, 1, 'ESTRADA LONDONO JUAN SIMON', 191821112, 'CRA 25 CALLE 100', '8@terra.com.co', '2011-02-03', 128579, '2011-03-09', 101260.00, 'A'),
    (1060, 1, 'MEDRANO BARRIOS WILSON', 191821112, 'CRA 25 CALLE 100', '479@facebook.com', '2011-02-03', 132775, '2011-06-18', 956740.00, 'A'),
    (1061, 1, 'GERDTS PORTO HANS EDUARDO', 191821112, 'CRA 25 CALLE 100', '140@gmail.com', '2011-02-03', 127591, '2011-05-09', 883590.00, 'A'),
    (1062, 1, 'BORGE VISBAL JORGE FIDEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132775, '2011-07-14', 547750.00, 'A'),
    (1063, 3, 'GUTIERREZ JOSELYN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-06', 87960.00, 'A'),
    (1064, 4, 'OVIEDO PINZON MARYI YULEY', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127538, '2011-04-21', 796560.00, 'A'),
    (1065, 1, 'VILORA SILVA OMAR ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2010-06-09', 718910.00, 'A'),
    (1066, 3, 'AGUIAR ROMAN RODRIGO HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126674, '2011-06-28', 204890.00, 'A'),
    (1067, 1, 'GOMEZ AGAMEZ ADOLFO DEL CRISTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 131105, '2011-06-15', 867730.00, 'A'),
    (1068, 3, 'GARRIDO CECILIA', 191821112, 'CRA 25 CALLE 100', '973@yahoo.com.mx', '2011-02-03', 118777, '2010-08-16', 723980.00, 'A'),
    (1069, 1, 'JIMENEZ MANJARRES DAVID RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132775, '2010-12-17', 16680.00, 'A'),
    (107, 1, 'ARANGUREN TEJADA JORGE ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-16', 274110.00, 'A'),
    (1070, 3, 'OYARZUN TEJEDA ANDRES FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-26', 911490.00, 'A'),
    (1071, 3, 'MARIN BUCK RAFAEL ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126180, '2011-05-04', 507400.00, 'A'),
    (1072, 3, 'VARGAS JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126674, '2011-07-28', 802540.00, 'A'),
    (1073, 3, 'JUEZ JAIRALA JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126180, '2010-04-09', 490510.00, 'A'),
    (1074, 1, 'APONTE PENSO HERNAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132879, '2011-05-27', 44900.00, 'A'),
    (1075, 1, 'PINERES BUSTILLO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126916, '2008-10-29', 752980.00, 'A'),
    (1076, 1, 'OTERA OMA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-04-29', 630210.00, 'A'),
    (1077, 3, 'CONTRERAS CHINCHILLA JUAN DOMINGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 139844, '2011-06-21', 892110.00, 'A'),
    (1078, 1, 'GAMBA LAURENCIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-09-15', 569940.00, 'A'),
    (108, 1, 'MUNOZ ARANGO JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-01', 66770.00, 'A'),
    (1080, 1, 'PRADA ABAUZA CARLOS AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-11-15', 156870.00, 'A'),
    (1081, 1, 'PAOLA CAROLINA PINTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-27', 264350.00, 'A'),
    (1082, 1, 'PALOMINO HERNANDEZ GERMAN JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-03-22', 851120.00, 'A'),
    (1084, 1, 'URIBE DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '602@hotmail.es', '2011-02-03', 127591, '2011-09-07', 759470.00, 'A'),
    (1085, 1, 'ARGUELLO CALDERON ARMANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-24', 409660.00, 'A'),
    (1087, 1, 'CARVAJAL HERNANDEZ CHRISTIAN ARMANDO', 191821112, 'CRA 25 CALLE 100', '296@yahoo.es', '2011-02-03', 159432, '2011-06-03', 620410.00, 'A'),
    (1088, 1, 'CASTRO BLANCO MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150512, '2009-10-08', 792400.00, 'A'),
    (1089, 1, 'RIBEROS GUTIERREZ GUSTAVO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-01-27', 100800.00, 'A'),
    (109, 1, 'BELTRAN MARIA LUZ DARY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-06', 511510.00, 'A'),
    (1091, 4, 'ORTIZ ORTIZ BENIGNO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127538, '2011-08-05', 331540.00, 'A'),
    (1092, 3, 'JOHN CHRISTOPHER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-08', 277320.00, 'A'),
    (1093, 1, 'PARRA VILLAREAL MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 129499, '2011-08-23', 391980.00, 'A'),
    (1094, 1, 'BESGA RODRIGUEZ JUAN JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127300, '2011-09-23', 127960.00, 'A'),
    (1095, 1, 'ZAPATA MEZA EDGAR FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129499, '2011-05-19', 463840.00, 'A'),
    (1096, 3, 'CORNEJO BRAVO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2010-11-08', 935340.00, 'A'),
    ('CELL3944', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1099, 1, 'GARCIA PORRAS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-14', 243360.00, 'A'),
    (11, 1, 'HERNANDEZ PARDO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-31', 197540.00, 'A'),
    (110, 1, 'VANEGAS JULIAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-06', 357260.00, 'A'),
    (1101, 1, 'QUINTERO BURBANO GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129499, '2011-08-20', 57420.00, 'A'),
    (1102, 1, 'BOHORQUEZ AFANADOR CHRISTIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-19', 214610.00, 'A'),
    (1103, 1, 'MORA VARGAS JULIO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-29', 900790.00, 'A'),
    (1104, 1, 'PINEDA JORGE ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-21', 860110.00, 'A'),
    (1105, 1, 'TORO CEBALLOS GONZALO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 129499, '2011-08-18', 598180.00, 'A'),
    (1106, 1, 'SCHENIDER TORRES JAIME', 191821112, 'CRA 25 CALLE 100', '85@yahoo.com.mx', '2011-02-03', 127799, '2011-08-11', 410590.00, 'A'),
    (1107, 1, 'RUEDA VILLAMIZAR JAIME', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-11-15', 258410.00, 'A'),
    (1108, 1, 'RUEDA VILLAMIZAR RICARDO JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129499, '2011-03-22', 60260.00, 'A'),
    (1109, 1, 'GOMEZ RODRIGUEZ HERNANDO ARTURO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-06-02', 526080.00, 'A'),
    (111, 1, 'FRANCISCO EDUARDO JAIME BOTERO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-09-09', 251770.00, 'A'),
    (1110, 1, 'HERNANDEZ MENDEZ EDGAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 129499, '2011-03-22', 449610.00, 'A'),
    (1113, 1, 'LEON HERNANDEZ OSCAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129499, '2011-03-21', 992090.00, 'A'),
    (1114, 1, 'LIZARAZO CARRENO HUGO ARCENIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2010-12-10', 959490.00, 'A'),
    (1115, 1, 'LIAN BARRERA GABRIEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-05-30', 821170.00, 'A'),
    (1117, 3, 'TELLEZ BEZAN FRANCISCO JAVIER ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2011-08-21', 673430.00, 'A'),
    (1118, 1, 'FUENTES ARIZA DIEGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-09', 684970.00, 'A'),
    (1119, 1, 'MOLINA M. ROBINSON', 191821112, 'CRA 25 CALLE 100', '728@hotmail.com', '2011-02-03', 129447, '2010-09-19', 404580.00, 'A'),
    (112, 1, 'PATINO PINTO ARIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-06', 187050.00, 'A'),
    (1120, 1, 'ORTIZ DURAN BENIGNO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127538, '2011-08-05', 967970.00, 'A'),
    (1121, 1, 'CARVAJAL ALMEIDA LUIS RAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129499, '2011-06-22', 626140.00, 'A'),
    (1122, 1, 'TORRES QUIROGA EDWIN SILVESTRE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 129447, '2011-08-17', 226780.00, 'A'),
    (1123, 1, 'VIVIESCAS JAIMES ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-10', 255480.00, 'A'),
    (1124, 1, 'MARTINEZ RUEDA JAVIER EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129447, '2011-06-23', 597040.00, 'A'),
    (1125, 1, 'ANAYA FLORES JORGE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129499, '2011-06-04', 218790.00, 'A'),
    (1126, 3, 'TORRES MARTINEZ ANTONIO JESUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2010-09-02', 302820.00, 'A'),
    (1127, 3, 'CACHO LEVISIER JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 153276, '2009-06-25', 857720.00, 'A'),
    (1129, 3, 'ULLOA VALDIVIESO CRISTIAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-06-02', 327570.00, 'A'),
    (113, 1, 'HIGUERA CALA JAIME ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-27', 179950.00, 'A'),
    (1130, 1, 'ARCINIEGAS WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126892, '2011-08-05', 497420.00, 'A'),
    (1131, 1, 'BAZA ACUNA JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129447, '2010-12-10', 504410.00, 'A'),
    (1132, 3, 'BUIRA ROS CARLOS MARIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-04-27', 29750.00, 'A'),
    (1133, 1, 'RODRIGUEZ JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 129447, '2011-06-10', 635560.00, 'A'),
    (1134, 1, 'QUIROGA PEREZ NELSON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 129447, '2011-05-18', 88520.00, 'A'),
    (1135, 1, 'TATIANA AYALA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127122, '2011-07-01', 535920.00, 'A'),
    (1136, 1, 'OSORIO BENEDETTI FABIAN AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132775, '2010-10-23', 414060.00, 'A'),
    (1139, 1, 'CELIS PINTO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2009-02-25', 964970.00, 'A'),
    (114, 1, 'VALDERRAMA CUERVO JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-02', 338590.00, 'A'),
    (1140, 1, 'ORTIZ ARENAS JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129499, '2009-10-21', 613300.00, 'A'),
    (1141, 1, 'VALDIVIESO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 134022, '2009-01-13', 171590.00, 'A'),
    (1144, 1, 'LOPEZ CASTILLO NELSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 129499, '2010-09-09', 823110.00, 'A'),
    (1145, 1, 'CAVELIER LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126916, '2008-11-29', 389220.00, 'A'),
    (1146, 1, 'CAVELIER OTOYA LUIS EDURDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126916, '2010-05-25', 476770.00, 'A'),
    (1147, 1, 'GARCIA RUEDA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '111@yahoo.es', '2011-02-03', 133535, '2010-09-12', 216190.00, 'A'),
    (1148, 1, 'LADINO GOMEZ OMAR ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-02', 650640.00, 'A'),
    (1149, 1, 'CARRENO ORTIZ OSCAR JAVIER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-15', 604630.00, 'A'),
    (115, 1, 'NARDEI BONILLO BRUNO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-16', 153110.00, 'A'),
    (1150, 1, 'MONTOYA BOZZI MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 129499, '2011-05-12', 71240.00, 'A'),
    (1152, 1, 'LORA RICHARD JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-09-15', 497700.00, 'A'),
    (1153, 1, 'SILVA PINZON MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '915@hotmail.es', '2011-02-03', 127591, '2011-06-15', 861670.00, 'A'),
    (1154, 3, 'GEORGE J A KHALILIEH', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-20', 815260.00, 'A'),
    (1155, 3, 'CHACON MARIN CARLOS MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-07-26', 491280.00, 'A'),
    (1156, 3, 'OCHOA CHEHAB XAVIER ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 126180, '2011-06-13', 10630.00, 'A'),
    (1157, 3, 'ARAYA GARRI GABRIEL ALEXIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-09-19', 579320.00, 'A'),
    (1158, 3, 'MACCHI ARIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116366, '2010-04-12', 864690.00, 'A'),
    (116, 1, 'GONZALEZ FANDINO JAIME EDUARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-10', 749800.00, 'A'),
    (1160, 1, 'CAVALIER LUIS EDUARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126916, '2009-08-27', 333390.00, 'A'),
    ('CELL396', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1161, 3, 'DOMINGUEZ DE OBREGON ILEANA DEL CARMEN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 139844, '2011-03-06', 910490.00, 'A'),
    (1162, 2, 'FALASCA CLAUDIO ARIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116511, '2011-07-10', 552280.00, 'A'),
    (1163, 3, 'MUTABARUKA PATRICK', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131352, '2011-03-22', 29940.00, 'A'),
    (1164, 1, 'DOMINGUEZ ATENCIA JIMMY CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-07-22', 492860.00, 'A'),
    (1165, 4, 'LLANO GONZALEZ ALBERTO MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127300, '2010-08-21', 374490.00, 'A'),
    (1166, 3, 'LOPEZ ROLDAN JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-07-31', 393860.00, 'A'),
    (1167, 1, 'GUTIERREZ DE PINERES JALILIE ARISTIDES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2010-12-09', 845810.00, 'A'),
    (1168, 1, 'HEYMANS PIERRE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2010-11-08', 47470.00, 'A'),
    (1169, 1, 'BOTERO OSORIO RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2009-05-27', 699940.00, 'A'),
    (1170, 3, 'GARNHAM POBLETE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 116396, '2011-03-27', 357270.00, 'A'),
    (1172, 1, 'DAJUD DURAN JOSE RODRIGO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2009-12-02', 360910.00, 'A'),
    (1173, 1, 'MARTINEZ MERCADO PEDRO PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-07-25', 744930.00, 'A'),
    (1174, 1, 'GARCIA AMADOR ANDRES EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-05-19', 641930.00, 'A'),
    (1176, 1, 'VARGAS VARELA LUIS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 131568, '2011-08-30', 948410.00, 'A'),
    (1178, 1, 'GUTIERRES DE PINERES ARISTIDES', 191821112, 'CRA 25 CALLE 100', '217@hotmail.com', '2011-02-03', 133535, '2011-05-10', 242490.00, 'A'),
    (1179, 3, 'LEIZAOLA POZO JIMENA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132958, '2011-08-01', 759800.00, 'A'),
    (118, 1, 'FERNANDEZ VELOSO PEDRO HERNANDO', 191821112, 'CRA 25 CALLE 100', '452@hotmail.es', '2011-02-03', 128662, '2010-08-06', 198830.00, 'A'),
    (1180, 3, 'MARINO PAOLO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-12-24', 71520.00, 'A'),
    (1181, 1, 'MOLINA VIZCAINO GUSTAVO JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-04-28', 78220.00, 'A'),
    (1182, 3, 'MEDEL GARCIA FABIAN RODRIGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-04-25', 176540.00, 'A'),
    (1183, 1, 'LESMES ARIAS RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-09-09', 648020.00, 'A'),
    (1184, 1, 'ALCALA MARTINEZ ALFREDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132775, '2010-07-23', 710470.00, 'A'),
    (1186, 1, 'LLAMAS FOLIACO LUIS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-07', 910210.00, 'A'),
    (1187, 1, 'GUARDO DEL RIO LIBARDO FARID', 191821112, 'CRA 25 CALLE 100', '73@yahoo.com.mx', '2011-02-03', 128662, '2011-09-01', 726050.00, 'A'),
    (1188, 3, 'JEFFREY ARTHUR DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 115724, '2011-03-21', 899630.00, 'A'),
    (1189, 1, 'DAHL VELEZ JULIANA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126916, '2011-05-23', 320020.00, 'A'),
    (119, 3, 'WALESKA DE LIMA ALMEIDA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-05-09', 125240.00, 'A'),
    (1190, 3, 'LUIS JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2008-04-04', 901210.00, 'A'),
    (1192, 1, 'AZUERO VALENTINA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-14', 26310.00, 'A'),
    (1193, 1, 'MARQUEZ GALINDO MAURICIO JAVIER', 191821112, 'CRA 25 CALLE 100', '729@yahoo.es', '2011-02-03', 131105, '2011-05-13', 493560.00, 'A'),
    (1195, 1, 'NIETO FRANCO JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '707@yahoo.com', '2011-02-03', 127591, '2011-07-30', 463790.00, 'A'),
    (1196, 3, 'ESTEVES JOAQUIM LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-04-05', 152270.00, 'A'),
    (1197, 4, 'BARRERO KAREN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-12', 369990.00, 'A'),
    (1198, 1, 'CORRALES GUZMAN DELIO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127689, '2011-08-03', 393120.00, 'A'),
    (1199, 1, 'CUELLAR TOCO EDGAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127531, '2011-09-20', 855640.00, 'A'),
    (12, 1, 'MARIN PRIETO FREDY NELSON ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-23', 641210.00, 'A'),
    (120, 1, 'LOPEZ JARAMILLO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2009-04-17', 29680.00, 'A'),
    (1200, 3, 'SCHULTER ACHIM', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 291002, '2010-05-21', 98860.00, 'A'),
    (1201, 3, 'HOWELL LAURENCE ADRIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 286785, '2011-05-22', 927350.00, 'A'),
    (1202, 3, 'ALCAZAR ESCARATE JAIME PATRICIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2011-08-25', 340160.00, 'A'),
    (1203, 3, 'HIDALGO FUENZALIDA GABRIEL RAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-05-03', 918780.00, 'A'),
    (1206, 1, 'VANEGAS HENAO ORLANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-27', 832910.00, 'A'),
    (1207, 1, 'PENARANDA ARIAS RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-19', 832710.00, 'A'),
    (1209, 1, 'LEZAMA CERVERA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2011-09-14', 825980.00, 'A'),
    (121, 1, 'PULIDO JIMENEZ OSCAR HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-29', 772700.00, 'A'),
    (1211, 1, 'TRUJILLO BOCANEGRA HAROL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127538, '2011-05-27', 199260.00, 'A'),
    (1212, 1, 'ALVAREZ TORRES MARIO RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-08-15', 589960.00, 'A'),
    (1213, 1, 'CORRALES VARON BELMER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-26', 352030.00, 'A'),
    (1214, 3, 'CUEVAS RODRIGUEZ MANUELA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-30', 990250.00, 'A'),
    (1216, 1, 'LOPEZ EDICSON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-31', 505210.00, 'A'),
    (1217, 3, 'GARCIA PALOMARES JUAN JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-07-31', 840440.00, 'A'),
    (1218, 1, 'ARCINIEGAS NARANJO RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127492, '2010-12-17', 686610.00, 'A'),
    (122, 1, 'GONZALEZ RIANO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128031, '2011-08-05', 774450.00, 'A'),
    (1220, 1, 'GARCIA GUTIERREZ WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-06-20', 498680.00, 'A'),
    (1221, 3, 'GOMEZ DE ALONSO ANGELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-27', 758300.00, 'A'),
    (1222, 1, 'MEDINA QUIROGA JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127538, '2011-01-16', 295480.00, 'A'),
    (1224, 1, 'ARCILA CORREA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-03-20', 125900.00, 'A'),
    (1225, 1, 'QUIJANO REYES CARLOS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127538, '2010-04-08', 22100.00, 'A'),
    (157, 1, 'ORTIZ RIOS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-12', 365330.00, 'A'),
    (1226, 1, 'VARGAS GALLEGO JAIRO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2009-07-30', 732820.00, 'A'),
    (1228, 3, 'NAPANGA MIRENGHI MARTIN', 191821112, 'CRA 25 CALLE 100', '153@yahoo.es', '2011-02-03', 132958, '2011-02-08', 790400.00, 'A'),
    (123, 1, 'LAMUS CASTELLANOS ANDRES RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-11', 554160.00, 'A'),
    (1230, 1, 'RIVEROS PINEROS JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127492, '2011-09-25', 422220.00, 'A'),
    (1231, 3, 'ESSER JUAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127327, '2011-04-01', 635060.00, 'A'),
    (1232, 3, 'DOMINGUEZ MORA MAURICIO ALFREDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-22', 908630.00, 'A'),
    (1233, 3, 'MOLINA FERNANDEZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-05-28', 637990.00, 'A'),
    (1234, 3, 'BELLO DANIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 196234, '2010-09-04', 464040.00, 'A'),
    (1235, 3, 'BENADAVA GUEVARA DAVID ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-05-18', 406240.00, 'A'),
    (1236, 3, 'RODRIGUEZ MATOS ROBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-03-22', 639070.00, 'A'),
    (1237, 3, 'TAPIA ALARCON PATRICIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2010-07-06', 976620.00, 'A'),
    (1239, 3, 'VERCHERE ALFONSO CHRISTIAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2010-08-23', 899600.00, 'A'),
    (1241, 1, 'ESPINEL LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128206, '2009-03-09', 302860.00, 'A'),
    (1242, 3, 'VERGARA FERREIRA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-03', 713310.00, 'A'),
    (1243, 3, 'ZUMARRAGA SIRVENT CRSTINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-08-24', 657950.00, 'A'),
    (1244, 4, 'ESCORCIA VASQUEZ TOMAS', 191821112, 'CRA 25 CALLE 100', '354@yahoo.com.mx', '2011-02-03', 128662, '2011-04-01', 149830.00, 'A'),
    (1245, 4, 'PARAMO CUENCA KELLY LORENA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127492, '2011-05-04', 775300.00, 'A'),
    (1246, 4, 'PEREZ LOPEZ VERONICA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-07-11', 426990.00, 'A'),
    (1247, 4, 'CHAPARRO RODRIGUEZ DANIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-10-08', 809070.00, 'A'),
    (1249, 4, 'DIAZ MARTINEZ MARIA CAROLINA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2011-05-30', 394740.00, 'A'),
    (125, 1, 'CALDON RODRIGUEZ JAIME ARIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126968, '2011-07-29', 574780.00, 'A'),
    (1250, 4, 'PINEDA VASQUEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2010-09-03', 680540.00, 'A'),
    (1251, 5, 'MATIZ URIBE ANGELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-12-25', 218470.00, 'A'),
    (1253, 1, 'ZAMUDIO RICAURTE JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126892, '2011-08-05', 598160.00, 'A'),
    (1254, 1, 'ALJURE FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-07-21', 838660.00, 'A'),
    (1255, 3, 'ARMESTO AIRA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 196234, '2011-01-29', 398840.00, 'A'),
    (1257, 1, 'POTES GUEVARA JAIRO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127858, '2011-03-17', 194580.00, 'A'),
    (1258, 1, 'BURBANO QUIROGA RAFAEL', 191821112, 'CRA 25 CALLE 100', '767@facebook.com', '2011-02-03', 127591, '2011-04-07', 538220.00, 'A'),
    (1259, 1, 'CARDONA GOMEZ JAVIR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-03-16', 107380.00, 'A'),
    (126, 1, 'PULIDO PARDO GUIDO IVAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-05', 531550.00, 'A'),
    (1260, 1, 'LOPERA LEDESMA PABLO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-09-19', 922240.00, 'A'),
    (1263, 1, 'TRIBIN BARRIGA JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-09-02', 525330.00, 'A'),
    (1264, 1, 'NAVIA LOPEZ ANDRES FELIPE ', 191821112, 'CRA 25 CALLE 100', '353@hotmail.es', '2011-02-03', 127300, '2011-07-15', 591190.00, 'A'),
    (1265, 1, 'CARDONA GOMEZ FABIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2010-11-18', 379940.00, 'A'),
    (1266, 1, 'ESCARRIA VILLEGAS ANDRES JULIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-08-19', 126160.00, 'A'),
    (1268, 1, 'CASTRO HERNANDEZ ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-03-25', 76260.00, 'A'),
    (127, 1, 'RODRIGUEZ RODRIGUEZ GIOVANI FRANCISCO', 191821112, 'CRA 25 CALLE 100', '662@hotmail.es', '2011-02-03', 127591, '2011-09-29', 933390.00, 'A'),
    (1270, 1, 'LEAL HERNANDEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-24', 313610.00, 'A'),
    (1272, 1, 'ORTIZ CARDONA WILLIAM ENRIQUE', 191821112, 'CRA 25 CALLE 100', '914@hotmail.com', '2011-02-03', 128662, '2011-09-13', 272150.00, 'A'),
    (1273, 1, 'ROMERO VAN GOMPEL HERNAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-09-07', 832960.00, 'A'),
    (1274, 1, 'BERMUDEZ LONDONO JHON FREDY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127300, '2011-08-29', 348380.00, 'A'),
    (1275, 1, 'URREA ALVAREZ NICOLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-01', 242980.00, 'A'),
    (1276, 1, 'VALENCIA LLANOS RODRIGO AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-04-11', 169790.00, 'A'),
    (1277, 1, 'PAZ VALENCIA GUILLERMO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127300, '2011-08-05', 120020.00, 'A'),
    (1278, 1, 'MONROY CORREDOR GERARDO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-06-25', 90700.00, 'A'),
    (1279, 1, 'RIOS MEDINA JAVIER ERMINSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-09-12', 93440.00, 'A'),
    (128, 1, 'GALLEGO GUZMAN MARIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-06-25', 72290.00, 'A'),
    (1280, 1, 'GARCIA OSCAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127662, '2011-09-30', 195090.00, 'A'),
    (1282, 1, 'MURILLO PESELLIN GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-06-15', 890530.00, 'A'),
    (1284, 1, 'DIAZ ALVAREZ JOHNY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-06-25', 164130.00, 'A'),
    (1285, 1, 'GARCES BELTRAN RAUL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-08-11', 719220.00, 'A'),
    (1286, 1, 'MATERON POVEDA LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-25', 103710.00, 'A'),
    (1287, 1, 'VALENCIA ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-10-23', 360880.00, 'A'),
    (1288, 1, 'PENA AGUDELO JOSE RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 134022, '2011-05-25', 493280.00, 'A'),
    (1289, 1, 'CORREA NUNEZ JORGE ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-08-18', 383750.00, 'A'),
    (129, 1, 'ALVAREZ RODRIGUEZ IVAN RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2008-01-28', 561290.00, 'A'),
    (1291, 1, 'BEJARANO ROSERO FREDDY ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-10-09', 43400.00, 'A'),
    (1292, 1, 'CASTILLO BARRIOS GUSTAVO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-06-17', 900180.00, 'A'),
    ('CELL401', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1296, 1, 'GALVEZ GUTIERREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2010-03-28', 807090.00, 'A'),
    (1297, 3, 'CRUZ GARCIA MILTON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 139844, '2011-03-21', 75630.00, 'A'),
    (1298, 1, 'VILLEGAS GUTIERREZ JOSE RICARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-11', 956860.00, 'A'),
    (13, 1, 'VACA MURCIA JESUS ALFREDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-04', 613430.00, 'A'),
    (1301, 3, 'BOTTI ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 231989, '2011-04-04', 910640.00, 'A'),
    (1302, 3, 'COTINO HUESO LORENZO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-02-02', 803450.00, 'A'),
    (1304, 3, 'NESPOLI MANTOVANI LUIZ CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-04-18', 16230.00, 'A'),
    (1307, 4, 'AVILA GIL PAULA ANDREA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-19', 711110.00, 'A'),
    (1308, 4, 'VALLEJO PINEDA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-12', 323490.00, 'A'),
    (1312, 1, 'ROMERO OSCAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-17', 642460.00, 'A'),
    (1314, 3, 'LULLIES CONSTANZE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 245206, '2010-06-03', 154970.00, 'A'),
    (1315, 1, 'CHAPARRO GUTIERREZ JORGE ADRIANO', 191821112, 'CRA 25 CALLE 100', '284@hotmail.es', '2011-02-03', 127591, '2010-12-02', 325440.00, 'A'),
    (1316, 1, 'BARRANTES DISI RICARDO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132879, '2011-07-18', 162270.00, 'A'),
    (1317, 3, 'VERDES GAGO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2010-03-10', 835060.00, 'A'),
    (1319, 3, 'MARTIN MARTINEZ GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2010-05-26', 937220.00, 'A'),
    (1320, 3, 'MOTTURA MASSIMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2008-11-10', 620640.00, 'A'),
    (1321, 3, 'RUSSELL TIMOTHY JAMES', 191821112, 'CRA 25 CALLE 100', '502@hotmail.es', '2011-02-03', 145135, '2010-04-16', 291560.00, 'A'),
    (1322, 3, 'JAIN TARSEM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 190393, '2011-05-31', 595890.00, 'A'),
    (1323, 3, 'ORTEGA CEVALLOS JULIETA ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-30', 104760.00, 'A'),
    (1324, 3, 'MULLER PICHAIDA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-05-17', 736130.00, 'A'),
    (1325, 3, 'ALVEAR TELLEZ JULIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-01-23', 366390.00, 'A'),
    (1327, 3, 'MOYA LATORRE MARCELA CAROLINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-05-17', 18520.00, 'A'),
    (1328, 3, 'LAMA ZAROR RODRIGO IGNACIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2010-10-27', 221990.00, 'A'),
    (1329, 3, 'HERNANDEZ CIFUENTES MAURICE JEANETTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 139844, '2011-06-22', 54410.00, 'A'),
    (133, 1, 'CORDOBA HOYOS JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-20', 966820.00, 'A'),
    (1330, 2, 'HOCHKOFLER NOEMI CONSUELO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-27', 606070.00, 'A'),
    (1331, 4, 'RAMIREZ BARRERO DANIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 154563, '2011-04-18', 867120.00, 'A'),
    (1332, 4, 'DE LEON DURANGO RICARDO JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131105, '2011-09-08', 517400.00, 'A'),
    (1333, 4, 'RODRIGUEZ MACIAS IVAN MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129447, '2011-05-23', 985620.00, 'A'),
    (1334, 4, 'GUTIERREZ DE PINERES YANET MARIA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2011-06-16', 375890.00, 'A'),
    (1335, 4, 'GUTIERREZ DE PINERES YANET MARIA GABRIELA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-06-16', 922600.00, 'A'),
    (1336, 4, 'CABRALES BECHARA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '708@hotmail.com', '2011-02-03', 131105, '2011-05-13', 485330.00, 'A'),
    (1337, 4, 'MEJIA TOBON LUIS DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127662, '2011-08-05', 658860.00, 'A'),
    (1338, 3, 'OROS NERCELLES CRISTIAN ANDRE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 144215, '2011-04-26', 838310.00, 'A'),
    (1339, 3, 'MORENO BRAVO CAROLINA ANDREA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 190393, '2010-12-08', 214950.00, 'A'),
    (134, 1, 'GONZALEZ LOPEZ DANIEL ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-08', 178580.00, 'A'),
    (1340, 3, 'FERNANDEZ GARRIDO MARCELO FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-07-08', 559820.00, 'A'),
    (1342, 3, 'SUMEGI IMRE ZOLTAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-16', 91750.00, 'A'),
    (1343, 3, 'CALDERON FLANDEZ SERGIO', 191821112, 'CRA 25 CALLE 100', '108@hotmail.com', '2011-02-03', 117002, '2010-12-12', 996030.00, 'A'),
    (1345, 3, 'CARBONELL ATCHUGARRY GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116366, '2010-04-12', 536390.00, 'A'),
    (1346, 3, 'MONTEALEGRE AGUILAR FEDERICO ', 191821112, 'CRA 25 CALLE 100', '448@yahoo.es', '2011-02-03', 132165, '2011-08-08', 567260.00, 'A'),
    (1347, 1, 'HERNANDEZ MANCHEGO CARLOS JULIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-04-28', 227130.00, 'A'),
    (1348, 1, 'ARENAS ZARATE FERNEY ARNULFO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127963, '2011-03-26', 433860.00, 'A'),
    (1349, 3, 'DELFIM DINIZ PASSOS PINHEIRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 110784, '2010-04-17', 487930.00, 'A'),
    (135, 1, 'GARCIA SIMBAQUEBA RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-25', 992420.00, 'A'),
    (1350, 3, 'BRAUN VALENZUELA FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-29', 138050.00, 'A'),
    (1351, 3, 'LEVIN FIORELLI ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 116366, '2011-04-10', 226470.00, 'A'),
    (1353, 3, 'BALTODANO ESQUIVEL LAURA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132165, '2011-08-01', 911660.00, 'A'),
    (1354, 4, 'ESCOBAR  YEPES ANDREA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-19', 403630.00, 'A'),
    (1356, 1, 'GAGELI OSORIO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '228@yahoo.com.mx', '2011-02-03', 128662, '2011-07-14', 205070.00, 'A'),
    (1357, 3, 'CABAL ALVAREZ RUBEN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-08-14', 175770.00, 'A'),
    (1359, 4, 'HUERFANO JUAN DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-04', 790970.00, 'A'),
    (136, 1, 'OSORIO RAMIREZ LEONARDO', 191821112, 'CRA 25 CALLE 100', '686@yahoo.es', '2011-02-03', 128662, '2010-05-14', 426380.00, 'A'),
    (1360, 4, 'RAMON GARCIA MARIA PAULA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-01', 163890.00, 'A'),
    (1362, 30, 'ALVAREZ CLAVIO CARLA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127203, '2011-04-18', 741020.00, 'A'),
    (1363, 3, 'SERRA DURAN GERARDO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-08-03', 365490.00, 'A'),
    (1364, 3, 'NORIEGA VALVERDE SILVIA MARCELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132775, '2011-02-27', 604370.00, 'A'),
    (1366, 1, 'JARAMILLO LOPEZ ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '269@terra.com.co', '2011-02-03', 127559, '2010-11-08', 813800.00, 'A'),
    (1367, 1, 'MAZO ROLDAN CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-05-04', 292880.00, 'A'),
    (1368, 1, 'MURIEL ARCILA MAURICIO HERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-29', 22970.00, 'A'),
    (1369, 1, 'RAMIREZ CARLOS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-14', 236230.00, 'A'),
    (137, 1, 'LUNA PEREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126881, '2011-08-05', 154640.00, 'A'),
    (1370, 1, 'GARCIA GRAJALES PEDRO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128166, '2011-10-09', 112230.00, 'A'),
    (1372, 3, 'GARCIA ESCOBAR ANA MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-03-29', 925670.00, 'A'),
    (1373, 3, 'ALVES DIAS CARLOS AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-07', 70940.00, 'A'),
    (1374, 3, 'MATTOS CHRISTIANE GARCIA CID', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 183024, '2010-08-25', 577700.00, 'A'),
    (1376, 1, 'CARVAJAL ROJAS ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-10', 645240.00, 'A'),
    (1377, 3, 'MADARIAGA CADIZ CLAUDIO CRISTIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-10-04', 199200.00, 'A'),
    (1379, 3, 'MARIN YANEZ ALICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-02-20', 703870.00, 'A'),
    (138, 1, 'DIAZ AVENDANO MARCELO IVAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-22', 494080.00, 'A'),
    (1381, 3, 'COSTA VILLEGAS LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2011-08-21', 580670.00, 'A'),
    (1382, 3, 'DAZA PEREZ JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 122035, '2009-02-23', 888000.00, 'A'),
    (1385, 4, 'RIVEROS ARIAS MARIA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127492, '2011-09-26', 35710.00, 'A'),
    (1386, 30, 'TORO GIRALDO MATEO', 191821112, 'CRA 25 CALLE 100', '433@yahoo.com.mx', '2011-02-03', 127591, '2011-07-17', 700730.00, 'A'),
    (1387, 4, 'ROJAS YARA LAURA DANIELA MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-31', 396530.00, 'A'),
    (1388, 3, 'GALLEGO RODRIGO MARIA PILAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2009-04-19', 880450.00, 'A'),
    (1389, 1, 'PANTOJA VELASQUEZ JOSE ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127300, '2011-08-05', 212660.00, 'A'),
    (139, 1, 'RANCO GOMEZ HERNÁN EDUARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-01-19', 6450.00, 'A'),
    (1390, 3, 'VAN DEN BORNE KEES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2010-01-28', 421930.00, 'A'),
    (1391, 3, 'MONDRAGON FLORES JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-08-22', 471700.00, 'A'),
    (1392, 3, 'BAGELLA MICHELE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-07-27', 92720.00, 'A'),
    (1393, 3, 'BISTIANCIC MACHADO ANA INES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 116366, '2010-08-02', 48490.00, 'A'),
    (1394, 3, 'BANADOS ORTIZ MARIA PILAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-08-25', 964280.00, 'A'),
    (1395, 1, 'CHINDOY CHINDOY HERNANDO', 191821112, 'CRA 25 CALLE 100', '107@terra.com.co', '2011-02-03', 126892, '2011-08-25', 675920.00, 'A'),
    (1396, 3, 'SOTO NUNEZ ANDRES ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-10-02', 486760.00, 'A'),
    (1397, 1, 'DELGADO MARTINEZ LORGE ELIAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-23', 406040.00, 'A'),
    (1398, 1, 'LEON GUEVARA JAVIER ANIBAL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126892, '2011-09-08', 569930.00, 'A'),
    (1399, 1, 'ZARAMA BASTIDAS LUIS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126892, '2011-08-05', 631540.00, 'A'),
    (14, 1, 'MAGUIN HENNSSEY LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '714@gmail.com', '2011-02-03', 127591, '2011-07-11', 143540.00, 'A'),
    (140, 1, 'CARRANZA CUY ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-25', 550010.00, 'A'),
    (1401, 3, 'REYNA CASTORENA JOSE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 189815, '2011-08-29', 344970.00, 'A'),
    (1402, 1, 'GFALLO BOTERO SERGIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-07-14', 381100.00, 'A'),
    (1403, 1, 'ARANGO ARAQUE JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-05-04', 870590.00, 'A'),
    (1404, 3, 'LASSNER NORBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118942, '2010-02-28', 209650.00, 'A'),
    (1405, 1, 'DURANGO MARIN HECTOR LEON', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '1970-02-02', 436480.00, 'A'),
    (1407, 1, 'FRANCO CASTANO DIEGO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-06-28', 457770.00, 'A'),
    (1408, 1, 'HERNANDEZ SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-05-29', 628550.00, 'A'),
    (1409, 1, 'CASTANO DUQUE CARLOS HUGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-03-23', 769410.00, 'A'),
    (141, 1, 'CHAMORRO CHEDRAUI SERGIO ALBERTO', 191821112, 'CRA 25 CALLE 100', '922@yahoo.com.mx', '2011-02-03', 127591, '2011-05-07', 730720.00, 'A'),
    (1411, 1, 'RAMIREZ MONTOYA ADAMO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-04-13', 498880.00, 'A'),
    (1412, 1, 'GONZALEZ BENJUMEA OSCAR HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-11-01', 610150.00, 'A'),
    (1413, 1, 'ARANGO ACEVEDO WALTER ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-10-07', 554090.00, 'A'),
    (1414, 1, 'ARANGO GALLO HUMBERTO LEON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-02-25', 940010.00, 'A'),
    (1415, 1, 'VELASQUEZ LUIS GONZALO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-07-06', 37760.00, 'A'),
    (1416, 1, 'MIRA AGUILAR FRANCISCO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-30', 368790.00, 'A'),
    (1417, 1, 'RIVERA ARISTIZABAL CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-03-02', 730670.00, 'A'),
    (1418, 1, 'ARISTIZABAL ROLDAN ANDRES RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-02', 546960.00, 'A'),
    (142, 1, 'LOPEZ ZULETA MAURICIO ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-01', 3550.00, 'A'),
    (1420, 1, 'ESCORCIA ARAMBURO JUAN MARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-04-01', 73100.00, 'A'),
    (1421, 1, 'CORREA PARRA RICARDO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-08-05', 737110.00, 'A'),
    (1422, 1, 'RESTREPO NARANJO DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-09-15', 466240.00, 'A'),
    (1423, 1, 'VELASQUEZ CARLOS JUAN', 191821112, 'CRA 25 CALLE 100', '123@yahoo.com', '2011-02-03', 128662, '2010-06-09', 119880.00, 'A'),
    (1424, 1, 'MACIA GONZALEZ ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2010-11-12', 200690.00, 'A'),
    (1425, 1, 'BERRIO MEJIA HELBER ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2010-06-04', 643800.00, 'A'),
    (1427, 1, 'GOMEZ GUTIERREZ CARLOS ARIEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-09-08', 153320.00, 'A'),
    (1428, 1, 'RESTREPO LOPEZ JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-12', 915770.00, 'A'),
    ('CELL4012', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1429, 1, 'BARTH TOBAR LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-02-23', 118900.00, 'A'),
    (143, 1, 'MUNERA BEDIYA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-09-21', 825600.00, 'A'),
    (1430, 1, 'JIMENEZ VELEZ ANDRES EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-02-26', 847160.00, 'A'),
    (1431, 1, 'TAKAHASHI GAVIRIA NICOLAS KEIICHIRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-13', 879120.00, 'A'),
    (1432, 1, 'ESCOBAR JARAMILLO ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-06-10', 854110.00, 'A'),
    (1433, 1, 'PALACIO NAVARRO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-08-18', 633200.00, 'A'),
    (1434, 1, 'LONDONO MUNOZ ADOLFO LEON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-09-14', 603670.00, 'A'),
    (1435, 1, 'PULGARIN JAIME ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2009-11-01', 118730.00, 'A'),
    (1436, 1, 'FERRERA ZULUAGA LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-07-10', 782630.00, 'A'),
    (1437, 1, 'VASQUEZ VELEZ HABACUC', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-27', 557000.00, 'A'),
    (1438, 1, 'HENAO PALOMINO DIEGO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2009-05-06', 437080.00, 'A'),
    (1439, 1, 'HURTADO URIBE JUAN GONZALO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-01-11', 514400.00, 'A'),
    (144, 1, 'ALDANA RODOLFO AUGUSTO', 191821112, 'CRA 25 CALLE 100', '838@yahoo.es', '2011-02-03', 127591, '2011-08-07', 117350.00, 'A'),
    (1441, 1, 'URIBE DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2010-11-19', 760610.00, 'A'),
    (1442, 1, 'PINEDA GALIANO JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-07-29', 20770.00, 'A'),
    (1443, 1, 'DUQUE BETANCOURT FABIO LEON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-26', 822030.00, 'A'),
    (1444, 1, 'JARAMILLO TORO HERNAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-04-27', 47830.00, 'A'),
    (145, 1, 'VASQUEZ ZAPATA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-09', 109940.00, 'A'),
    (1450, 1, 'TOBON FRANCO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '545@facebook.com', '2011-02-03', 127591, '2011-05-03', 889540.00, 'A'),
    (1454, 1, 'LOTERO PAVAS CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-05-28', 646750.00, 'A'),
    (1455, 1, 'ESTRADA HENAO JAVIER ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128569, '2009-09-07', 215460.00, 'A'),
    (1456, 1, 'VALDERRAMA MAXIMILIANO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-23', 137030.00, 'A'),
    (1457, 3, 'ESTRADA ALVAREZ GONZALO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 154903, '2011-05-02', 38790.00, 'A'),
    (1458, 1, 'PAUCAR VALLEJO JAIRO ALONSO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-10-15', 782860.00, 'A'),
    (1459, 1, 'RESTREPO GIRALDO JHON DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-04-04', 797930.00, 'A'),
    (146, 1, 'BAQUERO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-03-03', 197650.00, 'A'),
    (1460, 1, 'RESTREPO DOMINGUEZ GUSTAVO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2009-05-18', 641050.00, 'A'),
    (1461, 1, 'YANOVICH JACKY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-08-21', 811470.00, 'A'),
    (1462, 1, 'HINCAPIE ROLDAN JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-08-27', 134200.00, 'A'),
    (1463, 3, 'ZEA JORGE OLIVER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2011-03-12', 236610.00, 'A'),
    (1464, 1, 'OSCAR MAURICIO ECHAVARRIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-11-24', 780440.00, 'A'),
    (1465, 1, 'COSSIO GIL JOSE ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-10-01', 192380.00, 'A'),
    (1466, 1, 'GOMEZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-03-01', 620580.00, 'A'),
    (1467, 1, 'VILLALOBOS OCHOA ANDRES GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-18', 525740.00, 'A'),
    (1470, 1, 'GARCIA GONZALEZ DAVID DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-09-17', 986990.00, 'A'),
    (1471, 1, 'RAMIREZ RESTREPO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-04-03', 162250.00, 'A'),
    (1472, 1, 'VASQUEZ GUTIERREZ JUAN ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-05', 850280.00, 'A'),
    (1474, 1, 'ESCOBAR ARANGO DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-11-01', 272460.00, 'A'),
    (1475, 1, 'MEJIA TORO JUAN DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-05-02', 68320.00, 'A'),
    (1477, 1, 'ESCOBAR GOMEZ JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127848, '2011-05-15', 416150.00, 'A'),
    (1478, 1, 'BETANCUR WILSON', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2008-02-09', 508060.00, 'A'),
    (1479, 3, 'ROMERO ARRAU GONZALO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-10', 291880.00, 'A'),
    (148, 1, 'REINA MORENO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-08', 699240.00, 'A'),
    (1480, 1, 'CASTANO OSORIO JORGE ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127662, '2011-09-20', 935200.00, 'A'),
    (1482, 1, 'LOPEZ LOPERA ROBINSON FREDY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-09-02', 196280.00, 'A'),
    (1484, 1, 'HERNAN DARIO RENDON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-03-18', 312520.00, 'A'),
    (1485, 1, 'MARTINEZ ARBOLEDA MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-11-03', 821760.00, 'A'),
    (1486, 1, 'RODRIGUEZ MORA CARLOS MORA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-09-16', 171270.00, 'A'),
    (1487, 1, 'PENAGOS VASQUEZ JOSE DOMINGO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-09-06', 391080.00, 'A'),
    (1488, 1, 'UERRA MEJIA DIEGO LEON', 191821112, 'CRA 25 CALLE 100', '704@hotmail.com', '2011-02-03', 144086, '2011-08-06', 441570.00, 'A'),
    (1491, 1, 'QUINTERO GUTIERREZ ABEL PASTOR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2009-11-16', 138100.00, 'A'),
    (1492, 1, 'ALARCON YEPES IVAN DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2010-05-03', 145330.00, 'A'),
    (1494, 1, 'HERNANDEZ VALLEJO ANDRES MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-09', 125770.00, 'A'),
    (1495, 1, 'MONTOYA MORENO LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-09', 691770.00, 'A'),
    (1497, 1, 'BARRERA CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '62@yahoo.es', '2011-02-03', 127591, '2010-08-24', 332550.00, 'A'),
    (1498, 1, 'ARROYAVE FERNANDEZ PABLO EMILIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-05-12', 418030.00, 'A'),
    (1499, 1, 'GOMEZ ANGEL FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-05-03', 92480.00, 'A'),
    (15, 1, 'AMSILI COHEN JOSEPH', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-07', 877400.00, 'A'),
    ('CELL411', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (150, 3, 'ARDILA GUTIERREZ DANIEL MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-12', 506760.00, 'A'),
    (1500, 1, 'GONZALEZ DUQUE PABLO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-04-13', 208330.00, 'A'),
    (1502, 1, 'MEJIA BUSTAMANTE JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-09', 196000.00, 'A'),
    (1506, 1, 'SUAREZ MONTOYA JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128569, '2011-09-13', 368250.00, 'A'),
    (1508, 1, 'ALVAREZ GONZALEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-02-15', 355190.00, 'A'),
    (1509, 1, 'NIETO CORREA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-31', 899980.00, 'A'),
    (1511, 1, 'HERNANDEZ GRANADOS JHONATHAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-08-30', 471720.00, 'A'),
    (1512, 1, 'CARDONA ALVAREZ DEIBY', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2010-10-05', 55590.00, 'A'),
    (1513, 1, 'TORRES MARULANDA JUAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-10-20', 862820.00, 'A'),
    (1514, 1, 'RAMIREZ RAMIREZ JHON JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-05-11', 147310.00, 'A'),
    (1515, 1, 'MONDRAGON TORO NICOLAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-01-19', 148100.00, 'A'),
    (1517, 3, 'SUIDA DIETER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2008-07-21', 48580.00, 'A'),
    (1518, 3, 'LEFTWICH ANDREW PAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 211610, '2011-06-07', 347170.00, 'A'),
    (1519, 3, 'RENTON ANDREW GEORGE PATRICK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2010-12-11', 590120.00, 'A'),
    (152, 1, 'BUSTOS MONZON CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-22', 335160.00, 'A'),
    (1521, 3, 'JOSE CUSTODIO DO ALTISSIMO NETONETO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 119814, '2011-04-28', 775000.00, 'A'),
    (1522, 3, 'GUARACI FRANCO DE PAIVA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 119167, '2011-04-28', 147770.00, 'A'),
    (1525, 4, 'MORENO TENORIO MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-20', 888750.00, 'A'),
    (1527, 1, 'VELASQUEZ HERNANDEZ JHON EDUARSON', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-07-19', 161270.00, 'A'),
    (1528, 4, 'VANEGAS ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '185@yahoo.com', '2011-02-03', 127591, '2011-06-20', 109830.00, 'A'),
    (1529, 3, 'BARBABE CLAIRE LAURENCE ANNICK', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-04', 65330.00, 'A'),
    (153, 1, 'GONZALEZ TORREZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-01', 762560.00, 'A'),
    (1530, 3, 'COREA MARTINEZ GUILLERMO JOSE ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 135360, '2011-09-25', 997190.00, 'A'),
    (1531, 3, 'PACHECO RODRIGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2010-03-08', 789960.00, 'A'),
    (1532, 3, 'WELCH RICHARD WILLIAM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 190393, '2010-10-04', 958210.00, 'A'),
    (1533, 3, 'FOREMAN CAROLYN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 107159, '2011-05-23', 421200.00, 'A'),
    (1535, 3, 'ZAGAL SOTO CLAUDIA PAZ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2008-05-16', 893130.00, 'A'),
    (1536, 3, 'ZAGAL SOTO CLAUDIA PAZ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-10-08', 771600.00, 'A'),
    (1538, 3, 'BLANCO RODRIGUEZ JUAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 197162, '2011-04-02', 578250.00, 'A'),
    (154, 1, 'HENDEZ PUERTO JAVIER ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-25', 807310.00, 'A'),
    (1540, 3, 'CONTRERAS BRAIN JAVIER ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-02-22', 42420.00, 'A'),
    (1541, 3, 'RONDON HERNANDEZ MARYLIN DEL CARMEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-09-29', 145780.00, 'A'),
    (1542, 3, 'ELJURI RAMIREZ EMIRA ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2010-10-13', 601670.00, 'A'),
    (1544, 3, 'REYES LE ROY TOMAS FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2009-06-24', 49990.00, 'A'),
    (1545, 3, 'GHETEA GAMUZ JENNY', 191821112, 'CRA 25 CALLE 100', '675@gmail.com', '2011-02-03', 150699, '2010-05-29', 536940.00, 'A'),
    (1546, 3, 'DUARTE GONZALEZ ROONEY ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-06-20', 534720.00, 'A'),
    (1548, 3, 'BIZOT PHILIPPE PIERRE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 263813, '2011-03-02', 709760.00, 'A'),
    (1549, 3, 'PELUFFO RUBIO GUILLERMO JUAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 116366, '2011-05-09', 360470.00, 'A'),
    (1550, 3, 'AGLIATI YERKOVIC CAROLINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2010-06-01', 673040.00, 'A'),
    (1551, 3, 'SEPULVEDA LEDEZMA HENRY CORNELIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-08-15', 283810.00, 'A'),
    (1552, 3, 'CABRERA CARMINE JAIME FRANCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2008-11-30', 399940.00, 'A'),
    (1553, 3, 'ZINNO PENA ALVARO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116366, '2010-08-02', 148270.00, 'A'),
    (1554, 3, 'ROMERO BUCCICARDI JUAN CRISTOBAL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-08-01', 541530.00, 'A'),
    (1555, 3, 'FEFERKORN ABRAHAM', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 159312, '2011-06-12', 262840.00, 'A'),
    (1556, 3, 'MASSE CATESSON CAROLINE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131272, '2011-06-12', 689600.00, 'A'),
    (1557, 3, 'CATESSON ALEXANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 131272, '2011-06-12', 659470.00, 'A'),
    (1558, 3, 'FUENTES HERNANDEZ RICARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-18', 228540.00, 'A'),
    (1559, 3, 'GUEVARA MENJIVAR WILSON ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-18', 164310.00, 'A'),
    (1560, 3, 'DANOWSKI NICOLAS JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-02', 135920.00, 'A'),
    (1561, 3, 'CASTRO VELASQUEZ ISMAEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 121318, '2011-07-31', 186670.00, 'A'),
    (1562, 3, 'RODRIGUEZ CORNEJO CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 525590.00, 'A'),
    (1563, 3, 'VANIA CAROLINA FLORES AVILA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-18', 67950.00, 'A'),
    (1564, 3, 'ARMERO RAMOS OSCAR ALEXANDER', 191821112, 'CRA 25 CALLE 100', '414@hotmail.com', '2011-02-03', 127591, '2011-09-18', 762950.00, 'A'),
    (1565, 3, 'ORELLANA MARTINEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-18', 610930.00, 'A'),
    (1566, 3, 'BRATT BABONNEAU CARLOS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-14', 765800.00, 'A'),
    (1567, 3, 'YANES FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150728, '2011-04-12', 996200.00, 'A'),
    (1568, 3, 'ANGULO TAMAYO SEBASTIAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126674, '2011-05-19', 683600.00, 'A'),
    (1569, 3, 'HENRIQUEZ JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 138329, '2011-08-15', 429390.00, 'A'),
    ('CELL4137', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1570, 3, 'GARCIA VILLARROEL RAUL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126189, '2011-06-12', 96140.00, 'A'),
    (1571, 3, 'SOLA HERNANDEZ JOSE FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-09-25', 192530.00, 'A'),
    (1572, 3, 'PEREZ PASTOR OSWALDO MAGARREY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126674, '2011-05-25', 674260.00, 'A'),
    (1573, 3, 'MICHAN QUINONES FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-06-21', 793680.00, 'A'),
    (1574, 3, 'GARCIA ARANDA OSCAR DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-08-15', 945620.00, 'A'),
    (1575, 3, 'GARCIA RIBAS JORDI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-10', 347070.00, 'A'),
    (1576, 3, 'GALVAN ROMERO MARIA INMACULADA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-09-14', 898480.00, 'A'),
    (1577, 3, 'BOSH MOLINAS JUAN JOSE ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 198576, '2011-08-22', 451190.00, 'A'),
    (1578, 3, 'MARTIN TENA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-04-24', 560520.00, 'A'),
    (1579, 3, 'HAWKINS ROBERT JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-12', 449010.00, 'A'),
    (1580, 3, 'GHERARDI ALEJANDRO EMILIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 180063, '2010-11-15', 563500.00, 'A'),
    (1581, 3, 'TELLO JUAN EDUARDO', 191821112, 'CRA 25 CALLE 100', '192@hotmail.com', '2011-02-03', 138329, '2011-05-01', 470460.00, 'A'),
    (1583, 3, 'GUZMAN VALDIVIA CINTIA TATIANA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 199862, '2011-04-06', 897580.00, 'A'),
    (1584, 3, 'STUBBS MERCEDES CARMEN JOSEFINA DEL MILAGRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 199862, '2011-04-06', 502510.00, 'A'),
    (1585, 3, 'QUINTEIRO GORIS JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-17', 819840.00, 'A'),
    (1587, 3, 'RIVAS LORIA PRISCILLA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 205636, '2011-05-01', 498720.00, 'A'),
    (1588, 3, 'DE LA TORRE AUGUSTO PATRICIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 20404, '2011-08-31', 718670.00, 'A'),
    (159, 1, 'ALDANA PATINO NORMAN ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2009-10-10', 201500.00, 'A'),
    (1590, 3, 'TORRES VILLAR ROBERTO ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-08-10', 329950.00, 'A'),
    (1591, 3, 'PETRULLI CARMELO MORENO', 191821112, 'CRA 25 CALLE 100', '883@yahoo.com.mx', '2011-02-03', 127591, '2011-06-20', 358180.00, 'A'),
    (1592, 3, 'MUSCO ENZO FRANCESCO GIUSEPPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-04', 801050.00, 'A'),
    (1593, 3, 'RONCUZZI CLAUDIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127134, '2011-10-02', 930700.00, 'A'),
    (1594, 3, 'VELANI FRANCESCA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 199862, '2011-08-22', 250360.00, 'A'),
    (1596, 3, 'BENARROCH ASSOR DAVID ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-10-06', 547310.00, 'A'),
    (1597, 3, 'FLO VILLASECA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-05-27', 357520.00, 'A'),
    (1598, 3, 'FONT RIBAS ANTONI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196117, '2011-09-21', 145660.00, 'A'),
    (1599, 3, 'LOPEZ BARAHONA MONICA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-08-03', 655740.00, 'A'),
    (16, 1, 'FLOREZ PEREZ GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132572, '2011-03-30', 956370.00, 'A'),
    (160, 1, 'GIRALDO MENDIVELSO MARTIN EDISSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-14', 429010.00, 'A'),
    (1600, 3, 'SCATTIATI ALDO ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 215245, '2011-07-10', 841730.00, 'A'),
    (1601, 3, 'MARONE CARLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 101179, '2011-06-14', 241420.00, 'A'),
    (1602, 3, 'CHUVASHEVA ELENA ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 190393, '2011-08-21', 681900.00, 'A'),
    (1603, 3, 'GIGLIO FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 122035, '2011-09-19', 685250.00, 'A'),
    (1604, 3, 'JUSTO AMATE AGUSTIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 174598, '2011-05-16', 380560.00, 'A'),
    (1605, 3, 'GUARDABASSI FABIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 281044, '2011-07-26', 847060.00, 'A'),
    (1606, 3, 'CALABRETTA FRAMCESCO ANTONIO MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 199862, '2011-08-22', 93590.00, 'A'),
    (1607, 3, 'TARTARINI MASSIMO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196234, '2011-05-10', 926800.00, 'A'),
    (1608, 3, 'BOTTI GIAIME', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 231989, '2011-04-04', 353210.00, 'A'),
    (1610, 3, 'PILERI ANDREA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 205040, '2011-09-01', 868590.00, 'A'),
    (1612, 3, 'MARTIN GRACIA LUIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-07-27', 324320.00, 'A'),
    (1613, 3, 'GRACIA MARTIN LUIS', 191821112, 'CRA 25 CALLE 100', '579@facebook.com', '2011-02-03', 198248, '2011-08-24', 463560.00, 'A'),
    (1614, 3, 'SERRAT SESE JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-05-16', 344840.00, 'A'),
    (1615, 3, 'DEL LAGO AMPELIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-06-29', 333510.00, 'A'),
    (1616, 3, 'PERUGORRIA RODRIGUEZ JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 148511, '2011-06-06', 633040.00, 'A'),
    (1617, 3, 'GIRAL CALVO IGNACIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-09-19', 164670.00, 'A'),
    (1618, 3, 'ALONSO CEBRIAN JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '253@terra.com.co', '2011-02-03', 188640, '2011-03-23', 924240.00, 'A'),
    (162, 1, 'ARIZA PINEDA JOHN ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-11-27', 415710.00, 'A'),
    (1620, 3, 'OLMEDO CARDENETE DOMINGO MIGUEL', 191821112, 'CRA 25 CALLE 100', '608@terra.com.co', '2011-02-03', 135397, '2011-09-03', 863200.00, 'A'),
    (1622, 3, 'GIMENEZ BALDRES ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 182860, '2011-05-12', 82660.00, 'A'),
    (1623, 3, 'NUNEZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-05-23', 609950.00, 'A'),
    (1624, 3, 'PENATE CASTRO WENCESLAO LORENZO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 153607, '2011-09-13', 801750.00, 'A'),
    (1626, 3, 'ESCODA MIGUEL JOAN JOSEP', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-07-18', 489310.00, 'A'),
    (1628, 3, 'ESTRADA CAPILLA ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-26', 81180.00, 'A'),
    (163, 1, 'PERDOMO LOPEZ ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-05', 456910.00, 'A'),
    (1630, 3, 'SUBIRAIS MARIANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-09-08', 138700.00, 'A'),
    (1632, 3, 'ENSENAT VELASCO JAIME LUIS', 191821112, 'CRA 25 CALLE 100', '687@gmail.com', '2011-02-03', 188640, '2011-04-12', 904560.00, 'A'),
    (1633, 3, 'DIEZ POLANCO CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-05-24', 530410.00, 'A'),
    (1636, 3, 'CUADRA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-09-04', 688400.00, 'A'),
    (1637, 3, 'UBRIC MUNOZ RAUL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 98790, '2011-05-30', 139830.00, 'A'),
    ('CELL4159', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1638, 3, 'NEDDERMANN GUJO RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-31', 633990.00, 'A'),
    (1639, 3, 'RENEDO ZALBA JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-03-13', 750430.00, 'A'),
    (164, 1, 'JIMENEZ PADILLA JOHAN MARCEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-05', 37430.00, 'A'),
    (1640, 3, 'FERNANDEZ MORENO DAVID', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-05-28', 850180.00, 'A'),
    (1641, 3, 'VERGARA SERRANO JUAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-06-30', 999620.00, 'A'),
    (1642, 3, 'MARTINEZ HUESO LUCAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 182860, '2011-06-29', 447570.00, 'A'),
    (1643, 3, 'FRANCO POBLET JUAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-10-03', 238990.00, 'A'),
    (1644, 3, 'MORA HIDALGO MIGUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-06', 852250.00, 'A'),
    (1645, 3, 'GARCIA COSO EMILIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-09-14', 544260.00, 'A'),
    (1646, 3, 'GIMENO ESCRIG ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 180124, '2011-09-20', 164580.00, 'A'),
    (1647, 3, 'MORCILLO LOPEZ RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127538, '2011-04-16', 190090.00, 'A'),
    (1648, 3, 'RUBIO BONET MANUEL', 191821112, 'CRA 25 CALLE 100', '252@facebook.com', '2011-02-03', 196234, '2011-05-25', 456740.00, 'A'),
    (1649, 3, 'PRADO ABUIN FERNANDO ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-07-16', 713400.00, 'A'),
    (165, 1, 'RAMIREZ PALMA LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-10', 816420.00, 'A'),
    (1650, 3, 'DE VEGA PUJOL GEMA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-08-01', 196780.00, 'A'),
    (1651, 3, 'IBARGUEN ALFREDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2010-12-03', 843720.00, 'A'),
    (1652, 3, 'IBARGUEN ALFREDO', 191821112, 'CRA 25 CALLE 100', '856@hotmail.com', '2011-02-03', 188640, '2011-06-18', 628250.00, 'A'),
    (1654, 3, 'MATELLANES RODRIGUEZ NURIA PILAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-10-05', 165770.00, 'A'),
    (1656, 3, 'VIDAURRAZAGA GUISOLA JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2011-08-08', 495320.00, 'A'),
    (1658, 3, 'GOMEZ ULLATE MARIA ELENA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-04-12', 919090.00, 'A'),
    (1659, 3, 'ALCAIDE ALONSO JUAN MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-05-02', 152430.00, 'A'),
    (166, 1, 'TUSTANOSKI RODOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-12-03', 969790.00, 'A'),
    (1660, 3, 'LARROY GARCIA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-14', 4900.00, 'A'),
    (1661, 3, 'FERNANDEZ POYATO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-10', 567180.00, 'A'),
    (1662, 3, 'TREVEJO PARDO JULIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-25', 821200.00, 'A'),
    (1663, 3, 'GORGA CASSINELLI VICTOR DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-30', 404490.00, 'A'),
    (1664, 3, 'MORUECO GONZALEZ JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-10-09', 558820.00, 'A'),
    (1665, 3, 'IRURETA FERNANDEZ PEDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 214283, '2011-09-14', 580650.00, 'A'),
    (1667, 3, 'TREVEJO PARDO JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-25', 392020.00, 'A'),
    (1668, 3, 'BOCOS NUNEZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-10-08', 279710.00, 'A'),
    (1669, 3, 'LUIS CASTILLO JOSE AGUSTIN', 191821112, 'CRA 25 CALLE 100', '557@hotmail.es', '2011-02-03', 168202, '2011-06-16', 222500.00, 'A'),
    (167, 1, 'HURTADO BELALCAZAR JOHN JADY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127300, '2011-08-17', 399710.00, 'A'),
    (1670, 3, 'REDONDO GUTIERREZ EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-09-14', 273350.00, 'A'),
    (1671, 3, 'MADARIAGA ALONSO RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-07-26', 699240.00, 'A'),
    (1673, 3, 'REY GONZALEZ LUIS JAVIER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-07-26', 283190.00, 'A'),
    (1676, 3, 'PEREZ ESTER ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-10-03', 274900.00, 'A'),
    (1677, 3, 'GOMEZ-GRACIA HUERTA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-22', 112260.00, 'A'),
    (1678, 3, 'DAMASO PUENTE DIEGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-25', 736600.00, 'A'),
    (168, 1, 'JUAN PABLO MARTINEZ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-15', 89160.00, 'A'),
    (1680, 3, 'DIEZ GONZALEZ LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-05-17', 521280.00, 'A'),
    (1681, 3, 'LOPEZ LOPEZ JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '853@yahoo.com', '2011-02-03', 196234, '2010-12-13', 567760.00, 'A'),
    (1682, 3, 'MIRO LINARES FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133442, '2011-09-03', 274930.00, 'A'),
    (1683, 3, 'ROCA PINTADO MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-05-16', 671410.00, 'A'),
    (1684, 3, 'GARCIA BARTOLOME HORACIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-09-29', 532220.00, 'A'),
    (1686, 3, 'BALMASEDA DE AHUMADA DIEZ JUAN LUIS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 168202, '2011-04-13', 637860.00, 'A'),
    (1687, 3, 'FERNANDEZ IMAZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-04-10', 248580.00, 'A'),
    (1688, 3, 'ELIAS CASTELLS FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-19', 329300.00, 'A'),
    (1689, 3, 'ANIDO DIAZ DANIEL', 191821112, 'CRA 25 CALLE 100', '491@gmail.com', '2011-02-03', 188640, '2011-04-04', 900780.00, 'A'),
    (1691, 3, 'GATELL ARIMONT MARIA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-09-17', 877700.00, 'A'),
    (1692, 3, 'RIVERA MUNOZ ADONI', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 211705, '2011-04-05', 840470.00, 'A'),
    (1693, 3, 'LUNA LOPEZ ALICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-10-01', 569270.00, 'A'),
    (1695, 3, 'HAMMOND ANN ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118021, '2011-05-17', 916770.00, 'A'),
    (1698, 3, 'RODRIGUEZ PARAJA MARIA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-15', 649080.00, 'A'),
    (1699, 3, 'RUIZ DIAZ JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-06-24', 359540.00, 'A'),
    (17, 1, 'SUAREZ CUEVAS FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129499, '2011-08-31', 149640.00, 'A'),
    (170, 1, 'MARROQUIN AVILA FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-04', 965840.00, 'A'),
    (1700, 3, 'BACCHELLI ORTEGA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126180, '2011-06-07', 850450.00, 'A'),
    (1701, 3, 'IGLESIAS JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2010-09-14', 173630.00, 'A'),
    (1702, 3, 'GUTIEZ CUEVAS JULIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2010-09-07', 316800.00, 'A'),
    ('CELL4183', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1704, 3, 'CALDEIRO ZAMORA JESUS CARMELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-09', 365230.00, 'A'),
    (1705, 3, 'ARBONA ABASCAL MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-02-27', 636760.00, 'A'),
    (1706, 3, 'COHEN AMAR MOISES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196766, '2011-05-20', 88120.00, 'A'),
    (1708, 3, 'FERNANDEZ COBOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2010-11-09', 387220.00, 'A'),
    (1709, 3, 'CANAL VIVES JOAQUIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 196234, '2011-09-27', 345150.00, 'A'),
    (171, 1, 'LADINO MORENO JAVIER ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-25', 89230.00, 'A'),
    (1710, 5, 'GARCIA BERTRAND HECTOR', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-04-07', 564100.00, 'A'),
    (1711, 1, 'CONSTANZA MARIN ESCOBAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127799, '2011-03-24', 785060.00, 'A'),
    (1712, 1, 'NUNEZ BATALLA FAUSTINO JORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-26', 232970.00, 'A'),
    (1713, 3, 'VILORA LAZARO ERICK MARTIN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-26', 809690.00, 'A'),
    (1715, 3, 'ELLIOT EDWARD JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-26', 318660.00, 'A'),
    (1716, 3, 'ALCALDE ORTENO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2011-07-23', 544650.00, 'A'),
    (1717, 3, 'CIARAVELLA STEFANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 231989, '2011-06-13', 767260.00, 'A'),
    (1718, 3, 'URRA GONZALEZ PEDRO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-05-02', 202370.00, 'A'),
    (172, 1, 'GUERRERO ERNESTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-15', 548610.00, 'A'),
    (1720, 3, 'JIMENEZ RODRIGUEZ ANNET', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-05-25', 943140.00, 'A'),
    (1721, 3, 'LESCAY CASTELLANOS ARNALDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-14', 585570.00, 'A'),
    (1722, 3, 'OCHOA AGUILAR ELIADES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-25', 98410.00, 'A'),
    (1723, 3, 'RODRIGUEZ NUNES JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-25', 735340.00, 'A'),
    (1724, 3, 'OCHOA BUSTAMANTE ELIADES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-25', 381480.00, 'A'),
    (1725, 3, 'MARTINEZ NIEVES JOSE ANGEL', 191821112, 'CRA 25 CALLE 100', '919@yahoo.es', '2011-02-03', 127591, '2011-05-25', 701360.00, 'A'),
    (1727, 3, 'DRAGONI ALAIN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-25', 707850.00, 'A'),
    (1728, 3, 'FERNANDEZ LOPEZ MARCOS ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-25', 452090.00, 'A'),
    (1729, 3, 'MATURELL ROMERO JORGE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-25', 136880.00, 'A'),
    (173, 1, 'RUIZ CEBALLOS ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-04', 475380.00, 'A'),
    (1730, 3, 'LARA CASTELLANO LENNIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-25', 328150.00, 'A'),
    (1731, 3, 'GRAHAM CRISTOPHER DRAKE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 203079, '2011-06-27', 230120.00, 'A'),
    (1732, 3, 'TORRE LUCA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-05-11', 166120.00, 'A'),
    (1733, 3, 'OCHOA HIDALGO EGLIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-25', 140250.00, 'A'),
    (1734, 3, 'LOURERIO DELACROIX FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116511, '2011-09-28', 202900.00, 'A'),
    (1736, 3, 'LEVIN FIORELLI ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116366, '2011-08-07', 360110.00, 'A'),
    (1739, 3, 'BERRY R ALBERT', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 216125, '2011-08-16', 22170.00, 'A'),
    (174, 1, 'NIETO PARRA SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-05-11', 731040.00, 'A'),
    (1740, 3, 'MARSHALL ROBERT SHEPARD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 150159, '2011-03-09', 62860.00, 'A'),
    (1741, 3, 'HENANDEZ ROY CHRISTOPHER JOHN PATRICK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 179614, '2011-09-26', 247780.00, 'A'),
    (1742, 3, 'LANDRY GUILLAUME', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 232263, '2011-04-27', 50330.00, 'A'),
    (1743, 3, 'VUCETIC ZELJKO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 232263, '2011-07-25', 508320.00, 'A'),
    (1744, 3, 'DE JUANA CELASCO MARIA DEL CARMEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-04-16', 390620.00, 'A'),
    (1745, 3, 'LABONTE RONALD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 269033, '2011-09-28', 428120.00, 'A'),
    (1746, 3, 'NEWMAN PHILIP MARK', 191821112, 'CRA 25 CALLE 100', '557@gmail.com', '2011-02-03', 231373, '2011-07-25', 968750.00, 'A'),
    (1747, 3, 'GRENIER MARIE PIERRE ', 191821112, 'CRA 25 CALLE 100', '409@facebook.com', '2011-02-03', 244158, '2011-07-03', 559370.00, 'A'),
    (1749, 3, 'SHINDER GARY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 244158, '2011-07-25', 775000.00, 'A'),
    (175, 3, 'GALLEGOS BASTIDAS CARLOS EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133211, '2011-08-10', 229090.00, 'A'),
    (1750, 3, 'LOPEZ DE GOICOCHEA ZABALA FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-13', 203120.00, 'A'),
    (1751, 3, 'CORRAL BELLON MANUEL', 191821112, 'CRA 25 CALLE 100', '538@yahoo.com', '2011-02-03', 177443, '2011-05-02', 690610.00, 'A'),
    (1752, 3, 'DE SOLA SOLVAS JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-10-02', 843700.00, 'A'),
    (1753, 3, 'GARCIA ALCALA DIAZ REGANON EVA MARIA', 191821112, 'CRA 25 CALLE 100', '398@yahoo.com', '2011-02-03', 118777, '2010-03-15', 146680.00, 'A'),
    (1754, 3, 'BIELA VILIAM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2011-08-16', 202290.00, 'A'),
    (1755, 3, 'GUIOT CANO JUAN PATRICK', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 232263, '2011-05-23', 571390.00, 'A'),
    (1756, 3, 'JIMENEZ DIAZ LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-03-27', 250100.00, 'A'),
    (1757, 3, 'FOX ELEANORE MAE', 191821112, 'CRA 25 CALLE 100', '117@yahoo.com', '2011-02-03', 190393, '2011-05-04', 536340.00, 'A'),
    (1758, 3, 'TANG VAN SON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-05-07', 931400.00, 'A'),
    (1759, 3, 'SUTTON PETER RONALD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 281673, '2011-06-01', 47960.00, 'A'),
    (176, 1, 'GOMEZ IVAN', 191821112, 'CRA 25 CALLE 100', '438@yahoo.com.mx', '2011-02-03', 127591, '2008-04-09', 952310.00, 'A'),
    (1762, 3, 'STOODY MATTHEW FRANCIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-21', 84320.00, 'A'),
    (1763, 3, 'SEIX MASO ARNAU', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150699, '2011-05-24', 168880.00, 'A'),
    (1764, 3, 'FERNANDEZ REDEL RAQUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-09-14', 591440.00, 'A'),
    (1765, 3, 'PORCAR DESCALS VICENNTE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 176745, '2011-04-24', 450580.00, 'A'),
    (1766, 3, 'PEREZ DE VILLEGAS TRILLO FIGUEROA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-05-17', 478560.00, 'A'),
    ('CELL4198', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1767, 3, 'CELDRAN DEGANO ANGEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 196234, '2011-05-17', 41040.00, 'A'),
    (1768, 3, 'TERRAGO MARI FERRAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-09-30', 769550.00, 'A'),
    (1769, 3, 'SZUCHOVSZKY GERGELY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 250256, '2011-05-23', 724630.00, 'A'),
    (177, 1, 'SEBASTIAN TORO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127443, '2011-07-14', 74270.00, 'A'),
    (1771, 3, 'TORIBIO JOSE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 226612, '2011-09-04', 398570.00, 'A'),
    (1772, 3, 'JOSE LUIS BAQUERA PEIRONCELLY', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2010-10-19', 49360.00, 'A'),
    (1773, 3, 'MADARIAGA VILLANUEVA MIGUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-04-12', 51090.00, 'A'),
    (1774, 3, 'VILLENA BORREGO ANTONIO', 191821112, 'CRA 25 CALLE 100', '830@terra.com.co', '2011-02-03', 188640, '2011-07-19', 107400.00, 'A'),
    (1776, 3, 'VILAR VILLALBA JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 180124, '2011-09-20', 596330.00, 'A'),
    (1777, 3, 'CAGIGAL ORTIZ MACARENA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 214283, '2011-09-14', 830530.00, 'A'),
    (1778, 3, 'KORBA ATTILA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 250256, '2011-09-27', 363650.00, 'A'),
    (1779, 3, 'KORBA-ELIAS BARBARA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 250256, '2011-09-27', 326670.00, 'A'),
    (178, 1, 'AMSILI COHEN HANAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-08-29', 514450.00, 'A'),
    (1780, 3, 'PINDADO GOMEZ JESUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 189053, '2011-04-26', 542400.00, 'A'),
    (1781, 3, 'IBARRONDO GOMEZ GRACIA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-09-21', 731990.00, 'A'),
    (1782, 3, 'MUNGUIRA GONZALEZ JUAN JULIAN', 191821112, 'CRA 25 CALLE 100', '54@hotmail.es', '2011-02-03', 188640, '2011-09-06', 32730.00, 'A'),
    (1784, 3, 'LANDMAN PIETER MARINUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 294861, '2011-09-22', 740260.00, 'A'),
    (1789, 3, 'SUAREZ AINARA ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-05-17', 503470.00, 'A'),
    (179, 1, 'CARO JUNCO GUIOVANNY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-03', 349420.00, 'A'),
    (1790, 3, 'MARTINEZ CHACON JOSE JOAQUIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-20', 592220.00, 'A'),
    (1792, 3, 'MENDEZ DEL RION LUCIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 120639, '2011-06-16', 476910.00, 'A'),
    (1793, 3, 'VERHULST LAMBERTUS  CORNELIA FRANCISCUS ALPHONSUS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 295420, '2011-07-04', 32410.00, 'A'),
    (1794, 3, 'YANEZ YAGUE JESUS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-07-10', 731290.00, 'A'),
    (1796, 3, 'GOMEZ ZORRILLA AMATE JOSE MARIOA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2011-07-12', 602380.00, 'A'),
    (1797, 3, 'LAIZ MORENO ENEKO', 191821112, 'CRA 25 CALLE 100', '219@gmail.com', '2011-02-03', 127591, '2011-08-05', 334150.00, 'A'),
    (1798, 3, 'MORODO RUIZ RUBEN DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-09-14', 863620.00, 'A'),
    (18, 1, 'GARZON VARGAS GUILLERMO FEDERICO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-29', 879110.00, 'A'),
    (1800, 3, 'ALFARO FAUS MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-09-14', 987410.00, 'A'),
    (1801, 3, 'MORRALLA VALLVERDU ENRIC', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 194601, '2011-07-18', 990070.00, 'A'),
    (1802, 3, 'BALBASTRE TEJEDOR JUAN VICENTE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 182860, '2011-08-24', 988120.00, 'A'),
    (1803, 3, 'MINGO REIZ FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2010-03-24', 970400.00, 'A'),
    (1804, 3, 'IRURETA FERNANDEZ JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 214283, '2011-09-10', 887630.00, 'A'),
    (1807, 3, 'NEBRO MELLADO JOSE JUAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 168996, '2011-08-15', 278540.00, 'A'),
    (1808, 3, 'ALBERQUILLA OJEDA JOSE DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-09-27', 477070.00, 'A'),
    (1809, 3, 'BUENDIA NORTE MARIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 131401, '2011-07-08', 549720.00, 'A'),
    (181, 1, 'CASTELLANOS FLORES RODRIGO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-18', 970470.00, 'A'),
    (1811, 3, 'HILBERT ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-09-08', 937830.00, 'A'),
    (1812, 3, 'GONZALES PINTO COTERILLO ADOLFO LORENZO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 214283, '2011-09-10', 736970.00, 'A'),
    (1813, 3, 'ARQUES ALVAREZ JOSE RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-04-04', 871360.00, 'A'),
    (1817, 3, 'CLAUSELL LOW ROBERTO EMILIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2011-09-28', 348770.00, 'A'),
    (1818, 3, 'BELICHON MARTINEZ JESUS ALVARO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-04-12', 327010.00, 'A'),
    (182, 1, 'GUZMAN NIETO JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-20', 241130.00, 'A'),
    (1821, 3, 'LINATI DE PUIG JORGE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 196234, '2011-05-18', 47210.00, 'A'),
    (1823, 3, 'SINBARRERA ROMA ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196234, '2011-09-08', 598380.00, 'A'),
    (1826, 2, 'JUANES GARATE BRUNO ', 191821112, 'CRA 25 CALLE 100', '301@gmail.com', '2011-02-03', 118777, '2011-08-21', 877650.00, 'A'),
    (1827, 3, 'BOLOS GIMENO ROGELIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 200247, '2010-11-28', 555470.00, 'A'),
    (1828, 3, 'ZABALA ASTIGARRAGA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2011-09-20', 144410.00, 'A'),
    (1831, 3, 'MAPELLI CAFFARENA BORJA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 172381, '2011-09-04', 58200.00, 'A'),
    (1833, 3, 'LARMONIE LESLIE MARTIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-30', 604840.00, 'A'),
    (1834, 3, 'WILLEMS ROBERT-JAN MICHAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 288531, '2011-09-05', 756530.00, 'A'),
    (1835, 3, 'ANJEMA LAURENS JAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-08-29', 968140.00, 'A'),
    (1836, 3, 'VERHULST HENRICUS LAMBERTUS MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 295420, '2011-04-03', 571100.00, 'A'),
    (1837, 3, 'PIERROT JOZEF MARIE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 288733, '2011-05-18', 951100.00, 'A'),
    (1838, 3, 'EIKELBOOM HIDDE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-02', 42210.00, 'A'),
    (1839, 3, 'TAMBINI GOMEZ DE MUNG', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 180063, '2011-04-24', 357740.00, 'A'),
    (1840, 3, 'MAGANA PEREZ GERARDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 135360, '2011-09-28', 662060.00, 'A'),
    (1841, 3, 'COURTOISIE BEYHAUT RAFAEL JUAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116366, '2011-09-05', 237070.00, 'A'),
    (1842, 3, 'ROJAS BENJAMIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-13', 199170.00, 'A'),
    (1843, 3, 'GARCIA VICENTE EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 150699, '2011-08-10', 284650.00, 'A'),
    ('CELL4291', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1844, 3, 'CESTTI LOPEZ RAFAEL GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 144215, '2011-09-27', 825750.00, 'A'),
    (1845, 3, 'URTECHO LOPEZ ARMANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 139272, '2011-09-28', 274800.00, 'A'),
    (1846, 3, 'SEGURA ESPINOZA ARMANDO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 135360, '2011-09-28', 896730.00, 'A'),
    (1847, 3, 'GONZALEZ VEGA LUIS PASTOR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 135360, '2011-05-18', 659240.00, 'A'),
    (185, 1, 'AYALA CARDENAS NELSON MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-25', 855960.00, 'A'),
    (1850, 3, 'ROTZINGER ROA KLAUS ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 116366, '2011-09-12', 444250.00, 'A'),
    (1851, 3, 'FRANCO DE LEON SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116366, '2011-04-26', 63840.00, 'A'),
    (1852, 3, 'RIVAS GAGNONI LUIS ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 135360, '2011-05-18', 986440.00, 'A'),
    (1853, 3, 'BARRETO VELASQUEZ JOEL FERNANDO', 191821112, 'CRA 25 CALLE 100', '104@hotmail.es', '2011-02-03', 116511, '2011-04-27', 740670.00, 'A'),
    (1854, 3, 'SEVILLA AMAYA ORLANDO', 191821112, 'CRA 25 CALLE 100', '264@yahoo.com', '2011-02-03', 136995, '2011-05-18', 744020.00, 'A'),
    (1855, 3, 'VALFRE BRALICH ELEONORA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116366, '2011-06-06', 498080.00, 'A'),
    (1857, 3, 'URDANETA DIAMANTES DIEGO ANDRES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-09-23', 797590.00, 'A'),
    (1858, 3, 'RAMIREZ ALVARADO ROBERT JESUS', 191821112, 'CRA 25 CALLE 100', '290@yahoo.com.mx', '2011-02-03', 127591, '2011-09-18', 212850.00, 'A'),
    (1859, 3, 'GUTTNER DENNIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-25', 671470.00, 'A'),
    (186, 1, 'CARRASCO SUESCUN ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-15', 36620.00, 'A'),
    (1861, 3, 'HEGEMANN JOACHIM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-25', 579710.00, 'A'),
    (1862, 3, 'MALCHER INGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 292243, '2011-06-23', 742060.00, 'A'),
    (1864, 3, 'HOFFMEISTER MALTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128206, '2011-09-06', 629770.00, 'A'),
    (1865, 3, 'BOHME ALEXANDRA LUCE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-14', 235260.00, 'A'),
    (1866, 3, 'HAMMAN FRANK THOMAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-13', 286980.00, 'A'),
    (1867, 3, 'GOPPERT MARKUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-09-05', 729150.00, 'A'),
    (1868, 3, 'BISCARO CAROLINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-09-16', 784790.00, 'A'),
    (1869, 3, 'MASCHAT SEBASTIAN STEPHAN ANDREAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-02-03', 736520.00, 'A'),
    (1870, 3, 'WALTHER DANIEL CLAUS PETER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-24', 328220.00, 'A'),
    (1871, 3, 'NENTWIG DANIEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 289697, '2011-02-03', 431550.00, 'A'),
    (1872, 3, 'KARUTZ ALEX', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127662, '2011-03-17', 173090.00, 'A'),
    (1875, 3, 'KAY KUNNE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 289697, '2011-03-18', 961400.00, 'A'),
    (1876, 2, 'SCHLUMPF IVANA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 245206, '2011-03-28', 802690.00, 'A'),
    (1877, 3, 'RODRIGUEZ BUSTILLO CONSUELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 139067, '2011-03-21', 129280.00, 'A'),
    (1878, 1, 'REHWALDT RICHARD ULRICH', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289697, '2009-10-25', 238320.00, 'A'),
    (1880, 3, 'FONSECA BEHRENS MANUELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150699, '2011-08-18', 303810.00, 'A'),
    (1881, 3, 'VOGEL MIRKO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-09', 107790.00, 'A'),
    (1882, 3, 'WU WEI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 289697, '2011-03-04', 627520.00, 'A'),
    (1884, 3, 'KADOLSKY ANKE SIGRID', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 289697, '2010-10-07', 188560.00, 'A'),
    (1885, 3, 'PFLUCKER PLENGE CARLOS HERNAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 239124, '2011-08-15', 500140.00, 'A'),
    (1886, 3, 'PENA LAGOS MELENIA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 935020.00, 'A'),
    (1887, 3, 'CALVANO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-05-02', 174690.00, 'A'),
    (1888, 3, 'KUHLEN LOTHAR WILHELM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 289232, '2011-08-30', 68390.00, 'A'),
    (1889, 3, 'QUIJANO RICO SOFIA VICTORIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 221939, '2011-06-13', 817890.00, 'A'),
    (189, 1, 'GOMEZ TRUJILLO SERGIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-17', 985980.00, 'A'),
    (1890, 3, 'SCHILBERZ KARIN', 191821112, 'CRA 25 CALLE 100', '405@facebook.com', '2011-02-03', 287570, '2011-06-23', 884260.00, 'A'),
    (1891, 3, 'SCHILBERZ SOPHIE CAHRLOTTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 287570, '2011-06-23', 967640.00, 'A'),
    (1892, 3, 'MOLINA MOLINA MILAGRO DE SUYAPA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 139844, '2011-07-26', 185410.00, 'A'),
    (1893, 3, 'BARRIENTOS ESCALANTE RAFAEL ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 139067, '2011-05-18', 24110.00, 'A'),
    (1895, 3, 'ENGELS FRANZBERNARD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 292243, '2011-07-01', 749430.00, 'A'),
    (1896, 3, 'FRIEDHOFF SVEN WILHEM', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 289697, '2010-10-31', 54090.00, 'A'),
    (1897, 3, 'BARTELS CHRISTIAN JOHAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-07-25', 22160.00, 'A'),
    (1898, 3, 'NILS REMMEL', 191821112, 'CRA 25 CALLE 100', '214@gmail.com', '2011-02-03', 256231, '2011-08-05', 948530.00, 'A'),
    (1899, 3, 'DR SCHEIBE MATTHIAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 252431, '2011-09-26', 676150.00, 'A'),
    (19, 1, 'RIANO ROMERO ALBERTO ELIAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-12-14', 946630.00, 'A'),
    (190, 1, 'LLOREDA ORTIZ FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-12-20', 30860.00, 'A'),
    (1900, 3, 'CARRASCO CATERIANO PEDRO', 191821112, 'CRA 25 CALLE 100', '255@hotmail.com', '2011-02-03', 286578, '2011-05-02', 535180.00, 'A'),
    (1901, 3, 'ROSENBER DIRK PETER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-29', 647450.00, 'A'),
    (1902, 3, 'LAUBACH JOHANNES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289697, '2011-05-01', 631720.00, 'A'),
    (1904, 3, 'GRUND STEFAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 256231, '2011-08-05', 185990.00, 'A'),
    (1905, 3, 'GRUND BEATE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 256231, '2011-08-05', 281280.00, 'A'),
    (1906, 3, 'CORZO PAULA MIRIANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 180063, '2011-08-02', 848400.00, 'A'),
    (1907, 3, 'OESTERHAUS CORNELIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 256231, '2011-03-16', 398170.00, 'A'),
    (1908, 1, 'JUAN SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127300, '2011-05-12', 445660.00, 'A'),
    (1909, 3, 'VAN ZIJL CHRISTIAN ANDREAS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 286785, '2011-09-24', 33800.00, 'A'),
    (191, 1, 'CASTANEDA CABALLERO JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-28', 196370.00, 'A'),
    (1910, 3, 'LORZA RUIZ MYRIAM ESPERANZA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-29', 831990.00, 'A'),
    (192, 1, 'ZEA EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-09', 889270.00, 'A'),
    (193, 1, 'VELEZ VICTOR MANUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-10-22', 857250.00, 'A'),
    (194, 1, 'ARCINIEGAS GOMEZ ISMAEL', 191821112, 'CRA 25 CALLE 100', '937@hotmail.com', '2011-02-03', 127591, '2011-05-18', 618450.00, 'A'),
    (195, 1, 'LINAREZ PEDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-12', 520470.00, 'A'),
    (1952, 3, 'BERND ERNST HEINZ SCHUNEMANN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 255673, '2011-09-04', 796820.00, 'A'),
    (1953, 3, 'BUCHNER RICHARD ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-17', 808430.00, 'A'),
    (1954, 3, 'CHO YONG BEOM', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 173192, '2011-02-07', 651670.00, 'A'),
    (1955, 3, 'BERNECKER WALTER LUDWIG', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 256231, '2011-04-03', 833080.00, 'A'),
    (1956, 3, 'SCHIERENBECK THOMAS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 256231, '2011-05-03', 210380.00, 'A'),
    (1957, 3, 'STEGMANN WOLF DIETER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-08-27', 552650.00, 'A'),
    (1958, 3, 'LEBAGE GONZALEZ VALENTINA CECILIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 131272, '2011-07-29', 132130.00, 'A'),
    (1959, 3, 'CABRERA MACCHI JOSE ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 180063, '2011-08-02', 2700.00, 'A'),
    (196, 1, 'OTERO BERNAL ALVARO ERNESTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-04-29', 747030.00, 'A'),
    (1960, 3, 'KOO BONKI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-15', 617110.00, 'A'),
    (1961, 3, 'JODJAHN DE CARVALHO BEIRAL FLAVIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-07-05', 77460.00, 'A'),
    (1963, 3, 'VIEIRA ROCHA MARQUES ELIANE TEREZINHA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118402, '2011-09-13', 447430.00, 'A'),
    (1965, 3, 'KELLEN CRISTINA GATTI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126180, '2011-07-01', 804020.00, 'A'),
    (1966, 3, 'CHAVEZ MARLON TENORIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 120773, '2011-07-25', 132310.00, 'A'),
    (1967, 3, 'SERGIO COZZI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 125750, '2011-08-28', 249500.00, 'A'),
    (1968, 3, 'REZENDE LIMA JOSE MARCIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-08-23', 850570.00, 'A'),
    (1969, 3, 'RAMOS PEDRO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118942, '2011-08-03', 504330.00, 'A'),
    (1972, 3, 'ADAMS THOMAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2011-08-11', 774000.00, 'A'),
    (1973, 3, 'WALESKA NUCINI BOGO ANDREA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-23', 859690.00, 'A'),
    (1974, 3, 'GERMANO PAULO BUNN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118439, '2011-08-30', 976440.00, 'A'),
    (1975, 3, 'CALDEIRA FILHO RUBENS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118942, '2011-07-18', 303120.00, 'A'),
    (1976, 3, 'JOSE CUSTODIO DO ALTISSIMO NETONETO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 119814, '2011-09-08', 586290.00, 'A'),
    (1977, 3, 'GAMAS MARIA CRISTINA ALVES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-09-19', 22070.00, 'A'),
    (1979, 3, 'PORTO WEBER FERREIRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-07', 691340.00, 'A'),
    (1980, 3, 'FONSECA LAURO PINTO', 191821112, 'CRA 25 CALLE 100', '104@hotmail.es', '2011-02-03', 127591, '2011-08-16', 402140.00, 'A'),
    (1981, 3, 'DUARTE ELENA CECILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-06-15', 936710.00, 'A'),
    (1983, 3, 'CECHINEL CRISTIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118942, '2011-06-12', 575530.00, 'A'),
    (1984, 3, 'BATISTA PINHERO JOAO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-04-25', 446250.00, 'A'),
    (1987, 1, 'ISRAEL JOSE MAXWELL', 191821112, 'CRA 25 CALLE 100', '936@gmail.com', '2011-02-03', 125894, '2011-07-04', 408350.00, 'A'),
    (1988, 3, 'BATISTA CARVALHO RODRIGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118864, '2011-09-19', 488410.00, 'A'),
    (1989, 3, 'RENO DA SILVEIRA EDNEIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118867, '2011-05-03', 216990.00, 'A'),
    (199, 1, 'BASTO CORREA FERNANDO ANTONIO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-21', 616860.00, 'A'),
    (1990, 3, 'SEIDLER KOHNERT G TEIXEIRA CHRISTINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 119814, '2011-08-23', 619730.00, 'A'),
    (1992, 3, 'GUIMARAES COSTA LEONARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-04-20', 379090.00, 'A'),
    (1993, 3, 'BOTTA RODRIGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2011-09-16', 552510.00, 'A'),
    (1994, 3, 'ARAUJO DA SILVA MARCELO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 125666, '2011-08-03', 625260.00, 'A'),
    (1995, 3, 'DA SILVA FELIPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118864, '2011-04-14', 468760.00, 'A'),
    (1996, 3, 'MANFIO RODRIGUEZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '974@yahoo.com', '2011-02-03', 118777, '2011-03-23', 468040.00, 'A'),
    (1997, 3, 'NEIVA MORENO DE SOUZA CRISTIANE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-09-24', 933900.00, 'A'),
    (2, 3, 'CHEEVER MICHAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-04', 560090.00, 'I'),
    (2000, 3, 'ROCHA GUSTAVO ADRIANO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118288, '2011-07-25', 830340.00, 'A'),
    (2001, 3, 'DE ANDRADE CARVALHO VIRGINIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-08-11', 575760.00, 'A'),
    (2002, 3, 'CAVALCANTI PIERECK GUILHERME', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 180063, '2011-08-01', 387770.00, 'A'),
    (2004, 3, 'HOEGEMANN RAMOS CARLOS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-04', 894550.00, 'A'),
    (201, 1, 'LUIS FERNANDO AREVALO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-17', 156730.00, 'A'),
    (2010, 3, 'GOMES BUCHALA JORGE FERNANDO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-09-23', 314800.00, 'A'),
    (2011, 3, 'MARTINS SIMAIKA CATIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-06-01', 155020.00, 'A'),
    (2012, 3, 'MONICA CASECA BUENO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-05-16', 830710.00, 'A'),
    (2013, 3, 'ALBERTAL MARCELO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118000, '2010-09-10', 688480.00, 'A'),
    (2015, 3, 'GOMES CANTARELLI JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118761, '2011-01-11', 685940.00, 'A'),
    (2016, 3, 'CADETTI GARBELLINI ENILICE CRISTINA ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-11', 578870.00, 'A'),
    (2017, 3, 'SPIELKAMP KLAUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 150699, '2011-03-28', 836540.00, 'A'),
    (2019, 3, 'GARES HENRI PHILIPPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 135190, '2011-04-05', 720730.00, 'A'),
    ('CELL4308', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (202, 1, 'LUCIO CHAUSTRE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-19', 179240.00, 'A'),
    (2023, 3, 'GRECO DE RESENDELUIZ ALFREDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 119814, '2011-04-25', 647940.00, 'A'),
    (2024, 3, 'CORTINA EVANDRO JOAO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118922, '2011-05-12', 153970.00, 'A'),
    (2026, 3, 'BASQUES MOURA GERALDO CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 119814, '2011-09-07', 668250.00, 'A'),
    (2027, 3, 'DA SILVA VALDECIR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-23', 863150.00, 'A'),
    (2028, 3, 'CHI MOW YUNG IVAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-21', 311000.00, 'A'),
    (2029, 3, 'YUNG MYRA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-21', 965570.00, 'A'),
    (2030, 3, 'MARTINS RAMALHO PATRICIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-03-23', 894830.00, 'A'),
    (2031, 3, 'DE LEMOS RIBEIRO GILBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118951, '2011-07-29', 577430.00, 'A'),
    (2032, 3, 'AIROLDI CLAUDIO', 191821112, 'CRA 25 CALLE 100', '973@terra.com.co', '2011-02-03', 127591, '2011-09-28', 202650.00, 'A'),
    (2033, 3, 'ARRUDA MENDES HEILMANN IONE TEREZA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 120773, '2011-09-07', 280990.00, 'A'),
    (2034, 3, 'TAVARES DE CARVALHO EDUARDO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118942, '2011-08-03', 796980.00, 'A'),
    (2036, 3, 'FERNANDES ALARCON RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-08-28', 318730.00, 'A'),
    (2037, 3, 'SUCHODOLKI SERGIO GUSMAO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 190393, '2011-07-13', 167870.00, 'A'),
    (2039, 3, 'ESTEVES MARCAL MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-02-24', 912100.00, 'A'),
    (2040, 3, 'CORSI LUIZ ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-03-25', 911080.00, 'A'),
    (2041, 3, 'LOPEZ MONICA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118795, '2011-05-03', 819090.00, 'A'),
    (2042, 3, 'QUINTANILHA LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-16', 362230.00, 'A'),
    (2043, 3, 'DE CARLI BRUNO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-05-03', 353890.00, 'A'),
    (2045, 3, 'MARINO FRANCA MARILIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-07-04', 352060.00, 'A'),
    (2048, 3, 'VOIGT ALPHONSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118439, '2010-11-22', 384150.00, 'A'),
    (2049, 3, 'ALENCAR ARIMA TATIANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-05-23', 408590.00, 'A'),
    (2050, 3, 'LINIS DE ALMEIDA NEILSON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 125666, '2011-08-03', 890480.00, 'A'),
    (2051, 3, 'PINHEIRO DE CASTRO BENETI', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-08-09', 226640.00, 'A'),
    (2052, 3, 'ALVES DO LAGO HELMANN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118942, '2011-08-01', 461770.00, 'A'),
    (2053, 3, 'OLIVO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-22', 628900.00, 'A'),
    (2054, 3, 'WILLIAM DOMINGUES SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118085, '2011-08-23', 759220.00, 'A'),
    (2055, 3, 'DE SOUZA MENEZES KLEBER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-04-25', 909400.00, 'A'),
    (2056, 3, 'CABRAL NEIDE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-16', 269340.00, 'A'),
    (2057, 3, 'RODRIGUES RENATO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-06-15', 618500.00, 'A'),
    (2058, 3, 'SPADALE PEDRO JORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-08-03', 284490.00, 'A'),
    (2059, 3, 'MARTINS DE ALMEIDA GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-09-28', 566920.00, 'A'),
    (206, 1, 'TORRES HEBER MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-01-29', 643210.00, 'A'),
    (2060, 3, 'IKUNO CELINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-06-08', 981170.00, 'A'),
    (2061, 3, 'DAL BELLO FABIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129499, '2011-08-20', 205050.00, 'A'),
    (2062, 3, 'BENATES ADRIANA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-23', 81770.00, 'A'),
    (2063, 3, 'CARDOSO ALEXANDRE ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-23', 793690.00, 'A'),
    (2064, 3, 'ZANIOLO DE SOUZA CARLOS HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-09-19', 723130.00, 'A'),
    (2065, 3, 'DA SILVA LUIZ SIDNEI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-03-30', 234590.00, 'A'),
    (2066, 3, 'RUFATO DE SOUZA LUIZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-08-29', 3560.00, 'A'),
    (2067, 3, 'DE MEDEIROS LUCIANA', 191821112, 'CRA 25 CALLE 100', '994@yahoo.com.mx', '2011-02-03', 118777, '2011-09-10', 314020.00, 'A'),
    (2068, 3, 'WOLFF PIAZERA DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118255, '2011-06-15', 559430.00, 'A'),
    (2069, 3, 'DA SILVA FORTUNA MARINA CLAUDIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-09-23', 855100.00, 'A'),
    (2070, 3, 'PEREIRA BORGES LUCILA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 120773, '2011-07-26', 597210.00, 'A'),
    (2072, 3, 'PORROZZI DE ALMEIDA RENATO', 191821112, 'CRA 25 CALLE 100', '812@hotmail.es', '2011-02-03', 127591, '2011-06-13', 312120.00, 'A'),
    (2073, 3, 'KALICHSZTEINN RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-03-23', 298330.00, 'A'),
    (2074, 3, 'OCCHIALINI GUIMARAES ANA PAULA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2011-08-03', 555310.00, 'A'),
    (2075, 3, 'MAZZUCO FONTES LUIZ ROBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-05-23', 881570.00, 'A'),
    (2078, 3, 'TRAN DINH VAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 98560.00, 'A'),
    (2079, 3, 'NGUYEN THI LE YEN', 191821112, 'CRA 25 CALLE 100', '249@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 298200.00, 'A'),
    (208, 1, 'GOMEZ GONZALEZ JORGE MARIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-12', 889010.00, 'A'),
    (2080, 3, 'MILA DE LA ROCA JOHANA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-01-26', 195350.00, 'A'),
    (2081, 3, 'RODRIGUEZ DE FLORES LOURDES MARIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-16', 82120.00, 'A'),
    (2082, 3, 'FLORES PEREZ FRANCISCO GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-23', 824550.00, 'A'),
    (2083, 3, 'FRAGACHAN BETANCOUT FRANCISCO JO SE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-07-04', 876400.00, 'A'),
    (2084, 3, 'GAFARO MOLINA CARLOS JULIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-03-22', 908370.00, 'A'),
    (2085, 3, 'CACERES REYES JORGEANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-08-11', 912630.00, 'A'),
    (2086, 3, 'ALVAREZ RODRIGUEZ VICTOR ROGELIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132958, '2011-05-23', 838040.00, 'A'),
    (2087, 3, 'GARCES ALVARADO JHAGEIMA JOSEFINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2011-04-29', 452320.00, 'A'),
    ('CELL4324', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (2089, 3, 'FAVREAU CHOLLET JEAN PIERRE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132554, '2011-05-27', 380470.00, 'A'),
    (209, 1, 'CRUZ RODRIGEZ CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '316@hotmail.es', '2011-02-03', 127591, '2011-06-28', 953870.00, 'A'),
    (2090, 3, 'GARAY LLUCH URBI ALAIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-03-13', 659870.00, 'A'),
    (2091, 3, 'LETICIA LETICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-07', 157950.00, 'A'),
    (2092, 3, 'VELASQUEZ RODULFO RAMON ARISTIDES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-09-23', 810140.00, 'A'),
    (2093, 3, 'PEREZ EDGAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-06', 576850.00, 'A'),
    (2094, 3, 'PEREZ MARIELA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-07', 453840.00, 'A'),
    (2095, 3, 'PETRUZZI MANGIARANO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132958, '2011-03-27', 538650.00, 'A'),
    (2096, 3, 'LINARES GORI RICARDO RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-12', 331730.00, 'A'),
    (2097, 3, 'LAIRET OLIVEROS CAROLINE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-09-25', 42680.00, 'A'),
    (2099, 3, 'JIMENEZ GARCIA FERNANDO JOSE', 191821112, 'CRA 25 CALLE 100', '78@hotmail.es', '2011-02-03', 132958, '2011-07-21', 963110.00, 'A'),
    (21, 1, 'RUBIO ESCOBAR RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-05-21', 639240.00, 'A'),
    (2100, 3, 'ZABALA MILAGROS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-20', 160860.00, 'A'),
    (2101, 3, 'VASQUEZ CRUZ NICOLEDANIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2011-07-31', 914990.00, 'A'),
    (2102, 3, 'REYES FIGUERA RAMON ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126674, '2011-04-03', 92340.00, 'A'),
    (2104, 3, 'RAMIREZ JIMENEZ MARYLIN CAROLINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2011-06-14', 306760.00, 'A'),
    (2105, 3, 'TELLES GUILLEN INNA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-09-07', 383520.00, 'A'),
    (2106, 3, 'ALVAREZ CARMEN MARINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-07-20', 997340.00, 'A'),
    (2107, 3, 'MARTINEZ YRIGOYEN NABUCODONOSOR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-07-21', 836110.00, 'A'),
    (2108, 5, 'FERNANDEZ RUIZ IGNACIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-01', 188530.00, 'A'),
    (211, 1, 'RIVEROS GARCIA JORGE IVAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-01', 650050.00, 'A'),
    (2110, 3, 'CACERES REYES JORGE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-08-08', 606030.00, 'A'),
    (2111, 3, 'GELFI MARCOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 199862, '2011-05-17', 727190.00, 'A'),
    (2112, 3, 'CERDA CASTILLO CARMEN GLORIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-08-21', 817870.00, 'A'),
    (2113, 3, 'RANGEL FERNANDEZ LEONARDO JOSE', 191821112, 'CRA 25 CALLE 100', '856@hotmail.com', '2011-02-03', 133211, '2011-05-16', 907750.00, 'A'),
    (2114, 3, 'ROTHSCHILD VARGAS MICHAEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132165, '2011-02-05', 85170.00, 'A'),
    (2115, 3, 'RUIZ GRATEROL INGRID JOHANNA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2011-05-16', 702600.00, 'A'),
    (2116, 2, 'DEARMAS ALBERTO FERNANDO ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-07-19', 257500.00, 'A'),
    (2117, 3, 'BOSCAN ARRIETA ERICK HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-07-12', 179680.00, 'A'),
    (2118, 3, 'GUILLEN DE TELLES NENCY JOSEFINA', 191821112, 'CRA 25 CALLE 100', '56@facebook.com', '2011-02-03', 132958, '2011-09-07', 125900.00, 'A'),
    (212, 1, 'BUSTAMANTE BUSTAMANTE CARLOS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-26', 943260.00, 'A'),
    (2120, 2, 'MARK ANTHONY STUART', 191821112, 'CRA 25 CALLE 100', '661@terra.com.co', '2011-02-03', 127591, '2011-06-26', 74600.00, 'A'),
    (2122, 3, 'SCOCOZZA GIOVANNA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 190526, '2011-09-23', 284220.00, 'A'),
    (2125, 3, 'CHAVES MOLINA JULIO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132165, '2011-09-22', 295360.00, 'A'),
    (2127, 3, 'BERNARDES DE SOUZA TONIATI VIRGINIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-30', 565090.00, 'A'),
    (2129, 2, 'BRIAN DAVIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-19', 78460.00, 'A'),
    (213, 1, 'PAREJO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-11', 766120.00, 'A'),
    (2131, 3, 'DE OLIVEIRA LOPES REGINALDO LAZARO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-05', 404910.00, 'A'),
    (2132, 3, 'DE MELO MING AZEVEDO PAULO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-10-05', 440370.00, 'A'),
    (2137, 3, 'SILVA JORGE ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-05', 230570.00, 'A'),
    (214, 1, 'CADENA RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-08', 840.00, 'A'),
    (2142, 3, 'VIEIRA VEIGA PEDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-30', 85330.00, 'A'),
    (2144, 3, 'ESCRIBANO LEONARDA DEL VALLE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-03-24', 941440.00, 'A'),
    (2145, 3, 'RODRIGUEZ MENENDEZ BERNARDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 148511, '2011-08-02', 588740.00, 'A'),
    (2146, 3, 'GONZALEZ COURET DANIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 148511, '2011-08-09', 119380.00, 'A'),
    (2147, 3, 'GARCIA SOTO WILLIAM', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 135360, '2011-05-18', 830660.00, 'A'),
    (2148, 3, 'MENESES ORELLANA RICARDO TOMAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132165, '2011-06-13', 795200.00, 'A'),
    (2149, 3, 'GUEVARA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-27', 483990.00, 'A'),
    (215, 1, 'BELTRAN PINZON JUAN CARLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-08', 705860.00, 'A'),
    (2151, 2, 'LLANES GARRIDO JAVIER ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-30', 719750.00, 'A'),
    (2152, 3, 'CHAVARRIA CHAVES RAFAEL ADRIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132165, '2011-09-20', 495720.00, 'A'),
    (2153, 2, 'MILBERT ANDREASPETER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-10', 319370.00, 'A'),
    (2154, 2, 'GOMEZ SILVA LOZANO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127300, '2011-05-30', 109670.00, 'A'),
    (2156, 3, 'WINTON ROBERT DOUGLAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 115551, '2011-08-08', 622290.00, 'A'),
    (2157, 2, 'ROMERO PINA MANUEL GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-05-05', 340650.00, 'A'),
    (2158, 3, 'KARWALSKI MATTHEW REECE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117229, '2011-08-29', 836380.00, 'A'),
    (2159, 2, 'KIM JUNG SIK ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-08', 159950.00, 'A'),
    (216, 1, 'MARTINEZ VALBUENA JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-25', 526750.00, 'A'),
    (2160, 3, 'AGAR ROBERT ALEXANDER', 191821112, 'CRA 25 CALLE 100', '81@hotmail.es', '2011-02-03', 116862, '2011-06-11', 290620.00, 'A'),
    (2161, 3, 'IGLESIAS EDGAR ALEXIS', 191821112, 'CRA 25 CALLE 100', '645@facebook.com', '2011-02-03', 131272, '2011-04-04', 973240.00, 'A'),
    (2163, 2, 'NOAIN MORENO CECILIA KARIM ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-22', 51950.00, 'A'),
    (2164, 2, 'FIGUEROA HEBEL ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-26', 276760.00, 'A'),
    (2166, 5, 'FRANDBERG DAN RICHARD VERNER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 134022, '2011-04-06', 309480.00, 'A'),
    (2168, 2, 'CONTRERAS LILLO EDUARDO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-27', 389320.00, 'A'),
    (2169, 2, 'BLANCO VALLE RICARDO ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-07-13', 355950.00, 'A'),
    (2171, 2, 'BELTRAN ZAVALA JIMI ALFONSO MIGUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126674, '2011-08-22', 991000.00, 'A'),
    (2172, 2, 'RAMIRO OREGUI JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-04-27', 119700.00, 'A'),
    (2175, 2, 'FENG PUYO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 302172, '2011-10-07', 965660.00, 'A'),
    (2176, 3, 'CLERICI GUIDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 116366, '2011-08-30', 522970.00, 'A'),
    (2177, 1, 'SEIJAS GUNTER LUIS MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-02', 717890.00, 'A'),
    (2178, 2, 'SHOSHANI MOSHE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-13', 20520.00, 'A'),
    (218, 3, 'HUCHICHALEO ARSENDIGA FRANCISCA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-05', 690.00, 'A'),
    (2181, 2, 'DOMINGO BARTOLOME LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '173@terra.com.co', '2011-02-03', 127591, '2011-04-18', 569030.00, 'A'),
    (2182, 3, 'GONZALEZ RIJO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-10-02', 795610.00, 'A'),
    (2183, 2, 'ANDROVICH MORENO LIZETH LILIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127300, '2011-10-10', 270970.00, 'A'),
    (2184, 2, 'ARREAZA LUGO JESUS ALFREDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-08', 968030.00, 'A'),
    (2185, 2, 'NAVEDA CANELON KATHERINE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132775, '2011-09-14', 27250.00, 'A'),
    (2189, 2, 'LUGO BEHRENS DENISE SOFIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-08', 253980.00, 'A'),
    (2190, 2, 'ERICA ROSE MOLDENHAUVER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-25', 175480.00, 'A'),
    (2192, 2, 'SOLORZANO GARCIA ANDREINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-25', 50790.00, 'A'),
    (2193, 3, 'DE LA COSTE MARIA CAROLINA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-26', 907640.00, 'A'),
    (2194, 2, 'MARTINEZ DIAZ JUAN JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-08', 385810.00, 'A'),
    (2195, 2, 'GALARRAGA ECHEVERRIA DAYEN ALI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-13', 206150.00, 'A'),
    (2196, 2, 'GUTIERREZ RAMIREZ HECTOR JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133211, '2011-06-07', 873330.00, 'A'),
    (2197, 2, 'LOPEZ GONZALEZ SILVIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127662, '2011-09-01', 748170.00, 'A'),
    (2198, 2, 'SEGARES LUTZ JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-07', 120880.00, 'A'),
    (2199, 2, 'NADER MARTIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127538, '2011-08-12', 359880.00, 'A'),
    (22, 1, 'CARDOZO AMAYA JORGE HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-25', 908720.00, 'A'),
    (2200, 3, 'NATERA BERMUDEZ OSWALDO JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-10-18', 436740.00, 'A'),
    (2201, 2, 'COSTA RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 150699, '2011-09-01', 104090.00, 'A'),
    (2202, 5, 'GRUNDY VALENZUELA ALAN PATRICK', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-08', 210230.00, 'A'),
    (2203, 2, 'MONTENEGRO DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-26', 738890.00, 'A'),
    (2204, 2, 'TAMAI BUNGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-24', 63730.00, 'A'),
    (2205, 5, 'VINHAS FORTUNA EDSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-09-23', 102010.00, 'A'),
    (2206, 2, 'RUIZ ERBS MARIO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-07-19', 318860.00, 'A'),
    (2207, 2, 'VENTURA TINEO MARCEL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-08', 288240.00, 'A'),
    (2210, 2, 'RAMIREZ GUZMAN RICARDO JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-28', 338740.00, 'A'),
    (2211, 2, 'STERNBERG GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2011-09-04', 18070.00, 'A'),
    (2212, 2, 'MARTELLO ALEJOS ROGER ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127443, '2011-06-20', 74120.00, 'A'),
    (2213, 2, 'CASTANEDA RAFAEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-25', 316410.00, 'A'),
    (2214, 2, 'LIMON MARTINEZ WILBERT DE JESUS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128904, '2011-09-19', 359690.00, 'A'),
    (2215, 2, 'PEREZ HERNANDEZ MONICA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133211, '2011-05-23', 849240.00, 'A'),
    (2216, 2, 'AWAD LOBATO RICARDO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '853@hotmail.com', '2011-02-03', 127591, '2011-04-12', 167100.00, 'A'),
    (2217, 2, 'CEPEDA VANEGAS ENDER ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-08-22', 287770.00, 'A'),
    (2218, 2, 'PEREZ CHIQUIN HECTOR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132572, '2011-04-13', 937580.00, 'A'),
    (2220, 5, 'FRANCO DELGADILLO RONALD FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132775, '2011-09-16', 310190.00, 'A'),
    (2222, 2, 'ALCAIDE ALONSO JUAN MIGUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-02', 455360.00, 'A'),
    (2223, 3, 'BROWNING BENJAMIN MARK', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-09', 45230.00, 'A'),
    (2225, 3, 'HARWOO BENJAMIN JOEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-09', 164620.00, 'A'),
    (2226, 3, 'HOEY TIMOTHY ROSS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-09', 242910.00, 'A'),
    (2227, 3, 'FERGUSON GARRY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-28', 720700.00, 'A'),
    (2228, 3, 'NORMAN NEVILLE ROBERT', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 288493, '2011-06-29', 874750.00, 'A'),
    (2229, 3, 'KUK HYUN CHAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-03-22', 211660.00, 'A'),
    (223, 1, 'PINZON PLAZA MARCOS VINICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-22', 856300.00, 'A'),
    (2230, 3, 'SLIPAK NATALIA ANDREA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-07-27', 434070.00, 'A'),
    (2231, 3, 'BONELLI MASSIMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 170601, '2011-07-11', 535340.00, 'A'),
    (2233, 3, 'VUYLSTEKE ALEXANDER ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 284647, '2011-09-11', 266530.00, 'A'),
    (2234, 3, 'DRESSE ALAIN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 284272, '2011-04-19', 209100.00, 'A'),
    (2235, 3, 'PAIRON JEAN LOUIS MARIE RAIMOND', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 284272, '2011-03-03', 245940.00, 'A'),
    (2236, 3, 'DEVIANE ACHIM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 284272, '2010-11-14', 602370.00, 'A'),
    (2239, 3, 'DE CANNIERE LOUIS GEORFES HELE MARIE-JOZEF', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 285511, '2011-09-11', 993540.00, 'A'),
    (2240, 1, 'ERGO ROBERT', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-28', 278270.00, 'A'),
    (2241, 3, 'MYRTES RODRIGUEZ MORGANA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-09-18', 410740.00, 'A'),
    (2242, 3, 'BRECHBUEHL   HANSRUDOLF', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 249059, '2011-07-27', 218900.00, 'A'),
    (2243, 3, 'IVANA SCHLUMPF', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 245206, '2011-04-08', 862270.00, 'A'),
    (2244, 3, 'JESSICA JACCART', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 189512, '2011-08-28', 654640.00, 'A'),
    (2246, 3, 'PAUSELLI MARIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 210050, '2011-09-26', 468090.00, 'A'),
    (2247, 3, 'VOLONTEIRO RICCARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-04-13', 281230.00, 'A'),
    (2248, 3, 'HOFFMANN ALVIR ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 120773, '2011-08-23', 1900.00, 'A'),
    (2249, 3, 'MANTOVANI DANIEL FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-08-09', 165820.00, 'A'),
    (225, 1, 'DUARTE RUEDA JAVIER ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-29', 293110.00, 'A'),
    (2250, 3, 'LIMA DA COSTA BRENO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-03-23', 823370.00, 'A'),
    (2251, 3, 'TAMBORIN MACIEL MAGALI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 619420.00, 'A'),
    (2252, 3, 'BELLO DE MUORA BIANCA', 191821112, 'CRA 25 CALLE 100', '969@gmail.com', '2011-02-03', 118942, '2011-08-03', 626970.00, 'A'),
    (2253, 3, 'VINHAS FORTUNA PIETRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2011-09-23', 276600.00, 'A'),
    (2255, 3, 'BLUMENTHAL JAIRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117630, '2011-07-20', 680590.00, 'A'),
    (2256, 3, 'DOS REIS FILHO ELPIDIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 120773, '2011-08-07', 896720.00, 'A'),
    (2257, 3, 'COIMBRA CARDOSO MUNARI FERNANDA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-09', 441830.00, 'A'),
    (2258, 3, 'LAZANHA FLAVIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118942, '2011-06-14', 519000.00, 'A'),
    (2259, 3, 'LAZANHA FLAVIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-06-14', 269480.00, 'A'),
    (226, 1, 'HUERFANO FLOREZ JOHN FAVER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-29', 148340.00, 'A'),
    (2260, 3, 'JOVETTA EDILSON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118941, '2011-09-19', 790430.00, 'A'),
    (2261, 3, 'DE OLIVEIRA ANDRE RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-07-25', 143680.00, 'A'),
    (2263, 3, 'MUNDO TEIXEIRA CARVALHO SILVIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118864, '2011-09-19', 304670.00, 'A'),
    (2264, 3, 'FERREIRA CINTRA ADRIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-04-08', 481910.00, 'A'),
    (2265, 3, 'AUGUSTO DE OLIVEIRA MARCOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118685, '2011-08-09', 495530.00, 'A'),
    (2266, 3, 'CHEN ROBERTO LUIZ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-03-15', 31920.00, 'A'),
    (2268, 3, 'WROBLESKI DIENSTMANN RAQUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117630, '2011-05-15', 269320.00, 'A'),
    (2269, 3, 'MALAGOLA GEDERSON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118864, '2011-05-30', 327540.00, 'A'),
    (227, 1, 'LOPEZ ESCOBAR CARLOS ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-06', 862360.00, 'A'),
    (2271, 3, 'GOMES EVANDRO HENRIQUE', 191821112, 'CRA 25 CALLE 100', '199@hotmail.es', '2011-02-03', 118777, '2011-03-24', 166100.00, 'A'),
    (2273, 3, 'LANDEIRA FERNANDEZ JESUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-21', 207990.00, 'A'),
    (2274, 3, 'ROSSI RENATO', 191821112, 'CRA 25 CALLE 100', '791@hotmail.es', '2011-02-03', 118777, '2011-09-19', 16170.00, 'A'),
    (2275, 3, 'CALMON RANGEL PATRICIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 456890.00, 'A'),
    (2277, 3, 'CIFU NETO ROQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-04-27', 808940.00, 'A'),
    (2278, 3, 'GONCALVES PRETO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118942, '2011-07-25', 336930.00, 'A'),
    (2279, 3, 'JORGE JUNIOR ROBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-05-09', 257840.00, 'A'),
    (2281, 3, 'ELENCIUC DEMETRIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-04-20', 618510.00, 'A'),
    (2283, 3, 'CUNHA MENDEZ RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 119855, '2011-07-18', 431190.00, 'A'),
    (2286, 3, 'DIAZ LENICE APARECIDA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-05-03', 977840.00, 'A'),
    (2288, 3, 'DE CARVALHO SIGEL TATIANA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2011-07-04', 123920.00, 'A'),
    (229, 1, 'GALARZA GIRALDO SERGIO ALDEMAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-09-17', 746930.00, 'A'),
    (2290, 3, 'ACHOA MORANDI BORGUES SIBELE MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118777, '2011-09-12', 553890.00, 'A'),
    (2291, 3, 'EPAMINONDAS DE ALMEIDA DELIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-09-22', 14080.00, 'A'),
    (2293, 3, 'REIS CASTRO SHANA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-08-03', 1430.00, 'A'),
    (2294, 3, 'BERNARDES JUNIOR ARMANDO', 191821112, 'CRA 25 CALLE 100', '678@gmail.com', '2011-02-03', 127591, '2011-08-30', 780930.00, 'A'),
    (2295, 3, 'LEMOS DE SOUZA AGUIAR SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-10-03', 900370.00, 'A'),
    (2296, 3, 'CARVALHO ADAMS KARIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2011-08-11', 159040.00, 'A'),
    (2297, 3, 'GALLINA SILVANA BRASILEIRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-23', 94110.00, 'A'),
    (23, 1, 'COLMENARES PEDREROS EDUARDO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-02', 625870.00, 'A'),
    (2300, 3, 'TAVEIRA DE SIQUEIRA TANIA APARECIDA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-24', 443910.00, 'A'),
    (2301, 3, 'DA SIVA LIMA ANDRE LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-23', 165020.00, 'A'),
    (2302, 3, 'GALVAO GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-09-12', 493370.00, 'A'),
    (2303, 3, 'DA COSTA CRUZ GABRIELA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-07-27', 971800.00, 'A'),
    (2304, 3, 'BERNHARD GOTTFRIED RABER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-04-30', 378870.00, 'A'),
    (2306, 3, 'ALDANA URIBE PABLO AXEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-05-08', 758160.00, 'A'),
    (2308, 3, 'FLORES ALONSO EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-04-26', 995310.00, 'A'),
    ('CELL4330', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (2309, 3, 'MADRIGAL MIER Y TERAN LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-02-23', 414650.00, 'A'),
    (231, 1, 'ZAPATA CEBALLOS JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127662, '2011-08-16', 430320.00, 'A'),
    (2310, 3, 'GONZALEZ ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-05-19', 87330.00, 'A'),
    (2313, 3, 'MONTES PORTO ANDREA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-09-01', 929180.00, 'A'),
    (2314, 3, 'ROCHA SUSUNAGA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2010-10-18', 541540.00, 'A'),
    (2315, 3, 'VASQUEZ CALERO FEDERICO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-22', 920160.00, 'A'),
    (2317, 3, 'GONZALEZ FERNANDEZ YUSSEN ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-26', 120530.00, 'A'),
    (2319, 3, 'ATTIAS WENGROWSKY DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150581, '2011-09-07', 8580.00, 'A'),
    (232, 1, 'OSPINA ABUCHAIBE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-07-14', 748960.00, 'A'),
    (2320, 3, 'EFRON TOPOROVSKY INES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 116511, '2011-07-15', 20810.00, 'A'),
    (2321, 3, 'LUNA PLA DARIO', 191821112, 'CRA 25 CALLE 100', '95@terra.com.co', '2011-02-03', 145135, '2011-09-07', 78320.00, 'A'),
    (2322, 1, 'VAZQUEZ DANIELA', 191821112, 'CRA 25 CALLE 100', '190@gmail.com', '2011-02-03', 145135, '2011-05-19', 329170.00, 'A'),
    (2323, 3, 'BALBI BALBI JUAN DE DIOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-08-23', 410880.00, 'A'),
    (2324, 3, 'MARROQUIN FERNANDEZ GELACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-03-23', 66880.00, 'A'),
    (2325, 3, 'VAZQUEZ ZAVALA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-04-11', 101770.00, 'A'),
    (2326, 3, 'SOTO MARTINEZ MARIA ELENA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-23', 308200.00, 'A'),
    (2328, 3, 'HERNANDEZ MURILLO RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-08-22', 253830.00, 'A'),
    (233, 1, 'HADDAD LINERO YEBRAIL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 130608, '2010-06-17', 453830.00, 'A'),
    (2330, 3, 'TERMINEL HERNANDEZ DANIELA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 190393, '2011-08-15', 48940.00, 'A'),
    (2331, 3, 'MIJARES FERNANDEZ MAGDALENA GUADALUPE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-07-31', 558440.00, 'A'),
    (2332, 3, 'GONZALEZ LUNA CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 146258, '2011-04-26', 645400.00, 'A'),
    (2333, 3, 'DIAZ TORREJON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-05-03', 551690.00, 'A'),
    (2335, 3, 'PADILLA GUTIERREZ JESUS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 456120.00, 'A'),
    (2336, 3, 'TORRES CORONA JORGE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-04-11', 813900.00, 'A'),
    (2337, 3, 'CASTRO RAMSES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150581, '2011-07-04', 701120.00, 'A'),
    (2338, 3, 'APARICIO VALLEJO RUSSELL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-03-16', 63890.00, 'A'),
    (2339, 3, 'ALBOR FERNANDEZ LUIS ARTURO', 191821112, 'CRA 25 CALLE 100', '574@gmail.com', '2011-02-03', 147467, '2011-05-09', 216110.00, 'A'),
    (234, 1, 'DOMINGUEZ GOMEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '942@hotmail.com', '2011-02-03', 127591, '2010-08-22', 22260.00, 'A'),
    (2342, 3, 'REY ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '110@facebook.com', '2011-02-03', 127591, '2011-03-04', 313330.00, 'A'),
    (2343, 3, 'MENDOZA GONZALES ADRIANA', 191821112, 'CRA 25 CALLE 100', '295@yahoo.com', '2011-02-03', 127591, '2011-03-23', 178720.00, 'A'),
    (2344, 3, 'RODRIGUEZ SEGOVIA JESUS ALONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-07-26', 953590.00, 'A'),
    (2345, 3, 'GONZALEZ PELAEZ EDUARDO DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-26', 231790.00, 'A'),
    (2347, 3, 'VILLEDA GARCIA DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 144939, '2011-05-29', 795600.00, 'A'),
    (2348, 3, 'FERRER BURGES EMILIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-04-11', 83430.00, 'A'),
    (2349, 3, 'NARRO ROBLES LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-03-16', 30330.00, 'A'),
    (2350, 3, 'ZALDIVAR UGALDE CARLOS IGNACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-06-19', 901380.00, 'A'),
    (2351, 3, 'VARGAS RODRIGUEZ VALENTE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 146258, '2011-04-26', 415910.00, 'A'),
    (2354, 3, 'DEL PIERO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-09', 19890.00, 'A'),
    (2355, 3, 'VILLAREAL ANA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-23', 211810.00, 'A'),
    (2356, 3, 'GARRIDO FERRAN JORGE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-22', 999370.00, 'A'),
    (2357, 3, 'PEREZ PRECIADO EDMUNDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-22', 361450.00, 'A'),
    (2358, 3, 'AGUIRRE VIGNAU DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150581, '2011-08-21', 809110.00, 'A'),
    (2359, 3, 'LOPEZ SESMA TOMAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 146258, '2011-09-14', 961200.00, 'A'),
    (236, 1, 'VENTO BETANCOURT LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-19', 682230.00, 'A'),
    (2360, 3, 'BERNAL MALDONADO GUILLERMO JAVIER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-09-19', 378670.00, 'A'),
    (2361, 3, 'GUZMAN DELGADO ALFREDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-22', 9770.00, 'A'),
    (2362, 3, 'GUZMAN DELGADO MARTIN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 912850.00, 'A'),
    (2363, 3, 'GUSMAND ELGADO JORGE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-22', 534910.00, 'A'),
    (2364, 3, 'RENDON BUICK JORGE JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-26', 936010.00, 'A'),
    (2365, 3, 'HERNANDEZ HERNANDEZ HERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-22', 75340.00, 'A'),
    (2366, 3, 'ALVAREZ PAZ PEDRO RAFAEL ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-01-02', 568650.00, 'A'),
    (2367, 3, 'MIJARES DE LA BARREDA FERNANDA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-07-31', 617240.00, 'A'),
    (2368, 3, 'MARTINEZ LOPEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-08-24', 380250.00, 'A'),
    (2369, 3, 'GAYTAN MILLAN YANERI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-23', 49520.00, 'A'),
    (237, 1, 'BARGUIL ASSIS DAVID ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117460, '2009-09-03', 161770.00, 'A'),
    (2370, 3, 'DURAN HEREDIA FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-04-15', 106850.00, 'A'),
    (2371, 3, 'SEGURA MIJARES CRISTOBAL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-31', 385700.00, 'A'),
    (2372, 3, 'TEPOS VALTIERRA ERIK ARTURO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116345, '2011-09-01', 607930.00, 'A'),
    (2373, 3, 'RODRIGUEZ AGUILAR EDMUNDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-05-04', 882570.00, 'A'),
    (2374, 3, 'MYSLABODSKI MICHAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-03-08', 589060.00, 'A'),
    (2375, 3, 'HERNANDEZ MIRELES JATNIEL ELIOENAI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-26', 297600.00, 'A'),
    (2376, 3, 'SNELL FERNANDEZ SYNTYHA ROCIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 720830.00, 'A'),
    (2378, 3, 'HERNANDEZ EIVET AARON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-26', 394200.00, 'A'),
    (2379, 3, 'LOPEZ GARZA JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-22', 837000.00, 'A'),
    (238, 1, 'GARCIA PINO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-10', 762140.00, 'A'),
    (2381, 3, 'TOSCANO ESTRADA RUBEN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-22', 500940.00, 'A'),
    (2382, 3, 'RAMIREZ HUDSON ROGER SILVESTER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-22', 497550.00, 'A'),
    (2383, 3, 'RAMOS JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '362@yahoo.es', '2011-02-03', 127591, '2011-08-22', 984940.00, 'A'),
    (2384, 3, 'CORTES CERVANTES ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-04-11', 432020.00, 'A'),
    (2385, 3, 'POZOS ESQUIVEL DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-27', 205310.00, 'A'),
    (2387, 3, 'ESTRADA AGUIRRE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-22', 36470.00, 'A'),
    (2388, 3, 'GARCIA RAMIREZ RAMON', 191821112, 'CRA 25 CALLE 100', '177@yahoo.es', '2011-02-03', 127591, '2011-08-22', 990910.00, 'A'),
    (2389, 3, 'PRUD HOMME GARCIA CUBAS XAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-05-18', 845140.00, 'A'),
    (239, 1, 'PINZON ARDILA GUSTAVO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-01', 325400.00, 'A'),
    (2390, 3, 'ELIZABETH OCHOA ROJAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-05-21', 252950.00, 'A'),
    (2391, 3, 'MEZA ALVAREZ JOSE ALBERTO', 191821112, 'CRA 25 CALLE 100', '646@terra.com.co', '2011-02-03', 144939, '2011-05-09', 729340.00, 'A'),
    (2392, 3, 'HERRERA REYES RENATO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2010-02-28', 887860.00, 'A'),
    (2393, 3, 'MURILLO GARIBAY GILBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-08-20', 251280.00, 'A'),
    (2394, 3, 'GARCIA JIMENEZ CARLOS MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-09', 592830.00, 'A'),
    (2395, 3, 'GUAGNELLI MARTINEZ BLANCA MONICA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145184, '2010-10-05', 210320.00, 'A'),
    (2397, 3, 'GARCIA CISNEROS RAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-07-04', 734530.00, 'A'),
    (2398, 3, 'MIRANDA ROMO FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 853340.00, 'A'),
    (24, 1, 'ARREGOCES GARZON NELSON ORLANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127783, '2011-08-12', 403190.00, 'A'),
    (240, 1, 'ARCINIEGAS GOMEZ ALBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-18', 340590.00, 'A'),
    (2400, 3, 'HERRERA ABARCA EDUARDO VICENTE ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-22', 755620.00, 'A'),
    (2403, 3, 'CASTRO MONCAYO LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-07-29', 617260.00, 'A'),
    (2404, 3, 'GUZMAN DELGADO OSBALDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-22', 56250.00, 'A'),
    (2405, 3, 'GARCIA LOPEZ DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-22', 429500.00, 'A'),
    (2406, 3, 'JIMENEZ GAMEZ RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 245206, '2011-03-23', 978720.00, 'A'),
    (2407, 3, 'BECERRA MARTINEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-08-23', 605130.00, 'A'),
    (2408, 3, 'GARCIA MARTINEZ BERNARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-22', 89480.00, 'A'),
    (2409, 3, 'URRUTIA RAYAS BALTAZAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-22', 632020.00, 'A'),
    (241, 1, 'MEDINA AGUILA NESTOR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-09', 726730.00, 'A'),
    (2411, 3, 'VERGARA MENDOZAVICTOR HUGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-06-15', 562230.00, 'A'),
    (2412, 3, 'MENDOZA MEDINA JORGE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-22', 136170.00, 'A'),
    (2413, 3, 'CORONADO CASTILLO HUGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 147529, '2011-05-09', 994160.00, 'A'),
    (2414, 3, 'GONZALEZ SOTO DELIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-03-23', 562280.00, 'A'),
    (2415, 3, 'HERNANDEZ FLORES STEPHANIE REYNA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-23', 828940.00, 'A'),
    (2416, 3, 'ABRAJAN GUERRERO MARIA DE LOS ANGELES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-23', 457860.00, 'A'),
    (2417, 3, 'HERNANDEZ LOERA ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-23', 802490.00, 'A'),
    (2418, 3, 'TARIN LOPEZ JOSE CARMEN', 191821112, 'CRA 25 CALLE 100', '117@gmail.com', '2011-02-03', 127591, '2011-03-23', 638870.00, 'A'),
    (242, 1, 'JULIO NARVAEZ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-05', 611890.00, 'A'),
    (2420, 3, 'BATTA MARQUEZ VICTOR ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-08-23', 17820.00, 'A'),
    (2423, 3, 'GONZALEZ REYES JUAN JOSE', 191821112, 'CRA 25 CALLE 100', '55@yahoo.es', '2011-02-03', 127591, '2011-07-26', 758070.00, 'A'),
    (2425, 3, 'ALVAREZ RODRIGUEZ HIRAM RAMSES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-23', 847420.00, 'A'),
    (2426, 3, 'FEMATT HERNANDEZ JESUS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-03-23', 164130.00, 'A'),
    (2427, 3, 'GUTIERRES ORTEGA FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 278410.00, 'A'),
    (2428, 3, 'JIMENEZ DIAZ JUAN JORGE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-13', 899650.00, 'A'),
    (2429, 3, 'VILLANUEVA PEREZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '656@yahoo.es', '2011-02-03', 150449, '2011-03-23', 663000.00, 'A'),
    (243, 1, 'GOMEZ REYES ANDRES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126674, '2009-12-20', 879240.00, 'A'),
    (2430, 3, 'CERON GOMEZ JOEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-03-21', 616070.00, 'A'),
    (2431, 3, 'LOPEZ LINALDI DEMETRIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-05-09', 91360.00, 'A'),
    (2432, 3, 'JOSEPH NATHAN PEDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-02', 608580.00, 'A'),
    (2433, 3, 'CARRENO PULIDO RUBEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 147242, '2011-06-19', 768810.00, 'A'),
    (2434, 3, 'AREVALO MERCADO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-06-12', 18320.00, 'A'),
    (2436, 3, 'RAMIREZ QUEZADA ERIKA BELEM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-03', 870930.00, 'A'),
    (2438, 3, 'TATTO PRIETO MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-05-19', 382740.00, 'A'),
    (2439, 3, 'LOPEZ AYALA LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-10-08', 916370.00, 'A'),
    (244, 1, 'DEVIS EDGAR JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-10-08', 560540.00, 'A'),
    (2440, 3, 'HERNANDEZ TOVAR JORGE ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 144991, '2011-10-02', 433650.00, 'A'),
    (2441, 3, 'COLLIARD LOPEZ PETER GEORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-09', 419120.00, 'A'),
    (2442, 3, 'FLORES CHALA GARY', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-22', 794670.00, 'A'),
    (2443, 3, 'FANDINO MUNOZ ZAMIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-19', 715970.00, 'A'),
    (2444, 3, 'BARROSO VARGAS DIEGO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-26', 195840.00, 'A'),
    (2446, 3, 'CRUZ RAMIREZ JUAN PEDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-07-14', 569050.00, 'A'),
    (2447, 3, 'TIJERINA ACOSTA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-26', 351280.00, 'A'),
    (2449, 3, 'JASSO BARRERA CARLOS GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-08-24', 192560.00, 'A'),
    (245, 1, 'LENCHIG KALEDA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-09-02', 165000.00, 'A'),
    (2450, 3, 'GARRIDO PATRON VICTOR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-09-27', 814970.00, 'A'),
    (2451, 3, 'VELASQUEZ GUERRERO RUBEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-20', 497150.00, 'A'),
    (2452, 3, 'CHOI SUNGKYU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 209494, '2011-08-16', 40860.00, 'A'),
    (2453, 3, 'CONTRERAS LOPEZ SERGIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-08-05', 712830.00, 'A'),
    (2454, 3, 'CHAVEZ BATAA OSCAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 150699, '2011-06-14', 441590.00, 'A'),
    (2455, 3, 'LEE JONG HYUN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131272, '2011-10-10', 69460.00, 'A'),
    (2456, 3, 'MEDINA PADILLA CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 146589, '2011-04-20', 22530.00, 'A'),
    (2457, 3, 'FLORES CUEVAS DOTNARA LUZ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-05-17', 904260.00, 'A'),
    (2458, 3, 'LIU YONGCHAO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-10-09', 453710.00, 'A'),
    (2459, 3, 'CASTRO FERNANDES PORTOCARRERO JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 195892, '2011-06-14', 555790.00, 'A'),
    (246, 1, 'YAMHURE FONSECAN ERNESTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-10-03', 143350.00, 'A'),
    (2460, 3, 'DUAN WEI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-06-22', 417820.00, 'A'),
    (2461, 3, 'ZHU XUTAO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-18', 421740.00, 'A'),
    (2462, 3, 'MEI SHUANNIU', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-09', 855240.00, 'A'),
    (2464, 3, 'VEGA VACA LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-06-08', 489110.00, 'A'),
    (2465, 3, 'TANG YUMING', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 147578, '2011-03-26', 412660.00, 'A'),
    (2466, 3, 'VILLEDA GARCIA DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 144939, '2011-06-07', 595990.00, 'A'),
    (2467, 3, 'GARCIA GARZA BLANCA ARMIDA', 191821112, 'CRA 25 CALLE 100', '927@hotmail.com', '2011-02-03', 145135, '2011-05-20', 741940.00, 'A'),
    (2468, 3, 'HERNANDEZ MARTINEZ EMILIO JOAQUIN', 191821112, 'CRA 25 CALLE 100', '356@facebook.com', '2011-02-03', 145135, '2011-06-16', 921740.00, 'A'),
    (2469, 3, 'WANG FAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 185363, '2011-08-20', 382860.00, 'A'),
    (247, 1, 'ROJAS RODRIGUEZ ALVARO HERNAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-09', 221760.00, 'A'),
    (2470, 3, 'WANG FEI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-10-09', 149100.00, 'A'),
    (2471, 3, 'BERNAL MALDONADO GUILLERMO JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118777, '2011-07-26', 596900.00, 'A'),
    (2472, 3, 'GUTIERREZ GOMEZ ARTURO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145184, '2011-07-24', 537210.00, 'A'),
    (2474, 3, 'LAN TYANYE ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-23', 865050.00, 'A'),
    (2475, 3, 'LAN SHUZHEN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-23', 639240.00, 'A'),
    (2476, 3, 'RODRIGUEZ GONZALEZ CARLOS ARTURO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 144616, '2011-08-09', 601050.00, 'A'),
    (2477, 3, 'HAIBO NI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-20', 87540.00, 'A'),
    (2479, 3, 'RUIZ RODRIGUEZ GRACIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-05-20', 910130.00, 'A'),
    (248, 1, 'GONZALEZ RODRIGUEZ ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-03', 678750.00, 'A'),
    (2480, 3, 'OROZCO MACIAS NORMA LETICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-20', 647010.00, 'A'),
    (2481, 3, 'MEZA ALVAREZ JOSE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 144939, '2011-06-07', 504670.00, 'A'),
    (2482, 3, 'RODRIGUEZ FIGUEROA RODRIGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 146308, '2011-04-27', 582290.00, 'A'),
    (2483, 3, 'CARREON GUERRA ANA CECILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 110709, '2011-05-27', 397440.00, 'A'),
    (2484, 3, 'BOTELHO BARRETO CARLOS JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 195892, '2011-08-02', 240350.00, 'A'),
    (2485, 3, 'CORONADO CASTILLO HUGO', 191821112, 'CRA 25 CALLE 100', '209@yahoo.com.mx', '2011-02-03', 147529, '2011-06-07', 9420.00, 'A'),
    (2486, 3, 'DE FUENTES GARZA MARCELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-18', 326030.00, 'A'),
    (2487, 3, 'GONZALEZ DUHART GUTIERREZ HORACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-17', 601920.00, 'A'),
    (2488, 3, 'LOPEZ LINALDI DEMETRIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-06-07', 31500.00, 'A'),
    (2489, 3, 'CASTRO MONCAYO JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-06-15', 351720.00, 'A'),
    (249, 1, 'CASTRO RIBEROS JULIAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-23', 728470.00, 'A'),
    (2490, 3, 'SERRALDE LOPEZ MARIA GUADALUPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-25', 664120.00, 'A'),
    (2491, 3, 'GARRIDO PATRON VICTOR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-09-29', 265450.00, 'A'),
    (2492, 3, 'BRAUN JUAN NICOLAS ANTONIE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-28', 334880.00, 'A'),
    (2493, 3, 'BANKA RAHUL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 141138, '2011-05-02', 878070.00, 'A'),
    (2494, 1, 'GARCIA MARTINEZ MARIA VIRGINIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-17', 385690.00, 'A'),
    (2495, 1, 'MARIA VIRGINIA', 191821112, 'CRA 25 CALLE 100', '298@yahoo.com.mx', '2011-02-03', 127591, '2011-04-16', 294220.00, 'A'),
    (2496, 3, 'GOMEZ ZENDEJAS MARIA ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145184, '2011-06-06', 314060.00, 'A'),
    (2498, 3, 'MENDEZ MARTINEZ RAUL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-07-10', 496040.00, 'A'),
    (2623, 3, 'ZAFIROPOULO ANA I', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-25', 98170.00, 'A'),
    (2499, 3, 'CARREON GUERRA ANA CECILIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-29', 417240.00, 'A'),
    (2501, 3, 'OLIVAR ARIAS ISMAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-06-06', 738850.00, 'A'),
    (2502, 3, 'ABOUMRAD NASTA EMILE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-07-26', 899890.00, 'A'),
    (2503, 3, 'RODRIGUEZ JIMENEZ ROBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-05-03', 282900.00, 'A'),
    (2504, 3, 'ESTADOS UNIDOS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-07-27', 714840.00, 'A'),
    (2505, 3, 'SOTO MUNOZ MARCO GREGORIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-26', 725480.00, 'A'),
    (2506, 3, 'GARCIA MONTER ANA OTILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-10-05', 482880.00, 'A'),
    (2507, 3, 'THIRUKONDA VIGNESH', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126180, '2011-05-02', 237950.00, 'A'),
    (2508, 3, 'RAMIREZ REATIAGA LYDA YOANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 150699, '2011-06-26', 741120.00, 'A'),
    (2509, 3, 'SEPULVEDA RODRIGUEZ JESUS ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-26', 991730.00, 'A'),
    (251, 1, 'MEJIA PIZANO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-10', 845000.00, 'A'),
    (2510, 3, 'FRANCISCO MARIA DIAS COSTA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 179111, '2011-07-12', 735330.00, 'A'),
    (2511, 3, 'TEIXEIRA REGO DE OLIVEIRA TIAGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 179111, '2011-06-14', 701430.00, 'A'),
    (2512, 3, 'PHILLIP JAMES', 191821112, 'CRA 25 CALLE 100', '766@terra.com.co', '2011-02-03', 127591, '2011-09-28', 301150.00, 'A'),
    (2513, 3, 'ERXLEBEN ROBERT', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 216125, '2011-04-13', 401460.00, 'A'),
    (2514, 3, 'HUGHES  CONNORRICHARD', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-06-22', 103880.00, 'A'),
    (2515, 3, 'LEBLANC MICHAEL PAUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 216125, '2011-08-09', 314990.00, 'A'),
    (2517, 3, 'DEVINE CHRISTOPHER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-06-22', 371560.00, 'A'),
    (2518, 3, 'WONG BRIAN TEK FUNG', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126885, '2011-09-22', 67910.00, 'A'),
    (2519, 3, 'BIDWALA IRFAN A', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 154811, '2011-03-28', 224840.00, 'A'),
    (252, 1, 'JIMENEZ LARRARTE JUAN GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-01', 406770.00, 'A'),
    (2520, 3, 'LEE HO YIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 147578, '2011-08-29', 920470.00, 'A'),
    (2521, 3, 'DE MOURA MARTINS NUNO ALEXANDRE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196094, '2011-10-09', 927850.00, 'A'),
    (2522, 3, 'DA COSTA GOMES CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 179111, '2011-08-10', 877850.00, 'A'),
    (2523, 3, 'HOOGWAERTS PAUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-02-11', 605690.00, 'A'),
    (2524, 3, 'LOPES MARQUES LUIS JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2011-09-20', 394910.00, 'A'),
    (2525, 3, 'CORREIA CAVACO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 178728, '2011-10-09', 157470.00, 'A'),
    (2526, 3, 'HALL JOHN WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-09', 602620.00, 'A'),
    (2527, 3, 'KNIGHT MARTIN GYLES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 113550, '2011-08-29', 540670.00, 'A'),
    (2528, 3, 'HINDS THMAS TRISTAN PELLEW', 191821112, 'CRA 25 CALLE 100', '337@yahoo.es', '2011-02-03', 116862, '2011-08-23', 895500.00, 'A'),
    (2529, 3, 'CARTON ALAN JOHN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-07-31', 855510.00, 'A'),
    (253, 1, 'AZCUENAGA RAMIREZ NICOLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 298472, '2011-05-10', 498840.00, 'A'),
    (2530, 3, 'GHIM CHEOLL HO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-27', 591060.00, 'A'),
    (2531, 3, 'PHILLIPS NADIA SULLIVAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-28', 388750.00, 'A'),
    (2532, 3, 'CHANG KUKHYUN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-22', 170560.00, 'A'),
    (2533, 3, 'KANG SEOUNGHYUN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 173192, '2011-08-24', 686540.00, 'A'),
    (2534, 3, 'CHUNG BYANG HOON', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 125744, '2011-03-14', 921030.00, 'A'),
    (2535, 3, 'SHIN MIN CHUL ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 173192, '2011-08-24', 545510.00, 'A'),
    (2536, 3, 'CHOI JIN SUNG', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-15', 964490.00, 'A'),
    (2537, 3, 'CHOI SUNGMIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-27', 185910.00, 'A'),
    (2538, 3, 'PARK JAESER ', 191821112, 'CRA 25 CALLE 100', '525@terra.com.co', '2011-02-03', 127591, '2011-09-03', 36090.00, 'A'),
    (2539, 3, 'KIM DAE HOON ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 173192, '2011-08-24', 622700.00, 'A'),
    (254, 1, 'AVENDANO PABON ROLANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-05-12', 273900.00, 'A'),
    (2540, 3, 'LYNN MARIA CRISTINA NORMA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116862, '2011-09-21', 5220.00, 'A'),
    (2541, 3, 'KIM CHINIL JULIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 147578, '2011-08-27', 158030.00, 'A'),
    (2543, 3, 'HALL JOHN WILLIAM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-09', 398290.00, 'A'),
    (2544, 3, 'YOSUKE PERDOMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 165600, '2011-07-26', 668040.00, 'A'),
    (2546, 3, 'AKAGI KAZAHIKO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-26', 722510.00, 'A'),
    (2547, 3, 'NELSON JONATHAN GARY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-09', 176570.00, 'A'),
    (2548, 3, 'DUONG HOP BA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 116862, '2011-09-14', 715310.00, 'A'),
    (2549, 3, 'CHAO-VILLEGAS NIKOLE TUK HING', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 180063, '2011-04-05', 46830.00, 'A'),
    (255, 1, 'CORREA ALVARO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-27', 872990.00, 'A'),
    (2551, 3, 'APPELS LAURENT BERNHARD', 191821112, 'CRA 25 CALLE 100', '891@hotmail.es', '2011-02-03', 135190, '2011-08-16', 300620.00, 'A'),
    (2552, 3, 'PLAISIER ERIK JAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289294, '2011-05-23', 238440.00, 'A'),
    (2553, 3, 'BLOK HENDRIK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 288552, '2011-03-27', 290350.00, 'A'),
    (2554, 3, 'NETTE ANNA STERRE', 191821112, 'CRA 25 CALLE 100', '621@yahoo.com.mx', '2011-02-03', 185363, '2011-07-30', 736400.00, 'A'),
    (2555, 3, 'FRIELING HANS ERIC', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 107469, '2011-07-31', 810990.00, 'A'),
    (2556, 3, 'RUTTE CORNELIA JANTINE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 143579, '2011-03-30', 845710.00, 'A'),
    (2557, 3, 'WALRAVEN PIETER PAUL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 289294, '2011-07-29', 795620.00, 'A'),
    (2558, 3, 'TREBES LAURENS JOHANNES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-11-22', 440940.00, 'A'),
    (2559, 3, 'KROESE  ROLANDWILLEBRORDUSMARIA', 191821112, 'CRA 25 CALLE 100', '188@facebook.com', '2011-02-03', 110643, '2011-06-09', 817860.00, 'A'),
    (256, 1, 'FARIAS GARCIA REINI', 191821112, 'CRA 25 CALLE 100', '615@hotmail.com', '2011-02-03', 127591, '2011-03-05', 543220.00, 'A'),
    (2560, 3, 'VAN DER HEIDE HENDRIK', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 291042, '2011-09-04', 766460.00, 'A'),
    (2561, 3, 'VAN DEN BERG DONAR ALEXANDER GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 190393, '2011-07-13', 378720.00, 'A'),
    (2562, 3, 'GODEFRIDUS JOHANNES ROPS ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127622, '2011-10-02', 594240.00, 'A'),
    (2564, 3, 'WAT YOK YIENG', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 287095, '2011-03-22', 392370.00, 'A'),
    (2565, 3, 'BUIS JACOBUS NICOLAAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-20', 456810.00, 'A'),
    (2567, 3, 'CHIPPER FRANCIUSCUS NICOLAAS ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 291599, '2011-07-28', 164300.00, 'A'),
    (2568, 3, 'ONNO ROUKENS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-11-28', 500670.00, 'A'),
    (2569, 3, 'PETRUS MARCELLINUS STEPHANUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150699, '2011-06-25', 10430.00, 'A'),
    (2571, 3, 'VAN VOLLENHOVEN IVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-08', 719370.00, 'A'),
    (2572, 3, 'LAMBOOIJ BART', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-09-20', 946480.00, 'A'),
    (2573, 3, 'LANSER MARIANA PAULINE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 289294, '2011-04-09', 574270.00, 'A'),
    (2575, 3, 'KLERKEN JOHANNES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 286101, '2011-05-24', 436840.00, 'A'),
    (2576, 3, 'KRAS JACOBUS NICOLAAS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289294, '2011-09-26', 88410.00, 'A'),
    (2577, 3, 'FUCHS MICHAEL JOSEPH', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 185363, '2011-07-30', 131530.00, 'A'),
    (2578, 3, 'BIJVANK ERIK JAN WILLEM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-11', 392410.00, 'A'),
    (2579, 3, 'SCHMIDT FRANC ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 106742, '2011-09-11', 567470.00, 'A'),
    (258, 1, 'SOTO GONZALEZ FRANCISCO LAZARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 116511, '2011-05-07', 856050.00, 'A'),
    (2580, 3, 'VAN DER KOOIJ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 291277, '2011-07-10', 660130.00, 'A'),
    (2581, 2, 'KRIS ANDRE GEORGES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-07-26', 598240.00, 'A'),
    (2582, 3, 'HARDING LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 263813, '2011-05-08', 10820.00, 'A'),
    (2583, 3, 'ROLLI GUY JEAN ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-05-31', 259370.00, 'A'),
    (2584, 3, 'NIETO PARRA SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 263813, '2011-07-04', 264400.00, 'A'),
    (2585, 3, 'LASTRA CHAVEZ PABLO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126674, '2011-05-25', 543890.00, 'A'),
    (2586, 1, 'ZAIDA MAYERLY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-05', 926250.00, 'A'),
    (2587, 1, 'OSWALDO SOLORZANO CONTRERAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-28', 999590.00, 'A'),
    (2588, 3, 'ZHOU XUAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-18', 219200.00, 'A'),
    (2589, 3, 'HUANG ZHENGQUN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-18', 97230.00, 'A'),
    (259, 1, 'GALARZA NARANJO JAIME RENE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 988830.00, 'A'),
    (2590, 3, 'HUANG ZHENQUIN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-18', 828560.00, 'A'),
    (2591, 3, 'WEIDEN MULLER AMURER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-29', 851110.00, 'A'),
    (2593, 3, 'OESTERHAUS CORNELIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 256231, '2011-03-29', 295960.00, 'A'),
    (2594, 3, 'RINTALAHTI JUHA HENRIK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 170220.00, 'A'),
    (2597, 3, 'VERWIJNEN JONAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 289697, '2011-02-03', 638040.00, 'A'),
    (2598, 3, 'SHAW ROBERT', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 157414, '2011-07-10', 273550.00, 'A'),
    (2599, 3, 'MAKINEN TIMO JUHANI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-09-13', 453600.00, 'A'),
    (260, 1, 'RIVERA CANON JOSE EDWARD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127538, '2011-09-19', 375990.00, 'A'),
    (2600, 3, 'HONKANIEMI ARTO OLAVI', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 301387, '2011-09-06', 447380.00, 'A'),
    (2601, 3, 'DAGG JAMIE MICHAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 216125, '2011-08-09', 876080.00, 'A'),
    (2602, 3, 'BOLAND PATRICK CHARLES ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 216125, '2011-09-14', 38260.00, 'A'),
    (2603, 2, 'ZULEYKA JERRYS RIVERA MENDOZA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 150347, '2011-03-27', 563050.00, 'A'),
    (2604, 3, 'DELGADO SEQUIRA FERRAO JOSE PEDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188228, '2011-08-16', 700460.00, 'A'),
    (2605, 3, 'YORRO LORA EDGAR MANUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127689, '2011-06-17', 813180.00, 'A'),
    (2606, 3, 'CARRASCO RODRIGUEZQCARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127689, '2011-06-17', 964520.00, 'A'),
    (2607, 30, 'ORJUELA VELASQUEZ JULIANA MARIA', 191821112, 'CRA 25 CALLE 100', '372@terra.com.co', '2011-02-03', 132775, '2011-09-01', 383070.00, 'A'),
    (2608, 3, 'DUQUE DUTRA LUIS EDUARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-07-12', 21780.00, 'A'),
    (261, 1, 'MURCIA MARQUEZ NESTOR JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-19', 913480.00, 'A'),
    (2610, 3, 'NGUYEN HUU KHUONG', 191821112, 'CRA 25 CALLE 100', '457@facebook.com', '2011-02-03', 132958, '2011-05-07', 733120.00, 'A'),
    (2611, 3, 'NGUYEN VAN LAP', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 786510.00, 'A'),
    (2612, 3, 'PHAM HUU THU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 733200.00, 'A'),
    (2613, 3, 'DANG MING CUONG', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-05-07', 306460.00, 'A'),
    (2614, 3, 'VU THI HONG HANH', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-05-07', 332710.00, 'A'),
    (2615, 3, 'CHAU TANG LANG', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-05-07', 744190.00, 'A'),
    (2616, 3, 'CHU BAN THING', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-05-07', 722800.00, 'A'),
    (2617, 3, 'NGUYEN QUANG THU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-05-07', 381420.00, 'A'),
    (2618, 3, 'TRAN THI KIM OANH', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-05-07', 738690.00, 'A'),
    (2619, 3, 'NGUYEN VAN VINH', 191821112, 'CRA 25 CALLE 100', '422@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 549210.00, 'A'),
    (262, 1, 'ABDULAZIS ELNESER KHALED', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-27', 439430.00, 'A'),
    (2620, 3, 'NGUYEN XUAN VY', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132958, '2011-05-07', 529950.00, 'A'),
    (2621, 3, 'HA MANH HOA', 191821112, 'CRA 25 CALLE 100', '439@gmail.com', '2011-02-03', 132958, '2011-05-07', 2160.00, 'A'),
    (2622, 3, 'ZAFIROPOULO STEVEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-25', 420930.00, 'A'),
    (2624, 3, 'TEMIGTERRA MASSIMILIANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 210050, '2011-09-26', 228070.00, 'A'),
    (2625, 3, 'CASSES TRINDADE HELGIO HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118402, '2011-09-13', 845850.00, 'A'),
    (2626, 3, 'ASCOLI MASTROENI MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 120773, '2011-09-07', 545010.00, 'A'),
    (2627, 3, 'MONTEIRO SOARES MARCOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 120773, '2011-07-18', 187530.00, 'A'),
    (2629, 3, 'HALL ALVARO AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 120773, '2011-08-02', 950450.00, 'A'),
    (2631, 3, 'ANDRADE CATUNDA RAFAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 120773, '2011-08-23', 370860.00, 'A'),
    (2632, 3, 'MAGALHAES MAYRA ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118767, '2011-08-23', 320960.00, 'A'),
    (2633, 3, 'SPREAFICO MIRIAM ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118587, '2011-08-23', 492220.00, 'A'),
    (2634, 3, 'GOMES FERREIRA HELIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 125812, '2011-08-23', 498220.00, 'A'),
    (2635, 3, 'FERNANDES SENNA PIRES SERGIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-05', 14460.00, 'A'),
    (2636, 3, 'BALESTRO FLORIANO FABIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 120773, '2011-08-24', 577630.00, 'A'),
    (2637, 3, 'CABANA DE QUEIROZ ANDRADE ALAXANDRE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-23', 844780.00, 'A'),
    (2638, 3, 'DALBOSCO CARLA', 191821112, 'CRA 25 CALLE 100', '380@yahoo.com.mx', '2011-02-03', 127591, '2011-06-30', 491010.00, 'A'),
    (264, 1, 'ROMERO MONTOYA NICOLAY ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-13', 965220.00, 'A'),
    (2640, 3, 'BILLINI CRUZ RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 144215, '2011-03-27', 130530.00, 'A'),
    (2641, 3, 'VASQUES ARIAS DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 144509, '2011-08-19', 890500.00, 'A'),
    (2642, 3, 'ROJAS VOLQUEZ GLADYS MICHELLE', 191821112, 'CRA 25 CALLE 100', '852@gmail.com', '2011-02-03', 144215, '2011-07-25', 60930.00, 'A'),
    (2643, 3, 'LLANEZA GIL JUAN RAFAELMO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 144215, '2011-07-08', 633120.00, 'A'),
    (2646, 3, 'AVILA PEROZO IANKEL JACOB', 191821112, 'CRA 25 CALLE 100', '318@hotmail.com', '2011-02-03', 144215, '2011-09-03', 125600.00, 'A'),
    (2647, 3, 'REGULAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-19', 583540.00, 'A'),
    (2648, 3, 'CORONADO BATISTA JOSE ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-19', 540910.00, 'A'),
    (2649, 3, 'OLIVIER JOSE VICTOR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 144509, '2011-08-19', 953910.00, 'A'),
    (2650, 3, 'YOO HOE TAEK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-08-25', 146820.00, 'A'),
    (266, 1, 'CUECA RODRIGUEZ CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-22', 384280.00, 'A'),
    (267, 1, 'NIETO ALVARADO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2008-04-28', 553450.00, 'A'),
    (269, 1, 'LEAL HOLGUIN FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-25', 411700.00, 'A'),
    (27, 1, 'MORENO MORENO CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2009-09-15', 995620.00, 'A'),
    (270, 1, 'CANO IBANES JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-03', 215260.00, 'A'),
    (271, 1, 'RESTREPO HERRAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132775, '2011-04-18', 841220.00, 'A'),
    (272, 3, 'RIOS FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 199862, '2011-03-24', 560300.00, 'A'),
    (273, 1, 'MADERO LORENZANA NICOLAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-03', 277850.00, 'A'),
    (274, 1, 'GOMEZ GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-09-24', 708350.00, 'A'),
    (275, 1, 'CONSUEGRA ARENAS ANDRES MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-09', 708210.00, 'A'),
    (276, 1, 'HURTADO ROJAS NICOLAS', 191821112, 'CRA 25 CALLE 100', '463@yahoo.com.mx', '2011-02-03', 127591, '2011-09-07', 416000.00, 'A'),
    (277, 1, 'MURCIA BAQUERO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-02', 955370.00, 'A'),
    (2773, 3, 'TAKUBO KAORI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 165753, '2011-05-12', 872390.00, 'A'),
    (2774, 3, 'OKADA MAKOTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 165753, '2011-06-19', 921480.00, 'A'),
    (2775, 3, 'TAKEDA AKIO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 21062, '2011-06-19', 990250.00, 'A'),
    (2776, 3, 'KOIKE WATARU ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 165753, '2011-06-19', 186800.00, 'A'),
    (2777, 3, 'KUBO SHINEI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 165753, '2011-02-13', 963230.00, 'A'),
    (2778, 3, 'KANNO YONEZO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 165600, '2011-07-26', 255770.00, 'A'),
    (278, 3, 'PARENT ELOIDE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 267980, '2011-05-01', 528840.00, 'A'),
    (2781, 3, 'SUNADA MINORU ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 165753, '2011-06-19', 724450.00, 'A'),
    (2782, 3, 'INOUE KASUYA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-22', 87150.00, 'A'),
    (2783, 3, 'OTAKE NOBUTOSHI', 191821112, 'CRA 25 CALLE 100', '208@facebook.com', '2011-02-03', 127591, '2011-06-11', 262380.00, 'A'),
    (2784, 3, 'MOTOI KEN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 165753, '2011-06-19', 50470.00, 'A'),
    (2785, 3, 'TANAKA KIYOTAKA ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 165753, '2011-06-19', 465210.00, 'A'),
    (2787, 3, 'YUMIKOPERDOMO', 191821112, 'CRA 25 CALLE 100', '600@yahoo.es', '2011-02-03', 165600, '2011-07-26', 477550.00, 'A'),
    (2788, 3, 'FUKUSHIMA KENZO', 191821112, 'CRA 25 CALLE 100', '599@gmail.com', '2011-02-03', 156960, '2011-05-30', 863860.00, 'A'),
    (2789, 3, 'GELGIN LEVENT NURI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-26', 886630.00, 'A'),
    (279, 1, 'AVIATUR S. A.', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-02', 778110.00, 'A'),
    (2791, 3, 'GELGIN ENIS ENRE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-26', 547940.00, 'A'),
    (2792, 3, 'PAZ SOTO LUBRASCA MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 143954, '2011-06-27', 215000.00, 'A'),
    (2794, 3, 'MOURAD TAOUFIKI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-13', 511000.00, 'A'),
    (2796, 3, 'DASTUS ALAIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 218656, '2011-05-29', 774010.00, 'A'),
    (2797, 3, 'MCDONALD MICHAEL LORNE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 269033, '2011-07-19', 85820.00, 'A'),
    (2799, 3, 'KLESO MICHAEL QUENTIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-07-26', 277950.00, 'A'),
    (28, 1, 'GONZALEZ ACUNA EDGAR MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-19', 531710.00, 'A'),
    (280, 3, 'NEME KARIM CHAIBAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 135967, '2010-05-02', 304040.00, 'A'),
    (2800, 3, 'CLERK CHARLES ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 244158, '2011-07-26', 68490.00, 'A'),
    ('CELL3673', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (2801, 3, 'BURRIS MAURICE STEWARD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-27', 508600.00, 'A'),
    (2802, 1, 'PINCHEN CLAIRE ELAINE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 216125, '2011-04-13', 337530.00, 'A'),
    (2803, 3, 'LETTNER EVA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 231224, '2011-09-20', 161860.00, 'A'),
    (2804, 3, 'CANUEL LUCIE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 146258, '2011-09-20', 796710.00, 'A'),
    (2805, 3, 'IGLESIAS CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 216125, '2011-08-02', 497980.00, 'A'),
    (2806, 3, 'PAQUIN JEAN FRANCOIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-03-27', 99760.00, 'A'),
    (2807, 3, 'FOURNIER DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 228688, '2011-05-19', 4860.00, 'A'),
    (2808, 3, 'BILODEAU MARTIN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-13', 725030.00, 'A'),
    (2809, 3, 'KELLNER PETER WILLIAM', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 130757, '2011-07-24', 610570.00, 'A'),
    (2810, 3, 'ZAZULAK INGRID ROSEMARIE', 191821112, 'CRA 25 CALLE 100', '683@facebook.com', '2011-02-03', 240550, '2011-09-11', 877770.00, 'A'),
    (2811, 3, 'RUCCI JHON MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 285188, '2011-05-10', 557130.00, 'A'),
    (2813, 3, 'JONCAS MARC', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 33265, '2011-03-21', 90360.00, 'A'),
    (2814, 3, 'DUCHARME ERICK', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-03-29', 994750.00, 'A'),
    (2816, 3, 'BAILLOD THOMAS DAVID ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 239124, '2010-10-20', 529130.00, 'A'),
    (2817, 3, 'MARTINEZ SORIA JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 289697, '2011-09-06', 537630.00, 'A'),
    (2818, 3, 'TAMARA RABER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-30', 100750.00, 'A'),
    (2819, 3, 'BURGI VINCENT EMANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 245206, '2011-04-20', 890860.00, 'A'),
    (282, 1, 'HUESPED ASISTENTE A LA CONVENCION DE LA DIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2009-06-24', 17160.00, 'A'),
    (2820, 3, 'ROBLES TORRALBA IVAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 238949, '2011-05-16', 152030.00, 'A'),
    (2821, 3, 'CONSUEGRA MARIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-06', 87600.00, 'A'),
    (2822, 3, 'CELMA ADROVER LAIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 190393, '2011-03-23', 981880.00, 'A'),
    (2823, 3, 'ALVAREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-06-20', 646610.00, 'A'),
    (2824, 3, 'VARGAS WOODROFFE FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 157414, '2011-06-22', 287410.00, 'A'),
    (2825, 3, 'GARCIA GUILLEN VICENTE LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 144215, '2011-08-19', 497230.00, 'A'),
    (2826, 3, 'GOMEZ GARCIA DIAMANTES PATRICIA MARIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 286785, '2011-09-22', 623930.00, 'A'),
    (2827, 3, 'PEREZ IGLESIAS BIBIANA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-09-30', 627940.00, 'A'),
    (2830, 3, 'VILLALONGA MORENES MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 169679, '2011-05-29', 474910.00, 'A'),
    (2831, 3, 'REY LOPEZ DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2011-08-03', 7380.00, 'A'),
    (2832, 3, 'HOYO APARICIO JESUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116511, '2011-09-19', 612180.00, 'A'),
    (2836, 3, 'GOMEZ GARCIA LOPEZ CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150699, '2011-09-21', 277540.00, 'A'),
    (2839, 3, 'GALIMERTI MARCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 235197, '2011-08-28', 156870.00, 'A'),
    (2840, 3, 'BAROZZI GIUSEPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 231989, '2011-05-25', 609500.00, 'A'),
    (2841, 3, 'MARIAN RENATO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-12', 576900.00, 'A'),
    (2842, 3, 'FAENZA CARLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126180, '2011-05-19', 55990.00, 'A'),
    (2843, 3, 'PESOLILLO CARMINE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 203162, '2011-06-26', 549230.00, 'A'),
    (2844, 3, 'CHIODI FRANCESCO MARIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 199862, '2011-09-10', 578210.00, 'A'),
    (2845, 3, 'RUTA MARIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-06-19', 243350.00, 'A'),
    (2846, 3, 'BAZZONI MARINO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 101518, '2011-05-03', 482140.00, 'A'),
    (2848, 3, 'LAGASIO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 231989, '2011-05-04', 956670.00, 'A'),
    (2849, 3, 'VIERA DA CUNHA PAULO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 190393, '2011-04-05', 741520.00, 'A'),
    (2850, 3, 'DAL BEN DENIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 116511, '2011-05-26', 837590.00, 'A'),
    (2851, 3, 'GIANELLI HERIBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 233927, '2011-05-01', 963400.00, 'A'),
    (2852, 3, 'JUSTINO DA SILVA DJAMIR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-08', 304200.00, 'A'),
    (2853, 3, 'DIPASQUUALE GAETANO', 191821112, 'CRA 25 CALLE 100', '574@terra.com.co', '2011-02-03', 172888, '2011-07-11', 630830.00, 'A'),
    (2855, 3, 'CURI MAURO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 199862, '2011-06-19', 315160.00, 'A'),
    (2856, 3, 'DI DIO MARCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-20', 851210.00, 'A'),
    (2857, 3, 'ROBERTI MENDONCA CAIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-11', 310580.00, 'A'),
    (2859, 3, 'RAMOS MORENO DE SOUZA ANDRE ', 191821112, 'CRA 25 CALLE 100', '133@facebook.com', '2011-02-03', 118777, '2011-09-24', 64540.00, 'A'),
    (286, 8, 'INEXMODA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-06-21', 50150.00, 'A'),
    (2860, 3, 'JODJAHN DE CARVALHO FLAVIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-06-27', 324950.00, 'A'),
    (2862, 3, 'LAGASIO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 231989, '2011-07-04', 180760.00, 'A'),
    (2863, 3, 'MOON SUNG RIUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-08', 610440.00, 'A'),
    (2865, 3, 'VAIDYANATHAN VIKRAM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-11', 718220.00, 'A'),
    (2866, 3, 'NARAYANASWAMY RAMSUNDAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 73079, '2011-10-02', 61390.00, 'A'),
    (2867, 3, 'VADADA VENKATA RAMESH KUMAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-10', 152300.00, 'A'),
    (2868, 3, 'RAMA KRISHNAN ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-10', 577300.00, 'A'),
    (2869, 3, 'JALAN PRASHANT', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 122035, '2011-05-02', 429600.00, 'A'),
    (2871, 3, 'CHANDRASEKAR VENKAT', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 112862, '2011-06-27', 791800.00, 'A'),
    (2872, 3, 'CUMBAKONAM SWAMINATHAN SUBRAMANIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-11', 710650.00, 'A'),
    (288, 8, 'BCD TRAVEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-23', 645390.00, 'A'),
    (289, 3, 'EMBAJADA ARGENTINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '1970-02-02', 749440.00, 'A'),
    ('CELL3789', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (290, 3, 'EMBAJADA DE BRASIL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-11-16', 811030.00, 'A'),
    (293, 8, 'ONU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-09-19', 584810.00, 'A'),
    (299, 1, 'BLANDON GUZMAN JHON JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-01-13', 201740.00, 'A'),
    (304, 3, 'COHEN DANIEL DYLAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 286785, '2010-11-17', 184850.00, 'A'),
    (306, 1, 'CINDU ANDINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2009-06-11', 899230.00, 'A'),
    (31, 1, 'GARRIDO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127662, '2010-09-12', 801450.00, 'A'),
    (310, 3, 'CORPORACION CLUB EL NOGAL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2010-08-27', 918760.00, 'A'),
    (314, 3, 'CHAWLA AARON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-08', 295840.00, 'A'),
    (317, 3, 'BAKER HUGHES', 191821112, 'CRA 25 CALLE 100', '694@hotmail.com', '2011-02-03', 127591, '2011-04-03', 211990.00, 'A'),
    (32, 1, 'PAEZ SEGURA JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '675@gmail.com', '2011-02-03', 129447, '2011-08-22', 717340.00, 'A'),
    (320, 1, 'MORENO PAEZ FREDDY ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-31', 971670.00, 'A'),
    (322, 1, 'CALDERON CARDOZO GASTON EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-10-05', 990640.00, 'A'),
    (324, 1, 'ARCHILA MERA ALFREDOMANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-22', 77200.00, 'A'),
    (326, 1, 'MUNOZ AVILA HERNEY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-11-10', 550920.00, 'A'),
    (327, 1, 'CHAPARRO CUBILLOS FABIAN ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-15', 685080.00, 'A'),
    (329, 1, 'GOMEZ LOPEZ JUAN SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '970@yahoo.com', '2011-02-03', 127591, '2011-03-20', 808070.00, 'A'),
    (33, 1, 'MARTINEZ MARINO HENRY HERNAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-04-20', 182370.00, 'A'),
    (330, 3, 'MAPSTONE NAOMI LEA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 122035, '2010-02-21', 722380.00, 'A'),
    (332, 3, 'ROSSI BURRI NELLY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132165, '2010-05-10', 771210.00, 'A'),
    (333, 1, 'AVELLANEDA OVIEDO JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-25', 293060.00, 'A'),
    (334, 1, 'SUZA FLOREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-13', 151650.00, 'A'),
    (335, 1, 'ESGUERRA ALVARO ANDRES', 191821112, 'CRA 25 CALLE 100', '11@facebook.com', '2011-02-03', 127591, '2011-09-10', 879080.00, 'A'),
    (337, 3, 'DE LA HARPE MARTIN CARAPET WALTER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-27', 64960.00, 'A'),
    (339, 1, 'HERNANDEZ ACOSTA SERGIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 129499, '2011-06-22', 322570.00, 'A'),
    (340, 3, 'ZARAMA DE LA ESPRIELLA MIGUEL PATRICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-27', 102360.00, 'A'),
    (342, 1, 'CABRERA VASQUEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-01', 413440.00, 'A'),
    (343, 3, 'RICHARDSON BEN MARRIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 286785, '2010-05-18', 434890.00, 'A'),
    (344, 1, 'OLARTE PINZON MIGUEL FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-30', 934140.00, 'A'),
    (345, 1, 'SOLER SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-04-20', 366020.00, 'A'),
    (346, 1, 'PRIETO JUAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-07-12', 27690.00, 'A'),
    (349, 1, 'BARRERO VELASCO DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-01', 472850.00, 'A'),
    (35, 1, 'VELASQUEZ RAMOS JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-13', 251940.00, 'A'),
    (350, 1, 'RANGEL GARCIA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-03-20', 7880.00, 'A'),
    (353, 1, 'ALVAREZ ACEVEDO JOHN FREDDY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-16', 540070.00, 'A'),
    (354, 1, 'VILLAMARIN HOME WILMAR ALFREDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-19', 458810.00, 'A'),
    (355, 3, 'SLUCHIN NAAMAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 263813, '2010-12-01', 673830.00, 'A'),
    (357, 1, 'BULLA BERNAL LUIS ERNESTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-14', 942160.00, 'A'),
    (358, 1, 'BRACCIA AVILA GIANCARLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-01', 732620.00, 'A'),
    (359, 1, 'RODRIGUEZ PINTO RAUL DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-24', 836600.00, 'A'),
    (36, 1, 'MALDONADO ALVAREZ JAIRO ASDRUBAL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127300, '2011-06-19', 980270.00, 'A'),
    (362, 1, 'POMBO POLANCO JUAN BERNARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-18', 124130.00, 'A'),
    (363, 1, 'CARDENAS SUAREZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127662, '2011-09-01', 372920.00, 'A'),
    (364, 1, 'RIVERA MAZO JOSE DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-06-10', 492220.00, 'A'),
    (365, 1, 'LEDERMAN CORDIKI JONATHAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-12-03', 342340.00, 'A'),
    (367, 1, 'BARRERA MARTINEZ LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '35@yahoo.com.mx', '2011-02-03', 127591, '2011-05-24', 148130.00, 'A'),
    (368, 1, 'SEPULVEDA RAMIREZ DANIEL MARCELO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-31', 35560.00, 'A'),
    (369, 1, 'QUINTERO DIAZ WILSON ASDRUBAL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-24', 733430.00, 'A'),
    (37, 1, 'RESTREPO SUAREZ HENRY BERNARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-07-25', 145540.00, 'A'),
    (370, 1, 'ROJAS YARA WILLMAR ARLEY', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-12-03', 560450.00, 'A'),
    (371, 3, 'CARVER LOUISE EMILY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 286785, '2010-10-07', 601980.00, 'A'),
    (372, 3, 'VINCENT DAVID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 286785, '2011-03-06', 328540.00, 'A'),
    (374, 1, 'GONZALEZ DELGADO MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-08-18', 198260.00, 'A'),
    (375, 1, 'PAEZ SIMON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-25', 480970.00, 'A'),
    (376, 1, 'CADOSCH DELMAR ELIE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-07', 810080.00, 'A'),
    (377, 1, 'HERRERA VASQUEZ DANIEL EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-06-30', 607460.00, 'A'),
    (378, 1, 'CORREAL ROJAS RONALD', 191821112, 'CRA 25 CALLE 100', '269@facebook.com', '2011-02-03', 127591, '2011-07-16', 607080.00, 'A'),
    (379, 1, 'VOIDONNIKOLAS MUNOS PANAGIOTIS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-27', 213010.00, 'A'),
    (38, 1, 'CANAL ROJAS MAURICIO HERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-05-29', 786900.00, 'A'),
    (380, 1, 'DIAZ ECHEVERRI JUAN DAVID ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-20', 243800.00, 'A'),
    (381, 1, 'CIFUENTES MARIN HERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-26', 579960.00, 'A'),
    (382, 3, 'PAXTON LUCINDA HARRIET', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 107159, '2011-05-23', 168420.00, 'A'),
    (384, 3, 'POYNTON BRIAN GEORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 286785, '2011-03-20', 5790.00, 'A'),
    (385, 3, 'TERMIGNONI ADRIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-01-14', 722320.00, 'A'),
    (386, 3, 'CARDWELL PAULA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-02-17', 594230.00, 'A'),
    (389, 1, 'FONCECA MARTINEZ MIGUEL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-25', 778680.00, 'A'),
    (39, 1, 'GARCIA SUAREZ WILLIAM ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-25', 497880.00, 'A'),
    (390, 1, 'GUERRERO NELSON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-12-03', 178650.00, 'A'),
    (391, 1, 'VICTORIA PENA FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-22', 557200.00, 'A'),
    (392, 1, 'VAN HISSENHOVEN FERRERO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-13', 250060.00, 'A'),
    (393, 1, 'CACERES ORDUZ JUAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-28', 578690.00, 'A'),
    (394, 1, 'QUINTERO ALVARO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-17', 143270.00, 'A'),
    (395, 1, 'ANZOLA PEREZ CARLOSDAVID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-04', 980300.00, 'A'),
    (397, 1, 'LLOREDA ORTIZ CARLOS JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-27', 417470.00, 'A'),
    (398, 1, 'GONZALES LONDONO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-19', 672310.00, 'A'),
    (4, 1, 'LONDONO DOMINGUEZ ERNESTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-05', 324610.00, 'A'),
    (40, 1, 'MORENO ANGULO ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-01', 128690.00, 'A'),
    (400, 8, 'TRANSELCA .A', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-04-14', 528930.00, 'A'),
    (403, 1, 'VERGARA MURILLO JUAN FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-04', 42900.00, 'A'),
    (405, 1, 'CAPERA CAPERA HARRINSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127799, '2011-06-12', 961000.00, 'A'),
    (407, 1, 'MORENO MORA WILLIAM EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-22', 872780.00, 'A'),
    (408, 1, 'HIGUERA ROA NICOLAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-28', 910430.00, 'A'),
    (409, 1, 'FORERO CASTILLO OSCAR ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '988@terra.com.co', '2011-02-03', 127591, '2011-07-23', 933810.00, 'A'),
    (410, 1, 'LOPEZ MURCIA JULIAN DANIEL', 191821112, 'CRA 25 CALLE 100', '399@facebook.com', '2011-02-03', 127591, '2011-08-08', 937790.00, 'A'),
    (411, 1, 'ALZATE JOHN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-09-09', 887490.00, 'A'),
    (412, 1, 'GONZALES GONZALES ORLANDO ANDREY', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-30', 624080.00, 'A'),
    (413, 1, 'ESCOLANO VALENTIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-05', 457930.00, 'A'),
    (414, 1, 'JARAMILLO RODRIGUEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-12', 417420.00, 'A'),
    (415, 1, 'GARCIA MUNOZ DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-02', 713300.00, 'A'),
    (416, 1, 'PINEROS ARENAS JUAN DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-10-17', 314260.00, 'A'),
    (417, 1, 'ORTIZ ARROYAVE ANDRES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-05-21', 431370.00, 'A'),
    (418, 1, 'BAYONA BARRIENTOS JEAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-12', 214090.00, 'A'),
    (419, 1, 'AGUDELO VASQUEZ JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-08-30', 776360.00, 'A'),
    (420, 1, 'CALLE DANIEL CJ PRODUCCIONES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-04', 239500.00, 'A'),
    (422, 1, 'CANO BETANCUR ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-08-20', 623620.00, 'A'),
    (423, 1, 'CALDAS BARRETO LUZ MIREYA', 191821112, 'CRA 25 CALLE 100', '991@facebook.com', '2011-02-03', 127591, '2011-05-22', 512840.00, 'A'),
    (424, 1, 'SIMBAQUEBA JOSE ERNESTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-25', 693320.00, 'A'),
    (425, 1, 'DE SILVESTRE CALERO LUIS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-18', 928110.00, 'A'),
    (426, 1, 'ZORRO PERALTA YEZID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-25', 560560.00, 'A'),
    (428, 1, 'SUAREZ OIDOR DARWIN LEONARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131272, '2011-09-05', 410650.00, 'A'),
    (429, 1, 'GIRAL CARRILLO LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-04-13', 997850.00, 'A'),
    (43, 1, 'MARULANDA VALENCIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-17', 365550.00, 'A'),
    (430, 1, 'CORDOBA GARCES JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-18', 757320.00, 'A'),
    (431, 1, 'ARIAS TAMAYO DIEGO MAURICIO', 191821112, 'CRA 25 CALLE 100', '36@yahoo.com', '2011-02-03', 127591, '2011-09-05', 793050.00, 'A'),
    (432, 1, 'EICHMANN PERRET MARC WILLY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-22', 693270.00, 'A'),
    (433, 1, 'DIAZ DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2008-09-18', 87200.00, 'A'),
    (435, 1, 'FACCINI GONZALEZ HERMANN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2009-01-08', 519420.00, 'A'),
    (436, 1, 'URIBE DUQUE FELIPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-28', 528470.00, 'A'),
    (437, 1, 'TAVERA GAONA GABREL LEAL', 191821112, 'CRA 25 CALLE 100', '280@terra.com.co', '2011-02-03', 127591, '2011-04-28', 84120.00, 'A'),
    (438, 1, 'ORDONEZ PARIS FERNANDO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-09-26', 835170.00, 'A'),
    (439, 1, 'VILLEGAS ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-19', 923520.00, 'A'),
    (44, 1, 'MARTINEZ PEDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-08-13', 738750.00, 'A'),
    (440, 1, 'MARTINEZ RUEDA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '805@hotmail.es', '2011-02-03', 127591, '2011-04-07', 112050.00, 'A'),
    (441, 1, 'ROLDAN JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-05-25', 789720.00, 'A'),
    (442, 1, 'PEREZ BRANDWAYN ELIYAU MOISES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-10-20', 612450.00, 'A'),
    (443, 1, 'VALLEJO TORO JUAN DIEGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128579, '2011-08-16', 693080.00, 'A'),
    (444, 1, 'TORRES CABRERA EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-03-19', 628070.00, 'A'),
    (445, 1, 'MERINO MEJIA GERMAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-28', 61100.00, 'A'),
    (447, 1, 'GOMEZ GOMEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-08', 923070.00, 'A'),
    (448, 1, 'RAUSCH CHEHEBAR STEVEN JOSEPH', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-09-27', 351540.00, 'A'),
    (449, 1, 'RESTREPO TRUCCO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-28', 988500.00, 'A'),
    (45, 1, 'GUTIERREZ JARAMILLO CARLOS MARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150699, '2011-08-22', 597090.00, 'A'),
    (450, 1, 'GOLDSTEIN VAIDA ELI JACK', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-11', 887860.00, 'A'),
    (451, 1, 'OLEA PINEDA EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-10', 473800.00, 'A'),
    (452, 1, 'JORGE OROZCO', 191821112, 'CRA 25 CALLE 100', '503@hotmail.es', '2011-02-03', 127591, '2011-06-02', 705410.00, 'A'),
    (454, 1, 'DE LA TORRE GOMEZ GERMAN ERNESTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-03', 411990.00, 'A'),
    (456, 1, 'MADERO ARIAS JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '452@hotmail.es', '2011-02-03', 127591, '2011-08-22', 479090.00, 'A'),
    (457, 1, 'GOMEZ MACHUCA ALVARO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-12', 166430.00, 'A'),
    (458, 1, 'MENDIETA TOBON DANIEL RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-08', 394880.00, 'A'),
    (459, 1, 'VILLADIEGO CORTINA JAVIER TOMAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-26', 475110.00, 'A'),
    (46, 1, 'FERRUCHO ARCINIEGAS JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-06', 769220.00, 'A'),
    (460, 1, 'DERESER HARTUNG ERNESTO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-12-25', 190900.00, 'A'),
    (461, 1, 'RAMIREZ PENA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-06-25', 529190.00, 'A'),
    (463, 1, 'IREGUI REYES LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-07', 778590.00, 'A'),
    (464, 1, 'PINTO GOMEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2010-06-24', 673270.00, 'A'),
    (465, 1, 'RAMIREZ RAMIREZ FERNANDO ALONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127799, '2011-10-01', 30570.00, 'A'),
    (466, 1, 'BERRIDO TRUJILLO JORGE HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132775, '2011-10-06', 133040.00, 'A'),
    (467, 1, 'RIVERA CARVAJAL RAFAEL HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-20', 573500.00, 'A'),
    (468, 3, 'FLOREZ PUENTES IVAN ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-08', 468380.00, 'A'),
    (469, 1, 'BALLESTEROS FLOREZ IVAN DARIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-02', 621410.00, 'A'),
    (47, 1, 'MARIN FLOREZ OMAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-30', 54840.00, 'A'),
    (470, 1, 'RODRIGO PENA HERRERA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 237734, '2011-10-04', 701890.00, 'A'),
    (471, 1, 'RODRIGUEZ SILVA ROGELIO', 191821112, 'CRA 25 CALLE 100', '163@gmail.com', '2011-02-03', 127591, '2011-05-26', 645210.00, 'A'),
    (473, 1, 'VASQUEZ VELANDIA JUAN GABRIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-05-04', 666330.00, 'A'),
    (474, 1, 'ROBLEDO JAIME', 191821112, 'CRA 25 CALLE 100', '409@yahoo.com', '2011-02-03', 127591, '2011-05-31', 970480.00, 'A'),
    (475, 1, 'GRIMBERG DIAZ PHILIP', 191821112, 'CRA 25 CALLE 100', '723@yahoo.com', '2011-02-03', 127591, '2011-03-30', 853430.00, 'A'),
    (476, 1, 'CHAUSTRE GARCIA JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-26', 355670.00, 'A'),
    (477, 1, 'GOMEZ FLOREZ IGNASIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-09-14', 218090.00, 'A'),
    (478, 1, 'LUIS ALBERTO CABRERA PUENTES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-05-26', 23420.00, 'A'),
    (479, 1, 'MARTINEZ ZAPATA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '234@gmail.com', '2011-02-03', 127122, '2011-07-01', 462840.00, 'A'),
    (48, 1, 'PARRA IBANEZ FABIAN ERNESTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-02-01', 966520.00, 'A'),
    (480, 3, 'WESTERBERG JAN RICKARD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 300701, '2011-02-01', 243940.00, 'A'),
    (484, 1, 'RODRIGUEZ VILLALOBOS EDGAR FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-19', 860320.00, 'A'),
    (486, 1, 'NAVARRO REYES DIEGO FELIPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-01', 530150.00, 'A'),
    (487, 1, 'NOGUERA RICAURTE ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-01-21', 384100.00, 'A'),
    (488, 1, 'RUIZ VEJARANO CARLOS DANIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-27', 330030.00, 'A'),
    (489, 1, 'CORREA PEREZ ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-12-14', 497860.00, 'A'),
    (49, 1, 'FLOREZ PEREZ RUBIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-23', 668090.00, 'A'),
    (490, 1, 'REYES GOMEZ LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-26', 499210.00, 'A'),
    (491, 3, 'BERNAL LEON ALBERTO JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2011-03-29', 2470.00, 'A'),
    (492, 1, 'FELIPE JARAMILLO CARO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2009-10-31', 514700.00, 'A'),
    (493, 1, 'GOMEZ PARRA GERMAN DARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-01-29', 566100.00, 'A'),
    (494, 1, 'VALLEJO RAMIREZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-13', 286390.00, 'A'),
    (495, 1, 'DIAZ LONDONO HUGO MARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-06', 733670.00, 'A'),
    (496, 3, 'VAN BAKERGEM RONALD JAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2008-11-05', 809190.00, 'A'),
    (497, 1, 'MENDEZ RAMIREZ JOSE LEONARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-10', 844920.00, 'A'),
    (498, 3, 'QUI TANILLA HENRIQUEZ PAUL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-10', 797030.00, 'A'),
    (499, 3, 'PELEATO FLOREAL', 191821112, 'CRA 25 CALLE 100', '531@hotmail.com', '2011-02-03', 188640, '2011-04-23', 450370.00, 'A'),
    (50, 1, 'SILVA GUZMAN MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-24', 440890.00, 'A'),
    (502, 3, 'LEO ULF GORAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 300701, '2010-07-26', 181840.00, 'A'),
    (503, 3, 'KARLSSON DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 300701, '2011-07-22', 50680.00, 'A'),
    (504, 1, 'JIMENEZ JANER ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '889@hotmail.es', '2011-02-03', 203272, '2011-08-29', 707880.00, 'A'),
    (506, 1, 'PABON OCHOA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-14', 813050.00, 'A'),
    (507, 1, 'ACHURY CADENA CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-26', 903240.00, 'A'),
    (508, 1, 'ECHEVERRY GARZON SEBASTIN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-23', 77050.00, 'A'),
    (509, 1, 'PINEROS PENA LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-29', 675550.00, 'A'),
    (51, 1, 'CAICEDO URREA JAIME ORLANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-08-17', 200160.00, 'A'),
    ('CELL3795', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (510, 1, 'MARTINEZ MARTINEZ LUIS EDUARDO', 191821112, 'CRA 25 CALLE 100', '586@facebook.com', '2011-02-03', 127591, '2010-08-28', 146600.00, 'A'),
    (511, 1, 'MOLANO PENA JESUS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-02-05', 706320.00, 'A'),
    (512, 3, 'RUDOLPHY FONTAINE ANDRES', 191821112, 'CRA 25 CALLE 100', '492@yahoo.com', '2011-02-03', 117002, '2011-04-12', 91820.00, 'A'),
    (513, 1, 'NEIRA CHAVARRO JOHN JAIRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-12', 340120.00, 'A'),
    (514, 3, 'MENDEZ VILLALOBOS ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-03-25', 425160.00, 'A'),
    (515, 3, 'HERNANDEZ OLIVA JOSE DE LA CRUZ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-03-25', 105440.00, 'A'),
    (518, 3, 'JANCO NICOLAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-15', 955830.00, 'A'),
    (52, 1, 'TAPIA MUNOZ JAIRO RICARDO', 191821112, 'CRA 25 CALLE 100', '920@hotmail.es', '2011-02-03', 127591, '2011-10-05', 678130.00, 'A'),
    (520, 1, 'ALVARADO JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-26', 895550.00, 'A'),
    (521, 1, 'HUERFANO SOTO JONATHAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-30', 619910.00, 'A'),
    (522, 1, 'HUERFANO SOTO JONATHAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-04', 412900.00, 'A'),
    (523, 1, 'RODRIGEZ GOMEZ WILMAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-14', 204790.00, 'A'),
    (525, 1, 'ARROYO BAPTISTE DIEGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-04-09', 311810.00, 'A'),
    (526, 1, 'PULECIO BOEK DANIEL', 191821112, 'CRA 25 CALLE 100', '718@gmail.com', '2011-02-03', 127591, '2011-08-12', 203350.00, 'A'),
    (527, 1, 'ESLAVA VELEZ SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-10-08', 81300.00, 'A'),
    (528, 1, 'CASTRO FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-05-06', 796470.00, 'A'),
    (53, 1, 'HINCAPIE MARTINEZ RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127573, '2011-09-26', 790180.00, 'A'),
    (530, 1, 'ZORRILLA PUJANA NICOLAS', 191821112, 'CRA 25 CALLE 100', '312@yahoo.es', '2011-02-03', 127591, '2011-06-06', 302750.00, 'A'),
    (531, 1, 'ZORRILLA PUJANA NICOLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-06', 298440.00, 'A'),
    (532, 1, 'PRETEL ARTEAGA MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-09', 583980.00, 'A'),
    (533, 1, 'RAMOS VERGARA HUMBERTO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 131105, '2010-05-13', 24560.00, 'A'),
    (534, 1, 'BONILLA PINEROS DIEGO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-20', 370880.00, 'A'),
    (535, 1, 'BELTRAN TRIVINO JULIAN DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-11-06', 780710.00, 'A'),
    (536, 3, 'BLOD ULF FREDERICK EDWARD', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-06', 790900.00, 'A'),
    (537, 1, 'VANEGAS OROZCO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-10', 612400.00, 'A'),
    (538, 3, 'ORUE VALLE MONICA CECILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 97885, '2011-09-15', 689270.00, 'A'),
    (539, 1, 'AGUDELO BEDOYA ANDRES JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-05-24', 609160.00, 'A'),
    (54, 1, 'DE HOYOS TRESPALACIOS MAURICIO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-04-21', 916500.00, 'A'),
    (540, 3, 'HEIJKENSKJOLD PER JESPER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-04-06', 977980.00, 'A'),
    (541, 3, 'GONZALEZ ALVARADO LUIS RAUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-08-27', 62430.00, 'A'),
    (543, 1, 'GRUPO SURAMERICA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-08-24', 703760.00, 'A'),
    (545, 1, 'CORPORACION CONTEXTO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-09-08', 809570.00, 'A'),
    (546, 3, 'LUNDIN JOHAN ERIK ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-29', 895330.00, 'A'),
    (548, 3, 'VEGERANO JOSE ', 191821112, 'CRA 25 CALLE 100', '221@facebook.com', '2011-02-03', 190393, '2011-06-05', 553780.00, 'A'),
    (549, 3, 'SERRANO MADRID CLAUDIA INES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-07-27', 625060.00, 'A'),
    (55, 1, 'TAFUR GOMEZ ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2010-09-12', 211980.00, 'A'),
    (550, 1, 'MARTINEZ ACEVEDO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-10-06', 463920.00, 'A'),
    (551, 1, 'GONZALEZ MORENO PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-07-21', 444450.00, 'A'),
    (552, 1, 'MEJIA ROJAS ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-08-02', 830470.00, 'A'),
    (553, 3, 'RODRIGUEZ ANTHONY HANSEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-16', 819000.00, 'A'),
    (554, 1, 'ABUCHAIBE ANNICCHRICO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-31', 603610.00, 'A'),
    (555, 3, 'MOYES KIMBERLY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-08', 561020.00, 'A'),
    (556, 3, 'MONTINI MARIO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118942, '2010-03-16', 994280.00, 'A'),
    (557, 3, 'HOGBERG DANIEL TOBIAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-15', 288350.00, 'A'),
    (559, 1, 'OROZCO PFEIZER MARTIN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-10-07', 429520.00, 'A'),
    (56, 1, 'NARINO ROJAS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-27', 310390.00, 'A'),
    (560, 1, 'GARCIA MONTOYA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-06-02', 770840.00, 'A'),
    (562, 1, 'VELASQUEZ PALACIO MANUEL ORLANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-06-23', 515670.00, 'A'),
    (563, 1, 'GALLEGO PEREZ DIEGO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-04-14', 881460.00, 'A'),
    (564, 1, 'RUEDA URREGO JUAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-04', 860270.00, 'A'),
    (565, 1, 'RESTREPO DEL TORO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-10', 656960.00, 'A'),
    (567, 1, 'TORO VALENCIA FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-08-04', 549090.00, 'A'),
    (568, 1, 'VILLEGAS LUIS ALFONSO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-02', 633490.00, 'A'),
    (569, 3, 'RIDSTROM CHRISTER ANDERS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 300701, '2011-09-06', 520150.00, 'A'),
    (57, 1, 'TOVAR ARANGO JOHN JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127662, '2010-07-03', 916010.00, 'A'),
    (570, 3, 'SHEPHERD DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2008-05-11', 700280.00, 'A'),
    (573, 3, 'BENGTSSON JOHAN ANDREAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-06', 196830.00, 'A'),
    (574, 3, 'PERSSON HANS JONAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-09', 172340.00, 'A'),
    (575, 3, 'SYNNEBY BJORN ERIK', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-15', 271210.00, 'A'),
    ('CELL381', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (577, 3, 'COHEN PAUL KIRTAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-25', 381490.00, 'A'),
    (578, 3, 'ROMERO BRAVO FERNANDO EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-08-21', 390360.00, 'A'),
    (579, 3, 'GUTHRIE ROBERT DEAN', 191821112, 'CRA 25 CALLE 100', '794@gmail.com', '2011-02-03', 161705, '2010-07-20', 807350.00, 'A'),
    (58, 1, 'TORRES ESCOBAR JAIRO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-06-17', 648860.00, 'A'),
    (580, 3, 'ROCASERMENO MONTENEGRO MARIO JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 139844, '2010-12-01', 865650.00, 'A'),
    (581, 1, 'COCK JORGE EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-08-19', 906210.00, 'A'),
    (582, 3, 'REISS ANDREAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-01-31', 934120.00, 'A'),
    (584, 3, 'ECHEVERRIA CASTILLO GERMAN FRANCISCO', 191821112, 'CRA 25 CALLE 100', '982@yahoo.com', '2011-02-03', 139844, '2011-07-20', 957370.00, 'A'),
    (585, 3, 'BRANDT CARLOS GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-10', 931030.00, 'A'),
    (586, 3, 'VEGA NUNEZ GILBERTO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-14', 783010.00, 'A'),
    (587, 1, 'BEJAR MUNOZ JORDI', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 196234, '2010-10-08', 121990.00, 'A'),
    (588, 3, 'WADSO KERSTIN ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-17', 260890.00, 'A'),
    (59, 1, 'RAMOS FORERO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-20', 496300.00, 'A'),
    (590, 1, 'RODRIGUEZ BETANCOURT JAVIER AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127538, '2011-05-23', 909850.00, 'A'),
    (592, 1, 'ARBOLEDA HALABY RODRIGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 150699, '2009-02-03', 939170.00, 'A'),
    (593, 1, 'CURE CURE CARLOS ALFREDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-07-11', 494600.00, 'A'),
    (594, 3, 'VIDELA PEREZ OSCAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-07-13', 655510.00, 'A'),
    (595, 1, 'GONZALEZ GAVIRIA NESTOR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2009-09-28', 793760.00, 'A'),
    (596, 3, 'IZQUIERDO DELGADO DIONISIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2009-09-24', 2250.00, 'A'),
    (597, 1, 'MORENO DAIRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127300, '2011-06-14', 629990.00, 'A'),
    (598, 1, 'RESTREPO FERNNDEZ SOTO JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-08-31', 143210.00, 'A'),
    (599, 3, 'YERYES VERGARA MARIA SOLEDAD', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-10-11', 826060.00, 'A'),
    (6, 1, 'GUZMAN ESCOBAR JOSE VICENTE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-10', 26390.00, 'A'),
    (60, 1, 'ELEJALDE ESCOBAR TOMAS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-11-09', 534910.00, 'A'),
    (601, 1, 'ESCAF ESCAF WILLIAM MIGUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 150699, '2011-07-26', 25190.00, 'A'),
    (602, 1, 'CEBALLOS ZULUAGA JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-03', 23920.00, 'A'),
    (603, 1, 'OLIVELLA GUERRERO RAFAEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 134022, '2010-06-23', 44040.00, 'A'),
    (604, 1, 'ESCOBAR GALLO CARLOS HUGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-09', 148420.00, 'A'),
    (605, 1, 'ESCORCIA RAMIREZ EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128569, '2011-04-01', 609990.00, 'A'),
    (606, 1, 'MELGAREJO MORENO PAULA ANDREA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-05', 604700.00, 'A'),
    (607, 1, 'TOBON CALLE CARLOS GUILLERMO', 191821112, 'CRA 25 CALLE 100', '689@hotmail.es', '2011-02-03', 128662, '2011-03-16', 193510.00, 'A'),
    (608, 3, 'TREVINO NOPHAL SILVANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 110709, '2011-05-27', 153470.00, 'A'),
    (609, 1, 'CARDER VELEZ EDWIN JOHN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-09-04', 186830.00, 'A'),
    (61, 1, 'GASCA DAZA VICTOR HERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-09', 185660.00, 'A'),
    (610, 3, 'DAVIS JOHN BRADLEY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-04-06', 473740.00, 'A'),
    (611, 1, 'BAQUERO SLDARRIAGA ALVARO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-09-15', 808210.00, 'A'),
    (612, 3, 'SERRACIN ARAUZ YANIRA YAMILET', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 131272, '2011-06-09', 619820.00, 'A'),
    (613, 1, 'MORA SOTO ALVARO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-09-20', 674450.00, 'A'),
    (614, 1, 'SUAREZ RODRIGUEZ HERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-03-29', 512820.00, 'A'),
    (616, 1, 'BAQUERO GARCIA JORGE LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-07-14', 165160.00, 'A'),
    (617, 3, 'ABADI MADURO MOISES SIMON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 131272, '2009-03-31', 203640.00, 'A'),
    (62, 3, 'FLOWER LYNDON BRUCE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 231373, '2011-05-16', 323560.00, 'A'),
    (624, 8, 'OLARTE LEONARDO', 191821112, 'CRA 25 CALLE 100', '6@hotmail.com', '2011-02-03', 127591, '2011-06-03', 219790.00, 'A'),
    (63, 1, 'RUBIO CORTES OSCAR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-04-28', 60830.00, 'A'),
    (630, 5, 'PROEXPORT', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2010-08-12', 708320.00, 'A'),
    (632, 8, 'SUPER COFFEE ', 191821112, 'CRA 25 CALLE 100', '792@hotmail.es', '2011-02-03', 127591, '2011-08-30', 306460.00, 'A'),
    (636, 8, 'NOGAL ASESORIAS FINANCIERAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-04-07', 752150.00, 'A'),
    (64, 1, 'GUERRA MARTINEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-24', 333480.00, 'A'),
    (645, 8, 'GIZ - PROFIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-31', 566330.00, 'A'),
    (652, 3, 'QBE DEL ISTMO COMPANIA DE REASEGUROS ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-14', 932190.00, 'A'),
    (655, 3, 'CORP. CENTRO DE ESTUDIOS DE DERECHO JUSTICIA Y SOCIEDAD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-05-04', 440370.00, 'A'),
    (659, 3, 'GOOD YEAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2010-09-24', 993830.00, 'A'),
    (660, 3, 'ARCINIEGAS Y VILLAMIZAR', 191821112, 'CRA 25 CALLE 100', '258@yahoo.com', '2011-02-03', 127591, '2010-12-02', 787450.00, 'A'),
    (67, 1, 'LOPEZ HOYOS JUAN DIEGO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127662, '2010-04-13', 665230.00, 'A'),
    (670, 8, 'APPLUS NORCONTROL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-09-06', 83210.00, 'A'),
    (672, 3, 'KERLL SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 287273, '2010-12-19', 501610.00, 'A'),
    (673, 1, 'RESTREPO MOLINA RAMIRO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 144215, '2010-12-18', 457290.00, 'A'),
    (674, 1, 'PEREZ GIL JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-08-18', 781610.00, 'A'),
    ('CELL3840', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (676, 1, 'GARCIA LONDONO FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-23', 336160.00, 'A'),
    (677, 3, 'RIJLAARSDAM KARIN AN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-07-03', 72210.00, 'A'),
    (679, 1, 'LIZCANO MONTEALEGRE ARNULFO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127203, '2011-02-01', 546170.00, 'A'),
    (68, 1, 'MARTINEZ SILVA EDGAR', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-29', 54250.00, 'A'),
    (680, 3, 'OLIVARI MAYER PATRICIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 122642, '2011-08-01', 673170.00, 'A'),
    (682, 3, 'CHEVALIER FRANCK PIERRE CHARLES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 263813, '2010-12-01', 617280.00, 'A'),
    (683, 3, 'NG WAI WING ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126909, '2011-06-14', 904310.00, 'A'),
    (684, 3, 'MULLER DOMINGUEZ CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-22', 669700.00, 'A'),
    (685, 3, 'MOSQUEDA DOMNGUEZ ANGEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-04-08', 635580.00, 'A'),
    (686, 3, 'LARREGUI MARIN LEON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-08', 168800.00, 'A'),
    (687, 3, 'VARGAS VERGARA ALEJANDRO BRAULIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 159245, '2011-09-14', 937260.00, 'A'),
    (688, 3, 'SKINNER LYNN  CHERYL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-12', 179890.00, 'A'),
    (689, 1, 'URIBE CORREA LEONARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2010-07-29', 87680.00, 'A'),
    (690, 1, 'TAMAYO JARAMILLO FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-11-10', 898730.00, 'A'),
    (691, 3, 'MOTABAN DE BORGES PAULA ELENA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2010-09-24', 230610.00, 'A'),
    (692, 5, 'FERNANDEZ NALDA JOSE MANUEL ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-06-28', 456850.00, 'A'),
    (693, 1, 'GOMEZ RESTREPO JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-06-28', 592420.00, 'A'),
    (694, 1, 'CARDENAS TAMAYO JOSE JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-08-08', 591550.00, 'A'),
    (696, 1, 'RESTREPO ARANGO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-03-31', 127820.00, 'A'),
    (697, 1, 'ROCABADO PASTRANA ROBERT JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127443, '2011-08-13', 97600.00, 'A'),
    (698, 3, 'JARVINEN JOONAS JORI KRISTIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196234, '2011-05-29', 104560.00, 'A'),
    (699, 1, 'MORENO PEREZ HERNAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-30', 230000.00, 'A'),
    (7, 1, 'PUYANA RAMOS GUILLERMO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-08-27', 331830.00, 'A'),
    (70, 1, 'GALINDO MANZANO JAVIER FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-31', 214890.00, 'A'),
    (701, 1, 'ROMERO PEREZ ARCESIO JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132775, '2011-07-13', 491650.00, 'A'),
    (703, 1, 'CHAPARRO AGUDELO LEONARDO VIRGILIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-05-04', 271320.00, 'A'),
    (704, 5, 'VASQUEZ YANIS MARIA DEL PILAR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-10-13', 508820.00, 'A'),
    (705, 3, 'BARBERO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 116511, '2010-09-13', 730170.00, 'A'),
    (706, 1, 'CARMONA HERNANDEZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-11-08', 124380.00, 'A'),
    (707, 1, 'PEREZ SUAREZ JORGE ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2011-09-14', 431370.00, 'A'),
    (708, 1, 'ROJAS JORGE MARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 130135, '2011-04-01', 783740.00, 'A'),
    (71, 1, 'DIAZ JUAN PABLO/JULES JAVIER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-10-01', 247860.00, 'A'),
    (711, 3, 'CATALDO CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116773, '2011-06-06', 984810.00, 'A'),
    (716, 5, 'MACIAS PIZARRO PATRICIO ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-06-07', 376260.00, 'A'),
    (717, 1, 'RENDON MAYA DAVID ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 130273, '2010-07-25', 332310.00, 'A'),
    (718, 3, 'DE HILDEBRAND E GRISI FILHO CELSO CLAUDIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-11', 532740.00, 'A'),
    (719, 3, 'ALLIEL FACUSSE JULIO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-06-20', 666800.00, 'A'),
    (72, 1, 'LOPEZ ROJAS VICTOR DANIEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-11', 594640.00, 'A'),
    (720, 3, 'CHEMELLO JIMENEZ GAETANO ALBERTO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132958, '2010-06-23', 735760.00, 'A'),
    (721, 3, 'GARCIA BEZANILLA RODOLFO EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-04-12', 678420.00, 'A'),
    (722, 1, 'ARIAS EDWIN', 191821112, 'CRA 25 CALLE 100', '13@terra.com.co', '2011-02-03', 127492, '2008-04-24', 184800.00, 'A'),
    (723, 3, 'SOHN JANG WON', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-07', 888750.00, 'A'),
    (724, 3, 'WILHELM GIOVINE JAIME ROBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 115263, '2011-09-20', 889340.00, 'A'),
    (726, 3, 'CASTILLERO DANIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 131272, '2011-05-13', 234270.00, 'A'),
    (727, 3, 'PORTUGAL LANGHORST MAX GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-13', 829960.00, 'A'),
    (729, 3, 'ALFONSO HERRANZ AGUSTIN ALFONSO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-07-21', 745060.00, 'A'),
    (73, 1, 'DAVILA MENDEZ OSCAR DIEGO', 191821112, 'CRA 25 CALLE 100', '991@yahoo.com.mx', '2011-02-03', 128569, '2011-08-31', 229630.00, 'A'),
    (730, 3, 'ALFONSO HERRANZ AGUSTIN CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2010-03-31', 384360.00, 'A'),
    (731, 1, 'NOGUERA RAMIREZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-14', 686610.00, 'A'),
    (732, 1, 'ACOSTA PERALTA FABIAN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 134030, '2011-06-21', 279960.00, 'A'),
    (733, 3, 'MAC LEAN PINA PEDRO SEGUNDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-05-23', 339980.00, 'A'),
    (734, 1, 'LEON ARCOS ALEX', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-05-04', 860020.00, 'A'),
    (736, 3, 'LAMARCA GARCIA GERMAN JULIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-04-29', 820700.00, 'A'),
    (737, 1, 'PORTO VELASQUEZ LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '321@hotmail.es', '2011-02-03', 133535, '2011-08-17', 263060.00, 'A'),
    (738, 1, 'BUENAVENTURA MEDINA ERICK WILSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2011-09-18', 853180.00, 'A'),
    (739, 1, 'LEVY ARRAZOLA RALPH MARC', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2011-09-27', 476720.00, 'A'),
    (74, 1, 'RAMIREZ SORA EDISON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-03', 364220.00, 'A'),
    (740, 3, 'MOON HYUNSIK ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 173192, '2011-05-15', 824080.00, 'A'),
    (741, 3, 'LHUILLIER TRONCOSO GASTON MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-09-07', 690230.00, 'A'),
    (742, 3, 'UNDURRAGA PELLEGRINI GONZALO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2010-11-21', 978900.00, 'A'),
    (743, 1, 'SOLANO TRIBIN NICOLAS SIMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 134022, '2011-03-16', 823800.00, 'A'),
    (744, 1, 'NOGUERA BENAVIDES JACOBO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-06', 182300.00, 'A'),
    (745, 1, 'GARCIA LEON MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2008-04-16', 440110.00, 'A'),
    (746, 1, 'EMILIANI ROJAS ALEXANDER ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-09-12', 653640.00, 'A'),
    (748, 1, 'CARRENO POULSEN HELGEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-06', 778370.00, 'A'),
    (749, 1, 'ALVARADO FANDINO ANDRES EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2008-11-05', 48280.00, 'A'),
    (750, 1, 'DIAZ GRANADOS JUAN PABLO.', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-01-12', 906290.00, 'A'),
    (751, 1, 'OVALLE BETANCOURT ALBERTO JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 134022, '2011-08-14', 386620.00, 'A'),
    (752, 3, 'GUTIERREZ VERGARA JOSE MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-08', 214250.00, 'A'),
    (753, 3, 'CHAPARRO GUAIMARAL LIZ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 147467, '2011-03-16', 911350.00, 'A'),
    (754, 3, 'CORTES DE SOLMINIHAC PABLO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2011-01-20', 914020.00, 'A'),
    (755, 3, 'CHETAIL VINCENT', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 239124, '2010-08-23', 836050.00, 'A'),
    (756, 3, 'PERUGORRIA RODRIGUEZ JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2010-10-17', 438210.00, 'A'),
    (757, 3, 'GOLLMANN ROBERTO JUAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 167269, '2011-03-28', 682870.00, 'A'),
    (758, 3, 'VARELA SEPULVEDA MARIA PILAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2010-07-26', 99730.00, 'A'),
    (759, 3, 'MEYER WELIKSON MICHELE JANIK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-05-10', 450030.00, 'A'),
    (76, 1, 'VANEGAS RODRIGUEZ OSCAR IVAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-20', 568310.00, 'A'),
    (77, 3, 'GATICA SOTOMAYOR MAURICIO VICENTE', 191821112, 'CRA 25 CALLE 100', '409@terra.com.co', '2011-02-03', 117002, '2010-05-13', 444970.00, 'A'),
    (79, 1, 'PENA VALENZUELA DANIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-19', 264790.00, 'A'),
    (8, 1, 'NAVARRO PALENCIA HUGO RAFAEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126968, '2011-05-05', 579980.00, 'A'),
    (80, 1, 'BARRIOS CUADRADO DAVID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-29', 764140.00, 'A'),
    (802, 3, 'RECK GARRONE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2009-02-06', 767700.00, 'A'),
    (81, 1, 'PARRA QUIROGA JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 26330.00, 'A'),
    (811, 8, 'FEDERACION NACIONAL DE AVICULTORES ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-04-18', 926010.00, 'A'),
    (812, 1, 'ORJUELA VELEZ JAIME ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-22', 257160.00, 'A'),
    (813, 1, 'PENA CHACON GUSTAVO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-08-27', 507770.00, 'A'),
    (814, 1, 'RONDEROS MOJICA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127443, '2011-05-04', 767370.00, 'A'),
    (815, 1, 'RICO NINO MARIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127443, '2011-05-18', 313540.00, 'A'),
    (817, 3, 'AVILA CHYTIL MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118471, '2011-07-14', 387300.00, 'A'),
    (818, 3, 'JABLONSKI DUARTE SILVEIRA ESTER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2010-12-21', 139740.00, 'A'),
    (819, 3, 'BUHLER MOSLER XIMENA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-06-20', 536830.00, 'A'),
    (82, 1, 'CARRILLO GAMBOA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-06-01', 839240.00, 'A'),
    (820, 3, 'FALQUETO DALMIRO ANGELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-06-21', 264910.00, 'A'),
    (821, 1, 'RUGER GUSTAVO RODRIGUEZ TAMAYO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2010-04-12', 714080.00, 'A'),
    (822, 3, 'JULIO RODRIGUEZ FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2011-08-16', 775650.00, 'A'),
    (823, 3, 'CIBANIK RODOLFO MOISES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132554, '2011-09-19', 736020.00, 'A'),
    (824, 3, 'JIMENEZ FRANCO EMMANUEL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-17', 353150.00, 'A'),
    (825, 3, 'GNECCO TREMEDAD', 191821112, 'CRA 25 CALLE 100', '818@hotmail.com', '2011-02-03', 171072, '2011-03-19', 557700.00, 'A'),
    (826, 3, 'VILAR MENDOZA JOSE RAFAEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-29', 729050.00, 'A'),
    (827, 3, 'GONZALEZ MOLINA CRISTIAN MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-06-20', 972160.00, 'A'),
    (828, 1, 'GONTOVNIK HOBRECKT CARLOS DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-08-02', 673620.00, 'A'),
    (829, 3, 'DIBARRAT URZUA SEBASTIAN RAIMUNDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-28', 451650.00, 'A'),
    (830, 3, 'STOCCHERO HATSCHBACH GUILHERME', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2010-11-22', 237370.00, 'A'),
    (831, 1, 'NAVAS PASSOS NARCISO EVELIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-04-21', 831900.00, 'A'),
    (832, 3, 'LUNA SOBENES FAVIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-10-11', 447400.00, 'A'),
    (833, 3, 'NUNEZ NOGUEIRA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-03-19', 741290.00, 'A'),
    (834, 1, 'CASTRO BELTRAN ARIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128188, '2011-05-15', 364270.00, 'A'),
    (835, 1, 'TURBAY YAMIN MAURICIO JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-03-17', 597490.00, 'A'),
    (836, 1, 'GOMEZ BARRAZA RODNEY LORENZO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-07', 894610.00, 'A'),
    (837, 1, 'CUELLO LASCANO ROBERTO', 191821112, 'CRA 25 CALLE 100', '221@hotmail.es', '2011-02-03', 133535, '2011-07-11', 680610.00, 'A'),
    (838, 1, 'PATERNINA PEINADO JOSE VICENTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2011-08-23', 719190.00, 'A'),
    (839, 1, 'YEPES RUBIANO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-05-16', 554130.00, 'A'),
    (84, 1, 'ALVIS RAMIREZ ALFREDO', 191821112, 'CRA 25 CALLE 100', '292@yahoo.com', '2011-02-03', 127662, '2011-09-16', 68190.00, 'A'),
    (840, 1, 'ROCA LLANOS GUILLERMO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-08-22', 613060.00, 'A'),
    (841, 1, 'RENDON TORRALVO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2011-05-26', 402950.00, 'A'),
    (842, 1, 'BLANCO STAND GERMAN ELIECER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-07-17', 175530.00, 'A'),
    (843, 3, 'BERNAL MAYRA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 131272, '2010-08-31', 668820.00, 'A'),
    (844, 1, 'NAVARRO RUIZ LAZARO GREGORIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 126916, '2008-09-23', 817520.00, 'A'),
    (846, 3, 'TUOMINEN OLLI PETTERI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-09-01', 953150.00, 'A'),
    (847, 1, 'ESPARRAGOZA DE LA ESPRIELLA ENRIQUE ALBERTO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-08-09', 522340.00, 'A'),
    (848, 3, 'ARAYA ARIAS JUAN VICENTE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132165, '2011-08-09', 752210.00, 'A'),
    (85, 1, 'GARCIA JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-03-01', 989420.00, 'A'),
    (850, 1, 'PARDO GOMEZ GERMAN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2010-11-25', 713690.00, 'A'),
    (851, 1, 'ATIQUE JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2008-03-03', 986250.00, 'A'),
    (852, 1, 'HERNANDEZ MEYER EDGARDO DE JESUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-07-20', 790190.00, 'A'),
    (853, 1, 'ZULUAGA DE LEON IVAN JESUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-07-03', 992210.00, 'A'),
    (854, 1, 'VILLARREAL ANGULO ENRIQUE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-10-02', 590450.00, 'A'),
    (855, 1, 'CELIA MARTINEZ APARICIO GIAN PIERO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-06-15', 975620.00, 'A'),
    (857, 3, 'LIPARI RONALDO LUIS', 191821112, 'CRA 25 CALLE 100', '84@facebook.com', '2011-02-03', 118941, '2010-10-13', 606990.00, 'A'),
    (858, 1, 'RAVACHI DAVILA ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2011-05-04', 714620.00, 'A'),
    (859, 3, 'PINHEIRO OLIVEIRA LUCIANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-06', 752130.00, 'A'),
    (86, 1, 'GOMEZ LIS CARLOS EMILIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2009-12-22', 742520.00, 'A'),
    (860, 1, 'PUGLIESE MERCADO LUIGGI ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-08-19', 616780.00, 'A'),
    (862, 1, 'JANNA TELLO DANIEL JALIL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2010-08-07', 287220.00, 'A'),
    (863, 3, 'MATTAR CARLOS HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2009-04-26', 953570.00, 'A'),
    (864, 1, 'MOLINA OLIER OSVALDO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132775, '2011-04-18', 906200.00, 'A'),
    (865, 1, 'BLANCO MCLIN DAVID ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-08-18', 670290.00, 'A'),
    (866, 1, 'NARANJO ROMERO ALFREDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2010-08-25', 632860.00, 'A'),
    (867, 1, 'SIMANCAS TRUJILLO RICARDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-04-07', 153400.00, 'A'),
    (868, 1, 'ARENAS USME GERMAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126881, '2011-10-01', 868430.00, 'A'),
    (869, 5, 'DIAZ CORDERO RODRIGO FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-11-04', 881950.00, 'A'),
    (87, 1, 'CELIS PEREZ HERNANDO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-05', 744330.00, 'A'),
    (870, 3, 'BINDER ZBEDA JONATAHAN JANAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 131083, '2010-04-11', 804460.00, 'A'),
    (871, 1, 'HINCAPIE HELLMAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-09-15', 376440.00, 'A'),
    (872, 3, 'MONTEIRO LANAMAR ALFONSO DE BUSTAMANTE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118942, '2009-03-23', 468820.00, 'A'),
    (873, 3, 'AGUDO CARMINATTI REGINA CELIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-01-04', 214770.00, 'A'),
    (874, 1, 'GONZALEZ VILLALOBOS CRISTIAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2011-09-26', 667400.00, 'A'),
    (875, 3, 'GUELL VILLANUEVA ALVARO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2008-04-07', 692670.00, 'A'),
    (876, 3, 'GRES ANAIS ROBERTO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-12-01', 461180.00, 'A'),
    (877, 3, 'GAME MOCOCAIN JUAN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-07', 227890.00, 'A'),
    (878, 1, 'FERRER UCROS FERNANDO LEON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-06-22', 755900.00, 'A'),
    (879, 3, 'HERRERA JAUREGUI CARLOS GUSTAVO', 191821112, 'CRA 25 CALLE 100', '599@facebook.com', '2011-02-03', 131272, '2010-07-22', 95840.00, 'A'),
    (880, 3, 'BACALLAO HERNANDEZ ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126180, '2010-04-21', 211480.00, 'A'),
    (881, 1, 'GIJON URBINA JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 144879, '2011-04-03', 769910.00, 'A'),
    (882, 3, 'TRUSEN CHRISTOPH WOLFGANG', 191821112, 'CRA 25 CALLE 100', '338@yahoo.com.mx', '2011-02-03', 127591, '2010-10-24', 215100.00, 'A'),
    (883, 3, 'ASHOURI ASKANDAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 157861, '2009-03-03', 765760.00, 'A'),
    (885, 1, 'ALTAMAR WATTS JAIRO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-08-20', 620170.00, 'A'),
    (887, 3, 'QUINTANA BALTIERRA ROBERTO ALEX', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-06-21', 891370.00, 'A'),
    (889, 1, 'CARILLO PATINO VICTOR HILARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 130226, '2011-09-06', 354570.00, 'A'),
    (89, 1, 'CONTRERAS PULIDO LINA MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-06', 237480.00, 'A'),
    (890, 1, 'GELVES CANAS GENARO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-02', 355640.00, 'A'),
    (891, 3, 'CAGNONI DE MELO PAULA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2010-12-14', 714490.00, 'A'),
    (892, 3, 'MENA AMESTICA PATRICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-03-22', 505510.00, 'A'),
    (893, 1, 'CAICEDO ROMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-07', 384110.00, 'A'),
    (894, 1, 'ECHEVERRY TRUJILLO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-08', 404010.00, 'A'),
    (895, 1, 'CAJIA PEDRAZA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-02', 867700.00, 'A'),
    (896, 2, 'PALACIOS OLIVA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-05-24', 126500.00, 'A'),
    (897, 1, 'GUTIERREZ QUINTERO FABIAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2009-10-24', 29380.00, 'A'),
    (899, 3, 'COBO GUEVARA LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-12-09', 748860.00, 'A'),
    (9, 1, 'OSORIO RODRIGUEZ FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-09-27', 904420.00, 'A'),
    (90, 1, 'LEYTON GONZALEZ FREDY RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-24', 705130.00, 'A'),
    (901, 1, 'HERNANDEZ JOSE ANGEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 130266, '2011-05-23', 964010.00, 'A'),
    (903, 3, 'GONZALEZ MALDONADO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2010-11-13', 576500.00, 'A'),
    (904, 1, 'OCHOA BARRIGA JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 130266, '2011-05-05', 401380.00, 'A'),
    ('CELL3886', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (905, 1, 'OSORIO REDONDO JESUS DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127300, '2011-08-11', 277390.00, 'A'),
    (906, 1, 'BAYONA BARRIENTOS JEAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-01-25', 182820.00, 'A'),
    (907, 1, 'MARTINEZ GOMEZ CARLOS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2010-03-11', 81940.00, 'A'),
    (908, 1, 'PUELLO LOPEZ GUILLERMO LEON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-08-12', 861240.00, 'A'),
    (909, 1, 'MOGOLLON LONDONO PEDRO LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2011-06-22', 60380.00, 'A'),
    (91, 1, 'ORTIZ RIOS JAVIER ADOLFO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-12', 813200.00, 'A'),
    (911, 1, 'HERRERA HOYOS CARLOS FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2010-09-12', 409800.00, 'A'),
    (912, 3, 'RIM MYUNG HWAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-15', 894450.00, 'A'),
    (913, 3, 'BIANCO DORIEN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-29', 242820.00, 'A'),
    (914, 3, 'FROIMZON WIEN DANIEL', 191821112, 'CRA 25 CALLE 100', '348@yahoo.com', '2011-02-03', 132165, '2010-11-06', 530780.00, 'A'),
    (915, 3, 'ALVEZ AZEVEDO JOAO MIGUEL', 191821112, 'CRA 25 CALLE 100', '861@hotmail.es', '2011-02-03', 127591, '2009-06-25', 925420.00, 'A'),
    (916, 3, 'CARRASCO DIAZ LUIS ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-02', 34780.00, 'A'),
    (917, 3, 'VIVALLOS MEDINA LEONEL EDMUNDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2010-09-12', 397640.00, 'A'),
    (919, 3, 'LASSE ANDRE BARKLIEN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 286724, '2011-03-31', 226390.00, 'A'),
    (92, 1, 'CUERVO CARDENAS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-08', 950630.00, 'A'),
    (920, 3, 'BARCELOS PLOTEGHER LILIA MARA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-07', 480380.00, 'A'),
    (921, 1, 'JARAMILLO ARANGO JUAN DIEGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127559, '2011-06-28', 722700.00, 'A'),
    (93, 3, 'RUIZ PRIETO WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 131272, '2011-01-19', 313540.00, 'A'),
    (932, 7, 'COMFENALCO ANTIOQUIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-05', 515430.00, 'A'),
    (94, 1, 'GALLEGO JUAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-25', 715830.00, 'A'),
    (944, 3, 'KARMELIC PAVLOV VESNA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 120066, '2010-08-07', 585580.00, 'A'),
    (945, 3, 'RAMIREZ BORDON OSCAR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-07-02', 526250.00, 'A'),
    (946, 3, 'SORACCO CABEZA RODRIGO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-07-04', 874490.00, 'A'),
    (949, 1, 'GALINDO JORGE ERNESTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127300, '2008-07-10', 344110.00, 'A'),
    (950, 3, 'DR KNABLE THOMAS ERNST ALBERT', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 256231, '2009-11-17', 685430.00, 'A'),
    (953, 3, 'VELASQUEZ JANETH', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-20', 404650.00, 'A'),
    (954, 3, 'SOZA REX JOSE FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 150903, '2011-05-26', 269790.00, 'A'),
    (955, 3, 'FONTANA GAETE JAIME PATRICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-01-11', 134970.00, 'A'),
    (957, 3, 'PEREZ MARTINEZ GRECIA INDIRA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2010-08-27', 922610.00, 'A'),
    (96, 1, 'FORERO CUBILLOS JORGEARTURO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-25', 45020.00, 'A'),
    (97, 1, 'SILVA ACOSTA MARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-19', 309580.00, 'A'),
    (978, 3, 'BLUMENTHAL JAIRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117630, '2010-04-22', 653490.00, 'A'),
    (984, 3, 'SUN XIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-01-17', 203630.00, 'A'),
    (99, 1, 'CANO GUZMAN ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 135620.00, 'A'),
    (999, 1, 'DRAGER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-12-22', 882070.00, 'A'),
    ('CELL1020', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1021', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1083', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1153', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1179', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1183', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL126', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1326', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1329', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL133', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1413', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1426', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1529', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1614', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1651', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1760', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL179', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1857', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1879', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1902', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1921', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1962', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1992', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2006', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL206', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL215', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2187', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2307', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2322', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2497', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2641', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2736', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2805', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL281', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2905', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2963', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3029', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3090', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3161', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3302', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3309', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3325', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3372', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3422', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3514', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3562', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3614', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3652', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3661', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4334', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4415', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4440', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4547', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4639', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4662', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4698', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL475', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4790', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4838', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4885', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4939', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5064', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5066', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL51', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5102', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5116', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5187', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5192', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5206', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5226', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5250', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5282', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL536', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5401', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5415', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5503', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5506', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL554', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5544', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5595', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5648', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5801', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5821', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6179', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6201', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6277', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6288', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6358', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6369', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6408', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6418', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6425', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6439', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6509', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6533', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6556', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL673', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6731', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6766', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6775', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6802', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6834', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6842', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6890', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6953', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6957', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7024', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7198', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7216', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL728', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7314', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7316', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7418', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7431', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7432', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7513', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7522', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7617', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7623', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7708', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7777', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL787', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7907', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7951', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7956', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8004', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8058', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL811', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8136', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8162', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8187', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8286', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8300', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8316', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8339', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8366', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8389', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8446', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8487', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8546', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8578', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8643', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8774', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8829', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8846', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8942', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9046', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9110', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL917', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9189', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9206', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9241', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9331', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9429', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9434', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9495', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9517', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9558', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9650', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9748', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9830', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9842', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9878', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9893', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9945', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('T-Cx200', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx201', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx202', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx203', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx204', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx205', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx206', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx207', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx208', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx209', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx210', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx211', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx212', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx213', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx214', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('CELL4021', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5255', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5730', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2540', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7376', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2614', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5471', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2588', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL570', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2854', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6683', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1382', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2051', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7086', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9220', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9701', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A');

--
-- Data for Name: personnes; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO personnes (cedula, tipo_documento_id, nombres, telefono, direccion, email, fecha_nacimiento, ciudad_id, creado_at, cupo, estado) VALUES
    (1, 3, 'HUANG ZHENGQUIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-18', 6930.00, 'I'),
    (100, 1, 'USME FERNANDEZ JUAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-04-15', 439480.00, 'A'),
    (1003, 8, 'SINMON PEREZ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-25', 468610.00, 'A'),
    (1009, 8, 'ARCINIEGAS Y VILLAMIZAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-08-12', 967680.00, 'A'),
    (101, 1, 'CRANE DE NARVAEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-06-09', 790540.00, 'A'),
    (1011, 8, 'EL EVENTO', 191821112, 'CRA 25 CALLE 100', '596@terra.com.co', '2011-02-03', 127591, '2011-05-24', 820390.00, 'A'),
    (1020, 7, 'OSPINA YOLANDA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-02', 222970.00, 'A'),
    (1025, 7, 'CHEMIPLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-08', 918670.00, 'A'),
    (1034, 1, 'TAXI FILMS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-09-01', 962580.00, 'A'),
    (104, 1, 'CASTELLANOS JIMENEZ NOE', 191821112, 'CRA 25 CALLE 100', '127@yahoo.es', '2011-02-03', 127591, '2011-10-05', 95230.00, 'A'),
    (1046, 3, 'JACQUET PIERRE MICHEL ALAIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 263489, '2011-07-23', 90810.00, 'A'),
    (1048, 5, 'SPOERER VELEZ CARLOS JORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-02-03', 184920.00, 'A'),
    (1049, 3, 'SIDNEI DA SILVA LUIZ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117630, '2011-07-02', 850180.00, 'A'),
    (105, 1, 'HERRERA SEQUERA ALVARO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-26', 77390.00, 'A'),
    (1050, 3, 'CAVALCANTI YUE CARLA HANLI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-31', 696130.00, 'A'),
    (1052, 1, 'BARRETO RIVAS ELKIN MARTIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 131508, '2011-09-19', 562160.00, 'A'),
    (1053, 3, 'WANDERLEY ANTONIO ERNESTO THOME', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150617, '2011-01-31', 20490.00, 'A'),
    (1054, 3, 'HE SHAN', 191821112, 'CRA 25 CALLE 100', '715@yahoo.es', '2011-02-03', 132958, '2010-10-05', 415970.00, 'A'),
    (1055, 3, 'ZHRNG XIM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-05', 18380.00, 'A'),
    (1057, 3, 'NICKEL GEB. STUTZ KARIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-10-08', 164850.00, 'A'),
    (1058, 1, 'VELEZ PAREJA IGNACIO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132775, '2011-06-24', 292250.00, 'A'),
    (1059, 3, 'GURKE RALF ERNST', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 287570, '2011-06-15', 966700.00, 'A'),
    (106, 1, 'ESTRADA LONDONO JUAN SIMON', 191821112, 'CRA 25 CALLE 100', '8@terra.com.co', '2011-02-03', 128579, '2011-03-09', 101260.00, 'A'),
    (1060, 1, 'MEDRANO BARRIOS WILSON', 191821112, 'CRA 25 CALLE 100', '479@facebook.com', '2011-02-03', 132775, '2011-06-18', 956740.00, 'A'),
    (1061, 1, 'GERDTS PORTO HANS EDUARDO', 191821112, 'CRA 25 CALLE 100', '140@gmail.com', '2011-02-03', 127591, '2011-05-09', 883590.00, 'A'),
    (1062, 1, 'BORGE VISBAL JORGE FIDEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132775, '2011-07-14', 547750.00, 'A'),
    (1063, 3, 'GUTIERREZ JOSELYN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-06', 87960.00, 'A'),
    (1064, 4, 'OVIEDO PINZON MARYI YULEY', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127538, '2011-04-21', 796560.00, 'A'),
    (1065, 1, 'VILORA SILVA OMAR ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2010-06-09', 718910.00, 'A'),
    (1066, 3, 'AGUIAR ROMAN RODRIGO HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126674, '2011-06-28', 204890.00, 'A'),
    (1067, 1, 'GOMEZ AGAMEZ ADOLFO DEL CRISTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 131105, '2011-06-15', 867730.00, 'A'),
    (1068, 3, 'GARRIDO CECILIA', 191821112, 'CRA 25 CALLE 100', '973@yahoo.com.mx', '2011-02-03', 118777, '2010-08-16', 723980.00, 'A'),
    (1069, 1, 'JIMENEZ MANJARRES DAVID RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132775, '2010-12-17', 16680.00, 'A'),
    (107, 1, 'ARANGUREN TEJADA JORGE ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-16', 274110.00, 'A'),
    (1070, 3, 'OYARZUN TEJEDA ANDRES FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-26', 911490.00, 'A'),
    (1071, 3, 'MARIN BUCK RAFAEL ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126180, '2011-05-04', 507400.00, 'A'),
    (1072, 3, 'VARGAS JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126674, '2011-07-28', 802540.00, 'A'),
    (1073, 3, 'JUEZ JAIRALA JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126180, '2010-04-09', 490510.00, 'A'),
    (1074, 1, 'APONTE PENSO HERNAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132879, '2011-05-27', 44900.00, 'A'),
    (1075, 1, 'PINERES BUSTILLO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126916, '2008-10-29', 752980.00, 'A'),
    (1076, 1, 'OTERA OMA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-04-29', 630210.00, 'A'),
    (1077, 3, 'CONTRERAS CHINCHILLA JUAN DOMINGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 139844, '2011-06-21', 892110.00, 'A'),
    (1078, 1, 'GAMBA LAURENCIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-09-15', 569940.00, 'A'),
    (108, 1, 'MUNOZ ARANGO JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-01', 66770.00, 'A'),
    (1080, 1, 'PRADA ABAUZA CARLOS AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-11-15', 156870.00, 'A'),
    (1081, 1, 'PAOLA CAROLINA PINTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-27', 264350.00, 'A'),
    (1082, 1, 'PALOMINO HERNANDEZ GERMAN JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-03-22', 851120.00, 'A'),
    (1084, 1, 'URIBE DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '602@hotmail.es', '2011-02-03', 127591, '2011-09-07', 759470.00, 'A'),
    (1085, 1, 'ARGUELLO CALDERON ARMANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-24', 409660.00, 'A'),
    (1087, 1, 'CARVAJAL HERNANDEZ CHRISTIAN ARMANDO', 191821112, 'CRA 25 CALLE 100', '296@yahoo.es', '2011-02-03', 159432, '2011-06-03', 620410.00, 'A'),
    (1088, 1, 'CASTRO BLANCO MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150512, '2009-10-08', 792400.00, 'A'),
    (1089, 1, 'RIBEROS GUTIERREZ GUSTAVO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-01-27', 100800.00, 'A'),
    (109, 1, 'BELTRAN MARIA LUZ DARY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-06', 511510.00, 'A'),
    (1091, 4, 'ORTIZ ORTIZ BENIGNO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127538, '2011-08-05', 331540.00, 'A'),
    (1092, 3, 'JOHN CHRISTOPHER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-08', 277320.00, 'A'),
    (1093, 1, 'PARRA VILLAREAL MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 129499, '2011-08-23', 391980.00, 'A'),
    (1094, 1, 'BESGA RODRIGUEZ JUAN JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127300, '2011-09-23', 127960.00, 'A'),
    (1095, 1, 'ZAPATA MEZA EDGAR FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129499, '2011-05-19', 463840.00, 'A'),
    (1096, 3, 'CORNEJO BRAVO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2010-11-08', 935340.00, 'A'),
    ('CELL3944', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1099, 1, 'GARCIA PORRAS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-14', 243360.00, 'A'),
    (11, 1, 'HERNANDEZ PARDO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-31', 197540.00, 'A'),
    (110, 1, 'VANEGAS JULIAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-06', 357260.00, 'A'),
    (1101, 1, 'QUINTERO BURBANO GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129499, '2011-08-20', 57420.00, 'A'),
    (1102, 1, 'BOHORQUEZ AFANADOR CHRISTIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-19', 214610.00, 'A'),
    (1103, 1, 'MORA VARGAS JULIO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-29', 900790.00, 'A'),
    (1104, 1, 'PINEDA JORGE ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-21', 860110.00, 'A'),
    (1105, 1, 'TORO CEBALLOS GONZALO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 129499, '2011-08-18', 598180.00, 'A'),
    (1106, 1, 'SCHENIDER TORRES JAIME', 191821112, 'CRA 25 CALLE 100', '85@yahoo.com.mx', '2011-02-03', 127799, '2011-08-11', 410590.00, 'A'),
    (1107, 1, 'RUEDA VILLAMIZAR JAIME', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-11-15', 258410.00, 'A'),
    (1108, 1, 'RUEDA VILLAMIZAR RICARDO JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129499, '2011-03-22', 60260.00, 'A'),
    (1109, 1, 'GOMEZ RODRIGUEZ HERNANDO ARTURO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-06-02', 526080.00, 'A'),
    (111, 1, 'FRANCISCO EDUARDO JAIME BOTERO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-09-09', 251770.00, 'A'),
    (1110, 1, 'HERNANDEZ MENDEZ EDGAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 129499, '2011-03-22', 449610.00, 'A'),
    (1113, 1, 'LEON HERNANDEZ OSCAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129499, '2011-03-21', 992090.00, 'A'),
    (1114, 1, 'LIZARAZO CARRENO HUGO ARCENIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2010-12-10', 959490.00, 'A'),
    (1115, 1, 'LIAN BARRERA GABRIEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-05-30', 821170.00, 'A'),
    (1117, 3, 'TELLEZ BEZAN FRANCISCO JAVIER ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2011-08-21', 673430.00, 'A'),
    (1118, 1, 'FUENTES ARIZA DIEGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-09', 684970.00, 'A'),
    (1119, 1, 'MOLINA M. ROBINSON', 191821112, 'CRA 25 CALLE 100', '728@hotmail.com', '2011-02-03', 129447, '2010-09-19', 404580.00, 'A'),
    (112, 1, 'PATINO PINTO ARIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-06', 187050.00, 'A'),
    (1120, 1, 'ORTIZ DURAN BENIGNO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127538, '2011-08-05', 967970.00, 'A'),
    (1121, 1, 'CARVAJAL ALMEIDA LUIS RAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129499, '2011-06-22', 626140.00, 'A'),
    (1122, 1, 'TORRES QUIROGA EDWIN SILVESTRE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 129447, '2011-08-17', 226780.00, 'A'),
    (1123, 1, 'VIVIESCAS JAIMES ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-10', 255480.00, 'A'),
    (1124, 1, 'MARTINEZ RUEDA JAVIER EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129447, '2011-06-23', 597040.00, 'A'),
    (1125, 1, 'ANAYA FLORES JORGE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129499, '2011-06-04', 218790.00, 'A'),
    (1126, 3, 'TORRES MARTINEZ ANTONIO JESUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2010-09-02', 302820.00, 'A'),
    (1127, 3, 'CACHO LEVISIER JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 153276, '2009-06-25', 857720.00, 'A'),
    (1129, 3, 'ULLOA VALDIVIESO CRISTIAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-06-02', 327570.00, 'A'),
    (113, 1, 'HIGUERA CALA JAIME ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-27', 179950.00, 'A'),
    (1130, 1, 'ARCINIEGAS WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126892, '2011-08-05', 497420.00, 'A'),
    (1131, 1, 'BAZA ACUNA JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 129447, '2010-12-10', 504410.00, 'A'),
    (1132, 3, 'BUIRA ROS CARLOS MARIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-04-27', 29750.00, 'A'),
    (1133, 1, 'RODRIGUEZ JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 129447, '2011-06-10', 635560.00, 'A'),
    (1134, 1, 'QUIROGA PEREZ NELSON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 129447, '2011-05-18', 88520.00, 'A'),
    (1135, 1, 'TATIANA AYALA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127122, '2011-07-01', 535920.00, 'A'),
    (1136, 1, 'OSORIO BENEDETTI FABIAN AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132775, '2010-10-23', 414060.00, 'A'),
    (1139, 1, 'CELIS PINTO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2009-02-25', 964970.00, 'A'),
    (114, 1, 'VALDERRAMA CUERVO JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-02', 338590.00, 'A'),
    (1140, 1, 'ORTIZ ARENAS JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129499, '2009-10-21', 613300.00, 'A'),
    (1141, 1, 'VALDIVIESO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 134022, '2009-01-13', 171590.00, 'A'),
    (1144, 1, 'LOPEZ CASTILLO NELSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 129499, '2010-09-09', 823110.00, 'A'),
    (1145, 1, 'CAVELIER LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126916, '2008-11-29', 389220.00, 'A'),
    (1146, 1, 'CAVELIER OTOYA LUIS EDURDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126916, '2010-05-25', 476770.00, 'A'),
    (1147, 1, 'GARCIA RUEDA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '111@yahoo.es', '2011-02-03', 133535, '2010-09-12', 216190.00, 'A'),
    (1148, 1, 'LADINO GOMEZ OMAR ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-02', 650640.00, 'A'),
    (1149, 1, 'CARRENO ORTIZ OSCAR JAVIER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-15', 604630.00, 'A'),
    (115, 1, 'NARDEI BONILLO BRUNO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-16', 153110.00, 'A'),
    (1150, 1, 'MONTOYA BOZZI MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 129499, '2011-05-12', 71240.00, 'A'),
    (1152, 1, 'LORA RICHARD JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-09-15', 497700.00, 'A'),
    (1153, 1, 'SILVA PINZON MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '915@hotmail.es', '2011-02-03', 127591, '2011-06-15', 861670.00, 'A'),
    (1154, 3, 'GEORGE J A KHALILIEH', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-20', 815260.00, 'A'),
    (1155, 3, 'CHACON MARIN CARLOS MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-07-26', 491280.00, 'A'),
    (1156, 3, 'OCHOA CHEHAB XAVIER ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 126180, '2011-06-13', 10630.00, 'A'),
    (1157, 3, 'ARAYA GARRI GABRIEL ALEXIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-09-19', 579320.00, 'A'),
    (1158, 3, 'MACCHI ARIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116366, '2010-04-12', 864690.00, 'A'),
    (116, 1, 'GONZALEZ FANDINO JAIME EDUARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-10', 749800.00, 'A'),
    (1160, 1, 'CAVALIER LUIS EDUARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126916, '2009-08-27', 333390.00, 'A'),
    ('CELL396', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1161, 3, 'DOMINGUEZ DE OBREGON ILEANA DEL CARMEN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 139844, '2011-03-06', 910490.00, 'A'),
    (1162, 2, 'FALASCA CLAUDIO ARIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116511, '2011-07-10', 552280.00, 'A'),
    (1163, 3, 'MUTABARUKA PATRICK', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131352, '2011-03-22', 29940.00, 'A'),
    (1164, 1, 'DOMINGUEZ ATENCIA JIMMY CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-07-22', 492860.00, 'A'),
    (1165, 4, 'LLANO GONZALEZ ALBERTO MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127300, '2010-08-21', 374490.00, 'A'),
    (1166, 3, 'LOPEZ ROLDAN JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-07-31', 393860.00, 'A'),
    (1167, 1, 'GUTIERREZ DE PINERES JALILIE ARISTIDES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2010-12-09', 845810.00, 'A'),
    (1168, 1, 'HEYMANS PIERRE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2010-11-08', 47470.00, 'A'),
    (1169, 1, 'BOTERO OSORIO RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2009-05-27', 699940.00, 'A'),
    (1170, 3, 'GARNHAM POBLETE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 116396, '2011-03-27', 357270.00, 'A'),
    (1172, 1, 'DAJUD DURAN JOSE RODRIGO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2009-12-02', 360910.00, 'A'),
    (1173, 1, 'MARTINEZ MERCADO PEDRO PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-07-25', 744930.00, 'A'),
    (1174, 1, 'GARCIA AMADOR ANDRES EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-05-19', 641930.00, 'A'),
    (1176, 1, 'VARGAS VARELA LUIS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 131568, '2011-08-30', 948410.00, 'A'),
    (1178, 1, 'GUTIERRES DE PINERES ARISTIDES', 191821112, 'CRA 25 CALLE 100', '217@hotmail.com', '2011-02-03', 133535, '2011-05-10', 242490.00, 'A'),
    (1179, 3, 'LEIZAOLA POZO JIMENA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132958, '2011-08-01', 759800.00, 'A'),
    (118, 1, 'FERNANDEZ VELOSO PEDRO HERNANDO', 191821112, 'CRA 25 CALLE 100', '452@hotmail.es', '2011-02-03', 128662, '2010-08-06', 198830.00, 'A'),
    (1180, 3, 'MARINO PAOLO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-12-24', 71520.00, 'A'),
    (1181, 1, 'MOLINA VIZCAINO GUSTAVO JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-04-28', 78220.00, 'A'),
    (1182, 3, 'MEDEL GARCIA FABIAN RODRIGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-04-25', 176540.00, 'A'),
    (1183, 1, 'LESMES ARIAS RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-09-09', 648020.00, 'A'),
    (1184, 1, 'ALCALA MARTINEZ ALFREDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132775, '2010-07-23', 710470.00, 'A'),
    (1186, 1, 'LLAMAS FOLIACO LUIS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-07', 910210.00, 'A'),
    (1187, 1, 'GUARDO DEL RIO LIBARDO FARID', 191821112, 'CRA 25 CALLE 100', '73@yahoo.com.mx', '2011-02-03', 128662, '2011-09-01', 726050.00, 'A'),
    (1188, 3, 'JEFFREY ARTHUR DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 115724, '2011-03-21', 899630.00, 'A'),
    (1189, 1, 'DAHL VELEZ JULIANA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126916, '2011-05-23', 320020.00, 'A'),
    (119, 3, 'WALESKA DE LIMA ALMEIDA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-05-09', 125240.00, 'A'),
    (1190, 3, 'LUIS JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2008-04-04', 901210.00, 'A'),
    (1192, 1, 'AZUERO VALENTINA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-14', 26310.00, 'A'),
    (1193, 1, 'MARQUEZ GALINDO MAURICIO JAVIER', 191821112, 'CRA 25 CALLE 100', '729@yahoo.es', '2011-02-03', 131105, '2011-05-13', 493560.00, 'A'),
    (1195, 1, 'NIETO FRANCO JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '707@yahoo.com', '2011-02-03', 127591, '2011-07-30', 463790.00, 'A'),
    (1196, 3, 'ESTEVES JOAQUIM LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-04-05', 152270.00, 'A'),
    (1197, 4, 'BARRERO KAREN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-12', 369990.00, 'A'),
    (1198, 1, 'CORRALES GUZMAN DELIO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127689, '2011-08-03', 393120.00, 'A'),
    (1199, 1, 'CUELLAR TOCO EDGAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127531, '2011-09-20', 855640.00, 'A'),
    (12, 1, 'MARIN PRIETO FREDY NELSON ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-23', 641210.00, 'A'),
    (120, 1, 'LOPEZ JARAMILLO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2009-04-17', 29680.00, 'A'),
    (1200, 3, 'SCHULTER ACHIM', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 291002, '2010-05-21', 98860.00, 'A'),
    (1201, 3, 'HOWELL LAURENCE ADRIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 286785, '2011-05-22', 927350.00, 'A'),
    (1202, 3, 'ALCAZAR ESCARATE JAIME PATRICIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2011-08-25', 340160.00, 'A'),
    (1203, 3, 'HIDALGO FUENZALIDA GABRIEL RAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-05-03', 918780.00, 'A'),
    (1206, 1, 'VANEGAS HENAO ORLANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-27', 832910.00, 'A'),
    (1207, 1, 'PENARANDA ARIAS RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-19', 832710.00, 'A'),
    (1209, 1, 'LEZAMA CERVERA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2011-09-14', 825980.00, 'A'),
    (121, 1, 'PULIDO JIMENEZ OSCAR HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-29', 772700.00, 'A'),
    (1211, 1, 'TRUJILLO BOCANEGRA HAROL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127538, '2011-05-27', 199260.00, 'A'),
    (1212, 1, 'ALVAREZ TORRES MARIO RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-08-15', 589960.00, 'A'),
    (1213, 1, 'CORRALES VARON BELMER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-26', 352030.00, 'A'),
    (1214, 3, 'CUEVAS RODRIGUEZ MANUELA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-30', 990250.00, 'A'),
    (1216, 1, 'LOPEZ EDICSON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-31', 505210.00, 'A'),
    (1217, 3, 'GARCIA PALOMARES JUAN JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-07-31', 840440.00, 'A'),
    (1218, 1, 'ARCINIEGAS NARANJO RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127492, '2010-12-17', 686610.00, 'A'),
    (122, 1, 'GONZALEZ RIANO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128031, '2011-08-05', 774450.00, 'A'),
    (1220, 1, 'GARCIA GUTIERREZ WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-06-20', 498680.00, 'A'),
    (1221, 3, 'GOMEZ DE ALONSO ANGELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-27', 758300.00, 'A'),
    (1222, 1, 'MEDINA QUIROGA JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127538, '2011-01-16', 295480.00, 'A'),
    (1224, 1, 'ARCILA CORREA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-03-20', 125900.00, 'A'),
    (1225, 1, 'QUIJANO REYES CARLOS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127538, '2010-04-08', 22100.00, 'A'),
    (157, 1, 'ORTIZ RIOS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-12', 365330.00, 'A'),
    (1226, 1, 'VARGAS GALLEGO JAIRO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2009-07-30', 732820.00, 'A'),
    (1228, 3, 'NAPANGA MIRENGHI MARTIN', 191821112, 'CRA 25 CALLE 100', '153@yahoo.es', '2011-02-03', 132958, '2011-02-08', 790400.00, 'A'),
    (123, 1, 'LAMUS CASTELLANOS ANDRES RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-11', 554160.00, 'A'),
    (1230, 1, 'RIVEROS PINEROS JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127492, '2011-09-25', 422220.00, 'A'),
    (1231, 3, 'ESSER JUAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127327, '2011-04-01', 635060.00, 'A'),
    (1232, 3, 'DOMINGUEZ MORA MAURICIO ALFREDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-22', 908630.00, 'A'),
    (1233, 3, 'MOLINA FERNANDEZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-05-28', 637990.00, 'A'),
    (1234, 3, 'BELLO DANIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 196234, '2010-09-04', 464040.00, 'A'),
    (1235, 3, 'BENADAVA GUEVARA DAVID ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-05-18', 406240.00, 'A'),
    (1236, 3, 'RODRIGUEZ MATOS ROBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-03-22', 639070.00, 'A'),
    (1237, 3, 'TAPIA ALARCON PATRICIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2010-07-06', 976620.00, 'A'),
    (1239, 3, 'VERCHERE ALFONSO CHRISTIAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2010-08-23', 899600.00, 'A'),
    (1241, 1, 'ESPINEL LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128206, '2009-03-09', 302860.00, 'A'),
    (1242, 3, 'VERGARA FERREIRA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-03', 713310.00, 'A'),
    (1243, 3, 'ZUMARRAGA SIRVENT CRSTINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-08-24', 657950.00, 'A'),
    (1244, 4, 'ESCORCIA VASQUEZ TOMAS', 191821112, 'CRA 25 CALLE 100', '354@yahoo.com.mx', '2011-02-03', 128662, '2011-04-01', 149830.00, 'A'),
    (1245, 4, 'PARAMO CUENCA KELLY LORENA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127492, '2011-05-04', 775300.00, 'A'),
    (1246, 4, 'PEREZ LOPEZ VERONICA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-07-11', 426990.00, 'A'),
    (1247, 4, 'CHAPARRO RODRIGUEZ DANIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-10-08', 809070.00, 'A'),
    (1249, 4, 'DIAZ MARTINEZ MARIA CAROLINA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2011-05-30', 394740.00, 'A'),
    (125, 1, 'CALDON RODRIGUEZ JAIME ARIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126968, '2011-07-29', 574780.00, 'A'),
    (1250, 4, 'PINEDA VASQUEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2010-09-03', 680540.00, 'A'),
    (1251, 5, 'MATIZ URIBE ANGELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-12-25', 218470.00, 'A'),
    (1253, 1, 'ZAMUDIO RICAURTE JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126892, '2011-08-05', 598160.00, 'A'),
    (1254, 1, 'ALJURE FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-07-21', 838660.00, 'A'),
    (1255, 3, 'ARMESTO AIRA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 196234, '2011-01-29', 398840.00, 'A'),
    (1257, 1, 'POTES GUEVARA JAIRO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127858, '2011-03-17', 194580.00, 'A'),
    (1258, 1, 'BURBANO QUIROGA RAFAEL', 191821112, 'CRA 25 CALLE 100', '767@facebook.com', '2011-02-03', 127591, '2011-04-07', 538220.00, 'A'),
    (1259, 1, 'CARDONA GOMEZ JAVIR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-03-16', 107380.00, 'A'),
    (126, 1, 'PULIDO PARDO GUIDO IVAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-05', 531550.00, 'A'),
    (1260, 1, 'LOPERA LEDESMA PABLO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-09-19', 922240.00, 'A'),
    (1263, 1, 'TRIBIN BARRIGA JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-09-02', 525330.00, 'A'),
    (1264, 1, 'NAVIA LOPEZ ANDRES FELIPE ', 191821112, 'CRA 25 CALLE 100', '353@hotmail.es', '2011-02-03', 127300, '2011-07-15', 591190.00, 'A'),
    (1265, 1, 'CARDONA GOMEZ FABIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2010-11-18', 379940.00, 'A'),
    (1266, 1, 'ESCARRIA VILLEGAS ANDRES JULIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-08-19', 126160.00, 'A'),
    (1268, 1, 'CASTRO HERNANDEZ ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-03-25', 76260.00, 'A'),
    (127, 1, 'RODRIGUEZ RODRIGUEZ GIOVANI FRANCISCO', 191821112, 'CRA 25 CALLE 100', '662@hotmail.es', '2011-02-03', 127591, '2011-09-29', 933390.00, 'A'),
    (1270, 1, 'LEAL HERNANDEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-24', 313610.00, 'A'),
    (1272, 1, 'ORTIZ CARDONA WILLIAM ENRIQUE', 191821112, 'CRA 25 CALLE 100', '914@hotmail.com', '2011-02-03', 128662, '2011-09-13', 272150.00, 'A'),
    (1273, 1, 'ROMERO VAN GOMPEL HERNAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-09-07', 832960.00, 'A'),
    (1274, 1, 'BERMUDEZ LONDONO JHON FREDY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127300, '2011-08-29', 348380.00, 'A'),
    (1275, 1, 'URREA ALVAREZ NICOLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-01', 242980.00, 'A'),
    (1276, 1, 'VALENCIA LLANOS RODRIGO AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-04-11', 169790.00, 'A'),
    (1277, 1, 'PAZ VALENCIA GUILLERMO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127300, '2011-08-05', 120020.00, 'A'),
    (1278, 1, 'MONROY CORREDOR GERARDO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-06-25', 90700.00, 'A'),
    (1279, 1, 'RIOS MEDINA JAVIER ERMINSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-09-12', 93440.00, 'A'),
    (128, 1, 'GALLEGO GUZMAN MARIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-06-25', 72290.00, 'A'),
    (1280, 1, 'GARCIA OSCAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127662, '2011-09-30', 195090.00, 'A'),
    (1282, 1, 'MURILLO PESELLIN GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-06-15', 890530.00, 'A'),
    (1284, 1, 'DIAZ ALVAREZ JOHNY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-06-25', 164130.00, 'A'),
    (1285, 1, 'GARCES BELTRAN RAUL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-08-11', 719220.00, 'A'),
    (1286, 1, 'MATERON POVEDA LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-25', 103710.00, 'A'),
    (1287, 1, 'VALENCIA ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-10-23', 360880.00, 'A'),
    (1288, 1, 'PENA AGUDELO JOSE RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 134022, '2011-05-25', 493280.00, 'A'),
    (1289, 1, 'CORREA NUNEZ JORGE ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-08-18', 383750.00, 'A'),
    (129, 1, 'ALVAREZ RODRIGUEZ IVAN RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2008-01-28', 561290.00, 'A'),
    (1291, 1, 'BEJARANO ROSERO FREDDY ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-10-09', 43400.00, 'A'),
    (1292, 1, 'CASTILLO BARRIOS GUSTAVO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-06-17', 900180.00, 'A'),
    ('CELL401', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1296, 1, 'GALVEZ GUTIERREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2010-03-28', 807090.00, 'A'),
    (1297, 3, 'CRUZ GARCIA MILTON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 139844, '2011-03-21', 75630.00, 'A'),
    (1298, 1, 'VILLEGAS GUTIERREZ JOSE RICARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-11', 956860.00, 'A'),
    (13, 1, 'VACA MURCIA JESUS ALFREDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-04', 613430.00, 'A'),
    (1301, 3, 'BOTTI ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 231989, '2011-04-04', 910640.00, 'A'),
    (1302, 3, 'COTINO HUESO LORENZO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-02-02', 803450.00, 'A'),
    (1304, 3, 'NESPOLI MANTOVANI LUIZ CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-04-18', 16230.00, 'A'),
    (1307, 4, 'AVILA GIL PAULA ANDREA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-19', 711110.00, 'A'),
    (1308, 4, 'VALLEJO PINEDA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-12', 323490.00, 'A'),
    (1312, 1, 'ROMERO OSCAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-17', 642460.00, 'A'),
    (1314, 3, 'LULLIES CONSTANZE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 245206, '2010-06-03', 154970.00, 'A'),
    (1315, 1, 'CHAPARRO GUTIERREZ JORGE ADRIANO', 191821112, 'CRA 25 CALLE 100', '284@hotmail.es', '2011-02-03', 127591, '2010-12-02', 325440.00, 'A'),
    (1316, 1, 'BARRANTES DISI RICARDO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132879, '2011-07-18', 162270.00, 'A'),
    (1317, 3, 'VERDES GAGO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2010-03-10', 835060.00, 'A'),
    (1319, 3, 'MARTIN MARTINEZ GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2010-05-26', 937220.00, 'A'),
    (1320, 3, 'MOTTURA MASSIMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2008-11-10', 620640.00, 'A'),
    (1321, 3, 'RUSSELL TIMOTHY JAMES', 191821112, 'CRA 25 CALLE 100', '502@hotmail.es', '2011-02-03', 145135, '2010-04-16', 291560.00, 'A'),
    (1322, 3, 'JAIN TARSEM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 190393, '2011-05-31', 595890.00, 'A'),
    (1323, 3, 'ORTEGA CEVALLOS JULIETA ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-30', 104760.00, 'A'),
    (1324, 3, 'MULLER PICHAIDA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-05-17', 736130.00, 'A'),
    (1325, 3, 'ALVEAR TELLEZ JULIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-01-23', 366390.00, 'A'),
    (1327, 3, 'MOYA LATORRE MARCELA CAROLINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-05-17', 18520.00, 'A'),
    (1328, 3, 'LAMA ZAROR RODRIGO IGNACIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2010-10-27', 221990.00, 'A'),
    (1329, 3, 'HERNANDEZ CIFUENTES MAURICE JEANETTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 139844, '2011-06-22', 54410.00, 'A'),
    (133, 1, 'CORDOBA HOYOS JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-20', 966820.00, 'A'),
    (1330, 2, 'HOCHKOFLER NOEMI CONSUELO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-27', 606070.00, 'A'),
    (1331, 4, 'RAMIREZ BARRERO DANIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 154563, '2011-04-18', 867120.00, 'A'),
    (1332, 4, 'DE LEON DURANGO RICARDO JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131105, '2011-09-08', 517400.00, 'A'),
    (1333, 4, 'RODRIGUEZ MACIAS IVAN MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129447, '2011-05-23', 985620.00, 'A'),
    (1334, 4, 'GUTIERREZ DE PINERES YANET MARIA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2011-06-16', 375890.00, 'A'),
    (1335, 4, 'GUTIERREZ DE PINERES YANET MARIA GABRIELA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-06-16', 922600.00, 'A'),
    (1336, 4, 'CABRALES BECHARA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '708@hotmail.com', '2011-02-03', 131105, '2011-05-13', 485330.00, 'A'),
    (1337, 4, 'MEJIA TOBON LUIS DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127662, '2011-08-05', 658860.00, 'A'),
    (1338, 3, 'OROS NERCELLES CRISTIAN ANDRE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 144215, '2011-04-26', 838310.00, 'A'),
    (1339, 3, 'MORENO BRAVO CAROLINA ANDREA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 190393, '2010-12-08', 214950.00, 'A'),
    (134, 1, 'GONZALEZ LOPEZ DANIEL ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-08', 178580.00, 'A'),
    (1340, 3, 'FERNANDEZ GARRIDO MARCELO FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-07-08', 559820.00, 'A'),
    (1342, 3, 'SUMEGI IMRE ZOLTAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-16', 91750.00, 'A'),
    (1343, 3, 'CALDERON FLANDEZ SERGIO', 191821112, 'CRA 25 CALLE 100', '108@hotmail.com', '2011-02-03', 117002, '2010-12-12', 996030.00, 'A'),
    (1345, 3, 'CARBONELL ATCHUGARRY GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116366, '2010-04-12', 536390.00, 'A'),
    (1346, 3, 'MONTEALEGRE AGUILAR FEDERICO ', 191821112, 'CRA 25 CALLE 100', '448@yahoo.es', '2011-02-03', 132165, '2011-08-08', 567260.00, 'A'),
    (1347, 1, 'HERNANDEZ MANCHEGO CARLOS JULIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-04-28', 227130.00, 'A'),
    (1348, 1, 'ARENAS ZARATE FERNEY ARNULFO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127963, '2011-03-26', 433860.00, 'A'),
    (1349, 3, 'DELFIM DINIZ PASSOS PINHEIRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 110784, '2010-04-17', 487930.00, 'A'),
    (135, 1, 'GARCIA SIMBAQUEBA RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-25', 992420.00, 'A'),
    (1350, 3, 'BRAUN VALENZUELA FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-29', 138050.00, 'A'),
    (1351, 3, 'LEVIN FIORELLI ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 116366, '2011-04-10', 226470.00, 'A'),
    (1353, 3, 'BALTODANO ESQUIVEL LAURA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132165, '2011-08-01', 911660.00, 'A'),
    (1354, 4, 'ESCOBAR  YEPES ANDREA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-19', 403630.00, 'A'),
    (1356, 1, 'GAGELI OSORIO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '228@yahoo.com.mx', '2011-02-03', 128662, '2011-07-14', 205070.00, 'A'),
    (1357, 3, 'CABAL ALVAREZ RUBEN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-08-14', 175770.00, 'A'),
    (1359, 4, 'HUERFANO JUAN DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-04', 790970.00, 'A'),
    (136, 1, 'OSORIO RAMIREZ LEONARDO', 191821112, 'CRA 25 CALLE 100', '686@yahoo.es', '2011-02-03', 128662, '2010-05-14', 426380.00, 'A'),
    (1360, 4, 'RAMON GARCIA MARIA PAULA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-01', 163890.00, 'A'),
    (1362, 30, 'ALVAREZ CLAVIO CARLA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127203, '2011-04-18', 741020.00, 'A'),
    (1363, 3, 'SERRA DURAN GERARDO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-08-03', 365490.00, 'A'),
    (1364, 3, 'NORIEGA VALVERDE SILVIA MARCELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132775, '2011-02-27', 604370.00, 'A'),
    (1366, 1, 'JARAMILLO LOPEZ ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '269@terra.com.co', '2011-02-03', 127559, '2010-11-08', 813800.00, 'A'),
    (1367, 1, 'MAZO ROLDAN CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-05-04', 292880.00, 'A'),
    (1368, 1, 'MURIEL ARCILA MAURICIO HERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-29', 22970.00, 'A'),
    (1369, 1, 'RAMIREZ CARLOS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-14', 236230.00, 'A'),
    (137, 1, 'LUNA PEREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126881, '2011-08-05', 154640.00, 'A'),
    (1370, 1, 'GARCIA GRAJALES PEDRO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128166, '2011-10-09', 112230.00, 'A'),
    (1372, 3, 'GARCIA ESCOBAR ANA MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-03-29', 925670.00, 'A'),
    (1373, 3, 'ALVES DIAS CARLOS AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-07', 70940.00, 'A'),
    (1374, 3, 'MATTOS CHRISTIANE GARCIA CID', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 183024, '2010-08-25', 577700.00, 'A'),
    (1376, 1, 'CARVAJAL ROJAS ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-10', 645240.00, 'A'),
    (1377, 3, 'MADARIAGA CADIZ CLAUDIO CRISTIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-10-04', 199200.00, 'A'),
    (1379, 3, 'MARIN YANEZ ALICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-02-20', 703870.00, 'A'),
    (138, 1, 'DIAZ AVENDANO MARCELO IVAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-22', 494080.00, 'A'),
    (1381, 3, 'COSTA VILLEGAS LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2011-08-21', 580670.00, 'A'),
    (1382, 3, 'DAZA PEREZ JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 122035, '2009-02-23', 888000.00, 'A'),
    (1385, 4, 'RIVEROS ARIAS MARIA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127492, '2011-09-26', 35710.00, 'A'),
    (1386, 30, 'TORO GIRALDO MATEO', 191821112, 'CRA 25 CALLE 100', '433@yahoo.com.mx', '2011-02-03', 127591, '2011-07-17', 700730.00, 'A'),
    (1387, 4, 'ROJAS YARA LAURA DANIELA MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-31', 396530.00, 'A'),
    (1388, 3, 'GALLEGO RODRIGO MARIA PILAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2009-04-19', 880450.00, 'A'),
    (1389, 1, 'PANTOJA VELASQUEZ JOSE ARMANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127300, '2011-08-05', 212660.00, 'A'),
    (139, 1, 'RANCO GOMEZ HERNÁN EDUARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-01-19', 6450.00, 'A'),
    (1390, 3, 'VAN DEN BORNE KEES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2010-01-28', 421930.00, 'A'),
    (1391, 3, 'MONDRAGON FLORES JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-08-22', 471700.00, 'A'),
    (1392, 3, 'BAGELLA MICHELE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-07-27', 92720.00, 'A'),
    (1393, 3, 'BISTIANCIC MACHADO ANA INES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 116366, '2010-08-02', 48490.00, 'A'),
    (1394, 3, 'BANADOS ORTIZ MARIA PILAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-08-25', 964280.00, 'A'),
    (1395, 1, 'CHINDOY CHINDOY HERNANDO', 191821112, 'CRA 25 CALLE 100', '107@terra.com.co', '2011-02-03', 126892, '2011-08-25', 675920.00, 'A'),
    (1396, 3, 'SOTO NUNEZ ANDRES ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-10-02', 486760.00, 'A'),
    (1397, 1, 'DELGADO MARTINEZ LORGE ELIAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-23', 406040.00, 'A'),
    (1398, 1, 'LEON GUEVARA JAVIER ANIBAL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126892, '2011-09-08', 569930.00, 'A'),
    (1399, 1, 'ZARAMA BASTIDAS LUIS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126892, '2011-08-05', 631540.00, 'A'),
    (14, 1, 'MAGUIN HENNSSEY LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '714@gmail.com', '2011-02-03', 127591, '2011-07-11', 143540.00, 'A'),
    (140, 1, 'CARRANZA CUY ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-25', 550010.00, 'A'),
    (1401, 3, 'REYNA CASTORENA JOSE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 189815, '2011-08-29', 344970.00, 'A'),
    (1402, 1, 'GFALLO BOTERO SERGIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-07-14', 381100.00, 'A'),
    (1403, 1, 'ARANGO ARAQUE JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-05-04', 870590.00, 'A'),
    (1404, 3, 'LASSNER NORBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118942, '2010-02-28', 209650.00, 'A'),
    (1405, 1, 'DURANGO MARIN HECTOR LEON', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '1970-02-02', 436480.00, 'A'),
    (1407, 1, 'FRANCO CASTANO DIEGO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-06-28', 457770.00, 'A'),
    (1408, 1, 'HERNANDEZ SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-05-29', 628550.00, 'A'),
    (1409, 1, 'CASTANO DUQUE CARLOS HUGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-03-23', 769410.00, 'A'),
    (141, 1, 'CHAMORRO CHEDRAUI SERGIO ALBERTO', 191821112, 'CRA 25 CALLE 100', '922@yahoo.com.mx', '2011-02-03', 127591, '2011-05-07', 730720.00, 'A'),
    (1411, 1, 'RAMIREZ MONTOYA ADAMO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-04-13', 498880.00, 'A'),
    (1412, 1, 'GONZALEZ BENJUMEA OSCAR HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-11-01', 610150.00, 'A'),
    (1413, 1, 'ARANGO ACEVEDO WALTER ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-10-07', 554090.00, 'A'),
    (1414, 1, 'ARANGO GALLO HUMBERTO LEON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-02-25', 940010.00, 'A'),
    (1415, 1, 'VELASQUEZ LUIS GONZALO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-07-06', 37760.00, 'A'),
    (1416, 1, 'MIRA AGUILAR FRANCISCO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-30', 368790.00, 'A'),
    (1417, 1, 'RIVERA ARISTIZABAL CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-03-02', 730670.00, 'A'),
    (1418, 1, 'ARISTIZABAL ROLDAN ANDRES RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-02', 546960.00, 'A'),
    (142, 1, 'LOPEZ ZULETA MAURICIO ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-01', 3550.00, 'A'),
    (1420, 1, 'ESCORCIA ARAMBURO JUAN MARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-04-01', 73100.00, 'A'),
    (1421, 1, 'CORREA PARRA RICARDO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-08-05', 737110.00, 'A'),
    (1422, 1, 'RESTREPO NARANJO DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-09-15', 466240.00, 'A'),
    (1423, 1, 'VELASQUEZ CARLOS JUAN', 191821112, 'CRA 25 CALLE 100', '123@yahoo.com', '2011-02-03', 128662, '2010-06-09', 119880.00, 'A'),
    (1424, 1, 'MACIA GONZALEZ ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2010-11-12', 200690.00, 'A'),
    (1425, 1, 'BERRIO MEJIA HELBER ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2010-06-04', 643800.00, 'A'),
    (1427, 1, 'GOMEZ GUTIERREZ CARLOS ARIEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-09-08', 153320.00, 'A'),
    (1428, 1, 'RESTREPO LOPEZ JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-12', 915770.00, 'A'),
    ('CELL4012', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1429, 1, 'BARTH TOBAR LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-02-23', 118900.00, 'A'),
    (143, 1, 'MUNERA BEDIYA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-09-21', 825600.00, 'A'),
    (1430, 1, 'JIMENEZ VELEZ ANDRES EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-02-26', 847160.00, 'A'),
    (1431, 1, 'TAKAHASHI GAVIRIA NICOLAS KEIICHIRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-13', 879120.00, 'A'),
    (1432, 1, 'ESCOBAR JARAMILLO ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-06-10', 854110.00, 'A'),
    (1433, 1, 'PALACIO NAVARRO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-08-18', 633200.00, 'A'),
    (1434, 1, 'LONDONO MUNOZ ADOLFO LEON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-09-14', 603670.00, 'A'),
    (1435, 1, 'PULGARIN JAIME ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2009-11-01', 118730.00, 'A'),
    (1436, 1, 'FERRERA ZULUAGA LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-07-10', 782630.00, 'A'),
    (1437, 1, 'VASQUEZ VELEZ HABACUC', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-27', 557000.00, 'A'),
    (1438, 1, 'HENAO PALOMINO DIEGO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2009-05-06', 437080.00, 'A'),
    (1439, 1, 'HURTADO URIBE JUAN GONZALO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-01-11', 514400.00, 'A'),
    (144, 1, 'ALDANA RODOLFO AUGUSTO', 191821112, 'CRA 25 CALLE 100', '838@yahoo.es', '2011-02-03', 127591, '2011-08-07', 117350.00, 'A'),
    (1441, 1, 'URIBE DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2010-11-19', 760610.00, 'A'),
    (1442, 1, 'PINEDA GALIANO JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-07-29', 20770.00, 'A'),
    (1443, 1, 'DUQUE BETANCOURT FABIO LEON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-26', 822030.00, 'A'),
    (1444, 1, 'JARAMILLO TORO HERNAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-04-27', 47830.00, 'A'),
    (145, 1, 'VASQUEZ ZAPATA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-09', 109940.00, 'A'),
    (1450, 1, 'TOBON FRANCO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '545@facebook.com', '2011-02-03', 127591, '2011-05-03', 889540.00, 'A'),
    (1454, 1, 'LOTERO PAVAS CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-05-28', 646750.00, 'A'),
    (1455, 1, 'ESTRADA HENAO JAVIER ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128569, '2009-09-07', 215460.00, 'A'),
    (1456, 1, 'VALDERRAMA MAXIMILIANO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-23', 137030.00, 'A'),
    (1457, 3, 'ESTRADA ALVAREZ GONZALO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 154903, '2011-05-02', 38790.00, 'A'),
    (1458, 1, 'PAUCAR VALLEJO JAIRO ALONSO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-10-15', 782860.00, 'A'),
    (1459, 1, 'RESTREPO GIRALDO JHON DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-04-04', 797930.00, 'A'),
    (146, 1, 'BAQUERO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-03-03', 197650.00, 'A'),
    (1460, 1, 'RESTREPO DOMINGUEZ GUSTAVO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2009-05-18', 641050.00, 'A'),
    (1461, 1, 'YANOVICH JACKY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-08-21', 811470.00, 'A'),
    (1462, 1, 'HINCAPIE ROLDAN JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-08-27', 134200.00, 'A'),
    (1463, 3, 'ZEA JORGE OLIVER', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2011-03-12', 236610.00, 'A'),
    (1464, 1, 'OSCAR MAURICIO ECHAVARRIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-11-24', 780440.00, 'A'),
    (1465, 1, 'COSSIO GIL JOSE ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-10-01', 192380.00, 'A'),
    (1466, 1, 'GOMEZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-03-01', 620580.00, 'A'),
    (1467, 1, 'VILLALOBOS OCHOA ANDRES GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-18', 525740.00, 'A'),
    (1470, 1, 'GARCIA GONZALEZ DAVID DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-09-17', 986990.00, 'A'),
    (1471, 1, 'RAMIREZ RESTREPO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-04-03', 162250.00, 'A'),
    (1472, 1, 'VASQUEZ GUTIERREZ JUAN ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-05', 850280.00, 'A'),
    (1474, 1, 'ESCOBAR ARANGO DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-11-01', 272460.00, 'A'),
    (1475, 1, 'MEJIA TORO JUAN DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-05-02', 68320.00, 'A'),
    (1477, 1, 'ESCOBAR GOMEZ JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127848, '2011-05-15', 416150.00, 'A'),
    (1478, 1, 'BETANCUR WILSON', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2008-02-09', 508060.00, 'A'),
    (1479, 3, 'ROMERO ARRAU GONZALO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-10', 291880.00, 'A'),
    (148, 1, 'REINA MORENO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-08', 699240.00, 'A'),
    (1480, 1, 'CASTANO OSORIO JORGE ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127662, '2011-09-20', 935200.00, 'A'),
    (1482, 1, 'LOPEZ LOPERA ROBINSON FREDY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-09-02', 196280.00, 'A'),
    (1484, 1, 'HERNAN DARIO RENDON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-03-18', 312520.00, 'A'),
    (1485, 1, 'MARTINEZ ARBOLEDA MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-11-03', 821760.00, 'A'),
    (1486, 1, 'RODRIGUEZ MORA CARLOS MORA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-09-16', 171270.00, 'A'),
    (1487, 1, 'PENAGOS VASQUEZ JOSE DOMINGO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-09-06', 391080.00, 'A'),
    (1488, 1, 'UERRA MEJIA DIEGO LEON', 191821112, 'CRA 25 CALLE 100', '704@hotmail.com', '2011-02-03', 144086, '2011-08-06', 441570.00, 'A'),
    (1491, 1, 'QUINTERO GUTIERREZ ABEL PASTOR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2009-11-16', 138100.00, 'A'),
    (1492, 1, 'ALARCON YEPES IVAN DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2010-05-03', 145330.00, 'A'),
    (1494, 1, 'HERNANDEZ VALLEJO ANDRES MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-09', 125770.00, 'A'),
    (1495, 1, 'MONTOYA MORENO LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-09', 691770.00, 'A'),
    (1497, 1, 'BARRERA CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '62@yahoo.es', '2011-02-03', 127591, '2010-08-24', 332550.00, 'A'),
    (1498, 1, 'ARROYAVE FERNANDEZ PABLO EMILIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-05-12', 418030.00, 'A'),
    (1499, 1, 'GOMEZ ANGEL FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-05-03', 92480.00, 'A'),
    (15, 1, 'AMSILI COHEN JOSEPH', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-07', 877400.00, 'A'),
    ('CELL411', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (150, 3, 'ARDILA GUTIERREZ DANIEL MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-12', 506760.00, 'A'),
    (1500, 1, 'GONZALEZ DUQUE PABLO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-04-13', 208330.00, 'A'),
    (1502, 1, 'MEJIA BUSTAMANTE JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-09', 196000.00, 'A'),
    (1506, 1, 'SUAREZ MONTOYA JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128569, '2011-09-13', 368250.00, 'A'),
    (1508, 1, 'ALVAREZ GONZALEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-02-15', 355190.00, 'A'),
    (1509, 1, 'NIETO CORREA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-31', 899980.00, 'A'),
    (1511, 1, 'HERNANDEZ GRANADOS JHONATHAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-08-30', 471720.00, 'A'),
    (1512, 1, 'CARDONA ALVAREZ DEIBY', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2010-10-05', 55590.00, 'A'),
    (1513, 1, 'TORRES MARULANDA JUAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-10-20', 862820.00, 'A'),
    (1514, 1, 'RAMIREZ RAMIREZ JHON JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-05-11', 147310.00, 'A'),
    (1515, 1, 'MONDRAGON TORO NICOLAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-01-19', 148100.00, 'A'),
    (1517, 3, 'SUIDA DIETER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2008-07-21', 48580.00, 'A'),
    (1518, 3, 'LEFTWICH ANDREW PAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 211610, '2011-06-07', 347170.00, 'A'),
    (1519, 3, 'RENTON ANDREW GEORGE PATRICK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2010-12-11', 590120.00, 'A'),
    (152, 1, 'BUSTOS MONZON CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-22', 335160.00, 'A'),
    (1521, 3, 'JOSE CUSTODIO DO ALTISSIMO NETONETO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 119814, '2011-04-28', 775000.00, 'A'),
    (1522, 3, 'GUARACI FRANCO DE PAIVA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 119167, '2011-04-28', 147770.00, 'A'),
    (1525, 4, 'MORENO TENORIO MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-20', 888750.00, 'A'),
    (1527, 1, 'VELASQUEZ HERNANDEZ JHON EDUARSON', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-07-19', 161270.00, 'A'),
    (1528, 4, 'VANEGAS ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '185@yahoo.com', '2011-02-03', 127591, '2011-06-20', 109830.00, 'A'),
    (1529, 3, 'BARBABE CLAIRE LAURENCE ANNICK', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-04', 65330.00, 'A'),
    (153, 1, 'GONZALEZ TORREZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-01', 762560.00, 'A'),
    (1530, 3, 'COREA MARTINEZ GUILLERMO JOSE ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 135360, '2011-09-25', 997190.00, 'A'),
    (1531, 3, 'PACHECO RODRIGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2010-03-08', 789960.00, 'A'),
    (1532, 3, 'WELCH RICHARD WILLIAM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 190393, '2010-10-04', 958210.00, 'A'),
    (1533, 3, 'FOREMAN CAROLYN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 107159, '2011-05-23', 421200.00, 'A'),
    (1535, 3, 'ZAGAL SOTO CLAUDIA PAZ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2008-05-16', 893130.00, 'A'),
    (1536, 3, 'ZAGAL SOTO CLAUDIA PAZ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-10-08', 771600.00, 'A'),
    (1538, 3, 'BLANCO RODRIGUEZ JUAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 197162, '2011-04-02', 578250.00, 'A'),
    (154, 1, 'HENDEZ PUERTO JAVIER ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-25', 807310.00, 'A'),
    (1540, 3, 'CONTRERAS BRAIN JAVIER ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-02-22', 42420.00, 'A'),
    (1541, 3, 'RONDON HERNANDEZ MARYLIN DEL CARMEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-09-29', 145780.00, 'A'),
    (1542, 3, 'ELJURI RAMIREZ EMIRA ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2010-10-13', 601670.00, 'A'),
    (1544, 3, 'REYES LE ROY TOMAS FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2009-06-24', 49990.00, 'A'),
    (1545, 3, 'GHETEA GAMUZ JENNY', 191821112, 'CRA 25 CALLE 100', '675@gmail.com', '2011-02-03', 150699, '2010-05-29', 536940.00, 'A'),
    (1546, 3, 'DUARTE GONZALEZ ROONEY ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-06-20', 534720.00, 'A'),
    (1548, 3, 'BIZOT PHILIPPE PIERRE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 263813, '2011-03-02', 709760.00, 'A'),
    (1549, 3, 'PELUFFO RUBIO GUILLERMO JUAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 116366, '2011-05-09', 360470.00, 'A'),
    (1550, 3, 'AGLIATI YERKOVIC CAROLINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2010-06-01', 673040.00, 'A'),
    (1551, 3, 'SEPULVEDA LEDEZMA HENRY CORNELIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-08-15', 283810.00, 'A'),
    (1552, 3, 'CABRERA CARMINE JAIME FRANCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2008-11-30', 399940.00, 'A'),
    (1553, 3, 'ZINNO PENA ALVARO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116366, '2010-08-02', 148270.00, 'A'),
    (1554, 3, 'ROMERO BUCCICARDI JUAN CRISTOBAL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-08-01', 541530.00, 'A'),
    (1555, 3, 'FEFERKORN ABRAHAM', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 159312, '2011-06-12', 262840.00, 'A'),
    (1556, 3, 'MASSE CATESSON CAROLINE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131272, '2011-06-12', 689600.00, 'A'),
    (1557, 3, 'CATESSON ALEXANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 131272, '2011-06-12', 659470.00, 'A'),
    (1558, 3, 'FUENTES HERNANDEZ RICARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-18', 228540.00, 'A'),
    (1559, 3, 'GUEVARA MENJIVAR WILSON ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-18', 164310.00, 'A'),
    (1560, 3, 'DANOWSKI NICOLAS JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-02', 135920.00, 'A'),
    (1561, 3, 'CASTRO VELASQUEZ ISMAEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 121318, '2011-07-31', 186670.00, 'A'),
    (1562, 3, 'RODRIGUEZ CORNEJO CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 525590.00, 'A'),
    (1563, 3, 'VANIA CAROLINA FLORES AVILA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-18', 67950.00, 'A'),
    (1564, 3, 'ARMERO RAMOS OSCAR ALEXANDER', 191821112, 'CRA 25 CALLE 100', '414@hotmail.com', '2011-02-03', 127591, '2011-09-18', 762950.00, 'A'),
    (1565, 3, 'ORELLANA MARTINEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-18', 610930.00, 'A'),
    (1566, 3, 'BRATT BABONNEAU CARLOS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-14', 765800.00, 'A'),
    (1567, 3, 'YANES FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150728, '2011-04-12', 996200.00, 'A'),
    (1568, 3, 'ANGULO TAMAYO SEBASTIAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126674, '2011-05-19', 683600.00, 'A'),
    (1569, 3, 'HENRIQUEZ JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 138329, '2011-08-15', 429390.00, 'A'),
    ('CELL4137', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1570, 3, 'GARCIA VILLARROEL RAUL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126189, '2011-06-12', 96140.00, 'A'),
    (1571, 3, 'SOLA HERNANDEZ JOSE FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-09-25', 192530.00, 'A'),
    (1572, 3, 'PEREZ PASTOR OSWALDO MAGARREY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126674, '2011-05-25', 674260.00, 'A'),
    (1573, 3, 'MICHAN QUINONES FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-06-21', 793680.00, 'A'),
    (1574, 3, 'GARCIA ARANDA OSCAR DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-08-15', 945620.00, 'A'),
    (1575, 3, 'GARCIA RIBAS JORDI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-10', 347070.00, 'A'),
    (1576, 3, 'GALVAN ROMERO MARIA INMACULADA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-09-14', 898480.00, 'A'),
    (1577, 3, 'BOSH MOLINAS JUAN JOSE ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 198576, '2011-08-22', 451190.00, 'A'),
    (1578, 3, 'MARTIN TENA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-04-24', 560520.00, 'A'),
    (1579, 3, 'HAWKINS ROBERT JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-12', 449010.00, 'A'),
    (1580, 3, 'GHERARDI ALEJANDRO EMILIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 180063, '2010-11-15', 563500.00, 'A'),
    (1581, 3, 'TELLO JUAN EDUARDO', 191821112, 'CRA 25 CALLE 100', '192@hotmail.com', '2011-02-03', 138329, '2011-05-01', 470460.00, 'A'),
    (1583, 3, 'GUZMAN VALDIVIA CINTIA TATIANA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 199862, '2011-04-06', 897580.00, 'A'),
    (1584, 3, 'STUBBS MERCEDES CARMEN JOSEFINA DEL MILAGRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 199862, '2011-04-06', 502510.00, 'A'),
    (1585, 3, 'QUINTEIRO GORIS JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-17', 819840.00, 'A'),
    (1587, 3, 'RIVAS LORIA PRISCILLA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 205636, '2011-05-01', 498720.00, 'A'),
    (1588, 3, 'DE LA TORRE AUGUSTO PATRICIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 20404, '2011-08-31', 718670.00, 'A'),
    (159, 1, 'ALDANA PATINO NORMAN ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2009-10-10', 201500.00, 'A'),
    (1590, 3, 'TORRES VILLAR ROBERTO ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-08-10', 329950.00, 'A'),
    (1591, 3, 'PETRULLI CARMELO MORENO', 191821112, 'CRA 25 CALLE 100', '883@yahoo.com.mx', '2011-02-03', 127591, '2011-06-20', 358180.00, 'A'),
    (1592, 3, 'MUSCO ENZO FRANCESCO GIUSEPPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-04', 801050.00, 'A'),
    (1593, 3, 'RONCUZZI CLAUDIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127134, '2011-10-02', 930700.00, 'A'),
    (1594, 3, 'VELANI FRANCESCA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 199862, '2011-08-22', 250360.00, 'A'),
    (1596, 3, 'BENARROCH ASSOR DAVID ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-10-06', 547310.00, 'A'),
    (1597, 3, 'FLO VILLASECA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-05-27', 357520.00, 'A'),
    (1598, 3, 'FONT RIBAS ANTONI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196117, '2011-09-21', 145660.00, 'A'),
    (1599, 3, 'LOPEZ BARAHONA MONICA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-08-03', 655740.00, 'A'),
    (16, 1, 'FLOREZ PEREZ GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132572, '2011-03-30', 956370.00, 'A'),
    (160, 1, 'GIRALDO MENDIVELSO MARTIN EDISSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-14', 429010.00, 'A'),
    (1600, 3, 'SCATTIATI ALDO ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 215245, '2011-07-10', 841730.00, 'A'),
    (1601, 3, 'MARONE CARLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 101179, '2011-06-14', 241420.00, 'A'),
    (1602, 3, 'CHUVASHEVA ELENA ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 190393, '2011-08-21', 681900.00, 'A'),
    (1603, 3, 'GIGLIO FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 122035, '2011-09-19', 685250.00, 'A'),
    (1604, 3, 'JUSTO AMATE AGUSTIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 174598, '2011-05-16', 380560.00, 'A'),
    (1605, 3, 'GUARDABASSI FABIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 281044, '2011-07-26', 847060.00, 'A'),
    (1606, 3, 'CALABRETTA FRAMCESCO ANTONIO MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 199862, '2011-08-22', 93590.00, 'A'),
    (1607, 3, 'TARTARINI MASSIMO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196234, '2011-05-10', 926800.00, 'A'),
    (1608, 3, 'BOTTI GIAIME', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 231989, '2011-04-04', 353210.00, 'A'),
    (1610, 3, 'PILERI ANDREA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 205040, '2011-09-01', 868590.00, 'A'),
    (1612, 3, 'MARTIN GRACIA LUIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-07-27', 324320.00, 'A'),
    (1613, 3, 'GRACIA MARTIN LUIS', 191821112, 'CRA 25 CALLE 100', '579@facebook.com', '2011-02-03', 198248, '2011-08-24', 463560.00, 'A'),
    (1614, 3, 'SERRAT SESE JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-05-16', 344840.00, 'A'),
    (1615, 3, 'DEL LAGO AMPELIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-06-29', 333510.00, 'A'),
    (1616, 3, 'PERUGORRIA RODRIGUEZ JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 148511, '2011-06-06', 633040.00, 'A'),
    (1617, 3, 'GIRAL CALVO IGNACIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-09-19', 164670.00, 'A'),
    (1618, 3, 'ALONSO CEBRIAN JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '253@terra.com.co', '2011-02-03', 188640, '2011-03-23', 924240.00, 'A'),
    (162, 1, 'ARIZA PINEDA JOHN ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-11-27', 415710.00, 'A'),
    (1620, 3, 'OLMEDO CARDENETE DOMINGO MIGUEL', 191821112, 'CRA 25 CALLE 100', '608@terra.com.co', '2011-02-03', 135397, '2011-09-03', 863200.00, 'A'),
    (1622, 3, 'GIMENEZ BALDRES ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 182860, '2011-05-12', 82660.00, 'A'),
    (1623, 3, 'NUNEZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-05-23', 609950.00, 'A'),
    (1624, 3, 'PENATE CASTRO WENCESLAO LORENZO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 153607, '2011-09-13', 801750.00, 'A'),
    (1626, 3, 'ESCODA MIGUEL JOAN JOSEP', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-07-18', 489310.00, 'A'),
    (1628, 3, 'ESTRADA CAPILLA ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-26', 81180.00, 'A'),
    (163, 1, 'PERDOMO LOPEZ ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-05', 456910.00, 'A'),
    (1630, 3, 'SUBIRAIS MARIANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-09-08', 138700.00, 'A'),
    (1632, 3, 'ENSENAT VELASCO JAIME LUIS', 191821112, 'CRA 25 CALLE 100', '687@gmail.com', '2011-02-03', 188640, '2011-04-12', 904560.00, 'A'),
    (1633, 3, 'DIEZ POLANCO CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-05-24', 530410.00, 'A'),
    (1636, 3, 'CUADRA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-09-04', 688400.00, 'A'),
    (1637, 3, 'UBRIC MUNOZ RAUL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 98790, '2011-05-30', 139830.00, 'A'),
    ('CELL4159', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1638, 3, 'NEDDERMANN GUJO RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-31', 633990.00, 'A'),
    (1639, 3, 'RENEDO ZALBA JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-03-13', 750430.00, 'A'),
    (164, 1, 'JIMENEZ PADILLA JOHAN MARCEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-05', 37430.00, 'A'),
    (1640, 3, 'FERNANDEZ MORENO DAVID', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-05-28', 850180.00, 'A'),
    (1641, 3, 'VERGARA SERRANO JUAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-06-30', 999620.00, 'A'),
    (1642, 3, 'MARTINEZ HUESO LUCAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 182860, '2011-06-29', 447570.00, 'A'),
    (1643, 3, 'FRANCO POBLET JUAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-10-03', 238990.00, 'A'),
    (1644, 3, 'MORA HIDALGO MIGUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-06', 852250.00, 'A'),
    (1645, 3, 'GARCIA COSO EMILIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-09-14', 544260.00, 'A'),
    (1646, 3, 'GIMENO ESCRIG ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 180124, '2011-09-20', 164580.00, 'A'),
    (1647, 3, 'MORCILLO LOPEZ RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127538, '2011-04-16', 190090.00, 'A'),
    (1648, 3, 'RUBIO BONET MANUEL', 191821112, 'CRA 25 CALLE 100', '252@facebook.com', '2011-02-03', 196234, '2011-05-25', 456740.00, 'A'),
    (1649, 3, 'PRADO ABUIN FERNANDO ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-07-16', 713400.00, 'A'),
    (165, 1, 'RAMIREZ PALMA LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-10', 816420.00, 'A'),
    (1650, 3, 'DE VEGA PUJOL GEMA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-08-01', 196780.00, 'A'),
    (1651, 3, 'IBARGUEN ALFREDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2010-12-03', 843720.00, 'A'),
    (1652, 3, 'IBARGUEN ALFREDO', 191821112, 'CRA 25 CALLE 100', '856@hotmail.com', '2011-02-03', 188640, '2011-06-18', 628250.00, 'A'),
    (1654, 3, 'MATELLANES RODRIGUEZ NURIA PILAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-10-05', 165770.00, 'A'),
    (1656, 3, 'VIDAURRAZAGA GUISOLA JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2011-08-08', 495320.00, 'A'),
    (1658, 3, 'GOMEZ ULLATE MARIA ELENA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-04-12', 919090.00, 'A'),
    (1659, 3, 'ALCAIDE ALONSO JUAN MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-05-02', 152430.00, 'A'),
    (166, 1, 'TUSTANOSKI RODOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-12-03', 969790.00, 'A'),
    (1660, 3, 'LARROY GARCIA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-14', 4900.00, 'A'),
    (1661, 3, 'FERNANDEZ POYATO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-10', 567180.00, 'A'),
    (1662, 3, 'TREVEJO PARDO JULIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-25', 821200.00, 'A'),
    (1663, 3, 'GORGA CASSINELLI VICTOR DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-30', 404490.00, 'A'),
    (1664, 3, 'MORUECO GONZALEZ JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-10-09', 558820.00, 'A'),
    (1665, 3, 'IRURETA FERNANDEZ PEDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 214283, '2011-09-14', 580650.00, 'A'),
    (1667, 3, 'TREVEJO PARDO JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-25', 392020.00, 'A'),
    (1668, 3, 'BOCOS NUNEZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-10-08', 279710.00, 'A'),
    (1669, 3, 'LUIS CASTILLO JOSE AGUSTIN', 191821112, 'CRA 25 CALLE 100', '557@hotmail.es', '2011-02-03', 168202, '2011-06-16', 222500.00, 'A'),
    (167, 1, 'HURTADO BELALCAZAR JOHN JADY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127300, '2011-08-17', 399710.00, 'A'),
    (1670, 3, 'REDONDO GUTIERREZ EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-09-14', 273350.00, 'A'),
    (1671, 3, 'MADARIAGA ALONSO RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-07-26', 699240.00, 'A'),
    (1673, 3, 'REY GONZALEZ LUIS JAVIER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-07-26', 283190.00, 'A'),
    (1676, 3, 'PEREZ ESTER ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-10-03', 274900.00, 'A'),
    (1677, 3, 'GOMEZ-GRACIA HUERTA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-22', 112260.00, 'A'),
    (1678, 3, 'DAMASO PUENTE DIEGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-25', 736600.00, 'A'),
    (168, 1, 'JUAN PABLO MARTINEZ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-15', 89160.00, 'A'),
    (1680, 3, 'DIEZ GONZALEZ LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-05-17', 521280.00, 'A'),
    (1681, 3, 'LOPEZ LOPEZ JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '853@yahoo.com', '2011-02-03', 196234, '2010-12-13', 567760.00, 'A'),
    (1682, 3, 'MIRO LINARES FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133442, '2011-09-03', 274930.00, 'A'),
    (1683, 3, 'ROCA PINTADO MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-05-16', 671410.00, 'A'),
    (1684, 3, 'GARCIA BARTOLOME HORACIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-09-29', 532220.00, 'A'),
    (1686, 3, 'BALMASEDA DE AHUMADA DIEZ JUAN LUIS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 168202, '2011-04-13', 637860.00, 'A'),
    (1687, 3, 'FERNANDEZ IMAZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-04-10', 248580.00, 'A'),
    (1688, 3, 'ELIAS CASTELLS FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-19', 329300.00, 'A'),
    (1689, 3, 'ANIDO DIAZ DANIEL', 191821112, 'CRA 25 CALLE 100', '491@gmail.com', '2011-02-03', 188640, '2011-04-04', 900780.00, 'A'),
    (1691, 3, 'GATELL ARIMONT MARIA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-09-17', 877700.00, 'A'),
    (1692, 3, 'RIVERA MUNOZ ADONI', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 211705, '2011-04-05', 840470.00, 'A'),
    (1693, 3, 'LUNA LOPEZ ALICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-10-01', 569270.00, 'A'),
    (1695, 3, 'HAMMOND ANN ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118021, '2011-05-17', 916770.00, 'A'),
    (1698, 3, 'RODRIGUEZ PARAJA MARIA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-07-15', 649080.00, 'A'),
    (1699, 3, 'RUIZ DIAZ JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-06-24', 359540.00, 'A'),
    (17, 1, 'SUAREZ CUEVAS FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 129499, '2011-08-31', 149640.00, 'A'),
    (170, 1, 'MARROQUIN AVILA FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-04', 965840.00, 'A'),
    (1700, 3, 'BACCHELLI ORTEGA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 126180, '2011-06-07', 850450.00, 'A'),
    (1701, 3, 'IGLESIAS JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2010-09-14', 173630.00, 'A'),
    (1702, 3, 'GUTIEZ CUEVAS JULIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2010-09-07', 316800.00, 'A'),
    ('CELL4183', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1704, 3, 'CALDEIRO ZAMORA JESUS CARMELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-09', 365230.00, 'A'),
    (1705, 3, 'ARBONA ABASCAL MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-02-27', 636760.00, 'A'),
    (1706, 3, 'COHEN AMAR MOISES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196766, '2011-05-20', 88120.00, 'A'),
    (1708, 3, 'FERNANDEZ COBOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2010-11-09', 387220.00, 'A'),
    (1709, 3, 'CANAL VIVES JOAQUIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 196234, '2011-09-27', 345150.00, 'A'),
    (171, 1, 'LADINO MORENO JAVIER ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-25', 89230.00, 'A'),
    (1710, 5, 'GARCIA BERTRAND HECTOR', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-04-07', 564100.00, 'A'),
    (1711, 1, 'CONSTANZA MARIN ESCOBAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127799, '2011-03-24', 785060.00, 'A'),
    (1712, 1, 'NUNEZ BATALLA FAUSTINO JORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-26', 232970.00, 'A'),
    (1713, 3, 'VILORA LAZARO ERICK MARTIN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-26', 809690.00, 'A'),
    (1715, 3, 'ELLIOT EDWARD JAMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-26', 318660.00, 'A'),
    (1716, 3, 'ALCALDE ORTENO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2011-07-23', 544650.00, 'A'),
    (1717, 3, 'CIARAVELLA STEFANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 231989, '2011-06-13', 767260.00, 'A'),
    (1718, 3, 'URRA GONZALEZ PEDRO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-05-02', 202370.00, 'A'),
    (172, 1, 'GUERRERO ERNESTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-15', 548610.00, 'A'),
    (1720, 3, 'JIMENEZ RODRIGUEZ ANNET', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-05-25', 943140.00, 'A'),
    (1721, 3, 'LESCAY CASTELLANOS ARNALDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-14', 585570.00, 'A'),
    (1722, 3, 'OCHOA AGUILAR ELIADES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-25', 98410.00, 'A'),
    (1723, 3, 'RODRIGUEZ NUNES JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-25', 735340.00, 'A'),
    (1724, 3, 'OCHOA BUSTAMANTE ELIADES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-25', 381480.00, 'A'),
    (1725, 3, 'MARTINEZ NIEVES JOSE ANGEL', 191821112, 'CRA 25 CALLE 100', '919@yahoo.es', '2011-02-03', 127591, '2011-05-25', 701360.00, 'A'),
    (1727, 3, 'DRAGONI ALAIN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-25', 707850.00, 'A'),
    (1728, 3, 'FERNANDEZ LOPEZ MARCOS ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-25', 452090.00, 'A'),
    (1729, 3, 'MATURELL ROMERO JORGE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-25', 136880.00, 'A'),
    (173, 1, 'RUIZ CEBALLOS ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-04', 475380.00, 'A'),
    (1730, 3, 'LARA CASTELLANO LENNIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-25', 328150.00, 'A'),
    (1731, 3, 'GRAHAM CRISTOPHER DRAKE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 203079, '2011-06-27', 230120.00, 'A'),
    (1732, 3, 'TORRE LUCA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-05-11', 166120.00, 'A'),
    (1733, 3, 'OCHOA HIDALGO EGLIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-25', 140250.00, 'A'),
    (1734, 3, 'LOURERIO DELACROIX FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116511, '2011-09-28', 202900.00, 'A'),
    (1736, 3, 'LEVIN FIORELLI ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116366, '2011-08-07', 360110.00, 'A'),
    (1739, 3, 'BERRY R ALBERT', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 216125, '2011-08-16', 22170.00, 'A'),
    (174, 1, 'NIETO PARRA SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-05-11', 731040.00, 'A'),
    (1740, 3, 'MARSHALL ROBERT SHEPARD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 150159, '2011-03-09', 62860.00, 'A'),
    (1741, 3, 'HENANDEZ ROY CHRISTOPHER JOHN PATRICK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 179614, '2011-09-26', 247780.00, 'A'),
    (1742, 3, 'LANDRY GUILLAUME', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 232263, '2011-04-27', 50330.00, 'A'),
    (1743, 3, 'VUCETIC ZELJKO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 232263, '2011-07-25', 508320.00, 'A'),
    (1744, 3, 'DE JUANA CELASCO MARIA DEL CARMEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188640, '2011-04-16', 390620.00, 'A'),
    (1745, 3, 'LABONTE RONALD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 269033, '2011-09-28', 428120.00, 'A'),
    (1746, 3, 'NEWMAN PHILIP MARK', 191821112, 'CRA 25 CALLE 100', '557@gmail.com', '2011-02-03', 231373, '2011-07-25', 968750.00, 'A'),
    (1747, 3, 'GRENIER MARIE PIERRE ', 191821112, 'CRA 25 CALLE 100', '409@facebook.com', '2011-02-03', 244158, '2011-07-03', 559370.00, 'A'),
    (1749, 3, 'SHINDER GARY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 244158, '2011-07-25', 775000.00, 'A'),
    (175, 3, 'GALLEGOS BASTIDAS CARLOS EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133211, '2011-08-10', 229090.00, 'A'),
    (1750, 3, 'LOPEZ DE GOICOCHEA ZABALA FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-09-13', 203120.00, 'A'),
    (1751, 3, 'CORRAL BELLON MANUEL', 191821112, 'CRA 25 CALLE 100', '538@yahoo.com', '2011-02-03', 177443, '2011-05-02', 690610.00, 'A'),
    (1752, 3, 'DE SOLA SOLVAS JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-10-02', 843700.00, 'A'),
    (1753, 3, 'GARCIA ALCALA DIAZ REGANON EVA MARIA', 191821112, 'CRA 25 CALLE 100', '398@yahoo.com', '2011-02-03', 118777, '2010-03-15', 146680.00, 'A'),
    (1754, 3, 'BIELA VILIAM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2011-08-16', 202290.00, 'A'),
    (1755, 3, 'GUIOT CANO JUAN PATRICK', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 232263, '2011-05-23', 571390.00, 'A'),
    (1756, 3, 'JIMENEZ DIAZ LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-03-27', 250100.00, 'A'),
    (1757, 3, 'FOX ELEANORE MAE', 191821112, 'CRA 25 CALLE 100', '117@yahoo.com', '2011-02-03', 190393, '2011-05-04', 536340.00, 'A'),
    (1758, 3, 'TANG VAN SON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-05-07', 931400.00, 'A'),
    (1759, 3, 'SUTTON PETER RONALD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 281673, '2011-06-01', 47960.00, 'A'),
    (176, 1, 'GOMEZ IVAN', 191821112, 'CRA 25 CALLE 100', '438@yahoo.com.mx', '2011-02-03', 127591, '2008-04-09', 952310.00, 'A'),
    (1762, 3, 'STOODY MATTHEW FRANCIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-21', 84320.00, 'A'),
    (1763, 3, 'SEIX MASO ARNAU', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150699, '2011-05-24', 168880.00, 'A'),
    (1764, 3, 'FERNANDEZ REDEL RAQUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-09-14', 591440.00, 'A'),
    (1765, 3, 'PORCAR DESCALS VICENNTE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 176745, '2011-04-24', 450580.00, 'A'),
    (1766, 3, 'PEREZ DE VILLEGAS TRILLO FIGUEROA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-05-17', 478560.00, 'A'),
    ('CELL4198', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1767, 3, 'CELDRAN DEGANO ANGEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 196234, '2011-05-17', 41040.00, 'A'),
    (1768, 3, 'TERRAGO MARI FERRAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-09-30', 769550.00, 'A'),
    (1769, 3, 'SZUCHOVSZKY GERGELY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 250256, '2011-05-23', 724630.00, 'A'),
    (177, 1, 'SEBASTIAN TORO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127443, '2011-07-14', 74270.00, 'A'),
    (1771, 3, 'TORIBIO JOSE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 226612, '2011-09-04', 398570.00, 'A'),
    (1772, 3, 'JOSE LUIS BAQUERA PEIRONCELLY', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2010-10-19', 49360.00, 'A'),
    (1773, 3, 'MADARIAGA VILLANUEVA MIGUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 188640, '2011-04-12', 51090.00, 'A'),
    (1774, 3, 'VILLENA BORREGO ANTONIO', 191821112, 'CRA 25 CALLE 100', '830@terra.com.co', '2011-02-03', 188640, '2011-07-19', 107400.00, 'A'),
    (1776, 3, 'VILAR VILLALBA JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 180124, '2011-09-20', 596330.00, 'A'),
    (1777, 3, 'CAGIGAL ORTIZ MACARENA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 214283, '2011-09-14', 830530.00, 'A'),
    (1778, 3, 'KORBA ATTILA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 250256, '2011-09-27', 363650.00, 'A'),
    (1779, 3, 'KORBA-ELIAS BARBARA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 250256, '2011-09-27', 326670.00, 'A'),
    (178, 1, 'AMSILI COHEN HANAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-08-29', 514450.00, 'A'),
    (1780, 3, 'PINDADO GOMEZ JESUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 189053, '2011-04-26', 542400.00, 'A'),
    (1781, 3, 'IBARRONDO GOMEZ GRACIA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 188640, '2011-09-21', 731990.00, 'A'),
    (1782, 3, 'MUNGUIRA GONZALEZ JUAN JULIAN', 191821112, 'CRA 25 CALLE 100', '54@hotmail.es', '2011-02-03', 188640, '2011-09-06', 32730.00, 'A'),
    (1784, 3, 'LANDMAN PIETER MARINUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 294861, '2011-09-22', 740260.00, 'A'),
    (1789, 3, 'SUAREZ AINARA ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-05-17', 503470.00, 'A'),
    (179, 1, 'CARO JUNCO GUIOVANNY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-03', 349420.00, 'A'),
    (1790, 3, 'MARTINEZ CHACON JOSE JOAQUIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-05-20', 592220.00, 'A'),
    (1792, 3, 'MENDEZ DEL RION LUCIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 120639, '2011-06-16', 476910.00, 'A'),
    (1793, 3, 'VERHULST LAMBERTUS  CORNELIA FRANCISCUS ALPHONSUS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 295420, '2011-07-04', 32410.00, 'A'),
    (1794, 3, 'YANEZ YAGUE JESUS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 188640, '2011-07-10', 731290.00, 'A'),
    (1796, 3, 'GOMEZ ZORRILLA AMATE JOSE MARIOA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2011-07-12', 602380.00, 'A'),
    (1797, 3, 'LAIZ MORENO ENEKO', 191821112, 'CRA 25 CALLE 100', '219@gmail.com', '2011-02-03', 127591, '2011-08-05', 334150.00, 'A'),
    (1798, 3, 'MORODO RUIZ RUBEN DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-09-14', 863620.00, 'A'),
    (18, 1, 'GARZON VARGAS GUILLERMO FEDERICO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-29', 879110.00, 'A'),
    (1800, 3, 'ALFARO FAUS MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-09-14', 987410.00, 'A'),
    (1801, 3, 'MORRALLA VALLVERDU ENRIC', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 194601, '2011-07-18', 990070.00, 'A'),
    (1802, 3, 'BALBASTRE TEJEDOR JUAN VICENTE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 182860, '2011-08-24', 988120.00, 'A'),
    (1803, 3, 'MINGO REIZ FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2010-03-24', 970400.00, 'A'),
    (1804, 3, 'IRURETA FERNANDEZ JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 214283, '2011-09-10', 887630.00, 'A'),
    (1807, 3, 'NEBRO MELLADO JOSE JUAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 168996, '2011-08-15', 278540.00, 'A'),
    (1808, 3, 'ALBERQUILLA OJEDA JOSE DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 188640, '2011-09-27', 477070.00, 'A'),
    (1809, 3, 'BUENDIA NORTE MARIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 131401, '2011-07-08', 549720.00, 'A'),
    (181, 1, 'CASTELLANOS FLORES RODRIGO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-18', 970470.00, 'A'),
    (1811, 3, 'HILBERT ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 196234, '2011-09-08', 937830.00, 'A'),
    (1812, 3, 'GONZALES PINTO COTERILLO ADOLFO LORENZO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 214283, '2011-09-10', 736970.00, 'A'),
    (1813, 3, 'ARQUES ALVAREZ JOSE RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-04-04', 871360.00, 'A'),
    (1817, 3, 'CLAUSELL LOW ROBERTO EMILIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2011-09-28', 348770.00, 'A'),
    (1818, 3, 'BELICHON MARTINEZ JESUS ALVARO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-04-12', 327010.00, 'A'),
    (182, 1, 'GUZMAN NIETO JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-20', 241130.00, 'A'),
    (1821, 3, 'LINATI DE PUIG JORGE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 196234, '2011-05-18', 47210.00, 'A'),
    (1823, 3, 'SINBARRERA ROMA ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196234, '2011-09-08', 598380.00, 'A'),
    (1826, 2, 'JUANES GARATE BRUNO ', 191821112, 'CRA 25 CALLE 100', '301@gmail.com', '2011-02-03', 118777, '2011-08-21', 877650.00, 'A'),
    (1827, 3, 'BOLOS GIMENO ROGELIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 200247, '2010-11-28', 555470.00, 'A'),
    (1828, 3, 'ZABALA ASTIGARRAGA JOSE MARIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 188640, '2011-09-20', 144410.00, 'A'),
    (1831, 3, 'MAPELLI CAFFARENA BORJA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 172381, '2011-09-04', 58200.00, 'A'),
    (1833, 3, 'LARMONIE LESLIE MARTIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-30', 604840.00, 'A'),
    (1834, 3, 'WILLEMS ROBERT-JAN MICHAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 288531, '2011-09-05', 756530.00, 'A'),
    (1835, 3, 'ANJEMA LAURENS JAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-08-29', 968140.00, 'A'),
    (1836, 3, 'VERHULST HENRICUS LAMBERTUS MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 295420, '2011-04-03', 571100.00, 'A'),
    (1837, 3, 'PIERROT JOZEF MARIE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 288733, '2011-05-18', 951100.00, 'A'),
    (1838, 3, 'EIKELBOOM HIDDE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-02', 42210.00, 'A'),
    (1839, 3, 'TAMBINI GOMEZ DE MUNG', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 180063, '2011-04-24', 357740.00, 'A'),
    (1840, 3, 'MAGANA PEREZ GERARDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 135360, '2011-09-28', 662060.00, 'A'),
    (1841, 3, 'COURTOISIE BEYHAUT RAFAEL JUAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116366, '2011-09-05', 237070.00, 'A'),
    (1842, 3, 'ROJAS BENJAMIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-13', 199170.00, 'A'),
    (1843, 3, 'GARCIA VICENTE EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 150699, '2011-08-10', 284650.00, 'A'),
    ('CELL4291', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (1844, 3, 'CESTTI LOPEZ RAFAEL GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 144215, '2011-09-27', 825750.00, 'A'),
    (1845, 3, 'URTECHO LOPEZ ARMANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 139272, '2011-09-28', 274800.00, 'A'),
    (1846, 3, 'SEGURA ESPINOZA ARMANDO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 135360, '2011-09-28', 896730.00, 'A'),
    (1847, 3, 'GONZALEZ VEGA LUIS PASTOR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 135360, '2011-05-18', 659240.00, 'A'),
    (185, 1, 'AYALA CARDENAS NELSON MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-25', 855960.00, 'A'),
    (1850, 3, 'ROTZINGER ROA KLAUS ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 116366, '2011-09-12', 444250.00, 'A'),
    (1851, 3, 'FRANCO DE LEON SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116366, '2011-04-26', 63840.00, 'A'),
    (1852, 3, 'RIVAS GAGNONI LUIS ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 135360, '2011-05-18', 986440.00, 'A'),
    (1853, 3, 'BARRETO VELASQUEZ JOEL FERNANDO', 191821112, 'CRA 25 CALLE 100', '104@hotmail.es', '2011-02-03', 116511, '2011-04-27', 740670.00, 'A'),
    (1854, 3, 'SEVILLA AMAYA ORLANDO', 191821112, 'CRA 25 CALLE 100', '264@yahoo.com', '2011-02-03', 136995, '2011-05-18', 744020.00, 'A'),
    (1855, 3, 'VALFRE BRALICH ELEONORA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116366, '2011-06-06', 498080.00, 'A'),
    (1857, 3, 'URDANETA DIAMANTES DIEGO ANDRES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-09-23', 797590.00, 'A'),
    (1858, 3, 'RAMIREZ ALVARADO ROBERT JESUS', 191821112, 'CRA 25 CALLE 100', '290@yahoo.com.mx', '2011-02-03', 127591, '2011-09-18', 212850.00, 'A'),
    (1859, 3, 'GUTTNER DENNIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-25', 671470.00, 'A'),
    (186, 1, 'CARRASCO SUESCUN ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-15', 36620.00, 'A'),
    (1861, 3, 'HEGEMANN JOACHIM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-25', 579710.00, 'A'),
    (1862, 3, 'MALCHER INGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 292243, '2011-06-23', 742060.00, 'A'),
    (1864, 3, 'HOFFMEISTER MALTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128206, '2011-09-06', 629770.00, 'A'),
    (1865, 3, 'BOHME ALEXANDRA LUCE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-14', 235260.00, 'A'),
    (1866, 3, 'HAMMAN FRANK THOMAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-13', 286980.00, 'A'),
    (1867, 3, 'GOPPERT MARKUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-09-05', 729150.00, 'A'),
    (1868, 3, 'BISCARO CAROLINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-09-16', 784790.00, 'A'),
    (1869, 3, 'MASCHAT SEBASTIAN STEPHAN ANDREAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-02-03', 736520.00, 'A'),
    (1870, 3, 'WALTHER DANIEL CLAUS PETER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-24', 328220.00, 'A'),
    (1871, 3, 'NENTWIG DANIEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 289697, '2011-02-03', 431550.00, 'A'),
    (1872, 3, 'KARUTZ ALEX', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127662, '2011-03-17', 173090.00, 'A'),
    (1875, 3, 'KAY KUNNE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 289697, '2011-03-18', 961400.00, 'A'),
    (1876, 2, 'SCHLUMPF IVANA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 245206, '2011-03-28', 802690.00, 'A'),
    (1877, 3, 'RODRIGUEZ BUSTILLO CONSUELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 139067, '2011-03-21', 129280.00, 'A'),
    (1878, 1, 'REHWALDT RICHARD ULRICH', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289697, '2009-10-25', 238320.00, 'A'),
    (1880, 3, 'FONSECA BEHRENS MANUELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150699, '2011-08-18', 303810.00, 'A'),
    (1881, 3, 'VOGEL MIRKO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-09', 107790.00, 'A'),
    (1882, 3, 'WU WEI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 289697, '2011-03-04', 627520.00, 'A'),
    (1884, 3, 'KADOLSKY ANKE SIGRID', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 289697, '2010-10-07', 188560.00, 'A'),
    (1885, 3, 'PFLUCKER PLENGE CARLOS HERNAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 239124, '2011-08-15', 500140.00, 'A'),
    (1886, 3, 'PENA LAGOS MELENIA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 935020.00, 'A'),
    (1887, 3, 'CALVANO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-05-02', 174690.00, 'A'),
    (1888, 3, 'KUHLEN LOTHAR WILHELM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 289232, '2011-08-30', 68390.00, 'A'),
    (1889, 3, 'QUIJANO RICO SOFIA VICTORIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 221939, '2011-06-13', 817890.00, 'A'),
    (189, 1, 'GOMEZ TRUJILLO SERGIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-17', 985980.00, 'A'),
    (1890, 3, 'SCHILBERZ KARIN', 191821112, 'CRA 25 CALLE 100', '405@facebook.com', '2011-02-03', 287570, '2011-06-23', 884260.00, 'A'),
    (1891, 3, 'SCHILBERZ SOPHIE CAHRLOTTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 287570, '2011-06-23', 967640.00, 'A'),
    (1892, 3, 'MOLINA MOLINA MILAGRO DE SUYAPA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 139844, '2011-07-26', 185410.00, 'A'),
    (1893, 3, 'BARRIENTOS ESCALANTE RAFAEL ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 139067, '2011-05-18', 24110.00, 'A'),
    (1895, 3, 'ENGELS FRANZBERNARD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 292243, '2011-07-01', 749430.00, 'A'),
    (1896, 3, 'FRIEDHOFF SVEN WILHEM', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 289697, '2010-10-31', 54090.00, 'A'),
    (1897, 3, 'BARTELS CHRISTIAN JOHAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-07-25', 22160.00, 'A'),
    (1898, 3, 'NILS REMMEL', 191821112, 'CRA 25 CALLE 100', '214@gmail.com', '2011-02-03', 256231, '2011-08-05', 948530.00, 'A'),
    (1899, 3, 'DR SCHEIBE MATTHIAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 252431, '2011-09-26', 676150.00, 'A'),
    (19, 1, 'RIANO ROMERO ALBERTO ELIAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-12-14', 946630.00, 'A'),
    (190, 1, 'LLOREDA ORTIZ FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-12-20', 30860.00, 'A'),
    (1900, 3, 'CARRASCO CATERIANO PEDRO', 191821112, 'CRA 25 CALLE 100', '255@hotmail.com', '2011-02-03', 286578, '2011-05-02', 535180.00, 'A'),
    (1901, 3, 'ROSENBER DIRK PETER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-29', 647450.00, 'A'),
    (1902, 3, 'LAUBACH JOHANNES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289697, '2011-05-01', 631720.00, 'A'),
    (1904, 3, 'GRUND STEFAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 256231, '2011-08-05', 185990.00, 'A'),
    (1905, 3, 'GRUND BEATE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 256231, '2011-08-05', 281280.00, 'A'),
    (1906, 3, 'CORZO PAULA MIRIANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 180063, '2011-08-02', 848400.00, 'A'),
    (1907, 3, 'OESTERHAUS CORNELIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 256231, '2011-03-16', 398170.00, 'A'),
    (1908, 1, 'JUAN SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127300, '2011-05-12', 445660.00, 'A'),
    (1909, 3, 'VAN ZIJL CHRISTIAN ANDREAS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 286785, '2011-09-24', 33800.00, 'A'),
    (191, 1, 'CASTANEDA CABALLERO JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-28', 196370.00, 'A'),
    (1910, 3, 'LORZA RUIZ MYRIAM ESPERANZA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-29', 831990.00, 'A'),
    (192, 1, 'ZEA EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-09', 889270.00, 'A'),
    (193, 1, 'VELEZ VICTOR MANUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-10-22', 857250.00, 'A'),
    (194, 1, 'ARCINIEGAS GOMEZ ISMAEL', 191821112, 'CRA 25 CALLE 100', '937@hotmail.com', '2011-02-03', 127591, '2011-05-18', 618450.00, 'A'),
    (195, 1, 'LINAREZ PEDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-12', 520470.00, 'A'),
    (1952, 3, 'BERND ERNST HEINZ SCHUNEMANN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 255673, '2011-09-04', 796820.00, 'A'),
    (1953, 3, 'BUCHNER RICHARD ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-17', 808430.00, 'A'),
    (1954, 3, 'CHO YONG BEOM', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 173192, '2011-02-07', 651670.00, 'A'),
    (1955, 3, 'BERNECKER WALTER LUDWIG', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 256231, '2011-04-03', 833080.00, 'A'),
    (1956, 3, 'SCHIERENBECK THOMAS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 256231, '2011-05-03', 210380.00, 'A'),
    (1957, 3, 'STEGMANN WOLF DIETER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-08-27', 552650.00, 'A'),
    (1958, 3, 'LEBAGE GONZALEZ VALENTINA CECILIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 131272, '2011-07-29', 132130.00, 'A'),
    (1959, 3, 'CABRERA MACCHI JOSE ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 180063, '2011-08-02', 2700.00, 'A'),
    (196, 1, 'OTERO BERNAL ALVARO ERNESTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-04-29', 747030.00, 'A'),
    (1960, 3, 'KOO BONKI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-15', 617110.00, 'A'),
    (1961, 3, 'JODJAHN DE CARVALHO BEIRAL FLAVIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-07-05', 77460.00, 'A'),
    (1963, 3, 'VIEIRA ROCHA MARQUES ELIANE TEREZINHA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118402, '2011-09-13', 447430.00, 'A'),
    (1965, 3, 'KELLEN CRISTINA GATTI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126180, '2011-07-01', 804020.00, 'A'),
    (1966, 3, 'CHAVEZ MARLON TENORIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 120773, '2011-07-25', 132310.00, 'A'),
    (1967, 3, 'SERGIO COZZI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 125750, '2011-08-28', 249500.00, 'A'),
    (1968, 3, 'REZENDE LIMA JOSE MARCIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-08-23', 850570.00, 'A'),
    (1969, 3, 'RAMOS PEDRO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118942, '2011-08-03', 504330.00, 'A'),
    (1972, 3, 'ADAMS THOMAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2011-08-11', 774000.00, 'A'),
    (1973, 3, 'WALESKA NUCINI BOGO ANDREA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-23', 859690.00, 'A'),
    (1974, 3, 'GERMANO PAULO BUNN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118439, '2011-08-30', 976440.00, 'A'),
    (1975, 3, 'CALDEIRA FILHO RUBENS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118942, '2011-07-18', 303120.00, 'A'),
    (1976, 3, 'JOSE CUSTODIO DO ALTISSIMO NETONETO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 119814, '2011-09-08', 586290.00, 'A'),
    (1977, 3, 'GAMAS MARIA CRISTINA ALVES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-09-19', 22070.00, 'A'),
    (1979, 3, 'PORTO WEBER FERREIRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-07', 691340.00, 'A'),
    (1980, 3, 'FONSECA LAURO PINTO', 191821112, 'CRA 25 CALLE 100', '104@hotmail.es', '2011-02-03', 127591, '2011-08-16', 402140.00, 'A'),
    (1981, 3, 'DUARTE ELENA CECILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-06-15', 936710.00, 'A'),
    (1983, 3, 'CECHINEL CRISTIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118942, '2011-06-12', 575530.00, 'A'),
    (1984, 3, 'BATISTA PINHERO JOAO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-04-25', 446250.00, 'A'),
    (1987, 1, 'ISRAEL JOSE MAXWELL', 191821112, 'CRA 25 CALLE 100', '936@gmail.com', '2011-02-03', 125894, '2011-07-04', 408350.00, 'A'),
    (1988, 3, 'BATISTA CARVALHO RODRIGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118864, '2011-09-19', 488410.00, 'A'),
    (1989, 3, 'RENO DA SILVEIRA EDNEIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118867, '2011-05-03', 216990.00, 'A'),
    (199, 1, 'BASTO CORREA FERNANDO ANTONIO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-21', 616860.00, 'A'),
    (1990, 3, 'SEIDLER KOHNERT G TEIXEIRA CHRISTINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 119814, '2011-08-23', 619730.00, 'A'),
    (1992, 3, 'GUIMARAES COSTA LEONARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-04-20', 379090.00, 'A'),
    (1993, 3, 'BOTTA RODRIGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2011-09-16', 552510.00, 'A'),
    (1994, 3, 'ARAUJO DA SILVA MARCELO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 125666, '2011-08-03', 625260.00, 'A'),
    (1995, 3, 'DA SILVA FELIPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118864, '2011-04-14', 468760.00, 'A'),
    (1996, 3, 'MANFIO RODRIGUEZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '974@yahoo.com', '2011-02-03', 118777, '2011-03-23', 468040.00, 'A'),
    (1997, 3, 'NEIVA MORENO DE SOUZA CRISTIANE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-09-24', 933900.00, 'A'),
    (2, 3, 'CHEEVER MICHAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-04', 560090.00, 'I'),
    (2000, 3, 'ROCHA GUSTAVO ADRIANO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118288, '2011-07-25', 830340.00, 'A'),
    (2001, 3, 'DE ANDRADE CARVALHO VIRGINIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-08-11', 575760.00, 'A'),
    (2002, 3, 'CAVALCANTI PIERECK GUILHERME', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 180063, '2011-08-01', 387770.00, 'A'),
    (2004, 3, 'HOEGEMANN RAMOS CARLOS FERNANDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-04', 894550.00, 'A'),
    (201, 1, 'LUIS FERNANDO AREVALO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-17', 156730.00, 'A'),
    (2010, 3, 'GOMES BUCHALA JORGE FERNANDO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-09-23', 314800.00, 'A'),
    (2011, 3, 'MARTINS SIMAIKA CATIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-06-01', 155020.00, 'A'),
    (2012, 3, 'MONICA CASECA BUENO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-05-16', 830710.00, 'A'),
    (2013, 3, 'ALBERTAL MARCELO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118000, '2010-09-10', 688480.00, 'A'),
    (2015, 3, 'GOMES CANTARELLI JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118761, '2011-01-11', 685940.00, 'A'),
    (2016, 3, 'CADETTI GARBELLINI ENILICE CRISTINA ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-11', 578870.00, 'A'),
    (2017, 3, 'SPIELKAMP KLAUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 150699, '2011-03-28', 836540.00, 'A'),
    (2019, 3, 'GARES HENRI PHILIPPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 135190, '2011-04-05', 720730.00, 'A'),
    ('CELL4308', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (202, 1, 'LUCIO CHAUSTRE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-19', 179240.00, 'A'),
    (2023, 3, 'GRECO DE RESENDELUIZ ALFREDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 119814, '2011-04-25', 647940.00, 'A'),
    (2024, 3, 'CORTINA EVANDRO JOAO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118922, '2011-05-12', 153970.00, 'A'),
    (2026, 3, 'BASQUES MOURA GERALDO CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 119814, '2011-09-07', 668250.00, 'A'),
    (2027, 3, 'DA SILVA VALDECIR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-23', 863150.00, 'A'),
    (2028, 3, 'CHI MOW YUNG IVAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-21', 311000.00, 'A'),
    (2029, 3, 'YUNG MYRA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-21', 965570.00, 'A'),
    (2030, 3, 'MARTINS RAMALHO PATRICIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-03-23', 894830.00, 'A'),
    (2031, 3, 'DE LEMOS RIBEIRO GILBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118951, '2011-07-29', 577430.00, 'A'),
    (2032, 3, 'AIROLDI CLAUDIO', 191821112, 'CRA 25 CALLE 100', '973@terra.com.co', '2011-02-03', 127591, '2011-09-28', 202650.00, 'A'),
    (2033, 3, 'ARRUDA MENDES HEILMANN IONE TEREZA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 120773, '2011-09-07', 280990.00, 'A'),
    (2034, 3, 'TAVARES DE CARVALHO EDUARDO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118942, '2011-08-03', 796980.00, 'A'),
    (2036, 3, 'FERNANDES ALARCON RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-08-28', 318730.00, 'A'),
    (2037, 3, 'SUCHODOLKI SERGIO GUSMAO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 190393, '2011-07-13', 167870.00, 'A'),
    (2039, 3, 'ESTEVES MARCAL MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-02-24', 912100.00, 'A'),
    (2040, 3, 'CORSI LUIZ ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-03-25', 911080.00, 'A'),
    (2041, 3, 'LOPEZ MONICA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118795, '2011-05-03', 819090.00, 'A'),
    (2042, 3, 'QUINTANILHA LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-16', 362230.00, 'A'),
    (2043, 3, 'DE CARLI BRUNO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-05-03', 353890.00, 'A'),
    (2045, 3, 'MARINO FRANCA MARILIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-07-04', 352060.00, 'A'),
    (2048, 3, 'VOIGT ALPHONSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118439, '2010-11-22', 384150.00, 'A'),
    (2049, 3, 'ALENCAR ARIMA TATIANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-05-23', 408590.00, 'A'),
    (2050, 3, 'LINIS DE ALMEIDA NEILSON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 125666, '2011-08-03', 890480.00, 'A'),
    (2051, 3, 'PINHEIRO DE CASTRO BENETI', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-08-09', 226640.00, 'A'),
    (2052, 3, 'ALVES DO LAGO HELMANN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118942, '2011-08-01', 461770.00, 'A'),
    (2053, 3, 'OLIVO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-22', 628900.00, 'A'),
    (2054, 3, 'WILLIAM DOMINGUES SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118085, '2011-08-23', 759220.00, 'A'),
    (2055, 3, 'DE SOUZA MENEZES KLEBER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-04-25', 909400.00, 'A'),
    (2056, 3, 'CABRAL NEIDE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-16', 269340.00, 'A'),
    (2057, 3, 'RODRIGUES RENATO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-06-15', 618500.00, 'A'),
    (2058, 3, 'SPADALE PEDRO JORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-08-03', 284490.00, 'A'),
    (2059, 3, 'MARTINS DE ALMEIDA GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-09-28', 566920.00, 'A'),
    (206, 1, 'TORRES HEBER MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-01-29', 643210.00, 'A'),
    (2060, 3, 'IKUNO CELINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-06-08', 981170.00, 'A'),
    (2061, 3, 'DAL BELLO FABIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 129499, '2011-08-20', 205050.00, 'A'),
    (2062, 3, 'BENATES ADRIANA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-23', 81770.00, 'A'),
    (2063, 3, 'CARDOSO ALEXANDRE ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-23', 793690.00, 'A'),
    (2064, 3, 'ZANIOLO DE SOUZA CARLOS HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-09-19', 723130.00, 'A'),
    (2065, 3, 'DA SILVA LUIZ SIDNEI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-03-30', 234590.00, 'A'),
    (2066, 3, 'RUFATO DE SOUZA LUIZ FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-08-29', 3560.00, 'A'),
    (2067, 3, 'DE MEDEIROS LUCIANA', 191821112, 'CRA 25 CALLE 100', '994@yahoo.com.mx', '2011-02-03', 118777, '2011-09-10', 314020.00, 'A'),
    (2068, 3, 'WOLFF PIAZERA DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118255, '2011-06-15', 559430.00, 'A'),
    (2069, 3, 'DA SILVA FORTUNA MARINA CLAUDIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-09-23', 855100.00, 'A'),
    (2070, 3, 'PEREIRA BORGES LUCILA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 120773, '2011-07-26', 597210.00, 'A'),
    (2072, 3, 'PORROZZI DE ALMEIDA RENATO', 191821112, 'CRA 25 CALLE 100', '812@hotmail.es', '2011-02-03', 127591, '2011-06-13', 312120.00, 'A'),
    (2073, 3, 'KALICHSZTEINN RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-03-23', 298330.00, 'A'),
    (2074, 3, 'OCCHIALINI GUIMARAES ANA PAULA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2011-08-03', 555310.00, 'A'),
    (2075, 3, 'MAZZUCO FONTES LUIZ ROBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-05-23', 881570.00, 'A'),
    (2078, 3, 'TRAN DINH VAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 98560.00, 'A'),
    (2079, 3, 'NGUYEN THI LE YEN', 191821112, 'CRA 25 CALLE 100', '249@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 298200.00, 'A'),
    (208, 1, 'GOMEZ GONZALEZ JORGE MARIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-12', 889010.00, 'A'),
    (2080, 3, 'MILA DE LA ROCA JOHANA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-01-26', 195350.00, 'A'),
    (2081, 3, 'RODRIGUEZ DE FLORES LOURDES MARIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-16', 82120.00, 'A'),
    (2082, 3, 'FLORES PEREZ FRANCISCO GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-23', 824550.00, 'A'),
    (2083, 3, 'FRAGACHAN BETANCOUT FRANCISCO JO SE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-07-04', 876400.00, 'A'),
    (2084, 3, 'GAFARO MOLINA CARLOS JULIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-03-22', 908370.00, 'A'),
    (2085, 3, 'CACERES REYES JORGEANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-08-11', 912630.00, 'A'),
    (2086, 3, 'ALVAREZ RODRIGUEZ VICTOR ROGELIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132958, '2011-05-23', 838040.00, 'A'),
    (2087, 3, 'GARCES ALVARADO JHAGEIMA JOSEFINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2011-04-29', 452320.00, 'A'),
    ('CELL4324', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (2089, 3, 'FAVREAU CHOLLET JEAN PIERRE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132554, '2011-05-27', 380470.00, 'A'),
    (209, 1, 'CRUZ RODRIGEZ CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '316@hotmail.es', '2011-02-03', 127591, '2011-06-28', 953870.00, 'A'),
    (2090, 3, 'GARAY LLUCH URBI ALAIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-03-13', 659870.00, 'A'),
    (2091, 3, 'LETICIA LETICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-07', 157950.00, 'A'),
    (2092, 3, 'VELASQUEZ RODULFO RAMON ARISTIDES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-09-23', 810140.00, 'A'),
    (2093, 3, 'PEREZ EDGAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-06', 576850.00, 'A'),
    (2094, 3, 'PEREZ MARIELA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-07', 453840.00, 'A'),
    (2095, 3, 'PETRUZZI MANGIARANO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132958, '2011-03-27', 538650.00, 'A'),
    (2096, 3, 'LINARES GORI RICARDO RAMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-12', 331730.00, 'A'),
    (2097, 3, 'LAIRET OLIVEROS CAROLINE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-09-25', 42680.00, 'A'),
    (2099, 3, 'JIMENEZ GARCIA FERNANDO JOSE', 191821112, 'CRA 25 CALLE 100', '78@hotmail.es', '2011-02-03', 132958, '2011-07-21', 963110.00, 'A'),
    (21, 1, 'RUBIO ESCOBAR RUBEN DARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-05-21', 639240.00, 'A'),
    (2100, 3, 'ZABALA MILAGROS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-20', 160860.00, 'A'),
    (2101, 3, 'VASQUEZ CRUZ NICOLEDANIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2011-07-31', 914990.00, 'A'),
    (2102, 3, 'REYES FIGUERA RAMON ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 126674, '2011-04-03', 92340.00, 'A'),
    (2104, 3, 'RAMIREZ JIMENEZ MARYLIN CAROLINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2011-06-14', 306760.00, 'A'),
    (2105, 3, 'TELLES GUILLEN INNA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-09-07', 383520.00, 'A'),
    (2106, 3, 'ALVAREZ CARMEN MARINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-07-20', 997340.00, 'A'),
    (2107, 3, 'MARTINEZ YRIGOYEN NABUCODONOSOR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-07-21', 836110.00, 'A'),
    (2108, 5, 'FERNANDEZ RUIZ IGNACIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-01', 188530.00, 'A'),
    (211, 1, 'RIVEROS GARCIA JORGE IVAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-01', 650050.00, 'A'),
    (2110, 3, 'CACERES REYES JORGE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-08-08', 606030.00, 'A'),
    (2111, 3, 'GELFI MARCOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 199862, '2011-05-17', 727190.00, 'A'),
    (2112, 3, 'CERDA CASTILLO CARMEN GLORIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-08-21', 817870.00, 'A'),
    (2113, 3, 'RANGEL FERNANDEZ LEONARDO JOSE', 191821112, 'CRA 25 CALLE 100', '856@hotmail.com', '2011-02-03', 133211, '2011-05-16', 907750.00, 'A'),
    (2114, 3, 'ROTHSCHILD VARGAS MICHAEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132165, '2011-02-05', 85170.00, 'A'),
    (2115, 3, 'RUIZ GRATEROL INGRID JOHANNA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132958, '2011-05-16', 702600.00, 'A'),
    (2116, 2, 'DEARMAS ALBERTO FERNANDO ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-07-19', 257500.00, 'A'),
    (2117, 3, 'BOSCAN ARRIETA ERICK HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-07-12', 179680.00, 'A'),
    (2118, 3, 'GUILLEN DE TELLES NENCY JOSEFINA', 191821112, 'CRA 25 CALLE 100', '56@facebook.com', '2011-02-03', 132958, '2011-09-07', 125900.00, 'A'),
    (212, 1, 'BUSTAMANTE BUSTAMANTE CARLOS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-26', 943260.00, 'A'),
    (2120, 2, 'MARK ANTHONY STUART', 191821112, 'CRA 25 CALLE 100', '661@terra.com.co', '2011-02-03', 127591, '2011-06-26', 74600.00, 'A'),
    (2122, 3, 'SCOCOZZA GIOVANNA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 190526, '2011-09-23', 284220.00, 'A'),
    (2125, 3, 'CHAVES MOLINA JULIO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132165, '2011-09-22', 295360.00, 'A'),
    (2127, 3, 'BERNARDES DE SOUZA TONIATI VIRGINIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-30', 565090.00, 'A'),
    (2129, 2, 'BRIAN DAVIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-19', 78460.00, 'A'),
    (213, 1, 'PAREJO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-11', 766120.00, 'A'),
    (2131, 3, 'DE OLIVEIRA LOPES REGINALDO LAZARO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-05', 404910.00, 'A'),
    (2132, 3, 'DE MELO MING AZEVEDO PAULO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-10-05', 440370.00, 'A'),
    (2137, 3, 'SILVA JORGE ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-05', 230570.00, 'A'),
    (214, 1, 'CADENA RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-08', 840.00, 'A'),
    (2142, 3, 'VIEIRA VEIGA PEDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-30', 85330.00, 'A'),
    (2144, 3, 'ESCRIBANO LEONARDA DEL VALLE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-03-24', 941440.00, 'A'),
    (2145, 3, 'RODRIGUEZ MENENDEZ BERNARDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 148511, '2011-08-02', 588740.00, 'A'),
    (2146, 3, 'GONZALEZ COURET DANIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 148511, '2011-08-09', 119380.00, 'A'),
    (2147, 3, 'GARCIA SOTO WILLIAM', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 135360, '2011-05-18', 830660.00, 'A'),
    (2148, 3, 'MENESES ORELLANA RICARDO TOMAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132165, '2011-06-13', 795200.00, 'A'),
    (2149, 3, 'GUEVARA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-27', 483990.00, 'A'),
    (215, 1, 'BELTRAN PINZON JUAN CARLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-08', 705860.00, 'A'),
    (2151, 2, 'LLANES GARRIDO JAVIER ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-30', 719750.00, 'A'),
    (2152, 3, 'CHAVARRIA CHAVES RAFAEL ADRIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132165, '2011-09-20', 495720.00, 'A'),
    (2153, 2, 'MILBERT ANDREASPETER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-10', 319370.00, 'A'),
    (2154, 2, 'GOMEZ SILVA LOZANO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127300, '2011-05-30', 109670.00, 'A'),
    (2156, 3, 'WINTON ROBERT DOUGLAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 115551, '2011-08-08', 622290.00, 'A'),
    (2157, 2, 'ROMERO PINA MANUEL GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-05-05', 340650.00, 'A'),
    (2158, 3, 'KARWALSKI MATTHEW REECE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117229, '2011-08-29', 836380.00, 'A'),
    (2159, 2, 'KIM JUNG SIK ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-08', 159950.00, 'A'),
    (216, 1, 'MARTINEZ VALBUENA JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-25', 526750.00, 'A'),
    (2160, 3, 'AGAR ROBERT ALEXANDER', 191821112, 'CRA 25 CALLE 100', '81@hotmail.es', '2011-02-03', 116862, '2011-06-11', 290620.00, 'A'),
    (2161, 3, 'IGLESIAS EDGAR ALEXIS', 191821112, 'CRA 25 CALLE 100', '645@facebook.com', '2011-02-03', 131272, '2011-04-04', 973240.00, 'A'),
    (2163, 2, 'NOAIN MORENO CECILIA KARIM ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-22', 51950.00, 'A'),
    (2164, 2, 'FIGUEROA HEBEL ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-26', 276760.00, 'A'),
    (2166, 5, 'FRANDBERG DAN RICHARD VERNER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 134022, '2011-04-06', 309480.00, 'A'),
    (2168, 2, 'CONTRERAS LILLO EDUARDO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-27', 389320.00, 'A'),
    (2169, 2, 'BLANCO VALLE RICARDO ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-07-13', 355950.00, 'A'),
    (2171, 2, 'BELTRAN ZAVALA JIMI ALFONSO MIGUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126674, '2011-08-22', 991000.00, 'A'),
    (2172, 2, 'RAMIRO OREGUI JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-04-27', 119700.00, 'A'),
    (2175, 2, 'FENG PUYO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 302172, '2011-10-07', 965660.00, 'A'),
    (2176, 3, 'CLERICI GUIDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 116366, '2011-08-30', 522970.00, 'A'),
    (2177, 1, 'SEIJAS GUNTER LUIS MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-02', 717890.00, 'A'),
    (2178, 2, 'SHOSHANI MOSHE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-13', 20520.00, 'A'),
    (218, 3, 'HUCHICHALEO ARSENDIGA FRANCISCA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-05', 690.00, 'A'),
    (2181, 2, 'DOMINGO BARTOLOME LUIS FERNANDO', 191821112, 'CRA 25 CALLE 100', '173@terra.com.co', '2011-02-03', 127591, '2011-04-18', 569030.00, 'A'),
    (2182, 3, 'GONZALEZ RIJO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-10-02', 795610.00, 'A'),
    (2183, 2, 'ANDROVICH MORENO LIZETH LILIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127300, '2011-10-10', 270970.00, 'A'),
    (2184, 2, 'ARREAZA LUGO JESUS ALFREDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-08', 968030.00, 'A'),
    (2185, 2, 'NAVEDA CANELON KATHERINE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132775, '2011-09-14', 27250.00, 'A'),
    (2189, 2, 'LUGO BEHRENS DENISE SOFIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-08', 253980.00, 'A'),
    (2190, 2, 'ERICA ROSE MOLDENHAUVER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-25', 175480.00, 'A'),
    (2192, 2, 'SOLORZANO GARCIA ANDREINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-25', 50790.00, 'A'),
    (2193, 3, 'DE LA COSTE MARIA CAROLINA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-26', 907640.00, 'A'),
    (2194, 2, 'MARTINEZ DIAZ JUAN JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-08', 385810.00, 'A'),
    (2195, 2, 'GALARRAGA ECHEVERRIA DAYEN ALI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-13', 206150.00, 'A'),
    (2196, 2, 'GUTIERREZ RAMIREZ HECTOR JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133211, '2011-06-07', 873330.00, 'A'),
    (2197, 2, 'LOPEZ GONZALEZ SILVIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127662, '2011-09-01', 748170.00, 'A'),
    (2198, 2, 'SEGARES LUTZ JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-07', 120880.00, 'A'),
    (2199, 2, 'NADER MARTIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127538, '2011-08-12', 359880.00, 'A'),
    (22, 1, 'CARDOZO AMAYA JORGE HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-25', 908720.00, 'A'),
    (2200, 3, 'NATERA BERMUDEZ OSWALDO JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2010-10-18', 436740.00, 'A'),
    (2201, 2, 'COSTA RICARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 150699, '2011-09-01', 104090.00, 'A'),
    (2202, 5, 'GRUNDY VALENZUELA ALAN PATRICK', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-08', 210230.00, 'A'),
    (2203, 2, 'MONTENEGRO DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-26', 738890.00, 'A'),
    (2204, 2, 'TAMAI BUNGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-24', 63730.00, 'A'),
    (2205, 5, 'VINHAS FORTUNA EDSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-09-23', 102010.00, 'A'),
    (2206, 2, 'RUIZ ERBS MARIO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-07-19', 318860.00, 'A'),
    (2207, 2, 'VENTURA TINEO MARCEL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-08', 288240.00, 'A'),
    (2210, 2, 'RAMIREZ GUZMAN RICARDO JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-28', 338740.00, 'A'),
    (2211, 2, 'STERNBERG GABRIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2011-09-04', 18070.00, 'A'),
    (2212, 2, 'MARTELLO ALEJOS ROGER ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127443, '2011-06-20', 74120.00, 'A'),
    (2213, 2, 'CASTANEDA RAFAEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-25', 316410.00, 'A'),
    (2214, 2, 'LIMON MARTINEZ WILBERT DE JESUS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128904, '2011-09-19', 359690.00, 'A'),
    (2215, 2, 'PEREZ HERNANDEZ MONICA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133211, '2011-05-23', 849240.00, 'A'),
    (2216, 2, 'AWAD LOBATO RICARDO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '853@hotmail.com', '2011-02-03', 127591, '2011-04-12', 167100.00, 'A'),
    (2217, 2, 'CEPEDA VANEGAS ENDER ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-08-22', 287770.00, 'A'),
    (2218, 2, 'PEREZ CHIQUIN HECTOR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 132572, '2011-04-13', 937580.00, 'A'),
    (2220, 5, 'FRANCO DELGADILLO RONALD FERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132775, '2011-09-16', 310190.00, 'A'),
    (2222, 2, 'ALCAIDE ALONSO JUAN MIGUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-02', 455360.00, 'A'),
    (2223, 3, 'BROWNING BENJAMIN MARK', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-09', 45230.00, 'A'),
    (2225, 3, 'HARWOO BENJAMIN JOEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-09', 164620.00, 'A'),
    (2226, 3, 'HOEY TIMOTHY ROSS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-09', 242910.00, 'A'),
    (2227, 3, 'FERGUSON GARRY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-28', 720700.00, 'A'),
    (2228, 3, 'NORMAN NEVILLE ROBERT', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 288493, '2011-06-29', 874750.00, 'A'),
    (2229, 3, 'KUK HYUN CHAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-03-22', 211660.00, 'A'),
    (223, 1, 'PINZON PLAZA MARCOS VINICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-22', 856300.00, 'A'),
    (2230, 3, 'SLIPAK NATALIA ANDREA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-07-27', 434070.00, 'A'),
    (2231, 3, 'BONELLI MASSIMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 170601, '2011-07-11', 535340.00, 'A'),
    (2233, 3, 'VUYLSTEKE ALEXANDER ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 284647, '2011-09-11', 266530.00, 'A'),
    (2234, 3, 'DRESSE ALAIN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 284272, '2011-04-19', 209100.00, 'A'),
    (2235, 3, 'PAIRON JEAN LOUIS MARIE RAIMOND', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 284272, '2011-03-03', 245940.00, 'A'),
    (2236, 3, 'DEVIANE ACHIM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 284272, '2010-11-14', 602370.00, 'A'),
    (2239, 3, 'DE CANNIERE LOUIS GEORFES HELE MARIE-JOZEF', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 285511, '2011-09-11', 993540.00, 'A'),
    (2240, 1, 'ERGO ROBERT', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-28', 278270.00, 'A'),
    (2241, 3, 'MYRTES RODRIGUEZ MORGANA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-09-18', 410740.00, 'A'),
    (2242, 3, 'BRECHBUEHL   HANSRUDOLF', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 249059, '2011-07-27', 218900.00, 'A'),
    (2243, 3, 'IVANA SCHLUMPF', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 245206, '2011-04-08', 862270.00, 'A'),
    (2244, 3, 'JESSICA JACCART', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 189512, '2011-08-28', 654640.00, 'A'),
    (2246, 3, 'PAUSELLI MARIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 210050, '2011-09-26', 468090.00, 'A'),
    (2247, 3, 'VOLONTEIRO RICCARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-04-13', 281230.00, 'A'),
    (2248, 3, 'HOFFMANN ALVIR ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 120773, '2011-08-23', 1900.00, 'A'),
    (2249, 3, 'MANTOVANI DANIEL FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-08-09', 165820.00, 'A'),
    (225, 1, 'DUARTE RUEDA JAVIER ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-29', 293110.00, 'A'),
    (2250, 3, 'LIMA DA COSTA BRENO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-03-23', 823370.00, 'A'),
    (2251, 3, 'TAMBORIN MACIEL MAGALI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 619420.00, 'A'),
    (2252, 3, 'BELLO DE MUORA BIANCA', 191821112, 'CRA 25 CALLE 100', '969@gmail.com', '2011-02-03', 118942, '2011-08-03', 626970.00, 'A'),
    (2253, 3, 'VINHAS FORTUNA PIETRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2011-09-23', 276600.00, 'A'),
    (2255, 3, 'BLUMENTHAL JAIRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117630, '2011-07-20', 680590.00, 'A'),
    (2256, 3, 'DOS REIS FILHO ELPIDIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 120773, '2011-08-07', 896720.00, 'A'),
    (2257, 3, 'COIMBRA CARDOSO MUNARI FERNANDA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-09', 441830.00, 'A'),
    (2258, 3, 'LAZANHA FLAVIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118942, '2011-06-14', 519000.00, 'A'),
    (2259, 3, 'LAZANHA FLAVIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-06-14', 269480.00, 'A'),
    (226, 1, 'HUERFANO FLOREZ JOHN FAVER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-29', 148340.00, 'A'),
    (2260, 3, 'JOVETTA EDILSON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118941, '2011-09-19', 790430.00, 'A'),
    (2261, 3, 'DE OLIVEIRA ANDRE RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-07-25', 143680.00, 'A'),
    (2263, 3, 'MUNDO TEIXEIRA CARVALHO SILVIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118864, '2011-09-19', 304670.00, 'A'),
    (2264, 3, 'FERREIRA CINTRA ADRIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-04-08', 481910.00, 'A'),
    (2265, 3, 'AUGUSTO DE OLIVEIRA MARCOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118685, '2011-08-09', 495530.00, 'A'),
    (2266, 3, 'CHEN ROBERTO LUIZ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-03-15', 31920.00, 'A'),
    (2268, 3, 'WROBLESKI DIENSTMANN RAQUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117630, '2011-05-15', 269320.00, 'A'),
    (2269, 3, 'MALAGOLA GEDERSON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118864, '2011-05-30', 327540.00, 'A'),
    (227, 1, 'LOPEZ ESCOBAR CARLOS ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-06', 862360.00, 'A'),
    (2271, 3, 'GOMES EVANDRO HENRIQUE', 191821112, 'CRA 25 CALLE 100', '199@hotmail.es', '2011-02-03', 118777, '2011-03-24', 166100.00, 'A'),
    (2273, 3, 'LANDEIRA FERNANDEZ JESUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-21', 207990.00, 'A'),
    (2274, 3, 'ROSSI RENATO', 191821112, 'CRA 25 CALLE 100', '791@hotmail.es', '2011-02-03', 118777, '2011-09-19', 16170.00, 'A'),
    (2275, 3, 'CALMON RANGEL PATRICIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 456890.00, 'A'),
    (2277, 3, 'CIFU NETO ROQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-04-27', 808940.00, 'A'),
    (2278, 3, 'GONCALVES PRETO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118942, '2011-07-25', 336930.00, 'A'),
    (2279, 3, 'JORGE JUNIOR ROBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118777, '2011-05-09', 257840.00, 'A'),
    (2281, 3, 'ELENCIUC DEMETRIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 118777, '2011-04-20', 618510.00, 'A'),
    (2283, 3, 'CUNHA MENDEZ RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 119855, '2011-07-18', 431190.00, 'A'),
    (2286, 3, 'DIAZ LENICE APARECIDA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-05-03', 977840.00, 'A'),
    (2288, 3, 'DE CARVALHO SIGEL TATIANA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2011-07-04', 123920.00, 'A'),
    (229, 1, 'GALARZA GIRALDO SERGIO ALDEMAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-09-17', 746930.00, 'A'),
    (2290, 3, 'ACHOA MORANDI BORGUES SIBELE MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118777, '2011-09-12', 553890.00, 'A'),
    (2291, 3, 'EPAMINONDAS DE ALMEIDA DELIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-09-22', 14080.00, 'A'),
    (2293, 3, 'REIS CASTRO SHANA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-08-03', 1430.00, 'A'),
    (2294, 3, 'BERNARDES JUNIOR ARMANDO', 191821112, 'CRA 25 CALLE 100', '678@gmail.com', '2011-02-03', 127591, '2011-08-30', 780930.00, 'A'),
    (2295, 3, 'LEMOS DE SOUZA AGUIAR SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118777, '2011-10-03', 900370.00, 'A'),
    (2296, 3, 'CARVALHO ADAMS KARIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2011-08-11', 159040.00, 'A'),
    (2297, 3, 'GALLINA SILVANA BRASILEIRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-23', 94110.00, 'A'),
    (23, 1, 'COLMENARES PEDREROS EDUARDO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-02', 625870.00, 'A'),
    (2300, 3, 'TAVEIRA DE SIQUEIRA TANIA APARECIDA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-24', 443910.00, 'A'),
    (2301, 3, 'DA SIVA LIMA ANDRE LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-23', 165020.00, 'A'),
    (2302, 3, 'GALVAO GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118942, '2011-09-12', 493370.00, 'A'),
    (2303, 3, 'DA COSTA CRUZ GABRIELA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-07-27', 971800.00, 'A'),
    (2304, 3, 'BERNHARD GOTTFRIED RABER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-04-30', 378870.00, 'A'),
    (2306, 3, 'ALDANA URIBE PABLO AXEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-05-08', 758160.00, 'A'),
    (2308, 3, 'FLORES ALONSO EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-04-26', 995310.00, 'A'),
    ('CELL4330', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (2309, 3, 'MADRIGAL MIER Y TERAN LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-02-23', 414650.00, 'A'),
    (231, 1, 'ZAPATA CEBALLOS JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127662, '2011-08-16', 430320.00, 'A'),
    (2310, 3, 'GONZALEZ ALVARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-05-19', 87330.00, 'A'),
    (2313, 3, 'MONTES PORTO ANDREA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-09-01', 929180.00, 'A'),
    (2314, 3, 'ROCHA SUSUNAGA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2010-10-18', 541540.00, 'A'),
    (2315, 3, 'VASQUEZ CALERO FEDERICO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-22', 920160.00, 'A'),
    (2317, 3, 'GONZALEZ FERNANDEZ YUSSEN ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-26', 120530.00, 'A'),
    (2319, 3, 'ATTIAS WENGROWSKY DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150581, '2011-09-07', 8580.00, 'A'),
    (232, 1, 'OSPINA ABUCHAIBE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-07-14', 748960.00, 'A'),
    (2320, 3, 'EFRON TOPOROVSKY INES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 116511, '2011-07-15', 20810.00, 'A'),
    (2321, 3, 'LUNA PLA DARIO', 191821112, 'CRA 25 CALLE 100', '95@terra.com.co', '2011-02-03', 145135, '2011-09-07', 78320.00, 'A'),
    (2322, 1, 'VAZQUEZ DANIELA', 191821112, 'CRA 25 CALLE 100', '190@gmail.com', '2011-02-03', 145135, '2011-05-19', 329170.00, 'A'),
    (2323, 3, 'BALBI BALBI JUAN DE DIOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-08-23', 410880.00, 'A'),
    (2324, 3, 'MARROQUIN FERNANDEZ GELACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-03-23', 66880.00, 'A'),
    (2325, 3, 'VAZQUEZ ZAVALA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-04-11', 101770.00, 'A'),
    (2326, 3, 'SOTO MARTINEZ MARIA ELENA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-23', 308200.00, 'A'),
    (2328, 3, 'HERNANDEZ MURILLO RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-08-22', 253830.00, 'A'),
    (233, 1, 'HADDAD LINERO YEBRAIL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 130608, '2010-06-17', 453830.00, 'A'),
    (2330, 3, 'TERMINEL HERNANDEZ DANIELA PATRICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 190393, '2011-08-15', 48940.00, 'A'),
    (2331, 3, 'MIJARES FERNANDEZ MAGDALENA GUADALUPE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-07-31', 558440.00, 'A'),
    (2332, 3, 'GONZALEZ LUNA CARLOS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 146258, '2011-04-26', 645400.00, 'A'),
    (2333, 3, 'DIAZ TORREJON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-05-03', 551690.00, 'A'),
    (2335, 3, 'PADILLA GUTIERREZ JESUS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 456120.00, 'A'),
    (2336, 3, 'TORRES CORONA JORGE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-04-11', 813900.00, 'A'),
    (2337, 3, 'CASTRO RAMSES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150581, '2011-07-04', 701120.00, 'A'),
    (2338, 3, 'APARICIO VALLEJO RUSSELL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-03-16', 63890.00, 'A'),
    (2339, 3, 'ALBOR FERNANDEZ LUIS ARTURO', 191821112, 'CRA 25 CALLE 100', '574@gmail.com', '2011-02-03', 147467, '2011-05-09', 216110.00, 'A'),
    (234, 1, 'DOMINGUEZ GOMEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '942@hotmail.com', '2011-02-03', 127591, '2010-08-22', 22260.00, 'A'),
    (2342, 3, 'REY ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '110@facebook.com', '2011-02-03', 127591, '2011-03-04', 313330.00, 'A'),
    (2343, 3, 'MENDOZA GONZALES ADRIANA', 191821112, 'CRA 25 CALLE 100', '295@yahoo.com', '2011-02-03', 127591, '2011-03-23', 178720.00, 'A'),
    (2344, 3, 'RODRIGUEZ SEGOVIA JESUS ALONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-07-26', 953590.00, 'A'),
    (2345, 3, 'GONZALEZ PELAEZ EDUARDO DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-26', 231790.00, 'A'),
    (2347, 3, 'VILLEDA GARCIA DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 144939, '2011-05-29', 795600.00, 'A'),
    (2348, 3, 'FERRER BURGES EMILIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-04-11', 83430.00, 'A'),
    (2349, 3, 'NARRO ROBLES LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-03-16', 30330.00, 'A'),
    (2350, 3, 'ZALDIVAR UGALDE CARLOS IGNACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-06-19', 901380.00, 'A'),
    (2351, 3, 'VARGAS RODRIGUEZ VALENTE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 146258, '2011-04-26', 415910.00, 'A'),
    (2354, 3, 'DEL PIERO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-09', 19890.00, 'A'),
    (2355, 3, 'VILLAREAL ANA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-23', 211810.00, 'A'),
    (2356, 3, 'GARRIDO FERRAN JORGE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-22', 999370.00, 'A'),
    (2357, 3, 'PEREZ PRECIADO EDMUNDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-22', 361450.00, 'A'),
    (2358, 3, 'AGUIRRE VIGNAU DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150581, '2011-08-21', 809110.00, 'A'),
    (2359, 3, 'LOPEZ SESMA TOMAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 146258, '2011-09-14', 961200.00, 'A'),
    (236, 1, 'VENTO BETANCOURT LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-19', 682230.00, 'A'),
    (2360, 3, 'BERNAL MALDONADO GUILLERMO JAVIER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2011-09-19', 378670.00, 'A'),
    (2361, 3, 'GUZMAN DELGADO ALFREDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-22', 9770.00, 'A'),
    (2362, 3, 'GUZMAN DELGADO MARTIN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 912850.00, 'A'),
    (2363, 3, 'GUSMAND ELGADO JORGE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-22', 534910.00, 'A'),
    (2364, 3, 'RENDON BUICK JORGE JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-26', 936010.00, 'A'),
    (2365, 3, 'HERNANDEZ HERNANDEZ HERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-22', 75340.00, 'A'),
    (2366, 3, 'ALVAREZ PAZ PEDRO RAFAEL ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-01-02', 568650.00, 'A'),
    (2367, 3, 'MIJARES DE LA BARREDA FERNANDA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-07-31', 617240.00, 'A'),
    (2368, 3, 'MARTINEZ LOPEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-08-24', 380250.00, 'A'),
    (2369, 3, 'GAYTAN MILLAN YANERI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-23', 49520.00, 'A'),
    (237, 1, 'BARGUIL ASSIS DAVID ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117460, '2009-09-03', 161770.00, 'A'),
    (2370, 3, 'DURAN HEREDIA FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-04-15', 106850.00, 'A'),
    (2371, 3, 'SEGURA MIJARES CRISTOBAL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-31', 385700.00, 'A'),
    (2372, 3, 'TEPOS VALTIERRA ERIK ARTURO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 116345, '2011-09-01', 607930.00, 'A'),
    (2373, 3, 'RODRIGUEZ AGUILAR EDMUNDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-05-04', 882570.00, 'A'),
    (2374, 3, 'MYSLABODSKI MICHAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-03-08', 589060.00, 'A'),
    (2375, 3, 'HERNANDEZ MIRELES JATNIEL ELIOENAI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-26', 297600.00, 'A'),
    (2376, 3, 'SNELL FERNANDEZ SYNTYHA ROCIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 720830.00, 'A'),
    (2378, 3, 'HERNANDEZ EIVET AARON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-26', 394200.00, 'A'),
    (2379, 3, 'LOPEZ GARZA JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-22', 837000.00, 'A'),
    (238, 1, 'GARCIA PINO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-10', 762140.00, 'A'),
    (2381, 3, 'TOSCANO ESTRADA RUBEN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-22', 500940.00, 'A'),
    (2382, 3, 'RAMIREZ HUDSON ROGER SILVESTER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-22', 497550.00, 'A'),
    (2383, 3, 'RAMOS JUAN ANTONIO', 191821112, 'CRA 25 CALLE 100', '362@yahoo.es', '2011-02-03', 127591, '2011-08-22', 984940.00, 'A'),
    (2384, 3, 'CORTES CERVANTES ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-04-11', 432020.00, 'A'),
    (2385, 3, 'POZOS ESQUIVEL DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-27', 205310.00, 'A'),
    (2387, 3, 'ESTRADA AGUIRRE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-22', 36470.00, 'A'),
    (2388, 3, 'GARCIA RAMIREZ RAMON', 191821112, 'CRA 25 CALLE 100', '177@yahoo.es', '2011-02-03', 127591, '2011-08-22', 990910.00, 'A'),
    (2389, 3, 'PRUD HOMME GARCIA CUBAS XAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-05-18', 845140.00, 'A'),
    (239, 1, 'PINZON ARDILA GUSTAVO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-01', 325400.00, 'A'),
    (2390, 3, 'ELIZABETH OCHOA ROJAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-05-21', 252950.00, 'A'),
    (2391, 3, 'MEZA ALVAREZ JOSE ALBERTO', 191821112, 'CRA 25 CALLE 100', '646@terra.com.co', '2011-02-03', 144939, '2011-05-09', 729340.00, 'A'),
    (2392, 3, 'HERRERA REYES RENATO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2010-02-28', 887860.00, 'A'),
    (2393, 3, 'MURILLO GARIBAY GILBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-08-20', 251280.00, 'A'),
    (2394, 3, 'GARCIA JIMENEZ CARLOS MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-09', 592830.00, 'A'),
    (2395, 3, 'GUAGNELLI MARTINEZ BLANCA MONICA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145184, '2010-10-05', 210320.00, 'A'),
    (2397, 3, 'GARCIA CISNEROS RAUL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-07-04', 734530.00, 'A'),
    (2398, 3, 'MIRANDA ROMO FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 853340.00, 'A'),
    (24, 1, 'ARREGOCES GARZON NELSON ORLANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127783, '2011-08-12', 403190.00, 'A'),
    (240, 1, 'ARCINIEGAS GOMEZ ALBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-18', 340590.00, 'A'),
    (2400, 3, 'HERRERA ABARCA EDUARDO VICENTE ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-22', 755620.00, 'A'),
    (2403, 3, 'CASTRO MONCAYO LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-07-29', 617260.00, 'A'),
    (2404, 3, 'GUZMAN DELGADO OSBALDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-22', 56250.00, 'A'),
    (2405, 3, 'GARCIA LOPEZ DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-22', 429500.00, 'A'),
    (2406, 3, 'JIMENEZ GAMEZ RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 245206, '2011-03-23', 978720.00, 'A'),
    (2407, 3, 'BECERRA MARTINEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-08-23', 605130.00, 'A'),
    (2408, 3, 'GARCIA MARTINEZ BERNARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-22', 89480.00, 'A'),
    (2409, 3, 'URRUTIA RAYAS BALTAZAR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-22', 632020.00, 'A'),
    (241, 1, 'MEDINA AGUILA NESTOR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-09', 726730.00, 'A'),
    (2411, 3, 'VERGARA MENDOZAVICTOR HUGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-06-15', 562230.00, 'A'),
    (2412, 3, 'MENDOZA MEDINA JORGE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-22', 136170.00, 'A'),
    (2413, 3, 'CORONADO CASTILLO HUGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 147529, '2011-05-09', 994160.00, 'A'),
    (2414, 3, 'GONZALEZ SOTO DELIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-03-23', 562280.00, 'A'),
    (2415, 3, 'HERNANDEZ FLORES STEPHANIE REYNA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-23', 828940.00, 'A'),
    (2416, 3, 'ABRAJAN GUERRERO MARIA DE LOS ANGELES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-23', 457860.00, 'A'),
    (2417, 3, 'HERNANDEZ LOERA ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-23', 802490.00, 'A'),
    (2418, 3, 'TARIN LOPEZ JOSE CARMEN', 191821112, 'CRA 25 CALLE 100', '117@gmail.com', '2011-02-03', 127591, '2011-03-23', 638870.00, 'A'),
    (242, 1, 'JULIO NARVAEZ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-05', 611890.00, 'A'),
    (2420, 3, 'BATTA MARQUEZ VICTOR ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-08-23', 17820.00, 'A'),
    (2423, 3, 'GONZALEZ REYES JUAN JOSE', 191821112, 'CRA 25 CALLE 100', '55@yahoo.es', '2011-02-03', 127591, '2011-07-26', 758070.00, 'A'),
    (2425, 3, 'ALVAREZ RODRIGUEZ HIRAM RAMSES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-23', 847420.00, 'A'),
    (2426, 3, 'FEMATT HERNANDEZ JESUS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-03-23', 164130.00, 'A'),
    (2427, 3, 'GUTIERRES ORTEGA FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-22', 278410.00, 'A'),
    (2428, 3, 'JIMENEZ DIAZ JUAN JORGE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-13', 899650.00, 'A'),
    (2429, 3, 'VILLANUEVA PEREZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '656@yahoo.es', '2011-02-03', 150449, '2011-03-23', 663000.00, 'A'),
    (243, 1, 'GOMEZ REYES ANDRES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126674, '2009-12-20', 879240.00, 'A'),
    (2430, 3, 'CERON GOMEZ JOEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-03-21', 616070.00, 'A'),
    (2431, 3, 'LOPEZ LINALDI DEMETRIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-05-09', 91360.00, 'A'),
    (2432, 3, 'JOSEPH NATHAN PEDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-02', 608580.00, 'A'),
    (2433, 3, 'CARRENO PULIDO RUBEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 147242, '2011-06-19', 768810.00, 'A'),
    (2434, 3, 'AREVALO MERCADO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-06-12', 18320.00, 'A'),
    (2436, 3, 'RAMIREZ QUEZADA ERIKA BELEM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-03', 870930.00, 'A'),
    (2438, 3, 'TATTO PRIETO MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-05-19', 382740.00, 'A'),
    (2439, 3, 'LOPEZ AYALA LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-10-08', 916370.00, 'A'),
    (244, 1, 'DEVIS EDGAR JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-10-08', 560540.00, 'A'),
    (2440, 3, 'HERNANDEZ TOVAR JORGE ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 144991, '2011-10-02', 433650.00, 'A'),
    (2441, 3, 'COLLIARD LOPEZ PETER GEORGE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-09', 419120.00, 'A'),
    (2442, 3, 'FLORES CHALA GARY', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-22', 794670.00, 'A'),
    (2443, 3, 'FANDINO MUNOZ ZAMIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-19', 715970.00, 'A'),
    (2444, 3, 'BARROSO VARGAS DIEGO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-26', 195840.00, 'A'),
    (2446, 3, 'CRUZ RAMIREZ JUAN PEDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-07-14', 569050.00, 'A'),
    (2447, 3, 'TIJERINA ACOSTA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-26', 351280.00, 'A'),
    (2449, 3, 'JASSO BARRERA CARLOS GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-08-24', 192560.00, 'A'),
    (245, 1, 'LENCHIG KALEDA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-09-02', 165000.00, 'A'),
    (2450, 3, 'GARRIDO PATRON VICTOR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-09-27', 814970.00, 'A'),
    (2451, 3, 'VELASQUEZ GUERRERO RUBEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-20', 497150.00, 'A'),
    (2452, 3, 'CHOI SUNGKYU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 209494, '2011-08-16', 40860.00, 'A'),
    (2453, 3, 'CONTRERAS LOPEZ SERGIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-08-05', 712830.00, 'A'),
    (2454, 3, 'CHAVEZ BATAA OSCAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 150699, '2011-06-14', 441590.00, 'A'),
    (2455, 3, 'LEE JONG HYUN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131272, '2011-10-10', 69460.00, 'A'),
    (2456, 3, 'MEDINA PADILLA CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 146589, '2011-04-20', 22530.00, 'A'),
    (2457, 3, 'FLORES CUEVAS DOTNARA LUZ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-05-17', 904260.00, 'A'),
    (2458, 3, 'LIU YONGCHAO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-10-09', 453710.00, 'A'),
    (2459, 3, 'CASTRO FERNANDES PORTOCARRERO JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 195892, '2011-06-14', 555790.00, 'A'),
    (246, 1, 'YAMHURE FONSECAN ERNESTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-10-03', 143350.00, 'A'),
    (2460, 3, 'DUAN WEI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-06-22', 417820.00, 'A'),
    (2461, 3, 'ZHU XUTAO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-18', 421740.00, 'A'),
    (2462, 3, 'MEI SHUANNIU', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-09', 855240.00, 'A'),
    (2464, 3, 'VEGA VACA LUIS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-06-08', 489110.00, 'A'),
    (2465, 3, 'TANG YUMING', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 147578, '2011-03-26', 412660.00, 'A'),
    (2466, 3, 'VILLEDA GARCIA DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 144939, '2011-06-07', 595990.00, 'A'),
    (2467, 3, 'GARCIA GARZA BLANCA ARMIDA', 191821112, 'CRA 25 CALLE 100', '927@hotmail.com', '2011-02-03', 145135, '2011-05-20', 741940.00, 'A'),
    (2468, 3, 'HERNANDEZ MARTINEZ EMILIO JOAQUIN', 191821112, 'CRA 25 CALLE 100', '356@facebook.com', '2011-02-03', 145135, '2011-06-16', 921740.00, 'A'),
    (2469, 3, 'WANG FAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 185363, '2011-08-20', 382860.00, 'A'),
    (247, 1, 'ROJAS RODRIGUEZ ALVARO HERNAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-09', 221760.00, 'A'),
    (2470, 3, 'WANG FEI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-10-09', 149100.00, 'A'),
    (2471, 3, 'BERNAL MALDONADO GUILLERMO JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118777, '2011-07-26', 596900.00, 'A'),
    (2472, 3, 'GUTIERREZ GOMEZ ARTURO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145184, '2011-07-24', 537210.00, 'A'),
    (2474, 3, 'LAN TYANYE ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-23', 865050.00, 'A'),
    (2475, 3, 'LAN SHUZHEN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-23', 639240.00, 'A'),
    (2476, 3, 'RODRIGUEZ GONZALEZ CARLOS ARTURO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 144616, '2011-08-09', 601050.00, 'A'),
    (2477, 3, 'HAIBO NI', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-20', 87540.00, 'A'),
    (2479, 3, 'RUIZ RODRIGUEZ GRACIELA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-05-20', 910130.00, 'A'),
    (248, 1, 'GONZALEZ RODRIGUEZ ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-03', 678750.00, 'A'),
    (2480, 3, 'OROZCO MACIAS NORMA LETICIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-09-20', 647010.00, 'A'),
    (2481, 3, 'MEZA ALVAREZ JOSE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 144939, '2011-06-07', 504670.00, 'A'),
    (2482, 3, 'RODRIGUEZ FIGUEROA RODRIGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 146308, '2011-04-27', 582290.00, 'A'),
    (2483, 3, 'CARREON GUERRA ANA CECILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 110709, '2011-05-27', 397440.00, 'A'),
    (2484, 3, 'BOTELHO BARRETO CARLOS JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 195892, '2011-08-02', 240350.00, 'A'),
    (2485, 3, 'CORONADO CASTILLO HUGO', 191821112, 'CRA 25 CALLE 100', '209@yahoo.com.mx', '2011-02-03', 147529, '2011-06-07', 9420.00, 'A'),
    (2486, 3, 'DE FUENTES GARZA MARCELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-18', 326030.00, 'A'),
    (2487, 3, 'GONZALEZ DUHART GUTIERREZ HORACIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-17', 601920.00, 'A'),
    (2488, 3, 'LOPEZ LINALDI DEMETRIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-06-07', 31500.00, 'A'),
    (2489, 3, 'CASTRO MONCAYO JOSE LUIS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-06-15', 351720.00, 'A'),
    (249, 1, 'CASTRO RIBEROS JULIAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-23', 728470.00, 'A'),
    (2490, 3, 'SERRALDE LOPEZ MARIA GUADALUPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-25', 664120.00, 'A'),
    (2491, 3, 'GARRIDO PATRON VICTOR', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-09-29', 265450.00, 'A'),
    (2492, 3, 'BRAUN JUAN NICOLAS ANTONIE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-28', 334880.00, 'A'),
    (2493, 3, 'BANKA RAHUL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 141138, '2011-05-02', 878070.00, 'A'),
    (2494, 1, 'GARCIA MARTINEZ MARIA VIRGINIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-17', 385690.00, 'A'),
    (2495, 1, 'MARIA VIRGINIA', 191821112, 'CRA 25 CALLE 100', '298@yahoo.com.mx', '2011-02-03', 127591, '2011-04-16', 294220.00, 'A'),
    (2496, 3, 'GOMEZ ZENDEJAS MARIA ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145184, '2011-06-06', 314060.00, 'A'),
    (2498, 3, 'MENDEZ MARTINEZ RAUL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-07-10', 496040.00, 'A'),
    (2623, 3, 'ZAFIROPOULO ANA I', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-25', 98170.00, 'A'),
    (2499, 3, 'CARREON GUERRA ANA CECILIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-07-29', 417240.00, 'A'),
    (2501, 3, 'OLIVAR ARIAS ISMAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-06-06', 738850.00, 'A'),
    (2502, 3, 'ABOUMRAD NASTA EMILE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 145135, '2011-07-26', 899890.00, 'A'),
    (2503, 3, 'RODRIGUEZ JIMENEZ ROBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-05-03', 282900.00, 'A'),
    (2504, 3, 'ESTADOS UNIDOS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 145135, '2011-07-27', 714840.00, 'A'),
    (2505, 3, 'SOTO MUNOZ MARCO GREGORIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-26', 725480.00, 'A'),
    (2506, 3, 'GARCIA MONTER ANA OTILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 145135, '2011-10-05', 482880.00, 'A'),
    (2507, 3, 'THIRUKONDA VIGNESH', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 126180, '2011-05-02', 237950.00, 'A'),
    (2508, 3, 'RAMIREZ REATIAGA LYDA YOANA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 150699, '2011-06-26', 741120.00, 'A'),
    (2509, 3, 'SEPULVEDA RODRIGUEZ JESUS ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-26', 991730.00, 'A'),
    (251, 1, 'MEJIA PIZANO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-10', 845000.00, 'A'),
    (2510, 3, 'FRANCISCO MARIA DIAS COSTA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 179111, '2011-07-12', 735330.00, 'A'),
    (2511, 3, 'TEIXEIRA REGO DE OLIVEIRA TIAGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 179111, '2011-06-14', 701430.00, 'A'),
    (2512, 3, 'PHILLIP JAMES', 191821112, 'CRA 25 CALLE 100', '766@terra.com.co', '2011-02-03', 127591, '2011-09-28', 301150.00, 'A'),
    (2513, 3, 'ERXLEBEN ROBERT', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 216125, '2011-04-13', 401460.00, 'A'),
    (2514, 3, 'HUGHES  CONNORRICHARD', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-06-22', 103880.00, 'A'),
    (2515, 3, 'LEBLANC MICHAEL PAUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 216125, '2011-08-09', 314990.00, 'A'),
    (2517, 3, 'DEVINE CHRISTOPHER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-06-22', 371560.00, 'A'),
    (2518, 3, 'WONG BRIAN TEK FUNG', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126885, '2011-09-22', 67910.00, 'A'),
    (2519, 3, 'BIDWALA IRFAN A', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 154811, '2011-03-28', 224840.00, 'A'),
    (252, 1, 'JIMENEZ LARRARTE JUAN GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-01', 406770.00, 'A'),
    (2520, 3, 'LEE HO YIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 147578, '2011-08-29', 920470.00, 'A'),
    (2521, 3, 'DE MOURA MARTINS NUNO ALEXANDRE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196094, '2011-10-09', 927850.00, 'A'),
    (2522, 3, 'DA COSTA GOMES CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 179111, '2011-08-10', 877850.00, 'A'),
    (2523, 3, 'HOOGWAERTS PAUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118777, '2011-02-11', 605690.00, 'A'),
    (2524, 3, 'LOPES MARQUES LUIS JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2011-09-20', 394910.00, 'A'),
    (2525, 3, 'CORREIA CAVACO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 178728, '2011-10-09', 157470.00, 'A'),
    (2526, 3, 'HALL JOHN WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-09', 602620.00, 'A'),
    (2527, 3, 'KNIGHT MARTIN GYLES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 113550, '2011-08-29', 540670.00, 'A'),
    (2528, 3, 'HINDS THMAS TRISTAN PELLEW', 191821112, 'CRA 25 CALLE 100', '337@yahoo.es', '2011-02-03', 116862, '2011-08-23', 895500.00, 'A'),
    (2529, 3, 'CARTON ALAN JOHN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-07-31', 855510.00, 'A'),
    (253, 1, 'AZCUENAGA RAMIREZ NICOLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 298472, '2011-05-10', 498840.00, 'A'),
    (2530, 3, 'GHIM CHEOLL HO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-27', 591060.00, 'A'),
    (2531, 3, 'PHILLIPS NADIA SULLIVAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-28', 388750.00, 'A'),
    (2532, 3, 'CHANG KUKHYUN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-22', 170560.00, 'A'),
    (2533, 3, 'KANG SEOUNGHYUN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 173192, '2011-08-24', 686540.00, 'A'),
    (2534, 3, 'CHUNG BYANG HOON', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 125744, '2011-03-14', 921030.00, 'A'),
    (2535, 3, 'SHIN MIN CHUL ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 173192, '2011-08-24', 545510.00, 'A'),
    (2536, 3, 'CHOI JIN SUNG', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-15', 964490.00, 'A'),
    (2537, 3, 'CHOI SUNGMIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-27', 185910.00, 'A'),
    (2538, 3, 'PARK JAESER ', 191821112, 'CRA 25 CALLE 100', '525@terra.com.co', '2011-02-03', 127591, '2011-09-03', 36090.00, 'A'),
    (2539, 3, 'KIM DAE HOON ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 173192, '2011-08-24', 622700.00, 'A'),
    (254, 1, 'AVENDANO PABON ROLANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-05-12', 273900.00, 'A'),
    (2540, 3, 'LYNN MARIA CRISTINA NORMA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116862, '2011-09-21', 5220.00, 'A'),
    (2541, 3, 'KIM CHINIL JULIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 147578, '2011-08-27', 158030.00, 'A'),
    (2543, 3, 'HALL JOHN WILLIAM', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-09', 398290.00, 'A'),
    (2544, 3, 'YOSUKE PERDOMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 165600, '2011-07-26', 668040.00, 'A'),
    (2546, 3, 'AKAGI KAZAHIKO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-26', 722510.00, 'A'),
    (2547, 3, 'NELSON JONATHAN GARY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-09', 176570.00, 'A'),
    (2548, 3, 'DUONG HOP BA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 116862, '2011-09-14', 715310.00, 'A'),
    (2549, 3, 'CHAO-VILLEGAS NIKOLE TUK HING', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 180063, '2011-04-05', 46830.00, 'A'),
    (255, 1, 'CORREA ALVARO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-27', 872990.00, 'A'),
    (2551, 3, 'APPELS LAURENT BERNHARD', 191821112, 'CRA 25 CALLE 100', '891@hotmail.es', '2011-02-03', 135190, '2011-08-16', 300620.00, 'A'),
    (2552, 3, 'PLAISIER ERIK JAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289294, '2011-05-23', 238440.00, 'A'),
    (2553, 3, 'BLOK HENDRIK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 288552, '2011-03-27', 290350.00, 'A'),
    (2554, 3, 'NETTE ANNA STERRE', 191821112, 'CRA 25 CALLE 100', '621@yahoo.com.mx', '2011-02-03', 185363, '2011-07-30', 736400.00, 'A'),
    (2555, 3, 'FRIELING HANS ERIC', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 107469, '2011-07-31', 810990.00, 'A'),
    (2556, 3, 'RUTTE CORNELIA JANTINE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 143579, '2011-03-30', 845710.00, 'A'),
    (2557, 3, 'WALRAVEN PIETER PAUL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 289294, '2011-07-29', 795620.00, 'A'),
    (2558, 3, 'TREBES LAURENS JOHANNES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-11-22', 440940.00, 'A'),
    (2559, 3, 'KROESE  ROLANDWILLEBRORDUSMARIA', 191821112, 'CRA 25 CALLE 100', '188@facebook.com', '2011-02-03', 110643, '2011-06-09', 817860.00, 'A'),
    (256, 1, 'FARIAS GARCIA REINI', 191821112, 'CRA 25 CALLE 100', '615@hotmail.com', '2011-02-03', 127591, '2011-03-05', 543220.00, 'A'),
    (2560, 3, 'VAN DER HEIDE HENDRIK', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 291042, '2011-09-04', 766460.00, 'A'),
    (2561, 3, 'VAN DEN BERG DONAR ALEXANDER GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 190393, '2011-07-13', 378720.00, 'A'),
    (2562, 3, 'GODEFRIDUS JOHANNES ROPS ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127622, '2011-10-02', 594240.00, 'A'),
    (2564, 3, 'WAT YOK YIENG', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 287095, '2011-03-22', 392370.00, 'A'),
    (2565, 3, 'BUIS JACOBUS NICOLAAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-20', 456810.00, 'A'),
    (2567, 3, 'CHIPPER FRANCIUSCUS NICOLAAS ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 291599, '2011-07-28', 164300.00, 'A'),
    (2568, 3, 'ONNO ROUKENS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-11-28', 500670.00, 'A'),
    (2569, 3, 'PETRUS MARCELLINUS STEPHANUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150699, '2011-06-25', 10430.00, 'A'),
    (2571, 3, 'VAN VOLLENHOVEN IVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-08', 719370.00, 'A'),
    (2572, 3, 'LAMBOOIJ BART', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-09-20', 946480.00, 'A'),
    (2573, 3, 'LANSER MARIANA PAULINE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 289294, '2011-04-09', 574270.00, 'A'),
    (2575, 3, 'KLERKEN JOHANNES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 286101, '2011-05-24', 436840.00, 'A'),
    (2576, 3, 'KRAS JACOBUS NICOLAAS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 289294, '2011-09-26', 88410.00, 'A'),
    (2577, 3, 'FUCHS MICHAEL JOSEPH', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 185363, '2011-07-30', 131530.00, 'A'),
    (2578, 3, 'BIJVANK ERIK JAN WILLEM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-11', 392410.00, 'A'),
    (2579, 3, 'SCHMIDT FRANC ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 106742, '2011-09-11', 567470.00, 'A'),
    (258, 1, 'SOTO GONZALEZ FRANCISCO LAZARO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 116511, '2011-05-07', 856050.00, 'A'),
    (2580, 3, 'VAN DER KOOIJ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 291277, '2011-07-10', 660130.00, 'A'),
    (2581, 2, 'KRIS ANDRE GEORGES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127300, '2011-07-26', 598240.00, 'A'),
    (2582, 3, 'HARDING LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 263813, '2011-05-08', 10820.00, 'A'),
    (2583, 3, 'ROLLI GUY JEAN ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 145135, '2011-05-31', 259370.00, 'A'),
    (2584, 3, 'NIETO PARRA SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 263813, '2011-07-04', 264400.00, 'A'),
    (2585, 3, 'LASTRA CHAVEZ PABLO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126674, '2011-05-25', 543890.00, 'A'),
    (2586, 1, 'ZAIDA MAYERLY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-05', 926250.00, 'A'),
    (2587, 1, 'OSWALDO SOLORZANO CONTRERAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-28', 999590.00, 'A'),
    (2588, 3, 'ZHOU XUAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-18', 219200.00, 'A'),
    (2589, 3, 'HUANG ZHENGQUN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-18', 97230.00, 'A'),
    (259, 1, 'GALARZA NARANJO JAIME RENE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 988830.00, 'A'),
    (2590, 3, 'HUANG ZHENQUIN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-18', 828560.00, 'A'),
    (2591, 3, 'WEIDEN MULLER AMURER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-29', 851110.00, 'A'),
    (2593, 3, 'OESTERHAUS CORNELIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 256231, '2011-03-29', 295960.00, 'A'),
    (2594, 3, 'RINTALAHTI JUHA HENRIK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 170220.00, 'A'),
    (2597, 3, 'VERWIJNEN JONAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 289697, '2011-02-03', 638040.00, 'A'),
    (2598, 3, 'SHAW ROBERT', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 157414, '2011-07-10', 273550.00, 'A'),
    (2599, 3, 'MAKINEN TIMO JUHANI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 196234, '2011-09-13', 453600.00, 'A'),
    (260, 1, 'RIVERA CANON JOSE EDWARD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127538, '2011-09-19', 375990.00, 'A'),
    (2600, 3, 'HONKANIEMI ARTO OLAVI', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 301387, '2011-09-06', 447380.00, 'A'),
    (2601, 3, 'DAGG JAMIE MICHAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 216125, '2011-08-09', 876080.00, 'A'),
    (2602, 3, 'BOLAND PATRICK CHARLES ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 216125, '2011-09-14', 38260.00, 'A'),
    (2603, 2, 'ZULEYKA JERRYS RIVERA MENDOZA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 150347, '2011-03-27', 563050.00, 'A'),
    (2604, 3, 'DELGADO SEQUIRA FERRAO JOSE PEDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 188228, '2011-08-16', 700460.00, 'A'),
    (2605, 3, 'YORRO LORA EDGAR MANUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127689, '2011-06-17', 813180.00, 'A'),
    (2606, 3, 'CARRASCO RODRIGUEZQCARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127689, '2011-06-17', 964520.00, 'A'),
    (2607, 30, 'ORJUELA VELASQUEZ JULIANA MARIA', 191821112, 'CRA 25 CALLE 100', '372@terra.com.co', '2011-02-03', 132775, '2011-09-01', 383070.00, 'A'),
    (2608, 3, 'DUQUE DUTRA LUIS EDUARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 118942, '2011-07-12', 21780.00, 'A'),
    (261, 1, 'MURCIA MARQUEZ NESTOR JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-19', 913480.00, 'A'),
    (2610, 3, 'NGUYEN HUU KHUONG', 191821112, 'CRA 25 CALLE 100', '457@facebook.com', '2011-02-03', 132958, '2011-05-07', 733120.00, 'A'),
    (2611, 3, 'NGUYEN VAN LAP', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 786510.00, 'A'),
    (2612, 3, 'PHAM HUU THU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 733200.00, 'A'),
    (2613, 3, 'DANG MING CUONG', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-05-07', 306460.00, 'A'),
    (2614, 3, 'VU THI HONG HANH', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-05-07', 332710.00, 'A'),
    (2615, 3, 'CHAU TANG LANG', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-05-07', 744190.00, 'A'),
    (2616, 3, 'CHU BAN THING', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2011-05-07', 722800.00, 'A'),
    (2617, 3, 'NGUYEN QUANG THU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132958, '2011-05-07', 381420.00, 'A'),
    (2618, 3, 'TRAN THI KIM OANH', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-05-07', 738690.00, 'A'),
    (2619, 3, 'NGUYEN VAN VINH', 191821112, 'CRA 25 CALLE 100', '422@yahoo.com.mx', '2011-02-03', 132958, '2011-05-07', 549210.00, 'A'),
    (262, 1, 'ABDULAZIS ELNESER KHALED', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-27', 439430.00, 'A'),
    (2620, 3, 'NGUYEN XUAN VY', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132958, '2011-05-07', 529950.00, 'A'),
    (2621, 3, 'HA MANH HOA', 191821112, 'CRA 25 CALLE 100', '439@gmail.com', '2011-02-03', 132958, '2011-05-07', 2160.00, 'A'),
    (2622, 3, 'ZAFIROPOULO STEVEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-25', 420930.00, 'A'),
    (2624, 3, 'TEMIGTERRA MASSIMILIANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 210050, '2011-09-26', 228070.00, 'A'),
    (2625, 3, 'CASSES TRINDADE HELGIO HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118402, '2011-09-13', 845850.00, 'A'),
    (2626, 3, 'ASCOLI MASTROENI MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 120773, '2011-09-07', 545010.00, 'A'),
    (2627, 3, 'MONTEIRO SOARES MARCOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 120773, '2011-07-18', 187530.00, 'A'),
    (2629, 3, 'HALL ALVARO AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 120773, '2011-08-02', 950450.00, 'A'),
    (2631, 3, 'ANDRADE CATUNDA RAFAEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 120773, '2011-08-23', 370860.00, 'A'),
    (2632, 3, 'MAGALHAES MAYRA ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118767, '2011-08-23', 320960.00, 'A'),
    (2633, 3, 'SPREAFICO MIRIAM ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118587, '2011-08-23', 492220.00, 'A'),
    (2634, 3, 'GOMES FERREIRA HELIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 125812, '2011-08-23', 498220.00, 'A'),
    (2635, 3, 'FERNANDES SENNA PIRES SERGIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-05', 14460.00, 'A'),
    (2636, 3, 'BALESTRO FLORIANO FABIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 120773, '2011-08-24', 577630.00, 'A'),
    (2637, 3, 'CABANA DE QUEIROZ ANDRADE ALAXANDRE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-23', 844780.00, 'A'),
    (2638, 3, 'DALBOSCO CARLA', 191821112, 'CRA 25 CALLE 100', '380@yahoo.com.mx', '2011-02-03', 127591, '2011-06-30', 491010.00, 'A'),
    (264, 1, 'ROMERO MONTOYA NICOLAY ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-13', 965220.00, 'A'),
    (2640, 3, 'BILLINI CRUZ RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 144215, '2011-03-27', 130530.00, 'A'),
    (2641, 3, 'VASQUES ARIAS DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 144509, '2011-08-19', 890500.00, 'A'),
    (2642, 3, 'ROJAS VOLQUEZ GLADYS MICHELLE', 191821112, 'CRA 25 CALLE 100', '852@gmail.com', '2011-02-03', 144215, '2011-07-25', 60930.00, 'A'),
    (2643, 3, 'LLANEZA GIL JUAN RAFAELMO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 144215, '2011-07-08', 633120.00, 'A'),
    (2646, 3, 'AVILA PEROZO IANKEL JACOB', 191821112, 'CRA 25 CALLE 100', '318@hotmail.com', '2011-02-03', 144215, '2011-09-03', 125600.00, 'A'),
    (2647, 3, 'REGULAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-19', 583540.00, 'A'),
    (2648, 3, 'CORONADO BATISTA JOSE ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-19', 540910.00, 'A'),
    (2649, 3, 'OLIVIER JOSE VICTOR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 144509, '2011-08-19', 953910.00, 'A'),
    (2650, 3, 'YOO HOE TAEK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-08-25', 146820.00, 'A'),
    (266, 1, 'CUECA RODRIGUEZ CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-22', 384280.00, 'A'),
    (267, 1, 'NIETO ALVARADO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2008-04-28', 553450.00, 'A'),
    (269, 1, 'LEAL HOLGUIN FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-25', 411700.00, 'A'),
    (27, 1, 'MORENO MORENO CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2009-09-15', 995620.00, 'A'),
    (270, 1, 'CANO IBANES JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-03', 215260.00, 'A'),
    (271, 1, 'RESTREPO HERRAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132775, '2011-04-18', 841220.00, 'A'),
    (272, 3, 'RIOS FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 199862, '2011-03-24', 560300.00, 'A'),
    (273, 1, 'MADERO LORENZANA NICOLAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-03', 277850.00, 'A'),
    (274, 1, 'GOMEZ GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-09-24', 708350.00, 'A'),
    (275, 1, 'CONSUEGRA ARENAS ANDRES MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-09-09', 708210.00, 'A'),
    (276, 1, 'HURTADO ROJAS NICOLAS', 191821112, 'CRA 25 CALLE 100', '463@yahoo.com.mx', '2011-02-03', 127591, '2011-09-07', 416000.00, 'A'),
    (277, 1, 'MURCIA BAQUERO MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-02', 955370.00, 'A'),
    (2773, 3, 'TAKUBO KAORI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 165753, '2011-05-12', 872390.00, 'A'),
    (2774, 3, 'OKADA MAKOTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 165753, '2011-06-19', 921480.00, 'A'),
    (2775, 3, 'TAKEDA AKIO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 21062, '2011-06-19', 990250.00, 'A'),
    (2776, 3, 'KOIKE WATARU ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 165753, '2011-06-19', 186800.00, 'A'),
    (2777, 3, 'KUBO SHINEI', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 165753, '2011-02-13', 963230.00, 'A'),
    (2778, 3, 'KANNO YONEZO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 165600, '2011-07-26', 255770.00, 'A'),
    (278, 3, 'PARENT ELOIDE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 267980, '2011-05-01', 528840.00, 'A'),
    (2781, 3, 'SUNADA MINORU ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 165753, '2011-06-19', 724450.00, 'A'),
    (2782, 3, 'INOUE KASUYA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-22', 87150.00, 'A'),
    (2783, 3, 'OTAKE NOBUTOSHI', 191821112, 'CRA 25 CALLE 100', '208@facebook.com', '2011-02-03', 127591, '2011-06-11', 262380.00, 'A'),
    (2784, 3, 'MOTOI KEN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 165753, '2011-06-19', 50470.00, 'A'),
    (2785, 3, 'TANAKA KIYOTAKA ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 165753, '2011-06-19', 465210.00, 'A'),
    (2787, 3, 'YUMIKOPERDOMO', 191821112, 'CRA 25 CALLE 100', '600@yahoo.es', '2011-02-03', 165600, '2011-07-26', 477550.00, 'A'),
    (2788, 3, 'FUKUSHIMA KENZO', 191821112, 'CRA 25 CALLE 100', '599@gmail.com', '2011-02-03', 156960, '2011-05-30', 863860.00, 'A'),
    (2789, 3, 'GELGIN LEVENT NURI', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-26', 886630.00, 'A'),
    (279, 1, 'AVIATUR S. A.', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-02', 778110.00, 'A'),
    (2791, 3, 'GELGIN ENIS ENRE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-26', 547940.00, 'A'),
    (2792, 3, 'PAZ SOTO LUBRASCA MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 143954, '2011-06-27', 215000.00, 'A'),
    (2794, 3, 'MOURAD TAOUFIKI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-13', 511000.00, 'A'),
    (2796, 3, 'DASTUS ALAIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 218656, '2011-05-29', 774010.00, 'A'),
    (2797, 3, 'MCDONALD MICHAEL LORNE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 269033, '2011-07-19', 85820.00, 'A'),
    (2799, 3, 'KLESO MICHAEL QUENTIN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-07-26', 277950.00, 'A'),
    (28, 1, 'GONZALEZ ACUNA EDGAR MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-19', 531710.00, 'A'),
    (280, 3, 'NEME KARIM CHAIBAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 135967, '2010-05-02', 304040.00, 'A'),
    (2800, 3, 'CLERK CHARLES ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 244158, '2011-07-26', 68490.00, 'A'),
    ('CELL3673', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (2801, 3, 'BURRIS MAURICE STEWARD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-27', 508600.00, 'A'),
    (2802, 1, 'PINCHEN CLAIRE ELAINE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 216125, '2011-04-13', 337530.00, 'A'),
    (2803, 3, 'LETTNER EVA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 231224, '2011-09-20', 161860.00, 'A'),
    (2804, 3, 'CANUEL LUCIE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 146258, '2011-09-20', 796710.00, 'A'),
    (2805, 3, 'IGLESIAS CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 216125, '2011-08-02', 497980.00, 'A'),
    (2806, 3, 'PAQUIN JEAN FRANCOIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 269033, '2011-03-27', 99760.00, 'A'),
    (2807, 3, 'FOURNIER DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 228688, '2011-05-19', 4860.00, 'A'),
    (2808, 3, 'BILODEAU MARTIN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-13', 725030.00, 'A'),
    (2809, 3, 'KELLNER PETER WILLIAM', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 130757, '2011-07-24', 610570.00, 'A'),
    (2810, 3, 'ZAZULAK INGRID ROSEMARIE', 191821112, 'CRA 25 CALLE 100', '683@facebook.com', '2011-02-03', 240550, '2011-09-11', 877770.00, 'A'),
    (2811, 3, 'RUCCI JHON MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 285188, '2011-05-10', 557130.00, 'A'),
    (2813, 3, 'JONCAS MARC', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 33265, '2011-03-21', 90360.00, 'A'),
    (2814, 3, 'DUCHARME ERICK', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-03-29', 994750.00, 'A'),
    (2816, 3, 'BAILLOD THOMAS DAVID ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 239124, '2010-10-20', 529130.00, 'A'),
    (2817, 3, 'MARTINEZ SORIA JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 289697, '2011-09-06', 537630.00, 'A'),
    (2818, 3, 'TAMARA RABER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-04-30', 100750.00, 'A'),
    (2819, 3, 'BURGI VINCENT EMANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 245206, '2011-04-20', 890860.00, 'A'),
    (282, 1, 'HUESPED ASISTENTE A LA CONVENCION DE LA DIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2009-06-24', 17160.00, 'A'),
    (2820, 3, 'ROBLES TORRALBA IVAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 238949, '2011-05-16', 152030.00, 'A'),
    (2821, 3, 'CONSUEGRA MARIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-06', 87600.00, 'A'),
    (2822, 3, 'CELMA ADROVER LAIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 190393, '2011-03-23', 981880.00, 'A'),
    (2823, 3, 'ALVAREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-06-20', 646610.00, 'A'),
    (2824, 3, 'VARGAS WOODROFFE FRANCISCO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 157414, '2011-06-22', 287410.00, 'A'),
    (2825, 3, 'GARCIA GUILLEN VICENTE LUIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 144215, '2011-08-19', 497230.00, 'A'),
    (2826, 3, 'GOMEZ GARCIA DIAMANTES PATRICIA MARIA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 286785, '2011-09-22', 623930.00, 'A'),
    (2827, 3, 'PEREZ IGLESIAS BIBIANA', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 132958, '2011-09-30', 627940.00, 'A'),
    (2830, 3, 'VILLALONGA MORENES MARIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 169679, '2011-05-29', 474910.00, 'A'),
    (2831, 3, 'REY LOPEZ DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2011-08-03', 7380.00, 'A'),
    (2832, 3, 'HOYO APARICIO JESUS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 116511, '2011-09-19', 612180.00, 'A'),
    (2836, 3, 'GOMEZ GARCIA LOPEZ CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 150699, '2011-09-21', 277540.00, 'A'),
    (2839, 3, 'GALIMERTI MARCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 235197, '2011-08-28', 156870.00, 'A'),
    (2840, 3, 'BAROZZI GIUSEPE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 231989, '2011-05-25', 609500.00, 'A'),
    (2841, 3, 'MARIAN RENATO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-12', 576900.00, 'A'),
    (2842, 3, 'FAENZA CARLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 126180, '2011-05-19', 55990.00, 'A'),
    (2843, 3, 'PESOLILLO CARMINE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 203162, '2011-06-26', 549230.00, 'A'),
    (2844, 3, 'CHIODI FRANCESCO MARIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 199862, '2011-09-10', 578210.00, 'A'),
    (2845, 3, 'RUTA MARIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-06-19', 243350.00, 'A'),
    (2846, 3, 'BAZZONI MARINO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 101518, '2011-05-03', 482140.00, 'A'),
    (2848, 3, 'LAGASIO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 231989, '2011-05-04', 956670.00, 'A'),
    (2849, 3, 'VIERA DA CUNHA PAULO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 190393, '2011-04-05', 741520.00, 'A'),
    (2850, 3, 'DAL BEN DENIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 116511, '2011-05-26', 837590.00, 'A'),
    (2851, 3, 'GIANELLI HERIBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 233927, '2011-05-01', 963400.00, 'A'),
    (2852, 3, 'JUSTINO DA SILVA DJAMIR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-08', 304200.00, 'A'),
    (2853, 3, 'DIPASQUUALE GAETANO', 191821112, 'CRA 25 CALLE 100', '574@terra.com.co', '2011-02-03', 172888, '2011-07-11', 630830.00, 'A'),
    (2855, 3, 'CURI MAURO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 199862, '2011-06-19', 315160.00, 'A'),
    (2856, 3, 'DI DIO MARCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-20', 851210.00, 'A'),
    (2857, 3, 'ROBERTI MENDONCA CAIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-11', 310580.00, 'A'),
    (2859, 3, 'RAMOS MORENO DE SOUZA ANDRE ', 191821112, 'CRA 25 CALLE 100', '133@facebook.com', '2011-02-03', 118777, '2011-09-24', 64540.00, 'A'),
    (286, 8, 'INEXMODA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-06-21', 50150.00, 'A'),
    (2860, 3, 'JODJAHN DE CARVALHO FLAVIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2011-06-27', 324950.00, 'A'),
    (2862, 3, 'LAGASIO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 231989, '2011-07-04', 180760.00, 'A'),
    (2863, 3, 'MOON SUNG RIUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-08', 610440.00, 'A'),
    (2865, 3, 'VAIDYANATHAN VIKRAM', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-11', 718220.00, 'A'),
    (2866, 3, 'NARAYANASWAMY RAMSUNDAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 73079, '2011-10-02', 61390.00, 'A'),
    (2867, 3, 'VADADA VENKATA RAMESH KUMAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-10', 152300.00, 'A'),
    (2868, 3, 'RAMA KRISHNAN ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-10', 577300.00, 'A'),
    (2869, 3, 'JALAN PRASHANT', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 122035, '2011-05-02', 429600.00, 'A'),
    (2871, 3, 'CHANDRASEKAR VENKAT', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 112862, '2011-06-27', 791800.00, 'A'),
    (2872, 3, 'CUMBAKONAM SWAMINATHAN SUBRAMANIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-11', 710650.00, 'A'),
    (288, 8, 'BCD TRAVEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-23', 645390.00, 'A'),
    (289, 3, 'EMBAJADA ARGENTINA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '1970-02-02', 749440.00, 'A'),
    ('CELL3789', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (290, 3, 'EMBAJADA DE BRASIL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-11-16', 811030.00, 'A'),
    (293, 8, 'ONU', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-09-19', 584810.00, 'A'),
    (299, 1, 'BLANDON GUZMAN JHON JAIRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-01-13', 201740.00, 'A'),
    (304, 3, 'COHEN DANIEL DYLAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 286785, '2010-11-17', 184850.00, 'A'),
    (306, 1, 'CINDU ANDINA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2009-06-11', 899230.00, 'A'),
    (31, 1, 'GARRIDO LEONARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127662, '2010-09-12', 801450.00, 'A'),
    (310, 3, 'CORPORACION CLUB EL NOGAL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2010-08-27', 918760.00, 'A'),
    (314, 3, 'CHAWLA AARON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-08', 295840.00, 'A'),
    (317, 3, 'BAKER HUGHES', 191821112, 'CRA 25 CALLE 100', '694@hotmail.com', '2011-02-03', 127591, '2011-04-03', 211990.00, 'A'),
    (32, 1, 'PAEZ SEGURA JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '675@gmail.com', '2011-02-03', 129447, '2011-08-22', 717340.00, 'A'),
    (320, 1, 'MORENO PAEZ FREDDY ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-31', 971670.00, 'A'),
    (322, 1, 'CALDERON CARDOZO GASTON EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-10-05', 990640.00, 'A'),
    (324, 1, 'ARCHILA MERA ALFREDOMANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-06-22', 77200.00, 'A'),
    (326, 1, 'MUNOZ AVILA HERNEY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-11-10', 550920.00, 'A'),
    (327, 1, 'CHAPARRO CUBILLOS FABIAN ANDRES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-15', 685080.00, 'A'),
    (329, 1, 'GOMEZ LOPEZ JUAN SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '970@yahoo.com', '2011-02-03', 127591, '2011-03-20', 808070.00, 'A'),
    (33, 1, 'MARTINEZ MARINO HENRY HERNAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-04-20', 182370.00, 'A'),
    (330, 3, 'MAPSTONE NAOMI LEA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 122035, '2010-02-21', 722380.00, 'A'),
    (332, 3, 'ROSSI BURRI NELLY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132165, '2010-05-10', 771210.00, 'A'),
    (333, 1, 'AVELLANEDA OVIEDO JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-25', 293060.00, 'A'),
    (334, 1, 'SUZA FLOREZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-13', 151650.00, 'A'),
    (335, 1, 'ESGUERRA ALVARO ANDRES', 191821112, 'CRA 25 CALLE 100', '11@facebook.com', '2011-02-03', 127591, '2011-09-10', 879080.00, 'A'),
    (337, 3, 'DE LA HARPE MARTIN CARAPET WALTER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-27', 64960.00, 'A'),
    (339, 1, 'HERNANDEZ ACOSTA SERGIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 129499, '2011-06-22', 322570.00, 'A'),
    (340, 3, 'ZARAMA DE LA ESPRIELLA MIGUEL PATRICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-27', 102360.00, 'A'),
    (342, 1, 'CABRERA VASQUEZ JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-01', 413440.00, 'A'),
    (343, 3, 'RICHARDSON BEN MARRIS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 286785, '2010-05-18', 434890.00, 'A'),
    (344, 1, 'OLARTE PINZON MIGUEL FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-30', 934140.00, 'A'),
    (345, 1, 'SOLER SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2011-04-20', 366020.00, 'A'),
    (346, 1, 'PRIETO JUAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-07-12', 27690.00, 'A'),
    (349, 1, 'BARRERO VELASCO DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-01', 472850.00, 'A'),
    (35, 1, 'VELASQUEZ RAMOS JUAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-13', 251940.00, 'A'),
    (350, 1, 'RANGEL GARCIA SERGIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-03-20', 7880.00, 'A'),
    (353, 1, 'ALVAREZ ACEVEDO JOHN FREDDY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-16', 540070.00, 'A'),
    (354, 1, 'VILLAMARIN HOME WILMAR ALFREDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-19', 458810.00, 'A'),
    (355, 3, 'SLUCHIN NAAMAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 263813, '2010-12-01', 673830.00, 'A'),
    (357, 1, 'BULLA BERNAL LUIS ERNESTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-14', 942160.00, 'A'),
    (358, 1, 'BRACCIA AVILA GIANCARLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-01', 732620.00, 'A'),
    (359, 1, 'RODRIGUEZ PINTO RAUL DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-08-24', 836600.00, 'A'),
    (36, 1, 'MALDONADO ALVAREZ JAIRO ASDRUBAL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127300, '2011-06-19', 980270.00, 'A'),
    (362, 1, 'POMBO POLANCO JUAN BERNARDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-18', 124130.00, 'A'),
    (363, 1, 'CARDENAS SUAREZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127662, '2011-09-01', 372920.00, 'A'),
    (364, 1, 'RIVERA MAZO JOSE DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-06-10', 492220.00, 'A'),
    (365, 1, 'LEDERMAN CORDIKI JONATHAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-12-03', 342340.00, 'A'),
    (367, 1, 'BARRERA MARTINEZ LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '35@yahoo.com.mx', '2011-02-03', 127591, '2011-05-24', 148130.00, 'A'),
    (368, 1, 'SEPULVEDA RAMIREZ DANIEL MARCELO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-31', 35560.00, 'A'),
    (369, 1, 'QUINTERO DIAZ WILSON ASDRUBAL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-07-24', 733430.00, 'A'),
    (37, 1, 'RESTREPO SUAREZ HENRY BERNARDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2011-07-25', 145540.00, 'A'),
    (370, 1, 'ROJAS YARA WILLMAR ARLEY', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-12-03', 560450.00, 'A'),
    (371, 3, 'CARVER LOUISE EMILY', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 286785, '2010-10-07', 601980.00, 'A'),
    (372, 3, 'VINCENT DAVID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 286785, '2011-03-06', 328540.00, 'A'),
    (374, 1, 'GONZALEZ DELGADO MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-08-18', 198260.00, 'A'),
    (375, 1, 'PAEZ SIMON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-06-25', 480970.00, 'A'),
    (376, 1, 'CADOSCH DELMAR ELIE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-10-07', 810080.00, 'A'),
    (377, 1, 'HERRERA VASQUEZ DANIEL EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-06-30', 607460.00, 'A'),
    (378, 1, 'CORREAL ROJAS RONALD', 191821112, 'CRA 25 CALLE 100', '269@facebook.com', '2011-02-03', 127591, '2011-07-16', 607080.00, 'A'),
    (379, 1, 'VOIDONNIKOLAS MUNOS PANAGIOTIS', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-27', 213010.00, 'A'),
    (38, 1, 'CANAL ROJAS MAURICIO HERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-05-29', 786900.00, 'A'),
    (380, 1, 'DIAZ ECHEVERRI JUAN DAVID ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-20', 243800.00, 'A'),
    (381, 1, 'CIFUENTES MARIN HERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-26', 579960.00, 'A'),
    (382, 3, 'PAXTON LUCINDA HARRIET', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 107159, '2011-05-23', 168420.00, 'A'),
    (384, 3, 'POYNTON BRIAN GEORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 286785, '2011-03-20', 5790.00, 'A'),
    (385, 3, 'TERMIGNONI ADRIANO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-01-14', 722320.00, 'A'),
    (386, 3, 'CARDWELL PAULA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-02-17', 594230.00, 'A'),
    (389, 1, 'FONCECA MARTINEZ MIGUEL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-25', 778680.00, 'A'),
    (39, 1, 'GARCIA SUAREZ WILLIAM ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-25', 497880.00, 'A'),
    (390, 1, 'GUERRERO NELSON', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-12-03', 178650.00, 'A'),
    (391, 1, 'VICTORIA PENA FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-22', 557200.00, 'A'),
    (392, 1, 'VAN HISSENHOVEN FERRERO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-13', 250060.00, 'A'),
    (393, 1, 'CACERES ORDUZ JUAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-28', 578690.00, 'A'),
    (394, 1, 'QUINTERO ALVARO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-17', 143270.00, 'A'),
    (395, 1, 'ANZOLA PEREZ CARLOSDAVID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-04', 980300.00, 'A'),
    (397, 1, 'LLOREDA ORTIZ CARLOS JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-27', 417470.00, 'A'),
    (398, 1, 'GONZALES LONDONO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-19', 672310.00, 'A'),
    (4, 1, 'LONDONO DOMINGUEZ ERNESTO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-05', 324610.00, 'A'),
    (40, 1, 'MORENO ANGULO ORLANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-01', 128690.00, 'A'),
    (400, 8, 'TRANSELCA .A', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-04-14', 528930.00, 'A'),
    (403, 1, 'VERGARA MURILLO JUAN FERNANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-03-04', 42900.00, 'A'),
    (405, 1, 'CAPERA CAPERA HARRINSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127799, '2011-06-12', 961000.00, 'A'),
    (407, 1, 'MORENO MORA WILLIAM EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-22', 872780.00, 'A'),
    (408, 1, 'HIGUERA ROA NICOLAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-28', 910430.00, 'A'),
    (409, 1, 'FORERO CASTILLO OSCAR ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '988@terra.com.co', '2011-02-03', 127591, '2011-07-23', 933810.00, 'A'),
    (410, 1, 'LOPEZ MURCIA JULIAN DANIEL', 191821112, 'CRA 25 CALLE 100', '399@facebook.com', '2011-02-03', 127591, '2011-08-08', 937790.00, 'A'),
    (411, 1, 'ALZATE JOHN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-09-09', 887490.00, 'A'),
    (412, 1, 'GONZALES GONZALES ORLANDO ANDREY', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-30', 624080.00, 'A'),
    (413, 1, 'ESCOLANO VALENTIN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-08-05', 457930.00, 'A'),
    (414, 1, 'JARAMILLO RODRIGUEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-12', 417420.00, 'A'),
    (415, 1, 'GARCIA MUNOZ DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-02', 713300.00, 'A'),
    (416, 1, 'PINEROS ARENAS JUAN DAVID', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-10-17', 314260.00, 'A'),
    (417, 1, 'ORTIZ ARROYAVE ANDRES', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-05-21', 431370.00, 'A'),
    (418, 1, 'BAYONA BARRIENTOS JEAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-12', 214090.00, 'A'),
    (419, 1, 'AGUDELO VASQUEZ JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-08-30', 776360.00, 'A'),
    (420, 1, 'CALLE DANIEL CJ PRODUCCIONES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-04', 239500.00, 'A'),
    (422, 1, 'CANO BETANCUR ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-08-20', 623620.00, 'A'),
    (423, 1, 'CALDAS BARRETO LUZ MIREYA', 191821112, 'CRA 25 CALLE 100', '991@facebook.com', '2011-02-03', 127591, '2011-05-22', 512840.00, 'A'),
    (424, 1, 'SIMBAQUEBA JOSE ERNESTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-25', 693320.00, 'A'),
    (425, 1, 'DE SILVESTRE CALERO LUIS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-18', 928110.00, 'A'),
    (426, 1, 'ZORRO PERALTA YEZID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-25', 560560.00, 'A'),
    (428, 1, 'SUAREZ OIDOR DARWIN LEONARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 131272, '2011-09-05', 410650.00, 'A'),
    (429, 1, 'GIRAL CARRILLO LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-04-13', 997850.00, 'A'),
    (43, 1, 'MARULANDA VALENCIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-17', 365550.00, 'A'),
    (430, 1, 'CORDOBA GARCES JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-18', 757320.00, 'A'),
    (431, 1, 'ARIAS TAMAYO DIEGO MAURICIO', 191821112, 'CRA 25 CALLE 100', '36@yahoo.com', '2011-02-03', 127591, '2011-09-05', 793050.00, 'A'),
    (432, 1, 'EICHMANN PERRET MARC WILLY', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-22', 693270.00, 'A'),
    (433, 1, 'DIAZ DANIEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2008-09-18', 87200.00, 'A'),
    (435, 1, 'FACCINI GONZALEZ HERMANN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2009-01-08', 519420.00, 'A'),
    (436, 1, 'URIBE DUQUE FELIPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-28', 528470.00, 'A'),
    (437, 1, 'TAVERA GAONA GABREL LEAL', 191821112, 'CRA 25 CALLE 100', '280@terra.com.co', '2011-02-03', 127591, '2011-04-28', 84120.00, 'A'),
    (438, 1, 'ORDONEZ PARIS FERNANDO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-09-26', 835170.00, 'A'),
    (439, 1, 'VILLEGAS ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-19', 923520.00, 'A'),
    (44, 1, 'MARTINEZ PEDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-08-13', 738750.00, 'A'),
    (440, 1, 'MARTINEZ RUEDA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '805@hotmail.es', '2011-02-03', 127591, '2011-04-07', 112050.00, 'A'),
    (441, 1, 'ROLDAN JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-05-25', 789720.00, 'A'),
    (442, 1, 'PEREZ BRANDWAYN ELIYAU MOISES', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-10-20', 612450.00, 'A'),
    (443, 1, 'VALLEJO TORO JUAN DIEGO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128579, '2011-08-16', 693080.00, 'A'),
    (444, 1, 'TORRES CABRERA EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-03-19', 628070.00, 'A'),
    (445, 1, 'MERINO MEJIA GERMAN ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-28', 61100.00, 'A'),
    (447, 1, 'GOMEZ GOMEZ JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-08', 923070.00, 'A'),
    (448, 1, 'RAUSCH CHEHEBAR STEVEN JOSEPH', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-09-27', 351540.00, 'A'),
    (449, 1, 'RESTREPO TRUCCO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-28', 988500.00, 'A'),
    (45, 1, 'GUTIERREZ JARAMILLO CARLOS MARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 150699, '2011-08-22', 597090.00, 'A'),
    (450, 1, 'GOLDSTEIN VAIDA ELI JACK', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-11', 887860.00, 'A'),
    (451, 1, 'OLEA PINEDA EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-08-10', 473800.00, 'A'),
    (452, 1, 'JORGE OROZCO', 191821112, 'CRA 25 CALLE 100', '503@hotmail.es', '2011-02-03', 127591, '2011-06-02', 705410.00, 'A'),
    (454, 1, 'DE LA TORRE GOMEZ GERMAN ERNESTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-03', 411990.00, 'A'),
    (456, 1, 'MADERO ARIAS JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '452@hotmail.es', '2011-02-03', 127591, '2011-08-22', 479090.00, 'A'),
    (457, 1, 'GOMEZ MACHUCA ALVARO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-08-12', 166430.00, 'A'),
    (458, 1, 'MENDIETA TOBON DANIEL RICARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-08', 394880.00, 'A'),
    (459, 1, 'VILLADIEGO CORTINA JAVIER TOMAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-26', 475110.00, 'A'),
    (46, 1, 'FERRUCHO ARCINIEGAS JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-06', 769220.00, 'A'),
    (460, 1, 'DERESER HARTUNG ERNESTO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-12-25', 190900.00, 'A'),
    (461, 1, 'RAMIREZ PENA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-06-25', 529190.00, 'A'),
    (463, 1, 'IREGUI REYES LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-07', 778590.00, 'A'),
    (464, 1, 'PINTO GOMEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2010-06-24', 673270.00, 'A'),
    (465, 1, 'RAMIREZ RAMIREZ FERNANDO ALONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127799, '2011-10-01', 30570.00, 'A'),
    (466, 1, 'BERRIDO TRUJILLO JORGE HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 132775, '2011-10-06', 133040.00, 'A'),
    (467, 1, 'RIVERA CARVAJAL RAFAEL HUMBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-07-20', 573500.00, 'A'),
    (468, 3, 'FLOREZ PUENTES IVAN ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 145135, '2011-05-08', 468380.00, 'A'),
    (469, 1, 'BALLESTEROS FLOREZ IVAN DARIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-02', 621410.00, 'A'),
    (47, 1, 'MARIN FLOREZ OMAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-30', 54840.00, 'A'),
    (470, 1, 'RODRIGO PENA HERRERA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 237734, '2011-10-04', 701890.00, 'A'),
    (471, 1, 'RODRIGUEZ SILVA ROGELIO', 191821112, 'CRA 25 CALLE 100', '163@gmail.com', '2011-02-03', 127591, '2011-05-26', 645210.00, 'A'),
    (473, 1, 'VASQUEZ VELANDIA JUAN GABRIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 196234, '2011-05-04', 666330.00, 'A'),
    (474, 1, 'ROBLEDO JAIME', 191821112, 'CRA 25 CALLE 100', '409@yahoo.com', '2011-02-03', 127591, '2011-05-31', 970480.00, 'A'),
    (475, 1, 'GRIMBERG DIAZ PHILIP', 191821112, 'CRA 25 CALLE 100', '723@yahoo.com', '2011-02-03', 127591, '2011-03-30', 853430.00, 'A'),
    (476, 1, 'CHAUSTRE GARCIA JUAN PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-26', 355670.00, 'A'),
    (477, 1, 'GOMEZ FLOREZ IGNASIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-09-14', 218090.00, 'A'),
    (478, 1, 'LUIS ALBERTO CABRERA PUENTES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-05-26', 23420.00, 'A'),
    (479, 1, 'MARTINEZ ZAPATA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '234@gmail.com', '2011-02-03', 127122, '2011-07-01', 462840.00, 'A'),
    (48, 1, 'PARRA IBANEZ FABIAN ERNESTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-02-01', 966520.00, 'A'),
    (480, 3, 'WESTERBERG JAN RICKARD', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 300701, '2011-02-01', 243940.00, 'A'),
    (484, 1, 'RODRIGUEZ VILLALOBOS EDGAR FERNANDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-19', 860320.00, 'A'),
    (486, 1, 'NAVARRO REYES DIEGO FELIPE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-01', 530150.00, 'A'),
    (487, 1, 'NOGUERA RICAURTE ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-01-21', 384100.00, 'A'),
    (488, 1, 'RUIZ VEJARANO CARLOS DANIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-09-27', 330030.00, 'A'),
    (489, 1, 'CORREA PEREZ ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-12-14', 497860.00, 'A'),
    (49, 1, 'FLOREZ PEREZ RUBIEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-23', 668090.00, 'A'),
    (490, 1, 'REYES GOMEZ LUIS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-26', 499210.00, 'A'),
    (491, 3, 'BERNAL LEON ALBERTO JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 150699, '2011-03-29', 2470.00, 'A'),
    (492, 1, 'FELIPE JARAMILLO CARO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2009-10-31', 514700.00, 'A'),
    (493, 1, 'GOMEZ PARRA GERMAN DARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-01-29', 566100.00, 'A'),
    (494, 1, 'VALLEJO RAMIREZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-13', 286390.00, 'A'),
    (495, 1, 'DIAZ LONDONO HUGO MARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-06', 733670.00, 'A'),
    (496, 3, 'VAN BAKERGEM RONALD JAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2008-11-05', 809190.00, 'A'),
    (497, 1, 'MENDEZ RAMIREZ JOSE LEONARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-10', 844920.00, 'A'),
    (498, 3, 'QUI TANILLA HENRIQUEZ PAUL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-10', 797030.00, 'A'),
    (499, 3, 'PELEATO FLOREAL', 191821112, 'CRA 25 CALLE 100', '531@hotmail.com', '2011-02-03', 188640, '2011-04-23', 450370.00, 'A'),
    (50, 1, 'SILVA GUZMAN MAURICIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-03-24', 440890.00, 'A'),
    (502, 3, 'LEO ULF GORAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 300701, '2010-07-26', 181840.00, 'A'),
    (503, 3, 'KARLSSON DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 300701, '2011-07-22', 50680.00, 'A'),
    (504, 1, 'JIMENEZ JANER ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '889@hotmail.es', '2011-02-03', 203272, '2011-08-29', 707880.00, 'A'),
    (506, 1, 'PABON OCHOA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-14', 813050.00, 'A'),
    (507, 1, 'ACHURY CADENA CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-26', 903240.00, 'A'),
    (508, 1, 'ECHEVERRY GARZON SEBASTIN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-23', 77050.00, 'A'),
    (509, 1, 'PINEROS PENA LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-07-29', 675550.00, 'A'),
    (51, 1, 'CAICEDO URREA JAIME ORLANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127300, '2011-08-17', 200160.00, 'A'),
    ('CELL3795', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (510, 1, 'MARTINEZ MARTINEZ LUIS EDUARDO', 191821112, 'CRA 25 CALLE 100', '586@facebook.com', '2011-02-03', 127591, '2010-08-28', 146600.00, 'A'),
    (511, 1, 'MOLANO PENA JESUS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-02-05', 706320.00, 'A'),
    (512, 3, 'RUDOLPHY FONTAINE ANDRES', 191821112, 'CRA 25 CALLE 100', '492@yahoo.com', '2011-02-03', 117002, '2011-04-12', 91820.00, 'A'),
    (513, 1, 'NEIRA CHAVARRO JOHN JAIRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-05-12', 340120.00, 'A'),
    (514, 3, 'MENDEZ VILLALOBOS ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 145135, '2011-03-25', 425160.00, 'A'),
    (515, 3, 'HERNANDEZ OLIVA JOSE DE LA CRUZ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 145135, '2011-03-25', 105440.00, 'A'),
    (518, 3, 'JANCO NICOLAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-15', 955830.00, 'A'),
    (52, 1, 'TAPIA MUNOZ JAIRO RICARDO', 191821112, 'CRA 25 CALLE 100', '920@hotmail.es', '2011-02-03', 127591, '2011-10-05', 678130.00, 'A'),
    (520, 1, 'ALVARADO JAVIER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-26', 895550.00, 'A'),
    (521, 1, 'HUERFANO SOTO JONATHAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-30', 619910.00, 'A'),
    (522, 1, 'HUERFANO SOTO JONATHAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-04', 412900.00, 'A'),
    (523, 1, 'RODRIGEZ GOMEZ WILMAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-05-14', 204790.00, 'A'),
    (525, 1, 'ARROYO BAPTISTE DIEGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-04-09', 311810.00, 'A'),
    (526, 1, 'PULECIO BOEK DANIEL', 191821112, 'CRA 25 CALLE 100', '718@gmail.com', '2011-02-03', 127591, '2011-08-12', 203350.00, 'A'),
    (527, 1, 'ESLAVA VELEZ SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-10-08', 81300.00, 'A'),
    (528, 1, 'CASTRO FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-05-06', 796470.00, 'A'),
    (53, 1, 'HINCAPIE MARTINEZ RICARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127573, '2011-09-26', 790180.00, 'A'),
    (530, 1, 'ZORRILLA PUJANA NICOLAS', 191821112, 'CRA 25 CALLE 100', '312@yahoo.es', '2011-02-03', 127591, '2011-06-06', 302750.00, 'A'),
    (531, 1, 'ZORRILLA PUJANA NICOLAS', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-06', 298440.00, 'A'),
    (532, 1, 'PRETEL ARTEAGA MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-09', 583980.00, 'A'),
    (533, 1, 'RAMOS VERGARA HUMBERTO CARLOS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 131105, '2010-05-13', 24560.00, 'A'),
    (534, 1, 'BONILLA PINEROS DIEGO FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-09-20', 370880.00, 'A'),
    (535, 1, 'BELTRAN TRIVINO JULIAN DAVID', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-11-06', 780710.00, 'A'),
    (536, 3, 'BLOD ULF FREDERICK EDWARD', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-06', 790900.00, 'A'),
    (537, 1, 'VANEGAS OROZCO SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-11-10', 612400.00, 'A'),
    (538, 3, 'ORUE VALLE MONICA CECILIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 97885, '2011-09-15', 689270.00, 'A'),
    (539, 1, 'AGUDELO BEDOYA ANDRES JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2011-05-24', 609160.00, 'A'),
    (54, 1, 'DE HOYOS TRESPALACIOS MAURICIO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-04-21', 916500.00, 'A'),
    (540, 3, 'HEIJKENSKJOLD PER JESPER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-04-06', 977980.00, 'A'),
    (541, 3, 'GONZALEZ ALVARADO LUIS RAUL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-08-27', 62430.00, 'A'),
    (543, 1, 'GRUPO SURAMERICA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-08-24', 703760.00, 'A'),
    (545, 1, 'CORPORACION CONTEXTO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-09-08', 809570.00, 'A'),
    (546, 3, 'LUNDIN JOHAN ERIK ', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-29', 895330.00, 'A'),
    (548, 3, 'VEGERANO JOSE ', 191821112, 'CRA 25 CALLE 100', '221@facebook.com', '2011-02-03', 190393, '2011-06-05', 553780.00, 'A'),
    (549, 3, 'SERRANO MADRID CLAUDIA INES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-07-27', 625060.00, 'A'),
    (55, 1, 'TAFUR GOMEZ ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127300, '2010-09-12', 211980.00, 'A'),
    (550, 1, 'MARTINEZ ACEVEDO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-10-06', 463920.00, 'A'),
    (551, 1, 'GONZALEZ MORENO PABLO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-07-21', 444450.00, 'A'),
    (552, 1, 'MEJIA ROJAS ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-08-02', 830470.00, 'A'),
    (553, 3, 'RODRIGUEZ ANTHONY HANSEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-16', 819000.00, 'A'),
    (554, 1, 'ABUCHAIBE ANNICCHRICO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-05-31', 603610.00, 'A'),
    (555, 3, 'MOYES KIMBERLY', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-08', 561020.00, 'A'),
    (556, 3, 'MONTINI MARIO JOSE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118942, '2010-03-16', 994280.00, 'A'),
    (557, 3, 'HOGBERG DANIEL TOBIAS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-06-15', 288350.00, 'A'),
    (559, 1, 'OROZCO PFEIZER MARTIN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-10-07', 429520.00, 'A'),
    (56, 1, 'NARINO ROJAS GABRIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-27', 310390.00, 'A'),
    (560, 1, 'GARCIA MONTOYA ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-06-02', 770840.00, 'A'),
    (562, 1, 'VELASQUEZ PALACIO MANUEL ORLANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-06-23', 515670.00, 'A'),
    (563, 1, 'GALLEGO PEREZ DIEGO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-04-14', 881460.00, 'A'),
    (564, 1, 'RUEDA URREGO JUAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-04', 860270.00, 'A'),
    (565, 1, 'RESTREPO DEL TORO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-10', 656960.00, 'A'),
    (567, 1, 'TORO VALENCIA FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-08-04', 549090.00, 'A'),
    (568, 1, 'VILLEGAS LUIS ALFONSO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-02', 633490.00, 'A'),
    (569, 3, 'RIDSTROM CHRISTER ANDERS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 300701, '2011-09-06', 520150.00, 'A'),
    (57, 1, 'TOVAR ARANGO JOHN JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127662, '2010-07-03', 916010.00, 'A'),
    (570, 3, 'SHEPHERD DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2008-05-11', 700280.00, 'A'),
    (573, 3, 'BENGTSSON JOHAN ANDREAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-06', 196830.00, 'A'),
    (574, 3, 'PERSSON HANS JONAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-09', 172340.00, 'A'),
    (575, 3, 'SYNNEBY BJORN ERIK', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-06-15', 271210.00, 'A'),
    ('CELL381', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (577, 3, 'COHEN PAUL KIRTAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-25', 381490.00, 'A'),
    (578, 3, 'ROMERO BRAVO FERNANDO EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-08-21', 390360.00, 'A'),
    (579, 3, 'GUTHRIE ROBERT DEAN', 191821112, 'CRA 25 CALLE 100', '794@gmail.com', '2011-02-03', 161705, '2010-07-20', 807350.00, 'A'),
    (58, 1, 'TORRES ESCOBAR JAIRO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-06-17', 648860.00, 'A'),
    (580, 3, 'ROCASERMENO MONTENEGRO MARIO JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 139844, '2010-12-01', 865650.00, 'A'),
    (581, 1, 'COCK JORGE EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2011-08-19', 906210.00, 'A'),
    (582, 3, 'REISS ANDREAS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2009-01-31', 934120.00, 'A'),
    (584, 3, 'ECHEVERRIA CASTILLO GERMAN FRANCISCO', 191821112, 'CRA 25 CALLE 100', '982@yahoo.com', '2011-02-03', 139844, '2011-07-20', 957370.00, 'A'),
    (585, 3, 'BRANDT CARLOS GUSTAVO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-10', 931030.00, 'A'),
    (586, 3, 'VEGA NUNEZ GILBERTO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-14', 783010.00, 'A'),
    (587, 1, 'BEJAR MUNOZ JORDI', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 196234, '2010-10-08', 121990.00, 'A'),
    (588, 3, 'WADSO KERSTIN ELIZABETH', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-09-17', 260890.00, 'A'),
    (59, 1, 'RAMOS FORERO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-06-20', 496300.00, 'A'),
    (590, 1, 'RODRIGUEZ BETANCOURT JAVIER AUGUSTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127538, '2011-05-23', 909850.00, 'A'),
    (592, 1, 'ARBOLEDA HALABY RODRIGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 150699, '2009-02-03', 939170.00, 'A'),
    (593, 1, 'CURE CURE CARLOS ALFREDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 150699, '2011-07-11', 494600.00, 'A'),
    (594, 3, 'VIDELA PEREZ OSCAR EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-07-13', 655510.00, 'A'),
    (595, 1, 'GONZALEZ GAVIRIA NESTOR', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2009-09-28', 793760.00, 'A'),
    (596, 3, 'IZQUIERDO DELGADO DIONISIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2009-09-24', 2250.00, 'A'),
    (597, 1, 'MORENO DAIRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127300, '2011-06-14', 629990.00, 'A'),
    (598, 1, 'RESTREPO FERNNDEZ SOTO JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-08-31', 143210.00, 'A'),
    (599, 3, 'YERYES VERGARA MARIA SOLEDAD', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-10-11', 826060.00, 'A'),
    (6, 1, 'GUZMAN ESCOBAR JOSE VICENTE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-10', 26390.00, 'A'),
    (60, 1, 'ELEJALDE ESCOBAR TOMAS ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-11-09', 534910.00, 'A'),
    (601, 1, 'ESCAF ESCAF WILLIAM MIGUEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 150699, '2011-07-26', 25190.00, 'A'),
    (602, 1, 'CEBALLOS ZULUAGA JOSE ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2011-05-03', 23920.00, 'A'),
    (603, 1, 'OLIVELLA GUERRERO RAFAEL ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 134022, '2010-06-23', 44040.00, 'A'),
    (604, 1, 'ESCOBAR GALLO CARLOS HUGO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-09', 148420.00, 'A'),
    (605, 1, 'ESCORCIA RAMIREZ EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128569, '2011-04-01', 609990.00, 'A'),
    (606, 1, 'MELGAREJO MORENO PAULA ANDREA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-05', 604700.00, 'A'),
    (607, 1, 'TOBON CALLE CARLOS GUILLERMO', 191821112, 'CRA 25 CALLE 100', '689@hotmail.es', '2011-02-03', 128662, '2011-03-16', 193510.00, 'A'),
    (608, 3, 'TREVINO NOPHAL SILVANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 110709, '2011-05-27', 153470.00, 'A'),
    (609, 1, 'CARDER VELEZ EDWIN JOHN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-09-04', 186830.00, 'A'),
    (61, 1, 'GASCA DAZA VICTOR HERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-09-09', 185660.00, 'A'),
    (610, 3, 'DAVIS JOHN BRADLEY', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-04-06', 473740.00, 'A'),
    (611, 1, 'BAQUERO SLDARRIAGA ALVARO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-09-15', 808210.00, 'A'),
    (612, 3, 'SERRACIN ARAUZ YANIRA YAMILET', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 131272, '2011-06-09', 619820.00, 'A'),
    (613, 1, 'MORA SOTO ALVARO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-09-20', 674450.00, 'A'),
    (614, 1, 'SUAREZ RODRIGUEZ HERNANDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 145135, '2011-03-29', 512820.00, 'A'),
    (616, 1, 'BAQUERO GARCIA JORGE LUIS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2010-07-14', 165160.00, 'A'),
    (617, 3, 'ABADI MADURO MOISES SIMON', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 131272, '2009-03-31', 203640.00, 'A'),
    (62, 3, 'FLOWER LYNDON BRUCE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 231373, '2011-05-16', 323560.00, 'A'),
    (624, 8, 'OLARTE LEONARDO', 191821112, 'CRA 25 CALLE 100', '6@hotmail.com', '2011-02-03', 127591, '2011-06-03', 219790.00, 'A'),
    (63, 1, 'RUBIO CORTES OSCAR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-04-28', 60830.00, 'A'),
    (630, 5, 'PROEXPORT', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 128662, '2010-08-12', 708320.00, 'A'),
    (632, 8, 'SUPER COFFEE ', 191821112, 'CRA 25 CALLE 100', '792@hotmail.es', '2011-02-03', 127591, '2011-08-30', 306460.00, 'A'),
    (636, 8, 'NOGAL ASESORIAS FINANCIERAS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-04-07', 752150.00, 'A'),
    (64, 1, 'GUERRA MARTINEZ MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-24', 333480.00, 'A'),
    (645, 8, 'GIZ - PROFIS', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-08-31', 566330.00, 'A'),
    (652, 3, 'QBE DEL ISTMO COMPANIA DE REASEGUROS ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-07-14', 932190.00, 'A'),
    (655, 3, 'CORP. CENTRO DE ESTUDIOS DE DERECHO JUSTICIA Y SOCIEDAD', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-05-04', 440370.00, 'A'),
    (659, 3, 'GOOD YEAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2010-09-24', 993830.00, 'A'),
    (660, 3, 'ARCINIEGAS Y VILLAMIZAR', 191821112, 'CRA 25 CALLE 100', '258@yahoo.com', '2011-02-03', 127591, '2010-12-02', 787450.00, 'A'),
    (67, 1, 'LOPEZ HOYOS JUAN DIEGO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127662, '2010-04-13', 665230.00, 'A'),
    (670, 8, 'APPLUS NORCONTROL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2011-09-06', 83210.00, 'A'),
    (672, 3, 'KERLL SEBASTIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 287273, '2010-12-19', 501610.00, 'A'),
    (673, 1, 'RESTREPO MOLINA RAMIRO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 144215, '2010-12-18', 457290.00, 'A'),
    (674, 1, 'PEREZ GIL JOSE IGNACIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-08-18', 781610.00, 'A'),
    ('CELL3840', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (676, 1, 'GARCIA LONDONO FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-23', 336160.00, 'A'),
    (677, 3, 'RIJLAARSDAM KARIN AN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-07-03', 72210.00, 'A'),
    (679, 1, 'LIZCANO MONTEALEGRE ARNULFO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127203, '2011-02-01', 546170.00, 'A'),
    (68, 1, 'MARTINEZ SILVA EDGAR', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-29', 54250.00, 'A'),
    (680, 3, 'OLIVARI MAYER PATRICIA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 122642, '2011-08-01', 673170.00, 'A'),
    (682, 3, 'CHEVALIER FRANCK PIERRE CHARLES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 263813, '2010-12-01', 617280.00, 'A'),
    (683, 3, 'NG WAI WING ', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126909, '2011-06-14', 904310.00, 'A'),
    (684, 3, 'MULLER DOMINGUEZ CARLOS ANDRES', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-05-22', 669700.00, 'A'),
    (685, 3, 'MOSQUEDA DOMNGUEZ ANGEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-04-08', 635580.00, 'A'),
    (686, 3, 'LARREGUI MARIN LEON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-04-08', 168800.00, 'A'),
    (687, 3, 'VARGAS VERGARA ALEJANDRO BRAULIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 159245, '2011-09-14', 937260.00, 'A'),
    (688, 3, 'SKINNER LYNN  CHERYL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-12', 179890.00, 'A'),
    (689, 1, 'URIBE CORREA LEONARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128662, '2010-07-29', 87680.00, 'A'),
    (690, 1, 'TAMAYO JARAMILLO FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 128662, '2010-11-10', 898730.00, 'A'),
    (691, 3, 'MOTABAN DE BORGES PAULA ELENA', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132958, '2010-09-24', 230610.00, 'A'),
    (692, 5, 'FERNANDEZ NALDA JOSE MANUEL ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-06-28', 456850.00, 'A'),
    (693, 1, 'GOMEZ RESTREPO JUAN FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-06-28', 592420.00, 'A'),
    (694, 1, 'CARDENAS TAMAYO JOSE JAIME', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-08-08', 591550.00, 'A'),
    (696, 1, 'RESTREPO ARANGO ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-03-31', 127820.00, 'A'),
    (697, 1, 'ROCABADO PASTRANA ROBERT JAVIER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127443, '2011-08-13', 97600.00, 'A'),
    (698, 3, 'JARVINEN JOONAS JORI KRISTIAN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 196234, '2011-05-29', 104560.00, 'A'),
    (699, 1, 'MORENO PEREZ HERNAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 128662, '2011-08-30', 230000.00, 'A'),
    (7, 1, 'PUYANA RAMOS GUILLERMO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-08-27', 331830.00, 'A'),
    (70, 1, 'GALINDO MANZANO JAVIER FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-31', 214890.00, 'A'),
    (701, 1, 'ROMERO PEREZ ARCESIO JOSE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 132775, '2011-07-13', 491650.00, 'A'),
    (703, 1, 'CHAPARRO AGUDELO LEONARDO VIRGILIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 128662, '2011-05-04', 271320.00, 'A'),
    (704, 5, 'VASQUEZ YANIS MARIA DEL PILAR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-10-13', 508820.00, 'A'),
    (705, 3, 'BARBERO JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 116511, '2010-09-13', 730170.00, 'A'),
    (706, 1, 'CARMONA HERNANDEZ MIGUEL ANGEL', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2010-11-08', 124380.00, 'A'),
    (707, 1, 'PEREZ SUAREZ JORGE ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2011-09-14', 431370.00, 'A'),
    (708, 1, 'ROJAS JORGE MARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 130135, '2011-04-01', 783740.00, 'A'),
    (71, 1, 'DIAZ JUAN PABLO/JULES JAVIER', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-10-01', 247860.00, 'A'),
    (711, 3, 'CATALDO CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 116773, '2011-06-06', 984810.00, 'A'),
    (716, 5, 'MACIAS PIZARRO PATRICIO ', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2011-06-07', 376260.00, 'A'),
    (717, 1, 'RENDON MAYA DAVID ALEXANDER', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 130273, '2010-07-25', 332310.00, 'A'),
    (718, 3, 'DE HILDEBRAND E GRISI FILHO CELSO CLAUDIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-11', 532740.00, 'A'),
    (719, 3, 'ALLIEL FACUSSE JULIO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-06-20', 666800.00, 'A'),
    (72, 1, 'LOPEZ ROJAS VICTOR DANIEL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-07-11', 594640.00, 'A'),
    (720, 3, 'CHEMELLO JIMENEZ GAETANO ALBERTO FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132958, '2010-06-23', 735760.00, 'A'),
    (721, 3, 'GARCIA BEZANILLA RODOLFO EDUARDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 128662, '2010-04-12', 678420.00, 'A'),
    (722, 1, 'ARIAS EDWIN', 191821112, 'CRA 25 CALLE 100', '13@terra.com.co', '2011-02-03', 127492, '2008-04-24', 184800.00, 'A'),
    (723, 3, 'SOHN JANG WON', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-07', 888750.00, 'A'),
    (724, 3, 'WILHELM GIOVINE JAIME ROBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 115263, '2011-09-20', 889340.00, 'A'),
    (726, 3, 'CASTILLERO DANIA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 131272, '2011-05-13', 234270.00, 'A'),
    (727, 3, 'PORTUGAL LANGHORST MAX GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-03-13', 829960.00, 'A'),
    (729, 3, 'ALFONSO HERRANZ AGUSTIN ALFONSO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-07-21', 745060.00, 'A'),
    (73, 1, 'DAVILA MENDEZ OSCAR DIEGO', 191821112, 'CRA 25 CALLE 100', '991@yahoo.com.mx', '2011-02-03', 128569, '2011-08-31', 229630.00, 'A'),
    (730, 3, 'ALFONSO HERRANZ AGUSTIN CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2010-03-31', 384360.00, 'A'),
    (731, 1, 'NOGUERA RAMIREZ CARLOS ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-07-14', 686610.00, 'A'),
    (732, 1, 'ACOSTA PERALTA FABIAN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 134030, '2011-06-21', 279960.00, 'A'),
    (733, 3, 'MAC LEAN PINA PEDRO SEGUNDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-05-23', 339980.00, 'A'),
    (734, 1, 'LEON ARCOS ALEX', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-05-04', 860020.00, 'A'),
    (736, 3, 'LAMARCA GARCIA GERMAN JULIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-04-29', 820700.00, 'A'),
    (737, 1, 'PORTO VELASQUEZ LUIS MIGUEL', 191821112, 'CRA 25 CALLE 100', '321@hotmail.es', '2011-02-03', 133535, '2011-08-17', 263060.00, 'A'),
    (738, 1, 'BUENAVENTURA MEDINA ERICK WILSON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2011-09-18', 853180.00, 'A'),
    (739, 1, 'LEVY ARRAZOLA RALPH MARC', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2011-09-27', 476720.00, 'A'),
    (74, 1, 'RAMIREZ SORA EDISON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-03', 364220.00, 'A'),
    (740, 3, 'MOON HYUNSIK ', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 173192, '2011-05-15', 824080.00, 'A'),
    (741, 3, 'LHUILLIER TRONCOSO GASTON MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-09-07', 690230.00, 'A'),
    (742, 3, 'UNDURRAGA PELLEGRINI GONZALO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 117002, '2010-11-21', 978900.00, 'A'),
    (743, 1, 'SOLANO TRIBIN NICOLAS SIMON', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 134022, '2011-03-16', 823800.00, 'A'),
    (744, 1, 'NOGUERA BENAVIDES JACOBO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2010-10-06', 182300.00, 'A'),
    (745, 1, 'GARCIA LEON MARCO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2008-04-16', 440110.00, 'A'),
    (746, 1, 'EMILIANI ROJAS ALEXANDER ALFONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-09-12', 653640.00, 'A'),
    (748, 1, 'CARRENO POULSEN HELGEN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-05-06', 778370.00, 'A'),
    (749, 1, 'ALVARADO FANDINO ANDRES EDUARDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2008-11-05', 48280.00, 'A'),
    (750, 1, 'DIAZ GRANADOS JUAN PABLO.', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-01-12', 906290.00, 'A'),
    (751, 1, 'OVALLE BETANCOURT ALBERTO JOSE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 134022, '2011-08-14', 386620.00, 'A'),
    (752, 3, 'GUTIERREZ VERGARA JOSE MIGUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-05-08', 214250.00, 'A'),
    (753, 3, 'CHAPARRO GUAIMARAL LIZ', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 147467, '2011-03-16', 911350.00, 'A'),
    (754, 3, 'CORTES DE SOLMINIHAC PABLO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117002, '2011-01-20', 914020.00, 'A'),
    (755, 3, 'CHETAIL VINCENT', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 239124, '2010-08-23', 836050.00, 'A'),
    (756, 3, 'PERUGORRIA RODRIGUEZ JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2010-10-17', 438210.00, 'A'),
    (757, 3, 'GOLLMANN ROBERTO JUAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 167269, '2011-03-28', 682870.00, 'A'),
    (758, 3, 'VARELA SEPULVEDA MARIA PILAR', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 118777, '2010-07-26', 99730.00, 'A'),
    (759, 3, 'MEYER WELIKSON MICHELE JANIK', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-05-10', 450030.00, 'A'),
    (76, 1, 'VANEGAS RODRIGUEZ OSCAR IVAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-06-20', 568310.00, 'A'),
    (77, 3, 'GATICA SOTOMAYOR MAURICIO VICENTE', 191821112, 'CRA 25 CALLE 100', '409@terra.com.co', '2011-02-03', 117002, '2010-05-13', 444970.00, 'A'),
    (79, 1, 'PENA VALENZUELA DANIEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-19', 264790.00, 'A'),
    (8, 1, 'NAVARRO PALENCIA HUGO RAFAEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 126968, '2011-05-05', 579980.00, 'A'),
    (80, 1, 'BARRIOS CUADRADO DAVID', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-07-29', 764140.00, 'A'),
    (802, 3, 'RECK GARRONE', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118942, '2009-02-06', 767700.00, 'A'),
    (81, 1, 'PARRA QUIROGA JOSE ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-18', 26330.00, 'A'),
    (811, 8, 'FEDERACION NACIONAL DE AVICULTORES ', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-04-18', 926010.00, 'A'),
    (812, 1, 'ORJUELA VELEZ JAIME ALFONSO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-06-22', 257160.00, 'A'),
    (813, 1, 'PENA CHACON GUSTAVO ADOLFO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2011-08-27', 507770.00, 'A'),
    (814, 1, 'RONDEROS MOJICA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127443, '2011-05-04', 767370.00, 'A'),
    (815, 1, 'RICO NINO MARIO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127443, '2011-05-18', 313540.00, 'A'),
    (817, 3, 'AVILA CHYTIL MANUEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 118471, '2011-07-14', 387300.00, 'A'),
    (818, 3, 'JABLONSKI DUARTE SILVEIRA ESTER', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 118942, '2010-12-21', 139740.00, 'A'),
    (819, 3, 'BUHLER MOSLER XIMENA ALEJANDRA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-06-20', 536830.00, 'A'),
    (82, 1, 'CARRILLO GAMBOA JUAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-06-01', 839240.00, 'A'),
    (820, 3, 'FALQUETO DALMIRO ANGELO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-06-21', 264910.00, 'A'),
    (821, 1, 'RUGER GUSTAVO RODRIGUEZ TAMAYO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2010-04-12', 714080.00, 'A'),
    (822, 3, 'JULIO RODRIGUEZ FRANCISCO JAVIER', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 117002, '2011-08-16', 775650.00, 'A'),
    (823, 3, 'CIBANIK RODOLFO MOISES', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132554, '2011-09-19', 736020.00, 'A'),
    (824, 3, 'JIMENEZ FRANCO EMMANUEL ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-03-17', 353150.00, 'A'),
    (825, 3, 'GNECCO TREMEDAD', 191821112, 'CRA 25 CALLE 100', '818@hotmail.com', '2011-02-03', 171072, '2011-03-19', 557700.00, 'A'),
    (826, 3, 'VILAR MENDOZA JOSE RAFAEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-29', 729050.00, 'A'),
    (827, 3, 'GONZALEZ MOLINA CRISTIAN MAURICIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-06-20', 972160.00, 'A'),
    (828, 1, 'GONTOVNIK HOBRECKT CARLOS DANIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-08-02', 673620.00, 'A'),
    (829, 3, 'DIBARRAT URZUA SEBASTIAN RAIMUNDO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-28', 451650.00, 'A'),
    (830, 3, 'STOCCHERO HATSCHBACH GUILHERME', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 118777, '2010-11-22', 237370.00, 'A'),
    (831, 1, 'NAVAS PASSOS NARCISO EVELIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-04-21', 831900.00, 'A'),
    (832, 3, 'LUNA SOBENES FAVIAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-10-11', 447400.00, 'A'),
    (833, 3, 'NUNEZ NOGUEIRA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 188640, '2011-03-19', 741290.00, 'A'),
    (834, 1, 'CASTRO BELTRAN ARIEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 128188, '2011-05-15', 364270.00, 'A'),
    (835, 1, 'TURBAY YAMIN MAURICIO JOSE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 188640, '2011-03-17', 597490.00, 'A'),
    (836, 1, 'GOMEZ BARRAZA RODNEY LORENZO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-10-07', 894610.00, 'A'),
    (837, 1, 'CUELLO LASCANO ROBERTO', 191821112, 'CRA 25 CALLE 100', '221@hotmail.es', '2011-02-03', 133535, '2011-07-11', 680610.00, 'A'),
    (838, 1, 'PATERNINA PEINADO JOSE VICENTE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 133535, '2011-08-23', 719190.00, 'A'),
    (839, 1, 'YEPES RUBIANO ALFONSO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-05-16', 554130.00, 'A'),
    (84, 1, 'ALVIS RAMIREZ ALFREDO', 191821112, 'CRA 25 CALLE 100', '292@yahoo.com', '2011-02-03', 127662, '2011-09-16', 68190.00, 'A'),
    (840, 1, 'ROCA LLANOS GUILLERMO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-08-22', 613060.00, 'A'),
    (841, 1, 'RENDON TORRALVO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2011-05-26', 402950.00, 'A'),
    (842, 1, 'BLANCO STAND GERMAN ELIECER', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-07-17', 175530.00, 'A'),
    (843, 3, 'BERNAL MAYRA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 131272, '2010-08-31', 668820.00, 'A'),
    (844, 1, 'NAVARRO RUIZ LAZARO GREGORIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 126916, '2008-09-23', 817520.00, 'A'),
    (846, 3, 'TUOMINEN OLLI PETTERI', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2010-09-01', 953150.00, 'A'),
    (847, 1, 'ESPARRAGOZA DE LA ESPRIELLA ENRIQUE ALBERTO ', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 133535, '2011-08-09', 522340.00, 'A'),
    (848, 3, 'ARAYA ARIAS JUAN VICENTE', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 132165, '2011-08-09', 752210.00, 'A'),
    (85, 1, 'GARCIA JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-03-01', 989420.00, 'A'),
    (850, 1, 'PARDO GOMEZ GERMAN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2010-11-25', 713690.00, 'A'),
    (851, 1, 'ATIQUE JOSE MANUEL', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2008-03-03', 986250.00, 'A'),
    (852, 1, 'HERNANDEZ MEYER EDGARDO DE JESUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-07-20', 790190.00, 'A'),
    (853, 1, 'ZULUAGA DE LEON IVAN JESUS', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-07-03', 992210.00, 'A'),
    (854, 1, 'VILLARREAL ANGULO ENRIQUE ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 133535, '2011-10-02', 590450.00, 'A'),
    (855, 1, 'CELIA MARTINEZ APARICIO GIAN PIERO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 133535, '2011-06-15', 975620.00, 'A'),
    (857, 3, 'LIPARI RONALDO LUIS', 191821112, 'CRA 25 CALLE 100', '84@facebook.com', '2011-02-03', 118941, '2010-10-13', 606990.00, 'A'),
    (858, 1, 'RAVACHI DAVILA ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2011-05-04', 714620.00, 'A'),
    (859, 3, 'PINHEIRO OLIVEIRA LUCIANO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-04-06', 752130.00, 'A'),
    (86, 1, 'GOMEZ LIS CARLOS EMILIO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2009-12-22', 742520.00, 'A'),
    (860, 1, 'PUGLIESE MERCADO LUIGGI ALBERTO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-08-19', 616780.00, 'A'),
    (862, 1, 'JANNA TELLO DANIEL JALIL', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 133535, '2010-08-07', 287220.00, 'A'),
    (863, 3, 'MATTAR CARLOS HENRIQUE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2009-04-26', 953570.00, 'A'),
    (864, 1, 'MOLINA OLIER OSVALDO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132775, '2011-04-18', 906200.00, 'A'),
    (865, 1, 'BLANCO MCLIN DAVID ALBERTO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2010-08-18', 670290.00, 'A'),
    (866, 1, 'NARANJO ROMERO ALFREDO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 133535, '2010-08-25', 632860.00, 'A'),
    (867, 1, 'SIMANCAS TRUJILLO RICARDO ANTONIO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-04-07', 153400.00, 'A'),
    (868, 1, 'ARENAS USME GERMAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 126881, '2011-10-01', 868430.00, 'A'),
    (869, 5, 'DIAZ CORDERO RODRIGO FERNANDO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-11-04', 881950.00, 'A'),
    (87, 1, 'CELIS PEREZ HERNANDO ALONSO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-10-05', 744330.00, 'A'),
    (870, 3, 'BINDER ZBEDA JONATAHAN JANAN', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 131083, '2010-04-11', 804460.00, 'A'),
    (871, 1, 'HINCAPIE HELLMAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2010-09-15', 376440.00, 'A'),
    (872, 3, 'MONTEIRO LANAMAR ALFONSO DE BUSTAMANTE', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 118942, '2009-03-23', 468820.00, 'A'),
    (873, 3, 'AGUDO CARMINATTI REGINA CELIA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2011-01-04', 214770.00, 'A'),
    (874, 1, 'GONZALEZ VILLALOBOS CRISTIAN MANUEL', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 133535, '2011-09-26', 667400.00, 'A'),
    (875, 3, 'GUELL VILLANUEVA ALVARO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2008-04-07', 692670.00, 'A'),
    (876, 3, 'GRES ANAIS ROBERTO ANDRES', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2010-12-01', 461180.00, 'A'),
    (877, 3, 'GAME MOCOCAIN JUAN ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-08-07', 227890.00, 'A'),
    (878, 1, 'FERRER UCROS FERNANDO LEON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-06-22', 755900.00, 'A'),
    (879, 3, 'HERRERA JAUREGUI CARLOS GUSTAVO', 191821112, 'CRA 25 CALLE 100', '599@facebook.com', '2011-02-03', 131272, '2010-07-22', 95840.00, 'A'),
    (880, 3, 'BACALLAO HERNANDEZ ANTONIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 126180, '2010-04-21', 211480.00, 'A'),
    (881, 1, 'GIJON URBINA JAIME', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 144879, '2011-04-03', 769910.00, 'A'),
    (882, 3, 'TRUSEN CHRISTOPH WOLFGANG', 191821112, 'CRA 25 CALLE 100', '338@yahoo.com.mx', '2011-02-03', 127591, '2010-10-24', 215100.00, 'A'),
    (883, 3, 'ASHOURI ASKANDAR', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 157861, '2009-03-03', 765760.00, 'A'),
    (885, 1, 'ALTAMAR WATTS JAIRO ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-08-20', 620170.00, 'A'),
    (887, 3, 'QUINTANA BALTIERRA ROBERTO ALEX', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 117002, '2011-06-21', 891370.00, 'A'),
    (889, 1, 'CARILLO PATINO VICTOR HILARIO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 130226, '2011-09-06', 354570.00, 'A'),
    (89, 1, 'CONTRERAS PULIDO LINA MARIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-08-06', 237480.00, 'A'),
    (890, 1, 'GELVES CANAS GENARO ALBERTO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-04-02', 355640.00, 'A'),
    (891, 3, 'CAGNONI DE MELO PAULA CRISTINA', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 118777, '2010-12-14', 714490.00, 'A'),
    (892, 3, 'MENA AMESTICA PATRICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2011-03-22', 505510.00, 'A'),
    (893, 1, 'CAICEDO ROMES', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-04-07', 384110.00, 'A'),
    (894, 1, 'ECHEVERRY TRUJILLO ARMANDO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-06-08', 404010.00, 'A'),
    (895, 1, 'CAJIA PEDRAZA ANTONIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2011-09-02', 867700.00, 'A'),
    (896, 2, 'PALACIOS OLIVA ANDRES FELIPE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 117002, '2011-05-24', 126500.00, 'A'),
    (897, 1, 'GUTIERREZ QUINTERO FABIAN ESTEBAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2009-10-24', 29380.00, 'A'),
    (899, 3, 'COBO GUEVARA LUIS FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-12-09', 748860.00, 'A'),
    (9, 1, 'OSORIO RODRIGUEZ FELIPE', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2010-09-27', 904420.00, 'A'),
    (90, 1, 'LEYTON GONZALEZ FREDY RAFAEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-03-24', 705130.00, 'A'),
    (901, 1, 'HERNANDEZ JOSE ANGEL', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 130266, '2011-05-23', 964010.00, 'A'),
    (903, 3, 'GONZALEZ MALDONADO MAURICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 117002, '2010-11-13', 576500.00, 'A'),
    (904, 1, 'OCHOA BARRIGA JORGE', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 130266, '2011-05-05', 401380.00, 'A'),
    ('CELL3886', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    (905, 1, 'OSORIO REDONDO JESUS DAVID', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127300, '2011-08-11', 277390.00, 'A'),
    (906, 1, 'BAYONA BARRIENTOS JEAN CARLOS', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-01-25', 182820.00, 'A'),
    (907, 1, 'MARTINEZ GOMEZ CARLOS ENRIQUE', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2010-03-11', 81940.00, 'A'),
    (908, 1, 'PUELLO LOPEZ GUILLERMO LEON', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 133535, '2011-08-12', 861240.00, 'A'),
    (909, 1, 'MOGOLLON LONDONO PEDRO LUIS CARLOS', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 132775, '2011-06-22', 60380.00, 'A'),
    (91, 1, 'ORTIZ RIOS JAVIER ADOLFO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127591, '2011-05-12', 813200.00, 'A'),
    (911, 1, 'HERRERA HOYOS CARLOS FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 132775, '2010-09-12', 409800.00, 'A'),
    (912, 3, 'RIM MYUNG HWAN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-05-15', 894450.00, 'A'),
    (913, 3, 'BIANCO DORIEN', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-29', 242820.00, 'A'),
    (914, 3, 'FROIMZON WIEN DANIEL', 191821112, 'CRA 25 CALLE 100', '348@yahoo.com', '2011-02-03', 132165, '2010-11-06', 530780.00, 'A'),
    (915, 3, 'ALVEZ AZEVEDO JOAO MIGUEL', 191821112, 'CRA 25 CALLE 100', '861@hotmail.es', '2011-02-03', 127591, '2009-06-25', 925420.00, 'A'),
    (916, 3, 'CARRASCO DIAZ LUIS ANTONIO', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 127591, '2011-10-02', 34780.00, 'A'),
    (917, 3, 'VIVALLOS MEDINA LEONEL EDMUNDO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2010-09-12', 397640.00, 'A'),
    (919, 3, 'LASSE ANDRE BARKLIEN', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 286724, '2011-03-31', 226390.00, 'A'),
    (92, 1, 'CUERVO CARDENAS ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-09-08', 950630.00, 'A'),
    (920, 3, 'BARCELOS PLOTEGHER LILIA MARA', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127591, '2011-08-07', 480380.00, 'A'),
    (921, 1, 'JARAMILLO ARANGO JUAN DIEGO', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 127559, '2011-06-28', 722700.00, 'A'),
    (93, 3, 'RUIZ PRIETO WILLIAM', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 131272, '2011-01-19', 313540.00, 'A'),
    (932, 7, 'COMFENALCO ANTIOQUIA', 191821112, 'CRA 25 CALLE 100', '@facebook.com', '2011-02-03', 128662, '2011-05-05', 515430.00, 'A'),
    (94, 1, 'GALLEGO JUAN GUILLERMO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-06-25', 715830.00, 'A'),
    (944, 3, 'KARMELIC PAVLOV VESNA', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 120066, '2010-08-07', 585580.00, 'A'),
    (945, 3, 'RAMIREZ BORDON OSCAR', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 128662, '2010-07-02', 526250.00, 'A'),
    (946, 3, 'SORACCO CABEZA RODRIGO ANDRES', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 117002, '2011-07-04', 874490.00, 'A'),
    (949, 1, 'GALINDO JORGE ERNESTO', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 127300, '2008-07-10', 344110.00, 'A'),
    (950, 3, 'DR KNABLE THOMAS ERNST ALBERT', 191821112, 'CRA 25 CALLE 100', '@terra.com.co', '2011-02-03', 256231, '2009-11-17', 685430.00, 'A'),
    (953, 3, 'VELASQUEZ JANETH', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-20', 404650.00, 'A'),
    (954, 3, 'SOZA REX JOSE FRANCISCO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 150903, '2011-05-26', 269790.00, 'A'),
    (955, 3, 'FONTANA GAETE JAIME PATRICIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 117002, '2011-01-11', 134970.00, 'A'),
    (957, 3, 'PEREZ MARTINEZ GRECIA INDIRA', 191821112, 'CRA 25 CALLE 100', '@hotmail.es', '2011-02-03', 132958, '2010-08-27', 922610.00, 'A'),
    (96, 1, 'FORERO CUBILLOS JORGEARTURO', 191821112, 'CRA 25 CALLE 100', '@hotmail.com', '2011-02-03', 127591, '2011-07-25', 45020.00, 'A'),
    (97, 1, 'SILVA ACOSTA MARIO', 191821112, 'CRA 25 CALLE 100', '@yahoo.es', '2011-02-03', 127591, '2011-09-19', 309580.00, 'A'),
    (978, 3, 'BLUMENTHAL JAIRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 117630, '2010-04-22', 653490.00, 'A'),
    (984, 3, 'SUN XIAN', 191821112, 'CRA 25 CALLE 100', '@yahoo.com.mx', '2011-02-03', 127591, '2011-01-17', 203630.00, 'A'),
    (99, 1, 'CANO GUZMAN ALEJANDRO', 191821112, 'CRA 25 CALLE 100', '@gmail.com', '2011-02-03', 127591, '2011-08-23', 135620.00, 'A'),
    (999, 1, 'DRAGER', 191821112, 'CRA 25 CALLE 100', '@yahoo.com', '2011-02-03', 127591, '2010-12-22', 882070.00, 'A'),
    ('CELL1020', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1021', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1083', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1153', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1179', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1183', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL126', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1326', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1329', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL133', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1413', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1426', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1529', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1614', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1651', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1760', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL179', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1857', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1879', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1902', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1921', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1962', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1992', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2006', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL206', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL215', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2187', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2307', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2322', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2497', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2641', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2736', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2805', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL281', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2905', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2963', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3029', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3090', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3161', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3302', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3309', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3325', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3372', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3422', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3514', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3562', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3614', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3652', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL3661', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4334', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4415', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4440', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4547', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4639', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4662', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4698', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL475', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4790', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4838', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4885', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL4939', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5064', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5066', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL51', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5102', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5116', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5187', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5192', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5206', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5226', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5250', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5282', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL536', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5401', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5415', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5503', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5506', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL554', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5544', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5595', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5648', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5801', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5821', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6179', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6201', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6277', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6288', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6358', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6369', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6408', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6418', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6425', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6439', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6509', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6533', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6556', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL673', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6731', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6766', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6775', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6802', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6834', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6842', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6890', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6953', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6957', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7024', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7198', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7216', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL728', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7314', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7316', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7418', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7431', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7432', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7513', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7522', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7617', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7623', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7708', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7777', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL787', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7907', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7951', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7956', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8004', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8058', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL811', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8136', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8162', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8187', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8286', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8300', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8316', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8339', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8366', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8389', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8446', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8487', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8546', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8578', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8643', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8774', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8829', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8846', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL8942', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9046', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9110', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL917', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9189', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9206', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9241', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9331', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9429', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9434', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9495', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9517', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9558', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9650', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9748', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9830', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9842', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9878', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9893', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9945', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('T-Cx200', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx201', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx202', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx203', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx204', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx205', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx206', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx207', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx208', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx209', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx210', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx211', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx212', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx213', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('T-Cx214', 1, 'LOST LOST', '1', NULL, NULL, NULL, NULL, NULL, 0.00, 'A'),
    ('CELL4021', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5255', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5730', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2540', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7376', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2614', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL5471', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2588', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL570', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2854', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL6683', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL1382', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL2051', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL7086', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9220', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A'),
    ('CELL9701', 1, 'LOST', '1', NULL, NULL, NULL, NULL, NULL, 20000.00, 'A');

--
-- Data for Name: robots; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO robots (id, name, type, year, datetime, text) VALUES
    (1, 'Robotina', 'mechanical', 1972, '1972-01-01 00:00:00', 'text'),
    (2, 'Astro Boy', 'mechanical', 1952, '1952-01-01 00:00:00', 'text'),
    (3, 'Terminator', 'cyborg', 2029, '2029-01-01 00:00:00', 'text');

--
-- Data for Name: robots_parts; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO robots_parts (id, robots_id, parts_id) VALUES
    (1, 1, 1),
    (2, 1, 2),
    (3, 1, 3);

--
-- Data for Name: subscriptores; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO subscriptores (id, email, created_at, status) VALUES
    (43, 'fuego@hotmail.com', '2012-04-14 23:30:33', 'P');

--
-- Data for Name: tipo_documento; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO tipo_documento (id, detalle) VALUES
    (1, 'TIPO'),
    (2, 'TIPO'),
    (3, 'TIPO'),
    (4, 'TIPO'),
    (5, 'TIPO'),
    (6, 'TIPO'),
    (7, 'TIPO'),
    (8, 'TIPO'),
    (9, 'TIPO'),
    (10, 'TIPO'),
    (11, 'TIPO'),
    (12, 'TIPO'),
    (13, 'TIPO'),
    (14, 'TIPO'),
    (15, 'TIPO'),
    (16, 'TIPO'),
    (17, 'TIPO'),
    (18, 'TIPO'),
    (19, 'TIPO'),
    (20, 'TIPO'),
    (21, 'TIPO'),
    (22, 'TIPO'),
    (23, 'TIPO'),
    (24, 'TIPO'),
    (25, 'TIPO'),
    (26, 'TIPO'),
    (27, 'TIPO'),
    (28, 'TIPO'),
    (29, 'TIPO'),
    (30, 'TIPO'),
    (31, 'TIPO'),
    (32, 'TIPO'),
    (33, 'TIPO'),
    (34, 'TIPO'),
    (35, 'TIPO'),
    (36, 'TIPO'),
    (37, 'TIPO'),
    (38, 'TIPO'),
    (39, 'TIPO'),
    (40, 'TIPO'),
    (41, 'TIPO'),
    (42, 'TIPO'),
    (43, 'TIPO'),
    (44, 'TIPO'),
    (45, 'TIPO'),
    (46, 'TIPO'),
    (47, 'TIPO'),
    (48, 'TIPO'),
    (49, 'TIPO'),
    (50, 'TIPO'),
    (51, 'TIPO'),
    (52, 'TIPO'),
    (53, 'TIPO'),
    (54, 'TIPO'),
    (55, 'TIPO'),
    (56, 'TIPO'),
    (57, 'TIPO'),
    (58, 'TIPO'),
    (59, 'TIPO'),
    (60, 'TIPO'),
    (61, 'TIPO'),
    (62, 'TIPO'),
    (63, 'TIPO'),
    (64, 'TIPO'),
    (65, 'TIPO'),
    (66, 'TIPO'),
    (67, 'TIPO'),
    (68, 'TIPO'),
    (69, 'TIPO'),
    (70, 'TIPO'),
    (71, 'TIPO'),
    (72, 'TIPO'),
    (73, 'TIPO'),
    (74, 'TIPO'),
    (75, 'TIPO'),
    (76, 'TIPO'),
    (77, 'TIPO'),
    (78, 'TIPO'),
    (79, 'TIPO'),
    (80, 'TIPO'),
    (81, 'TIPO'),
    (82, 'TIPO'),
    (83, 'TIPO'),
    (84, 'TIPO'),
    (85, 'TIPO'),
    (86, 'TIPO'),
    (87, 'TIPO'),
    (88, 'TIPO'),
    (89, 'TIPO'),
    (90, 'TIPO'),
    (91, 'TIPO'),
    (92, 'TIPO'),
    (93, 'TIPO'),
    (94, 'TIPO'),
    (95, 'TIPO'),
    (96, 'TIPO'),
    (97, 'TIPO'),
    (98, 'TIPO'),
    (99, 'TIPO'),
    (100, 'TIPO'),
    (101, 'TIPO'),
    (102, 'TIPO'),
    (103, 'TIPO'),
    (104, 'TIPO'),
    (105, 'TIPO'),
    (106, 'TIPO'),
    (107, 'TIPO'),
    (108, 'TIPO'),
    (109, 'TIPO'),
    (110, 'TIPO'),
    (111, 'TIPO'),
    (112, 'TIPO'),
    (113, 'TIPO'),
    (114, 'TIPO'),
    (115, 'TIPO'),
    (116, 'TIPO'),
    (117, 'TIPO'),
    (118, 'TIPO'),
    (119, 'TIPO'),
    (120, 'TIPO'),
    (121, 'TIPO'),
    (122, 'TIPO'),
    (123, 'TIPO'),
    (124, 'TIPO'),
    (125, 'TIPO'),
    (126, 'TIPO'),
    (127, 'TIPO'),
    (128, 'TIPO'),
    (129, 'TIPO'),
    (130, 'TIPO'),
    (131, 'TIPO'),
    (132, 'TIPO'),
    (133, 'TIPO'),
    (134, 'TIPO'),
    (135, 'TIPO'),
    (136, 'TIPO'),
    (137, 'TIPO'),
    (138, 'TIPO'),
    (139, 'TIPO'),
    (140, 'TIPO'),
    (141, 'TIPO'),
    (142, 'TIPO'),
    (143, 'TIPO'),
    (144, 'TIPO'),
    (145, 'TIPO'),
    (146, 'TIPO'),
    (147, 'TIPO'),
    (148, 'TIPO'),
    (149, 'TIPO'),
    (150, 'TIPO'),
    (151, 'TIPO'),
    (152, 'TIPO'),
    (153, 'TIPO'),
    (154, 'TIPO'),
    (155, 'TIPO'),
    (156, 'TIPO'),
    (157, 'TIPO'),
    (158, 'TIPO'),
    (159, 'TIPO'),
    (160, 'TIPO'),
    (161, 'TIPO'),
    (162, 'TIPO'),
    (163, 'TIPO'),
    (164, 'TIPO'),
    (165, 'TIPO'),
    (166, 'TIPO'),
    (167, 'TIPO'),
    (168, 'TIPO'),
    (169, 'TIPO'),
    (170, 'TIPO'),
    (171, 'TIPO'),
    (172, 'TIPO'),
    (173, 'TIPO'),
    (174, 'TIPO'),
    (175, 'TIPO'),
    (176, 'TIPO'),
    (177, 'TIPO'),
    (178, 'TIPO'),
    (179, 'TIPO'),
    (180, 'TIPO'),
    (181, 'TIPO'),
    (182, 'TIPO'),
    (183, 'TIPO'),
    (184, 'TIPO'),
    (185, 'TIPO'),
    (186, 'TIPO'),
    (187, 'TIPO'),
    (188, 'TIPO'),
    (189, 'TIPO'),
    (190, 'TIPO'),
    (191, 'TIPO'),
    (192, 'TIPO'),
    (193, 'TIPO'),
    (194, 'TIPO'),
    (195, 'TIPO'),
    (196, 'TIPO'),
    (197, 'TIPO'),
    (198, 'TIPO'),
    (199, 'TIPO'),
    (200, 'TIPO'),
    (201, 'TIPO'),
    (202, 'TIPO'),
    (203, 'TIPO'),
    (204, 'TIPO'),
    (205, 'TIPO'),
    (206, 'TIPO'),
    (207, 'TIPO'),
    (208, 'TIPO'),
    (209, 'TIPO'),
    (210, 'TIPO'),
    (211, 'TIPO'),
    (212, 'TIPO'),
    (213, 'TIPO'),
    (214, 'TIPO'),
    (215, 'TIPO'),
    (216, 'TIPO'),
    (217, 'TIPO'),
    (218, 'TIPO'),
    (219, 'TIPO'),
    (220, 'TIPO'),
    (221, 'TIPO'),
    (222, 'TIPO'),
    (223, 'TIPO'),
    (224, 'TIPO'),
    (225, 'TIPO'),
    (226, 'TIPO'),
    (227, 'TIPO'),
    (228, 'TIPO'),
    (229, 'TIPO'),
    (230, 'TIPO'),
    (231, 'TIPO'),
    (232, 'TIPO'),
    (233, 'TIPO'),
    (234, 'TIPO'),
    (235, 'TIPO'),
    (236, 'TIPO'),
    (237, 'TIPO'),
    (238, 'TIPO'),
    (239, 'TIPO'),
    (240, 'TIPO'),
    (241, 'TIPO'),
    (242, 'TIPO'),
    (243, 'TIPO'),
    (244, 'TIPO'),
    (245, 'TIPO'),
    (246, 'TIPO'),
    (247, 'TIPO'),
    (248, 'TIPO'),
    (249, 'TIPO'),
    (250, 'TIPO'),
    (251, 'TIPO'),
    (252, 'TIPO'),
    (253, 'TIPO'),
    (254, 'TIPO'),
    (255, 'TIPO'),
    (256, 'TIPO'),
    (257, 'TIPO'),
    (258, 'TIPO'),
    (259, 'TIPO'),
    (260, 'TIPO'),
    (261, 'TIPO'),
    (262, 'TIPO'),
    (263, 'TIPO'),
    (264, 'TIPO'),
    (265, 'TIPO'),
    (266, 'TIPO'),
    (267, 'TIPO'),
    (268, 'TIPO'),
    (269, 'TIPO'),
    (270, 'TIPO'),
    (271, 'TIPO'),
    (272, 'TIPO'),
    (273, 'TIPO'),
    (274, 'TIPO'),
    (275, 'TIPO'),
    (276, 'TIPO'),
    (277, 'TIPO'),
    (278, 'TIPO'),
    (279, 'TIPO'),
    (280, 'TIPO'),
    (281, 'TIPO'),
    (282, 'TIPO'),
    (283, 'TIPO'),
    (284, 'TIPO'),
    (285, 'TIPO'),
    (286, 'TIPO'),
    (287, 'TIPO'),
    (288, 'TIPO'),
    (289, 'TIPO'),
    (290, 'TIPO'),
    (291, 'TIPO'),
    (292, 'TIPO'),
    (293, 'TIPO'),
    (294, 'TIPO'),
    (295, 'TIPO'),
    (296, 'TIPO'),
    (297, 'TIPO'),
    (298, 'TIPO'),
    (299, 'TIPO'),
    (300, 'TIPO'),
    (301, 'TIPO'),
    (302, 'TIPO'),
    (303, 'TIPO'),
    (304, 'TIPO'),
    (305, 'TIPO'),
    (306, 'TIPO'),
    (307, 'TIPO'),
    (308, 'TIPO'),
    (309, 'TIPO'),
    (310, 'TIPO'),
    (311, 'TIPO'),
    (312, 'TIPO'),
    (313, 'TIPO'),
    (314, 'TIPO'),
    (315, 'TIPO'),
    (316, 'TIPO'),
    (317, 'TIPO'),
    (318, 'TIPO'),
    (319, 'TIPO'),
    (320, 'TIPO'),
    (321, 'TIPO'),
    (322, 'TIPO'),
    (323, 'TIPO'),
    (324, 'TIPO'),
    (325, 'TIPO'),
    (326, 'TIPO'),
    (327, 'TIPO'),
    (328, 'TIPO'),
    (329, 'TIPO'),
    (330, 'TIPO'),
    (331, 'TIPO'),
    (332, 'TIPO'),
    (333, 'TIPO'),
    (334, 'TIPO'),
    (335, 'TIPO'),
    (336, 'TIPO'),
    (337, 'TIPO'),
    (338, 'TIPO'),
    (339, 'TIPO'),
    (340, 'TIPO'),
    (341, 'TIPO'),
    (342, 'TIPO'),
    (343, 'TIPO'),
    (344, 'TIPO'),
    (345, 'TIPO'),
    (346, 'TIPO'),
    (347, 'TIPO'),
    (348, 'TIPO'),
    (349, 'TIPO'),
    (350, 'TIPO'),
    (351, 'TIPO'),
    (352, 'TIPO'),
    (353, 'TIPO'),
    (354, 'TIPO'),
    (355, 'TIPO'),
    (356, 'TIPO'),
    (357, 'TIPO'),
    (358, 'TIPO'),
    (359, 'TIPO'),
    (360, 'TIPO'),
    (361, 'TIPO'),
    (362, 'TIPO'),
    (363, 'TIPO'),
    (364, 'TIPO'),
    (365, 'TIPO'),
    (366, 'TIPO'),
    (367, 'TIPO'),
    (368, 'TIPO'),
    (369, 'TIPO'),
    (370, 'TIPO'),
    (371, 'TIPO'),
    (372, 'TIPO'),
    (373, 'TIPO'),
    (374, 'TIPO'),
    (375, 'TIPO'),
    (376, 'TIPO'),
    (377, 'TIPO'),
    (378, 'TIPO'),
    (379, 'TIPO'),
    (380, 'TIPO'),
    (381, 'TIPO'),
    (382, 'TIPO'),
    (383, 'TIPO'),
    (384, 'TIPO'),
    (385, 'TIPO'),
    (386, 'TIPO'),
    (387, 'TIPO'),
    (388, 'TIPO'),
    (389, 'TIPO'),
    (390, 'TIPO'),
    (391, 'TIPO'),
    (392, 'TIPO'),
    (393, 'TIPO'),
    (394, 'TIPO'),
    (395, 'TIPO'),
    (396, 'TIPO'),
    (397, 'TIPO'),
    (398, 'TIPO'),
    (399, 'TIPO'),
    (400, 'TIPO'),
    (401, 'TIPO'),
    (402, 'TIPO'),
    (403, 'TIPO'),
    (404, 'TIPO'),
    (405, 'TIPO'),
    (406, 'TIPO'),
    (407, 'TIPO'),
    (408, 'TIPO'),
    (409, 'TIPO'),
    (410, 'TIPO'),
    (411, 'TIPO'),
    (412, 'TIPO'),
    (413, 'TIPO'),
    (414, 'TIPO'),
    (415, 'TIPO'),
    (416, 'TIPO'),
    (417, 'TIPO'),
    (418, 'TIPO'),
    (419, 'TIPO'),
    (420, 'TIPO'),
    (421, 'TIPO'),
    (422, 'TIPO'),
    (423, 'TIPO'),
    (424, 'TIPO'),
    (425, 'TIPO'),
    (426, 'TIPO'),
    (427, 'TIPO'),
    (428, 'TIPO'),
    (429, 'TIPO'),
    (430, 'TIPO'),
    (431, 'TIPO'),
    (432, 'TIPO'),
    (433, 'TIPO'),
    (434, 'TIPO'),
    (435, 'TIPO'),
    (436, 'TIPO'),
    (437, 'TIPO'),
    (438, 'TIPO'),
    (439, 'TIPO'),
    (440, 'TIPO'),
    (441, 'TIPO'),
    (442, 'TIPO'),
    (443, 'TIPO'),
    (444, 'TIPO'),
    (445, 'TIPO'),
    (446, 'TIPO'),
    (447, 'TIPO'),
    (448, 'TIPO'),
    (449, 'TIPO'),
    (450, 'TIPO'),
    (451, 'TIPO'),
    (452, 'TIPO'),
    (453, 'TIPO'),
    (454, 'TIPO'),
    (455, 'TIPO'),
    (456, 'TIPO'),
    (457, 'TIPO'),
    (458, 'TIPO'),
    (459, 'TIPO'),
    (460, 'TIPO'),
    (461, 'TIPO'),
    (462, 'TIPO'),
    (463, 'TIPO'),
    (464, 'TIPO'),
    (465, 'TIPO'),
    (466, 'TIPO'),
    (467, 'TIPO'),
    (468, 'TIPO'),
    (469, 'TIPO'),
    (470, 'TIPO'),
    (471, 'TIPO'),
    (472, 'TIPO'),
    (473, 'TIPO'),
    (474, 'TIPO'),
    (475, 'TIPO'),
    (476, 'TIPO'),
    (477, 'TIPO'),
    (478, 'TIPO'),
    (479, 'TIPO'),
    (480, 'TIPO'),
    (481, 'TIPO'),
    (482, 'TIPO'),
    (483, 'TIPO'),
    (484, 'TIPO'),
    (485, 'TIPO'),
    (486, 'TIPO'),
    (487, 'TIPO'),
    (488, 'TIPO'),
    (489, 'TIPO'),
    (490, 'TIPO'),
    (491, 'TIPO'),
    (492, 'TIPO'),
    (493, 'TIPO'),
    (494, 'TIPO'),
    (495, 'TIPO'),
    (496, 'TIPO'),
    (497, 'TIPO'),
    (498, 'TIPO'),
    (499, 'TIPO'),
    (500, 'TIPO'),
    (501, 'TIPO'),
    (502, 'TIPO'),
    (503, 'TIPO'),
    (504, 'TIPO'),
    (505, 'TIPO'),
    (506, 'TIPO'),
    (507, 'TIPO'),
    (508, 'TIPO'),
    (509, 'TIPO'),
    (510, 'TIPO'),
    (511, 'TIPO'),
    (512, 'TIPO'),
    (513, 'TIPO'),
    (514, 'TIPO'),
    (515, 'TIPO'),
    (516, 'TIPO'),
    (517, 'TIPO'),
    (518, 'TIPO'),
    (519, 'TIPO'),
    (520, 'TIPO'),
    (521, 'TIPO'),
    (522, 'TIPO'),
    (523, 'TIPO'),
    (524, 'TIPO'),
    (525, 'TIPO'),
    (526, 'TIPO'),
    (527, 'TIPO'),
    (528, 'TIPO'),
    (529, 'TIPO'),
    (530, 'TIPO'),
    (531, 'TIPO'),
    (532, 'TIPO'),
    (533, 'TIPO'),
    (534, 'TIPO'),
    (535, 'TIPO'),
    (536, 'TIPO'),
    (537, 'TIPO'),
    (538, 'TIPO'),
    (539, 'TIPO'),
    (540, 'TIPO'),
    (541, 'TIPO'),
    (542, 'TIPO'),
    (543, 'TIPO'),
    (544, 'TIPO'),
    (545, 'TIPO'),
    (546, 'TIPO'),
    (547, 'TIPO'),
    (548, 'TIPO'),
    (549, 'TIPO'),
    (550, 'TIPO'),
    (551, 'TIPO'),
    (552, 'TIPO'),
    (553, 'TIPO'),
    (554, 'TIPO'),
    (555, 'TIPO'),
    (556, 'TIPO'),
    (557, 'TIPO'),
    (558, 'TIPO'),
    (559, 'TIPO'),
    (560, 'TIPO'),
    (561, 'TIPO'),
    (562, 'TIPO'),
    (563, 'TIPO'),
    (564, 'TIPO'),
    (565, 'TIPO'),
    (566, 'TIPO'),
    (567, 'TIPO'),
    (568, 'TIPO'),
    (569, 'TIPO'),
    (570, 'TIPO'),
    (571, 'TIPO'),
    (572, 'TIPO'),
    (573, 'TIPO'),
    (574, 'TIPO'),
    (575, 'TIPO'),
    (576, 'TIPO'),
    (577, 'TIPO'),
    (578, 'TIPO'),
    (579, 'TIPO'),
    (580, 'TIPO'),
    (581, 'TIPO'),
    (582, 'TIPO'),
    (583, 'TIPO'),
    (584, 'TIPO'),
    (585, 'TIPO'),
    (586, 'TIPO'),
    (587, 'TIPO'),
    (588, 'TIPO'),
    (589, 'TIPO'),
    (590, 'TIPO'),
    (591, 'TIPO'),
    (592, 'TIPO'),
    (593, 'TIPO'),
    (594, 'TIPO'),
    (595, 'TIPO'),
    (596, 'TIPO'),
    (597, 'TIPO'),
    (598, 'TIPO'),
    (599, 'TIPO'),
    (600, 'TIPO'),
    (601, 'TIPO'),
    (602, 'TIPO'),
    (603, 'TIPO'),
    (604, 'TIPO'),
    (605, 'TIPO'),
    (606, 'TIPO'),
    (607, 'TIPO'),
    (608, 'TIPO'),
    (609, 'TIPO'),
    (610, 'TIPO'),
    (611, 'TIPO'),
    (612, 'TIPO'),
    (613, 'TIPO'),
    (614, 'TIPO'),
    (615, 'TIPO'),
    (616, 'TIPO'),
    (617, 'TIPO'),
    (618, 'TIPO'),
    (619, 'TIPO'),
    (620, 'TIPO'),
    (621, 'TIPO'),
    (622, 'TIPO'),
    (623, 'TIPO'),
    (624, 'TIPO'),
    (625, 'TIPO'),
    (626, 'TIPO'),
    (627, 'TIPO'),
    (628, 'TIPO'),
    (629, 'TIPO'),
    (630, 'TIPO'),
    (631, 'TIPO'),
    (632, 'TIPO'),
    (633, 'TIPO'),
    (634, 'TIPO'),
    (635, 'TIPO'),
    (636, 'TIPO'),
    (637, 'TIPO'),
    (638, 'TIPO'),
    (639, 'TIPO'),
    (640, 'TIPO'),
    (641, 'TIPO'),
    (642, 'TIPO'),
    (643, 'TIPO'),
    (644, 'TIPO'),
    (645, 'TIPO'),
    (646, 'TIPO'),
    (647, 'TIPO'),
    (648, 'TIPO'),
    (649, 'TIPO'),
    (650, 'TIPO'),
    (651, 'TIPO'),
    (652, 'TIPO'),
    (653, 'TIPO'),
    (654, 'TIPO'),
    (655, 'TIPO'),
    (656, 'TIPO'),
    (657, 'TIPO'),
    (658, 'TIPO'),
    (659, 'TIPO'),
    (660, 'TIPO'),
    (661, 'TIPO'),
    (662, 'TIPO'),
    (663, 'TIPO'),
    (664, 'TIPO'),
    (665, 'TIPO'),
    (666, 'TIPO'),
    (667, 'TIPO'),
    (668, 'TIPO'),
    (669, 'TIPO'),
    (670, 'TIPO'),
    (671, 'TIPO'),
    (672, 'TIPO'),
    (673, 'TIPO'),
    (674, 'TIPO'),
    (675, 'TIPO'),
    (676, 'TIPO'),
    (677, 'TIPO'),
    (678, 'TIPO'),
    (679, 'TIPO'),
    (680, 'TIPO'),
    (681, 'TIPO'),
    (682, 'TIPO'),
    (683, 'TIPO'),
    (684, 'TIPO'),
    (685, 'TIPO'),
    (686, 'TIPO'),
    (687, 'TIPO'),
    (688, 'TIPO'),
    (689, 'TIPO'),
    (690, 'TIPO'),
    (691, 'TIPO'),
    (692, 'TIPO'),
    (693, 'TIPO'),
    (694, 'TIPO'),
    (695, 'TIPO'),
    (696, 'TIPO'),
    (697, 'TIPO'),
    (698, 'TIPO'),
    (699, 'TIPO'),
    (700, 'TIPO'),
    (701, 'TIPO'),
    (702, 'TIPO'),
    (703, 'TIPO'),
    (704, 'TIPO'),
    (705, 'TIPO'),
    (706, 'TIPO'),
    (707, 'TIPO'),
    (708, 'TIPO'),
    (709, 'TIPO'),
    (710, 'TIPO'),
    (711, 'TIPO'),
    (712, 'TIPO'),
    (713, 'TIPO'),
    (714, 'TIPO'),
    (715, 'TIPO'),
    (716, 'TIPO'),
    (717, 'TIPO'),
    (718, 'TIPO'),
    (719, 'TIPO'),
    (720, 'TIPO'),
    (721, 'TIPO'),
    (722, 'TIPO'),
    (723, 'TIPO'),
    (724, 'TIPO'),
    (725, 'TIPO'),
    (726, 'TIPO'),
    (727, 'TIPO'),
    (728, 'TIPO'),
    (729, 'TIPO'),
    (730, 'TIPO'),
    (731, 'TIPO'),
    (732, 'TIPO'),
    (733, 'TIPO'),
    (734, 'TIPO'),
    (735, 'TIPO'),
    (736, 'TIPO'),
    (737, 'TIPO'),
    (738, 'TIPO'),
    (739, 'TIPO'),
    (740, 'TIPO'),
    (741, 'TIPO'),
    (742, 'TIPO'),
    (743, 'TIPO'),
    (744, 'TIPO'),
    (745, 'TIPO'),
    (746, 'TIPO'),
    (747, 'TIPO'),
    (748, 'TIPO'),
    (749, 'TIPO'),
    (750, 'TIPO'),
    (751, 'TIPO'),
    (752, 'TIPO'),
    (753, 'TIPO'),
    (754, 'TIPO'),
    (755, 'TIPO'),
    (756, 'TIPO'),
    (757, 'TIPO'),
    (758, 'TIPO'),
    (759, 'TIPO'),
    (760, 'TIPO'),
    (761, 'TIPO'),
    (762, 'TIPO'),
    (763, 'TIPO'),
    (764, 'TIPO'),
    (765, 'TIPO'),
    (766, 'TIPO'),
    (767, 'TIPO'),
    (768, 'TIPO'),
    (769, 'TIPO'),
    (770, 'TIPO'),
    (771, 'TIPO'),
    (772, 'TIPO'),
    (773, 'TIPO'),
    (774, 'TIPO'),
    (775, 'TIPO'),
    (776, 'TIPO'),
    (777, 'TIPO'),
    (778, 'TIPO'),
    (779, 'TIPO'),
    (780, 'TIPO'),
    (781, 'TIPO'),
    (782, 'TIPO'),
    (783, 'TIPO'),
    (784, 'TIPO'),
    (785, 'TIPO'),
    (786, 'TIPO'),
    (787, 'TIPO'),
    (788, 'TIPO'),
    (789, 'TIPO'),
    (790, 'TIPO'),
    (791, 'TIPO'),
    (792, 'TIPO'),
    (793, 'TIPO'),
    (794, 'TIPO'),
    (795, 'TIPO'),
    (796, 'TIPO'),
    (797, 'TIPO'),
    (798, 'TIPO'),
    (799, 'TIPO'),
    (800, 'TIPO'),
    (801, 'TIPO'),
    (802, 'TIPO'),
    (803, 'TIPO'),
    (804, 'TIPO'),
    (805, 'TIPO'),
    (806, 'TIPO'),
    (807, 'TIPO'),
    (808, 'TIPO'),
    (809, 'TIPO'),
    (810, 'TIPO'),
    (811, 'TIPO'),
    (812, 'TIPO'),
    (813, 'TIPO'),
    (814, 'TIPO'),
    (815, 'TIPO'),
    (816, 'TIPO'),
    (817, 'TIPO'),
    (818, 'TIPO'),
    (819, 'TIPO'),
    (820, 'TIPO'),
    (821, 'TIPO'),
    (822, 'TIPO'),
    (823, 'TIPO'),
    (824, 'TIPO'),
    (825, 'TIPO'),
    (826, 'TIPO'),
    (827, 'TIPO'),
    (828, 'TIPO'),
    (829, 'TIPO'),
    (830, 'TIPO'),
    (831, 'TIPO'),
    (832, 'TIPO'),
    (833, 'TIPO'),
    (834, 'TIPO'),
    (835, 'TIPO'),
    (836, 'TIPO'),
    (837, 'TIPO'),
    (838, 'TIPO'),
    (839, 'TIPO'),
    (840, 'TIPO'),
    (841, 'TIPO'),
    (842, 'TIPO'),
    (843, 'TIPO'),
    (844, 'TIPO'),
    (845, 'TIPO'),
    (846, 'TIPO'),
    (847, 'TIPO'),
    (848, 'TIPO'),
    (849, 'TIPO'),
    (850, 'TIPO'),
    (851, 'TIPO'),
    (852, 'TIPO'),
    (853, 'TIPO'),
    (854, 'TIPO'),
    (855, 'TIPO'),
    (856, 'TIPO'),
    (857, 'TIPO'),
    (858, 'TIPO'),
    (859, 'TIPO'),
    (860, 'TIPO'),
    (861, 'TIPO'),
    (862, 'TIPO'),
    (863, 'TIPO'),
    (864, 'TIPO'),
    (865, 'TIPO'),
    (866, 'TIPO'),
    (867, 'TIPO'),
    (868, 'TIPO'),
    (869, 'TIPO'),
    (870, 'TIPO'),
    (871, 'TIPO'),
    (872, 'TIPO'),
    (873, 'TIPO'),
    (874, 'TIPO'),
    (875, 'TIPO'),
    (876, 'TIPO'),
    (877, 'TIPO'),
    (878, 'TIPO'),
    (879, 'TIPO'),
    (880, 'TIPO'),
    (881, 'TIPO'),
    (882, 'TIPO'),
    (883, 'TIPO'),
    (884, 'TIPO'),
    (885, 'TIPO'),
    (886, 'TIPO'),
    (887, 'TIPO'),
    (888, 'TIPO'),
    (889, 'TIPO'),
    (890, 'TIPO'),
    (891, 'TIPO'),
    (892, 'TIPO'),
    (893, 'TIPO'),
    (894, 'TIPO'),
    (895, 'TIPO'),
    (896, 'TIPO'),
    (897, 'TIPO'),
    (898, 'TIPO'),
    (899, 'TIPO'),
    (900, 'TIPO'),
    (901, 'TIPO'),
    (902, 'TIPO'),
    (903, 'TIPO'),
    (904, 'TIPO'),
    (905, 'TIPO'),
    (906, 'TIPO'),
    (907, 'TIPO'),
    (908, 'TIPO'),
    (909, 'TIPO'),
    (910, 'TIPO'),
    (911, 'TIPO'),
    (912, 'TIPO'),
    (913, 'TIPO'),
    (914, 'TIPO'),
    (915, 'TIPO'),
    (916, 'TIPO'),
    (917, 'TIPO'),
    (918, 'TIPO'),
    (919, 'TIPO'),
    (920, 'TIPO'),
    (921, 'TIPO'),
    (922, 'TIPO'),
    (923, 'TIPO'),
    (924, 'TIPO'),
    (925, 'TIPO'),
    (926, 'TIPO'),
    (927, 'TIPO'),
    (928, 'TIPO'),
    (929, 'TIPO'),
    (930, 'TIPO'),
    (931, 'TIPO'),
    (932, 'TIPO'),
    (933, 'TIPO'),
    (934, 'TIPO'),
    (935, 'TIPO'),
    (936, 'TIPO'),
    (937, 'TIPO'),
    (938, 'TIPO'),
    (939, 'TIPO'),
    (940, 'TIPO'),
    (941, 'TIPO'),
    (942, 'TIPO'),
    (943, 'TIPO'),
    (944, 'TIPO'),
    (945, 'TIPO'),
    (946, 'TIPO'),
    (947, 'TIPO'),
    (948, 'TIPO'),
    (949, 'TIPO'),
    (950, 'TIPO'),
    (951, 'TIPO'),
    (952, 'TIPO'),
    (953, 'TIPO'),
    (954, 'TIPO'),
    (955, 'TIPO'),
    (956, 'TIPO'),
    (957, 'TIPO'),
    (958, 'TIPO'),
    (959, 'TIPO'),
    (960, 'TIPO'),
    (961, 'TIPO'),
    (962, 'TIPO'),
    (963, 'TIPO'),
    (964, 'TIPO'),
    (965, 'TIPO'),
    (966, 'TIPO'),
    (967, 'TIPO'),
    (968, 'TIPO'),
    (969, 'TIPO'),
    (970, 'TIPO'),
    (971, 'TIPO'),
    (972, 'TIPO'),
    (973, 'TIPO'),
    (974, 'TIPO'),
    (975, 'TIPO'),
    (976, 'TIPO'),
    (977, 'TIPO'),
    (978, 'TIPO'),
    (979, 'TIPO'),
    (980, 'TIPO'),
    (981, 'TIPO'),
    (982, 'TIPO'),
    (983, 'TIPO'),
    (984, 'TIPO'),
    (985, 'TIPO'),
    (986, 'TIPO'),
    (987, 'TIPO'),
    (988, 'TIPO'),
    (989, 'TIPO'),
    (990, 'TIPO'),
    (991, 'TIPO'),
    (992, 'TIPO'),
    (993, 'TIPO'),
    (994, 'TIPO'),
    (995, 'TIPO'),
    (996, 'TIPO'),
    (997, 'TIPO'),
    (998, 'TIPO'),
    (999, 'TIPO'),
    (1000, 'TIPO'),
    (1001, 'TIPO'),
    (1002, 'TIPO'),
    (1003, 'TIPO'),
    (1004, 'TIPO'),
    (1005, 'TIPO'),
    (1006, 'TIPO'),
    (1007, 'TIPO'),
    (1008, 'TIPO'),
    (1009, 'TIPO'),
    (1010, 'TIPO'),
    (1011, 'TIPO'),
    (1012, 'TIPO'),
    (1013, 'TIPO'),
    (1014, 'TIPO'),
    (1015, 'TIPO'),
    (1016, 'TIPO'),
    (1017, 'TIPO'),
    (1018, 'TIPO'),
    (1019, 'TIPO'),
    (1020, 'TIPO'),
    (1021, 'TIPO'),
    (1022, 'TIPO'),
    (1023, 'TIPO'),
    (1024, 'TIPO'),
    (1025, 'TIPO'),
    (1026, 'TIPO'),
    (1027, 'TIPO'),
    (1028, 'TIPO'),
    (1029, 'TIPO'),
    (1030, 'TIPO'),
    (1031, 'TIPO'),
    (1032, 'TIPO'),
    (1033, 'TIPO'),
    (1034, 'TIPO'),
    (1035, 'TIPO'),
    (1036, 'TIPO'),
    (1037, 'TIPO'),
    (1038, 'TIPO'),
    (1039, 'TIPO'),
    (1040, 'TIPO'),
    (1041, 'TIPO'),
    (1042, 'TIPO'),
    (1043, 'TIPO'),
    (1044, 'TIPO'),
    (1045, 'TIPO'),
    (1046, 'TIPO'),
    (1047, 'TIPO'),
    (1048, 'TIPO'),
    (1049, 'TIPO'),
    (1050, 'TIPO'),
    (1051, 'TIPO'),
    (1052, 'TIPO'),
    (1053, 'TIPO'),
    (1054, 'TIPO'),
    (1055, 'TIPO'),
    (1056, 'TIPO'),
    (1057, 'TIPO'),
    (1058, 'TIPO'),
    (1059, 'TIPO'),
    (1060, 'TIPO'),
    (1061, 'TIPO'),
    (1062, 'TIPO'),
    (1063, 'TIPO'),
    (1064, 'TIPO'),
    (1065, 'TIPO'),
    (1066, 'TIPO'),
    (1067, 'TIPO'),
    (1068, 'TIPO'),
    (1069, 'TIPO'),
    (1070, 'TIPO'),
    (1071, 'TIPO'),
    (1072, 'TIPO'),
    (1073, 'TIPO'),
    (1074, 'TIPO'),
    (1075, 'TIPO'),
    (1076, 'TIPO'),
    (1077, 'TIPO'),
    (1078, 'TIPO'),
    (1079, 'TIPO'),
    (1080, 'TIPO'),
    (1081, 'TIPO'),
    (1082, 'TIPO'),
    (1083, 'TIPO'),
    (1084, 'TIPO'),
    (1085, 'TIPO'),
    (1086, 'TIPO'),
    (1087, 'TIPO'),
    (1088, 'TIPO'),
    (1089, 'TIPO'),
    (1090, 'TIPO'),
    (1091, 'TIPO'),
    (1092, 'TIPO'),
    (1093, 'TIPO'),
    (1094, 'TIPO'),
    (1095, 'TIPO'),
    (1096, 'TIPO'),
    (1097, 'TIPO'),
    (1098, 'TIPO'),
    (1099, 'TIPO'),
    (1100, 'TIPO'),
    (1101, 'TIPO'),
    (1102, 'TIPO'),
    (1103, 'TIPO'),
    (1104, 'TIPO'),
    (1105, 'TIPO'),
    (1106, 'TIPO'),
    (1107, 'TIPO'),
    (1108, 'TIPO'),
    (1109, 'TIPO'),
    (1110, 'TIPO'),
    (1111, 'TIPO'),
    (1112, 'TIPO'),
    (1113, 'TIPO'),
    (1114, 'TIPO'),
    (1115, 'TIPO'),
    (1116, 'TIPO'),
    (1117, 'TIPO'),
    (1118, 'TIPO'),
    (1119, 'TIPO'),
    (1120, 'TIPO'),
    (1121, 'TIPO'),
    (1122, 'TIPO'),
    (1123, 'TIPO'),
    (1124, 'TIPO'),
    (1125, 'TIPO'),
    (1126, 'TIPO'),
    (1127, 'TIPO'),
    (1128, 'TIPO'),
    (1129, 'TIPO'),
    (1130, 'TIPO'),
    (1131, 'TIPO'),
    (1132, 'TIPO'),
    (1133, 'TIPO'),
    (1134, 'TIPO'),
    (1135, 'TIPO'),
    (1136, 'TIPO'),
    (1137, 'TIPO'),
    (1138, 'TIPO'),
    (1139, 'TIPO'),
    (1140, 'TIPO'),
    (1141, 'TIPO'),
    (1142, 'TIPO'),
    (1143, 'TIPO'),
    (1144, 'TIPO'),
    (1145, 'TIPO'),
    (1146, 'TIPO'),
    (1147, 'TIPO'),
    (1148, 'TIPO'),
    (1149, 'TIPO'),
    (1150, 'TIPO'),
    (1151, 'TIPO'),
    (1152, 'TIPO'),
    (1153, 'TIPO'),
    (1154, 'TIPO'),
    (1155, 'TIPO'),
    (1156, 'TIPO'),
    (1157, 'TIPO'),
    (1158, 'TIPO'),
    (1159, 'TIPO'),
    (1160, 'TIPO'),
    (1161, 'TIPO'),
    (1162, 'TIPO'),
    (1163, 'TIPO'),
    (1164, 'TIPO'),
    (1165, 'TIPO'),
    (1166, 'TIPO'),
    (1167, 'TIPO'),
    (1168, 'TIPO'),
    (1169, 'TIPO'),
    (1170, 'TIPO'),
    (1171, 'TIPO'),
    (1172, 'TIPO'),
    (1173, 'TIPO'),
    (1174, 'TIPO'),
    (1175, 'TIPO'),
    (1176, 'TIPO'),
    (1177, 'TIPO'),
    (1178, 'TIPO'),
    (1179, 'TIPO'),
    (1180, 'TIPO'),
    (1181, 'TIPO'),
    (1182, 'TIPO'),
    (1183, 'TIPO'),
    (1184, 'TIPO'),
    (1185, 'TIPO'),
    (1186, 'TIPO'),
    (1187, 'TIPO'),
    (1188, 'TIPO'),
    (1189, 'TIPO'),
    (1190, 'TIPO'),
    (1191, 'TIPO'),
    (1192, 'TIPO'),
    (1193, 'TIPO'),
    (1194, 'TIPO'),
    (1195, 'TIPO'),
    (1196, 'TIPO'),
    (1197, 'TIPO'),
    (1198, 'TIPO'),
    (1199, 'TIPO'),
    (1200, 'TIPO'),
    (1201, 'TIPO'),
    (1202, 'TIPO'),
    (1203, 'TIPO'),
    (1204, 'TIPO'),
    (1205, 'TIPO'),
    (1206, 'TIPO'),
    (1207, 'TIPO'),
    (1208, 'TIPO'),
    (1209, 'TIPO'),
    (1210, 'TIPO'),
    (1211, 'TIPO'),
    (1212, 'TIPO'),
    (1213, 'TIPO'),
    (1214, 'TIPO'),
    (1215, 'TIPO'),
    (1216, 'TIPO'),
    (1217, 'TIPO'),
    (1218, 'TIPO'),
    (1219, 'TIPO'),
    (1220, 'TIPO'),
    (1221, 'TIPO'),
    (1222, 'TIPO'),
    (1223, 'TIPO'),
    (1224, 'TIPO'),
    (1225, 'TIPO'),
    (1226, 'TIPO'),
    (1227, 'TIPO'),
    (1228, 'TIPO'),
    (1229, 'TIPO'),
    (1230, 'TIPO'),
    (1231, 'TIPO'),
    (1232, 'TIPO'),
    (1233, 'TIPO'),
    (1234, 'TIPO'),
    (1235, 'TIPO'),
    (1236, 'TIPO'),
    (1237, 'TIPO'),
    (1238, 'TIPO'),
    (1239, 'TIPO'),
    (1240, 'TIPO'),
    (1241, 'TIPO'),
    (1242, 'TIPO'),
    (1243, 'TIPO'),
    (1244, 'TIPO'),
    (1245, 'TIPO'),
    (1246, 'TIPO'),
    (1247, 'TIPO'),
    (1248, 'TIPO'),
    (1249, 'TIPO'),
    (1250, 'TIPO'),
    (1251, 'TIPO'),
    (1252, 'TIPO'),
    (1253, 'TIPO'),
    (1254, 'TIPO'),
    (1255, 'TIPO'),
    (1256, 'TIPO'),
    (1257, 'TIPO'),
    (1258, 'TIPO'),
    (1259, 'TIPO'),
    (1260, 'TIPO'),
    (1261, 'TIPO'),
    (1262, 'TIPO'),
    (1263, 'TIPO'),
    (1264, 'TIPO'),
    (1265, 'TIPO'),
    (1266, 'TIPO'),
    (1267, 'TIPO'),
    (1268, 'TIPO'),
    (1269, 'TIPO'),
    (1270, 'TIPO'),
    (1271, 'TIPO'),
    (1272, 'TIPO'),
    (1273, 'TIPO'),
    (1274, 'TIPO'),
    (1275, 'TIPO'),
    (1276, 'TIPO'),
    (1277, 'TIPO'),
    (1278, 'TIPO'),
    (1279, 'TIPO'),
    (1280, 'TIPO'),
    (1281, 'TIPO'),
    (1282, 'TIPO'),
    (1283, 'TIPO'),
    (1284, 'TIPO'),
    (1285, 'TIPO'),
    (1286, 'TIPO'),
    (1287, 'TIPO'),
    (1288, 'TIPO'),
    (1289, 'TIPO'),
    (1290, 'TIPO'),
    (1291, 'TIPO'),
    (1292, 'TIPO'),
    (1293, 'TIPO'),
    (1294, 'TIPO'),
    (1295, 'TIPO'),
    (1296, 'TIPO'),
    (1297, 'TIPO'),
    (1298, 'TIPO'),
    (1299, 'TIPO'),
    (1300, 'TIPO'),
    (1301, 'TIPO'),
    (1302, 'TIPO'),
    (1303, 'TIPO'),
    (1304, 'TIPO'),
    (1305, 'TIPO'),
    (1306, 'TIPO'),
    (1307, 'TIPO'),
    (1308, 'TIPO'),
    (1309, 'TIPO'),
    (1310, 'TIPO'),
    (1311, 'TIPO'),
    (1312, 'TIPO'),
    (1313, 'TIPO'),
    (1314, 'TIPO'),
    (1315, 'TIPO'),
    (1316, 'TIPO'),
    (1317, 'TIPO'),
    (1318, 'TIPO'),
    (1319, 'TIPO'),
    (1320, 'TIPO'),
    (1321, 'TIPO'),
    (1322, 'TIPO'),
    (1323, 'TIPO'),
    (1324, 'TIPO'),
    (1325, 'TIPO'),
    (1326, 'TIPO'),
    (1327, 'TIPO'),
    (1328, 'TIPO'),
    (1329, 'TIPO'),
    (1330, 'TIPO'),
    (1331, 'TIPO'),
    (1332, 'TIPO'),
    (1333, 'TIPO'),
    (1334, 'TIPO'),
    (1335, 'TIPO'),
    (1336, 'TIPO'),
    (1337, 'TIPO'),
    (1338, 'TIPO'),
    (1339, 'TIPO'),
    (1340, 'TIPO'),
    (1341, 'TIPO'),
    (1342, 'TIPO'),
    (1343, 'TIPO'),
    (1344, 'TIPO'),
    (1345, 'TIPO'),
    (1346, 'TIPO'),
    (1347, 'TIPO'),
    (1348, 'TIPO'),
    (1349, 'TIPO'),
    (1350, 'TIPO'),
    (1351, 'TIPO'),
    (1352, 'TIPO'),
    (1353, 'TIPO'),
    (1354, 'TIPO'),
    (1355, 'TIPO'),
    (1356, 'TIPO'),
    (1357, 'TIPO'),
    (1358, 'TIPO'),
    (1359, 'TIPO'),
    (1360, 'TIPO'),
    (1361, 'TIPO'),
    (1362, 'TIPO'),
    (1363, 'TIPO'),
    (1364, 'TIPO'),
    (1365, 'TIPO'),
    (1366, 'TIPO'),
    (1367, 'TIPO'),
    (1368, 'TIPO'),
    (1369, 'TIPO'),
    (1370, 'TIPO'),
    (1371, 'TIPO'),
    (1372, 'TIPO'),
    (1373, 'TIPO'),
    (1374, 'TIPO'),
    (1375, 'TIPO'),
    (1376, 'TIPO'),
    (1377, 'TIPO'),
    (1378, 'TIPO'),
    (1379, 'TIPO'),
    (1380, 'TIPO'),
    (1381, 'TIPO'),
    (1382, 'TIPO'),
    (1383, 'TIPO'),
    (1384, 'TIPO'),
    (1385, 'TIPO'),
    (1386, 'TIPO'),
    (1387, 'TIPO'),
    (1388, 'TIPO'),
    (1389, 'TIPO'),
    (1390, 'TIPO'),
    (1391, 'TIPO'),
    (1392, 'TIPO'),
    (1393, 'TIPO'),
    (1394, 'TIPO'),
    (1395, 'TIPO'),
    (1396, 'TIPO'),
    (1397, 'TIPO'),
    (1398, 'TIPO'),
    (1399, 'TIPO'),
    (1400, 'TIPO'),
    (1401, 'TIPO'),
    (1402, 'TIPO'),
    (1403, 'TIPO'),
    (1404, 'TIPO'),
    (1405, 'TIPO'),
    (1406, 'TIPO'),
    (1407, 'TIPO'),
    (1408, 'TIPO'),
    (1409, 'TIPO'),
    (1410, 'TIPO'),
    (1411, 'TIPO'),
    (1412, 'TIPO'),
    (1413, 'TIPO'),
    (1414, 'TIPO'),
    (1415, 'TIPO'),
    (1416, 'TIPO'),
    (1417, 'TIPO'),
    (1418, 'TIPO'),
    (1419, 'TIPO'),
    (1420, 'TIPO'),
    (1421, 'TIPO'),
    (1422, 'TIPO'),
    (1423, 'TIPO'),
    (1424, 'TIPO'),
    (1425, 'TIPO'),
    (1426, 'TIPO'),
    (1427, 'TIPO'),
    (1428, 'TIPO'),
    (1429, 'TIPO'),
    (1430, 'TIPO'),
    (1431, 'TIPO'),
    (1432, 'TIPO'),
    (1433, 'TIPO'),
    (1434, 'TIPO'),
    (1435, 'TIPO'),
    (1436, 'TIPO'),
    (1437, 'TIPO'),
    (1438, 'TIPO'),
    (1439, 'TIPO'),
    (1440, 'TIPO'),
    (1441, 'TIPO'),
    (1442, 'TIPO'),
    (1443, 'TIPO'),
    (1444, 'TIPO'),
    (1445, 'TIPO'),
    (1446, 'TIPO'),
    (1447, 'TIPO'),
    (1448, 'TIPO'),
    (1449, 'TIPO'),
    (1450, 'TIPO'),
    (1451, 'TIPO'),
    (1452, 'TIPO'),
    (1453, 'TIPO'),
    (1454, 'TIPO'),
    (1455, 'TIPO'),
    (1456, 'TIPO'),
    (1457, 'TIPO'),
    (1458, 'TIPO'),
    (1459, 'TIPO'),
    (1460, 'TIPO'),
    (1461, 'TIPO'),
    (1462, 'TIPO'),
    (1463, 'TIPO'),
    (1464, 'TIPO'),
    (1465, 'TIPO'),
    (1466, 'TIPO'),
    (1467, 'TIPO'),
    (1468, 'TIPO'),
    (1469, 'TIPO'),
    (1470, 'TIPO'),
    (1471, 'TIPO'),
    (1472, 'TIPO'),
    (1473, 'TIPO'),
    (1474, 'TIPO'),
    (1475, 'TIPO'),
    (1476, 'TIPO'),
    (1477, 'TIPO'),
    (1478, 'TIPO'),
    (1479, 'TIPO'),
    (1480, 'TIPO'),
    (1481, 'TIPO'),
    (1482, 'TIPO'),
    (1483, 'TIPO'),
    (1484, 'TIPO'),
    (1485, 'TIPO'),
    (1486, 'TIPO'),
    (1487, 'TIPO'),
    (1488, 'TIPO'),
    (1489, 'TIPO'),
    (1490, 'TIPO'),
    (1491, 'TIPO'),
    (1492, 'TIPO'),
    (1493, 'TIPO'),
    (1494, 'TIPO'),
    (1495, 'TIPO'),
    (1496, 'TIPO'),
    (1497, 'TIPO'),
    (1498, 'TIPO'),
    (1499, 'TIPO'),
    (1500, 'TIPO'),
    (1501, 'TIPO'),
    (1502, 'TIPO'),
    (1503, 'TIPO'),
    (1504, 'TIPO'),
    (1505, 'TIPO'),
    (1506, 'TIPO'),
    (1507, 'TIPO'),
    (1508, 'TIPO'),
    (1509, 'TIPO'),
    (1510, 'TIPO'),
    (1511, 'TIPO'),
    (1512, 'TIPO'),
    (1513, 'TIPO'),
    (1514, 'TIPO'),
    (1515, 'TIPO'),
    (1516, 'TIPO'),
    (1517, 'TIPO'),
    (1518, 'TIPO'),
    (1519, 'TIPO'),
    (1520, 'TIPO'),
    (1521, 'TIPO'),
    (1522, 'TIPO'),
    (1523, 'TIPO'),
    (1524, 'TIPO'),
    (1525, 'TIPO'),
    (1526, 'TIPO'),
    (1527, 'TIPO'),
    (1528, 'TIPO'),
    (1529, 'TIPO'),
    (1530, 'TIPO'),
    (1531, 'TIPO'),
    (1532, 'TIPO'),
    (1533, 'TIPO'),
    (1534, 'TIPO'),
    (1535, 'TIPO'),
    (1536, 'TIPO'),
    (1537, 'TIPO'),
    (1538, 'TIPO'),
    (1539, 'TIPO'),
    (1540, 'TIPO'),
    (1541, 'TIPO'),
    (1542, 'TIPO'),
    (1543, 'TIPO'),
    (1544, 'TIPO'),
    (1545, 'TIPO'),
    (1546, 'TIPO'),
    (1547, 'TIPO'),
    (1548, 'TIPO'),
    (1549, 'TIPO'),
    (1550, 'TIPO'),
    (1551, 'TIPO'),
    (1552, 'TIPO'),
    (1553, 'TIPO'),
    (1554, 'TIPO'),
    (1555, 'TIPO'),
    (1556, 'TIPO'),
    (1557, 'TIPO'),
    (1558, 'TIPO'),
    (1559, 'TIPO'),
    (1560, 'TIPO'),
    (1561, 'TIPO'),
    (1562, 'TIPO'),
    (1563, 'TIPO'),
    (1564, 'TIPO'),
    (1565, 'TIPO'),
    (1566, 'TIPO'),
    (1567, 'TIPO'),
    (1568, 'TIPO'),
    (1569, 'TIPO'),
    (1570, 'TIPO'),
    (1571, 'TIPO'),
    (1572, 'TIPO'),
    (1573, 'TIPO'),
    (1574, 'TIPO'),
    (1575, 'TIPO'),
    (1576, 'TIPO'),
    (1577, 'TIPO'),
    (1578, 'TIPO'),
    (1579, 'TIPO'),
    (1580, 'TIPO'),
    (1581, 'TIPO'),
    (1582, 'TIPO'),
    (1583, 'TIPO'),
    (1584, 'TIPO'),
    (1585, 'TIPO'),
    (1586, 'TIPO'),
    (1587, 'TIPO'),
    (1588, 'TIPO'),
    (1589, 'TIPO'),
    (1590, 'TIPO'),
    (1591, 'TIPO'),
    (1592, 'TIPO'),
    (1593, 'TIPO'),
    (1594, 'TIPO'),
    (1595, 'TIPO'),
    (1596, 'TIPO'),
    (1597, 'TIPO'),
    (1598, 'TIPO'),
    (1599, 'TIPO'),
    (1600, 'TIPO'),
    (1601, 'TIPO'),
    (1602, 'TIPO'),
    (1603, 'TIPO'),
    (1604, 'TIPO'),
    (1605, 'TIPO'),
    (1606, 'TIPO'),
    (1607, 'TIPO'),
    (1608, 'TIPO'),
    (1609, 'TIPO'),
    (1610, 'TIPO'),
    (1611, 'TIPO'),
    (1612, 'TIPO'),
    (1613, 'TIPO'),
    (1614, 'TIPO'),
    (1615, 'TIPO'),
    (1616, 'TIPO'),
    (1617, 'TIPO'),
    (1618, 'TIPO'),
    (1619, 'TIPO'),
    (1620, 'TIPO'),
    (1621, 'TIPO'),
    (1622, 'TIPO'),
    (1623, 'TIPO'),
    (1624, 'TIPO'),
    (1625, 'TIPO'),
    (1626, 'TIPO'),
    (1627, 'TIPO'),
    (1628, 'TIPO'),
    (1629, 'TIPO'),
    (1630, 'TIPO'),
    (1631, 'TIPO'),
    (1632, 'TIPO'),
    (1633, 'TIPO'),
    (1634, 'TIPO'),
    (1635, 'TIPO'),
    (1636, 'TIPO'),
    (1637, 'TIPO'),
    (1638, 'TIPO'),
    (1639, 'TIPO'),
    (1640, 'TIPO'),
    (1641, 'TIPO'),
    (1642, 'TIPO'),
    (1643, 'TIPO'),
    (1644, 'TIPO'),
    (1645, 'TIPO'),
    (1646, 'TIPO'),
    (1647, 'TIPO'),
    (1648, 'TIPO'),
    (1649, 'TIPO'),
    (1650, 'TIPO'),
    (1651, 'TIPO'),
    (1652, 'TIPO'),
    (1653, 'TIPO'),
    (1654, 'TIPO'),
    (1655, 'TIPO'),
    (1656, 'TIPO'),
    (1657, 'TIPO'),
    (1658, 'TIPO'),
    (1659, 'TIPO'),
    (1660, 'TIPO'),
    (1661, 'TIPO'),
    (1662, 'TIPO'),
    (1663, 'TIPO'),
    (1664, 'TIPO'),
    (1665, 'TIPO'),
    (1666, 'TIPO'),
    (1667, 'TIPO'),
    (1668, 'TIPO'),
    (1669, 'TIPO'),
    (1670, 'TIPO'),
    (1671, 'TIPO'),
    (1672, 'TIPO'),
    (1673, 'TIPO'),
    (1674, 'TIPO'),
    (1675, 'TIPO'),
    (1676, 'TIPO'),
    (1677, 'TIPO'),
    (1678, 'TIPO'),
    (1679, 'TIPO'),
    (1680, 'TIPO'),
    (1681, 'TIPO'),
    (1682, 'TIPO'),
    (1683, 'TIPO'),
    (1684, 'TIPO'),
    (1685, 'TIPO'),
    (1686, 'TIPO'),
    (1687, 'TIPO'),
    (1688, 'TIPO'),
    (1689, 'TIPO'),
    (1690, 'TIPO'),
    (1691, 'TIPO'),
    (1692, 'TIPO'),
    (1693, 'TIPO'),
    (1694, 'TIPO'),
    (1695, 'TIPO'),
    (1696, 'TIPO'),
    (1697, 'TIPO'),
    (1698, 'TIPO'),
    (1699, 'TIPO'),
    (1700, 'TIPO'),
    (1701, 'TIPO'),
    (1702, 'TIPO'),
    (1703, 'TIPO'),
    (1704, 'TIPO'),
    (1705, 'TIPO'),
    (1706, 'TIPO'),
    (1707, 'TIPO'),
    (1708, 'TIPO'),
    (1709, 'TIPO'),
    (1710, 'TIPO'),
    (1711, 'TIPO'),
    (1712, 'TIPO'),
    (1713, 'TIPO'),
    (1714, 'TIPO'),
    (1715, 'TIPO'),
    (1716, 'TIPO'),
    (1717, 'TIPO'),
    (1718, 'TIPO'),
    (1719, 'TIPO'),
    (1720, 'TIPO'),
    (1721, 'TIPO'),
    (1722, 'TIPO'),
    (1723, 'TIPO'),
    (1724, 'TIPO'),
    (1725, 'TIPO'),
    (1726, 'TIPO'),
    (1727, 'TIPO'),
    (1728, 'TIPO'),
    (1729, 'TIPO'),
    (1730, 'TIPO'),
    (1731, 'TIPO'),
    (1732, 'TIPO'),
    (1733, 'TIPO'),
    (1734, 'TIPO'),
    (1735, 'TIPO'),
    (1736, 'TIPO'),
    (1737, 'TIPO'),
    (1738, 'TIPO'),
    (1739, 'TIPO'),
    (1740, 'TIPO'),
    (1741, 'TIPO'),
    (1742, 'TIPO'),
    (1743, 'TIPO'),
    (1744, 'TIPO'),
    (1745, 'TIPO'),
    (1746, 'TIPO'),
    (1747, 'TIPO'),
    (1748, 'TIPO'),
    (1749, 'TIPO'),
    (1750, 'TIPO'),
    (1751, 'TIPO'),
    (1752, 'TIPO'),
    (1753, 'TIPO'),
    (1754, 'TIPO'),
    (1755, 'TIPO'),
    (1756, 'TIPO'),
    (1757, 'TIPO'),
    (1758, 'TIPO'),
    (1759, 'TIPO'),
    (1760, 'TIPO'),
    (1761, 'TIPO'),
    (1762, 'TIPO'),
    (1763, 'TIPO'),
    (1764, 'TIPO'),
    (1765, 'TIPO'),
    (1766, 'TIPO'),
    (1767, 'TIPO'),
    (1768, 'TIPO'),
    (1769, 'TIPO'),
    (1770, 'TIPO'),
    (1771, 'TIPO'),
    (1772, 'TIPO'),
    (1773, 'TIPO'),
    (1774, 'TIPO'),
    (1775, 'TIPO'),
    (1776, 'TIPO'),
    (1777, 'TIPO'),
    (1778, 'TIPO'),
    (1779, 'TIPO'),
    (1780, 'TIPO'),
    (1781, 'TIPO'),
    (1782, 'TIPO'),
    (1783, 'TIPO'),
    (1784, 'TIPO'),
    (1785, 'TIPO'),
    (1786, 'TIPO'),
    (1787, 'TIPO'),
    (1788, 'TIPO'),
    (1789, 'TIPO'),
    (1790, 'TIPO'),
    (1791, 'TIPO'),
    (1792, 'TIPO'),
    (1793, 'TIPO'),
    (1794, 'TIPO'),
    (1795, 'TIPO'),
    (1796, 'TIPO'),
    (1797, 'TIPO'),
    (1798, 'TIPO'),
    (1799, 'TIPO'),
    (1800, 'TIPO'),
    (1801, 'TIPO'),
    (1802, 'TIPO'),
    (1803, 'TIPO'),
    (1804, 'TIPO'),
    (1805, 'TIPO'),
    (1806, 'TIPO'),
    (1807, 'TIPO'),
    (1808, 'TIPO'),
    (1809, 'TIPO'),
    (1810, 'TIPO'),
    (1811, 'TIPO'),
    (1812, 'TIPO'),
    (1813, 'TIPO'),
    (1814, 'TIPO'),
    (1815, 'TIPO'),
    (1816, 'TIPO'),
    (1817, 'TIPO'),
    (1818, 'TIPO'),
    (1819, 'TIPO'),
    (1820, 'TIPO'),
    (1821, 'TIPO'),
    (1822, 'TIPO'),
    (1823, 'TIPO'),
    (1824, 'TIPO'),
    (1825, 'TIPO'),
    (1826, 'TIPO'),
    (1827, 'TIPO'),
    (1828, 'TIPO'),
    (1829, 'TIPO'),
    (1830, 'TIPO'),
    (1831, 'TIPO'),
    (1832, 'TIPO'),
    (1833, 'TIPO'),
    (1834, 'TIPO'),
    (1835, 'TIPO'),
    (1836, 'TIPO'),
    (1837, 'TIPO'),
    (1838, 'TIPO'),
    (1839, 'TIPO'),
    (1840, 'TIPO'),
    (1841, 'TIPO'),
    (1842, 'TIPO'),
    (1843, 'TIPO'),
    (1844, 'TIPO'),
    (1845, 'TIPO'),
    (1846, 'TIPO'),
    (1847, 'TIPO'),
    (1848, 'TIPO'),
    (1849, 'TIPO'),
    (1850, 'TIPO'),
    (1851, 'TIPO'),
    (1852, 'TIPO'),
    (1853, 'TIPO'),
    (1854, 'TIPO'),
    (1855, 'TIPO'),
    (1856, 'TIPO'),
    (1857, 'TIPO'),
    (1858, 'TIPO'),
    (1859, 'TIPO'),
    (1860, 'TIPO'),
    (1861, 'TIPO'),
    (1862, 'TIPO'),
    (1863, 'TIPO'),
    (1864, 'TIPO'),
    (1865, 'TIPO'),
    (1866, 'TIPO'),
    (1867, 'TIPO'),
    (1868, 'TIPO'),
    (1869, 'TIPO'),
    (1870, 'TIPO'),
    (1871, 'TIPO'),
    (1872, 'TIPO'),
    (1873, 'TIPO'),
    (1874, 'TIPO'),
    (1875, 'TIPO'),
    (1876, 'TIPO'),
    (1877, 'TIPO'),
    (1878, 'TIPO'),
    (1879, 'TIPO'),
    (1880, 'TIPO'),
    (1881, 'TIPO'),
    (1882, 'TIPO'),
    (1883, 'TIPO'),
    (1884, 'TIPO'),
    (1885, 'TIPO'),
    (1886, 'TIPO'),
    (1887, 'TIPO'),
    (1888, 'TIPO'),
    (1889, 'TIPO'),
    (1890, 'TIPO'),
    (1891, 'TIPO'),
    (1892, 'TIPO'),
    (1893, 'TIPO'),
    (1894, 'TIPO'),
    (1895, 'TIPO'),
    (1896, 'TIPO'),
    (1897, 'TIPO'),
    (1898, 'TIPO'),
    (1899, 'TIPO'),
    (1900, 'TIPO'),
    (1901, 'TIPO'),
    (1902, 'TIPO'),
    (1903, 'TIPO'),
    (1904, 'TIPO'),
    (1905, 'TIPO'),
    (1906, 'TIPO'),
    (1907, 'TIPO'),
    (1908, 'TIPO'),
    (1909, 'TIPO'),
    (1910, 'TIPO'),
    (1911, 'TIPO'),
    (1912, 'TIPO'),
    (1913, 'TIPO'),
    (1914, 'TIPO'),
    (1915, 'TIPO'),
    (1916, 'TIPO'),
    (1917, 'TIPO'),
    (1918, 'TIPO'),
    (1919, 'TIPO'),
    (1920, 'TIPO'),
    (1921, 'TIPO'),
    (1922, 'TIPO'),
    (1923, 'TIPO'),
    (1924, 'TIPO'),
    (1925, 'TIPO'),
    (1926, 'TIPO'),
    (1927, 'TIPO'),
    (1928, 'TIPO'),
    (1929, 'TIPO'),
    (1930, 'TIPO'),
    (1931, 'TIPO'),
    (1932, 'TIPO'),
    (1933, 'TIPO'),
    (1934, 'TIPO'),
    (1935, 'TIPO'),
    (1936, 'TIPO'),
    (1937, 'TIPO'),
    (1938, 'TIPO'),
    (1939, 'TIPO'),
    (1940, 'TIPO'),
    (1941, 'TIPO'),
    (1942, 'TIPO'),
    (1943, 'TIPO'),
    (1944, 'TIPO'),
    (1945, 'TIPO'),
    (1946, 'TIPO'),
    (1947, 'TIPO'),
    (1948, 'TIPO'),
    (1949, 'TIPO'),
    (1950, 'TIPO'),
    (1951, 'TIPO'),
    (1952, 'TIPO'),
    (1953, 'TIPO'),
    (1954, 'TIPO'),
    (1955, 'TIPO'),
    (1956, 'TIPO'),
    (1957, 'TIPO'),
    (1958, 'TIPO'),
    (1959, 'TIPO'),
    (1960, 'TIPO'),
    (1961, 'TIPO'),
    (1962, 'TIPO'),
    (1963, 'TIPO'),
    (1964, 'TIPO'),
    (1965, 'TIPO'),
    (1966, 'TIPO'),
    (1967, 'TIPO'),
    (1968, 'TIPO'),
    (1969, 'TIPO'),
    (1970, 'TIPO'),
    (1971, 'TIPO'),
    (1972, 'TIPO'),
    (1973, 'TIPO'),
    (1974, 'TIPO'),
    (1975, 'TIPO'),
    (1976, 'TIPO'),
    (1977, 'TIPO'),
    (1978, 'TIPO'),
    (1979, 'TIPO'),
    (1980, 'TIPO'),
    (1981, 'TIPO'),
    (1982, 'TIPO'),
    (1983, 'TIPO'),
    (1984, 'TIPO'),
    (1985, 'TIPO'),
    (1986, 'TIPO'),
    (1987, 'TIPO'),
    (1988, 'TIPO'),
    (1989, 'TIPO'),
    (1990, 'TIPO'),
    (1991, 'TIPO'),
    (1992, 'TIPO'),
    (1993, 'TIPO'),
    (1994, 'TIPO'),
    (1995, 'TIPO'),
    (1996, 'TIPO'),
    (1997, 'TIPO'),
    (1998, 'TIPO'),
    (1999, 'TIPO'),
    (2000, 'TIPO');

--
-- Name: parts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY parts ADD CONSTRAINT parts_pkey PRIMARY KEY (id);

--
-- Name: personas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY personas ADD CONSTRAINT personas_pkey PRIMARY KEY (cedula);

--
-- Name: personnes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY personnes ADD CONSTRAINT personnes_pkey PRIMARY KEY (cedula);

--
-- Name: prueba_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY prueba ADD CONSTRAINT prueba_pkey PRIMARY KEY (id);

--
-- Name: robots_parts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY robots_parts ADD CONSTRAINT robots_parts_pkey PRIMARY KEY (id);

--
-- Name: robots_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY robots ADD CONSTRAINT robots_pkey PRIMARY KEY (id);

--
-- Name: subscriptores_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY subscriptores ADD CONSTRAINT subscriptores_pkey PRIMARY KEY (id);

--
-- Name: tipo_documento_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY tipo_documento ADD CONSTRAINT tipo_documento_pkey PRIMARY KEY (id);

--
-- Name: personas_estado_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace:
--

CREATE INDEX personas_estado_idx ON personas USING btree (estado);

--
-- Name: robots_parts_parts_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace:
--

CREATE INDEX robots_parts_parts_id ON robots_parts USING btree (parts_id);

--
-- Name: robots_parts_robots_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace:
--

CREATE INDEX robots_parts_robots_id ON robots_parts USING btree (robots_id);

--
-- Name: robots_parts_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY robots_parts ADD CONSTRAINT robots_parts_ibfk_1 FOREIGN KEY (robots_id) REFERENCES robots(id);

--
-- Name: robots_parts_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY robots_parts ADD CONSTRAINT robots_parts_ibfk_2 FOREIGN KEY (parts_id) REFERENCES parts(id);

--
-- Name: table_with_string_field; Type: TABLE DATA; Schema: public; Owner: postgres
--

DROP TABLE IF EXISTS table_with_string_field;
CREATE TABLE table_with_string_field (
    id integer NOT NULL,
    field character varying(70) NOT NULL
);

--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;

--
-- PostgreSQL database dump complete
--
