/* stco.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"



void quicktime_stco_init(quicktime_stco_t *stco)
{
	stco->version = 0;
	stco->flags = 0;
	stco->total_entries = 0;
	stco->entries_allocated = 0;
}

void quicktime_stco_delete(quicktime_stco_t *stco)
{
	if(stco->total_entries) free(stco->table);
	stco->total_entries = 0;
	stco->entries_allocated = 0;
}

void quicktime_stco_init_common(quicktime_t *file, quicktime_stco_t *stco)
{
	if(!stco->entries_allocated)
	{
		stco->entries_allocated = 2000;
		stco->total_entries = 0;
		stco->table = (quicktime_stco_table_t*)malloc(sizeof(quicktime_stco_table_t) * stco->entries_allocated);
/*printf("quicktime_stco_init_common %x\n", stco->table); */
	}
}

void quicktime_stco_dump(quicktime_stco_t *stco)
{
	long i;
	printf("     chunk offset\n");
	printf("      version %d\n", stco->version);
	printf("      flags %ld\n", stco->flags);
	printf("      total_entries %ld\n", stco->total_entries);
	printf("      entries_allocated %ld\n", stco->entries_allocated);
	for(i = 0; i < stco->total_entries; i++)
	{
		printf("       offset %d 0x%llx\n", i, stco->table[i].offset);
	}
}

void quicktime_read_stco(quicktime_t *file, quicktime_stco_t *stco)
{
	long i;
	stco->version = quicktime_read_char(file);
	stco->flags = quicktime_read_int24(file);
	stco->total_entries = quicktime_read_int32(file);
	stco->entries_allocated = stco->total_entries;
	stco->table = (quicktime_stco_table_t*)calloc(1, sizeof(quicktime_stco_table_t) * stco->entries_allocated);
	for(i = 0; i < stco->total_entries; i++)
	{
		stco->table[i].offset = quicktime_read_uint32(file);
	}
}

void quicktime_read_stco64(quicktime_t *file, quicktime_stco_t *stco)
{
	long i;
	stco->version = quicktime_read_char(file);
	stco->flags = quicktime_read_int24(file);
	stco->total_entries = quicktime_read_int32(file);
	stco->entries_allocated = stco->total_entries;
	stco->table = (quicktime_stco_table_t*)calloc(1, sizeof(quicktime_stco_table_t) * stco->entries_allocated);
	for(i = 0; i < stco->total_entries; i++)
	{
		stco->table[i].offset = quicktime_read_int64(file);
	}
}

void quicktime_write_stco(quicktime_t *file, quicktime_stco_t *stco)
{
	long i;
	quicktime_atom_t atom;
//	quicktime_atom_write_header(file, &atom, "stco");
	quicktime_atom_write_header(file, &atom, "co64");

	quicktime_write_char(file, stco->version);
	quicktime_write_int24(file, stco->flags);
	quicktime_write_int32(file, stco->total_entries);
	for(i = 0; i < stco->total_entries; i++)
	{
		quicktime_write_int64(file, stco->table[i].offset);
	}

	quicktime_atom_write_footer(file, &atom);
}

void quicktime_update_stco(quicktime_stco_t *stco, long chunk, longest offset)
{
	long i;

	if(chunk > stco->entries_allocated)
	{
		stco->entries_allocated = chunk * 2;
		stco->table = (quicktime_stco_table_t*)realloc(stco->table, sizeof(quicktime_stco_table_t) * stco->entries_allocated);
	}
	
	stco->table[chunk - 1].offset = offset;
	if(chunk > stco->total_entries) stco->total_entries = chunk;
}


