/* mdhd.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"

void quicktime_mdhd_init(quicktime_mdhd_t *mdhd)
{
	mdhd->version = 0;
	mdhd->flags = 0;
	mdhd->creation_time = quicktime_current_time();
	mdhd->modification_time = quicktime_current_time();
	mdhd->time_scale = 0;
	mdhd->duration = 0;
	mdhd->language = 0;
	mdhd->quality = 100;
}

void quicktime_mdhd_init_video(quicktime_t *file, 
								quicktime_mdhd_t *mdhd, 
								int frame_w,
								int frame_h, 
								float frame_rate)
{
	mdhd->time_scale = quicktime_get_timescale(frame_rate);
//printf("quicktime_mdhd_init_video %ld %f\n", mdhd->time_scale, (double)frame_rate);
	mdhd->duration = 0;      /* set this when closing */
}

void quicktime_mdhd_init_audio(quicktime_t *file, 
							quicktime_mdhd_t *mdhd, 
							int channels, 
							int sample_rate, 
							int bits, 
							char *compressor)
{
	mdhd->time_scale = sample_rate;
	mdhd->duration = 0;      /* set this when closing */
}

void quicktime_mdhd_delete(quicktime_mdhd_t *mdhd)
{
}

void quicktime_read_mdhd(quicktime_t *file, quicktime_mdhd_t *mdhd)
{
	mdhd->version = quicktime_read_char(file);
	mdhd->flags = quicktime_read_int24(file);
	mdhd->creation_time = quicktime_read_int32(file);
	mdhd->modification_time = quicktime_read_int32(file);
	mdhd->time_scale = quicktime_read_int32(file);
	mdhd->duration = quicktime_read_int32(file);
	mdhd->language = quicktime_read_int16(file);
	mdhd->quality = quicktime_read_int16(file);
}

void quicktime_mdhd_dump(quicktime_mdhd_t *mdhd)
{
	printf("   media header\n");
	printf("    version %d\n", mdhd->version);
	printf("    flags %ld\n", mdhd->flags);
	printf("    creation_time %lu\n", mdhd->creation_time);
	printf("    modification_time %ul\n", mdhd->modification_time);
	printf("    time_scale %dl\n", mdhd->time_scale);
	printf("    duration %ld\n", mdhd->duration);
	printf("    language %d\n", mdhd->language);
	printf("    quality %d\n", mdhd->quality);
}

void quicktime_write_mdhd(quicktime_t *file, quicktime_mdhd_t *mdhd)
{
	quicktime_atom_t atom;
	quicktime_atom_write_header(file, &atom, "mdhd");

	quicktime_write_char(file, mdhd->version);
	quicktime_write_int24(file, mdhd->flags);
	quicktime_write_int32(file, mdhd->creation_time);
	quicktime_write_int32(file, mdhd->modification_time);
	quicktime_write_int32(file, mdhd->time_scale);
	quicktime_write_int32(file, mdhd->duration);
	quicktime_write_int16(file, mdhd->language);
	quicktime_write_int16(file, mdhd->quality);	

	quicktime_atom_write_footer(file, &atom);
}

