; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686--   -mattr=sse2 | FileCheck %s --check-prefixes=CHECK,X86-SSE2
; RUN: llc < %s -mtriple=x86_64-- -mattr=avx2 | FileCheck %s --check-prefixes=CHECK,X64-AVX,X64-AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,+avx512vbmi,+avx512vbmi2,+avx512vl | FileCheck %s --check-prefixes=CHECK,X64-AVX,X64-VBMI2

declare i8 @llvm.fshl.i8(i8, i8, i8)
declare i16 @llvm.fshl.i16(i16, i16, i16)
declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i64 @llvm.fshl.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)
declare i128 @llvm.fshl.i128(i128, i128, i128)

declare i8 @llvm.fshr.i8(i8, i8, i8)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare i32 @llvm.fshr.i32(i32, i32, i32)
declare i64 @llvm.fshr.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

; General case - all operands can be variables

define i32 @fshl_i32(i32 %x, i32 %y, i32 %z) nounwind {
; X86-SSE2-LABEL: fshl_i32:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %esi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %z)
  ret i32 %f
}

define i64 @fshl_i64(i64 %x, i64 %y, i64 %z) nounwind {
; X86-SSE2-LABEL: fshl_i64:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %edi
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    testb $32, %cl
; X86-SSE2-NEXT:    movl %edx, %edi
; X86-SSE2-NEXT:    cmovnel %esi, %edi
; X86-SSE2-NEXT:    cmovel {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    cmovnel {{[0-9]+}}(%esp), %esi
; X86-SSE2-NEXT:    movl %edi, %eax
; X86-SSE2-NEXT:    shldl %cl, %esi, %eax
; X86-SSE2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-SSE2-NEXT:    shldl %cl, %edi, %edx
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    popl %edi
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movq %rdx, %rcx
; X64-AVX-NEXT:    movq %rdi, %rax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-AVX-NEXT:    shldq %cl, %rsi, %rax
; X64-AVX-NEXT:    retq
  %f = call i64 @llvm.fshl.i64(i64 %x, i64 %y, i64 %z)
  ret i64 %f
}

define i128 @fshl_i128(i128 %x, i128 %y, i128 %z) nounwind {
; X86-SSE2-LABEL: fshl_i128:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    pushl %ebx
; X86-SSE2-NEXT:    pushl %edi
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    testb $64, %cl
; X86-SSE2-NEXT:    movl %esi, %eax
; X86-SSE2-NEXT:    cmovnel %ebx, %eax
; X86-SSE2-NEXT:    movl %edx, %ebp
; X86-SSE2-NEXT:    cmovnel %edi, %ebp
; X86-SSE2-NEXT:    cmovnel {{[0-9]+}}(%esp), %edi
; X86-SSE2-NEXT:    cmovnel {{[0-9]+}}(%esp), %ebx
; X86-SSE2-NEXT:    cmovel {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    cmovel {{[0-9]+}}(%esp), %esi
; X86-SSE2-NEXT:    testb $32, %cl
; X86-SSE2-NEXT:    cmovnel %esi, %edx
; X86-SSE2-NEXT:    cmovnel %ebp, %esi
; X86-SSE2-NEXT:    cmovnel %eax, %ebp
; X86-SSE2-NEXT:    cmovel %edi, %ebx
; X86-SSE2-NEXT:    cmovel %eax, %edi
; X86-SSE2-NEXT:    movl %edi, %eax
; X86-SSE2-NEXT:    shldl %cl, %ebx, %eax
; X86-SSE2-NEXT:    movl %ebp, %ebx
; X86-SSE2-NEXT:    shldl %cl, %edi, %ebx
; X86-SSE2-NEXT:    movl %esi, %edi
; X86-SSE2-NEXT:    shldl %cl, %ebp, %edi
; X86-SSE2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-SSE2-NEXT:    shldl %cl, %esi, %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl %edx, 12(%ecx)
; X86-SSE2-NEXT:    movl %edi, 8(%ecx)
; X86-SSE2-NEXT:    movl %ebx, 4(%ecx)
; X86-SSE2-NEXT:    movl %eax, (%ecx)
; X86-SSE2-NEXT:    movl %ecx, %eax
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    popl %edi
; X86-SSE2-NEXT:    popl %ebx
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl $4
;
; X64-AVX-LABEL: fshl_i128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    testb $64, %r8b
; X64-AVX-NEXT:    cmovneq %rdi, %rsi
; X64-AVX-NEXT:    cmoveq %rcx, %rdx
; X64-AVX-NEXT:    cmovneq %rcx, %rdi
; X64-AVX-NEXT:    movq %rdi, %rax
; X64-AVX-NEXT:    movl %r8d, %ecx
; X64-AVX-NEXT:    shldq %cl, %rdx, %rax
; X64-AVX-NEXT:    shldq %cl, %rdi, %rsi
; X64-AVX-NEXT:    movq %rsi, %rdx
; X64-AVX-NEXT:    retq
  %f = call i128 @llvm.fshl.i128(i128 %x, i128 %y, i128 %z)
  ret i128 %f
}

; Verify that weird types are minimally supported.
declare i37 @llvm.fshl.i37(i37, i37, i37)
define i37 @fshl_i37(i37 %x, i37 %y, i37 %z) nounwind {
; X86-SSE2-LABEL: fshl_i37:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebx
; X86-SSE2-NEXT:    pushl %edi
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    andl $31, %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-SSE2-NEXT:    shldl $27, %ebx, %edi
; X86-SSE2-NEXT:    pushl $0
; X86-SSE2-NEXT:    pushl $37
; X86-SSE2-NEXT:    pushl %eax
; X86-SSE2-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE2-NEXT:    calll __umoddi3
; X86-SSE2-NEXT:    addl $16, %esp
; X86-SSE2-NEXT:    movl %eax, %ecx
; X86-SSE2-NEXT:    testb $32, %cl
; X86-SSE2-NEXT:    jne .LBB3_1
; X86-SSE2-NEXT:  # %bb.2:
; X86-SSE2-NEXT:    movl %edi, %ebx
; X86-SSE2-NEXT:    movl %esi, %edi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SSE2-NEXT:    jmp .LBB3_3
; X86-SSE2-NEXT:  .LBB3_1:
; X86-SSE2-NEXT:    shll $27, %ebx
; X86-SSE2-NEXT:  .LBB3_3:
; X86-SSE2-NEXT:    movl %edi, %eax
; X86-SSE2-NEXT:    shldl %cl, %ebx, %eax
; X86-SSE2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-SSE2-NEXT:    shldl %cl, %edi, %esi
; X86-SSE2-NEXT:    movl %esi, %edx
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    popl %edi
; X86-SSE2-NEXT:    popl %ebx
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i37:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movq %rdx, %rcx
; X64-AVX-NEXT:    movabsq $137438953471, %rax # imm = 0x1FFFFFFFFF
; X64-AVX-NEXT:    andq %rdx, %rax
; X64-AVX-NEXT:    movabsq $498560650640798693, %rdx # imm = 0x6EB3E45306EB3E5
; X64-AVX-NEXT:    mulq %rdx
; X64-AVX-NEXT:    leal (%rdx,%rdx,8), %eax
; X64-AVX-NEXT:    leal (%rdx,%rax,4), %eax
; X64-AVX-NEXT:    subl %eax, %ecx
; X64-AVX-NEXT:    shlq $27, %rsi
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-AVX-NEXT:    shldq %cl, %rsi, %rdi
; X64-AVX-NEXT:    movq %rdi, %rax
; X64-AVX-NEXT:    retq
  %f = call i37 @llvm.fshl.i37(i37 %x, i37 %y, i37 %z)
  ret i37 %f
}

; extract(concat(0b1110000, 0b1111111) << 2) = 0b1000011

declare i7 @llvm.fshl.i7(i7, i7, i7)
define i7 @fshl_i7_const_fold() {
; CHECK-LABEL: fshl_i7_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $67, %al
; CHECK-NEXT:    ret{{[l|q]}}
  %f = call i7 @llvm.fshl.i7(i7 112, i7 127, i7 2)
  ret i7 %f
}

; With constant shift amount, this is 'shld' with constant operand.

define i32 @fshl_i32_const_shift(i32 %x, i32 %y) nounwind {
; X86-SSE2-LABEL: fshl_i32_const_shift:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl $9, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_const_shift:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shldl $9, %esi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 9)
  ret i32 %f
}

; Check modulo math on shift amount.

define i32 @fshl_i32_const_overshift(i32 %x, i32 %y) nounwind {
; X86-SSE2-LABEL: fshl_i32_const_overshift:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl $9, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_const_overshift:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shldl $9, %esi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 41)
  ret i32 %f
}

; 64-bit should also work.

define i64 @fshl_i64_const_overshift(i64 %x, i64 %y) nounwind {
; X86-SSE2-LABEL: fshl_i64_const_overshift:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    shldl $9, %ecx, %edx
; X86-SSE2-NEXT:    shrdl $23, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i64_const_overshift:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movq %rdi, %rax
; X64-AVX-NEXT:    shldq $41, %rsi, %rax
; X64-AVX-NEXT:    retq
  %f = call i64 @llvm.fshl.i64(i64 %x, i64 %y, i64 105)
  ret i64 %f
}

; This should work without any node-specific logic.

define i8 @fshl_i8_const_fold() nounwind {
; CHECK-LABEL: fshl_i8_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $-128, %al
; CHECK-NEXT:    ret{{[l|q]}}
  %f = call i8 @llvm.fshl.i8(i8 255, i8 0, i8 7)
  ret i8 %f
}

; Repeat everything for funnel shift right.

; General case - all operands can be variables

define i32 @fshr_i32(i32 %x, i32 %y, i32 %z) nounwind {
; X86-SSE2-LABEL: fshr_i32:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 %z)
  ret i32 %f
}

; Verify that weird types are minimally supported.
declare i37 @llvm.fshr.i37(i37, i37, i37)
define i37 @fshr_i37(i37 %x, i37 %y, i37 %z) nounwind {
; X86-SSE2-LABEL: fshr_i37:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebx
; X86-SSE2-NEXT:    pushl %edi
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    andl $31, %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SSE2-NEXT:    shldl $27, %ebx, %esi
; X86-SSE2-NEXT:    pushl $0
; X86-SSE2-NEXT:    pushl $37
; X86-SSE2-NEXT:    pushl %eax
; X86-SSE2-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-SSE2-NEXT:    calll __umoddi3
; X86-SSE2-NEXT:    addl $16, %esp
; X86-SSE2-NEXT:    movl %eax, %ecx
; X86-SSE2-NEXT:    addl $27, %ecx
; X86-SSE2-NEXT:    testb $32, %cl
; X86-SSE2-NEXT:    je .LBB10_1
; X86-SSE2-NEXT:  # %bb.2:
; X86-SSE2-NEXT:    movl %edi, %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-SSE2-NEXT:    jmp .LBB10_3
; X86-SSE2-NEXT:  .LBB10_1:
; X86-SSE2-NEXT:    shll $27, %ebx
; X86-SSE2-NEXT:    movl %esi, %edx
; X86-SSE2-NEXT:    movl %ebx, %esi
; X86-SSE2-NEXT:  .LBB10_3:
; X86-SSE2-NEXT:    shrdl %cl, %edx, %esi
; X86-SSE2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-SSE2-NEXT:    shrdl %cl, %edi, %edx
; X86-SSE2-NEXT:    movl %esi, %eax
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    popl %edi
; X86-SSE2-NEXT:    popl %ebx
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i37:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movq %rdx, %rcx
; X64-AVX-NEXT:    movabsq $137438953471, %rax # imm = 0x1FFFFFFFFF
; X64-AVX-NEXT:    andq %rdx, %rax
; X64-AVX-NEXT:    movabsq $498560650640798693, %rdx # imm = 0x6EB3E45306EB3E5
; X64-AVX-NEXT:    mulq %rdx
; X64-AVX-NEXT:    leal (%rdx,%rdx,8), %eax
; X64-AVX-NEXT:    leal (%rdx,%rax,4), %eax
; X64-AVX-NEXT:    subl %eax, %ecx
; X64-AVX-NEXT:    addl $27, %ecx
; X64-AVX-NEXT:    shlq $27, %rsi
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-AVX-NEXT:    shrdq %cl, %rdi, %rsi
; X64-AVX-NEXT:    movq %rsi, %rax
; X64-AVX-NEXT:    retq
  %f = call i37 @llvm.fshr.i37(i37 %x, i37 %y, i37 %z)
  ret i37 %f
}

; extract(concat(0b1110000, 0b1111111) >> 2) = 0b0011111

declare i7 @llvm.fshr.i7(i7, i7, i7)
define i7 @fshr_i7_const_fold() nounwind {
; CHECK-LABEL: fshr_i7_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $31, %al
; CHECK-NEXT:    ret{{[l|q]}}
  %f = call i7 @llvm.fshr.i7(i7 112, i7 127, i7 2)
  ret i7 %f
}

; demanded bits tests

define i32 @fshl_i32_demandedbits(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_demandedbits:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl $9, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_demandedbits:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shldl $9, %esi, %eax
; X64-AVX-NEXT:    retq
  %x = or i32 %a0, 2147483648
  %y = or i32 %a1, 1
  %res = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 9)
  ret i32 %res
}

define i32 @fshr_i32_demandedbits(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_demandedbits:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl $9, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_demandedbits:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shldl $23, %esi, %eax
; X64-AVX-NEXT:    retq
  %x = or i32 %a0, 2147483648
  %y = or i32 %a1, 1
  %res = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 9)
  ret i32 %res
}

; undef handling

define i32 @fshl_i32_undef0(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_undef0:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl %cl, %eax, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_undef0:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 undef, i32 %a0, i32 %a1)
  ret i32 %res
}

define i32 @fshl_i32_undef0_msk(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_undef0_msk:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    andl $7, %ecx
; X86-SSE2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-SSE2-NEXT:    shldl %cl, %eax, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_undef0_msk:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    andl $7, %ecx
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %m = and i32 %a1, 7
  %res = call i32 @llvm.fshl.i32(i32 undef, i32 %a0, i32 %m)
  ret i32 %res
}

define i32 @fshl_i32_undef0_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshl_i32_undef0_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrl $23, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_undef0_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shrl $23, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 undef, i32 %a0, i32 9)
  ret i32 %res
}

define <4 x i32> @fshl_v4i32_undef0_cst(<4 x i32> %a0) nounwind {
; X86-SSE2-LABEL: fshl_v4i32_undef0_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $20, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    psrld $21, %xmm2
; X86-SSE2-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $22, %xmm1
; X86-SSE2-NEXT:    psrld $23, %xmm0
; X86-SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm2[0,3]
; X86-SSE2-NEXT:    retl
;
; X64-AVX2-LABEL: fshl_v4i32_undef0_cst:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-VBMI2-LABEL: fshl_v4i32_undef0_cst:
; X64-VBMI2:       # %bb.0:
; X64-VBMI2-NEXT:    vpshldvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-VBMI2-NEXT:    retq
  %res = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> undef, <4 x i32> %a0, <4 x i32> <i32 9, i32 10, i32 11, i32 12>)
  ret <4 x i32> %res
}

define i32 @fshl_i32_undef1(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_undef1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl %cl, %eax, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_undef1:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %eax, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 %a0, i32 undef, i32 %a1)
  ret i32 %res
}

define i32 @fshl_i32_undef1_msk(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_undef1_msk:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    andb $7, %cl
; X86-SSE2-NEXT:    shll %cl, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_undef1_msk:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    andb $7, %cl
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shll %cl, %eax
; X64-AVX-NEXT:    retq
  %m = and i32 %a1, 7
  %res = call i32 @llvm.fshl.i32(i32 %a0, i32 undef, i32 %m)
  ret i32 %res
}

define i32 @fshl_i32_undef1_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshl_i32_undef1_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shll $9, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_undef1_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shll $9, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 %a0, i32 undef, i32 9)
  ret i32 %res
}

define <4 x i32> @fshl_v4i32_undef1_cst(<4 x i32> %a0) nounwind {
; X86-SSE2-LABEL: fshl_v4i32_undef1_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_v4i32_undef1_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %a0, <4 x i32> undef, <4 x i32> <i32 9, i32 10, i32 11, i32 12>)
  ret <4 x i32> %res
}

define i32 @fshl_i32_undef2(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_undef2:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl %cl, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_undef2:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shldl %cl, %esi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 %a0, i32 %a1, i32 undef)
  ret i32 %res
}

define i32 @fshr_i32_undef0(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_undef0:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl %cl, %eax, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_undef0:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %eax, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 undef, i32 %a0, i32 %a1)
  ret i32 %res
}

define i32 @fshr_i32_undef0_msk(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_undef0_msk:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    andb $7, %cl
; X86-SSE2-NEXT:    shrl %cl, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_undef0_msk:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    andb $7, %cl
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrl %cl, %eax
; X64-AVX-NEXT:    retq
  %m = and i32 %a1, 7
  %res = call i32 @llvm.fshr.i32(i32 undef, i32 %a0, i32 %m)
  ret i32 %res
}

define i32 @fshr_i32_undef0_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshr_i32_undef0_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrl $9, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_undef0_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shrl $9, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 undef, i32 %a0, i32 9)
  ret i32 %res
}

define <4 x i32> @fshr_v4i32_undef0_cst(<4 x i32> %a0) nounwind {
; X86-SSE2-LABEL: fshr_v4i32_undef0_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $12, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    psrld $11, %xmm2
; X86-SSE2-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $10, %xmm1
; X86-SSE2-NEXT:    psrld $9, %xmm0
; X86-SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm2[0,3]
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_v4i32_undef0_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpsrlvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> undef, <4 x i32> %a0, <4 x i32> <i32 9, i32 10, i32 11, i32 12>)
  ret <4 x i32> %res
}

define i32 @fshr_i32_undef1(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_undef1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl %cl, %eax, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_undef1:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 %a0, i32 undef, i32 %a1)
  ret i32 %res
}

define i32 @fshr_i32_undef1_msk(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_undef1_msk:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    andl $7, %ecx
; X86-SSE2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-SSE2-NEXT:    shrdl %cl, %eax, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_undef1_msk:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    andl $7, %ecx
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %m = and i32 %a1, 7
  %res = call i32 @llvm.fshr.i32(i32 %a0, i32 undef, i32 %m)
  ret i32 %res
}

define i32 @fshr_i32_undef1_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshr_i32_undef1_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shll $23, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_undef1_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shll $23, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 %a0, i32 undef, i32 9)
  ret i32 %res
}

define <4 x i32> @fshr_v4i32_undef1_cst(<4 x i32> %a0) nounwind {
; X86-SSE2-LABEL: fshr_v4i32_undef1_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X86-SSE2-NEXT:    pmuludq {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X64-AVX2-LABEL: fshr_v4i32_undef1_cst:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpsllvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-VBMI2-LABEL: fshr_v4i32_undef1_cst:
; X64-VBMI2:       # %bb.0:
; X64-VBMI2-NEXT:    vpshrdvd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-VBMI2-NEXT:    retq
  %res = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %a0, <4 x i32> undef, <4 x i32> <i32 9, i32 10, i32 11, i32 12>)
  ret <4 x i32> %res
}

define i32 @fshr_i32_undef2(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_undef2:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl %cl, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_undef2:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shrdl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 %a0, i32 %a1, i32 undef)
  ret i32 %res
}

; shift zero args

define i32 @fshl_i32_zero0(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_zero0:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    xorl %eax, %eax
; X86-SSE2-NEXT:    shldl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_zero0:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    xorl %eax, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 0, i32 %a0, i32 %a1)
  ret i32 %res
}

define i32 @fshl_i32_zero0_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshl_i32_zero0_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrl $23, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_zero0_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shrl $23, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 0, i32 %a0, i32 9)
  ret i32 %res
}

define i32 @fshl_i32_zero1(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_zero1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    xorl %edx, %edx
; X86-SSE2-NEXT:    shldl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_zero1:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    xorl %edx, %edx
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %edx, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 %a0, i32 0, i32 %a1)
  ret i32 %res
}

define i32 @fshl_i32_zero1_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshl_i32_zero1_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shll $9, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_zero1_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shll $9, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 %a0, i32 0, i32 9)
  ret i32 %res
}

define i32 @fshr_i32_zero0(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_zero0:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    xorl %edx, %edx
; X86-SSE2-NEXT:    shrdl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_zero0:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    xorl %edx, %edx
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %edx, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 0, i32 %a0, i32 %a1)
  ret i32 %res
}

define i32 @fshr_i32_zero0_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshr_i32_zero0_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrl $9, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_zero0_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shrl $9, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 0, i32 %a0, i32 9)
  ret i32 %res
}

define i32 @fshr_i32_zero1(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_zero1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    xorl %eax, %eax
; X86-SSE2-NEXT:    shrdl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_zero1:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %ecx
; X64-AVX-NEXT:    xorl %eax, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 %a0, i32 0, i32 %a1)
  ret i32 %res
}

define i32 @fshr_i32_zero1_cst(i32 %a0) nounwind {
; X86-SSE2-LABEL: fshr_i32_zero1_cst:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shll $23, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_zero1_cst:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shll $23, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 %a0, i32 0, i32 9)
  ret i32 %res
}

; shift by zero

define i32 @fshl_i32_zero2(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshl_i32_zero2:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_zero2:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshl.i32(i32 %a0, i32 %a1, i32 0)
  ret i32 %res
}

define i32 @fshr_i32_zero2(i32 %a0, i32 %a1) nounwind {
; X86-SSE2-LABEL: fshr_i32_zero2:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_zero2:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    retq
  %res = call i32 @llvm.fshr.i32(i32 %a0, i32 %a1, i32 0)
  ret i32 %res
}

; With constant shift amount, this is 'shrd' or 'shld'.

define i32 @fshr_i32_const_shift(i32 %x, i32 %y) nounwind {
; X86-SSE2-LABEL: fshr_i32_const_shift:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl $9, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_const_shift:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shldl $23, %esi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 9)
  ret i32 %f
}

; Check modulo math on shift amount. 41-32=9, but right-shift may became left, so 32-9=23.

define i32 @fshr_i32_const_overshift(i32 %x, i32 %y) nounwind {
; X86-SSE2-LABEL: fshr_i32_const_overshift:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl $9, %ecx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_const_overshift:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    shldl $23, %esi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 41)
  ret i32 %f
}

; 64-bit should also work. 105-64 = 41, but right-shift became left, so 64-41=23.

define i64 @fshr_i64_const_overshift(i64 %x, i64 %y) nounwind {
; X86-SSE2-LABEL: fshr_i64_const_overshift:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl $9, %ecx, %eax
; X86-SSE2-NEXT:    shldl $23, %ecx, %edx
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i64_const_overshift:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movq %rdi, %rax
; X64-AVX-NEXT:    shldq $23, %rsi, %rax
; X64-AVX-NEXT:    retq
  %f = call i64 @llvm.fshr.i64(i64 %x, i64 %y, i64 105)
  ret i64 %f
}

; This should work without any node-specific logic.

define i8 @fshr_i8_const_fold() nounwind {
; CHECK-LABEL: fshr_i8_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $-2, %al
; CHECK-NEXT:    ret{{[l|q]}}
  %f = call i8 @llvm.fshr.i8(i8 255, i8 0, i8 7)
  ret i8 %f
}

define i32 @fshl_i32_shift_by_bitwidth(i32 %x, i32 %y) nounwind {
; X86-SSE2-LABEL: fshl_i32_shift_by_bitwidth:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshl_i32_shift_by_bitwidth:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 32)
  ret i32 %f
}

define i32 @fshr_i32_shift_by_bitwidth(i32 %x, i32 %y) nounwind {
; X86-SSE2-LABEL: fshr_i32_shift_by_bitwidth:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_i32_shift_by_bitwidth:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    retq
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 32)
  ret i32 %f
}

define <4 x i32> @fshl_v4i32_shift_by_bitwidth(<4 x i32> %x, <4 x i32> %y) nounwind {
; CHECK-LABEL: fshl_v4i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

define <4 x i32> @fshr_v4i32_shift_by_bitwidth(<4 x i32> %x, <4 x i32> %y) nounwind {
; X86-SSE2-LABEL: fshr_v4i32_shift_by_bitwidth:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movaps %xmm1, %xmm0
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: fshr_v4i32_shift_by_bitwidth:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %xmm1, %xmm0
; X64-AVX-NEXT:    retq
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

%struct.S = type { [11 x i8], i8 }
define void @PR45265(i32 %0, ptr nocapture readonly %1) nounwind {
; X86-SSE2-LABEL: PR45265:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %edi
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    leal (%eax,%eax,2), %esi
; X86-SSE2-NEXT:    movzwl 8(%ecx,%esi,4), %edx
; X86-SSE2-NEXT:    movl 4(%ecx,%esi,4), %edi
; X86-SSE2-NEXT:    shrdl $8, %edx, %edi
; X86-SSE2-NEXT:    xorl %eax, %edi
; X86-SSE2-NEXT:    sarl $31, %eax
; X86-SSE2-NEXT:    movzbl 10(%ecx,%esi,4), %ecx
; X86-SSE2-NEXT:    shll $16, %ecx
; X86-SSE2-NEXT:    orl %edx, %ecx
; X86-SSE2-NEXT:    shll $8, %ecx
; X86-SSE2-NEXT:    movl %ecx, %edx
; X86-SSE2-NEXT:    sarl $8, %edx
; X86-SSE2-NEXT:    sarl $31, %ecx
; X86-SSE2-NEXT:    shldl $24, %edx, %ecx
; X86-SSE2-NEXT:    xorl %eax, %ecx
; X86-SSE2-NEXT:    orl %ecx, %edi
; X86-SSE2-NEXT:    jne .LBB50_1
; X86-SSE2-NEXT:  # %bb.2:
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    popl %edi
; X86-SSE2-NEXT:    jmp _Z3foov # TAILCALL
; X86-SSE2-NEXT:  .LBB50_1:
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    popl %edi
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: PR45265:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movslq %edi, %rax
; X64-AVX-NEXT:    leaq (%rax,%rax,2), %rcx
; X64-AVX-NEXT:    movsbq 10(%rsi,%rcx,4), %rdx
; X64-AVX-NEXT:    shlq $16, %rdx
; X64-AVX-NEXT:    movzwl 8(%rsi,%rcx,4), %edi
; X64-AVX-NEXT:    orq %rdx, %rdi
; X64-AVX-NEXT:    movq (%rsi,%rcx,4), %rcx
; X64-AVX-NEXT:    shrdq $40, %rdi, %rcx
; X64-AVX-NEXT:    cmpq %rax, %rcx
; X64-AVX-NEXT:    je _Z3foov # TAILCALL
; X64-AVX-NEXT:  # %bb.1:
; X64-AVX-NEXT:    retq
  %3 = sext i32 %0 to i64
  %4 = getelementptr inbounds %struct.S, ptr %1, i64 %3
  %5 = bitcast ptr %4 to ptr
  %6 = load i88, ptr %5, align 1
  %7 = ashr i88 %6, 40
  %8 = trunc i88 %7 to i64
  %9 = icmp eq i64 %8, %3
  br i1 %9, label %10, label %11

10:
  tail call void @_Z3foov()
  br label %11

11:
  ret void
}
declare dso_local void @_Z3foov()

define i32 @or_shl_fshl(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_shl_fshl:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl %edx, %esi
; X86-SSE2-NEXT:    shll %cl, %esi
; X86-SSE2-NEXT:    shldl %cl, %edx, %eax
; X86-SSE2-NEXT:    orl %esi, %eax
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_shl_fshl:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shll %cl, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %esi, %edi
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_shl_rotl(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_shl_rotl:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    shll %cl, %edx
; X86-SSE2-NEXT:    roll %cl, %eax
; X86-SSE2-NEXT:    orl %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_shl_rotl:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shll %cl, %edi
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    roll %cl, %eax
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shx = shl i32 %x, %s
  %rot = call i32 @llvm.fshl.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %rot, %shx
  ret i32 %or
}

define i32 @or_shl_fshl_commute(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_shl_fshl_commute:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl %edx, %esi
; X86-SSE2-NEXT:    shll %cl, %esi
; X86-SSE2-NEXT:    shldl %cl, %edx, %eax
; X86-SSE2-NEXT:    orl %esi, %eax
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_shl_fshl_commute:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shll %cl, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %esi, %edi
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}

define i32 @or_shl_rotl_commute(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_shl_rotl_commute:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    shll %cl, %edx
; X86-SSE2-NEXT:    roll %cl, %eax
; X86-SSE2-NEXT:    orl %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_shl_rotl_commute:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shll %cl, %edi
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    roll %cl, %eax
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shx = shl i32 %x, %s
  %rot = call i32 @llvm.fshl.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %shx, %rot
  ret i32 %or
}

define i32 @or_lshr_fshr(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_lshr_fshr:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl %edx, %esi
; X86-SSE2-NEXT:    shrl %cl, %esi
; X86-SSE2-NEXT:    shrdl %cl, %edx, %eax
; X86-SSE2-NEXT:    orl %esi, %eax
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_lshr_fshr:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shrl %cl, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %esi, %edi
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_lshr_rotr(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_lshr_rotr:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    shrl %cl, %edx
; X86-SSE2-NEXT:    rorl %cl, %eax
; X86-SSE2-NEXT:    orl %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_lshr_rotr:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shrl %cl, %edi
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    rorl %cl, %eax
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shx = lshr i32 %x, %s
  %rot = call i32 @llvm.fshr.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %rot, %shx
  ret i32 %or
}

define i32 @or_lshr_fshr_commute(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_lshr_fshr_commute:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl %edx, %esi
; X86-SSE2-NEXT:    shrl %cl, %esi
; X86-SSE2-NEXT:    shrdl %cl, %edx, %eax
; X86-SSE2-NEXT:    orl %esi, %eax
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_lshr_fshr_commute:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shrl %cl, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %esi, %edi
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}

define i32 @or_lshr_rotr_commute(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_lshr_rotr_commute:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    shrl %cl, %edx
; X86-SSE2-NEXT:    rorl %cl, %eax
; X86-SSE2-NEXT:    orl %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_lshr_rotr_commute:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    shrl %cl, %edi
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    rorl %cl, %eax
; X64-AVX-NEXT:    orl %edi, %eax
; X64-AVX-NEXT:    retq
  %shx = lshr i32 %x, %s
  %rot = call i32 @llvm.fshr.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %shx, %rot
  ret i32 %or
}

define i32 @or_shl_fshl_simplify(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_shl_fshl_simplify:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shldl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_shl_fshl_simplify:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shldl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_lshr_fshr_simplify(i32 %x, i32 %y, i32 %s) nounwind {
; X86-SSE2-LABEL: or_lshr_fshr_simplify:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    shrdl %cl, %edx, %eax
; X86-SSE2-NEXT:    retl
;
; X64-AVX-LABEL: or_lshr_fshr_simplify:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movl %edx, %ecx
; X64-AVX-NEXT:    movl %esi, %eax
; X64-AVX-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-AVX-NEXT:    shrdl %cl, %edi, %eax
; X64-AVX-NEXT:    retq
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}
