/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.abi.AbiClass;
import org.jetbrains.kotlin.library.abi.AbiClassKind;
import org.jetbrains.kotlin.library.abi.AbiClassifierReference;
import org.jetbrains.kotlin.library.abi.AbiCompoundName;
import org.jetbrains.kotlin.library.abi.AbiDeclaration;
import org.jetbrains.kotlin.library.abi.AbiDeclarationContainer;
import org.jetbrains.kotlin.library.abi.AbiDeclarationWithModality;
import org.jetbrains.kotlin.library.abi.AbiEnumEntry;
import org.jetbrains.kotlin.library.abi.AbiFunction;
import org.jetbrains.kotlin.library.abi.AbiModality;
import org.jetbrains.kotlin.library.abi.AbiProperty;
import org.jetbrains.kotlin.library.abi.AbiPropertyKind;
import org.jetbrains.kotlin.library.abi.AbiRenderingSettings;
import org.jetbrains.kotlin.library.abi.AbiSimpleName;
import org.jetbrains.kotlin.library.abi.AbiTopLevelDeclarations;
import org.jetbrains.kotlin.library.abi.AbiType;
import org.jetbrains.kotlin.library.abi.AbiTypeArgument;
import org.jetbrains.kotlin.library.abi.AbiTypeNullability;
import org.jetbrains.kotlin.library.abi.AbiTypeParameter;
import org.jetbrains.kotlin.library.abi.AbiTypeParametersContainer;
import org.jetbrains.kotlin.library.abi.AbiValueParameter;
import org.jetbrains.kotlin.library.abi.AbiValueParameterKind;
import org.jetbrains.kotlin.library.abi.AbiVariance;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryManifest;
import org.jetbrains.kotlin.library.abi.LibraryTarget;
import org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl;

@ExperimentalLibraryAbiReader
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0001\u0018\u0000 \u00162\u00020\u0001:\t\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl;", "", "libraryAbi", "Lorg/jetbrains/kotlin/library/abi/LibraryAbi;", "settings", "Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;", "output", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "<init>", "(Lorg/jetbrains/kotlin/library/abi/LibraryAbi;Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;Ljava/lang/Appendable;)V", "render", "", "printHeader", "Printer", "RenderedDeclarationContainerKind", "RenderedTopLevelDeclarations", "RenderedDeclaration", "RenderedClass", "RenderedEnumEntry", "RenderedProperty", "RenderedFunction", "Companion", "kotlin-util-klib-abi"})
@SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,455:1\n1#2:456\n1869#3,2:457\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl\n*L\n59#1:457,2\n*E\n"})
public final class AbiRendererImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryAbi libraryAbi;
    @NotNull
    private final AbiRenderingSettings settings;
    @NotNull
    private final Appendable output;

    public AbiRendererImpl(@NotNull LibraryAbi libraryAbi, @NotNull AbiRenderingSettings settings, @NotNull Appendable output2) {
        Intrinsics.checkNotNullParameter(libraryAbi, "libraryAbi");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(output2, "output");
        this.libraryAbi = libraryAbi;
        this.settings = settings;
        this.output = output2;
    }

    public final void render() {
        this.printHeader();
        if (this.settings.getRenderDeclarations()) {
            RenderedTopLevelDeclarations.INSTANCE.printNestedDeclarationsInProperOrder((AbiDeclarationContainer)this.libraryAbi.getTopLevelDeclarations(), new Printer(this.output, this.settings));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printHeader() {
        this.output.append(StringsKt.trimIndent("\n                // Rendering settings:\n                // - Signature version: " + this.settings.getRenderedSignatureVersion().getVersionNumber() + "\n                // - Show manifest properties: " + this.settings.getRenderManifest() + "\n                // - Show declarations: " + this.settings.getRenderDeclarations() + "\n               \n                // Library unique name: <" + this.libraryAbi.getUniqueName() + ">\n            ")).append('\n');
        if (this.settings.getRenderManifest()) {
            void $this$forEach$iv;
            Pair<String, Object> pair;
            Pair<String, Object> pair2;
            Pair<String, Object> pair3;
            Pair<String, String> pair4;
            Pair<String, String> pair5;
            Pair<String, void> pair6;
            Iterator it;
            Pair[] pairArray;
            int n2;
            Object object;
            Object platformTarget;
            LibraryManifest $this$printHeader_u24lambda_u249 = this.libraryAbi.getManifest();
            boolean bl = false;
            List nativeTargets = new ArrayList();
            List wasmTargets = new ArrayList();
            Object object2 = $this$printHeader_u24lambda_u249.getPlatformTargets().iterator();
            while (object2.hasNext()) {
                platformTarget = object2.next();
                object = platformTarget;
                if (object instanceof LibraryTarget.Native) {
                    ((Collection)nativeTargets).add(platformTarget);
                    continue;
                }
                if (object instanceof LibraryTarget.WASM) {
                    ((Collection)wasmTargets).add(platformTarget);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            Pair[] pairArray2 = object2 = new Pair[6];
            int n3 = 0;
            String string = $this$printHeader_u24lambda_u249.getPlatform();
            if (string != null) {
                String string2 = string;
                n2 = n3;
                pairArray = pairArray2;
                boolean bl2 = false;
                Pair<String, void> pair7 = TuplesKt.to("Platform", it);
                pairArray2 = pairArray;
                n3 = n2;
                pair6 = pair7;
            } else {
                pair6 = null;
            }
            pairArray2[n3] = pair6;
            it = object = nativeTargets;
            n2 = 1;
            pairArray = object2;
            boolean bl3 = false;
            boolean bl4 = !((Collection)((Object)it)).isEmpty();
            Pair[] pairArray3 = pairArray;
            int n4 = n2;
            Object object3 = platformTarget = bl4 ? object : null;
            if (platformTarget != null) {
                it = platformTarget;
                n2 = n4;
                pairArray = pairArray3;
                boolean bl5 = false;
                Pair<String, String> pair8 = TuplesKt.to("Native targets", CollectionsKt.joinToString$default((Iterable)((Object)it), ", ", null, null, 0, null, printHeader.1.3.1.INSTANCE, 30, null));
                pairArray3 = pairArray;
                n4 = n2;
                pair5 = pair8;
            } else {
                pair5 = null;
            }
            pairArray3[n4] = pair5;
            it = object = wasmTargets;
            n2 = 2;
            pairArray = object2;
            boolean bl6 = false;
            boolean bl7 = !((Collection)((Object)it)).isEmpty();
            Pair[] pairArray4 = pairArray;
            int n5 = n2;
            Object object4 = platformTarget = bl7 ? object : null;
            if (platformTarget != null) {
                it = platformTarget;
                n2 = n5;
                pairArray = pairArray4;
                boolean bl8 = false;
                Pair<String, String> pair9 = TuplesKt.to("WASM targets", CollectionsKt.joinToString$default((Iterable)((Object)it), ", ", null, null, 0, null, printHeader.1.5.1.INSTANCE, 30, null));
                pairArray4 = pairArray;
                n5 = n2;
                pair4 = pair9;
            } else {
                pair4 = null;
            }
            pairArray4[n5] = pair4;
            Pair[] pairArray5 = object2;
            int n6 = 3;
            String string3 = $this$printHeader_u24lambda_u249.getCompilerVersion();
            if (string3 != null) {
                it = string3;
                n2 = n6;
                pairArray = pairArray5;
                boolean bl9 = false;
                Pair<String, Object> pair10 = TuplesKt.to("Compiler version", it);
                pairArray5 = pairArray;
                n6 = n2;
                pair3 = pair10;
            } else {
                pair3 = null;
            }
            pairArray5[n6] = pair3;
            Pair[] pairArray6 = object2;
            int n7 = 4;
            String string4 = $this$printHeader_u24lambda_u249.getAbiVersion();
            if (string4 != null) {
                it = string4;
                n2 = n7;
                pairArray = pairArray6;
                boolean bl10 = false;
                Pair<String, Object> pair11 = TuplesKt.to("ABI version", it);
                pairArray6 = pairArray;
                n7 = n2;
                pair2 = pair11;
            } else {
                pair2 = null;
            }
            pairArray6[n7] = pair2;
            Pair[] pairArray7 = object2;
            int n8 = 5;
            String string5 = $this$printHeader_u24lambda_u249.getIrProviderName();
            if (string5 != null) {
                it = string5;
                n2 = n8;
                pairArray = pairArray7;
                boolean bl11 = false;
                Pair<String, Object> pair12 = TuplesKt.to("IR provider", it);
                pairArray7 = pairArray;
                n8 = n2;
                pair = pair12;
            } else {
                pair = null;
            }
            pairArray7[n8] = pair;
            object2 = CollectionsKt.listOfNotNull(object2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair13 = (Pair)element$iv;
                boolean bl12 = false;
                String name2 = (String)pair13.component1();
                String value2 = (String)pair13.component2();
                Appendable appendable = this.output.append("// ").append(name2).append(": ");
                Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
                appendable.append(value2).append('\n');
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JU\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0007\"\b\b\u0001\u0010\u0006*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u00070\u00052\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u0002H\u00060\tj\b\u0012\u0004\u0012\u0002H\u0006`\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\u00060\fH\u0082\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion;", "", "<init>", "()V", "mapAndSort", "", "R", "T", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "transform", "Lkotlin/Function1;", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,455:1\n1634#2,3:456\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n*L\n449#1:456,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0086\b\u00f8\u0001\u0000J\u001c\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "", "output", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "settings", "Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;", "<init>", "(Ljava/lang/Appendable;Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;)V", "indent", "Lkotlin/UInt;", "I", "indented", "", "block", "Lkotlin/Function0;", "printDeclaration", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "printOpeningBrace", "", "printClosingBrace", "appendIndent", "appendSignature", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "kotlin-util-klib-abi"})
    private static final class Printer {
        @NotNull
        private final Appendable output;
        @NotNull
        private final AbiRenderingSettings settings;
        private int indent;

        public Printer(@NotNull Appendable output2, @NotNull AbiRenderingSettings settings) {
            Intrinsics.checkNotNullParameter(output2, "output");
            Intrinsics.checkNotNullParameter(settings, "settings");
            this.output = output2;
            this.settings = settings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void indented(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, "block");
            boolean $i$f$indented = false;
            int n2 = this.indent;
            this.indent = UInt.constructor-impl(n2 + 1);
            try {
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart(1);
                n2 = this.indent;
                this.indent = UInt.constructor-impl(n2 + -1);
                InlineMarker.finallyEnd(1);
            }
        }

        public final void printDeclaration(@NotNull RenderedDeclaration<?> renderedDeclaration, boolean printOpeningBrace) {
            Intrinsics.checkNotNullParameter(renderedDeclaration, "renderedDeclaration");
            Appendable $this$printDeclaration_u24lambda_u240 = this.output;
            boolean bl = false;
            this.appendIndent();
            $this$printDeclaration_u24lambda_u240.append(renderedDeclaration.getText());
            if (printOpeningBrace) {
                $this$printDeclaration_u24lambda_u240.append(" {");
            }
            this.appendSignature((AbiDeclaration)renderedDeclaration.getDeclaration());
            $this$printDeclaration_u24lambda_u240.append('\n');
        }

        public static /* synthetic */ void printDeclaration$default(Printer printer, RenderedDeclaration renderedDeclaration, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            printer.printDeclaration(renderedDeclaration, bl);
        }

        public final void printClosingBrace() {
            Appendable $this$printClosingBrace_u24lambda_u241 = this.output;
            boolean bl = false;
            this.appendIndent();
            $this$printClosingBrace_u24lambda_u241.append('}').append('\n');
        }

        private final void appendIndent() {
            int n2 = 0;
            int n3 = this.indent;
            while (UnsignedKt.uintCompare(n2, n3) < 0) {
                int i2 = n2++;
                this.output.append(this.settings.getIndentationString());
            }
        }

        private final void appendSignature(AbiDeclaration declaration) {
            this.output.append(" // ");
            String string = declaration.getSignatures().get(this.settings.getRenderedSignatureVersion());
            if (string == null) {
                string = this.settings.getWhenSignatureNotFound().invoke(declaration, this.settings.getRenderedSignatureVersion());
            }
            this.output.append(string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiClass;", "declaration", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiClass;)V", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass\n+ 2 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer\n*L\n1#1,455:1\n70#2,7:456\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass\n*L\n270#1:456,7\n*E\n"})
    private static final class RenderedClass
    extends RenderedDeclaration<AbiClass> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        public RenderedClass(@NotNull AbiClass declaration) {
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedClass renderedClass = this;
            boolean bl = false;
            RenderedDeclaration.Companion.appendModalityOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            if (declaration.isInner()) {
                $this$_init__u24lambda_u240.append("inner ");
            }
            if (declaration.isValue()) {
                $this$_init__u24lambda_u240.append("value ");
            }
            if (declaration.isFunction()) {
                $this$_init__u24lambda_u240.append("fun ");
            }
            RenderedClass.Companion.appendClassKind((StringBuilder)$this$_init__u24lambda_u240, declaration.getKind());
            RenderedDeclaration.Companion.appendTypeParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            if (!((Collection)declaration.getSuperTypes()).isEmpty()) {
                RenderedDeclaration.Companion.appendSortedTypes((StringBuilder)$this$_init__u24lambda_u240, declaration.getSuperTypes(), ", ", " : ", "");
            }
            Unit unit = Unit.INSTANCE;
            super(abiDeclaration, stringBuilder.toString(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter(printer, "printer");
            boolean hasChildren = !((Collection)((AbiClass)this.getDeclaration()).getDeclarations()).isEmpty();
            printer.printDeclaration(this, hasChildren);
            if (hasChildren) {
                Printer this_$iv = printer;
                boolean $i$f$indented = false;
                int n2 = this_$iv.indent;
                this_$iv.indent = UInt.constructor-impl(n2 + 1);
                try {
                    boolean bl = false;
                    Companion.printNestedDeclarationsInProperOrder((AbiDeclarationContainer)this.getDeclaration(), printer);
                }
                finally {
                    n2 = this_$iv.indent;
                    this_$iv.indent = UInt.constructor-impl(n2 + -1);
                }
                printer.printClosingBrace();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u0006*\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass$Companion;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind;", "Lorg/jetbrains/kotlin/library/abi/AbiClass;", "<init>", "()V", "appendClassKind", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "classKind", "Lorg/jetbrains/kotlin/library/abi/AbiClassKind;", "orderByDeclarationKind", "", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "kotlin-util-klib-abi"})
        public static final class Companion
        extends RenderedDeclarationContainerKind<AbiClass> {
            private Companion() {
            }

            private final void appendClassKind(StringBuilder $this$appendClassKind, AbiClassKind classKind) {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[classKind.ordinal()]) {
                    case 1: {
                        string = "class";
                        break;
                    }
                    case 2: {
                        string = "interface";
                        break;
                    }
                    case 3: {
                        string = "object";
                        break;
                    }
                    case 4: {
                        string = "enum class";
                        break;
                    }
                    case 5: {
                        string = "annotation class";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$appendClassKind.append(string).append(' ');
            }

            @Override
            protected int orderByDeclarationKind(@NotNull RenderedDeclaration<?> renderedDeclaration) {
                int n2;
                Intrinsics.checkNotNullParameter(renderedDeclaration, "renderedDeclaration");
                Object declaration = renderedDeclaration.getDeclaration();
                if (declaration instanceof AbiProperty) {
                    n2 = 1;
                } else if (declaration instanceof AbiFunction) {
                    n2 = ((AbiFunction)declaration).isConstructor() ? 2 : 3;
                } else if (declaration instanceof AbiClass) {
                    n2 = 4;
                } else if (declaration instanceof AbiEnumEntry) {
                    n2 = 5;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return n2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[AbiClassKind.values().length];
                    try {
                        nArray[AbiClassKind.CLASS.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.INTERFACE.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.OBJECT.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.ENUM_CLASS.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.ANNOTATION_CLASS.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0018B\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u0082\u0001\u0004\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "T", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "", "declaration", "text", "", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;Ljava/lang/String;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "getText", "()Ljava/lang/String;", "additionalOrderingFactor1", "", "getAdditionalOrderingFactor1", "()I", "additionalOrderingFactor2", "getAdditionalOrderingFactor2", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedEnumEntry;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty;", "kotlin-util-klib-abi"})
    private static abstract class RenderedDeclaration<T extends AbiDeclaration> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final T declaration;
        @NotNull
        private final String text;

        private RenderedDeclaration(T declaration, String text) {
            this.declaration = declaration;
            this.text = text;
        }

        @NotNull
        public final T getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public int getAdditionalOrderingFactor1() {
            return 0;
        }

        @NotNull
        public String getAdditionalOrderingFactor2() {
            return "";
        }

        public abstract void print(@NotNull Printer var1);

        public /* synthetic */ RenderedDeclaration(AbiDeclaration declaration, String text, DefaultConstructorMarker $constructor_marker) {
            this(declaration, text);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0006\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u0012*\u00060\nj\u0002`\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u0012*\u00060\nj\u0002`\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J4\u0010\u001e\u001a\u00020\t*\u00060\nj\u0002`\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170 2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration$Companion;", "", "<init>", "()V", "createFor", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "appendModalityOf", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/kotlin/library/abi/AbiDeclarationWithModality;", "appendNameOf", "appendTypeParametersOf", "container", "Lorg/jetbrains/kotlin/library/abi/AbiTypeParametersContainer;", "appendTypeParameter", "", "typeParameter", "Lorg/jetbrains/kotlin/library/abi/AbiTypeParameter;", "appendType", "type", "Lorg/jetbrains/kotlin/library/abi/AbiType;", "appendTypeArgument", "typeArgument", "Lorg/jetbrains/kotlin/library/abi/AbiTypeArgument;", "appendVariance", "variance", "Lorg/jetbrains/kotlin/library/abi/AbiVariance;", "appendSortedTypes", "types", "", "separator", "prefix", "postfix", "kotlin-util-klib-abi"})
        @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration$Companion\n+ 2 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n446#2,4:456\n450#2,2:464\n1634#3,2:460\n1636#3:463\n1#4:462\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration$Companion\n*L\n241#1:456,4\n241#1:464,2\n241#1:460,2\n241#1:463\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RenderedDeclaration<?> createFor(@NotNull AbiDeclaration declaration) {
                RenderedDeclaration renderedDeclaration;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                AbiDeclaration abiDeclaration = declaration;
                if (abiDeclaration instanceof AbiFunction) {
                    renderedDeclaration = new RenderedFunction((AbiFunction)declaration);
                } else if (abiDeclaration instanceof AbiProperty) {
                    renderedDeclaration = new RenderedProperty((AbiProperty)declaration);
                } else if (abiDeclaration instanceof AbiClass) {
                    renderedDeclaration = new RenderedClass((AbiClass)declaration);
                } else if (abiDeclaration instanceof AbiEnumEntry) {
                    renderedDeclaration = new RenderedEnumEntry((AbiEnumEntry)declaration);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return renderedDeclaration;
            }

            public final void appendModalityOf(@NotNull StringBuilder $this$appendModalityOf, @NotNull AbiDeclarationWithModality declaration) {
                Intrinsics.checkNotNullParameter($this$appendModalityOf, "<this>");
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                String string = declaration.getModality().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                $this$appendModalityOf.append(string).append(' ');
            }

            public final void appendNameOf(@NotNull StringBuilder $this$appendNameOf, @NotNull AbiDeclaration declaration) {
                Intrinsics.checkNotNullParameter($this$appendNameOf, "<this>");
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                boolean isTopLevel = AbiCompoundName.getNameSegmentsCount-impl(declaration.getQualifiedName().getRelativeName-l9-qHIQ()) == 1;
                $this$appendNameOf.append(isTopLevel ? (Comparable)declaration.getQualifiedName() : AbiSimpleName.box-impl(AbiCompoundName.getSimpleName-t-3xSXQ(declaration.getQualifiedName().getRelativeName-l9-qHIQ())));
            }

            public final void appendTypeParametersOf(@NotNull StringBuilder $this$appendTypeParametersOf, @NotNull AbiTypeParametersContainer container) {
                Intrinsics.checkNotNullParameter($this$appendTypeParametersOf, "<this>");
                Intrinsics.checkNotNullParameter(container, "container");
                if (!((Collection)container.getTypeParameters()).isEmpty()) {
                    CollectionsKt.joinTo$default(container.getTypeParameters(), $this$appendTypeParametersOf, ", ", "<", ">", 0, null, arg_0 -> Companion.appendTypeParametersOf$lambda$0($this$appendTypeParametersOf, arg_0), 48, null);
                    $this$appendTypeParametersOf.append(' ');
                }
            }

            private final String appendTypeParameter(StringBuilder $this$appendTypeParameter, AbiTypeParameter typeParameter) {
                $this$appendTypeParameter.append('#').append(typeParameter.getTag()).append(": ");
                if (typeParameter.isReified()) {
                    $this$appendTypeParameter.append("reified ");
                }
                this.appendVariance($this$appendTypeParameter, typeParameter.getVariance());
                switch (typeParameter.getUpperBounds().size()) {
                    case 0: {
                        $this$appendTypeParameter.append("kotlin/Any?");
                        break;
                    }
                    case 1: {
                        this.appendType($this$appendTypeParameter, typeParameter.getUpperBounds().get(0));
                        break;
                    }
                    default: {
                        this.appendSortedTypes($this$appendTypeParameter, typeParameter.getUpperBounds(), " & ", "", "");
                    }
                }
                return "";
            }

            public final void appendType(@NotNull StringBuilder $this$appendType, @NotNull AbiType type) {
                block13: {
                    Object object;
                    AbiType abiType;
                    block11: {
                        block14: {
                            AbiClassifierReference classifier;
                            block12: {
                                Intrinsics.checkNotNullParameter($this$appendType, "<this>");
                                Intrinsics.checkNotNullParameter(type, "type");
                                abiType = type;
                                if (!(abiType instanceof AbiType.Simple)) break block11;
                                classifier = ((AbiType.Simple)type).getClassifierReference();
                                if (!(classifier instanceof AbiClassifierReference.ClassReference)) break block12;
                                $this$appendType.append(((AbiClassifierReference.ClassReference)classifier).getClassName());
                                if (!((Collection)((AbiType.Simple)type).getArguments()).isEmpty()) {
                                    CollectionsKt.joinTo$default(((AbiType.Simple)type).getArguments(), $this$appendType, ", ", "<", ">", 0, null, arg_0 -> Companion.appendType$lambda$1($this$appendType, arg_0), 48, null);
                                }
                                if (((AbiType.Simple)type).getNullability() == AbiTypeNullability.MARKED_NULLABLE) {
                                    $this$appendType.append('?');
                                }
                                object = Unit.INSTANCE;
                                break block13;
                            }
                            if (!(classifier instanceof AbiClassifierReference.TypeParameterReference)) break block14;
                            $this$appendType.append('#').append(((AbiClassifierReference.TypeParameterReference)classifier).getTag());
                            switch (WhenMappings.$EnumSwitchMapping$0[((AbiType.Simple)type).getNullability().ordinal()]) {
                                case 1: {
                                    object = $this$appendType.append('?');
                                    break block13;
                                }
                                case 2: {
                                    object = Unit.INSTANCE;
                                    break block13;
                                }
                                case 3: {
                                    object = $this$appendType.append("!!");
                                    break block13;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    if (abiType instanceof AbiType.Dynamic) {
                        object = $this$appendType.append("dynamic");
                    } else if (abiType instanceof AbiType.Error) {
                        object = $this$appendType.append("error");
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            private final String appendTypeArgument(StringBuilder $this$appendTypeArgument, AbiTypeArgument typeArgument) {
                AbiTypeArgument abiTypeArgument = typeArgument;
                if (abiTypeArgument instanceof AbiTypeArgument.StarProjection) {
                    $this$appendTypeArgument.append('*');
                } else if (abiTypeArgument instanceof AbiTypeArgument.TypeProjection) {
                    this.appendVariance($this$appendTypeArgument, ((AbiTypeArgument.TypeProjection)typeArgument).getVariance());
                    this.appendType($this$appendTypeArgument, ((AbiTypeArgument.TypeProjection)typeArgument).getType());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return "";
            }

            private final void appendVariance(StringBuilder $this$appendVariance, AbiVariance variance) {
                switch (WhenMappings.$EnumSwitchMapping$1[variance.ordinal()]) {
                    case 1: {
                        Object object = Unit.INSTANCE;
                        break;
                    }
                    case 2: {
                        Object object = $this$appendVariance.append("in ");
                        break;
                    }
                    case 3: {
                        Object object = $this$appendVariance.append("out ");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void appendSortedTypes(@NotNull StringBuilder $this$appendSortedTypes, @NotNull List<? extends AbiType> types2, @NotNull String separator, @NotNull String prefix, @NotNull String postfix) {
                List list;
                void $this$mapAndSort$iv;
                Intrinsics.checkNotNullParameter($this$appendSortedTypes, "<this>");
                Intrinsics.checkNotNullParameter(types2, "types");
                Intrinsics.checkNotNullParameter(separator, "separator");
                Intrinsics.checkNotNullParameter(prefix, "prefix");
                Intrinsics.checkNotNullParameter(postfix, "postfix");
                org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl$Companion companion = AbiRendererImpl.Companion;
                List<? extends AbiType> list2 = types2;
                Comparator comparator$iv = ComparisonsKt.naturalOrder();
                boolean $i$f$mapAndSort = false;
                if ($this$mapAndSort$iv.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else {
                    ArrayList result$iv = new ArrayList($this$mapAndSort$iv.size());
                    Iterable $this$mapTo$iv$iv = (Iterable)$this$mapAndSort$iv;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StringBuilder stringBuilder;
                        AbiType abiType = (AbiType)item$iv$iv;
                        Collection collection = result$iv;
                        boolean bl = false;
                        StringBuilder $this$appendSortedTypes_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
                        boolean bl2 = false;
                        Companion.appendType($this$appendSortedTypes_u24lambda_u243_u24lambda_u242, (AbiType)it);
                        collection.add(stringBuilder.toString());
                    }
                    CollectionsKt.sortWith(result$iv, comparator$iv);
                    list = result$iv;
                }
                CollectionsKt.joinTo$default(list, $this$appendSortedTypes, separator, prefix, postfix, 0, null, null, 112, null);
            }

            private static final CharSequence appendTypeParametersOf$lambda$0(StringBuilder $this_appendTypeParametersOf, AbiTypeParameter typeParameter) {
                Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
                return Companion.appendTypeParameter($this_appendTypeParametersOf, typeParameter);
            }

            private static final CharSequence appendType$lambda$1(StringBuilder $this_appendType, AbiTypeArgument typeArgument) {
                Intrinsics.checkNotNullParameter(typeArgument, "typeArgument");
                return Companion.appendTypeArgument($this_appendType, typeArgument);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;
                public static final /* synthetic */ int[] $EnumSwitchMapping$1;

                static {
                    int[] nArray = new int[AbiTypeNullability.values().length];
                    try {
                        nArray[AbiTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                    nArray = new int[AbiVariance.values().length];
                    try {
                        nArray[AbiVariance.INVARIANT.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiVariance.IN.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiVariance.OUT.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$1 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH$J\u001b\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind;", "T", "Lorg/jetbrains/kotlin/library/abi/AbiDeclarationContainer;", "", "<init>", "()V", "orderByDeclarationKind", "", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "printNestedDeclarationsInProperOrder", "", "container", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "(Lorg/jetbrains/kotlin/library/abi/AbiDeclarationContainer;Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;)V", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind\n+ 2 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,455:1\n446#2,4:456\n450#2,2:463\n1634#3,3:460\n1869#3,2:465\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind\n*L\n112#1:456,4\n112#1:463,2\n112#1:460,3\n130#1:465,2\n*E\n"})
    private static abstract class RenderedDeclarationContainerKind<T extends AbiDeclarationContainer> {
        protected abstract int orderByDeclarationKind(@NotNull RenderedDeclaration<?> var1);

        /*
         * WARNING - void declaration
         */
        public final void printNestedDeclarationsInProperOrder(@NotNull T container, @NotNull Printer printer) {
            List list;
            void $this$mapAndSort$iv;
            Intrinsics.checkNotNullParameter(container, "container");
            Intrinsics.checkNotNullParameter(printer, "printer");
            Companion companion = Companion;
            List<AbiDeclaration> list2 = container.getDeclarations();
            Object object = new Function1[]{new Function1<RenderedDeclaration<?>, Integer>(this){

                public final Integer invoke(RenderedDeclaration<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((RenderedDeclarationContainerKind)this.receiver).orderByDeclarationKind(p0);
                }
            }, RenderedDeclarationContainerKind::printNestedDeclarationsInProperOrder$lambda$0, printNestedDeclarationsInProperOrder.3.INSTANCE, printNestedDeclarationsInProperOrder.4.INSTANCE, printNestedDeclarationsInProperOrder.5.INSTANCE};
            object = ComparisonsKt.compareBy(object);
            RenderedDeclaration.Companion companion2 = RenderedDeclaration.Companion;
            boolean $i$f$mapAndSort = false;
            if ($this$mapAndSort$iv.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                void comparator$iv;
                ArrayList result$iv = new ArrayList($this$mapAndSort$iv.size());
                Iterable $this$mapTo$iv$iv = (Iterable)$this$mapAndSort$iv;
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    AbiDeclaration abiDeclaration = (AbiDeclaration)item$iv$iv;
                    Collection collection = result$iv;
                    boolean bl = false;
                    collection.add(companion2.createFor((AbiDeclaration)p0));
                }
                CollectionsKt.sortWith(result$iv, comparator$iv);
                list = result$iv;
            }
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RenderedDeclaration it = (RenderedDeclaration)element$iv;
                boolean bl = false;
                it.print(printer);
            }
        }

        private static final Comparable printNestedDeclarationsInProperOrder$lambda$0(RenderedDeclaration it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getDeclaration().getQualifiedName();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedEnumEntry;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiEnumEntry;", "declaration", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiEnumEntry;)V", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "kotlin-util-klib-abi"})
    private static final class RenderedEnumEntry
    extends RenderedDeclaration<AbiEnumEntry> {
        /*
         * WARNING - void declaration
         */
        public RenderedEnumEntry(@NotNull AbiEnumEntry declaration) {
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedEnumEntry renderedEnumEntry = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.append("enum entry ");
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            Unit unit = Unit.INSTANCE;
            super(abiDeclaration, stringBuilder.toString(), null);
        }

        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter(printer, "printer");
            Printer.printDeclaration$default(printer, this, false, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "declaration", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiFunction;)V", "additionalOrderingFactor1", "", "getAdditionalOrderingFactor1", "()I", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,455:1\n1869#2,2:456\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction\n*L\n387#1:456,2\n*E\n"})
    private static final class RenderedFunction
    extends RenderedDeclaration<AbiFunction> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        public RenderedFunction(@NotNull AbiFunction declaration) {
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedFunction renderedFunction = this;
            boolean bl = false;
            if (!declaration.isConstructor() || declaration.getModality() != AbiModality.FINAL) {
                RenderedDeclaration.Companion.appendModalityOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            }
            if (declaration.isSuspend()) {
                $this$_init__u24lambda_u240.append("suspend ");
            }
            if (declaration.isInline()) {
                $this$_init__u24lambda_u240.append("inline ");
            }
            $this$_init__u24lambda_u240.append(declaration.isConstructor() ? "constructor " : "fun ");
            RenderedDeclaration.Companion.appendTypeParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedFunction.Companion.appendIrregularValueParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedFunction.Companion.appendRegularValueParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedFunction.Companion.appendReturnTypeOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            Unit unit = Unit.INSTANCE;
            super(abiDeclaration, stringBuilder.toString(), null);
        }

        @Override
        public int getAdditionalOrderingFactor1() {
            int extensionReceivers = 0;
            int contextParameters = 0;
            int regularParameters = 0;
            Iterable $this$forEach$iv = ((AbiFunction)this.getDeclaration()).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbiValueParameter valueParameter2 = (AbiValueParameter)element$iv;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[valueParameter2.getKind().ordinal()]) {
                    case 1: {
                        int n2 = contextParameters;
                        contextParameters = n2 + 1;
                        break;
                    }
                    case 2: {
                        int n2 = extensionReceivers;
                        extensionReceivers = n2 + 1;
                        break;
                    }
                    case 3: {
                        int n2 = regularParameters;
                        regularParameters = n2 + 1;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return (contextParameters << 1 | extensionReceivers) << 8 | regularParameters;
        }

        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter(printer, "printer");
            Printer.printDeclaration$default(printer, this, false, 2, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\f*\u00060\u0006j\u0002`\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction$Companion;", "", "<init>", "()V", "appendIrregularValueParametersOf", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "function", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "appendRegularValueParametersOf", "appendValueParameter", "", "valueParameter", "Lorg/jetbrains/kotlin/library/abi/AbiValueParameter;", "appendReturnTypeOf", "kotlin-util-klib-abi"})
        @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n774#2:456\n865#2,2:457\n295#2,2:459\n774#2:461\n865#2,2:462\n1#3:464\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction$Companion\n*L\n402#1:456\n402#1:457,2\n403#1:459,2\n423#1:461\n423#1:462,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private final void appendIrregularValueParametersOf(StringBuilder $this$appendIrregularValueParametersOf, AbiFunction function2) {
                Object v0;
                List contextParameters;
                block6: {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = function2.getValueParameters();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        AbiValueParameter it = (AbiValueParameter)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getKind() == AbiValueParameterKind.CONTEXT)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    contextParameters = (List)destination$iv$iv;
                    Iterable $this$firstOrNull$iv = function2.getValueParameters();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AbiValueParameter it = (AbiValueParameter)element$iv;
                        boolean bl = false;
                        if (!(it.getKind() == AbiValueParameterKind.EXTENSION_RECEIVER)) continue;
                        v0 = element$iv;
                        break block6;
                    }
                    v0 = null;
                }
                AbiValueParameter extensionReceiver = v0;
                if (contextParameters.isEmpty() && extensionReceiver == null) {
                    return;
                }
                $this$appendIrregularValueParametersOf.append("(");
                if (!((Collection)contextParameters).isEmpty()) {
                    CollectionsKt.joinTo$default(contextParameters, $this$appendIrregularValueParametersOf, ", ", "context(", ")", 0, null, arg_0 -> Companion.appendIrregularValueParametersOf$lambda$2($this$appendIrregularValueParametersOf, arg_0), 48, null);
                    if (extensionReceiver != null) {
                        $this$appendIrregularValueParametersOf.append(", ");
                    }
                }
                if (extensionReceiver != null) {
                    $this$appendIrregularValueParametersOf.append(this.appendValueParameter($this$appendIrregularValueParametersOf, extensionReceiver));
                }
                $this$appendIrregularValueParametersOf.append(").");
            }

            /*
             * WARNING - void declaration
             */
            private final void appendRegularValueParametersOf(StringBuilder $this$appendRegularValueParametersOf, AbiFunction function2) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = function2.getValueParameters();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    AbiValueParameter it = (AbiValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getKind() == AbiValueParameterKind.REGULAR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                CollectionsKt.joinTo$default((List)destination$iv$iv, $this$appendRegularValueParametersOf, ", ", "(", ")", 0, null, arg_0 -> Companion.appendRegularValueParametersOf$lambda$4($this$appendRegularValueParametersOf, arg_0), 48, null);
            }

            private final String appendValueParameter(StringBuilder $this$appendValueParameter, AbiValueParameter valueParameter2) {
                if (valueParameter2.isNoinline()) {
                    $this$appendValueParameter.append("noinline ");
                }
                if (valueParameter2.isCrossinline()) {
                    $this$appendValueParameter.append("crossinline ");
                }
                RenderedDeclaration.Companion.appendType($this$appendValueParameter, valueParameter2.getType());
                if (valueParameter2.isVararg()) {
                    $this$appendValueParameter.append("...");
                }
                if (valueParameter2.getHasDefaultArg()) {
                    $this$appendValueParameter.append(" = ...");
                }
                return "";
            }

            private final void appendReturnTypeOf(StringBuilder $this$appendReturnTypeOf, AbiFunction function2) {
                block0: {
                    AbiType abiType = function2.getReturnType();
                    if (abiType == null) break block0;
                    AbiType returnType = abiType;
                    boolean bl = false;
                    StringBuilder stringBuilder = $this$appendReturnTypeOf.append(": ");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
                    RenderedDeclaration.Companion.appendType(stringBuilder, returnType);
                }
            }

            private static final CharSequence appendIrregularValueParametersOf$lambda$2(StringBuilder $this_appendIrregularValueParametersOf, AbiValueParameter it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Companion.appendValueParameter($this_appendIrregularValueParametersOf, it);
            }

            private static final CharSequence appendRegularValueParametersOf$lambda$4(StringBuilder $this_appendRegularValueParametersOf, AbiValueParameter valueParameter2) {
                Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
                return Companion.appendValueParameter($this_appendRegularValueParametersOf, valueParameter2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AbiValueParameterKind.values().length];
                try {
                    nArray[AbiValueParameterKind.CONTEXT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AbiValueParameterKind.EXTENSION_RECEIVER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AbiValueParameterKind.REGULAR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiProperty;", "declaration", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiProperty;)V", "getter", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction;", "setter", "additionalOrderingFactor1", "", "getAdditionalOrderingFactor1", "()I", "additionalOrderingFactor2", "", "getAdditionalOrderingFactor2", "()Ljava/lang/String;", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer\n*L\n1#1,455:1\n1#2:456\n70#3,7:457\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty\n*L\n341#1:457,7\n*E\n"})
    private static final class RenderedProperty
    extends RenderedDeclaration<AbiProperty> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final RenderedFunction getter;
        @Nullable
        private final RenderedFunction setter;

        /*
         * WARNING - void declaration
         */
        public RenderedProperty(@NotNull AbiProperty declaration) {
            RenderedFunction renderedFunction;
            RenderedFunction renderedFunction2;
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedProperty renderedProperty = this;
            boolean bl2 = false;
            RenderedDeclaration.Companion.appendModalityOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedProperty.Companion.appendPropertyKind((StringBuilder)$this$_init__u24lambda_u240, declaration.getKind());
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            Unit unit = Unit.INSTANCE;
            super(abiDeclaration, stringBuilder.toString(), null);
            RenderedProperty renderedProperty2 = this;
            AbiFunction abiFunction = declaration.getGetter();
            if (abiFunction != null) {
                void p0;
                AbiFunction bl2 = abiFunction;
                renderedProperty = renderedProperty2;
                boolean bl3 = false;
                renderedFunction2 = new RenderedFunction((AbiFunction)p0);
                renderedProperty2 = renderedProperty;
            } else {
                renderedFunction2 = null;
            }
            renderedProperty2.getter = renderedFunction2;
            RenderedProperty renderedProperty3 = this;
            AbiFunction abiFunction2 = declaration.getSetter();
            if (abiFunction2 != null) {
                AbiFunction p0 = abiFunction2;
                renderedProperty = renderedProperty3;
                boolean bl4 = false;
                renderedFunction = new RenderedFunction(p0);
                renderedProperty3 = renderedProperty;
            } else {
                renderedFunction = null;
            }
            renderedProperty3.setter = renderedFunction;
        }

        @Override
        public int getAdditionalOrderingFactor1() {
            RenderedFunction renderedFunction = this.getter;
            if (renderedFunction == null) {
                renderedFunction = this.setter;
            }
            return renderedFunction != null ? renderedFunction.getAdditionalOrderingFactor1() : 0;
        }

        @Override
        @NotNull
        public String getAdditionalOrderingFactor2() {
            String string;
            RenderedFunction renderedFunction = this.getter;
            if (renderedFunction == null) {
                renderedFunction = this.setter;
            }
            if ((string = renderedFunction != null ? renderedFunction.getText() : null) == null) {
                string = "";
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter(printer, "printer");
            Printer.printDeclaration$default(printer, this, false, 2, null);
            Printer this_$iv = printer;
            boolean $i$f$indented = false;
            int n2 = this_$iv.indent;
            this_$iv.indent = UInt.constructor-impl(n2 + 1);
            try {
                boolean bl = false;
                RenderedFunction renderedFunction = this.getter;
                if (renderedFunction != null) {
                    renderedFunction.print(printer);
                }
                RenderedFunction renderedFunction2 = this.setter;
                if (renderedFunction2 != null) {
                    renderedFunction2.print(printer);
                }
            }
            finally {
                n2 = this_$iv.indent;
                this_$iv.indent = UInt.constructor-impl(n2 + -1);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty$Companion;", "", "<init>", "()V", "appendPropertyKind", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "propertyKind", "Lorg/jetbrains/kotlin/library/abi/AbiPropertyKind;", "kotlin-util-klib-abi"})
        public static final class Companion {
            private Companion() {
            }

            private final void appendPropertyKind(StringBuilder $this$appendPropertyKind, AbiPropertyKind propertyKind) {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
                    case 1: {
                        string = "val";
                        break;
                    }
                    case 2: {
                        string = "const val";
                        break;
                    }
                    case 3: {
                        string = "var";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$appendPropertyKind.append(string).append(' ');
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[AbiPropertyKind.values().length];
                    try {
                        nArray[AbiPropertyKind.VAL.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiPropertyKind.CONST_VAL.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiPropertyKind.VAR.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedTopLevelDeclarations;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind;", "Lorg/jetbrains/kotlin/library/abi/AbiTopLevelDeclarations;", "<init>", "()V", "orderByDeclarationKind", "", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "kotlin-util-klib-abi"})
    private static final class RenderedTopLevelDeclarations
    extends RenderedDeclarationContainerKind<AbiTopLevelDeclarations> {
        @NotNull
        public static final RenderedTopLevelDeclarations INSTANCE = new RenderedTopLevelDeclarations();

        private RenderedTopLevelDeclarations() {
        }

        @Override
        protected int orderByDeclarationKind(@NotNull RenderedDeclaration<?> renderedDeclaration) {
            Intrinsics.checkNotNullParameter(renderedDeclaration, "renderedDeclaration");
            Object obj = renderedDeclaration.getDeclaration();
            return obj instanceof AbiClass ? 1 : (obj instanceof AbiProperty ? 2 : (obj instanceof AbiFunction ? 3 : 4));
        }
    }
}

