// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package retail provides access to the Vertex AI Search for Retail API.
//
// For product documentation, see: https://cloud.google.com/recommendations
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/retail/v2alpha"
//	...
//	ctx := context.Background()
//	retailService, err := retail.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	retailService, err := retail.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	retailService, err := retail.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package retail // import "google.golang.org/api/retail/v2alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "retail:v2alpha"
const apiName = "retail"
const apiVersion = "v2alpha"
const basePath = "https://retail.googleapis.com/"
const basePathTemplate = "https://retail.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://retail.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	rs.RetailProject = NewProjectsRetailProjectService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService

	RetailProject *ProjectsRetailProjectService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Catalogs = NewProjectsLocationsCatalogsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Catalogs *ProjectsLocationsCatalogsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsCatalogsService(s *Service) *ProjectsLocationsCatalogsService {
	rs := &ProjectsLocationsCatalogsService{s: s}
	rs.AttributesConfig = NewProjectsLocationsCatalogsAttributesConfigService(s)
	rs.Branches = NewProjectsLocationsCatalogsBranchesService(s)
	rs.CompletionData = NewProjectsLocationsCatalogsCompletionDataService(s)
	rs.Controls = NewProjectsLocationsCatalogsControlsService(s)
	rs.MerchantCenterAccountLinks = NewProjectsLocationsCatalogsMerchantCenterAccountLinksService(s)
	rs.Models = NewProjectsLocationsCatalogsModelsService(s)
	rs.Operations = NewProjectsLocationsCatalogsOperationsService(s)
	rs.Placements = NewProjectsLocationsCatalogsPlacementsService(s)
	rs.ServingConfigs = NewProjectsLocationsCatalogsServingConfigsService(s)
	rs.UserEvents = NewProjectsLocationsCatalogsUserEventsService(s)
	return rs
}

type ProjectsLocationsCatalogsService struct {
	s *Service

	AttributesConfig *ProjectsLocationsCatalogsAttributesConfigService

	Branches *ProjectsLocationsCatalogsBranchesService

	CompletionData *ProjectsLocationsCatalogsCompletionDataService

	Controls *ProjectsLocationsCatalogsControlsService

	MerchantCenterAccountLinks *ProjectsLocationsCatalogsMerchantCenterAccountLinksService

	Models *ProjectsLocationsCatalogsModelsService

	Operations *ProjectsLocationsCatalogsOperationsService

	Placements *ProjectsLocationsCatalogsPlacementsService

	ServingConfigs *ProjectsLocationsCatalogsServingConfigsService

	UserEvents *ProjectsLocationsCatalogsUserEventsService
}

func NewProjectsLocationsCatalogsAttributesConfigService(s *Service) *ProjectsLocationsCatalogsAttributesConfigService {
	rs := &ProjectsLocationsCatalogsAttributesConfigService{s: s}
	return rs
}

type ProjectsLocationsCatalogsAttributesConfigService struct {
	s *Service
}

func NewProjectsLocationsCatalogsBranchesService(s *Service) *ProjectsLocationsCatalogsBranchesService {
	rs := &ProjectsLocationsCatalogsBranchesService{s: s}
	rs.Operations = NewProjectsLocationsCatalogsBranchesOperationsService(s)
	rs.Places = NewProjectsLocationsCatalogsBranchesPlacesService(s)
	rs.Products = NewProjectsLocationsCatalogsBranchesProductsService(s)
	return rs
}

type ProjectsLocationsCatalogsBranchesService struct {
	s *Service

	Operations *ProjectsLocationsCatalogsBranchesOperationsService

	Places *ProjectsLocationsCatalogsBranchesPlacesService

	Products *ProjectsLocationsCatalogsBranchesProductsService
}

func NewProjectsLocationsCatalogsBranchesOperationsService(s *Service) *ProjectsLocationsCatalogsBranchesOperationsService {
	rs := &ProjectsLocationsCatalogsBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsBranchesPlacesService(s *Service) *ProjectsLocationsCatalogsBranchesPlacesService {
	rs := &ProjectsLocationsCatalogsBranchesPlacesService{s: s}
	rs.Operations = NewProjectsLocationsCatalogsBranchesPlacesOperationsService(s)
	return rs
}

type ProjectsLocationsCatalogsBranchesPlacesService struct {
	s *Service

	Operations *ProjectsLocationsCatalogsBranchesPlacesOperationsService
}

func NewProjectsLocationsCatalogsBranchesPlacesOperationsService(s *Service) *ProjectsLocationsCatalogsBranchesPlacesOperationsService {
	rs := &ProjectsLocationsCatalogsBranchesPlacesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsBranchesPlacesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsBranchesProductsService(s *Service) *ProjectsLocationsCatalogsBranchesProductsService {
	rs := &ProjectsLocationsCatalogsBranchesProductsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsBranchesProductsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsCompletionDataService(s *Service) *ProjectsLocationsCatalogsCompletionDataService {
	rs := &ProjectsLocationsCatalogsCompletionDataService{s: s}
	return rs
}

type ProjectsLocationsCatalogsCompletionDataService struct {
	s *Service
}

func NewProjectsLocationsCatalogsControlsService(s *Service) *ProjectsLocationsCatalogsControlsService {
	rs := &ProjectsLocationsCatalogsControlsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsControlsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsMerchantCenterAccountLinksService(s *Service) *ProjectsLocationsCatalogsMerchantCenterAccountLinksService {
	rs := &ProjectsLocationsCatalogsMerchantCenterAccountLinksService{s: s}
	return rs
}

type ProjectsLocationsCatalogsMerchantCenterAccountLinksService struct {
	s *Service
}

func NewProjectsLocationsCatalogsModelsService(s *Service) *ProjectsLocationsCatalogsModelsService {
	rs := &ProjectsLocationsCatalogsModelsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsModelsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsOperationsService(s *Service) *ProjectsLocationsCatalogsOperationsService {
	rs := &ProjectsLocationsCatalogsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsPlacementsService(s *Service) *ProjectsLocationsCatalogsPlacementsService {
	rs := &ProjectsLocationsCatalogsPlacementsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsPlacementsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsServingConfigsService(s *Service) *ProjectsLocationsCatalogsServingConfigsService {
	rs := &ProjectsLocationsCatalogsServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsUserEventsService(s *Service) *ProjectsLocationsCatalogsUserEventsService {
	rs := &ProjectsLocationsCatalogsUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsUserEventsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

func NewProjectsRetailProjectService(s *Service) *ProjectsRetailProjectService {
	rs := &ProjectsRetailProjectService{s: s}
	return rs
}

type ProjectsRetailProjectService struct {
	s *Service
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It should
// only be used for payload formats that can't be represented as JSON, such as
// raw binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingErrorContext: A description of the context in which
// an error occurred.
type GoogleCloudRetailLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudRetailLoggingHttpRequestContext `json:"httpRequest,omitempty"`
	// ReportLocation: The location in the source code where the decision was made
	// to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudRetailLoggingSourceLocation `json:"reportLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpRequest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingErrorLog: An error log which is reported to the
// Error Reporting system. This proto a superset of
// google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent.
type GoogleCloudRetailLoggingErrorLog struct {
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudRetailLoggingErrorContext `json:"context,omitempty"`
	// ImportPayload: The error payload that is populated on LRO import APIs.
	ImportPayload *GoogleCloudRetailLoggingImportErrorContext `json:"importPayload,omitempty"`
	// Message: A message describing the error.
	Message string `json:"message,omitempty"`
	// RequestPayload: The API request payload, represented as a protocol buffer.
	// Most API request types are supported. For example:
	// "type.googleapis.com/google.cloud.retail.v2.ProductService.CreateProductReque
	// st"
	// "type.googleapis.com/google.cloud.retail.v2.UserEventService.WriteUserEventRe
	// quest"
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`
	// ResponsePayload: The API response payload, represented as a protocol buffer.
	// This is used to log some "soft errors", where the response is valid but we
	// consider there are some quality issues like unjoined events. The following
	// API responses are supported and no PII is included:
	// "google.cloud.retail.v2.PredictionService.Predict"
	// "google.cloud.retail.v2.UserEventService.WriteUserEvent"
	// "google.cloud.retail.v2.UserEventService.CollectUserEvent"
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`
	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudRetailLoggingServiceContext `json:"serviceContext,omitempty"`
	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingErrorLog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingHttpRequestContext: HTTP request data that is
// related to a reported error.
type GoogleCloudRetailLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResponseStatusCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingHttpRequestContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingImportErrorContext: The error payload that is
// populated on LRO import APIs, including
// "google.cloud.retail.v2.ProductService.ImportProducts" and
// "google.cloud.retail.v2.EventService.ImportUserEvents".
type GoogleCloudRetailLoggingImportErrorContext struct {
	// CatalogItem: The detailed content which caused the error on importing a
	// catalog item.
	CatalogItem string `json:"catalogItem,omitempty"`
	// GcsPath: Cloud Storage file path of the import source. Can be set for batch
	// operation error.
	GcsPath string `json:"gcsPath,omitempty"`
	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`
	// OperationName: The operation resource name of the LRO.
	OperationName string `json:"operationName,omitempty"`
	// Product: The detailed content which caused the error on importing a product.
	Product string `json:"product,omitempty"`
	// UserEvent: The detailed content which caused the error on importing a user
	// event.
	UserEvent string `json:"userEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CatalogItem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CatalogItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingImportErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingServiceContext: Describes a running service that
// sends errors.
type GoogleCloudRetailLoggingServiceContext struct {
	// Service: An identifier of the service. For example, "retail.googleapis.com".
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingServiceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingSourceLocation: Indicates a location in the source
// code of the service for which errors are reported.
type GoogleCloudRetailLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method. For example,
	// "google.cloud.retail.v2.UserEventService.ImportUserEvents".
	FunctionName string `json:"functionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingSourceLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2AddFulfillmentPlacesMetadata: Metadata related to the
// progress of the AddFulfillmentPlaces operation. Currently empty because
// there is no meaningful metadata populated from the
// ProductService.AddFulfillmentPlaces method.
type GoogleCloudRetailV2AddFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2AddFulfillmentPlacesResponse: Response of the
// AddFulfillmentPlacesRequest. Currently empty because there is no meaningful
// response populated from the ProductService.AddFulfillmentPlaces method.
type GoogleCloudRetailV2AddFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2AddLocalInventoriesMetadata: Metadata related to the
// progress of the AddLocalInventories operation. Currently empty because there
// is no meaningful metadata populated from the
// ProductService.AddLocalInventories method.
type GoogleCloudRetailV2AddLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2AddLocalInventoriesResponse: Response of the
// ProductService.AddLocalInventories API. Currently empty because there is no
// meaningful response populated from the ProductService.AddLocalInventories
// method.
type GoogleCloudRetailV2AddLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2BigQueryOutputResult: A BigQuery output result.
type GoogleCloudRetailV2BigQueryOutputResult struct {
	// DatasetId: The ID of a BigQuery Dataset.
	DatasetId string `json:"datasetId,omitempty"`
	// TableId: The ID of a BigQuery Table.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2BigQueryOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2BigQueryOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2CreateModelMetadata: Metadata associated with a create
// operation.
type GoogleCloudRetailV2CreateModelMetadata struct {
	// Model: The resource name of the model that this create applies to. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}`
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2CreateModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2CreateModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ExportAnalyticsMetricsResponse: Response of the
// ExportAnalyticsMetricsRequest. If the long running operation was successful,
// then this message is returned by the google.longrunning.Operations.response
// field if the operation was successful.
type GoogleCloudRetailV2ExportAnalyticsMetricsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: This field is never set.
	ErrorsConfig *GoogleCloudRetailV2ExportErrorsConfig `json:"errorsConfig,omitempty"`
	// OutputResult: Output result indicating where the data were exported to.
	OutputResult *GoogleCloudRetailV2OutputResult `json:"outputResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ExportAnalyticsMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ExportAnalyticsMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ExportErrorsConfig: Configuration of destination for
// Export related errors.
type GoogleCloudRetailV2ExportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be an
	// empty, existing Cloud Storage bucket. Export errors will be written to a
	// file in this bucket, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ExportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ExportErrorsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ExportMetadata: Metadata related to the progress of the
// Export operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2ExportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ExportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ExportMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2GcsOutputResult: A Gcs output result.
type GoogleCloudRetailV2GcsOutputResult struct {
	// OutputUri: The uri of Gcs output
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2GcsOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2GcsOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportCompletionDataResponse: Response of the
// ImportCompletionDataRequest. If the long running operation is done, this
// message is returned by the google.longrunning.Operations.response field if
// the operation is successful.
type GoogleCloudRetailV2ImportCompletionDataResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ImportCompletionDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportCompletionDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportErrorsConfig: Configuration of destination for
// Import related errors.
type GoogleCloudRetailV2ImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportErrorsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportMetadata: Metadata related to the progress of the
// Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2ImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If this
	// field is set, when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a Operation.
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`
	// RequestId: Deprecated. This field is never set.
	RequestId string `json:"requestId,omitempty"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudRetailV2ImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudRetailV2ImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`
	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2UserEventImportSummary `json:"importSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2Model: Metadata that describes the training and serving
// parameters of a Model. A Model can be associated with a ServingConfig and
// then queried through the Predict API.
type GoogleCloudRetailV2Model struct {
	// CreateTime: Output only. Timestamp the Recommendation Model was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataState: Output only. The state of data requirements for this model:
	// `DATA_OK` and `DATA_ERROR`. Recommendation model cannot be trained if the
	// data is in `DATA_ERROR` state. Recommendation model can have `DATA_ERROR`
	// state even if serving state is `ACTIVE`: models were trained successfully
	// before, but cannot be refreshed because model no longer has sufficient data
	// for training.
	//
	// Possible values:
	//   "DATA_STATE_UNSPECIFIED" - Unspecified default value, should never be
	// explicitly set.
	//   "DATA_OK" - The model has sufficient training data.
	//   "DATA_ERROR" - The model does not have sufficient training data. Error
	// messages can be queried via Stackdriver.
	DataState string `json:"dataState,omitempty"`
	// DisplayName: Required. The display name of the model. Should be human
	// readable, used to display Recommendation Models in the Retail Cloud Console
	// Dashboard. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// FilteringOption: Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`,
	// recommendation filtering by attributes is enabled for the model.
	//
	// Possible values:
	//   "RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED" - Value used when unset. In
	// this case, server behavior defaults to RECOMMENDATIONS_FILTERING_DISABLED.
	//   "RECOMMENDATIONS_FILTERING_DISABLED" - Recommendation filtering is
	// disabled.
	//   "RECOMMENDATIONS_FILTERING_ENABLED" - Recommendation filtering is enabled.
	FilteringOption string `json:"filteringOption,omitempty"`
	// LastTuneTime: Output only. The timestamp when the latest successful tune
	// finished.
	LastTuneTime string `json:"lastTuneTime,omitempty"`
	// ModelFeaturesConfig: Optional. Additional model features config.
	ModelFeaturesConfig *GoogleCloudRetailV2ModelModelFeaturesConfig `json:"modelFeaturesConfig,omitempty"`
	// Name: Required. The fully qualified resource name of the model. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}` catalog_id has char limit of 50. recommendation_model_id has
	// char limit of 40.
	Name string `json:"name,omitempty"`
	// OptimizationObjective: Optional. The optimization objective e.g. `cvr`.
	// Currently supported values: `ctr`, `cvr`, `revenue-per-order`. If not
	// specified, we choose default based on model type. Default depends on type of
	// recommendation: `recommended-for-you` => `ctr` `others-you-may-like` =>
	// `ctr` `frequently-bought-together` => `revenue_per_order` This field
	// together with optimization_objective describe model metadata to use to
	// control model training and serving. See
	// https://cloud.google.com/retail/docs/models for more details on what the
	// model metadata control and which combination of parameters are valid. For
	// invalid combinations of parameters (e.g. type = `frequently-bought-together`
	// and optimization_objective = `ctr`), you receive an error 400 if you try to
	// create/update a recommendation with this set of knobs.
	OptimizationObjective string `json:"optimizationObjective,omitempty"`
	// PeriodicTuningState: Optional. The state of periodic tuning. The period we
	// use is 3 months - to do a one-off tune earlier use the `TuneModel` method.
	// Default value is `PERIODIC_TUNING_ENABLED`.
	//
	// Possible values:
	//   "PERIODIC_TUNING_STATE_UNSPECIFIED" - Unspecified default value, should
	// never be explicitly set.
	//   "PERIODIC_TUNING_DISABLED" - The model has periodic tuning disabled.
	// Tuning can be reenabled by calling the `EnableModelPeriodicTuning` method or
	// by calling the `TuneModel` method.
	//   "ALL_TUNING_DISABLED" - The model cannot be tuned with periodic tuning OR
	// the `TuneModel` method. Hide the options in customer UI and reject any
	// requests through the backend self serve API.
	//   "PERIODIC_TUNING_ENABLED" - The model has periodic tuning enabled. Tuning
	// can be disabled by calling the `DisableModelPeriodicTuning` method.
	PeriodicTuningState string `json:"periodicTuningState,omitempty"`
	// ServingConfigLists: Output only. The list of valid serving configs
	// associated with the PageOptimizationConfig.
	ServingConfigLists []*GoogleCloudRetailV2ModelServingConfigList `json:"servingConfigLists,omitempty"`
	// ServingState: Output only. The serving state of the model: `ACTIVE`,
	// `NOT_ACTIVE`.
	//
	// Possible values:
	//   "SERVING_STATE_UNSPECIFIED" - Unspecified serving state.
	//   "INACTIVE" - The model is not serving.
	//   "ACTIVE" - The model is serving and can be queried.
	//   "TUNED" - The model is trained on tuned hyperparameters and can be
	// queried.
	ServingState string `json:"servingState,omitempty"`
	// TrainingState: Optional. The training state that the model is in (e.g.
	// `TRAINING` or `PAUSED`). Since part of the cost of running the service is
	// frequency of training - this can be used to determine when to train model in
	// order to control cost. If not specified: the default value for `CreateModel`
	// method is `TRAINING`. The default value for `UpdateModel` method is to keep
	// the state the same as before.
	//
	// Possible values:
	//   "TRAINING_STATE_UNSPECIFIED" - Unspecified training state.
	//   "PAUSED" - The model training is paused.
	//   "TRAINING" - The model is training.
	TrainingState string `json:"trainingState,omitempty"`
	// TuningOperation: Output only. The tune operation associated with the model.
	// Can be used to determine if there is an ongoing tune for this
	// recommendation. Empty field implies no tune is goig on.
	TuningOperation string `json:"tuningOperation,omitempty"`
	// Type: Required. The type of model e.g. `home-page`. Currently supported
	// values: `recommended-for-you`, `others-you-may-like`,
	// `frequently-bought-together`, `page-optimization`, `similar-items`,
	// `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value). This
	// field together with optimization_objective describe model metadata to use to
	// control model training and serving. See
	// https://cloud.google.com/retail/docs/models for more details on what the
	// model metadata control and which combination of parameters are valid. For
	// invalid combinations of parameters (e.g. type = `frequently-bought-together`
	// and optimization_objective = `ctr`), you receive an error 400 if you try to
	// create/update a recommendation with this set of knobs.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Model was last
	// updated. E.g. if a Recommendation Model was paused - this would be the time
	// the pause was initiated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2Model) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Model
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ModelFrequentlyBoughtTogetherFeaturesConfig: Additional
// configs for the frequently-bought-together model type.
type GoogleCloudRetailV2ModelFrequentlyBoughtTogetherFeaturesConfig struct {
	// ContextProductsType: Optional. Specifies the context of the model when it is
	// used in predict requests. Can only be set for the
	// `frequently-bought-together` type. If it isn't specified, it defaults to
	// MULTIPLE_CONTEXT_PRODUCTS.
	//
	// Possible values:
	//   "CONTEXT_PRODUCTS_TYPE_UNSPECIFIED" - Unspecified default value, should
	// never be explicitly set. Defaults to MULTIPLE_CONTEXT_PRODUCTS.
	//   "SINGLE_CONTEXT_PRODUCT" - Use only a single product as context for the
	// recommendation. Typically used on pages like add-to-cart or product details.
	//   "MULTIPLE_CONTEXT_PRODUCTS" - Use one or multiple products as context for
	// the recommendation. Typically used on shopping cart pages.
	ContextProductsType string `json:"contextProductsType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextProductsType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextProductsType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ModelFrequentlyBoughtTogetherFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ModelFrequentlyBoughtTogetherFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ModelModelFeaturesConfig: Additional model features
// config.
type GoogleCloudRetailV2ModelModelFeaturesConfig struct {
	// FrequentlyBoughtTogetherConfig: Additional configs for
	// frequently-bought-together models.
	FrequentlyBoughtTogetherConfig *GoogleCloudRetailV2ModelFrequentlyBoughtTogetherFeaturesConfig `json:"frequentlyBoughtTogetherConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "FrequentlyBoughtTogetherConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FrequentlyBoughtTogetherConfig")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ModelModelFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ModelModelFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ModelServingConfigList: Represents an ordered combination
// of valid serving configs, which can be used for `PAGE_OPTIMIZATION`
// recommendations.
type GoogleCloudRetailV2ModelServingConfigList struct {
	// ServingConfigIds: Optional. A set of valid serving configs that may be used
	// for `PAGE_OPTIMIZATION`.
	ServingConfigIds []string `json:"servingConfigIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServingConfigIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServingConfigIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2ModelServingConfigList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ModelServingConfigList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2OutputResult: Output result that stores the information
// about where the exported data is stored.
type GoogleCloudRetailV2OutputResult struct {
	// BigqueryResult: The BigQuery location where the result is stored.
	BigqueryResult []*GoogleCloudRetailV2BigQueryOutputResult `json:"bigqueryResult,omitempty"`
	// GcsResult: The Google Cloud Storage location where the result is stored.
	GcsResult []*GoogleCloudRetailV2GcsOutputResult `json:"gcsResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2OutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2OutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PurgeMetadata: Metadata related to the progress of the
// Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2PurgeMetadata struct {
}

// GoogleCloudRetailV2PurgeProductsMetadata: Metadata related to the progress
// of the PurgeProducts operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2PurgeProductsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2PurgeProductsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PurgeProductsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PurgeProductsResponse: Response of the
// PurgeProductsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudRetailV2PurgeProductsResponse struct {
	// PurgeCount: The total count of products purged as a result of the operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of the product names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be returned
	// and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2PurgeProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PurgeProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudRetailV2PurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of the
	// operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgedEventsCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2PurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PurgeUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2RejoinUserEventsMetadata: Metadata for `RejoinUserEvents`
// method.
type GoogleCloudRetailV2RejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2RejoinUserEventsResponse: Response message for
// `RejoinUserEvents` method.
type GoogleCloudRetailV2RejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with latest
	// product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "RejoinedUserEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2RejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2RejoinUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2RemoveFulfillmentPlacesMetadata: Metadata related to the
// progress of the RemoveFulfillmentPlaces operation. Currently empty because
// there is no meaningful metadata populated from the
// ProductService.RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2RemoveFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2RemoveFulfillmentPlacesResponse: Response of the
// RemoveFulfillmentPlacesRequest. Currently empty because there is no
// meaningful response populated from the
// ProductService.RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2RemoveFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2RemoveLocalInventoriesMetadata: Metadata related to the
// progress of the RemoveLocalInventories operation. Currently empty because
// there is no meaningful metadata populated from the
// ProductService.RemoveLocalInventories method.
type GoogleCloudRetailV2RemoveLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2RemoveLocalInventoriesResponse: Response of the
// ProductService.RemoveLocalInventories API. Currently empty because there is
// no meaningful response populated from the
// ProductService.RemoveLocalInventories method.
type GoogleCloudRetailV2RemoveLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2SetInventoryMetadata: Metadata related to the progress of
// the SetInventory operation. Currently empty because there is no meaningful
// metadata populated from the ProductService.SetInventory method.
type GoogleCloudRetailV2SetInventoryMetadata struct {
}

// GoogleCloudRetailV2SetInventoryResponse: Response of the
// SetInventoryRequest. Currently empty because there is no meaningful response
// populated from the ProductService.SetInventory method.
type GoogleCloudRetailV2SetInventoryResponse struct {
}

// GoogleCloudRetailV2TuneModelMetadata: Metadata associated with a tune
// operation.
type GoogleCloudRetailV2TuneModelMetadata struct {
	// Model: The resource name of the model that this tune applies to. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}`
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2TuneModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2TuneModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2TuneModelResponse: Response associated with a tune
// operation.
type GoogleCloudRetailV2TuneModelResponse struct {
}

// GoogleCloudRetailV2UserEventImportSummary: A summary of import result. The
// UserEventImportSummary summarizes the import status for user events.
type GoogleCloudRetailV2UserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete existing
	// catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JoinedEventsCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2UserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2UserEventImportSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAcceptTermsRequest: Request for AcceptTerms method.
type GoogleCloudRetailV2alphaAcceptTermsRequest struct {
}

// GoogleCloudRetailV2alphaAddCatalogAttributeRequest: Request for
// CatalogService.AddCatalogAttribute method.
type GoogleCloudRetailV2alphaAddCatalogAttributeRequest struct {
	// CatalogAttribute: Required. The CatalogAttribute to add.
	CatalogAttribute *GoogleCloudRetailV2alphaCatalogAttribute `json:"catalogAttribute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CatalogAttribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CatalogAttribute") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAddCatalogAttributeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAddCatalogAttributeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAddControlRequest: Request for AddControl method.
type GoogleCloudRetailV2alphaAddControlRequest struct {
	// ControlId: Required. The id of the control to apply. Assumed to be in the
	// same catalog as the serving config - if id is not found a NOT_FOUND error is
	// returned.
	ControlId string `json:"controlId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ControlId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ControlId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAddControlRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAddControlRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAddFulfillmentPlacesMetadata: Metadata related to
// the progress of the AddFulfillmentPlaces operation. Currently empty because
// there is no meaningful metadata populated from the
// ProductService.AddFulfillmentPlaces method.
type GoogleCloudRetailV2alphaAddFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2alphaAddFulfillmentPlacesRequest: Request message for
// ProductService.AddFulfillmentPlaces method.
type GoogleCloudRetailV2alphaAddFulfillmentPlacesRequest struct {
	// AddTime: The time when the fulfillment updates are issued, used to prevent
	// out-of-order updates on fulfillment information. If not provided, the
	// internal system time will be used.
	AddTime string `json:"addTime,omitempty"`
	// AllowMissing: If set to true, and the Product is not found, the fulfillment
	// information will still be processed and retained for at most 1 day and
	// processed once the Product is created. If set to false, a NOT_FOUND error is
	// returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// PlaceIds: Required. The IDs for this type, such as the store IDs for
	// "pickup-in-store" or the region IDs for "same-day-delivery" to be added for
	// this type. Duplicate IDs will be automatically ignored. At least 1 value is
	// required, and a maximum of 2000 values are allowed. Each value must be a
	// string with a length limit of 10 characters, matching the pattern
	// `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
	// INVALID_ARGUMENT error is returned. If the total number of place IDs exceeds
	// 2000 for this type after adding, then the update will be rejected.
	PlaceIds []string `json:"placeIds,omitempty"`
	// Type: Required. The fulfillment type, including commonly used types (such as
	// pickup in store and same day delivery), and custom types. Supported values:
	// * "pickup-in-store" * "ship-to-store" * "same-day-delivery" *
	// "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" *
	// "custom-type-4" * "custom-type-5" If this field is set to an invalid value
	// other than these, an INVALID_ARGUMENT error is returned. This field directly
	// corresponds to Product.fulfillment_info.type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAddFulfillmentPlacesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAddFulfillmentPlacesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAddFulfillmentPlacesResponse: Response of the
// AddFulfillmentPlacesRequest. Currently empty because there is no meaningful
// response populated from the ProductService.AddFulfillmentPlaces method.
type GoogleCloudRetailV2alphaAddFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2alphaAddLocalInventoriesMetadata: Metadata related to the
// progress of the AddLocalInventories operation. Currently empty because there
// is no meaningful metadata populated from the
// ProductService.AddLocalInventories method.
type GoogleCloudRetailV2alphaAddLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2alphaAddLocalInventoriesRequest: Request message for
// ProductService.AddLocalInventories method.
type GoogleCloudRetailV2alphaAddLocalInventoriesRequest struct {
	// AddMask: Indicates which inventory fields in the provided list of
	// LocalInventory to update. The field is updated to the provided value. If a
	// field is set while the place does not have a previous local inventory, the
	// local inventory at that store is created. If a field is set while the value
	// of that field is not provided, the original field value, if it exists, is
	// deleted. If the mask is not set or set with empty paths, all inventory
	// fields will be updated. If an unsupported or unknown field is provided, an
	// INVALID_ARGUMENT error is returned and the entire update will be ignored.
	AddMask string `json:"addMask,omitempty"`
	// AddTime: The time when the inventory updates are issued. Used to prevent
	// out-of-order updates on local inventory fields. If not provided, the
	// internal system time will be used.
	AddTime string `json:"addTime,omitempty"`
	// AllowMissing: If set to true, and the Product is not found, the local
	// inventory will still be processed and retained for at most 1 day and
	// processed once the Product is created. If set to false, a NOT_FOUND error is
	// returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// LocalInventories: Required. A list of inventory information at difference
	// places. Each place is identified by its place ID. At most 3000 inventories
	// are allowed per request.
	LocalInventories []*GoogleCloudRetailV2alphaLocalInventory `json:"localInventories,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddMask") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddMask") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAddLocalInventoriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAddLocalInventoriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAddLocalInventoriesResponse: Response of the
// ProductService.AddLocalInventories API. Currently empty because there is no
// meaningful response populated from the ProductService.AddLocalInventories
// method.
type GoogleCloudRetailV2alphaAddLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2alphaAlertConfig: Project level alert config.
type GoogleCloudRetailV2alphaAlertConfig struct {
	// AlertPolicies: Alert policies for a customer. They must be unique by
	// [AlertPolicy.alert_group]
	AlertPolicies []*GoogleCloudRetailV2alphaAlertConfigAlertPolicy `json:"alertPolicies,omitempty"`
	// Name: Required. Immutable. The name of the AlertConfig singleton resource.
	// Format: projects/*/alertConfig
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlertPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertPolicies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAlertConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAlertConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAlertConfigAlertPolicy: Alert policy for a customer.
type GoogleCloudRetailV2alphaAlertConfigAlertPolicy struct {
	// AlertGroup: The feature that provides alerting capability. Supported value:
	// - `search-data-quality` for retail search customers. - `conv-data-quality`
	// for retail conversation customers.
	AlertGroup string `json:"alertGroup,omitempty"`
	// EnrollStatus: The enrollment status of a customer.
	//
	// Possible values:
	//   "ENROLL_STATUS_UNSPECIFIED" - Default value. Used for customers who have
	// not responded to the alert policy.
	//   "ENROLLED" - Customer is enrolled in this policy.
	//   "DECLINED" - Customer declined this policy.
	EnrollStatus string `json:"enrollStatus,omitempty"`
	// Recipients: Recipients for the alert policy. One alert policy should not
	// exceed 20 recipients.
	Recipients []*GoogleCloudRetailV2alphaAlertConfigAlertPolicyRecipient `json:"recipients,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertGroup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAlertConfigAlertPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAlertConfigAlertPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAlertConfigAlertPolicyRecipient: Recipient contact
// information.
type GoogleCloudRetailV2alphaAlertConfigAlertPolicyRecipient struct {
	// EmailAddress: Email address of the recipient.
	EmailAddress string `json:"emailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAlertConfigAlertPolicyRecipient) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAlertConfigAlertPolicyRecipient
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAttributesConfig: Catalog level attribute config.
type GoogleCloudRetailV2alphaAttributesConfig struct {
	// AttributeConfigLevel: Output only. The AttributeConfigLevel used for this
	// catalog.
	//
	// Possible values:
	//   "ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED" - Value used when unset. In this
	// case, server behavior defaults to CATALOG_LEVEL_ATTRIBUTE_CONFIG.
	//   "PRODUCT_LEVEL_ATTRIBUTE_CONFIG" - At this level, we honor the attribute
	// configurations set in Product.attributes.
	//   "CATALOG_LEVEL_ATTRIBUTE_CONFIG" - At this level, we honor the attribute
	// configurations set in CatalogConfig.attribute_configs.
	AttributeConfigLevel string `json:"attributeConfigLevel,omitempty"`
	// CatalogAttributes: Enable attribute(s) config at catalog level. For example,
	// indexable, dynamic_facetable, or searchable for each attribute. The key is
	// catalog attribute's name. For example: `color`, `brands`,
	// `attributes.custom_attribute`, such as `attributes.xyz`. The maximum number
	// of catalog attributes allowed in a request is 1000.
	CatalogAttributes map[string]GoogleCloudRetailV2alphaCatalogAttribute `json:"catalogAttributes,omitempty"`
	// Name: Required. Immutable. The fully qualified resource name of the
	// attribute config. Format:
	// `projects/*/locations/*/catalogs/*/attributesConfig`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributeConfigLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeConfigLevel") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAttributesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAttributesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAudience: An intended audience of the Product for
// whom it's sold.
type GoogleCloudRetailV2alphaAudience struct {
	// AgeGroups: The age groups of the audience. Strongly encouraged to use the
	// standard values: "newborn" (up to 3 months old), "infant" (3–12 months
	// old), "toddler" (1–5 years old), "kids" (5–13 years old), "adult"
	// (typically teens or older). At most 5 values are allowed. Each value must be
	// a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// age_group (https://support.google.com/merchants/answer/6324463). Schema.org
	// property Product.audience.suggestedMinAge
	// (https://schema.org/suggestedMinAge) and Product.audience.suggestedMaxAge
	// (https://schema.org/suggestedMaxAge).
	AgeGroups []string `json:"ageGroups,omitempty"`
	// Genders: The genders of the audience. Strongly encouraged to use the
	// standard values: "male", "female", "unisex". At most 5 values are allowed.
	// Each value must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center property gender
	// (https://support.google.com/merchants/answer/6324479). Schema.org property
	// Product.audience.suggestedGender (https://schema.org/suggestedGender).
	Genders []string `json:"genders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgeGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgeGroups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaAudience) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaAudience
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesRequest: Request for
// CatalogService.BatchRemoveCatalogAttributes method.
type GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesRequest struct {
	// AttributeKeys: Required. The attribute name keys of the CatalogAttributes to
	// delete. A maximum of 1000 catalog attributes can be deleted in a batch.
	AttributeKeys []string `json:"attributeKeys,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeKeys") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesResponse: Response of
// the CatalogService.BatchRemoveCatalogAttributes.
type GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesResponse struct {
	// DeletedCatalogAttributes: Catalog attributes that were deleted. Only
	// pre-loaded catalog attributes that are neither in use by products nor
	// predefined can be deleted.
	DeletedCatalogAttributes []string `json:"deletedCatalogAttributes,omitempty"`
	// ResetCatalogAttributes: Catalog attributes that were reset. Catalog
	// attributes that are either in use by products or are predefined attributes
	// cannot be deleted; however, their configuration properties will reset to
	// default values upon removal request.
	ResetCatalogAttributes []string `json:"resetCatalogAttributes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeletedCatalogAttributes")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeletedCatalogAttributes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBigQueryOutputResult: A BigQuery output result.
type GoogleCloudRetailV2alphaBigQueryOutputResult struct {
	// DatasetId: The ID of a BigQuery Dataset.
	DatasetId string `json:"datasetId,omitempty"`
	// TableId: The ID of a BigQuery Table.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaBigQueryOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBigQueryOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBigQuerySource: BigQuery source import data from.
type GoogleCloudRetailV2alphaBigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for product imports: * `product` (default): One JSON
	// Product per line. Each product must have a valid Product.id. *
	// `product_merchant_center`: See Importing catalog data from Merchant Center
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mc).
	// Supported values for user events imports: * `user_event` (default): One JSON
	// UserEvent per line. * `user_event_ga360`: The schema is available here:
	// https://support.google.com/analytics/answer/3437719. * `user_event_ga4`: The
	// schema is available here:
	// https://support.google.com/analytics/answer/7029846. Supported values for
	// autocomplete imports: * `suggestions` (default): One JSON completion
	// suggestion per line. * `denylist`: One JSON deny suggestion per line. *
	// `allowlist`: One JSON allow suggestion per line.
	DataSchema string `json:"dataSchema,omitempty"`
	// DatasetId: Required. The BigQuery data set to copy the data from with a
	// length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the BigQuery export to a specific Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// PartitionDate: BigQuery time partitioned table's _PARTITIONDATE in
	// YYYY-MM-DD format. Only supported in ImportProductsRequest.
	PartitionDate *GoogleTypeDate `json:"partitionDate,omitempty"`
	// ProjectId: The project ID (can be project # or ID) that the BigQuery source
	// is in with a length limit of 128 characters. If not specified, inherits the
	// project ID from the parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The BigQuery table to copy the data from with a length
	// limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBranch: A data branch that stores all instances of
// Products.
type GoogleCloudRetailV2alphaBranch struct {
	// DisplayName: Output only. Human readable name of the branch to display in
	// the UI.
	DisplayName string `json:"displayName,omitempty"`
	// IsDefault: Output only. Indicates whether this branch is set as the default
	// branch of its parent catalog.
	IsDefault bool `json:"isDefault,omitempty"`
	// LastProductImportTime: Output only. Timestamp of last import through
	// ProductService.ImportProducts. Empty value means no import has been made to
	// this branch.
	LastProductImportTime string `json:"lastProductImportTime,omitempty"`
	// Name: Immutable. Full resource name of the branch, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/branch_id`.
	Name string `json:"name,omitempty"`
	// ProductCountStats: Output only. Statistics for number of products in the
	// branch, provided for different scopes. This field is not populated in
	// BranchView.BASIC view.
	ProductCountStats []*GoogleCloudRetailV2alphaBranchProductCountStatistic `json:"productCountStats,omitempty"`
	// QualityMetrics: Output only. The quality metrics measured among products of
	// this branch. See QualityMetric.requirement_key for supported metrics.
	// Metrics could be missing if failed to retrieve. This field is not populated
	// in BranchView.BASIC view.
	QualityMetrics []*GoogleCloudRetailV2alphaBranchQualityMetric `json:"qualityMetrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaBranch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBranch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBranchProductCountStatistic: A statistic about the
// number of products in a branch.
type GoogleCloudRetailV2alphaBranchProductCountStatistic struct {
	// Counts: The number of products in scope broken down into different groups.
	// The key is a group representing a set of products, and the value is the
	// number of products in that group. Note: keys in this map may change over
	// time. Possible keys: * "primary-in-stock", products have
	// Product.Type.PRIMARY type and Product.Availability.IN_STOCK availability. *
	// "primary-out-of-stock", products have Product.Type.PRIMARY type and
	// Product.Availability.OUT_OF_STOCK availability. * "primary-preorder",
	// products have Product.Type.PRIMARY type and Product.Availability.PREORDER
	// availability. * "primary-backorder", products have Product.Type.PRIMARY type
	// and Product.Availability.BACKORDER availability. * "variant-in-stock",
	// products have Product.Type.VARIANT type and Product.Availability.IN_STOCK
	// availability. * "variant-out-of-stock", products have Product.Type.VARIANT
	// type and Product.Availability.OUT_OF_STOCK availability. *
	// "variant-preorder", products have Product.Type.VARIANT type and
	// Product.Availability.PREORDER availability. * "variant-backorder", products
	// have Product.Type.VARIANT type and Product.Availability.BACKORDER
	// availability. * "price-discounted", products have [Product.price_info.price]
	// < [Product.price_info.original_price].
	Counts map[string]string `json:"counts,omitempty"`
	// Scope: [ProductCountScope] of the [counts].
	//
	// Possible values:
	//   "PRODUCT_COUNT_SCOPE_UNSPECIFIED" - Default value for enum. This value is
	// not used in the API response.
	//   "ALL_PRODUCTS" - Scope for all existing products in the branch. Useful for
	// understanding how many products there are in a branch.
	//   "LAST_24_HOUR_UPDATE" - Scope for products created or updated in the last
	// 24 hours.
	Scope string `json:"scope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Counts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Counts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaBranchProductCountStatistic) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBranchProductCountStatistic
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaBranchQualityMetric: Metric measured on a group of
// Products against a certain quality requirement. Contains the number of
// products that pass the check and the number of products that don't.
type GoogleCloudRetailV2alphaBranchQualityMetric struct {
	// QualifiedProductCount: Number of products passing the quality requirement
	// check. We only check searchable products.
	QualifiedProductCount int64 `json:"qualifiedProductCount,omitempty"`
	// RequirementKey: The key that represents a quality requirement rule.
	// Supported keys: * "has-valid-uri": product has a valid and accessible uri. *
	// "available-expire-time-conformance": Product.available_time is early than
	// "now", and Product.expire_time is greater than "now". *
	// "has-searchable-attributes": product has at least one attribute set to
	// searchable. * "has-description": product has non-empty description. *
	// "has-at-least-bigram-title": Product title has at least two words. A
	// comprehensive title helps to improve search quality. * "variant-has-image":
	// the variant products has at least one image. You may ignore this metric if
	// all your products are at primary level. * "variant-has-price-info": the
	// variant products has price_info set. You may ignore this metric if all your
	// products are at primary level. * "has-publish-time": product has non-empty
	// publish_time.
	RequirementKey string `json:"requirementKey,omitempty"`
	// SuggestedQualityPercentThreshold: Value from 0 to 100 representing the
	// suggested percentage of products that meet the quality requirements to get
	// good search and recommendation performance. 100 * (qualified_product_count)
	// / (qualified_product_count + unqualified_product_count) should be greater or
	// equal to this suggestion.
	SuggestedQualityPercentThreshold float64 `json:"suggestedQualityPercentThreshold,omitempty"`
	// UnqualifiedProductCount: Number of products failing the quality requirement
	// check. We only check searchable products.
	UnqualifiedProductCount int64 `json:"unqualifiedProductCount,omitempty"`
	// UnqualifiedSampleProducts: A list of a maximum of 100 sample products that
	// do not qualify for this requirement. This field is only populated in the
	// response to BranchService.GetBranch API, and is always empty for
	// BranchService.ListBranches. Only the following fields are set in the
	// Product. * Product.name * Product.id * Product.title
	UnqualifiedSampleProducts []*GoogleCloudRetailV2alphaProduct `json:"unqualifiedSampleProducts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QualifiedProductCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QualifiedProductCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaBranchQualityMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaBranchQualityMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaBranchQualityMetric) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaBranchQualityMetric
	var s1 struct {
		SuggestedQualityPercentThreshold gensupport.JSONFloat64 `json:"suggestedQualityPercentThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SuggestedQualityPercentThreshold = float64(s1.SuggestedQualityPercentThreshold)
	return nil
}

// GoogleCloudRetailV2alphaCatalog: The catalog configuration.
type GoogleCloudRetailV2alphaCatalog struct {
	// DisplayName: Required. Immutable. The catalog display name. This field must
	// be a UTF-8 encoded string with a length limit of 128 characters. Otherwise,
	// an INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// MerchantCenterLinkingConfig: The Merchant Center linking configuration.
	// After a link is added, the data stream from Merchant Center to Cloud Retail
	// will be enabled automatically. The requester must have access to the
	// Merchant Center account in order to make changes to this field.
	MerchantCenterLinkingConfig *GoogleCloudRetailV2alphaMerchantCenterLinkingConfig `json:"merchantCenterLinkingConfig,omitempty"`
	// Name: Required. Immutable. The fully qualified resource name of the catalog.
	Name string `json:"name,omitempty"`
	// ProductLevelConfig: Required. The product level configuration.
	ProductLevelConfig *GoogleCloudRetailV2alphaProductLevelConfig `json:"productLevelConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCatalog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCatalogAttribute: Catalog level attribute config for
// an attribute. For example, if customers want to enable/disable facet for a
// specific attribute.
type GoogleCloudRetailV2alphaCatalogAttribute struct {
	// DynamicFacetableOption: If DYNAMIC_FACETABLE_ENABLED, attribute values are
	// available for dynamic facet. Could only be DYNAMIC_FACETABLE_DISABLED if
	// CatalogAttribute.indexable_option is INDEXABLE_DISABLED. Otherwise, an
	// INVALID_ARGUMENT error is returned. Must be specified, otherwise throws
	// INVALID_FORMAT error.
	//
	// Possible values:
	//   "DYNAMIC_FACETABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "DYNAMIC_FACETABLE_ENABLED" - Dynamic facetable option enabled for an
	// attribute.
	//   "DYNAMIC_FACETABLE_DISABLED" - Dynamic facetable option disabled for an
	// attribute.
	DynamicFacetableOption string `json:"dynamicFacetableOption,omitempty"`
	// ExactSearchableOption: If EXACT_SEARCHABLE_ENABLED, attribute values will be
	// exact searchable. This property only applies to textual custom attributes
	// and requires indexable set to enabled to enable exact-searchable. If unset,
	// the server behavior defaults to EXACT_SEARCHABLE_DISABLED.
	//
	// Possible values:
	//   "EXACT_SEARCHABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "EXACT_SEARCHABLE_ENABLED" - Exact searchable option enabled for an
	// attribute.
	//   "EXACT_SEARCHABLE_DISABLED" - Exact searchable option disabled for an
	// attribute.
	ExactSearchableOption string `json:"exactSearchableOption,omitempty"`
	// FacetConfig: Contains facet options.
	FacetConfig *GoogleCloudRetailV2alphaCatalogAttributeFacetConfig `json:"facetConfig,omitempty"`
	// InUse: Output only. Indicates whether this attribute has been used by any
	// products. `True` if at least one Product is using this attribute in
	// Product.attributes. Otherwise, this field is `False`. CatalogAttribute can
	// be pre-loaded by using CatalogService.AddCatalogAttribute,
	// CatalogService.ImportCatalogAttributes, or
	// CatalogService.UpdateAttributesConfig APIs. This field is `False` for
	// pre-loaded CatalogAttributes. Only pre-loaded catalog attributes that are
	// neither in use by products nor predefined can be deleted. Catalog attributes
	// that are either in use by products or are predefined attributes cannot be
	// deleted; however, their configuration properties will reset to default
	// values upon removal request. After catalog changes, it takes about 10
	// minutes for this field to update.
	InUse bool `json:"inUse,omitempty"`
	// IndexableOption: When AttributesConfig.attribute_config_level is
	// CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values are
	// indexed so that it can be filtered, faceted, or boosted in
	// SearchService.Search. Must be specified when
	// AttributesConfig.attribute_config_level is CATALOG_LEVEL_ATTRIBUTE_CONFIG,
	// otherwise throws INVALID_FORMAT error.
	//
	// Possible values:
	//   "INDEXABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "INDEXABLE_ENABLED" - Indexable option enabled for an attribute.
	//   "INDEXABLE_DISABLED" - Indexable option disabled for an attribute.
	IndexableOption string `json:"indexableOption,omitempty"`
	// Key: Required. Attribute name. For example: `color`, `brands`,
	// `attributes.custom_attribute`, such as `attributes.xyz`. To be indexable,
	// the attribute name can contain only alpha-numeric characters and
	// underscores. For example, an attribute named `attributes.abc_xyz` can be
	// indexed, but an attribute named `attributes.abc-xyz` cannot be indexed. If
	// the attribute key starts with `attributes.`, then the attribute is a custom
	// attribute. Attributes such as `brands`, `patterns`, and `title` are built-in
	// and called system attributes.
	Key string `json:"key,omitempty"`
	// RecommendationsFilteringOption: When AttributesConfig.attribute_config_level
	// is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if RECOMMENDATIONS_FILTERING_ENABLED,
	// attribute values are filterable for recommendations. This option works for
	// categorical features only, does not work for numerical features, inventory
	// filtering.
	//
	// Possible values:
	//   "RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED" - Value used when unset. In
	// this case, server behavior defaults to RECOMMENDATIONS_FILTERING_DISABLED.
	//   "RECOMMENDATIONS_FILTERING_DISABLED" - Recommendation filtering is
	// disabled.
	//   "RECOMMENDATIONS_FILTERING_ENABLED" - Recommendation filtering is enabled.
	RecommendationsFilteringOption string `json:"recommendationsFilteringOption,omitempty"`
	// RetrievableOption: If RETRIEVABLE_ENABLED, attribute values are retrievable
	// in the search results. If unset, the server behavior defaults to
	// RETRIEVABLE_DISABLED.
	//
	// Possible values:
	//   "RETRIEVABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "RETRIEVABLE_ENABLED" - Retrievable option enabled for an attribute.
	//   "RETRIEVABLE_DISABLED" - Retrievable option disabled for an attribute.
	RetrievableOption string `json:"retrievableOption,omitempty"`
	// SearchableOption: When AttributesConfig.attribute_config_level is
	// CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values are
	// searchable by text queries in SearchService.Search. If SEARCHABLE_ENABLED
	// but attribute type is numerical, attribute values will not be searchable by
	// text queries in SearchService.Search, as there are no text values associated
	// to numerical attributes. Must be specified, when
	// AttributesConfig.attribute_config_level is CATALOG_LEVEL_ATTRIBUTE_CONFIG,
	// otherwise throws INVALID_FORMAT error.
	//
	// Possible values:
	//   "SEARCHABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "SEARCHABLE_ENABLED" - Searchable option enabled for an attribute.
	//   "SEARCHABLE_DISABLED" - Searchable option disabled for an attribute.
	SearchableOption string `json:"searchableOption,omitempty"`
	// Type: Output only. The type of this attribute. This is derived from the
	// attribute in Product.attributes.
	//
	// Possible values:
	//   "UNKNOWN" - The type of the attribute is unknown. Used when type cannot be
	// derived from attribute that is not in_use.
	//   "TEXTUAL" - Textual attribute.
	//   "NUMERICAL" - Numerical attribute.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicFacetableOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicFacetableOption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCatalogAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalogAttribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCatalogAttributeFacetConfig: Possible options for
// the facet that corresponds to the current attribute config.
type GoogleCloudRetailV2alphaCatalogAttributeFacetConfig struct {
	// FacetIntervals: If you don't set the facet
	// SearchRequest.FacetSpec.FacetKey.intervals in the request to a numerical
	// attribute, then we use the computed intervals with rounded bounds obtained
	// from all its product numerical attribute values. The computed intervals
	// might not be ideal for some attributes. Therefore, we give you the option to
	// overwrite them with the facet_intervals field. The maximum of facet
	// intervals per CatalogAttribute is 40. Each interval must have a lower bound
	// or an upper bound. If both bounds are provided, then the lower bound must be
	// smaller or equal than the upper bound.
	FacetIntervals []*GoogleCloudRetailV2alphaInterval `json:"facetIntervals,omitempty"`
	// IgnoredFacetValues: Each instance represents a list of attribute values to
	// ignore as facet values for a specific time range. The maximum number of
	// instances per CatalogAttribute is 25.
	IgnoredFacetValues []*GoogleCloudRetailV2alphaCatalogAttributeFacetConfigIgnoredFacetValues `json:"ignoredFacetValues,omitempty"`
	// MergedFacet: Use this field only if you want to merge a facet key into
	// another facet key.
	MergedFacet *GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacet `json:"mergedFacet,omitempty"`
	// MergedFacetValues: Each instance replaces a list of facet values by a merged
	// facet value. If a facet value is not in any list, then it will stay the
	// same. To avoid conflicts, only paths of length 1 are accepted. In other
	// words, if "dark_blue" merged into "BLUE", then the latter can't merge into
	// "blues" because this would create a path of length 2. The maximum number of
	// instances of MergedFacetValue per CatalogAttribute is 100. This feature is
	// available only for textual custom attributes.
	MergedFacetValues []*GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacetValue `json:"mergedFacetValues,omitempty"`
	// RerankConfig: Set this field only if you want to rerank based on facet
	// values engaged by the user for the current key. This option is only possible
	// for custom facetable textual keys.
	RerankConfig *GoogleCloudRetailV2alphaCatalogAttributeFacetConfigRerankConfig `json:"rerankConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FacetIntervals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FacetIntervals") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCatalogAttributeFacetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalogAttributeFacetConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCatalogAttributeFacetConfigIgnoredFacetValues: Facet
// values to ignore on facets during the specified time range for the given
// SearchResponse.Facet.key attribute.
type GoogleCloudRetailV2alphaCatalogAttributeFacetConfigIgnoredFacetValues struct {
	// EndTime: If start time is empty and end time is not empty, then ignore these
	// facet values before end time.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Time range for the current list of facet values to ignore. If
	// multiple time ranges are specified for an facet value for the current
	// attribute, consider all of them. If both are empty, ignore always. If start
	// time and end time are set, then start time must be before end time. If start
	// time is not empty and end time is empty, then will ignore these facet values
	// after the start time.
	StartTime string `json:"startTime,omitempty"`
	// Values: List of facet values to ignore for the following time range. The
	// facet values are the same as the attribute values. There is a limit of 10
	// values per instance of IgnoredFacetValues. Each value can have at most 128
	// characters.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCatalogAttributeFacetConfigIgnoredFacetValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalogAttributeFacetConfigIgnoredFacetValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacet: The current
// facet key (i.e. attribute config) maps into the merged_facet_key. A facet
// key can have at most one child. The current facet key and the merged facet
// key need both to be textual custom attributes or both numerical custom
// attributes (same type).
type GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacet struct {
	// MergedFacetKey: The merged facet key should be a valid facet key that is
	// different than the facet key of the current catalog attribute. We refer this
	// is merged facet key as the child of the current catalog attribute. This
	// merged facet key can't be a parent of another facet key (i.e. no directed
	// path of length 2). This merged facet key needs to be either a textual custom
	// attribute or a numerical custom attribute.
	MergedFacetKey string `json:"mergedFacetKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergedFacetKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergedFacetKey") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacetValue:
// Replaces a set of textual facet values by the same (possibly different)
// merged facet value. Each facet value should appear at most once as a value
// per CatalogAttribute. This feature is available only for textual custom
// attributes.
type GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacetValue struct {
	// MergedValue: All the previous values are replaced by this merged facet
	// value. This merged_value must be non-empty and can have up to 128
	// characters.
	MergedValue string `json:"mergedValue,omitempty"`
	// Values: All the facet values that are replaces by the same merged_value that
	// follows. The maximum number of values per MergedFacetValue is 25. Each value
	// can have up to 128 characters.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergedValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergedValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacetValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalogAttributeFacetConfigMergedFacetValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCatalogAttributeFacetConfigRerankConfig: Options to
// rerank based on facet values engaged by the user for the current key. That
// key needs to be a custom textual key and facetable. To use this control, you
// also need to pass all the facet keys engaged by the user in the request
// using the field [SearchRequest.FacetSpec]. In particular, if you don't pass
// the facet keys engaged that you want to rerank on, this control won't be
// effective. Moreover, to obtain better results, the facet values that you
// want to rerank on should be close to English (ideally made of words,
// underscores, and spaces).
type GoogleCloudRetailV2alphaCatalogAttributeFacetConfigRerankConfig struct {
	// FacetValues: If empty, rerank on all facet values for the current key.
	// Otherwise, will rerank on the facet values from this list only.
	FacetValues []string `json:"facetValues,omitempty"`
	// RerankFacet: If set to true, then we also rerank the dynamic facets based on
	// the facet values engaged by the user for the current attribute key during
	// serving.
	RerankFacet bool `json:"rerankFacet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FacetValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FacetValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCatalogAttributeFacetConfigRerankConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCatalogAttributeFacetConfigRerankConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaColorInfo: The color information of a Product.
type GoogleCloudRetailV2alphaColorInfo struct {
	// ColorFamilies: The standard color families. Strongly recommended to use the
	// following standard color groups: "Red", "Pink", "Orange", "Yellow",
	// "Purple", "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and
	// "Mixed". Normally it is expected to have only 1 color family. May consider
	// using single "Mixed" instead of multiple values. A maximum of 5 values are
	// allowed. Each value must be a UTF-8 encoded string with a length limit of
	// 128 characters. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center property color
	// (https://support.google.com/merchants/answer/6324487). Schema.org property
	// Product.color (https://schema.org/color).
	ColorFamilies []string `json:"colorFamilies,omitempty"`
	// Colors: The color display names, which may be different from standard color
	// family names, such as the color aliases used in the website frontend.
	// Normally it is expected to have only 1 color. May consider using single
	// "Mixed" instead of multiple values. A maximum of 75 colors are allowed. Each
	// value must be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant Center
	// property color (https://support.google.com/merchants/answer/6324487).
	// Schema.org property Product.color (https://schema.org/color).
	Colors []string `json:"colors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColorFamilies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColorFamilies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaColorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaColorInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCompleteQueryResponse: Response of the autocomplete
// query.
type GoogleCloudRetailV2alphaCompleteQueryResponse struct {
	// AttributeResults: A map of matched attribute suggestions. This field is only
	// available for "cloud-retail" dataset. Current supported keys: * `brands` *
	// `categories`
	AttributeResults map[string]GoogleCloudRetailV2alphaCompleteQueryResponseAttributeResult `json:"attributeResults,omitempty"`
	// AttributionToken: A unique complete token. This should be included in the
	// UserEvent.completion_detail for search events resulting from this
	// completion, which enables accurate attribution of complete model
	// performance.
	AttributionToken string `json:"attributionToken,omitempty"`
	// CompletionResults: Results of the matching suggestions. The result list is
	// ordered and the first result is top suggestion.
	CompletionResults []*GoogleCloudRetailV2alphaCompleteQueryResponseCompletionResult `json:"completionResults,omitempty"`
	// RecentSearchResults: Deprecated. Matched recent searches of this user. The
	// maximum number of recent searches is 10. This field is a restricted feature.
	// If you want to enable it, contact Retail Search support. This feature is
	// only available when CompleteQueryRequest.visitor_id field is set and
	// UserEvent is imported. The recent searches satisfy the follow rules: * They
	// are ordered from latest to oldest. * They are matched with
	// CompleteQueryRequest.query case insensitively. * They are transformed to
	// lower case. * They are UTF-8 safe. Recent searches are deduplicated. More
	// recent searches will be reserved when duplication happens.
	RecentSearchResults []*GoogleCloudRetailV2alphaCompleteQueryResponseRecentSearchResult `json:"recentSearchResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributeResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCompleteQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCompleteQueryResponseAttributeResult: Resource that
// represents attribute results. The list of suggestions for the attribute.
type GoogleCloudRetailV2alphaCompleteQueryResponseAttributeResult struct {
	Suggestions []string `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCompleteQueryResponseAttributeResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCompleteQueryResponseAttributeResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCompleteQueryResponseCompletionResult: Resource that
// represents completion results.
type GoogleCloudRetailV2alphaCompleteQueryResponseCompletionResult struct {
	// Attributes: Custom attributes for the suggestion term. * For "user-data",
	// the attributes are additional custom attributes ingested through BigQuery. *
	// For "cloud-retail", the attributes are product attributes generated by Cloud
	// Retail. It requires UserEvent.product_details is imported properly.
	Attributes map[string]GoogleCloudRetailV2alphaCustomAttribute `json:"attributes,omitempty"`
	// Facets: Facet information for the suggestion term. Gives the number of items
	// resulting from a search with this suggestion term for each facet. This is an
	// experimental feature for limited customers. If you want to receive this
	// facet information, reach out to the Retail support team.
	Facets []*GoogleCloudRetailV2alphaSearchResponseFacet `json:"facets,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// TotalProductCount: Total number of products associated with a search with
	// this suggestion. This is an experimental feature for limited customers. If
	// you want to receive this product count information, reach out to the Retail
	// support team.
	TotalProductCount int64 `json:"totalProductCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCompleteQueryResponseCompletionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCompleteQueryResponseCompletionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCompleteQueryResponseRecentSearchResult: Deprecated:
// Recent search of this user.
type GoogleCloudRetailV2alphaCompleteQueryResponseRecentSearchResult struct {
	// RecentSearch: The recent search query.
	RecentSearch string `json:"recentSearch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecentSearch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecentSearch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCompleteQueryResponseRecentSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCompleteQueryResponseRecentSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCompletionConfig: Catalog level autocomplete config
// for customers to customize autocomplete feature's settings.
type GoogleCloudRetailV2alphaCompletionConfig struct {
	// AllowlistInputConfig: Output only. The source data for the latest import of
	// the autocomplete allowlist phrases.
	AllowlistInputConfig *GoogleCloudRetailV2alphaCompletionDataInputConfig `json:"allowlistInputConfig,omitempty"`
	// AutoLearning: If set to true, the auto learning function is enabled. Auto
	// learning uses user data to generate suggestions using ML techniques. Default
	// value is false. Only after enabling auto learning can users use
	// `cloud-retail` data in CompleteQueryRequest.
	AutoLearning bool `json:"autoLearning,omitempty"`
	// DenylistInputConfig: Output only. The source data for the latest import of
	// the autocomplete denylist phrases.
	DenylistInputConfig *GoogleCloudRetailV2alphaCompletionDataInputConfig `json:"denylistInputConfig,omitempty"`
	// LastAllowlistImportOperation: Output only. Name of the LRO corresponding to
	// the latest allowlist import. Can use GetOperation API to retrieve the latest
	// state of the Long Running Operation.
	LastAllowlistImportOperation string `json:"lastAllowlistImportOperation,omitempty"`
	// LastDenylistImportOperation: Output only. Name of the LRO corresponding to
	// the latest denylist import. Can use GetOperation API to retrieve the latest
	// state of the Long Running Operation.
	LastDenylistImportOperation string `json:"lastDenylistImportOperation,omitempty"`
	// LastSuggestionsImportOperation: Output only. Name of the LRO corresponding
	// to the latest suggestion terms list import. Can use GetOperation API method
	// to retrieve the latest state of the Long Running Operation.
	LastSuggestionsImportOperation string `json:"lastSuggestionsImportOperation,omitempty"`
	// MatchingOrder: Specifies the matching order for autocomplete suggestions,
	// e.g., a query consisting of 'sh' with 'out-of-order' specified would suggest
	// "women's shoes", whereas a query of 'red s' with 'exact-prefix' specified
	// would suggest "red shoes". Currently supported values: * 'out-of-order' *
	// 'exact-prefix' Default value: 'exact-prefix'.
	MatchingOrder string `json:"matchingOrder,omitempty"`
	// MaxSuggestions: The maximum number of autocomplete suggestions returned per
	// term. Default value is 20. If left unset or set to 0, then will fallback to
	// default value. Value range is 1 to 20.
	MaxSuggestions int64 `json:"maxSuggestions,omitempty"`
	// MinPrefixLength: The minimum number of characters needed to be typed in
	// order to get suggestions. Default value is 2. If left unset or set to 0,
	// then will fallback to default value. Value range is 1 to 20.
	MinPrefixLength int64 `json:"minPrefixLength,omitempty"`
	// Name: Required. Immutable. Fully qualified name
	// `projects/*/locations/*/catalogs/*/completionConfig`
	Name string `json:"name,omitempty"`
	// SuggestionsInputConfig: Output only. The source data for the latest import
	// of the autocomplete suggestion phrases.
	SuggestionsInputConfig *GoogleCloudRetailV2alphaCompletionDataInputConfig `json:"suggestionsInputConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowlistInputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistInputConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCompletionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCompletionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCompletionDataInputConfig: The input config source
// for completion data.
type GoogleCloudRetailV2alphaCompletionDataInputConfig struct {
	// BigQuerySource: Required. BigQuery input source. Add the IAM permission
	// "BigQuery Data Viewer" for
	// cloud-retail-customer-data-access@system.gserviceaccount.com before using
	// this feature otherwise an error is thrown.
	BigQuerySource *GoogleCloudRetailV2alphaBigQuerySource `json:"bigQuerySource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCompletionDataInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCompletionDataInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCompletionDetail: Detailed completion information
// including completion attribution token and clicked completion info.
type GoogleCloudRetailV2alphaCompletionDetail struct {
	// CompletionAttributionToken: Completion attribution token in
	// CompleteQueryResponse.attribution_token.
	CompletionAttributionToken string `json:"completionAttributionToken,omitempty"`
	// SelectedPosition: End user selected
	// CompleteQueryResponse.CompletionResult.suggestion position, starting from 0.
	SelectedPosition int64 `json:"selectedPosition,omitempty"`
	// SelectedSuggestion: End user selected
	// CompleteQueryResponse.CompletionResult.suggestion.
	SelectedSuggestion string `json:"selectedSuggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionAttributionToken")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionAttributionToken") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCompletionDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCompletionDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCondition: Metadata that is used to define a
// condition that triggers an action. A valid condition must specify at least
// one of 'query_terms' or 'products_filter'. If multiple fields are specified,
// the condition is met if all the fields are satisfied e.g. if a set of query
// terms and product_filter are set, then only items matching the
// product_filter for requests with a query matching the query terms wil get
// boosted.
type GoogleCloudRetailV2alphaCondition struct {
	// ActiveTimeRange: Range of time(s) specifying when Condition is active.
	// Condition true if any time range matches.
	ActiveTimeRange []*GoogleCloudRetailV2alphaConditionTimeRange `json:"activeTimeRange,omitempty"`
	// PageCategories: Used to support browse uses cases. A list (up to 10 entries)
	// of categories or departments. The format should be the same as
	// UserEvent.page_categories;
	PageCategories []string `json:"pageCategories,omitempty"`
	// QueryTerms: A list (up to 10 entries) of terms to match the query on. If not
	// specified, match all queries. If many query terms are specified, the
	// condition is matched if any of the terms is a match (i.e. using the OR
	// operator).
	QueryTerms []*GoogleCloudRetailV2alphaConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaConditionQueryTerm: Query terms that we want to
// match on.
type GoogleCloudRetailV2alphaConditionQueryTerm struct {
	// FullMatch: Whether this is supposed to be a full or partial match.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The value of the term to match on. Value cannot be empty. Value can
	// have at most 3 terms if specified as a partial match. Each space separated
	// string is considered as one term. For example, "a b c" is 3 terms and
	// allowed, but " a b c d" is 4 terms and not allowed for a partial match.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaConditionTimeRange: Used for time-dependent
// conditions. Example: Want to have rule applied for week long sale.
type GoogleCloudRetailV2alphaConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaControl: Configures dynamic metadata that can be
// linked to a ServingConfig and affect search or recommendation results at
// serving time.
type GoogleCloudRetailV2alphaControl struct {
	// AssociatedServingConfigIds: Output only. List of serving config ids that are
	// associated with this control in the same Catalog. Note the association is
	// managed via the ServingConfig, this is an output only denormalized view.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// DisplayName: Required. The human readable control display name. Used in
	// Retail UI. This field must be a UTF-8 encoded string with a length limit of
	// 128 characters. Otherwise, an INVALID_ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FacetSpec: A facet specification to perform faceted search. Note that this
	// field is deprecated and will throw NOT_IMPLEMENTED if used for creating a
	// control.
	FacetSpec *GoogleCloudRetailV2alphaSearchRequestFacetSpec `json:"facetSpec,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/catalogs/*/controls/*`
	Name string `json:"name,omitempty"`
	// Rule: A rule control - a condition-action pair. Enacts a set action when the
	// condition is triggered. For example: Boost "gShoe" when query full matches
	// "Running Shoes".
	Rule *GoogleCloudRetailV2alphaRule `json:"rule,omitempty"`
	// SearchSolutionUseCase: Specifies the use case for the control. Affects what
	// condition fields can be set. Only settable by search controls. Will default
	// to SEARCH_SOLUTION_USE_CASE_SEARCH if not specified. Currently only allow
	// one search_solution_use_case per control.
	//
	// Possible values:
	//   "SEARCH_SOLUTION_USE_CASE_UNSPECIFIED" - The value when it's unspecified.
	// In this case, server behavior defaults to SEARCH_SOLUTION_USE_CASE_SEARCH.
	//   "SEARCH_SOLUTION_USE_CASE_SEARCH" - Search use case. Expects the traffic
	// has a non-empty query.
	//   "SEARCH_SOLUTION_USE_CASE_BROWSE" - Browse use case. Expects the traffic
	// has an empty query.
	SearchSolutionUseCase []string `json:"searchSolutionUseCase,omitempty"`
	// SolutionTypes: Required. Immutable. The solution types that the control is
	// used for. Currently we support setting only one type of solution at creation
	// time. Only `SOLUTION_TYPE_SEARCH` value is supported at the moment. If no
	// solution type is provided at creation time, will default to
	// SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Retail Search.
	SolutionTypes []string `json:"solutionTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaControl) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCreateMerchantCenterAccountLinkMetadata: Common
// metadata related to the progress of the operations.
type GoogleCloudRetailV2alphaCreateMerchantCenterAccountLinkMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCreateMerchantCenterAccountLinkMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCreateMerchantCenterAccountLinkMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCreateModelMetadata: Metadata associated with a
// create operation.
type GoogleCloudRetailV2alphaCreateModelMetadata struct {
	// Model: The resource name of the model that this create applies to. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}`
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCreateModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCreateModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaCustomAttribute: A custom attribute that is not
// explicitly modeled in Product.
type GoogleCloudRetailV2alphaCustomAttribute struct {
	// Indexable: This field is normally ignored unless
	// AttributesConfig.attribute_config_level of the Catalog is set to the
	// deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
	// product-level attribute configuration, see Configuration modes
	// (https://cloud.google.com/retail/docs/attribute-config#config-modes). If
	// true, custom attribute values are indexed, so that they can be filtered,
	// faceted or boosted in SearchService.Search. This field is ignored in a
	// UserEvent. See SearchRequest.filter, SearchRequest.facet_specs and
	// SearchRequest.boost_spec for more details.
	Indexable bool `json:"indexable,omitempty"`
	// Numbers: The numerical values of this custom attribute. For example, `[2.3,
	// 15.4]` when the key is "lengths_cm". Exactly one of text or numbers should
	// be set. Otherwise, an INVALID_ARGUMENT error is returned.
	Numbers []float64 `json:"numbers,omitempty"`
	// Searchable: This field is normally ignored unless
	// AttributesConfig.attribute_config_level of the Catalog is set to the
	// deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
	// product-level attribute configuration, see Configuration modes
	// (https://cloud.google.com/retail/docs/attribute-config#config-modes). If
	// true, custom attribute values are searchable by text queries in
	// SearchService.Search. This field is ignored in a UserEvent. Only set if type
	// text is set. Otherwise, a INVALID_ARGUMENT error is returned.
	Searchable bool `json:"searchable,omitempty"`
	// Text: The textual values of this custom attribute. For example, `["yellow",
	// "green"]` when the key is "color". Empty string is not allowed. Otherwise,
	// an INVALID_ARGUMENT error is returned. Exactly one of text or numbers should
	// be set. Otherwise, an INVALID_ARGUMENT error is returned.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Indexable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Indexable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaCustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaCustomAttribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaCustomAttribute) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaCustomAttribute
	var s1 struct {
		Numbers []gensupport.JSONFloat64 `json:"numbers"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Numbers = make([]float64, len(s1.Numbers))
	for i := range s1.Numbers {
		s.Numbers[i] = float64(s1.Numbers[i])
	}
	return nil
}

// GoogleCloudRetailV2alphaEnrollSolutionMetadata: Metadata related to the
// EnrollSolution method. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaEnrollSolutionMetadata struct {
}

// GoogleCloudRetailV2alphaEnrollSolutionRequest: Request for EnrollSolution
// method.
type GoogleCloudRetailV2alphaEnrollSolutionRequest struct {
	// Solution: Required. Solution to enroll.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Retail Search.
	Solution string `json:"solution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Solution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Solution") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaEnrollSolutionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaEnrollSolutionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaEnrollSolutionResponse: Response for EnrollSolution
// method.
type GoogleCloudRetailV2alphaEnrollSolutionResponse struct {
	// EnrolledSolution: Retail API solution that the project has enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Retail Search.
	EnrolledSolution string `json:"enrolledSolution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnrolledSolution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnrolledSolution") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaEnrollSolutionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaEnrollSolutionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExperimentInfo: Metadata for active A/B testing
// Experiment.
type GoogleCloudRetailV2alphaExperimentInfo struct {
	// Experiment: The fully qualified resource name of the experiment that
	// provides the serving config under test, should an active experiment exist.
	// For example:
	// `projects/*/locations/global/catalogs/default_catalog/experiments/experiment_
	// id`
	Experiment string `json:"experiment,omitempty"`
	// ServingConfigExperiment: A/B test between existing Cloud Retail Search
	// ServingConfigs.
	ServingConfigExperiment *GoogleCloudRetailV2alphaExperimentInfoServingConfigExperiment `json:"servingConfigExperiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Experiment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Experiment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExperimentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExperimentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExperimentInfoServingConfigExperiment: Metadata for
// active serving config A/B tests.
type GoogleCloudRetailV2alphaExperimentInfoServingConfigExperiment struct {
	// ExperimentServingConfig: The fully qualified resource name of the serving
	// config Experiment.VariantArm.serving_config_id responsible for generating
	// the search response. For example:
	// `projects/*/locations/*/catalogs/*/servingConfigs/*`.
	ExperimentServingConfig string `json:"experimentServingConfig,omitempty"`
	// OriginalServingConfig: The fully qualified resource name of the original
	// SearchRequest.placement in the search request prior to reassignment by
	// experiment API. For example:
	// `projects/*/locations/*/catalogs/*/servingConfigs/*`.
	OriginalServingConfig string `json:"originalServingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExperimentServingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExperimentServingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExperimentInfoServingConfigExperiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExperimentInfoServingConfigExperiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportAnalyticsMetricsRequest: Request message for
// the `ExportAnalyticsMetrics` method.
type GoogleCloudRetailV2alphaExportAnalyticsMetricsRequest struct {
	// Filter: A filtering expression to specify restrictions on returned metrics.
	// The expression is a sequence of terms. Each term applies a restriction to
	// the returned metrics. Use this expression to restrict results to a specific
	// time range. Currently we expect only one types of fields: * `timestamp`:
	// This can be specified twice, once with a less than operator and once with a
	// greater than operator. The `timestamp` restriction should result in one,
	// contiguous, valid, `timestamp` range. Some examples of valid filters
	// expressions: * Example 1: `timestamp > "2012-04-23T18:25:43.511Z" timestamp
	// < "2012-04-23T18:30:43.511Z" * Example 2: `timestamp >
	// "2012-04-23T18:25:43.511Z"
	Filter string `json:"filter,omitempty"`
	// OutputConfig: Required. The output location of the data.
	OutputConfig *GoogleCloudRetailV2alphaOutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportAnalyticsMetricsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportAnalyticsMetricsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportAnalyticsMetricsResponse: Response of the
// ExportAnalyticsMetricsRequest. If the long running operation was successful,
// then this message is returned by the google.longrunning.Operations.response
// field if the operation was successful.
type GoogleCloudRetailV2alphaExportAnalyticsMetricsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: This field is never set.
	ErrorsConfig *GoogleCloudRetailV2alphaExportErrorsConfig `json:"errorsConfig,omitempty"`
	// OutputResult: Output result indicating where the data were exported to.
	OutputResult *GoogleCloudRetailV2alphaOutputResult `json:"outputResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportAnalyticsMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportAnalyticsMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportErrorsConfig: Configuration of destination for
// Export related errors.
type GoogleCloudRetailV2alphaExportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be an
	// empty, existing Cloud Storage bucket. Export errors will be written to a
	// file in this bucket, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportErrorsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportMetadata: Metadata related to the progress of
// the Export operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaExportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportProductsRequest: Request message for
// ExportProducts method.
type GoogleCloudRetailV2alphaExportProductsRequest struct {
	// Filter: A filtering expression to specify restrictions on returned events.
	// The expression is a sequence of terms. Each term applies a restriction to
	// the returned products. Use this expression to restrict results to a specific
	// time range, tag, or stock state or to filter products by product type. For
	// example, `lastModifiedTime > "2012-04-23T18:25:43.511Z"
	// lastModifiedTime<"2012-04-23T18:25:43.511Z" productType=primary` We expect
	// only four types of fields: * `lastModifiedTime`: This can be specified
	// twice, once with a less than operator and once with a greater than operator.
	// The `lastModifiedTime` restriction should result in one, contiguous, valid,
	// last-modified, time range. * `productType`: Supported values are `primary`
	// and `variant`. The Boolean operators `OR` and `NOT` are supported if the
	// expression is enclosed in parentheses and must be separated from the
	// `productType` values by a space. * `availability`: Supported values are
	// `IN_STOCK`, `OUT_OF_STOCK`, `PREORDER`, and `BACKORDER`. Boolean operators
	// `OR` and `NOT` are supported if the expression is enclosed in parentheses
	// and must be separated from the `availability` values by a space. * `Tag
	// expressions`: Restricts output to products that match all of the specified
	// tags. Boolean operators `OR` and `NOT` are supported if the expression is
	// enclosed in parentheses and the operators are separated from the tag values
	// by a space. Also supported is '`-"tagA"', which is equivalent to '`NOT
	// "tagA"'. Tag values must be double-quoted, UTF-8 encoded strings and have a
	// size limit of 1,000 characters. Some examples of valid filters expressions:
	// * Example 1: `lastModifiedTime > "2012-04-23T18:25:43.511Z" lastModifiedTime
	// < "2012-04-23T18:30:43.511Z" * Example 2: `lastModifiedTime >
	// "2012-04-23T18:25:43.511Z" productType = "variant" * Example 3: `tag=("Red"
	// OR "Blue") tag="New-Arrival" tag=(NOT "promotional") productType = "primary"
	// lastModifiedTime < "2018-04-23T18:30:43.511Z" * Example 4:
	// `lastModifiedTime > "2012-04-23T18:25:43.511Z" * Example 5: `availability =
	// (IN_STOCK OR BACKORDER)`
	Filter string `json:"filter,omitempty"`
	// OutputConfig: Required. The output location of the data.
	OutputConfig *GoogleCloudRetailV2alphaOutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportProductsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportProductsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportProductsResponse: Response of the
// ExportProductsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudRetailV2alphaExportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: This field is never set.
	ErrorsConfig *GoogleCloudRetailV2alphaExportErrorsConfig `json:"errorsConfig,omitempty"`
	// OutputResult: Output result indicating where the data were exported to.
	OutputResult *GoogleCloudRetailV2alphaOutputResult `json:"outputResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportUserEventsRequest: Request message for the
// `ExportUserEvents` method.
type GoogleCloudRetailV2alphaExportUserEventsRequest struct {
	// Filter: A filtering expression to specify restrictions on returned events.
	// The expression is a sequence of terms. Each term applies a restriction to
	// the returned user events. Use this expression to restrict results to a
	// specific time range or to filter events by eventType. For example,
	// `eventTime > "2012-04-23T18:25:43.511Z" eventsMissingCatalogItems
	// eventTime<"2012-04-23T18:25:43.511Z" eventType=search` We expect only three
	// types of fields: * `eventTime`: This can be specified twice, once with a
	// less than operator and once with a greater than operator. The `eventTime`
	// restriction should result in one, contiguous, valid, `eventTime` range. *
	// `eventType`: Boolean operators `OR` and `NOT` are supported if the
	// expression is enclosed in parentheses and the operators are separated from
	// the tag values by a space. * `eventsMissingCatalogItems`: This restricts
	// results to events for which catalog items were not found in the catalog. The
	// default behavior is to return only those events for which catalog items were
	// found. Some examples of valid filters expressions: * Example 1: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" * Example
	// 2: `eventTime > "2012-04-23T18:25:43.511Z" eventType = detail-page-view` *
	// Example 3: `eventsMissingCatalogItems eventType = (NOT search) eventTime <
	// "2018-04-23T18:30:43.511Z" * Example 4: `eventTime >
	// "2012-04-23T18:25:43.511Z" * Example 5: `eventType = (detail-page-view OR
	// search)` * Example 6: `eventsMissingCatalogItems`
	Filter string `json:"filter,omitempty"`
	// OutputConfig: Required. The output location of the data.
	OutputConfig *GoogleCloudRetailV2alphaOutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportUserEventsResponse: Response of the
// ExportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudRetailV2alphaExportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: This field is never set.
	ErrorsConfig *GoogleCloudRetailV2alphaExportErrorsConfig `json:"errorsConfig,omitempty"`
	// OutputResult: Output result indicating where the data were exported to.
	OutputResult *GoogleCloudRetailV2alphaOutputResult `json:"outputResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaExportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaFulfillmentInfo: Fulfillment information, such as
// the store IDs for in-store pickup or region IDs for different shipping
// methods.
type GoogleCloudRetailV2alphaFulfillmentInfo struct {
	// PlaceIds: The IDs for this type, such as the store IDs for
	// FulfillmentInfo.type.pickup-in-store or the region IDs for
	// FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are
	// allowed. Each value must be a string with a length limit of 30 characters,
	// matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2".
	// Otherwise, an INVALID_ARGUMENT error is returned.
	PlaceIds []string `json:"placeIds,omitempty"`
	// Type: The fulfillment type, including commonly used types (such as pickup in
	// store and same day delivery), and custom types. Customers have to map custom
	// types to their display names before rendering UI. Supported values: *
	// "pickup-in-store" * "ship-to-store" * "same-day-delivery" *
	// "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" *
	// "custom-type-4" * "custom-type-5" If this field is set to an invalid value
	// other than these, an INVALID_ARGUMENT error is returned.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PlaceIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PlaceIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaGcsOutputResult: A Gcs output result.
type GoogleCloudRetailV2alphaGcsOutputResult struct {
	// OutputUri: The uri of Gcs output
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaGcsOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaGcsOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaGcsSource: Google Cloud Storage location for input
// content.
type GoogleCloudRetailV2alphaGcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for product imports: * `product` (default): One JSON
	// Product per line. Each product must have a valid Product.id. *
	// `product_merchant_center`: See Importing catalog data from Merchant Center
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mc).
	// Supported values for user events imports: * `user_event` (default): One JSON
	// UserEvent per line. * `user_event_ga360`: Using
	// https://support.google.com/analytics/answer/3437719. Supported values for
	// control imports: * `control` (default): One JSON Control per line. Supported
	// values for catalog attribute imports: * `catalog_attribute` (default): One
	// CSV CatalogAttribute per line.
	DataSchema string `json:"dataSchema,omitempty"`
	// InputUris: Required. Google Cloud Storage URIs to input files. URI can be up
	// to 2000 characters long. URIs can match the full object path (for example,
	// `gs://bucket/directory/object.json`) or a pattern matching one or more
	// files, such as `gs://bucket/directory/*.json`. A request can contain at most
	// 100 files, and each file can be up to 2 GB. See Importing product
	// information
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog) for
	// the expected file format and setup instructions.
	InputUris []string `json:"inputUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaGetDefaultBranchResponse: Response message of
// CatalogService.GetDefaultBranch.
type GoogleCloudRetailV2alphaGetDefaultBranchResponse struct {
	// Branch: Full resource name of the branch id currently set as default branch.
	Branch string `json:"branch,omitempty"`
	// Note: This corresponds to SetDefaultBranchRequest.note field, when this
	// branch was set as default.
	Note string `json:"note,omitempty"`
	// SetTime: The time when this branch is set to default.
	SetTime string `json:"setTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Branch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Branch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaGetDefaultBranchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaGetDefaultBranchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImage: Product image. Recommendations AI and Retail
// Search do not use product images to improve prediction and search results.
// However, product images can be returned in results, and are shown in
// prediction or search previews in the console.
type GoogleCloudRetailV2alphaImage struct {
	// Height: Height of the image in number of pixels. This field must be
	// nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
	Height int64 `json:"height,omitempty"`
	// Uri: Required. URI of the image. This field must be a valid UTF-8 encoded
	// URI with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. Google Merchant Center property image_link
	// (https://support.google.com/merchants/answer/6324350). Schema.org property
	// Product.image (https://schema.org/image).
	Uri string `json:"uri,omitempty"`
	// Width: Width of the image in number of pixels. This field must be
	// nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportCompletionDataRequest: Request message for
// ImportCompletionData methods.
type GoogleCloudRetailV2alphaImportCompletionDataRequest struct {
	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2alphaCompletionDataInputConfig `json:"inputConfig,omitempty"`
	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If this
	// field is set, when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a Operation.
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportCompletionDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportCompletionDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportCompletionDataResponse: Response of the
// ImportCompletionDataRequest. If the long running operation is done, this
// message is returned by the google.longrunning.Operations.response field if
// the operation is successful.
type GoogleCloudRetailV2alphaImportCompletionDataResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportCompletionDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportCompletionDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportErrorsConfig: Configuration of destination for
// Import related errors.
type GoogleCloudRetailV2alphaImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportErrorsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportMetadata: Metadata related to the progress of
// the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If this
	// field is set, when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a Operation.
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`
	// RequestId: Deprecated. This field is never set.
	RequestId string `json:"requestId,omitempty"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TransformedUserEventsMetadata: Metadata related to transform user events.
	TransformedUserEventsMetadata *GoogleCloudRetailV2alphaTransformedUserEventsMetadata `json:"transformedUserEventsMetadata,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportProductsRequest: Request message for Import
// methods.
type GoogleCloudRetailV2alphaImportProductsRequest struct {
	// ErrorsConfig: The desired location of errors incurred during the Import.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`
	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2alphaProductInputConfig `json:"inputConfig,omitempty"`
	// NotificationPubsubTopic: Full Pub/Sub topic name for receiving notification.
	// If this field is set, when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a Operation.
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
	// to be within the same project as ImportProductsRequest.parent. Make sure
	// that both `cloud-retail-customer-data-access@system.gserviceaccount.com` and
	// `service-@gcp-sa-retail.iam.gserviceaccount.com` have the
	// `pubsub.topics.publish` IAM permission on the topic. Only supported when
	// ImportProductsRequest.reconciliation_mode is set to `FULL`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`
	// ReconciliationMode: The mode of reconciliation between existing products and
	// the products to be imported. Defaults to ReconciliationMode.INCREMENTAL.
	//
	// Possible values:
	//   "RECONCILIATION_MODE_UNSPECIFIED" - Defaults to INCREMENTAL.
	//   "INCREMENTAL" - Inserts new products or updates existing products.
	//   "FULL" - Calculates diff and replaces the entire product dataset. Existing
	// products may be deleted if they are not present in the source location.
	ReconciliationMode string `json:"reconciliationMode,omitempty"`
	// RequestId: Deprecated. This field has no effect.
	RequestId string `json:"requestId,omitempty"`
	// SkipDefaultBranchProtection: If true, this performs the FULL import even if
	// it would delete a large proportion of the products in the default branch,
	// which could potentially cause outages if you have live predict/search
	// traffic. Only supported when ImportProductsRequest.reconciliation_mode is
	// set to `FULL`.
	SkipDefaultBranchProtection bool `json:"skipDefaultBranchProtection,omitempty"`
	// UpdateMask: Indicates which fields in the provided imported `products` to
	// update. If not set, all fields are updated. If provided, only the existing
	// product fields are updated. Missing products will not be created.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorsConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorsConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportProductsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportProductsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudRetailV2alphaImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportUserEventsRequest: Request message for the
// ImportUserEvents request.
type GoogleCloudRetailV2alphaImportUserEventsRequest struct {
	// ErrorsConfig: The desired location of errors incurred during the Import.
	// Cannot be set for inline user event imports.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`
	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2alphaUserEventInputConfig `json:"inputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorsConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorsConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudRetailV2alphaImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`
	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2alphaUserEventImportSummary `json:"importSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaInterval: A floating point interval.
type GoogleCloudRetailV2alphaInterval struct {
	// ExclusiveMaximum: Exclusive upper bound.
	ExclusiveMaximum float64 `json:"exclusiveMaximum,omitempty"`
	// ExclusiveMinimum: Exclusive lower bound.
	ExclusiveMinimum float64 `json:"exclusiveMinimum,omitempty"`
	// Maximum: Inclusive upper bound.
	Maximum float64 `json:"maximum,omitempty"`
	// Minimum: Inclusive lower bound.
	Minimum float64 `json:"minimum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExclusiveMaximum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExclusiveMaximum") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaInterval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaInterval
	var s1 struct {
		ExclusiveMaximum gensupport.JSONFloat64 `json:"exclusiveMaximum"`
		ExclusiveMinimum gensupport.JSONFloat64 `json:"exclusiveMinimum"`
		Maximum          gensupport.JSONFloat64 `json:"maximum"`
		Minimum          gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExclusiveMaximum = float64(s1.ExclusiveMaximum)
	s.ExclusiveMinimum = float64(s1.ExclusiveMinimum)
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudRetailV2alphaListBranchesResponse: Response for
// BranchService.ListBranches method.
type GoogleCloudRetailV2alphaListBranchesResponse struct {
	// Branches: The Branches.
	Branches []*GoogleCloudRetailV2alphaBranch `json:"branches,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Branches") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Branches") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListBranchesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListBranchesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListCatalogsResponse: Response for
// CatalogService.ListCatalogs method.
type GoogleCloudRetailV2alphaListCatalogsResponse struct {
	// Catalogs: All the customer's Catalogs.
	Catalogs []*GoogleCloudRetailV2alphaCatalog `json:"catalogs,omitempty"`
	// NextPageToken: A token that can be sent as ListCatalogsRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Catalogs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Catalogs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListCatalogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListCatalogsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListControlsResponse: Response for ListControls
// method.
type GoogleCloudRetailV2alphaListControlsResponse struct {
	// Controls: All the Controls for a given catalog.
	Controls []*GoogleCloudRetailV2alphaControl `json:"controls,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Controls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Controls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListControlsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListControlsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListEnrolledSolutionsResponse: Response for
// ListEnrolledSolutions method.
type GoogleCloudRetailV2alphaListEnrolledSolutionsResponse struct {
	// EnrolledSolutions: Retail API solutions that the project has enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Retail Search.
	EnrolledSolutions []string `json:"enrolledSolutions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EnrolledSolutions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnrolledSolutions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListEnrolledSolutionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListEnrolledSolutionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListMerchantCenterAccountLinksResponse: Response for
// MerchantCenterAccountLinkService.ListMerchantCenterAccountLinks method.
type GoogleCloudRetailV2alphaListMerchantCenterAccountLinksResponse struct {
	// MerchantCenterAccountLinks: The links.
	MerchantCenterAccountLinks []*GoogleCloudRetailV2alphaMerchantCenterAccountLink `json:"merchantCenterAccountLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MerchantCenterAccountLinks")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MerchantCenterAccountLinks") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListMerchantCenterAccountLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListMerchantCenterAccountLinksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListModelsResponse: Response to a ListModelRequest.
type GoogleCloudRetailV2alphaListModelsResponse struct {
	// Models: List of Models.
	Models []*GoogleCloudRetailV2alphaModel `json:"models,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListProductsResponse: Response message for
// ProductService.ListProducts method.
type GoogleCloudRetailV2alphaListProductsResponse struct {
	// NextPageToken: A token that can be sent as ListProductsRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Products: The Products.
	Products []*GoogleCloudRetailV2alphaProduct `json:"products,omitempty"`
	// TotalSize: The total count of matched Products irrespective of pagination.
	// The total number of Products returned by pagination may be less than the
	// total_size that matches. This field is ignored if
	// ListProductsRequest.require_total_size is not set or
	// ListProductsRequest.page_token is not empty.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaListServingConfigsResponse: Response for
// ListServingConfigs method.
type GoogleCloudRetailV2alphaListServingConfigsResponse struct {
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ServingConfigs: All the ServingConfigs for a given catalog.
	ServingConfigs []*GoogleCloudRetailV2alphaServingConfig `json:"servingConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaListServingConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaListServingConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaLocalInventory: The inventory information at a place
// (e.g. a store) identified by a place ID.
type GoogleCloudRetailV2alphaLocalInventory struct {
	// Attributes: Additional local inventory attributes, for example, store name,
	// promotion tags, etc. This field needs to pass all below criteria, otherwise
	// an INVALID_ARGUMENT error is returned: * At most 30 attributes are allowed.
	// * The key must be a UTF-8 encoded string with a length limit of 32
	// characters. * The key must match the pattern: `a-zA-Z0-9*`. For example,
	// key0LikeThis or KEY_1_LIKE_THIS. * The attribute values must be of the same
	// type (text or number). * Only 1 value is allowed for each attribute. * For
	// text values, the length limit is 256 UTF-8 characters. * The attribute does
	// not support search. The `searchable` field should be unset or set to false.
	// * The max summed total bytes of custom attribute keys and values per product
	// is 5MiB.
	Attributes map[string]GoogleCloudRetailV2alphaCustomAttribute `json:"attributes,omitempty"`
	// FulfillmentTypes: Input only. Supported fulfillment types. Valid fulfillment
	// type values include commonly used types (such as pickup in store and same
	// day delivery), and custom types. Customers have to map custom types to their
	// display names before rendering UI. Supported values: * "pickup-in-store" *
	// "ship-to-store" * "same-day-delivery" * "next-day-delivery" *
	// "custom-type-1" * "custom-type-2" * "custom-type-3" * "custom-type-4" *
	// "custom-type-5" If this field is set to an invalid value other than these,
	// an INVALID_ARGUMENT error is returned. All the elements must be distinct.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	FulfillmentTypes []string `json:"fulfillmentTypes,omitempty"`
	// PlaceId: The place ID for the current set of inventory information.
	PlaceId string `json:"placeId,omitempty"`
	// PriceInfo: Product price and cost information. Google Merchant Center
	// property price (https://support.google.com/merchants/answer/6324371).
	PriceInfo *GoogleCloudRetailV2alphaPriceInfo `json:"priceInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaLocalInventory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaLocalInventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaLoggingConfig: Project level logging config to
// control what level of log will be generated and written to Cloud Logging.
type GoogleCloudRetailV2alphaLoggingConfig struct {
	// DefaultLogGenerationRule: The log generation rule that applies by default to
	// all services supporting log generation. It can be overridden by
	// ServiceLogGenerationRule for service level control.
	DefaultLogGenerationRule *GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule `json:"defaultLogGenerationRule,omitempty"`
	// Name: Required. Immutable. The name of the LoggingConfig singleton resource.
	// Format: projects/*/loggingConfig
	Name string `json:"name,omitempty"`
	// ServiceLogGenerationRules: Controls logging configurations more granularly
	// for each supported service. This overrides the default_log_generation_rule
	// for the services specified. For those not mentioned, they will fallback to
	// the default log generation rule.
	ServiceLogGenerationRules []*GoogleCloudRetailV2alphaLoggingConfigServiceLogGenerationRule `json:"serviceLogGenerationRules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DefaultLogGenerationRule")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultLogGenerationRule") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaLoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaLoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule: The logging
// configurations for services supporting log generation.
type GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule struct {
	// InfoLogSampleRate: The log sample rate for INFO level log entries. You can
	// use this to reduce the number of entries generated for INFO level logs. DO
	// NOT set this field if the logging_level is not LoggingLevel.LOG_ALL.
	// Otherwise, an INVALID_ARGUMENT error is returned. Sample rate for INFO logs
	// defaults to 1 when unset (generate and send all INFO logs to Cloud Logging).
	// Its value must be greater than 0 and less than or equal to 1.
	InfoLogSampleRate float64 `json:"infoLogSampleRate,omitempty"`
	// LoggingLevel: The logging level. By default it is set to
	// `LOG_WARNINGS_AND_ABOVE`.
	//
	// Possible values:
	//   "LOGGING_LEVEL_UNSPECIFIED" - Default value. Defaults to
	// `LOG_FOR_WARNINGS_AND_ABOVE` if unset.
	//   "LOGGING_DISABLED" - No log will be generated and sent to Cloud Logging.
	//   "LOG_ERRORS_AND_ABOVE" - Log for operations resulted in fatal error.
	//   "LOG_WARNINGS_AND_ABOVE" - In addition to `LOG_ERRORS_AND_ABOVE`, also log
	// for operations that have soft errors, quality suggestions.
	//   "LOG_ALL" - Log all operations, including successful ones.
	LoggingLevel string `json:"loggingLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoLogSampleRate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoLogSampleRate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule
	var s1 struct {
		InfoLogSampleRate gensupport.JSONFloat64 `json:"infoLogSampleRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.InfoLogSampleRate = float64(s1.InfoLogSampleRate)
	return nil
}

// GoogleCloudRetailV2alphaLoggingConfigServiceLogGenerationRule: The granular
// logging configurations for supported services.
type GoogleCloudRetailV2alphaLoggingConfigServiceLogGenerationRule struct {
	// LogGenerationRule: The log generation rule that applies to this service.
	LogGenerationRule *GoogleCloudRetailV2alphaLoggingConfigLogGenerationRule `json:"logGenerationRule,omitempty"`
	// ServiceName: Required. Supported service names: "CatalogService",
	// "CompletionService", "ControlService", "MerchantCenterStreaming",
	// "ModelService", "PredictionService", "ProductService",
	// "ServingConfigService", "UserEventService",
	ServiceName string `json:"serviceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogGenerationRule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogGenerationRule") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaLoggingConfigServiceLogGenerationRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaLoggingConfigServiceLogGenerationRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaMerchantCenterAccountLink: Represents a link between
// a Merchant Center account and a branch. After a link is established,
// products from the linked Merchant Center account are streamed to the linked
// branch.
type GoogleCloudRetailV2alphaMerchantCenterAccountLink struct {
	// BranchId: Required. The branch ID (e.g. 0/1/2) within the catalog that
	// products from merchant_center_account_id are streamed to. When updating this
	// field, an empty value will use the currently configured default branch.
	// However, changing the default branch later on won't change the linked branch
	// here. A single branch ID can only have one linked Merchant Center account
	// ID.
	BranchId string `json:"branchId,omitempty"`
	// FeedFilters: Criteria for the Merchant Center feeds to be ingested via the
	// link. All offers will be ingested if the list is empty. Otherwise the offers
	// will be ingested from selected feeds.
	FeedFilters []*GoogleCloudRetailV2alphaMerchantCenterAccountLinkMerchantCenterFeedFilter `json:"feedFilters,omitempty"`
	// FeedLabel: The FeedLabel used to perform filtering. Note: this replaces
	// region_id
	// (https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.feed_label).
	// Example value: `US`. Example value: `FeedLabel1`.
	FeedLabel string `json:"feedLabel,omitempty"`
	// Id: Output only. Immutable. MerchantCenterAccountLink identifier, which is
	// the final component of name. This field is auto generated and follows the
	// convention: `BranchId_MerchantCenterAccountId`.
	// `projects/*/locations/global/catalogs/default_catalog/merchantCenterAccountLi
	// nks/id_1`.
	Id string `json:"id,omitempty"`
	// LanguageCode: Language of the title/description and other string attributes.
	// Use language tags defined by BCP 47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). ISO 639-1. This specifies
	// the language of offers in Merchant Center that will be accepted. If empty,
	// no language filtering will be performed. Example value: `en`.
	LanguageCode string `json:"languageCode,omitempty"`
	// MerchantCenterAccountId: Required. The linked Merchant center account id
	// (https://developers.google.com/shopping-content/guides/accountstatuses). The
	// account must be a standalone account or a sub-account of a MCA.
	MerchantCenterAccountId int64 `json:"merchantCenterAccountId,omitempty,string"`
	// Name: Output only. Immutable. Full resource name of the Merchant Center
	// Account Link, such as
	// `projects/*/locations/global/catalogs/default_catalog/merchantCenterAccountLi
	// nks/merchant_center_account_link`.
	Name string `json:"name,omitempty"`
	// ProjectId: Output only. Google Cloud project ID.
	ProjectId string `json:"projectId,omitempty"`
	// Source: Optional. An optional arbitrary string that could be used as a tag
	// for tracking link source.
	Source string `json:"source,omitempty"`
	// State: Output only. Represents the state of the link.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "PENDING" - Link is created and LRO is not complete.
	//   "ACTIVE" - Link is active.
	//   "FAILED" - Link creation failed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BranchId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BranchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaMerchantCenterAccountLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaMerchantCenterAccountLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaMerchantCenterAccountLinkMerchantCenterFeedFilter:
// Merchant Center Feed filter criterion.
type GoogleCloudRetailV2alphaMerchantCenterAccountLinkMerchantCenterFeedFilter struct {
	// PrimaryFeedId: Merchant Center primary feed ID.
	PrimaryFeedId int64 `json:"primaryFeedId,omitempty,string"`
	// PrimaryFeedName: Merchant Center primary feed name. The name is used for the
	// display purposes only.
	PrimaryFeedName string `json:"primaryFeedName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrimaryFeedId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrimaryFeedId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaMerchantCenterAccountLinkMerchantCenterFeedFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaMerchantCenterAccountLinkMerchantCenterFeedFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaMerchantCenterFeedFilter: Merchant Center Feed
// filter criterion.
type GoogleCloudRetailV2alphaMerchantCenterFeedFilter struct {
	// PrimaryFeedId: Merchant Center primary feed ID.
	PrimaryFeedId int64 `json:"primaryFeedId,omitempty,string"`
	// PrimaryFeedName: Merchant Center primary feed name. The name is used for the
	// display purposes only.
	PrimaryFeedName string `json:"primaryFeedName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrimaryFeedId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrimaryFeedId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaMerchantCenterFeedFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaMerchantCenterFeedFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaMerchantCenterLink: Represents a link between a
// Merchant Center account and a branch. After a link is established, products
// from the linked Merchant Center account are streamed to the linked branch.
type GoogleCloudRetailV2alphaMerchantCenterLink struct {
	// BranchId: The branch ID (e.g. 0/1/2) within this catalog that products from
	// merchant_center_account_id are streamed to. When updating this field, an
	// empty value will use the currently configured default branch. However,
	// changing the default branch later on won't change the linked branch here. A
	// single branch ID can only have one linked Merchant Center account ID.
	BranchId string `json:"branchId,omitempty"`
	// Destinations: String representing the destination to import for, all if left
	// empty. List of possible values is given in Included destination
	// (https://support.google.com/merchants/answer/7501026). List of allowed
	// string values: "Shopping_ads", "Buy_on_google_listings", "Display_ads",
	// "Local_inventory _ads", "Free_listings", "Free_local_listings" NOTE: The
	// string values are case sensitive.
	Destinations []string `json:"destinations,omitempty"`
	// Feeds: Criteria for the Merchant Center feeds to be ingested via the link.
	// All offers will be ingested if the list is empty. Otherwise the offers will
	// be ingested from selected feeds.
	Feeds []*GoogleCloudRetailV2alphaMerchantCenterFeedFilter `json:"feeds,omitempty"`
	// LanguageCode: Language of the title/description and other string attributes.
	// Use language tags defined by BCP 47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). ISO 639-1. This specifies
	// the language of offers in Merchant Center that will be accepted. If empty no
	// language filtering will be performed. Example value: `en`.
	LanguageCode string `json:"languageCode,omitempty"`
	// MerchantCenterAccountId: Required. The linked Merchant Center account ID
	// (https://developers.google.com/shopping-content/guides/accountstatuses). The
	// account must be a standalone account or a sub-account of a MCA.
	MerchantCenterAccountId int64 `json:"merchantCenterAccountId,omitempty,string"`
	// RegionCode: Region code of offers to accept. 2-letter Uppercase ISO 3166-1
	// alpha-2 code. List of values can be found here
	// (https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
	// under the `region` tag. If left blank no region filtering will be performed.
	// Example value: `US`.
	RegionCode string `json:"regionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BranchId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BranchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaMerchantCenterLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaMerchantCenterLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaMerchantCenterLinkingConfig: Configures Merchant
// Center linking. Links contained in the config will be used to sync data from
// a Merchant Center account to a Cloud Retail branch.
type GoogleCloudRetailV2alphaMerchantCenterLinkingConfig struct {
	// Links: Links between Merchant Center accounts and branches.
	Links []*GoogleCloudRetailV2alphaMerchantCenterLink `json:"links,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Links") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Links") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaMerchantCenterLinkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaMerchantCenterLinkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaModel: Metadata that describes the training and
// serving parameters of a Model. A Model can be associated with a
// ServingConfig and then queried through the Predict API.
type GoogleCloudRetailV2alphaModel struct {
	// CreateTime: Output only. Timestamp the Recommendation Model was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataState: Output only. The state of data requirements for this model:
	// `DATA_OK` and `DATA_ERROR`. Recommendation model cannot be trained if the
	// data is in `DATA_ERROR` state. Recommendation model can have `DATA_ERROR`
	// state even if serving state is `ACTIVE`: models were trained successfully
	// before, but cannot be refreshed because model no longer has sufficient data
	// for training.
	//
	// Possible values:
	//   "DATA_STATE_UNSPECIFIED" - Unspecified default value, should never be
	// explicitly set.
	//   "DATA_OK" - The model has sufficient training data.
	//   "DATA_ERROR" - The model does not have sufficient training data. Error
	// messages can be queried via Stackdriver.
	DataState string `json:"dataState,omitempty"`
	// DisplayName: Required. The display name of the model. Should be human
	// readable, used to display Recommendation Models in the Retail Cloud Console
	// Dashboard. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// FilteringOption: Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`,
	// recommendation filtering by attributes is enabled for the model.
	//
	// Possible values:
	//   "RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED" - Value used when unset. In
	// this case, server behavior defaults to RECOMMENDATIONS_FILTERING_DISABLED.
	//   "RECOMMENDATIONS_FILTERING_DISABLED" - Recommendation filtering is
	// disabled.
	//   "RECOMMENDATIONS_FILTERING_ENABLED" - Recommendation filtering is enabled.
	FilteringOption string `json:"filteringOption,omitempty"`
	// LastTuneTime: Output only. The timestamp when the latest successful tune
	// finished.
	LastTuneTime string `json:"lastTuneTime,omitempty"`
	// ModelFeaturesConfig: Optional. Additional model features config.
	ModelFeaturesConfig *GoogleCloudRetailV2alphaModelModelFeaturesConfig `json:"modelFeaturesConfig,omitempty"`
	// Name: Required. The fully qualified resource name of the model. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}` catalog_id has char limit of 50. recommendation_model_id has
	// char limit of 40.
	Name string `json:"name,omitempty"`
	// OptimizationObjective: Optional. The optimization objective e.g. `cvr`.
	// Currently supported values: `ctr`, `cvr`, `revenue-per-order`. If not
	// specified, we choose default based on model type. Default depends on type of
	// recommendation: `recommended-for-you` => `ctr` `others-you-may-like` =>
	// `ctr` `frequently-bought-together` => `revenue_per_order` This field
	// together with optimization_objective describe model metadata to use to
	// control model training and serving. See
	// https://cloud.google.com/retail/docs/models for more details on what the
	// model metadata control and which combination of parameters are valid. For
	// invalid combinations of parameters (e.g. type = `frequently-bought-together`
	// and optimization_objective = `ctr`), you receive an error 400 if you try to
	// create/update a recommendation with this set of knobs.
	OptimizationObjective string `json:"optimizationObjective,omitempty"`
	// PageOptimizationConfig: Optional. The page optimization config.
	PageOptimizationConfig *GoogleCloudRetailV2alphaModelPageOptimizationConfig `json:"pageOptimizationConfig,omitempty"`
	// PeriodicTuningState: Optional. The state of periodic tuning. The period we
	// use is 3 months - to do a one-off tune earlier use the `TuneModel` method.
	// Default value is `PERIODIC_TUNING_ENABLED`.
	//
	// Possible values:
	//   "PERIODIC_TUNING_STATE_UNSPECIFIED" - Unspecified default value, should
	// never be explicitly set.
	//   "PERIODIC_TUNING_DISABLED" - The model has periodic tuning disabled.
	// Tuning can be reenabled by calling the `EnableModelPeriodicTuning` method or
	// by calling the `TuneModel` method.
	//   "ALL_TUNING_DISABLED" - The model cannot be tuned with periodic tuning OR
	// the `TuneModel` method. Hide the options in customer UI and reject any
	// requests through the backend self serve API.
	//   "PERIODIC_TUNING_ENABLED" - The model has periodic tuning enabled. Tuning
	// can be disabled by calling the `DisableModelPeriodicTuning` method.
	PeriodicTuningState string `json:"periodicTuningState,omitempty"`
	// ServingConfigLists: Output only. The list of valid serving configs
	// associated with the PageOptimizationConfig.
	ServingConfigLists []*GoogleCloudRetailV2alphaModelServingConfigList `json:"servingConfigLists,omitempty"`
	// ServingState: Output only. The serving state of the model: `ACTIVE`,
	// `NOT_ACTIVE`.
	//
	// Possible values:
	//   "SERVING_STATE_UNSPECIFIED" - Unspecified serving state.
	//   "INACTIVE" - The model is not serving.
	//   "ACTIVE" - The model is serving and can be queried.
	//   "TUNED" - The model is trained on tuned hyperparameters and can be
	// queried.
	ServingState string `json:"servingState,omitempty"`
	// TrainingState: Optional. The training state that the model is in (e.g.
	// `TRAINING` or `PAUSED`). Since part of the cost of running the service is
	// frequency of training - this can be used to determine when to train model in
	// order to control cost. If not specified: the default value for `CreateModel`
	// method is `TRAINING`. The default value for `UpdateModel` method is to keep
	// the state the same as before.
	//
	// Possible values:
	//   "TRAINING_STATE_UNSPECIFIED" - Unspecified training state.
	//   "PAUSED" - The model training is paused.
	//   "TRAINING" - The model is training.
	TrainingState string `json:"trainingState,omitempty"`
	// TuningOperation: Output only. The tune operation associated with the model.
	// Can be used to determine if there is an ongoing tune for this
	// recommendation. Empty field implies no tune is goig on.
	TuningOperation string `json:"tuningOperation,omitempty"`
	// Type: Required. The type of model e.g. `home-page`. Currently supported
	// values: `recommended-for-you`, `others-you-may-like`,
	// `frequently-bought-together`, `page-optimization`, `similar-items`,
	// `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value). This
	// field together with optimization_objective describe model metadata to use to
	// control model training and serving. See
	// https://cloud.google.com/retail/docs/models for more details on what the
	// model metadata control and which combination of parameters are valid. For
	// invalid combinations of parameters (e.g. type = `frequently-bought-together`
	// and optimization_objective = `ctr`), you receive an error 400 if you try to
	// create/update a recommendation with this set of knobs.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Model was last
	// updated. E.g. if a Recommendation Model was paused - this would be the time
	// the pause was initiated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaModelFrequentlyBoughtTogetherFeaturesConfig:
// Additional configs for the frequently-bought-together model type.
type GoogleCloudRetailV2alphaModelFrequentlyBoughtTogetherFeaturesConfig struct {
	// ContextProductsType: Optional. Specifies the context of the model when it is
	// used in predict requests. Can only be set for the
	// `frequently-bought-together` type. If it isn't specified, it defaults to
	// MULTIPLE_CONTEXT_PRODUCTS.
	//
	// Possible values:
	//   "CONTEXT_PRODUCTS_TYPE_UNSPECIFIED" - Unspecified default value, should
	// never be explicitly set. Defaults to MULTIPLE_CONTEXT_PRODUCTS.
	//   "SINGLE_CONTEXT_PRODUCT" - Use only a single product as context for the
	// recommendation. Typically used on pages like add-to-cart or product details.
	//   "MULTIPLE_CONTEXT_PRODUCTS" - Use one or multiple products as context for
	// the recommendation. Typically used on shopping cart pages.
	ContextProductsType string `json:"contextProductsType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextProductsType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextProductsType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaModelFrequentlyBoughtTogetherFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaModelFrequentlyBoughtTogetherFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaModelModelFeaturesConfig: Additional model features
// config.
type GoogleCloudRetailV2alphaModelModelFeaturesConfig struct {
	// FrequentlyBoughtTogetherConfig: Additional configs for
	// frequently-bought-together models.
	FrequentlyBoughtTogetherConfig *GoogleCloudRetailV2alphaModelFrequentlyBoughtTogetherFeaturesConfig `json:"frequentlyBoughtTogetherConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "FrequentlyBoughtTogetherConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FrequentlyBoughtTogetherConfig")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaModelModelFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaModelModelFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaModelPageOptimizationConfig: The
// PageOptimizationConfig for model training. This determines how many panels
// to optimize for, and which serving configs to consider for each panel. The
// purpose of this model is to optimize which ServingConfig to show on which
// panels in way that optimizes the visitors shopping journey.
type GoogleCloudRetailV2alphaModelPageOptimizationConfig struct {
	// PageOptimizationEventType: Required. The type of UserEvent this page
	// optimization is shown for. Each page has an associated event type - this
	// will be the corresponding event type for the page that the page optimization
	// model is used on. Supported types: * `add-to-cart`: Products being added to
	// cart. * `detail-page-view`: Products detail page viewed. * `home-page-view`:
	// Homepage viewed * `category-page-view`: Homepage viewed *
	// `shopping-cart-page-view`: User viewing a shopping cart. `home-page-view`
	// only allows models with type `recommended-for-you`. All other
	// page_optimization_event_type allow all Model.types.
	PageOptimizationEventType string `json:"pageOptimizationEventType,omitempty"`
	// Panels: Required. A list of panel configurations. Limit = 5.
	Panels []*GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel `json:"panels,omitempty"`
	// Restriction: Optional. How to restrict results across panels e.g. can the
	// same ServingConfig be shown on multiple panels at once. If unspecified,
	// default to `UNIQUE_MODEL_RESTRICTION`.
	//
	// Possible values:
	//   "RESTRICTION_UNSPECIFIED" - Unspecified value for restriction.
	//   "NO_RESTRICTION" - Allow any ServingConfig to be show on any number of
	// panels. Example: `Panel1 candidates`: pdp_ctr, pdp_cvr,
	// home_page_ctr_no_diversity `Panel2 candidates`: home_page_ctr_no_diversity,
	// home_page_ctr_diversity, pdp_cvr_no_diversity `Restriction` = NO_RESTRICTION
	// `Valid combinations`: * * (pdp_ctr, home_page_ctr_no_diversity) * (pdp_ctr,
	// home_page_ctr_diversity) * (pdp_ctr, pdp_cvr_no_diversity) * (pdp_cvr,
	// home_page_ctr_no_diversity) * (pdp_cvr, home_page_ctr_diversity) * (pdp_cvr,
	// pdp_cvr_no_diversity) * (home_page_ctr_no_diversity,
	// home_page_ctr_no_diversity) * (home_page_ctr_no_diversity,
	// home_page_ctr_diversity) * (home_page_ctr_no_diversity,
	// pdp_cvr_no_diversity) * `Invalid combinations`: []
	//   "UNIQUE_SERVING_CONFIG_RESTRICTION" - Do not allow the same
	// ServingConfig.name to be shown on multiple panels. Example: `Panel1
	// candidates`: * pdp_ctr, pdp_cvr, home_page_ctr_no_diversity * `Panel2
	// candidates`: * home_page_ctr_no_diversity, home_page_ctr_diversity_low,
	// pdp_cvr_no_diversity * `Restriction` = `UNIQUE_SERVING_CONFIG_RESTRICTION`
	// `Valid combinations`: * * (pdp_ctr, home_page_ctr_no_diversity) * (pdp_ctr,
	// home_page_ctr_diversity_low) * (pdp_ctr, pdp_cvr_no_diversity) * (pdp_ctr,
	// pdp_cvr_no_diversity) * (pdp_cvr, home_page_ctr_no_diversity) * (pdp_cvr,
	// home_page_ctr_diversity_low) * (pdp_cvr, pdp_cvr_no_diversity) *
	// (home_page_ctr_no_diversity, home_page_ctr_diversity_low) *
	// (home_page_ctr_no_diversity, pdp_cvr_no_diversity) * `Invalid combinations`:
	// * * (home_page_ctr_no_diversity, home_page_ctr_no_diversity) *
	//   "UNIQUE_MODEL_RESTRICTION" - Do not allow multiple ServingConfigs with
	// same Model.name to be show on on different panels. Example: `Panel1
	// candidates`: * pdp_ctr, pdp_cvr, home_page_ctr_no_diversity * `Panel2
	// candidates`: * home_page_ctr_no_diversity, home_page_ctr_diversity_low,
	// pdp_cvr_no_diversity * `Restriction` = `UNIQUE_MODEL_RESTRICTION` `Valid
	// combinations`: * * (pdp_ctr, home_page_ctr_no_diversity) * (pdp_ctr,
	// home_page_ctr_diversity) * (pdp_ctr, pdp_cvr_no_diversity) * (pdp_ctr,
	// pdp_cvr_no_diversity) * (pdp_cvr, home_page_ctr_no_diversity) * (pdp_cvr,
	// home_page_ctr_diversity_low) * (home_page_ctr_no_diversity,
	// pdp_cvr_no_diversity) * `Invalid combinations`: * *
	// (home_page_ctr_no_diversity, home_page_ctr_no_diversity) * (pdp_cvr,
	// pdp_cvr_no_diversity) *
	//   "UNIQUE_MODEL_TYPE_RESTRICTION" - Do not allow multiple ServingConfigs
	// with same Model.type to be shown on different panels. Example: `Panel1
	// candidates`: * pdp_ctr, pdp_cvr, home_page_ctr_no_diversity * `Panel2
	// candidates`: * home_page_ctr_no_diversity, home_page_ctr_diversity_low,
	// pdp_cvr_no_diversity * `Restriction` = `UNIQUE_MODEL_RESTRICTION` `Valid
	// combinations`: * * (pdp_ctr, home_page_ctr_no_diversity) * (pdp_ctr,
	// home_page_ctr_diversity) * (pdp_cvr, home_page_ctr_no_diversity) * (pdp_cvr,
	// home_page_ctr_diversity_low) * (home_page_ctr_no_diversity,
	// pdp_cvr_no_diversity) * `Invalid combinations`: * * (pdp_ctr,
	// pdp_cvr_no_diversity) * (pdp_ctr, pdp_cvr_no_diversity) * (pdp_cvr,
	// pdp_cvr_no_diversity) * (home_page_ctr_no_diversity,
	// home_page_ctr_no_diversity) * (home_page_ctr_no_diversity,
	// home_page_ctr_diversity) *
	Restriction string `json:"restriction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageOptimizationEventType")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageOptimizationEventType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaModelPageOptimizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaModelPageOptimizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate: A candidate to
// consider for a given panel. Currently only ServingConfig are valid
// candidates.
type GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate struct {
	// ServingConfigId: This has to be a valid ServingConfig identifier. For
	// example, for a ServingConfig with full name:
	// `projects/*/locations/global/catalogs/default_catalog/servingConfigs/my_candi
	// date_config`, this would be `my_candidate_config`.
	ServingConfigId string `json:"servingConfigId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServingConfigId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServingConfigId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel: An individual
// panel with a list of ServingConfigs to consider for it.
type GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel struct {
	// Candidates: Required. The candidates to consider on the panel.
	Candidates []*GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate `json:"candidates,omitempty"`
	// DefaultCandidate: Required. The default candidate. If the model fails at
	// serving time, we fall back to the default.
	DefaultCandidate *GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate `json:"defaultCandidate,omitempty"`
	// DisplayName: Optional. The name to display for the panel.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaModelServingConfigList: Represents an ordered
// combination of valid serving configs, which can be used for
// `PAGE_OPTIMIZATION` recommendations.
type GoogleCloudRetailV2alphaModelServingConfigList struct {
	// ServingConfigIds: Optional. A set of valid serving configs that may be used
	// for `PAGE_OPTIMIZATION`.
	ServingConfigIds []string `json:"servingConfigIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServingConfigIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServingConfigIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaModelServingConfigList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaModelServingConfigList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaOutputConfig: The output configuration setting.
type GoogleCloudRetailV2alphaOutputConfig struct {
	// BigqueryDestination: The BigQuery location where the output is to be written
	// to.
	BigqueryDestination *GoogleCloudRetailV2alphaOutputConfigBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: The Google Cloud Storage location where the output is to be
	// written to.
	GcsDestination *GoogleCloudRetailV2alphaOutputConfigGcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaOutputConfigBigQueryDestination: The BigQuery output
// destination configuration.
type GoogleCloudRetailV2alphaOutputConfigBigQueryDestination struct {
	// DatasetId: Required. The ID of a BigQuery Dataset.
	DatasetId string `json:"datasetId,omitempty"`
	// TableIdPrefix: Required. The prefix of exported BigQuery tables.
	TableIdPrefix string `json:"tableIdPrefix,omitempty"`
	// TableType: Required. Describes the table type. The following values are
	// supported: * `table`: A BigQuery native table. * `view`: A virtual table
	// defined by a SQL query.
	TableType string `json:"tableType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaOutputConfigBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaOutputConfigBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaOutputConfigGcsDestination: The Google Cloud Storage
// output destination configuration.
type GoogleCloudRetailV2alphaOutputConfigGcsDestination struct {
	// OutputUriPrefix: Required. The output uri prefix for saving output data to
	// json files. Some mapping examples are as follows: output_uri_prefix sample
	// output(assuming the object is foo.json) ========================
	// ============================================= gs://bucket/
	// gs://bucket/foo.json gs://bucket/folder/ gs://bucket/folder/foo.json
	// gs://bucket/folder/item_ gs://bucket/folder/item_foo.json
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUriPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaOutputConfigGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaOutputConfigGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaOutputResult: Output result that stores the
// information about where the exported data is stored.
type GoogleCloudRetailV2alphaOutputResult struct {
	// BigqueryResult: The BigQuery location where the result is stored.
	BigqueryResult []*GoogleCloudRetailV2alphaBigQueryOutputResult `json:"bigqueryResult,omitempty"`
	// GcsResult: The Google Cloud Storage location where the result is stored.
	GcsResult []*GoogleCloudRetailV2alphaGcsOutputResult `json:"gcsResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPauseModelRequest: Request for pausing training of a
// model.
type GoogleCloudRetailV2alphaPauseModelRequest struct {
}

// GoogleCloudRetailV2alphaPredictRequest: Request message for Predict method.
type GoogleCloudRetailV2alphaPredictRequest struct {
	// Filter: Filter for restricting prediction results with a length limit of
	// 5,000 characters. Accepts values for tags and the `filterOutOfStockItems`
	// flag. * Tag expressions. Restricts predictions to products that match all of
	// the specified tags. Boolean operators `OR` and `NOT` are supported if the
	// expression is enclosed in parentheses, and must be separated from the tag
	// values by a space. `-"tagA" is also supported and is equivalent to `NOT
	// "tagA". Tag values must be double quoted UTF-8 encoded strings with a size
	// limit of 1,000 characters. Note: "Recently viewed" models don't support tag
	// filtering at the moment. * filterOutOfStockItems. Restricts predictions to
	// products that do not have a stockState value of OUT_OF_STOCK. Examples: *
	// tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional") *
	// filterOutOfStockItems tag=(-"promotional") * filterOutOfStockItems If your
	// filter blocks all prediction results, the API will return *no* results. If
	// instead you want empty result sets to return generic (unfiltered) popular
	// products, set `strictFiltering` to False in `PredictRequest.params`. Note
	// that the API will never return items with storageStatus of "EXPIRED" or
	// "DELETED" regardless of filter choices. If `filterSyntaxV2` is set to true
	// under the `params` field, then attribute-based expressions are expected
	// instead of the above described tag-based syntax. Examples: * (colors:
	// ANY("Red", "Blue")) AND NOT (categories: ANY("Phones")) * (availability:
	// ANY("IN_STOCK")) AND (colors: ANY("Red") OR categories: ANY("Phones")) For
	// more information, see Filter recommendations
	// (https://cloud.google.com/retail/docs/filter-recs).
	Filter string `json:"filter,omitempty"`
	// Labels: The labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	Labels map[string]string `json:"labels,omitempty"`
	// PageSize: Maximum number of results to return. Set this property to the
	// number of prediction results needed. If zero, the service will choose a
	// reasonable default. The maximum allowed value is 100. Values above 100 will
	// be coerced to 100.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: This field is not used; leave it unset.
	PageToken string `json:"pageToken,omitempty"`
	// Params: Additional domain specific parameters for the predictions. Allowed
	// values: * `returnProduct`: Boolean. If set to true, the associated product
	// object will be returned in the `results.metadata` field in the prediction
	// response. * `returnScore`: Boolean. If set to true, the prediction 'score'
	// corresponding to each returned product will be set in the `results.metadata`
	// field in the prediction response. The given 'score' indicates the
	// probability of a product being clicked/purchased given the user's context
	// and history. * `strictFiltering`: Boolean. True by default. If set to false,
	// the service will return generic (unfiltered) popular products instead of
	// empty if your filter blocks all prediction results. * `priceRerankLevel`:
	// String. Default empty. If set to be non-empty, then it needs to be one of
	// {'no-price-reranking', 'low-price-reranking', 'medium-price-reranking',
	// 'high-price-reranking'}. This gives request-level control and adjusts
	// prediction results based on product price. * `diversityLevel`: String.
	// Default empty. If set to be non-empty, then it needs to be one of
	// {'no-diversity', 'low-diversity', 'medium-diversity', 'high-diversity',
	// 'auto-diversity'}. This gives request-level control and adjusts prediction
	// results based on product category. * `filterSyntaxV2`: Boolean. False by
	// default. If set to true, the `filter` field is interpreteted according to
	// the new, attribute-based syntax.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// UserEvent: Required. Context about the user, what they are looking at and
	// what action they took to trigger the predict request. Note that this user
	// event detail won't be ingested to userEvent logs. Thus, a separate userEvent
	// write request is required for event logging. Don't set UserEvent.visitor_id
	// or UserInfo.user_id to the same fixed ID for different users. If you are
	// trying to receive non-personalized recommendations (not recommended; this
	// can negatively impact model performance), instead set UserEvent.visitor_id
	// to a random unique ID and leave UserInfo.user_id unset.
	UserEvent *GoogleCloudRetailV2alphaUserEvent `json:"userEvent,omitempty"`
	// ValidateOnly: Use validate only mode for this prediction query. If set to
	// true, a dummy model will be used that returns arbitrary products. Note that
	// the validate only mode should only be used for testing the API, or if the
	// model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPredictRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPredictResponse: Response message for predict
// method.
type GoogleCloudRetailV2alphaPredictResponse struct {
	// AttributionToken: A unique attribution token. This should be included in the
	// UserEvent logs resulting from this recommendation, which enables accurate
	// attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`
	// MissingIds: IDs of products in the request that were missing from the
	// inventory.
	MissingIds []string `json:"missingIds,omitempty"`
	// Results: A list of recommended products. The order represents the ranking
	// (from the most relevant product to the least).
	Results []*GoogleCloudRetailV2alphaPredictResponsePredictionResult `json:"results,omitempty"`
	// ValidateOnly: True if the validateOnly property was set in the request.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPredictResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPredictResponsePredictionResult: PredictionResult
// represents the recommendation prediction results.
type GoogleCloudRetailV2alphaPredictResponsePredictionResult struct {
	// Id: ID of the recommended product
	Id string `json:"id,omitempty"`
	// Metadata: Additional product metadata / annotations. Possible values: *
	// `product`: JSON representation of the product. Is set if `returnProduct` is
	// set to true in `PredictRequest.params`. * `score`: Prediction score in
	// double value. Is set if `returnScore` is set to true in
	// `PredictRequest.params`.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPredictResponsePredictionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPredictResponsePredictionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPriceInfo: The price information of a Product.
type GoogleCloudRetailV2alphaPriceInfo struct {
	// Cost: The costs associated with the sale of a particular product. Used for
	// gross profit reporting. * Profit = price - cost Google Merchant Center
	// property cost_of_goods_sold
	// (https://support.google.com/merchants/answer/9017895).
	Cost float64 `json:"cost,omitempty"`
	// CurrencyCode: The 3-letter currency code defined in ISO 4217
	// (https://www.iso.org/iso-4217-currency-codes.html). If this field is an
	// unrecognizable currency code, an INVALID_ARGUMENT error is returned. The
	// Product.Type.VARIANT Products with the same Product.primary_product_id must
	// share the same currency_code. Otherwise, a FAILED_PRECONDITION error is
	// returned.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// OriginalPrice: Price of the product without any discount. If zero, by
	// default set to be the price. If set, original_price should be greater than
	// or equal to price, otherwise an INVALID_ARGUMENT error is thrown.
	OriginalPrice float64 `json:"originalPrice,omitempty"`
	// Price: Price of the product. Google Merchant Center property price
	// (https://support.google.com/merchants/answer/6324371). Schema.org property
	// Offer.price (https://schema.org/price).
	Price float64 `json:"price,omitempty"`
	// PriceEffectiveTime: The timestamp when the price starts to be effective.
	// This can be set as a future timestamp, and the price is only used for search
	// after price_effective_time. If so, the original_price must be set and
	// original_price is used before price_effective_time. Do not set if price is
	// always effective because it will cause additional latency during search.
	PriceEffectiveTime string `json:"priceEffectiveTime,omitempty"`
	// PriceExpireTime: The timestamp when the price stops to be effective. The
	// price is used for search before price_expire_time. If this field is set, the
	// original_price must be set and original_price is used after
	// price_expire_time. Do not set if price is always effective because it will
	// cause additional latency during search.
	PriceExpireTime string `json:"priceExpireTime,omitempty"`
	// PriceRange: Output only. The price range of all the child
	// Product.Type.VARIANT Products grouped together on the Product.Type.PRIMARY
	// Product. Only populated for Product.Type.PRIMARY Products. Note: This field
	// is OUTPUT_ONLY for ProductService.GetProduct. Do not set this field in API
	// requests.
	PriceRange *GoogleCloudRetailV2alphaPriceInfoPriceRange `json:"priceRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cost") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPriceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPriceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaPriceInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaPriceInfo
	var s1 struct {
		Cost          gensupport.JSONFloat64 `json:"cost"`
		OriginalPrice gensupport.JSONFloat64 `json:"originalPrice"`
		Price         gensupport.JSONFloat64 `json:"price"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.OriginalPrice = float64(s1.OriginalPrice)
	s.Price = float64(s1.Price)
	return nil
}

// GoogleCloudRetailV2alphaPriceInfoPriceRange: The price range of all variant
// Product having the same Product.primary_product_id.
type GoogleCloudRetailV2alphaPriceInfoPriceRange struct {
	// OriginalPrice: The inclusive Product.pricing_info.original_price internal of
	// all variant Product having the same Product.primary_product_id.
	OriginalPrice *GoogleCloudRetailV2alphaInterval `json:"originalPrice,omitempty"`
	// Price: The inclusive Product.pricing_info.price interval of all variant
	// Product having the same Product.primary_product_id.
	Price *GoogleCloudRetailV2alphaInterval `json:"price,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalPrice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPriceInfoPriceRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPriceInfoPriceRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProduct: Product captures all metadata information
// of items to be recommended or searched.
type GoogleCloudRetailV2alphaProduct struct {
	// Attributes: Highly encouraged. Extra product attributes to be included. For
	// example, for products, this could include the store name, vendor, style,
	// color, etc. These are very strong signals for recommendation model, thus we
	// highly recommend providing the attributes here. Features that can take on
	// one of a limited number of possible values. Two types of features can be set
	// are: Textual features. some examples would be the brand/maker of a product,
	// or country of a customer. Numerical features. Some examples would be the
	// height/weight of a product, or age of a customer. For example: `{ "vendor":
	// {"text": ["vendor123", "vendor456"]}, "lengths_cm": {"numbers":[2.3, 15.4]},
	// "heights_cm": {"numbers":[8.1, 6.4]} }`. This field needs to pass all below
	// criteria, otherwise an INVALID_ARGUMENT error is returned: * Max entries
	// count: 200. * The key must be a UTF-8 encoded string with a length limit of
	// 128 characters. * For indexable attribute, the key must match the pattern:
	// `a-zA-Z0-9*`. For example, `key0LikeThis` or `KEY_1_LIKE_THIS`. * For text
	// attributes, at most 400 values are allowed. Empty values are not allowed.
	// Each value must be a non-empty UTF-8 encoded string with a length limit of
	// 256 characters. * For number attributes, at most 400 values are allowed.
	Attributes map[string]GoogleCloudRetailV2alphaCustomAttribute `json:"attributes,omitempty"`
	// Audience: The target group associated with a given audience (e.g. male,
	// veterans, car owners, musicians, etc.) of the product.
	Audience *GoogleCloudRetailV2alphaAudience `json:"audience,omitempty"`
	// Availability: The online availability of the Product. Default to
	// Availability.IN_STOCK. For primary products with variants set the
	// availability of the primary as Availability.OUT_OF_STOCK and set the true
	// availability at the variant level. This way the primary product will be
	// considered "in stock" as long as it has at least one variant in stock. For
	// primary products with no variants set the true availability at the primary
	// level. Corresponding properties: Google Merchant Center property
	// availability (https://support.google.com/merchants/answer/6324448).
	// Schema.org property Offer.availability (https://schema.org/availability).
	//
	// Possible values:
	//   "AVAILABILITY_UNSPECIFIED" - Default product availability. Default to
	// Availability.IN_STOCK if unset.
	//   "IN_STOCK" - Product in stock.
	//   "OUT_OF_STOCK" - Product out of stock.
	//   "PREORDER" - Product that is in pre-order state.
	//   "BACKORDER" - Product that is back-ordered (i.e. temporarily out of
	// stock).
	Availability string `json:"availability,omitempty"`
	// AvailableQuantity: The available quantity of the item.
	AvailableQuantity int64 `json:"availableQuantity,omitempty"`
	// AvailableTime: The timestamp when this Product becomes available for
	// SearchService.Search. Note that this is only applicable to Type.PRIMARY and
	// Type.COLLECTION, and ignored for Type.VARIANT.
	AvailableTime string `json:"availableTime,omitempty"`
	// Brands: The brands of the product. A maximum of 30 brands are allowed unless
	// overridden through the Google Cloud console. Each brand must be a UTF-8
	// encoded string with a length limit of 1,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Corresponding properties: Google
	// Merchant Center property brand
	// (https://support.google.com/merchants/answer/6324351). Schema.org property
	// Product.brand (https://schema.org/brand).
	Brands []string `json:"brands,omitempty"`
	// Categories: Product categories. This field is repeated for supporting one
	// product belonging to several parallel categories. Strongly recommended using
	// the full path for better search / recommendation quality. To represent full
	// path of category, use '>' sign to separate different hierarchies. If '>' is
	// part of the category name, replace it with other character(s). For example,
	// if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and
	// ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be
	// represented as: "categories": [ "Shoes & Accessories > Shoes", "Sports &
	// Fitness > Athletic Clothing > Shoes" ] Must be set for Type.PRIMARY Product
	// otherwise an INVALID_ARGUMENT error is returned. At most 250 values are
	// allowed per Product unless overridden through the Google Cloud console.
	// Empty values are not allowed. Each value must be a UTF-8 encoded string with
	// a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is
	// returned. Corresponding properties: Google Merchant Center property
	// google_product_category. Schema.org property [Product.category]
	// (https://schema.org/category). [mc_google_product_category]:
	// https://support.google.com/merchants/answer/6324436
	Categories []string `json:"categories,omitempty"`
	// CollectionMemberIds: The id of the collection members when type is
	// Type.COLLECTION. Non-existent product ids are allowed. The type of the
	// members must be either Type.PRIMARY or Type.VARIANT otherwise an
	// INVALID_ARGUMENT error is thrown. Should not set it for other types. A
	// maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
	// return.
	CollectionMemberIds []string `json:"collectionMemberIds,omitempty"`
	// ColorInfo: The color of the product. Corresponding properties: Google
	// Merchant Center property color
	// (https://support.google.com/merchants/answer/6324487). Schema.org property
	// Product.color (https://schema.org/color).
	ColorInfo *GoogleCloudRetailV2alphaColorInfo `json:"colorInfo,omitempty"`
	// Conditions: The condition of the product. Strongly encouraged to use the
	// standard values: "new", "refurbished", "used". A maximum of 1 value is
	// allowed per Product. Each value must be a UTF-8 encoded string with a length
	// limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	// Corresponding properties: Google Merchant Center property condition
	// (https://support.google.com/merchants/answer/6324469). Schema.org property
	// Offer.itemCondition (https://schema.org/itemCondition).
	Conditions []string `json:"conditions,omitempty"`
	// Description: Product description. This field must be a UTF-8 encoded string
	// with a length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. Corresponding properties: Google Merchant Center property
	// description (https://support.google.com/merchants/answer/6324468).
	// Schema.org property Product.description (https://schema.org/description).
	Description string `json:"description,omitempty"`
	// ExpireTime: Note that this field is applied in the following ways: * If the
	// Product is already expired when it is uploaded, this product is not indexed
	// for search. * If the Product is not expired when it is uploaded, only the
	// Type.PRIMARY's and Type.COLLECTION's expireTime is respected, and
	// Type.VARIANT's expireTime is not used. In general, we suggest the users to
	// delete the stale products explicitly, instead of using this field to
	// determine staleness. expire_time must be later than available_time and
	// publish_time, otherwise an INVALID_ARGUMENT error is thrown. Corresponding
	// properties: Google Merchant Center property expiration_date
	// (https://support.google.com/merchants/answer/6324499).
	ExpireTime string `json:"expireTime,omitempty"`
	// FulfillmentInfo: Fulfillment information, such as the store IDs for in-store
	// pickup or region IDs for different shipping methods. All the elements must
	// have distinct FulfillmentInfo.type. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	FulfillmentInfo []*GoogleCloudRetailV2alphaFulfillmentInfo `json:"fulfillmentInfo,omitempty"`
	// Gtin: The Global Trade Item Number (GTIN) of the product. This field must be
	// a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. This field must be a Unigram. Otherwise,
	// an INVALID_ARGUMENT error is returned. Corresponding properties: Google
	// Merchant Center property gtin
	// (https://support.google.com/merchants/answer/6324461). Schema.org property
	// Product.isbn (https://schema.org/isbn), Product.gtin8
	// (https://schema.org/gtin8), Product.gtin12 (https://schema.org/gtin12),
	// Product.gtin13 (https://schema.org/gtin13), or Product.gtin14
	// (https://schema.org/gtin14). If the value is not a valid GTIN, an
	// INVALID_ARGUMENT error is returned.
	Gtin string `json:"gtin,omitempty"`
	// Id: Immutable. Product identifier, which is the final component of name. For
	// example, this field is "id_1", if name is
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch
	// /products/id_1`. This field must be a UTF-8 encoded string with a length
	// limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	// Corresponding properties: Google Merchant Center property id
	// (https://support.google.com/merchants/answer/6324405). Schema.org property
	// Product.sku (https://schema.org/sku).
	Id string `json:"id,omitempty"`
	// Images: Product images for the product. We highly recommend putting the main
	// image first. A maximum of 300 images are allowed. Corresponding properties:
	// Google Merchant Center property image_link
	// (https://support.google.com/merchants/answer/6324350). Schema.org property
	// Product.image (https://schema.org/image).
	Images []*GoogleCloudRetailV2alphaImage `json:"images,omitempty"`
	// LanguageCode: Language of the title/description and other string attributes.
	// Use language tags defined by BCP 47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). For product prediction, this
	// field is ignored and the model automatically detects the text language. The
	// Product can include text in different languages, but duplicating Products to
	// provide text in multiple languages can result in degraded model performance.
	// For product search this field is in use. It defaults to "en-US" if unset.
	LanguageCode string `json:"languageCode,omitempty"`
	// LocalInventories: Output only. A list of local inventories specific to
	// different places. This field can be managed by
	// ProductService.AddLocalInventories and ProductService.RemoveLocalInventories
	// APIs if fine-grained, high-volume updates are necessary.
	LocalInventories []*GoogleCloudRetailV2alphaLocalInventory `json:"localInventories,omitempty"`
	// Materials: The material of the product. For example, "leather", "wooden". A
	// maximum of 20 values are allowed. Each value must be a UTF-8 encoded string
	// with a length limit of 200 characters. Otherwise, an INVALID_ARGUMENT error
	// is returned. Corresponding properties: Google Merchant Center property
	// material (https://support.google.com/merchants/answer/6324410). Schema.org
	// property Product.material (https://schema.org/material).
	Materials []string `json:"materials,omitempty"`
	// Name: Immutable. Full resource name of the product, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch
	// /products/product_id`.
	Name string `json:"name,omitempty"`
	// Patterns: The pattern or graphic print of the product. For example,
	// "striped", "polka dot", "paisley". A maximum of 20 values are allowed per
	// Product. Each value must be a UTF-8 encoded string with a length limit of
	// 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	// Corresponding properties: Google Merchant Center property pattern
	// (https://support.google.com/merchants/answer/6324483). Schema.org property
	// Product.pattern (https://schema.org/pattern).
	Patterns []string `json:"patterns,omitempty"`
	// PriceInfo: Product price and cost information. Corresponding properties:
	// Google Merchant Center property price
	// (https://support.google.com/merchants/answer/6324371).
	PriceInfo *GoogleCloudRetailV2alphaPriceInfo `json:"priceInfo,omitempty"`
	// PrimaryProductId: Variant group identifier. Must be an id, with the same
	// parent branch with this product. Otherwise, an error is thrown. For
	// Type.PRIMARY Products, this field can only be empty or set to the same value
	// as id. For VARIANT Products, this field cannot be empty. A maximum of 2,000
	// products are allowed to share the same Type.PRIMARY Product. Otherwise, an
	// INVALID_ARGUMENT error is returned. Corresponding properties: Google
	// Merchant Center property item_group_id
	// (https://support.google.com/merchants/answer/6324507). Schema.org property
	// Product.inProductGroupWithID (https://schema.org/inProductGroupWithID).
	PrimaryProductId string `json:"primaryProductId,omitempty"`
	// Promotions: The promotions applied to the product. A maximum of 10 values
	// are allowed per Product. Only Promotion.promotion_id will be used, other
	// fields will be ignored if set.
	Promotions []*GoogleCloudRetailV2alphaPromotion `json:"promotions,omitempty"`
	// PublishTime: The timestamp when the product is published by the retailer for
	// the first time, which indicates the freshness of the products. Note that
	// this field is different from available_time, given it purely describes
	// product freshness regardless of when it is available on search and
	// recommendation.
	PublishTime string `json:"publishTime,omitempty"`
	// Rating: The rating of this product.
	Rating *GoogleCloudRetailV2alphaRating `json:"rating,omitempty"`
	// RetrievableFields: Indicates which fields in the Products are returned in
	// SearchResponse. Supported fields for all types: * audience * availability *
	// brands * color_info * conditions * gtin * materials * name * patterns *
	// price_info * rating * sizes * title * uri Supported fields only for
	// Type.PRIMARY and Type.COLLECTION: * categories * description * images
	// Supported fields only for Type.VARIANT: * Only the first image in images To
	// mark attributes as retrievable, include paths of the form "attributes.key"
	// where "key" is the key of a custom attribute, as specified in attributes.
	// For Type.PRIMARY and Type.COLLECTION, the following fields are always
	// returned in SearchResponse by default: * name For Type.VARIANT, the
	// following fields are always returned in by default: * name * color_info The
	// maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
	// returned. Note: Returning more fields in SearchResponse can increase
	// response payload size and serving latency. This field is deprecated. Use the
	// retrievable site-wide control instead.
	RetrievableFields string `json:"retrievableFields,omitempty"`
	// Sizes: The size of the product. To represent different size systems or size
	// types, consider using this format: [[[size_system:]size_type:]size_value].
	// For example, in "US:MENS:M", "US" represents size system; "MENS" represents
	// size type; "M" represents size value. In "GIRLS:27", size system is empty;
	// "GIRLS" represents size type; "27" represents size value. In "32 inches",
	// both size system and size type are empty, while size value is "32 inches". A
	// maximum of 20 values are allowed per Product. Each value must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Corresponding properties: Google
	// Merchant Center property size
	// (https://support.google.com/merchants/answer/6324492), size_type
	// (https://support.google.com/merchants/answer/6324497), and size_system
	// (https://support.google.com/merchants/answer/6324502). Schema.org property
	// Product.size (https://schema.org/size).
	Sizes []string `json:"sizes,omitempty"`
	// Tags: Custom tags associated with the product. At most 250 values are
	// allowed per Product. This value must be a UTF-8 encoded string with a length
	// limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	// This tag can be used for filtering recommendation results by passing the tag
	// as part of the PredictRequest.filter. Corresponding properties: Google
	// Merchant Center property custom_label_0–4
	// (https://support.google.com/merchants/answer/6324473).
	Tags []string `json:"tags,omitempty"`
	// Title: Required. Product title. This field must be a UTF-8 encoded string
	// with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. Corresponding properties: Google Merchant Center property
	// title (https://support.google.com/merchants/answer/6324415). Schema.org
	// property Product.name (https://schema.org/name).
	Title string `json:"title,omitempty"`
	// Ttl: Input only. The TTL (time to live) of the product. Note that this is
	// only applicable to Type.PRIMARY and Type.COLLECTION, and ignored for
	// Type.VARIANT. In general, we suggest the users to delete the stale products
	// explicitly, instead of using this field to determine staleness. If it is
	// set, it must be a non-negative value, and expire_time is set as current
	// timestamp plus ttl. The derived expire_time is returned in the output and
	// ttl is left blank when retrieving the Product. If it is set, the product is
	// not available for SearchService.Search after current timestamp plus ttl.
	// However, the product can still be retrieved by ProductService.GetProduct and
	// ProductService.ListProducts.
	Ttl string `json:"ttl,omitempty"`
	// Type: Immutable. The type of the product. Default to
	// Catalog.product_level_config.ingestion_product_type if unset.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. Default to
	// Catalog.product_level_config.ingestion_product_type if unset.
	//   "PRIMARY" - The primary type. As the primary unit for predicting, indexing
	// and search serving, a Type.PRIMARY Product is grouped with multiple
	// Type.VARIANT Products.
	//   "VARIANT" - The variant type. Type.VARIANT Products usually share some
	// common attributes on the same Type.PRIMARY Products, but they have variant
	// attributes like different colors, sizes and prices, etc.
	//   "COLLECTION" - The collection type. Collection products are bundled
	// Type.PRIMARY Products or Type.VARIANT Products that are sold together, such
	// as a jewelry set with necklaces, earrings and rings, etc.
	Type string `json:"type,omitempty"`
	// Uri: Canonical URL directly linking to the product detail page. It is
	// strongly recommended to provide a valid uri for the product, otherwise the
	// service performance could be significantly degraded. This field must be a
	// UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Corresponding properties: Google
	// Merchant Center property link
	// (https://support.google.com/merchants/answer/6324416). Schema.org property
	// Offer.url (https://schema.org/url).
	Uri string `json:"uri,omitempty"`
	// Variants: Output only. Product variants grouped together on primary product
	// which share similar product attributes. It's automatically grouped by
	// primary_product_id for all the product variants. Only populated for
	// Type.PRIMARY Products. Note: This field is OUTPUT_ONLY for
	// ProductService.GetProduct. Do not set this field in API requests.
	Variants []*GoogleCloudRetailV2alphaProduct `json:"variants,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaProduct) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProduct
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductDetail: Detailed product information
// associated with a user event.
type GoogleCloudRetailV2alphaProductDetail struct {
	// Product: Required. Product information. Required field(s): * Product.id
	// Optional override field(s): * Product.price_info If any supported optional
	// fields are provided, we will treat them as a full override when looking up
	// product information from the catalog. Thus, it is important to ensure that
	// the overriding fields are accurate and complete. All other product fields
	// are ignored and instead populated via catalog lookup after event ingestion.
	Product *GoogleCloudRetailV2alphaProduct `json:"product,omitempty"`
	// Quantity: Quantity of the product associated with the user event. For
	// example, this field will be 2 if two products are added to the shopping cart
	// for `purchase-complete` event. Required for `add-to-cart` and
	// `purchase-complete` event types.
	Quantity int64 `json:"quantity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Product") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Product") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaProductDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductInlineSource: The inline source for the input
// config for ImportProducts method.
type GoogleCloudRetailV2alphaProductInlineSource struct {
	// Products: Required. A list of products to update/create. Each product must
	// have a valid Product.id. Recommended max of 100 items.
	Products []*GoogleCloudRetailV2alphaProduct `json:"products,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Products") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Products") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaProductInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductInputConfig: The input config source for
// products.
type GoogleCloudRetailV2alphaProductInputConfig struct {
	// BigQuerySource: BigQuery input source.
	BigQuerySource *GoogleCloudRetailV2alphaBigQuerySource `json:"bigQuerySource,omitempty"`
	// GcsSource: Google Cloud Storage location for the input content.
	GcsSource *GoogleCloudRetailV2alphaGcsSource `json:"gcsSource,omitempty"`
	// ProductInlineSource: The Inline source for the input content for products.
	ProductInlineSource *GoogleCloudRetailV2alphaProductInlineSource `json:"productInlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaProductInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProductLevelConfig: Configures what level the
// product should be uploaded with regards to how users will be send events and
// how predictions will be made.
type GoogleCloudRetailV2alphaProductLevelConfig struct {
	// IngestionProductType: The type of Products allowed to be ingested into the
	// catalog. Acceptable values are: * `primary` (default): You can ingest
	// Products of all types. When ingesting a Product, its type will default to
	// Product.Type.PRIMARY if unset. * `variant` (incompatible with Retail
	// Search): You can only ingest Product.Type.VARIANT Products. This means
	// Product.primary_product_id cannot be empty. If this field is set to an
	// invalid value other than these, an INVALID_ARGUMENT error is returned. If
	// this field is `variant` and merchant_center_product_id_field is
	// `itemGroupId`, an INVALID_ARGUMENT error is returned. See Product levels
	// (https://cloud.google.com/retail/docs/catalog#product-levels) for more
	// details.
	IngestionProductType string `json:"ingestionProductType,omitempty"`
	// MerchantCenterProductIdField: Which field of Merchant Center Product
	// (/bigquery-transfer/docs/merchant-center-products-schema) should be imported
	// as Product.id. Acceptable values are: * `offerId` (default): Import
	// `offerId` as the product ID. * `itemGroupId`: Import `itemGroupId` as the
	// product ID. Notice that Retail API will choose one item from the ones with
	// the same `itemGroupId`, and use it to represent the item group. If this
	// field is set to an invalid value other than these, an INVALID_ARGUMENT error
	// is returned. If this field is `itemGroupId` and ingestion_product_type is
	// `variant`, an INVALID_ARGUMENT error is returned. See Product levels
	// (https://cloud.google.com/retail/docs/catalog#product-levels) for more
	// details.
	MerchantCenterProductIdField string `json:"merchantCenterProductIdField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IngestionProductType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestionProductType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaProductLevelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProductLevelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaProject: Metadata that describes a Cloud Retail
// Project.
type GoogleCloudRetailV2alphaProject struct {
	// EnrolledSolutions: Output only. Retail API solutions that the project has
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Retail Search.
	EnrolledSolutions []string `json:"enrolledSolutions,omitempty"`
	// Name: Output only. Full resource name of the retail project, such as
	// `projects/{project_id_or_number}/retailProject`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EnrolledSolutions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnrolledSolutions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaProject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaProject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPromotion: Promotion specification.
type GoogleCloudRetailV2alphaPromotion struct {
	// PromotionId: Promotion identifier, which is the final component of name. For
	// example, this field is "free_gift", if name is
	// `projects/*/locations/global/catalogs/default_catalog/promotions/free_gift`.
	// The value must be a UTF-8 encoded string with a length limit of 128
	// characters, and match the pattern: `a-zA-Z*`. For example, id0LikeThis or
	// ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error is returned.
	// Corresponds to Google Merchant Center property promotion_id
	// (https://support.google.com/merchants/answer/7050148).
	PromotionId string `json:"promotionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PromotionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromotionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPromotion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPromotion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurchaseTransaction: A transaction represents the
// entire purchase transaction.
type GoogleCloudRetailV2alphaPurchaseTransaction struct {
	// Cost: All the costs associated with the products. These can be manufacturing
	// costs, shipping expenses not borne by the end user, or any other costs, such
	// that: * Profit = revenue - tax - cost
	Cost float64 `json:"cost,omitempty"`
	// CurrencyCode: Required. Currency code. Use three-character ISO-4217 code.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Id: The transaction ID with a length limit of 128 characters.
	Id string `json:"id,omitempty"`
	// Revenue: Required. Total non-zero revenue or grand total associated with the
	// transaction. This value include shipping, tax, or other adjustments to total
	// revenue that you want to include as part of your revenue calculations.
	Revenue float64 `json:"revenue,omitempty"`
	// Tax: All the taxes associated with the transaction.
	Tax float64 `json:"tax,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cost") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPurchaseTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurchaseTransaction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaPurchaseTransaction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaPurchaseTransaction
	var s1 struct {
		Cost    gensupport.JSONFloat64 `json:"cost"`
		Revenue gensupport.JSONFloat64 `json:"revenue"`
		Tax     gensupport.JSONFloat64 `json:"tax"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.Revenue = float64(s1.Revenue)
	s.Tax = float64(s1.Tax)
	return nil
}

// GoogleCloudRetailV2alphaPurgeMetadata: Metadata related to the progress of
// the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaPurgeMetadata struct {
}

// GoogleCloudRetailV2alphaPurgeProductsMetadata: Metadata related to the
// progress of the PurgeProducts operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaPurgeProductsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPurgeProductsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeProductsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurgeProductsRequest: Request message for
// PurgeProducts method.
type GoogleCloudRetailV2alphaPurgeProductsRequest struct {
	// Filter: Required. The filter string to specify the products to be deleted
	// with a length limit of 5,000 characters. Empty string filter is not allowed.
	// "*" implies delete all items in a branch. The eligible fields for filtering
	// are: * `availability`: Double quoted Product.availability string. *
	// `create_time` : in ISO 8601 "zulu" format. Supported syntax: * Comparators
	// (">", "<", ">=", "<=", "="). Examples: * create_time <=
	// "2015-02-13T17:05:46Z" * availability = "IN_STOCK" * Conjunctions ("AND")
	// Examples: * create_time <= "2015-02-13T17:05:46Z" AND availability =
	// "PREORDER" * Disjunctions ("OR") Examples: * create_time <=
	// "2015-02-13T17:05:46Z" OR availability = "IN_STOCK" * Can support nested
	// queries. Examples: * (create_time <= "2015-02-13T17:05:46Z" AND availability
	// = "PREORDER") OR (create_time >= "2015-02-14T13:03:32Z" AND availability =
	// "IN_STOCK") * Filter Limits: * Filter should not contain more than 6
	// conditions. * Max nesting depth should not exceed 2 levels. Examples
	// queries: * Delete back order products created before a timestamp.
	// create_time <= "2015-02-13T17:05:46Z" OR availability = "BACKORDER"
	Filter string `json:"filter,omitempty"`
	// Force: Actually perform the purge. If `force` is set to false, the method
	// will return the expected purge count without deleting any products.
	Force bool `json:"force,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPurgeProductsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeProductsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurgeProductsResponse: Response of the
// PurgeProductsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudRetailV2alphaPurgeProductsResponse struct {
	// PurgeCount: The total count of products purged as a result of the operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of the product names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be returned
	// and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPurgeProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurgeUserEventsRequest: Request message for
// PurgeUserEvents method.
type GoogleCloudRetailV2alphaPurgeUserEventsRequest struct {
	// Filter: Required. The filter string to specify the events to be deleted with
	// a length limit of 5,000 characters. Empty string filter is not allowed. The
	// eligible fields for filtering are: * `eventType`: Double quoted
	// UserEvent.event_type string. * `eventTime`: in ISO 8601 "zulu" format. *
	// `visitorId`: Double quoted string. Specifying this will delete all events
	// associated with a visitor. * `userId`: Double quoted string. Specifying this
	// will delete all events associated with a user. Examples: * Deleting all
	// events in a time range: `eventTime > "2012-04-23T18:25:43.511Z" eventTime <
	// "2012-04-23T18:30:43.511Z" * Deleting specific eventType in time range:
	// `eventTime > "2012-04-23T18:25:43.511Z" eventType = "detail-page-view" *
	// Deleting all events for a specific visitor: `visitorId = "visitor1024" The
	// filtering fields are assumed to have an implicit AND.
	Filter string `json:"filter,omitempty"`
	// Force: Actually perform the purge. If `force` is set to false, the method
	// will return the expected purge count without deleting any user events.
	Force bool `json:"force,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPurgeUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudRetailV2alphaPurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of the
	// operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgedEventsCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRating: The rating of a Product.
type GoogleCloudRetailV2alphaRating struct {
	// AverageRating: The average rating of the Product. The rating is scaled at
	// 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
	AverageRating float64 `json:"averageRating,omitempty"`
	// RatingCount: The total number of ratings. This value is independent of the
	// value of rating_histogram. This value must be nonnegative. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	RatingCount int64 `json:"ratingCount,omitempty"`
	// RatingHistogram: List of rating counts per rating value (index = rating -
	// 1). The list is empty if there is no rating. If the list is non-empty, its
	// size is always 5. Otherwise, an INVALID_ARGUMENT error is returned. For
	// example, [41, 14, 13, 47, 303]. It means that the Product got 41 ratings
	// with 1 star, 14 ratings with 2 star, and so on.
	RatingHistogram []int64 `json:"ratingHistogram,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageRating") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageRating") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRating) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRating
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaRating) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaRating
	var s1 struct {
		AverageRating gensupport.JSONFloat64 `json:"averageRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageRating = float64(s1.AverageRating)
	return nil
}

// GoogleCloudRetailV2alphaRejoinUserEventsMetadata: Metadata for
// `RejoinUserEvents` method.
type GoogleCloudRetailV2alphaRejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2alphaRejoinUserEventsRequest: Request message for
// RejoinUserEvents method.
type GoogleCloudRetailV2alphaRejoinUserEventsRequest struct {
	// UserEventRejoinScope: The type of the user event rejoin to define the scope
	// and range of the user events to be rejoined with the latest product catalog.
	// Defaults to `USER_EVENT_REJOIN_SCOPE_UNSPECIFIED` if this field is not set,
	// or set to an invalid integer value.
	//
	// Possible values:
	//   "USER_EVENT_REJOIN_SCOPE_UNSPECIFIED" - Rejoin all events with the latest
	// product catalog, including both joined events and unjoined events.
	//   "JOINED_EVENTS" - Only rejoin joined events with the latest product
	// catalog.
	//   "UNJOINED_EVENTS" - Only rejoin unjoined events with the latest product
	// catalog.
	UserEventRejoinScope string `json:"userEventRejoinScope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserEventRejoinScope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserEventRejoinScope") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRejoinUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRejoinUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRejoinUserEventsResponse: Response message for
// `RejoinUserEvents` method.
type GoogleCloudRetailV2alphaRejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with latest
	// product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "RejoinedUserEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRejoinUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRemoveCatalogAttributeRequest: Request for
// CatalogService.RemoveCatalogAttribute method.
type GoogleCloudRetailV2alphaRemoveCatalogAttributeRequest struct {
	// Key: Required. The attribute name key of the CatalogAttribute to remove.
	Key string `json:"key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRemoveCatalogAttributeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRemoveCatalogAttributeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRemoveControlRequest: Request for RemoveControl
// method.
type GoogleCloudRetailV2alphaRemoveControlRequest struct {
	// ControlId: Required. The id of the control to apply. Assumed to be in the
	// same catalog as the serving config.
	ControlId string `json:"controlId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ControlId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ControlId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRemoveControlRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRemoveControlRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRemoveFulfillmentPlacesMetadata: Metadata related to
// the progress of the RemoveFulfillmentPlaces operation. Currently empty
// because there is no meaningful metadata populated from the
// ProductService.RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2alphaRemoveFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2alphaRemoveFulfillmentPlacesRequest: Request message for
// ProductService.RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2alphaRemoveFulfillmentPlacesRequest struct {
	// AllowMissing: If set to true, and the Product is not found, the fulfillment
	// information will still be processed and retained for at most 1 day and
	// processed once the Product is created. If set to false, a NOT_FOUND error is
	// returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// PlaceIds: Required. The IDs for this type, such as the store IDs for
	// "pickup-in-store" or the region IDs for "same-day-delivery", to be removed
	// for this type. At least 1 value is required, and a maximum of 2000 values
	// are allowed. Each value must be a string with a length limit of 10
	// characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or
	// "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
	PlaceIds []string `json:"placeIds,omitempty"`
	// RemoveTime: The time when the fulfillment updates are issued, used to
	// prevent out-of-order updates on fulfillment information. If not provided,
	// the internal system time will be used.
	RemoveTime string `json:"removeTime,omitempty"`
	// Type: Required. The fulfillment type, including commonly used types (such as
	// pickup in store and same day delivery), and custom types. Supported values:
	// * "pickup-in-store" * "ship-to-store" * "same-day-delivery" *
	// "next-day-delivery" * "custom-type-1" * "custom-type-2" * "custom-type-3" *
	// "custom-type-4" * "custom-type-5" If this field is set to an invalid value
	// other than these, an INVALID_ARGUMENT error is returned. This field directly
	// corresponds to Product.fulfillment_info.type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRemoveFulfillmentPlacesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRemoveFulfillmentPlacesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRemoveFulfillmentPlacesResponse: Response of the
// RemoveFulfillmentPlacesRequest. Currently empty because there is no
// meaningful response populated from the
// ProductService.RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2alphaRemoveFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2alphaRemoveLocalInventoriesMetadata: Metadata related to
// the progress of the RemoveLocalInventories operation. Currently empty
// because there is no meaningful metadata populated from the
// ProductService.RemoveLocalInventories method.
type GoogleCloudRetailV2alphaRemoveLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2alphaRemoveLocalInventoriesRequest: Request message for
// ProductService.RemoveLocalInventories method.
type GoogleCloudRetailV2alphaRemoveLocalInventoriesRequest struct {
	// AllowMissing: If set to true, and the Product is not found, the local
	// inventory removal request will still be processed and retained for at most 1
	// day and processed once the Product is created. If set to false, a NOT_FOUND
	// error is returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// PlaceIds: Required. A list of place IDs to have their inventory deleted. At
	// most 3000 place IDs are allowed per request.
	PlaceIds []string `json:"placeIds,omitempty"`
	// RemoveTime: The time when the inventory deletions are issued. Used to
	// prevent out-of-order updates and deletions on local inventory fields. If not
	// provided, the internal system time will be used.
	RemoveTime string `json:"removeTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRemoveLocalInventoriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRemoveLocalInventoriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRemoveLocalInventoriesResponse: Response of the
// ProductService.RemoveLocalInventories API. Currently empty because there is
// no meaningful response populated from the
// ProductService.RemoveLocalInventories method.
type GoogleCloudRetailV2alphaRemoveLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2alphaReplaceCatalogAttributeRequest: Request for
// CatalogService.ReplaceCatalogAttribute method.
type GoogleCloudRetailV2alphaReplaceCatalogAttributeRequest struct {
	// CatalogAttribute: Required. The updated CatalogAttribute.
	CatalogAttribute *GoogleCloudRetailV2alphaCatalogAttribute `json:"catalogAttribute,omitempty"`
	// UpdateMask: Indicates which fields in the provided CatalogAttribute to
	// update. The following are NOT supported: * CatalogAttribute.key If not set,
	// all supported fields are updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CatalogAttribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CatalogAttribute") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaReplaceCatalogAttributeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaReplaceCatalogAttributeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaResumeModelRequest: Request for resuming training of
// a model.
type GoogleCloudRetailV2alphaResumeModelRequest struct {
}

// GoogleCloudRetailV2alphaRule: A rule is a condition-action pair * A
// condition defines when a rule is to be triggered. * An action specifies what
// occurs on that trigger. Currently rules only work for controls with
// SOLUTION_TYPE_SEARCH.
type GoogleCloudRetailV2alphaRule struct {
	// BoostAction: A boost action.
	BoostAction *GoogleCloudRetailV2alphaRuleBoostAction `json:"boostAction,omitempty"`
	// Condition: Required. The condition that triggers the rule. If the condition
	// is empty, the rule will always apply.
	Condition *GoogleCloudRetailV2alphaCondition `json:"condition,omitempty"`
	// DoNotAssociateAction: Prevents term from being associated with other terms.
	DoNotAssociateAction *GoogleCloudRetailV2alphaRuleDoNotAssociateAction `json:"doNotAssociateAction,omitempty"`
	// FilterAction: Filters results.
	FilterAction *GoogleCloudRetailV2alphaRuleFilterAction `json:"filterAction,omitempty"`
	// ForceReturnFacetAction: Force returns an attribute as a facet in the
	// request.
	ForceReturnFacetAction *GoogleCloudRetailV2alphaRuleForceReturnFacetAction `json:"forceReturnFacetAction,omitempty"`
	// IgnoreAction: Ignores specific terms from query during search.
	IgnoreAction *GoogleCloudRetailV2alphaRuleIgnoreAction `json:"ignoreAction,omitempty"`
	// OnewaySynonymsAction: Treats specific term as a synonym with a group of
	// terms. Group of terms will not be treated as synonyms with the specific
	// term.
	OnewaySynonymsAction *GoogleCloudRetailV2alphaRuleOnewaySynonymsAction `json:"onewaySynonymsAction,omitempty"`
	// RedirectAction: Redirects a shopper to a specific page.
	RedirectAction *GoogleCloudRetailV2alphaRuleRedirectAction `json:"redirectAction,omitempty"`
	// RemoveFacetAction: Remove an attribute as a facet in the request (if
	// present).
	RemoveFacetAction *GoogleCloudRetailV2alphaRuleRemoveFacetAction `json:"removeFacetAction,omitempty"`
	// ReplacementAction: Replaces specific terms in the query.
	ReplacementAction *GoogleCloudRetailV2alphaRuleReplacementAction `json:"replacementAction,omitempty"`
	// TwowaySynonymsAction: Treats a set of terms as synonyms of one another.
	TwowaySynonymsAction *GoogleCloudRetailV2alphaRuleTwowaySynonymsAction `json:"twowaySynonymsAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleBoostAction: A boost action to apply to results
// matching condition specified above.
type GoogleCloudRetailV2alphaRuleBoostAction struct {
	// Boost: Strength of the condition boost, which must be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0. Setting to 1.0 gives the item a big
	// promotion. However, it does not necessarily mean that the boosted item will
	// be the top result at all times, nor that other items will be excluded.
	// Results could still be shown even when none of them matches the condition.
	// And results that are significantly more relevant to the search query can
	// still trump your heavily favored but irrelevant items. Setting to -1.0 gives
	// the item a big demotion. However, results that are deeply relevant might
	// still be shown. The item will have an upstream battle to get a fairly high
	// ranking, but it is not blocked out completely. Setting to 0.0 means no boost
	// applied. The boosting condition is ignored.
	Boost float64 `json:"boost,omitempty"`
	// ProductsFilter: The filter can have a max size of 5000 characters. An
	// expression which specifies which products to apply an action to. The syntax
	// and supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: * To boost
	// products with product ID "product_1" or "product_2", and color "Red" or
	// "Blue": *(id: ANY("product_1", "product_2")) * *AND * *(colorFamilies:
	// ANY("Red", "Blue")) *
	ProductsFilter string `json:"productsFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaRuleBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaRuleBoostAction
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudRetailV2alphaRuleDoNotAssociateAction: Prevents `query_term` from
// being associated with specified terms during search. Example: Don't
// associate "gShoe" and "cheap".
type GoogleCloudRetailV2alphaRuleDoNotAssociateAction struct {
	// DoNotAssociateTerms: Cannot contain duplicates or the query term. Can
	// specify up to 100 terms.
	DoNotAssociateTerms []string `json:"doNotAssociateTerms,omitempty"`
	// QueryTerms: Terms from the search query. Will not consider
	// do_not_associate_terms for search if in search query. Can specify up to 100
	// terms.
	QueryTerms []string `json:"queryTerms,omitempty"`
	// Terms: Will be [deprecated = true] post migration;
	Terms []string `json:"terms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoNotAssociateTerms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoNotAssociateTerms") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleDoNotAssociateAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleDoNotAssociateAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleFilterAction: * Rule Condition: - No
// Condition.query_terms provided is a global match. - 1 or more
// Condition.query_terms provided are combined with OR operator. * Action
// Input: The request query and filter that are applied to the retrieved
// products, in addition to any filters already provided with the
// SearchRequest. The AND operator is used to combine the query's existing
// filters with the filter rule(s). NOTE: May result in 0 results when filters
// conflict. * Action Result: Filters the returned objects to be ONLY those
// that passed the filter.
type GoogleCloudRetailV2alphaRuleFilterAction struct {
	// Filter: A filter to apply on the matching condition results. Supported
	// features: * filter must be set. * Filter syntax is identical to
	// SearchRequest.filter. For more information, see Filter
	// (/retail/docs/filter-and-order#filter). * To filter products with product ID
	// "product_1" or "product_2", and color "Red" or "Blue": *(id:
	// ANY("product_1", "product_2")) * *AND * *(colorFamilies: ANY("Red", "Blue"))
	// *
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleForceReturnFacetAction: Force returns an
// attribute/facet in the request around a certain position or above. * Rule
// Condition: Must specify non-empty Condition.query_terms (for search only) or
// Condition.page_categories (for browse only), but can't specify both. *
// Action Inputs: attribute name, position * Action Result: Will force return a
// facet key around a certain position or above if the condition is satisfied.
// Example: Suppose the query is "shoes", the Condition.query_terms is "shoes",
// the ForceReturnFacetAction.FacetPositionAdjustment.attribute_name is "size"
// and the ForceReturnFacetAction.FacetPositionAdjustment.position is 8. Two
// cases: a) The facet key "size" is not already in the top 8 slots, then the
// facet "size" will appear at a position close to 8. b) The facet key "size"
// in among the top 8 positions in the request, then it will stay at its
// current rank.
type GoogleCloudRetailV2alphaRuleForceReturnFacetAction struct {
	// FacetPositionAdjustments: Each instance corresponds to a force return
	// attribute for the given condition. There can't be more 15 instances here.
	FacetPositionAdjustments []*GoogleCloudRetailV2alphaRuleForceReturnFacetActionFacetPositionAdjustment `json:"facetPositionAdjustments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FacetPositionAdjustments")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FacetPositionAdjustments") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleForceReturnFacetAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleForceReturnFacetAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleForceReturnFacetActionFacetPositionAdjustment:
// Each facet position adjustment consists of a single attribute name (i.e.
// facet key) along with a specified position.
type GoogleCloudRetailV2alphaRuleForceReturnFacetActionFacetPositionAdjustment struct {
	// AttributeName: The attribute name to force return as a facet. Each attribute
	// name should be a valid attribute name, be non-empty and contain at most 80
	// characters long.
	AttributeName string `json:"attributeName,omitempty"`
	// Position: This is the position in the request as explained above. It should
	// be strictly positive be at most 100.
	Position int64 `json:"position,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleForceReturnFacetActionFacetPositionAdjustment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleForceReturnFacetActionFacetPositionAdjustment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleIgnoreAction: Prevents a term in the query from
// being used in search. Example: Don't search for "shoddy".
type GoogleCloudRetailV2alphaRuleIgnoreAction struct {
	// IgnoreTerms: Terms to ignore in the search query.
	IgnoreTerms []string `json:"ignoreTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreTerms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreTerms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleIgnoreAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleIgnoreAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleOnewaySynonymsAction: Maps a set of terms to a
// set of synonyms. Set of synonyms will be treated as synonyms of each query
// term only. `query_terms` will not be treated as synonyms of each other.
// Example: "sneakers" will use a synonym of "shoes". "shoes" will not use a
// synonym of "sneakers".
type GoogleCloudRetailV2alphaRuleOnewaySynonymsAction struct {
	// OnewayTerms: Will be [deprecated = true] post migration;
	OnewayTerms []string `json:"onewayTerms,omitempty"`
	// QueryTerms: Terms from the search query. Will treat synonyms as their
	// synonyms. Not themselves synonyms of the synonyms. Can specify up to 100
	// terms.
	QueryTerms []string `json:"queryTerms,omitempty"`
	// Synonyms: Defines a set of synonyms. Cannot contain duplicates. Can specify
	// up to 100 synonyms.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OnewayTerms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OnewayTerms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleOnewaySynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleOnewaySynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleRedirectAction: Redirects a shopper to a
// specific page. * Rule Condition: Must specify Condition.query_terms. *
// Action Input: Request Query * Action Result: Redirects shopper to provided
// uri.
type GoogleCloudRetailV2alphaRuleRedirectAction struct {
	// RedirectUri: URL must have length equal or less than 2000 characters.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleRemoveFacetAction: Removes an attribute/facet in
// the request if is present. * Rule Condition: Must specify non-empty
// Condition.query_terms (for search only) or Condition.page_categories (for
// browse only), but can't specify both. * Action Input: attribute name *
// Action Result: Will remove the attribute (as a facet) from the request if it
// is present. Example: Suppose the query is "shoes", the Condition.query_terms
// is "shoes" and the attribute name "size", then facet key "size" will be
// removed from the request (if it is present).
type GoogleCloudRetailV2alphaRuleRemoveFacetAction struct {
	// AttributeNames: The attribute names (i.e. facet keys) to remove from the
	// dynamic facets (if present in the request). There can't be more 3 attribute
	// names. Each attribute name should be a valid attribute name, be non-empty
	// and contain at most 80 characters.
	AttributeNames []string `json:"attributeNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeNames") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleRemoveFacetAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleRemoveFacetAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleReplacementAction: Replaces a term in the query.
// Multiple replacement candidates can be specified. All `query_terms` will be
// replaced with the replacement term. Example: Replace "gShoe" with "google
// shoe".
type GoogleCloudRetailV2alphaRuleReplacementAction struct {
	// QueryTerms: Terms from the search query. Will be replaced by replacement
	// term. Can specify up to 100 terms.
	QueryTerms []string `json:"queryTerms,omitempty"`
	// ReplacementTerm: Term that will be used for replacement.
	ReplacementTerm string `json:"replacementTerm,omitempty"`
	// Term: Will be [deprecated = true] post migration;
	Term string `json:"term,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryTerms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryTerms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleReplacementAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleReplacementAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRuleTwowaySynonymsAction: Creates a set of terms
// that will be treated as synonyms of each other. Example: synonyms of
// "sneakers" and "shoes": * "sneakers" will use a synonym of "shoes". *
// "shoes" will use a synonym of "sneakers".
type GoogleCloudRetailV2alphaRuleTwowaySynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaRuleTwowaySynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRuleTwowaySynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequest: Request message for
// SearchService.Search method.
type GoogleCloudRetailV2alphaSearchRequest struct {
	// BoostSpec: Boost specification to boost certain products. For more
	// information, see Boost results
	// (https://cloud.google.com/retail/docs/boosting). Notice that if both
	// ServingConfig.boost_control_ids and SearchRequest.boost_spec are set, the
	// boost conditions from both places are evaluated. If a search request matches
	// multiple boost conditions, the final boost score is equal to the sum of the
	// boost scores from all matched boost conditions.
	BoostSpec *GoogleCloudRetailV2alphaSearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Branch: The branch resource name, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/0`. Use
	// "default_branch" as the branch ID or leave this field empty, to search
	// products under the default branch.
	Branch string `json:"branch,omitempty"`
	// CanonicalFilter: The default filter that is applied when a user performs a
	// search without checking any filters on the search page. The filter applied
	// to every search request when quality improvement such as query expansion is
	// needed. In the case a query does not have a sufficient amount of results
	// this filter will be used to determine whether or not to enable the query
	// expansion flow. The original filter will still be used for the query
	// expanded search. This field is strongly recommended to achieve high search
	// quality. For more information about filter syntax, see SearchRequest.filter.
	CanonicalFilter string `json:"canonicalFilter,omitempty"`
	// DynamicFacetSpec: Deprecated. Refer to
	// https://cloud.google.com/retail/docs/configs#dynamic to enable dynamic
	// facets. Do not set this field. The specification for dynamically generated
	// facets. Notice that only textual facets can be dynamically generated.
	DynamicFacetSpec *GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpec `json:"dynamicFacetSpec,omitempty"`
	// Entity: The entity for customers that may run multiple different entities,
	// domains, sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
	// `google.com`, `youtube.com`, etc. If this is set, it should be exactly
	// matched with UserEvent.entity to get search results boosted by entity.
	Entity string `json:"entity,omitempty"`
	// FacetSpecs: Facet specifications for faceted search. If empty, no facets are
	// returned. A maximum of 200 values are allowed. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	FacetSpecs []*GoogleCloudRetailV2alphaSearchRequestFacetSpec `json:"facetSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the products being
	// filtered. Filter expression is case-sensitive. For more information, see
	// Filter (https://cloud.google.com/retail/docs/filter-and-order#filter). If
	// this field is unrecognizable, an INVALID_ARGUMENT is returned.
	Filter string `json:"filter,omitempty"`
	// Labels: The labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. For more information, see Requirements
	// for labels
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// in the Resource Manager documentation.
	Labels map[string]string `json:"labels,omitempty"`
	// Offset: A 0-indexed integer that specifies the current offset (that is,
	// starting result location, amongst the Products deemed by the API as
	// relevant) in search results. This field is only considered if page_token is
	// unset. If this field is negative, an INVALID_ARGUMENT is returned.
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The order in which products are returned. Products can be ordered
	// by a field in an Product object. Leave it unset if ordered by relevance.
	// OrderBy expression is case-sensitive. For more information, see Order
	// (https://cloud.google.com/retail/docs/filter-and-order#order). If this field
	// is unrecognizable, an INVALID_ARGUMENT is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// PageCategories: The categories associated with a category page. Must be set
	// for category navigation queries to achieve good search quality. The format
	// should be the same as UserEvent.page_categories; To represent full path of
	// category, use '>' sign to separate different hierarchies. If '>' is part of
	// the category name, replace it with other character(s). Category pages
	// include special pages such as sales or promotions. For instance, a special
	// sale page may have the category hierarchy: "pageCategories" : ["Sales > 2017
	// Black Friday Deals"].
	PageCategories []string `json:"pageCategories,omitempty"`
	// PageSize: Maximum number of Products to return. If unspecified, defaults to
	// a reasonable value. The maximum allowed value is 120. Values above 120 will
	// be coerced to 120. If this field is negative, an INVALID_ARGUMENT is
	// returned.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token SearchResponse.next_page_token, received from a
	// previous SearchService.Search call. Provide this to retrieve the subsequent
	// page. When paginating, all other parameters provided to SearchService.Search
	// must match the call that provided the page token. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	PageToken string `json:"pageToken,omitempty"`
	// PersonalizationSpec: The specification for personalization. Notice that if
	// both ServingConfig.personalization_spec and
	// SearchRequest.personalization_spec are set.
	// SearchRequest.personalization_spec will override
	// ServingConfig.personalization_spec.
	PersonalizationSpec *GoogleCloudRetailV2alphaSearchRequestPersonalizationSpec `json:"personalizationSpec,omitempty"`
	// Query: Raw search query. If this field is empty, the request is considered a
	// category browsing request and returned results are based on filter and
	// page_categories.
	Query string `json:"query,omitempty"`
	// QueryExpansionSpec: The query expansion specification that specifies the
	// conditions under which query expansion occurs. For more information, see
	// Query expansion
	// (https://cloud.google.com/retail/docs/result-size#query_expansion).
	QueryExpansionSpec *GoogleCloudRetailV2alphaSearchRequestQueryExpansionSpec `json:"queryExpansionSpec,omitempty"`
	// RelevanceThreshold: The relevance threshold of the search results. Defaults
	// to RelevanceThreshold.HIGH, which means only the most relevant results are
	// shown, and the least number of results are returned. For more information,
	// see Adjust result size
	// (https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
	//
	// Possible values:
	//   "RELEVANCE_THRESHOLD_UNSPECIFIED" - Default value. In this case, server
	// behavior defaults to RelevanceThreshold.HIGH.
	//   "HIGH" - High relevance threshold.
	//   "MEDIUM" - Medium relevance threshold.
	//   "LOW" - Low relevance threshold.
	//   "LOWEST" - Lowest relevance threshold.
	RelevanceThreshold string `json:"relevanceThreshold,omitempty"`
	// SearchMode: The search mode of the search request. If not specified, a
	// single search request triggers both product search and faceted search.
	//
	// Possible values:
	//   "SEARCH_MODE_UNSPECIFIED" - Default value. In this case both product
	// search and faceted search will be performed. Both
	// SearchResponse.SearchResult and SearchResponse.Facet will be returned.
	//   "PRODUCT_SEARCH_ONLY" - Only product search will be performed. The faceted
	// search will be disabled. Only SearchResponse.SearchResult will be returned.
	// SearchResponse.Facet will not be returned, even if SearchRequest.facet_specs
	// or SearchRequest.dynamic_facet_spec is set.
	//   "FACETED_SEARCH_ONLY" - Only faceted search will be performed. The product
	// search will be disabled. When in this mode, one or both of
	// SearchRequest.facet_specs and SearchRequest.dynamic_facet_spec should be
	// set. Otherwise, an INVALID_ARGUMENT error is returned. Only
	// SearchResponse.Facet will be returned. SearchResponse.SearchResult will not
	// be returned.
	SearchMode string `json:"searchMode,omitempty"`
	// SpellCorrectionSpec: The spell correction specification that specifies the
	// mode under which spell correction will take effect.
	SpellCorrectionSpec *GoogleCloudRetailV2alphaSearchRequestSpellCorrectionSpec `json:"spellCorrectionSpec,omitempty"`
	// UserInfo: User information.
	UserInfo *GoogleCloudRetailV2alphaUserInfo `json:"userInfo,omitempty"`
	// VariantRollupKeys: The keys to fetch and rollup the matching variant
	// Products attributes, FulfillmentInfo or LocalInventorys attributes. The
	// attributes from all the matching variant Products or LocalInventorys are
	// merged and de-duplicated. Notice that rollup attributes will lead to extra
	// query latency. Maximum number of keys is 30. For FulfillmentInfo, a
	// fulfillment type and a fulfillment ID must be provided in the format of
	// "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
	// "pickupInStore" is fulfillment type and "store123" is the store ID.
	// Supported keys are: * colorFamilies * price * originalPrice * discount *
	// variantId * inventory(place_id,price) * inventory(place_id,original_price) *
	// inventory(place_id,attributes.key), where key is any key in the
	// Product.local_inventories.attributes map. * attributes.key, where key is any
	// key in the Product.attributes map. * pickupInStore.id, where id is any
	// FulfillmentInfo.place_ids for FulfillmentInfo.type "pickup-in-store". *
	// shipToStore.id, where id is any FulfillmentInfo.place_ids for
	// FulfillmentInfo.type "ship-to-store". * sameDayDelivery.id, where id is any
	// FulfillmentInfo.place_ids for FulfillmentInfo.type "same-day-delivery". *
	// nextDayDelivery.id, where id is any FulfillmentInfo.place_ids for
	// FulfillmentInfo.type "next-day-delivery". * customFulfillment1.id, where id
	// is any FulfillmentInfo.place_ids for FulfillmentInfo.type "custom-type-1". *
	// customFulfillment2.id, where id is any FulfillmentInfo.place_ids for
	// FulfillmentInfo.type "custom-type-2". * customFulfillment3.id, where id is
	// any FulfillmentInfo.place_ids for FulfillmentInfo.type "custom-type-3". *
	// customFulfillment4.id, where id is any FulfillmentInfo.place_ids for
	// FulfillmentInfo.type "custom-type-4". * customFulfillment5.id, where id is
	// any FulfillmentInfo.place_ids for FulfillmentInfo.type "custom-type-5". If
	// this field is set to an invalid value other than these, an INVALID_ARGUMENT
	// error is returned.
	VariantRollupKeys []string `json:"variantRollupKeys,omitempty"`
	// VisitorId: Required. A unique identifier for tracking visitors. For example,
	// this could be implemented with an HTTP cookie, which should be able to
	// uniquely identify a visitor on a single device. This unique identifier
	// should not change if the visitor logs in or out of the website. This should
	// be the same identifier as UserEvent.visitor_id. The field must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	VisitorId string `json:"visitorId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequestBoostSpec: Boost specification to boost
// certain items.
type GoogleCloudRetailV2alphaSearchRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a product matches
	// multiple conditions in the specifictions, boost scores from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20.
	ConditionBoostSpecs []*GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// SkipBoostSpecValidation: Whether to skip boostspec validation. If this field
	// is set to true, invalid BoostSpec.condition_boost_specs will be ignored and
	// valid BoostSpec.condition_boost_specs will still be applied.
	SkipBoostSpecValidation bool `json:"skipBoostSpecValidation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec: Boost
// applies to products which match a condition.
type GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0. Setting to 1.0 gives the item a big
	// promotion. However, it does not necessarily mean that the boosted item will
	// be the top result at all times, nor that other items will be excluded.
	// Results could still be shown even when none of them matches the condition.
	// And results that are significantly more relevant to the search query can
	// still trump your heavily favored but irrelevant items. Setting to -1.0 gives
	// the item a big demotion. However, results that are deeply relevant might
	// still be shown. The item will have an upstream battle to get a fairly high
	// ranking, but it is not blocked out completely. Setting to 0.0 means no boost
	// applied. The boosting condition is ignored.
	Boost float64 `json:"boost,omitempty"`
	// Condition: An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: * To boost
	// products with product ID "product_1" or "product_2", and color "Red" or
	// "Blue": * (id: ANY("product_1", "product_2")) AND (colorFamilies:
	// ANY("Red","Blue"))
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpec: The specifications of
// dynamically generated facets.
type GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpec struct {
	// Mode: Mode of the DynamicFacet feature. Defaults to Mode.DISABLED if it's
	// unset.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value.
	//   "DISABLED" - Disable Dynamic Facet.
	//   "ENABLED" - Automatic mode built by Google Retail Search.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequestFacetSpec: A facet specification to
// perform faceted search.
type GoogleCloudRetailV2alphaSearchRequestFacetSpec struct {
	// EnableDynamicPosition: Enables dynamic position for this facet. If set to
	// true, the position of this facet among all facets in the response is
	// determined by Google Retail Search. It is ordered together with dynamic
	// facets if dynamic facets is enabled. If set to false, the position of this
	// facet in the response is the same as in the request, and it is ranked before
	// the facets with dynamic position enable and all dynamic facets. For example,
	// you may always want to have rating facet returned in the response, but it's
	// not necessarily to always display the rating facet at the top. In that case,
	// you can set enable_dynamic_position to true so that the position of rating
	// facet in response is determined by Google Retail Search. Another example,
	// assuming you have the following facets in the request: * "rating",
	// enable_dynamic_position = true * "price", enable_dynamic_position = false *
	// "brands", enable_dynamic_position = false And also you have a dynamic facets
	// enable, which generates a facet "gender". Then, the final order of the
	// facets in the response can be ("price", "brands", "rating", "gender") or
	// ("price", "brands", "gender", "rating") depends on how Google Retail Search
	// orders "gender" and "rating" facets. However, notice that "price" and
	// "brands" are always ranked at first and second position because their
	// enable_dynamic_position values are false.
	EnableDynamicPosition bool `json:"enableDynamicPosition,omitempty"`
	// ExcludedFilterKeys: List of keys to exclude when faceting. By default,
	// FacetKey.key is not excluded from the filter unless it is listed in this
	// field. Listing a facet key in this field allows its values to appear as
	// facet results, even when they are filtered out of search results. Using this
	// field does not affect what search results are returned. For example, suppose
	// there are 100 products with the color facet "Red" and 200 products with the
	// color facet "Blue". A query containing the filter "colorFamilies:ANY("Red")"
	// and having "colorFamilies" as FacetKey.key would by default return only
	// "Red" products in the search results, and also return "Red" with count 100
	// as the only color facet. Although there are also blue products available,
	// "Blue" would not be shown as an available facet value. If "colorFamilies" is
	// listed in "excludedFilterKeys", then the query returns the facet values
	// "Red" with count 100 and "Blue" with count 200, because the "colorFamilies"
	// key is now excluded from the filter. Because this field doesn't affect
	// search results, the search results are still correctly filtered to return
	// only "Red" products. A maximum of 100 values are allowed. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	ExcludedFilterKeys []string `json:"excludedFilterKeys,omitempty"`
	// FacetKey: Required. The facet key specification.
	FacetKey *GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKey `json:"facetKey,omitempty"`
	// Limit: Maximum of facet values that should be returned for this facet. If
	// unspecified, defaults to 50. The maximum allowed value is 300. Values above
	// 300 will be coerced to 300. If this field is negative, an INVALID_ARGUMENT
	// is returned.
	Limit int64 `json:"limit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableDynamicPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableDynamicPosition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestFacetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKey: Specifies how a
// facet is computed.
type GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKey struct {
	// CaseInsensitive: True to make facet keys case insensitive when getting
	// faceting values with prefixes or contains; false otherwise.
	CaseInsensitive bool `json:"caseInsensitive,omitempty"`
	// Contains: Only get facet values that contains the given strings. For
	// example, suppose "categories" has three values "Women > Shoe", "Women >
	// Dress" and "Men > Shoe". If set "contains" to "Shoe", the "categories" facet
	// gives only "Women > Shoe" and "Men > Shoe". Only supported on textual
	// fields. Maximum is 10.
	Contains []string `json:"contains,omitempty"`
	// Intervals: Set only if values should be bucketized into intervals. Must be
	// set for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 40. For all numerical facet keys that
	// appear in the list of products from the catalog, the percentiles 0, 10, 30,
	// 50, 70, 90, and 100 are computed from their distribution weekly. If the
	// model assigns a high score to a numerical facet key and its intervals are
	// not specified in the search request, these percentiles become the bounds for
	// its intervals and are returned in the response. If the facet key intervals
	// are specified in the request, then the specified intervals are returned
	// instead.
	Intervals []*GoogleCloudRetailV2alphaInterval `json:"intervals,omitempty"`
	// Key: Required. Supported textual and numerical facet keys in Product object,
	// over which the facet values are computed. Facet key is case-sensitive.
	// Allowed facet keys when FacetKey.query is not specified: * textual_field = *
	// "brands" * "categories" * "genders" * "ageGroups" * "availability" *
	// "colorFamilies" * "colors" * "sizes" * "materials" * "patterns" *
	// "conditions" * "attributes.key" * "pickupInStore" * "shipToStore" *
	// "sameDayDelivery" * "nextDayDelivery" * "customFulfillment1" *
	// "customFulfillment2" * "customFulfillment3" * "customFulfillment4" *
	// "customFulfillment5" * "inventory(place_id,attributes.key)" *
	// numerical_field = * "price" * "discount" * "rating" * "ratingCount" *
	// "attributes.key" * "inventory(place_id,price)" *
	// "inventory(place_id,original_price)" * "inventory(place_id,attributes.key)"
	Key string `json:"key,omitempty"`
	// OrderBy: The order in which SearchResponse.Facet.values are returned.
	// Allowed values are: * "count desc", which means order by
	// SearchResponse.Facet.values.count descending. * "value desc", which means
	// order by SearchResponse.Facet.values.value descending. Only applies to
	// textual facets. If not set, textual values are sorted in natural order
	// (https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are
	// sorted in the order given by FacetSpec.FacetKey.intervals;
	// FulfillmentInfo.place_ids are sorted in the order given by
	// FacetSpec.FacetKey.restricted_values.
	OrderBy string `json:"orderBy,omitempty"`
	// Prefixes: Only get facet values that start with the given string prefix. For
	// example, suppose "categories" has three values "Women > Shoe", "Women >
	// Dress" and "Men > Shoe". If set "prefixes" to "Women", the "categories"
	// facet gives only "Women > Shoe" and "Women > Dress". Only supported on
	// textual fields. Maximum is 10.
	Prefixes []string `json:"prefixes,omitempty"`
	// Query: The query that is used to compute facet for the given facet key. When
	// provided, it overrides the default behavior of facet computation. The query
	// syntax is the same as a filter expression. See SearchRequest.filter for
	// detail syntax and limitations. Notice that there is no limitation on
	// FacetKey.key when query is specified. In the response,
	// SearchResponse.Facet.values.value is always "1" and
	// SearchResponse.Facet.values.count is the number of results that match the
	// query. For example, you can set a customized facet for "shipToStore", where
	// FacetKey.key is "customizedShipToStore", and FacetKey.query is
	// "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")". Then the
	// facet counts the products that are both in stock and ship to store "123".
	Query string `json:"query,omitempty"`
	// RestrictedValues: Only get facet for the given restricted values. For
	// example, when using "pickupInStore" as key and set restricted values to
	// ["store123", "store456"], only facets for "store123" and "store456" are
	// returned. Only supported on predefined textual fields, custom textual
	// attributes and fulfillments. Maximum is 20. Must be set for the fulfillment
	// facet keys: * pickupInStore * shipToStore * sameDayDelivery *
	// nextDayDelivery * customFulfillment1 * customFulfillment2 *
	// customFulfillment3 * customFulfillment4 * customFulfillment5
	RestrictedValues []string `json:"restrictedValues,omitempty"`
	// ReturnMinMax: Returns the min and max value for each numerical facet
	// intervals. Ignored for textual facets.
	ReturnMinMax bool `json:"returnMinMax,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseInsensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseInsensitive") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestFacetSpecFacetKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequestPersonalizationSpec: The specification
// for personalization.
type GoogleCloudRetailV2alphaSearchRequestPersonalizationSpec struct {
	// Mode: Defaults to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value. In this case, server behavior defaults
	// to Mode.AUTO.
	//   "AUTO" - Let CRS decide whether to use personalization based on quality of
	// user event data.
	//   "DISABLED" - Disable personalization.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestPersonalizationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestPersonalizationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequestQueryExpansionSpec: Specification to
// determine under which conditions query expansion should occur.
type GoogleCloudRetailV2alphaSearchRequestQueryExpansionSpec struct {
	// Condition: The condition under which query expansion should occur. Default
	// to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Unspecified query expansion condition. In this
	// case, server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disabled query expansion. Only the exact search query is
	// used, even if SearchResponse.total_size is zero.
	//   "AUTO" - Automatic query expansion built by Google Retail Search.
	Condition string `json:"condition,omitempty"`
	// PinUnexpandedResults: Whether to pin unexpanded results. If this field is
	// set to true, unexpanded products are always at the top of the search
	// results, followed by the expanded results.
	PinUnexpandedResults bool `json:"pinUnexpandedResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestQueryExpansionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestQueryExpansionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchRequestSpellCorrectionSpec: The specification
// for query spell correction.
type GoogleCloudRetailV2alphaSearchRequestSpellCorrectionSpec struct {
	// Mode: The mode under which spell correction should take effect to replace
	// the original search query. Default to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified spell correction mode. In this case,
	// server behavior defaults to Mode.AUTO.
	//   "SUGGESTION_ONLY" - Google Retail Search will try to find a spell
	// suggestion if there is any and put in the SearchResponse.corrected_query.
	// The spell suggestion will not be used as the search query.
	//   "AUTO" - Automatic spell correction built by Google Retail Search. Search
	// will be based on the corrected query if found.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchRequestSpellCorrectionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchRequestSpellCorrectionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchResponse: Response message for
// SearchService.Search method.
type GoogleCloudRetailV2alphaSearchResponse struct {
	// AppliedControls: The fully qualified resource name of applied controls
	// (https://cloud.google.com/retail/docs/serving-control-rules).
	AppliedControls []string `json:"appliedControls,omitempty"`
	// AttributionToken: A unique search token. This should be included in the
	// UserEvent logs resulting from this search, which enables accurate
	// attribution of search model performance.
	AttributionToken string `json:"attributionToken,omitempty"`
	// CorrectedQuery: Contains the spell corrected query, if found. If the spell
	// correction type is AUTOMATIC, then the search results are based on
	// corrected_query. Otherwise the original query is used for search.
	CorrectedQuery string `json:"correctedQuery,omitempty"`
	// ExperimentInfo: Metadata related to A/B testing Experiment associated with
	// this response. Only exists when an experiment is triggered.
	ExperimentInfo []*GoogleCloudRetailV2alphaExperimentInfo `json:"experimentInfo,omitempty"`
	// Facets: Results of facets requested by user.
	Facets []*GoogleCloudRetailV2alphaSearchResponseFacet `json:"facets,omitempty"`
	// InvalidConditionBoostSpecs: The invalid
	// SearchRequest.BoostSpec.condition_boost_specs that are not applied during
	// serving.
	InvalidConditionBoostSpecs []*GoogleCloudRetailV2alphaSearchRequestBoostSpecConditionBoostSpec `json:"invalidConditionBoostSpecs,omitempty"`
	// NextPageToken: A token that can be sent as SearchRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QueryExpansionInfo: Query expansion information for the returned results.
	QueryExpansionInfo *GoogleCloudRetailV2alphaSearchResponseQueryExpansionInfo `json:"queryExpansionInfo,omitempty"`
	// RedirectUri: The URI of a customer-defined redirect page. If redirect action
	// is triggered, no search is performed, and only redirect_uri and
	// attribution_token are set in the response.
	RedirectUri string `json:"redirectUri,omitempty"`
	// Results: A list of matched items. The order represents the ranking.
	Results []*GoogleCloudRetailV2alphaSearchResponseSearchResult `json:"results,omitempty"`
	// TotalSize: The estimated total count of matched items irrespective of
	// pagination. The count of results returned by pagination may be less than the
	// total_size that matches.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppliedControls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppliedControls") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchResponseFacet: A facet result.
type GoogleCloudRetailV2alphaSearchResponseFacet struct {
	// DynamicFacet: Whether the facet is dynamically generated.
	DynamicFacet bool `json:"dynamicFacet,omitempty"`
	// Key: The key for this facet. E.g., "colorFamilies" or "price" or
	// "attributes.attr1".
	Key string `json:"key,omitempty"`
	// Values: The facet values for this field.
	Values []*GoogleCloudRetailV2alphaSearchResponseFacetFacetValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicFacet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicFacet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchResponseFacet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchResponseFacet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchResponseFacetFacetValue: A facet value which
// contains value names and their count.
type GoogleCloudRetailV2alphaSearchResponseFacetFacetValue struct {
	// Count: Number of items that have this facet value.
	Count int64 `json:"count,omitempty,string"`
	// Interval: Interval value for a facet, such as [10, 20) for facet "price".
	Interval *GoogleCloudRetailV2alphaInterval `json:"interval,omitempty"`
	// MaxValue: The maximum value in the FacetValue.interval. Only supported on
	// numerical facets and returned if
	// SearchRequest.FacetSpec.FacetKey.return_min_max is true.
	MaxValue float64 `json:"maxValue,omitempty"`
	// MinValue: The minimum value in the FacetValue.interval. Only supported on
	// numerical facets and returned if
	// SearchRequest.FacetSpec.FacetKey.return_min_max is true.
	MinValue float64 `json:"minValue,omitempty"`
	// Value: Text value of a facet, such as "Black" for facet "colorFamilies".
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchResponseFacetFacetValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchResponseFacetFacetValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2alphaSearchResponseFacetFacetValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2alphaSearchResponseFacetFacetValue
	var s1 struct {
		MaxValue gensupport.JSONFloat64 `json:"maxValue"`
		MinValue gensupport.JSONFloat64 `json:"minValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxValue = float64(s1.MaxValue)
	s.MinValue = float64(s1.MinValue)
	return nil
}

// GoogleCloudRetailV2alphaSearchResponseQueryExpansionInfo: Information
// describing query expansion including whether expansion has occurred.
type GoogleCloudRetailV2alphaSearchResponseQueryExpansionInfo struct {
	// ExpandedQuery: Bool describing whether query expansion has occurred.
	ExpandedQuery bool `json:"expandedQuery,omitempty"`
	// PinnedResultCount: Number of pinned results. This field will only be set
	// when expansion happens and
	// SearchRequest.QueryExpansionSpec.pin_unexpanded_results is set to true.
	PinnedResultCount int64 `json:"pinnedResultCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ExpandedQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpandedQuery") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchResponseQueryExpansionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchResponseQueryExpansionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSearchResponseSearchResult: Represents the search
// results.
type GoogleCloudRetailV2alphaSearchResponseSearchResult struct {
	// Id: Product.id of the searched Product.
	Id string `json:"id,omitempty"`
	// MatchingVariantCount: The count of matched variant Products.
	MatchingVariantCount int64 `json:"matchingVariantCount,omitempty"`
	// MatchingVariantFields: If a variant Product matches the search query, this
	// map indicates which Product fields are matched. The key is the Product.name,
	// the value is a field mask of the matched Product fields. If matched
	// attributes cannot be determined, this map will be empty. For example, a key
	// "sku1" with field mask "products.color_info" indicates there is a match
	// between "sku1" ColorInfo and the query.
	MatchingVariantFields map[string]string `json:"matchingVariantFields,omitempty"`
	// PersonalLabels: Specifies previous events related to this product for this
	// user based on UserEvent with same SearchRequest.visitor_id or
	// UserInfo.user_id. This is set only when
	// SearchRequest.PersonalizationSpec.mode is
	// SearchRequest.PersonalizationSpec.Mode.AUTO. Possible values: * `purchased`:
	// Indicates that this product has been purchased before.
	PersonalLabels []string `json:"personalLabels,omitempty"`
	// Product: The product data snippet in the search response. Only Product.name
	// is guaranteed to be populated. Product.variants contains the product
	// variants that match the search query. If there are multiple product variants
	// matching the query, top 5 most relevant product variants are returned and
	// ordered by relevancy. If relevancy can be deternmined, use
	// matching_variant_fields to look up matched product variants fields. If
	// relevancy cannot be determined, e.g. when searching "shoe" all products in a
	// shoe product can be a match, 5 product variants are returned but order is
	// meaningless.
	Product *GoogleCloudRetailV2alphaProduct `json:"product,omitempty"`
	// VariantRollupValues: The rollup matching variant Product attributes. The key
	// is one of the SearchRequest.variant_rollup_keys. The values are the merged
	// and de-duplicated Product attributes. Notice that the rollup values are
	// respect filter. For example, when filtering by "colorFamilies:ANY(\"red\")"
	// and rollup "colorFamilies", only "red" is returned. For textual and
	// numerical attributes, the rollup values is a list of string or double values
	// with type google.protobuf.ListValue. For example, if there are two variants
	// with colors "red" and "blue", the rollup values are { key: "colorFamilies"
	// value { list_value { values { string_value: "red" } values { string_value:
	// "blue" } } } } For FulfillmentInfo, the rollup values is a double value with
	// type google.protobuf.Value. For example, `{key: "pickupInStore.store1" value
	// { number_value: 10 }}` means a there are 10 variants in this product are
	// available in the store "store1".
	VariantRollupValues googleapi.RawMessage `json:"variantRollupValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSearchResponseSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSearchResponseSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaServingConfig: Configures metadata that is used to
// generate serving time results (e.g. search results or recommendation
// predictions).
type GoogleCloudRetailV2alphaServingConfig struct {
	// BoostControlIds: Condition boost specifications. If a product matches
	// multiple conditions in the specifications, boost scores from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 100. Notice that if both
	// ServingConfig.boost_control_ids and SearchRequest.boost_spec are set, the
	// boost conditions from both places are evaluated. If a search request matches
	// multiple boost conditions, the final boost score is equal to the sum of the
	// boost scores from all matched boost conditions. Can only be set if
	// solution_types is SOLUTION_TYPE_SEARCH.
	BoostControlIds []string `json:"boostControlIds,omitempty"`
	// DisplayName: Required. The human readable serving config display name. Used
	// in Retail UI. This field must be a UTF-8 encoded string with a length limit
	// of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DiversityLevel: How much diversity to use in recommendation model results
	// e.g. `medium-diversity` or `high-diversity`. Currently supported values: *
	// `no-diversity` * `low-diversity` * `medium-diversity` * `high-diversity` *
	// `auto-diversity` If not specified, we choose default based on recommendation
	// model type. Default value: `no-diversity`. Can only be set if solution_types
	// is SOLUTION_TYPE_RECOMMENDATION.
	DiversityLevel string `json:"diversityLevel,omitempty"`
	// DiversityType: What kind of diversity to use - data driven or rule based. If
	// unset, the server behavior defaults to RULE_BASED_DIVERSITY.
	//
	// Possible values:
	//   "DIVERSITY_TYPE_UNSPECIFIED" - Default value.
	//   "RULE_BASED_DIVERSITY" - Rule based diversity.
	//   "DATA_DRIVEN_DIVERSITY" - Data driven diversity.
	DiversityType string `json:"diversityType,omitempty"`
	// DoNotAssociateControlIds: Condition do not associate specifications. If
	// multiple do not associate conditions match, all matching do not associate
	// controls in the list will execute. - Order does not matter. - Maximum number
	// of specifications is 100. Can only be set if solution_types is
	// SOLUTION_TYPE_SEARCH.
	DoNotAssociateControlIds []string `json:"doNotAssociateControlIds,omitempty"`
	// DynamicFacetSpec: The specification for dynamically generated facets. Notice
	// that only textual facets can be dynamically generated. Can only be set if
	// solution_types is SOLUTION_TYPE_SEARCH.
	DynamicFacetSpec *GoogleCloudRetailV2alphaSearchRequestDynamicFacetSpec `json:"dynamicFacetSpec,omitempty"`
	// EnableCategoryFilterLevel: Whether to add additional category filters on the
	// `similar-items` model. If not specified, we enable it by default. Allowed
	// values are: * `no-category-match`: No additional filtering of original
	// results from the model and the customer's filters. *
	// `relaxed-category-match`: Only keep results with categories that match at
	// least one item categories in the PredictRequests's context item. * If
	// customer also sends filters in the PredictRequest, then the results will
	// satisfy both conditions (user given and category match). Can only be set if
	// solution_types is SOLUTION_TYPE_RECOMMENDATION.
	EnableCategoryFilterLevel string `json:"enableCategoryFilterLevel,omitempty"`
	// FacetControlIds: Facet specifications for faceted search. If empty, no
	// facets are returned. The ids refer to the ids of Control resources with only
	// the Facet control set. These controls are assumed to be in the same Catalog
	// as the ServingConfig. A maximum of 100 values are allowed. Otherwise, an
	// INVALID_ARGUMENT error is returned. Can only be set if solution_types is
	// SOLUTION_TYPE_SEARCH.
	FacetControlIds []string `json:"facetControlIds,omitempty"`
	// FilterControlIds: Condition filter specifications. If a product matches
	// multiple conditions in the specifications, filters from these specifications
	// are all applied and combined via the AND operator. Maximum number of
	// specifications is 100. Can only be set if solution_types is
	// SOLUTION_TYPE_SEARCH.
	FilterControlIds []string `json:"filterControlIds,omitempty"`
	// IgnoreControlIds: Condition ignore specifications. If multiple ignore
	// conditions match, all matching ignore controls in the list will execute. -
	// Order does not matter. - Maximum number of specifications is 100. Can only
	// be set if solution_types is SOLUTION_TYPE_SEARCH.
	IgnoreControlIds []string `json:"ignoreControlIds,omitempty"`
	// IgnoreRecsDenylist: When the flag is enabled, the products in the denylist
	// will not be filtered out in the recommendation filtering results.
	IgnoreRecsDenylist bool `json:"ignoreRecsDenylist,omitempty"`
	// ModelId: The id of the model in the same Catalog to use at serving time.
	// Currently only RecommendationModels are supported:
	// https://cloud.google.com/retail/recommendations-ai/docs/create-models Can be
	// changed but only to a compatible model (e.g. others-you-may-like CTR to
	// others-you-may-like CVR). Required when solution_types is
	// SOLUTION_TYPE_RECOMMENDATION.
	ModelId string `json:"modelId,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/catalogs/*/servingConfig/*`
	Name string `json:"name,omitempty"`
	// OnewaySynonymsControlIds: Condition oneway synonyms specifications. If
	// multiple oneway synonyms conditions match, all matching oneway synonyms
	// controls in the list will execute. Order of controls in the list will not
	// matter. Maximum number of specifications is 100. Can only be set if
	// solution_types is SOLUTION_TYPE_SEARCH.
	OnewaySynonymsControlIds []string `json:"onewaySynonymsControlIds,omitempty"`
	// PersonalizationSpec: The specification for personalization spec. Can only be
	// set if solution_types is SOLUTION_TYPE_SEARCH. Notice that if both
	// ServingConfig.personalization_spec and SearchRequest.personalization_spec
	// are set. SearchRequest.personalization_spec will override
	// ServingConfig.personalization_spec.
	PersonalizationSpec *GoogleCloudRetailV2alphaSearchRequestPersonalizationSpec `json:"personalizationSpec,omitempty"`
	// PriceRerankingLevel: How much price ranking we want in serving results.
	// Price reranking causes product items with a similar recommendation
	// probability to be ordered by price, with the highest-priced items first.
	// This setting could result in a decrease in click-through and conversion
	// rates. Allowed values are: * `no-price-reranking` * `low-price-reranking` *
	// `medium-price-reranking` * `high-price-reranking` If not specified, we
	// choose default based on model type. Default value: `no-price-reranking`. Can
	// only be set if solution_types is SOLUTION_TYPE_RECOMMENDATION.
	PriceRerankingLevel string `json:"priceRerankingLevel,omitempty"`
	// RedirectControlIds: Condition redirect specifications. Only the first
	// triggered redirect action is applied, even if multiple apply. Maximum number
	// of specifications is 1000. Can only be set if solution_types is
	// SOLUTION_TYPE_SEARCH.
	RedirectControlIds []string `json:"redirectControlIds,omitempty"`
	// ReplacementControlIds: Condition replacement specifications. - Applied
	// according to the order in the list. - A previously replaced term can not be
	// re-replaced. - Maximum number of specifications is 100. Can only be set if
	// solution_types is SOLUTION_TYPE_SEARCH.
	ReplacementControlIds []string `json:"replacementControlIds,omitempty"`
	// SolutionTypes: Required. Immutable. Specifies the solution types that a
	// serving config can be associated with. Currently we support setting only one
	// type of solution.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Retail Search.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// TwowaySynonymsControlIds: Condition synonyms specifications. If multiple
	// syonyms conditions match, all matching synonyms control in the list will
	// execute. Order of controls in the list will not matter. Maximum number of
	// specifications is 100. Can only be set if solution_types is
	// SOLUTION_TYPE_SEARCH.
	TwowaySynonymsControlIds []string `json:"twowaySynonymsControlIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BoostControlIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostControlIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaServingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaServingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSetDefaultBranchRequest: Request message to set a
// specified branch as new default_branch.
type GoogleCloudRetailV2alphaSetDefaultBranchRequest struct {
	// BranchId: The final component of the resource name of a branch. This field
	// must be one of "0", "1" or "2". Otherwise, an INVALID_ARGUMENT error is
	// returned. If there are no sufficient active products in the targeted branch
	// and force is not set, a FAILED_PRECONDITION error is returned.
	BranchId string `json:"branchId,omitempty"`
	// Force: If set to true, it permits switching to a branch with branch_id even
	// if it has no sufficient active products.
	Force bool `json:"force,omitempty"`
	// Note: Some note on this request, this can be retrieved by
	// CatalogService.GetDefaultBranch before next valid default branch set occurs.
	// This field must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	Note string `json:"note,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BranchId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BranchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSetDefaultBranchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSetDefaultBranchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSetInventoryMetadata: Metadata related to the
// progress of the SetInventory operation. Currently empty because there is no
// meaningful metadata populated from the ProductService.SetInventory method.
type GoogleCloudRetailV2alphaSetInventoryMetadata struct {
}

// GoogleCloudRetailV2alphaSetInventoryRequest: Request message for
// ProductService.SetInventory method.
type GoogleCloudRetailV2alphaSetInventoryRequest struct {
	// AllowMissing: If set to true, and the Product with name Product.name is not
	// found, the inventory update will still be processed and retained for at most
	// 1 day until the Product is created. If set to false, a NOT_FOUND error is
	// returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`
	// Inventory: Required. The inventory information to update. The allowable
	// fields to update are: * Product.price_info * Product.availability *
	// Product.available_quantity * Product.fulfillment_info The updated inventory
	// fields must be specified in SetInventoryRequest.set_mask. If
	// SetInventoryRequest.inventory.name is empty or invalid, an INVALID_ARGUMENT
	// error is returned. If the caller does not have permission to update the
	// Product named in Product.name, regardless of whether or not it exists, a
	// PERMISSION_DENIED error is returned. If the Product to update does not have
	// existing inventory information, the provided inventory information will be
	// inserted. If the Product to update has existing inventory information, the
	// provided inventory information will be merged while respecting the last
	// update time for each inventory field, using the provided or default value
	// for SetInventoryRequest.set_time. The caller can replace place IDs for a
	// subset of fulfillment types in the following ways: * Adds "fulfillment_info"
	// in SetInventoryRequest.set_mask * Specifies only the desired fulfillment
	// types and corresponding place IDs to update in
	// SetInventoryRequest.inventory.fulfillment_info The caller can clear all
	// place IDs from a subset of fulfillment types in the following ways: * Adds
	// "fulfillment_info" in SetInventoryRequest.set_mask * Specifies only the
	// desired fulfillment types to clear in
	// SetInventoryRequest.inventory.fulfillment_info * Checks that only the
	// desired fulfillment info types have empty
	// SetInventoryRequest.inventory.fulfillment_info.place_ids The last update
	// time is recorded for the following inventory fields: * Product.price_info *
	// Product.availability * Product.available_quantity * Product.fulfillment_info
	// If a full overwrite of inventory information while ignoring timestamps is
	// needed, ProductService.UpdateProduct should be invoked instead.
	Inventory *GoogleCloudRetailV2alphaProduct `json:"inventory,omitempty"`
	// SetMask: Indicates which inventory fields in the provided Product to update.
	// At least one field must be provided. If an unsupported or unknown field is
	// provided, an INVALID_ARGUMENT error is returned and the entire update will
	// be ignored.
	SetMask string `json:"setMask,omitempty"`
	// SetTime: The time when the request is issued, used to prevent out-of-order
	// updates on inventory fields with the last update time recorded. If not
	// provided, the internal system time will be used.
	SetTime string `json:"setTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMissing") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaSetInventoryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaSetInventoryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaSetInventoryResponse: Response of the
// SetInventoryRequest. Currently empty because there is no meaningful response
// populated from the ProductService.SetInventory method.
type GoogleCloudRetailV2alphaSetInventoryResponse struct {
}

// GoogleCloudRetailV2alphaTransformedUserEventsMetadata: Metadata related to
// transform user events operation.
type GoogleCloudRetailV2alphaTransformedUserEventsMetadata struct {
	// SourceEventsCount: Count of entries in the source user events BigQuery
	// table.
	SourceEventsCount int64 `json:"sourceEventsCount,omitempty,string"`
	// TransformedEventsCount: Count of entries in the transformed user events
	// BigQuery table, which could be different from the actually imported number
	// of user events.
	TransformedEventsCount int64 `json:"transformedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "SourceEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceEventsCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaTransformedUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaTransformedUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaTuneModelMetadata: Metadata associated with a tune
// operation.
type GoogleCloudRetailV2alphaTuneModelMetadata struct {
	// Model: The resource name of the model that this tune applies to. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}`
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaTuneModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaTuneModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaTuneModelRequest: Request to manually start a tuning
// process now (instead of waiting for the periodically scheduled tuning to
// happen).
type GoogleCloudRetailV2alphaTuneModelRequest struct {
}

// GoogleCloudRetailV2alphaTuneModelResponse: Response associated with a tune
// operation.
type GoogleCloudRetailV2alphaTuneModelResponse struct {
}

// GoogleCloudRetailV2alphaUserEvent: UserEvent captures all metadata
// information Retail API needs to know about how end users interact with
// customers' website.
type GoogleCloudRetailV2alphaUserEvent struct {
	// Attributes: Extra user event features to include in the recommendation
	// model. If you provide custom attributes for ingested user events, also
	// include them in the user events that you associate with prediction requests.
	// Custom attribute formatting must be consistent between imported events and
	// events provided with prediction requests. This lets the Retail API use those
	// custom attributes when training models and serving predictions, which helps
	// improve recommendation quality. This field needs to pass all below criteria,
	// otherwise an INVALID_ARGUMENT error is returned: * The key must be a UTF-8
	// encoded string with a length limit of 5,000 characters. * For text
	// attributes, at most 400 values are allowed. Empty values are not allowed.
	// Each value must be a UTF-8 encoded string with a length limit of 256
	// characters. * For number attributes, at most 400 values are allowed. For
	// product recommendations, an example of extra user information is
	// traffic_channel, which is how a user arrives at the site. Users can arrive
	// at the site by coming to the site directly, coming through Google search, or
	// in other ways.
	Attributes map[string]GoogleCloudRetailV2alphaCustomAttribute `json:"attributes,omitempty"`
	// AttributionToken: Highly recommended for user events that are the result of
	// PredictionService.Predict. This field enables accurate attribution of
	// recommendation model performance. The value must be a valid
	// PredictResponse.attribution_token for user events that are the result of
	// PredictionService.Predict. The value must be a valid
	// SearchResponse.attribution_token for user events that are the result of
	// SearchService.Search. This token enables us to accurately attribute page
	// view or purchase back to the event and the particular predict response
	// containing this clicked/purchased product. If user clicks on product K in
	// the recommendation results, pass PredictResponse.attribution_token as a URL
	// parameter to product K's page. When recording events on product K's page,
	// log the PredictResponse.attribution_token to this field.
	AttributionToken string `json:"attributionToken,omitempty"`
	// CartId: The ID or name of the associated shopping cart. This ID is used to
	// associate multiple items added or present in the cart before purchase. This
	// can only be set for `add-to-cart`, `purchase-complete`, or
	// `shopping-cart-page-view` events.
	CartId string `json:"cartId,omitempty"`
	// CompletionDetail: The main auto-completion details related to the event.
	// This field should be set for `search` event when autocomplete function is
	// enabled and the user clicks a suggestion for search.
	CompletionDetail *GoogleCloudRetailV2alphaCompletionDetail `json:"completionDetail,omitempty"`
	// Entity: The entity for customers that may run multiple different entities,
	// domains, sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
	// `google.com`, `youtube.com`, etc. We recommend that you set this field to
	// get better per-entity search, completion, and prediction results.
	Entity string `json:"entity,omitempty"`
	// EventTime: Only required for UserEventService.ImportUserEvents method.
	// Timestamp of when the user event happened.
	EventTime string `json:"eventTime,omitempty"`
	// EventType: Required. User event type. Allowed values are: * `add-to-cart`:
	// Products being added to cart. * `remove-from-cart`: Products being removed
	// from cart. * `category-page-view`: Special pages such as sale or promotion
	// pages viewed. * `detail-page-view`: Products detail page viewed. *
	// `home-page-view`: Homepage viewed. * `promotion-offered`: Promotion is
	// offered to a user. * `promotion-not-offered`: Promotion is not offered to a
	// user. * `purchase-complete`: User finishing a purchase. * `search`: Product
	// search. * `shopping-cart-page-view`: User viewing a shopping cart.
	EventType string `json:"eventType,omitempty"`
	// ExperimentIds: A list of identifiers for the independent experiment groups
	// this user event belongs to. This is used to distinguish between user events
	// associated with different experiment setups (e.g. using Retail API, using
	// different recommendation models).
	ExperimentIds []string `json:"experimentIds,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the products being
	// filtered. See SearchRequest.filter for definition and syntax. The value must
	// be a UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Filter string `json:"filter,omitempty"`
	// Offset: An integer that specifies the current offset for pagination (the
	// 0-indexed starting location, amongst the products deemed by the API as
	// relevant). See SearchRequest.offset for definition. If this field is
	// negative, an INVALID_ARGUMENT is returned. This can only be set for `search`
	// events. Other event types should not set this field. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The order in which products are returned. See
	// SearchRequest.order_by for definition and syntax. The value must be a UTF-8
	// encoded string with a length limit of 1,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. This can only be set for `search`
	// events. Other event types should not set this field. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// PageCategories: The categories associated with a category page. To represent
	// full path of category, use '>' sign to separate different hierarchies. If
	// '>' is part of the category name, replace it with other character(s).
	// Category pages include special pages such as sales or promotions. For
	// instance, a special sale page may have the category hierarchy:
	// "pageCategories" : ["Sales > 2017 Black Friday Deals"]. Required for
	// `category-page-view` events. At least one of search_query or page_categories
	// is required for `search` events. Other event types should not set this
	// field. Otherwise, an INVALID_ARGUMENT error is returned.
	PageCategories []string `json:"pageCategories,omitempty"`
	// PageViewId: A unique ID of a web page view. This should be kept the same for
	// all user events triggered from the same pageview. For example, an item
	// detail page view could trigger multiple events as the user is browsing the
	// page. The `pageViewId` property should be kept the same for all these events
	// so that they can be grouped together properly. When using the client side
	// event reporting with JavaScript pixel and Google Tag Manager, this value is
	// filled in automatically.
	PageViewId string `json:"pageViewId,omitempty"`
	// ProductDetails: The main product details related to the event. This field is
	// optional except for the following event types: * `add-to-cart` *
	// `detail-page-view` * `purchase-complete` In a `search` event, this field
	// represents the products returned to the end user on the current page (the
	// end user may have not finished browsing the whole page yet). When a new page
	// is returned to the end user, after pagination/filtering/ordering even for
	// the same query, a new `search` event with different product_details is
	// desired. The end user may have not finished browsing the whole page yet.
	ProductDetails []*GoogleCloudRetailV2alphaProductDetail `json:"productDetails,omitempty"`
	// PurchaseTransaction: A transaction represents the entire purchase
	// transaction. Required for `purchase-complete` events. Other event types
	// should not set this field. Otherwise, an INVALID_ARGUMENT error is returned.
	PurchaseTransaction *GoogleCloudRetailV2alphaPurchaseTransaction `json:"purchaseTransaction,omitempty"`
	// ReferrerUri: The referrer URL of the current page. When using the client
	// side event reporting with JavaScript pixel and Google Tag Manager, this
	// value is filled in automatically.
	ReferrerUri string `json:"referrerUri,omitempty"`
	// SearchQuery: The user's search query. See SearchRequest.query for
	// definition. The value must be a UTF-8 encoded string with a length limit of
	// 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned. At least
	// one of search_query or page_categories is required for `search` events.
	// Other event types should not set this field. Otherwise, an INVALID_ARGUMENT
	// error is returned.
	SearchQuery string `json:"searchQuery,omitempty"`
	// SessionId: A unique identifier for tracking a visitor session with a length
	// limit of 128 bytes. A session is an aggregation of an end user behavior in a
	// time span. A general guideline to populate the sesion_id: 1. If user has no
	// activity for 30 min, a new session_id should be assigned. 2. The session_id
	// should be unique across users, suggest use uuid or add visitor_id as prefix.
	SessionId string `json:"sessionId,omitempty"`
	// Uri: Complete URL (window.location.href) of the user's current page. When
	// using the client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically. Maximum length 5,000
	// characters.
	Uri string `json:"uri,omitempty"`
	// UserInfo: User information.
	UserInfo *GoogleCloudRetailV2alphaUserInfo `json:"userInfo,omitempty"`
	// VisitorId: Required. A unique identifier for tracking visitors. For example,
	// this could be implemented with an HTTP cookie, which should be able to
	// uniquely identify a visitor on a single device. This unique identifier
	// should not change if the visitor log in/out of the website. Don't set the
	// field to the same fixed ID for different users. This mixes the event history
	// of those users together, which results in degraded model quality. The field
	// must be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned. The field should not
	// contain PII or user-data. We recommend to use Google Analytics Client ID
	// (https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
	// for this field.
	VisitorId string `json:"visitorId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaUserEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserEventImportSummary: A summary of import result.
// The UserEventImportSummary summarizes the import status for user events.
type GoogleCloudRetailV2alphaUserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete existing
	// catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JoinedEventsCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaUserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEventImportSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserEventInlineSource: The inline source for the
// input config for ImportUserEvents method.
type GoogleCloudRetailV2alphaUserEventInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended max of
	// 10k items.
	UserEvents []*GoogleCloudRetailV2alphaUserEvent `json:"userEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserEvents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaUserEventInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEventInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserEventInputConfig: The input config source for
// user events.
type GoogleCloudRetailV2alphaUserEventInputConfig struct {
	// BigQuerySource: Required. BigQuery input source.
	BigQuerySource *GoogleCloudRetailV2alphaBigQuerySource `json:"bigQuerySource,omitempty"`
	// GcsSource: Required. Google Cloud Storage location for the input content.
	GcsSource *GoogleCloudRetailV2alphaGcsSource `json:"gcsSource,omitempty"`
	// UserEventInlineSource: Required. The Inline source for the input content for
	// UserEvents.
	UserEventInlineSource *GoogleCloudRetailV2alphaUserEventInlineSource `json:"userEventInlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaUserEventInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEventInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaUserInfo: Information of an end user.
type GoogleCloudRetailV2alphaUserInfo struct {
	// DirectUserRequest: True if the request is made directly from the end user,
	// in which case the ip_address and user_agent can be populated from the HTTP
	// request. This flag should be set only if the API request is made directly
	// from the end user such as a mobile app (and not if a gateway or a server is
	// processing and pushing the user events). This should not be set when using
	// the JavaScript tag in UserEventService.CollectUserEvent.
	DirectUserRequest bool `json:"directUserRequest,omitempty"`
	// IpAddress: The end user's IP address. This field is used to extract location
	// information for personalization. This field must be either an IPv4 address
	// (e.g. "104.133.9.80") or an IPv6 address (e.g.
	// "2001:0db8:85a3:0000:0000:8a2e:0370:7334"). Otherwise, an INVALID_ARGUMENT
	// error is returned. This should not be set when: * setting
	// SearchRequest.user_info. * using the JavaScript tag in
	// UserEventService.CollectUserEvent or if direct_user_request is set.
	IpAddress string `json:"ipAddress,omitempty"`
	// UserAgent: User agent as included in the HTTP header. Required for getting
	// SearchResponse.sponsored_results. The field must be a UTF-8 encoded string
	// with a length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. This should not be set when using the client side event
	// reporting with GTM or JavaScript tag in UserEventService.CollectUserEvent or
	// if direct_user_request is set.
	UserAgent string `json:"userAgent,omitempty"`
	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. Don't set for anonymous users. Always
	// use a hashed value for this ID. Don't set the field to the same fixed ID for
	// different users. This mixes the event history of those users together, which
	// results in degraded model quality. The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
	// is returned.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DirectUserRequest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DirectUserRequest") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2alphaUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaAddFulfillmentPlacesMetadata: Metadata related to the
// progress of the AddFulfillmentPlaces operation. Currently empty because
// there is no meaningful metadata populated from the
// ProductService.AddFulfillmentPlaces method.
type GoogleCloudRetailV2betaAddFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2betaAddFulfillmentPlacesResponse: Response of the
// AddFulfillmentPlacesRequest. Currently empty because there is no meaningful
// response populated from the ProductService.AddFulfillmentPlaces method.
type GoogleCloudRetailV2betaAddFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2betaAddLocalInventoriesMetadata: Metadata related to the
// progress of the AddLocalInventories operation. Currently empty because there
// is no meaningful metadata populated from the
// ProductService.AddLocalInventories method.
type GoogleCloudRetailV2betaAddLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2betaAddLocalInventoriesResponse: Response of the
// ProductService.AddLocalInventories API. Currently empty because there is no
// meaningful response populated from the ProductService.AddLocalInventories
// method.
type GoogleCloudRetailV2betaAddLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2betaBigQueryOutputResult: A BigQuery output result.
type GoogleCloudRetailV2betaBigQueryOutputResult struct {
	// DatasetId: The ID of a BigQuery Dataset.
	DatasetId string `json:"datasetId,omitempty"`
	// TableId: The ID of a BigQuery Table.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaBigQueryOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaBigQueryOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaCreateModelMetadata: Metadata associated with a
// create operation.
type GoogleCloudRetailV2betaCreateModelMetadata struct {
	// Model: The resource name of the model that this create applies to. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}`
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaCreateModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaCreateModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportAnalyticsMetricsResponse: Response of the
// ExportAnalyticsMetricsRequest. If the long running operation was successful,
// then this message is returned by the google.longrunning.Operations.response
// field if the operation was successful.
type GoogleCloudRetailV2betaExportAnalyticsMetricsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: This field is never set.
	ErrorsConfig *GoogleCloudRetailV2betaExportErrorsConfig `json:"errorsConfig,omitempty"`
	// OutputResult: Output result indicating where the data were exported to.
	OutputResult *GoogleCloudRetailV2betaOutputResult `json:"outputResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaExportAnalyticsMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportAnalyticsMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportErrorsConfig: Configuration of destination for
// Export related errors.
type GoogleCloudRetailV2betaExportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be an
	// empty, existing Cloud Storage bucket. Export errors will be written to a
	// file in this bucket, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaExportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportErrorsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportMetadata: Metadata related to the progress of
// the Export operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaExportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaExportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportProductsResponse: Response of the
// ExportProductsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudRetailV2betaExportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: This field is never set.
	ErrorsConfig *GoogleCloudRetailV2betaExportErrorsConfig `json:"errorsConfig,omitempty"`
	// OutputResult: Output result indicating where the data were exported to.
	OutputResult *GoogleCloudRetailV2betaOutputResult `json:"outputResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaExportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportUserEventsResponse: Response of the
// ExportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudRetailV2betaExportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: This field is never set.
	ErrorsConfig *GoogleCloudRetailV2betaExportErrorsConfig `json:"errorsConfig,omitempty"`
	// OutputResult: Output result indicating where the data were exported to.
	OutputResult *GoogleCloudRetailV2betaOutputResult `json:"outputResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaExportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaGcsOutputResult: A Gcs output result.
type GoogleCloudRetailV2betaGcsOutputResult struct {
	// OutputUri: The uri of Gcs output
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaGcsOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaGcsOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportCompletionDataResponse: Response of the
// ImportCompletionDataRequest. If the long running operation is done, this
// message is returned by the google.longrunning.Operations.response field if
// the operation is successful.
type GoogleCloudRetailV2betaImportCompletionDataResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaImportCompletionDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportCompletionDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportErrorsConfig: Configuration of destination for
// Import related errors.
type GoogleCloudRetailV2betaImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportErrorsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportMetadata: Metadata related to the progress of
// the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If this
	// field is set, when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a Operation.
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`
	// RequestId: Deprecated. This field is never set.
	RequestId string `json:"requestId,omitempty"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudRetailV2betaImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorsConfig *GoogleCloudRetailV2betaImportErrorsConfig `json:"errorsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudRetailV2betaImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ErrorsConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorsConfig *GoogleCloudRetailV2betaImportErrorsConfig `json:"errorsConfig,omitempty"`
	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2betaUserEventImportSummary `json:"importSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaModel: Metadata that describes the training and
// serving parameters of a Model. A Model can be associated with a
// ServingConfig and then queried through the Predict API.
type GoogleCloudRetailV2betaModel struct {
	// CreateTime: Output only. Timestamp the Recommendation Model was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataState: Output only. The state of data requirements for this model:
	// `DATA_OK` and `DATA_ERROR`. Recommendation model cannot be trained if the
	// data is in `DATA_ERROR` state. Recommendation model can have `DATA_ERROR`
	// state even if serving state is `ACTIVE`: models were trained successfully
	// before, but cannot be refreshed because model no longer has sufficient data
	// for training.
	//
	// Possible values:
	//   "DATA_STATE_UNSPECIFIED" - Unspecified default value, should never be
	// explicitly set.
	//   "DATA_OK" - The model has sufficient training data.
	//   "DATA_ERROR" - The model does not have sufficient training data. Error
	// messages can be queried via Stackdriver.
	DataState string `json:"dataState,omitempty"`
	// DisplayName: Required. The display name of the model. Should be human
	// readable, used to display Recommendation Models in the Retail Cloud Console
	// Dashboard. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// FilteringOption: Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`,
	// recommendation filtering by attributes is enabled for the model.
	//
	// Possible values:
	//   "RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED" - Value used when unset. In
	// this case, server behavior defaults to RECOMMENDATIONS_FILTERING_DISABLED.
	//   "RECOMMENDATIONS_FILTERING_DISABLED" - Recommendation filtering is
	// disabled.
	//   "RECOMMENDATIONS_FILTERING_ENABLED" - Recommendation filtering is enabled.
	FilteringOption string `json:"filteringOption,omitempty"`
	// LastTuneTime: Output only. The timestamp when the latest successful tune
	// finished.
	LastTuneTime string `json:"lastTuneTime,omitempty"`
	// ModelFeaturesConfig: Optional. Additional model features config.
	ModelFeaturesConfig *GoogleCloudRetailV2betaModelModelFeaturesConfig `json:"modelFeaturesConfig,omitempty"`
	// Name: Required. The fully qualified resource name of the model. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}` catalog_id has char limit of 50. recommendation_model_id has
	// char limit of 40.
	Name string `json:"name,omitempty"`
	// OptimizationObjective: Optional. The optimization objective e.g. `cvr`.
	// Currently supported values: `ctr`, `cvr`, `revenue-per-order`. If not
	// specified, we choose default based on model type. Default depends on type of
	// recommendation: `recommended-for-you` => `ctr` `others-you-may-like` =>
	// `ctr` `frequently-bought-together` => `revenue_per_order` This field
	// together with optimization_objective describe model metadata to use to
	// control model training and serving. See
	// https://cloud.google.com/retail/docs/models for more details on what the
	// model metadata control and which combination of parameters are valid. For
	// invalid combinations of parameters (e.g. type = `frequently-bought-together`
	// and optimization_objective = `ctr`), you receive an error 400 if you try to
	// create/update a recommendation with this set of knobs.
	OptimizationObjective string `json:"optimizationObjective,omitempty"`
	// PeriodicTuningState: Optional. The state of periodic tuning. The period we
	// use is 3 months - to do a one-off tune earlier use the `TuneModel` method.
	// Default value is `PERIODIC_TUNING_ENABLED`.
	//
	// Possible values:
	//   "PERIODIC_TUNING_STATE_UNSPECIFIED" - Unspecified default value, should
	// never be explicitly set.
	//   "PERIODIC_TUNING_DISABLED" - The model has periodic tuning disabled.
	// Tuning can be reenabled by calling the `EnableModelPeriodicTuning` method or
	// by calling the `TuneModel` method.
	//   "ALL_TUNING_DISABLED" - The model cannot be tuned with periodic tuning OR
	// the `TuneModel` method. Hide the options in customer UI and reject any
	// requests through the backend self serve API.
	//   "PERIODIC_TUNING_ENABLED" - The model has periodic tuning enabled. Tuning
	// can be disabled by calling the `DisableModelPeriodicTuning` method.
	PeriodicTuningState string `json:"periodicTuningState,omitempty"`
	// ServingConfigLists: Output only. The list of valid serving configs
	// associated with the PageOptimizationConfig.
	ServingConfigLists []*GoogleCloudRetailV2betaModelServingConfigList `json:"servingConfigLists,omitempty"`
	// ServingState: Output only. The serving state of the model: `ACTIVE`,
	// `NOT_ACTIVE`.
	//
	// Possible values:
	//   "SERVING_STATE_UNSPECIFIED" - Unspecified serving state.
	//   "INACTIVE" - The model is not serving.
	//   "ACTIVE" - The model is serving and can be queried.
	//   "TUNED" - The model is trained on tuned hyperparameters and can be
	// queried.
	ServingState string `json:"servingState,omitempty"`
	// TrainingState: Optional. The training state that the model is in (e.g.
	// `TRAINING` or `PAUSED`). Since part of the cost of running the service is
	// frequency of training - this can be used to determine when to train model in
	// order to control cost. If not specified: the default value for `CreateModel`
	// method is `TRAINING`. The default value for `UpdateModel` method is to keep
	// the state the same as before.
	//
	// Possible values:
	//   "TRAINING_STATE_UNSPECIFIED" - Unspecified training state.
	//   "PAUSED" - The model training is paused.
	//   "TRAINING" - The model is training.
	TrainingState string `json:"trainingState,omitempty"`
	// TuningOperation: Output only. The tune operation associated with the model.
	// Can be used to determine if there is an ongoing tune for this
	// recommendation. Empty field implies no tune is goig on.
	TuningOperation string `json:"tuningOperation,omitempty"`
	// Type: Required. The type of model e.g. `home-page`. Currently supported
	// values: `recommended-for-you`, `others-you-may-like`,
	// `frequently-bought-together`, `page-optimization`, `similar-items`,
	// `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value). This
	// field together with optimization_objective describe model metadata to use to
	// control model training and serving. See
	// https://cloud.google.com/retail/docs/models for more details on what the
	// model metadata control and which combination of parameters are valid. For
	// invalid combinations of parameters (e.g. type = `frequently-bought-together`
	// and optimization_objective = `ctr`), you receive an error 400 if you try to
	// create/update a recommendation with this set of knobs.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Model was last
	// updated. E.g. if a Recommendation Model was paused - this would be the time
	// the pause was initiated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaModelFrequentlyBoughtTogetherFeaturesConfig:
// Additional configs for the frequently-bought-together model type.
type GoogleCloudRetailV2betaModelFrequentlyBoughtTogetherFeaturesConfig struct {
	// ContextProductsType: Optional. Specifies the context of the model when it is
	// used in predict requests. Can only be set for the
	// `frequently-bought-together` type. If it isn't specified, it defaults to
	// MULTIPLE_CONTEXT_PRODUCTS.
	//
	// Possible values:
	//   "CONTEXT_PRODUCTS_TYPE_UNSPECIFIED" - Unspecified default value, should
	// never be explicitly set. Defaults to MULTIPLE_CONTEXT_PRODUCTS.
	//   "SINGLE_CONTEXT_PRODUCT" - Use only a single product as context for the
	// recommendation. Typically used on pages like add-to-cart or product details.
	//   "MULTIPLE_CONTEXT_PRODUCTS" - Use one or multiple products as context for
	// the recommendation. Typically used on shopping cart pages.
	ContextProductsType string `json:"contextProductsType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextProductsType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextProductsType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaModelFrequentlyBoughtTogetherFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaModelFrequentlyBoughtTogetherFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaModelModelFeaturesConfig: Additional model features
// config.
type GoogleCloudRetailV2betaModelModelFeaturesConfig struct {
	// FrequentlyBoughtTogetherConfig: Additional configs for
	// frequently-bought-together models.
	FrequentlyBoughtTogetherConfig *GoogleCloudRetailV2betaModelFrequentlyBoughtTogetherFeaturesConfig `json:"frequentlyBoughtTogetherConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "FrequentlyBoughtTogetherConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FrequentlyBoughtTogetherConfig")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaModelModelFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaModelModelFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaModelServingConfigList: Represents an ordered
// combination of valid serving configs, which can be used for
// `PAGE_OPTIMIZATION` recommendations.
type GoogleCloudRetailV2betaModelServingConfigList struct {
	// ServingConfigIds: Optional. A set of valid serving configs that may be used
	// for `PAGE_OPTIMIZATION`.
	ServingConfigIds []string `json:"servingConfigIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServingConfigIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServingConfigIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaModelServingConfigList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaModelServingConfigList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaOutputResult: Output result that stores the
// information about where the exported data is stored.
type GoogleCloudRetailV2betaOutputResult struct {
	// BigqueryResult: The BigQuery location where the result is stored.
	BigqueryResult []*GoogleCloudRetailV2betaBigQueryOutputResult `json:"bigqueryResult,omitempty"`
	// GcsResult: The Google Cloud Storage location where the result is stored.
	GcsResult []*GoogleCloudRetailV2betaGcsOutputResult `json:"gcsResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaOutputResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaOutputResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaPurgeMetadata: Metadata related to the progress of
// the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaPurgeMetadata struct {
}

// GoogleCloudRetailV2betaPurgeProductsMetadata: Metadata related to the
// progress of the PurgeProducts operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaPurgeProductsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaPurgeProductsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaPurgeProductsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaPurgeProductsResponse: Response of the
// PurgeProductsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudRetailV2betaPurgeProductsResponse struct {
	// PurgeCount: The total count of products purged as a result of the operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of the product names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be returned
	// and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaPurgeProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaPurgeProductsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudRetailV2betaPurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of the
	// operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgedEventsCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaPurgeUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaRejoinUserEventsMetadata: Metadata for
// `RejoinUserEvents` method.
type GoogleCloudRetailV2betaRejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2betaRejoinUserEventsResponse: Response message for
// `RejoinUserEvents` method.
type GoogleCloudRetailV2betaRejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with latest
	// product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "RejoinedUserEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaRejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaRejoinUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaRemoveFulfillmentPlacesMetadata: Metadata related to
// the progress of the RemoveFulfillmentPlaces operation. Currently empty
// because there is no meaningful metadata populated from the
// ProductService.RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2betaRemoveFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2betaRemoveFulfillmentPlacesResponse: Response of the
// RemoveFulfillmentPlacesRequest. Currently empty because there is no
// meaningful response populated from the
// ProductService.RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2betaRemoveFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2betaRemoveLocalInventoriesMetadata: Metadata related to
// the progress of the RemoveLocalInventories operation. Currently empty
// because there is no meaningful metadata populated from the
// ProductService.RemoveLocalInventories method.
type GoogleCloudRetailV2betaRemoveLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2betaRemoveLocalInventoriesResponse: Response of the
// ProductService.RemoveLocalInventories API. Currently empty because there is
// no meaningful response populated from the
// ProductService.RemoveLocalInventories method.
type GoogleCloudRetailV2betaRemoveLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2betaSetInventoryMetadata: Metadata related to the
// progress of the SetInventory operation. Currently empty because there is no
// meaningful metadata populated from the ProductService.SetInventory method.
type GoogleCloudRetailV2betaSetInventoryMetadata struct {
}

// GoogleCloudRetailV2betaSetInventoryResponse: Response of the
// SetInventoryRequest. Currently empty because there is no meaningful response
// populated from the ProductService.SetInventory method.
type GoogleCloudRetailV2betaSetInventoryResponse struct {
}

// GoogleCloudRetailV2betaTuneModelMetadata: Metadata associated with a tune
// operation.
type GoogleCloudRetailV2betaTuneModelMetadata struct {
	// Model: The resource name of the model that this tune applies to. Format:
	// `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mode
	// ls/{model_id}`
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaTuneModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaTuneModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaTuneModelResponse: Response associated with a tune
// operation.
type GoogleCloudRetailV2betaTuneModelResponse struct {
}

// GoogleCloudRetailV2betaUserEventImportSummary: A summary of import result.
// The UserEventImportSummary summarizes the import status for user events.
type GoogleCloudRetailV2betaUserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete existing
	// catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JoinedEventsCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRetailV2betaUserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaUserEventImportSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsEnrollSolutionCall struct {
	s                                             *Service
	project                                       string
	googlecloudretailv2alphaenrollsolutionrequest *GoogleCloudRetailV2alphaEnrollSolutionRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// EnrollSolution: The method enrolls a solution of type Retail Search into a
// project. The Recommendations AI solution type is enrolled by default when
// your project enables Retail API, so you don't need to call the
// enrollSolution method for recommendations.
//
//   - project: Full resource name of parent. Format:
//     `projects/{project_number_or_id}`.
func (r *ProjectsService) EnrollSolution(project string, googlecloudretailv2alphaenrollsolutionrequest *GoogleCloudRetailV2alphaEnrollSolutionRequest) *ProjectsEnrollSolutionCall {
	c := &ProjectsEnrollSolutionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.googlecloudretailv2alphaenrollsolutionrequest = googlecloudretailv2alphaenrollsolutionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEnrollSolutionCall) Fields(s ...googleapi.Field) *ProjectsEnrollSolutionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEnrollSolutionCall) Context(ctx context.Context) *ProjectsEnrollSolutionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEnrollSolutionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEnrollSolutionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaenrollsolutionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+project}:enrollSolution")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.enrollSolution" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsEnrollSolutionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsGetAlertConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAlertConfig: Get the AlertConfig of the requested project.
//
//   - name: Full AlertConfig resource name. Format:
//     projects/{project_number}/alertConfig.
func (r *ProjectsService) GetAlertConfig(name string) *ProjectsGetAlertConfigCall {
	c := &ProjectsGetAlertConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetAlertConfigCall) Fields(s ...googleapi.Field) *ProjectsGetAlertConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetAlertConfigCall) IfNoneMatch(entityTag string) *ProjectsGetAlertConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetAlertConfigCall) Context(ctx context.Context) *ProjectsGetAlertConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetAlertConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetAlertConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.getAlertConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaAlertConfig.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGetAlertConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaAlertConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaAlertConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsGetLoggingConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetLoggingConfig: Gets the LoggingConfig of the requested project.
//
//   - name: Full LoggingConfig resource name. Format:
//     projects/{project_number}/loggingConfig.
func (r *ProjectsService) GetLoggingConfig(name string) *ProjectsGetLoggingConfigCall {
	c := &ProjectsGetLoggingConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetLoggingConfigCall) Fields(s ...googleapi.Field) *ProjectsGetLoggingConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetLoggingConfigCall) IfNoneMatch(entityTag string) *ProjectsGetLoggingConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetLoggingConfigCall) Context(ctx context.Context) *ProjectsGetLoggingConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetLoggingConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetLoggingConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.getLoggingConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaLoggingConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGetLoggingConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaLoggingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaLoggingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsGetRetailProjectCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetRetailProject: Gets the project. Throws `NOT_FOUND` if the project wasn't
// initialized for the Retail API service.
//
//   - name: Full resource name of the project. Format:
//     `projects/{project_number_or_id}/retailProject`.
func (r *ProjectsService) GetRetailProject(name string) *ProjectsGetRetailProjectCall {
	c := &ProjectsGetRetailProjectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetRetailProjectCall) Fields(s ...googleapi.Field) *ProjectsGetRetailProjectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetRetailProjectCall) IfNoneMatch(entityTag string) *ProjectsGetRetailProjectCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetRetailProjectCall) Context(ctx context.Context) *ProjectsGetRetailProjectCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetRetailProjectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetRetailProjectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.getRetailProject" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaProject.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGetRetailProjectCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaProject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsListEnrolledSolutionsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListEnrolledSolutions: Lists all the retail API solutions the project has
// enrolled.
//
//   - parent: Full resource name of parent. Format:
//     `projects/{project_number_or_id}`.
func (r *ProjectsService) ListEnrolledSolutions(parent string) *ProjectsListEnrolledSolutionsCall {
	c := &ProjectsListEnrolledSolutionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsListEnrolledSolutionsCall) Fields(s ...googleapi.Field) *ProjectsListEnrolledSolutionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsListEnrolledSolutionsCall) IfNoneMatch(entityTag string) *ProjectsListEnrolledSolutionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsListEnrolledSolutionsCall) Context(ctx context.Context) *ProjectsListEnrolledSolutionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsListEnrolledSolutionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsListEnrolledSolutionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}:enrolledSolutions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.listEnrolledSolutions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListEnrolledSolutionsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsListEnrolledSolutionsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListEnrolledSolutionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListEnrolledSolutionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsUpdateAlertConfigCall struct {
	s                                   *Service
	name                                string
	googlecloudretailv2alphaalertconfig *GoogleCloudRetailV2alphaAlertConfig
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// UpdateAlertConfig: Update the alert config of the requested project.
//
//   - name: Immutable. The name of the AlertConfig singleton resource. Format:
//     projects/*/alertConfig.
func (r *ProjectsService) UpdateAlertConfig(name string, googlecloudretailv2alphaalertconfig *GoogleCloudRetailV2alphaAlertConfig) *ProjectsUpdateAlertConfigCall {
	c := &ProjectsUpdateAlertConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphaalertconfig = googlecloudretailv2alphaalertconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided AlertConfig to update. If not set, all supported fields are
// updated.
func (c *ProjectsUpdateAlertConfigCall) UpdateMask(updateMask string) *ProjectsUpdateAlertConfigCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsUpdateAlertConfigCall) Fields(s ...googleapi.Field) *ProjectsUpdateAlertConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsUpdateAlertConfigCall) Context(ctx context.Context) *ProjectsUpdateAlertConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsUpdateAlertConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdateAlertConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaalertconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.updateAlertConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaAlertConfig.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsUpdateAlertConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaAlertConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaAlertConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsUpdateLoggingConfigCall struct {
	s                                     *Service
	name                                  string
	googlecloudretailv2alphaloggingconfig *GoogleCloudRetailV2alphaLoggingConfig
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// UpdateLoggingConfig: Updates the LoggingConfig of the requested project.
//
//   - name: Immutable. The name of the LoggingConfig singleton resource. Format:
//     projects/*/loggingConfig.
func (r *ProjectsService) UpdateLoggingConfig(name string, googlecloudretailv2alphaloggingconfig *GoogleCloudRetailV2alphaLoggingConfig) *ProjectsUpdateLoggingConfigCall {
	c := &ProjectsUpdateLoggingConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphaloggingconfig = googlecloudretailv2alphaloggingconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided LoggingConfig to update. The following are the only
// supported fields: * LoggingConfig.default_log_generation_rule *
// LoggingConfig.service_log_generation_rules If not set, all supported fields
// are updated.
func (c *ProjectsUpdateLoggingConfigCall) UpdateMask(updateMask string) *ProjectsUpdateLoggingConfigCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsUpdateLoggingConfigCall) Fields(s ...googleapi.Field) *ProjectsUpdateLoggingConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsUpdateLoggingConfigCall) Context(ctx context.Context) *ProjectsUpdateLoggingConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsUpdateLoggingConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdateLoggingConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaloggingconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.updateLoggingConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaLoggingConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsUpdateLoggingConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaLoggingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaLoggingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsCompleteQueryCall struct {
	s            *Service
	catalog      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CompleteQuery: Completes the specified prefix with keyword suggestions. This
// feature is only available for users who have Retail Search enabled. Enable
// Retail Search on Cloud Console before using this feature.
//
//   - catalog: Catalog for which the completion is performed. Full resource name
//     of catalog, such as
//     `projects/*/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsService) CompleteQuery(catalog string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c := &ProjectsLocationsCatalogsCompleteQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.catalog = catalog
	return c
}

// Dataset sets the optional parameter "dataset": Determines which dataset to
// use for fetching completion. "user-data" will use the imported dataset
// through CompletionService.ImportCompletionData. "cloud-retail" will use the
// dataset generated by cloud retail based on user events. If leave empty, it
// will use the "user-data". Current supported values: * user-data *
// cloud-retail: This option requires enabling auto-learning function first.
// See guidelines
// (https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Dataset(dataset string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("dataset", dataset)
	return c
}

// DeviceType sets the optional parameter "deviceType": The device type context
// for completion suggestions. We recommend that you leave this field empty. It
// can apply different suggestions on different device types, e.g. `DESKTOP`,
// `MOBILE`. If it is empty, the suggestions are across all device types.
// Supported formats: * `UNKNOWN_DEVICE_TYPE` * `DESKTOP` * `MOBILE` * A
// customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) DeviceType(deviceType string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("deviceType", deviceType)
	return c
}

// EnableAttributeSuggestions sets the optional parameter
// "enableAttributeSuggestions": If true, attribute suggestions are enabled and
// provided in the response. This field is only available for the
// "cloud-retail" dataset.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) EnableAttributeSuggestions(enableAttributeSuggestions bool) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("enableAttributeSuggestions", fmt.Sprint(enableAttributeSuggestions))
	return c
}

// Entity sets the optional parameter "entity": The entity for customers who
// run multiple entities, domains, sites, or regions, for example, `Google US`,
// `Google Ads`, `Waymo`, `google.com`, `youtube.com`, etc. If this is set, it
// must be an exact match with UserEvent.entity to get per-entity autocomplete
// results.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Entity(entity string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("entity", entity)
	return c
}

// LanguageCodes sets the optional parameter "languageCodes": Note that this
// field applies for `user-data` dataset only. For requests with `cloud-retail`
// dataset, setting this field has no effect. The language filters applied to
// the output suggestions. If set, it should contain the language of the query.
// If not set, suggestions are returned without considering language
// restrictions. This is the BCP-47 language code, such as "en-US" or
// "sr-Latn". For more information, see Tags for Identifying Languages
// (https://tools.ietf.org/html/bcp47). The maximum number of language codes is
// 3.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) LanguageCodes(languageCodes ...string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.SetMulti("languageCodes", append([]string{}, languageCodes...))
	return c
}

// MaxSuggestions sets the optional parameter "maxSuggestions": Completion max
// suggestions. If left unset or set to 0, then will fallback to the configured
// value CompletionConfig.max_suggestions. The maximum allowed max suggestions
// is 20. If it is set higher, it will be capped by 20.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) MaxSuggestions(maxSuggestions int64) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("maxSuggestions", fmt.Sprint(maxSuggestions))
	return c
}

// Query sets the optional parameter "query": Required. The query used to
// generate suggestions. The maximum number of allowed characters is 255.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Query(query string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("query", query)
	return c
}

// VisitorId sets the optional parameter "visitorId": Required field. A unique
// identifier for tracking visitors. For example, this could be implemented
// with an HTTP cookie, which should be able to uniquely identify a visitor on
// a single device. This unique identifier should not change if the visitor
// logs in or out of the website. The field must be a UTF-8 encoded string with
// a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is
// returned.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) VisitorId(visitorId string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("visitorId", visitorId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Context(ctx context.Context) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsCompleteQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+catalog}:completeQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"catalog": c.catalog,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.completeQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaCompleteQueryResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaCompleteQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaCompleteQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsExportAnalyticsMetricsCall struct {
	s                                                     *Service
	catalog                                               string
	googlecloudretailv2alphaexportanalyticsmetricsrequest *GoogleCloudRetailV2alphaExportAnalyticsMetricsRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// ExportAnalyticsMetrics: Exports analytics metrics. `Operation.response` is
// of type `ExportAnalyticsMetricsResponse`. `Operation.metadata` is of type
// `ExportMetadata`.
//
//   - catalog: Full resource name of the parent catalog. Expected format:
//     `projects/*/locations/*/catalogs/*`.
func (r *ProjectsLocationsCatalogsService) ExportAnalyticsMetrics(catalog string, googlecloudretailv2alphaexportanalyticsmetricsrequest *GoogleCloudRetailV2alphaExportAnalyticsMetricsRequest) *ProjectsLocationsCatalogsExportAnalyticsMetricsCall {
	c := &ProjectsLocationsCatalogsExportAnalyticsMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.catalog = catalog
	c.googlecloudretailv2alphaexportanalyticsmetricsrequest = googlecloudretailv2alphaexportanalyticsmetricsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsExportAnalyticsMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsExportAnalyticsMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsExportAnalyticsMetricsCall) Context(ctx context.Context) *ProjectsLocationsCatalogsExportAnalyticsMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsExportAnalyticsMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsExportAnalyticsMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaexportanalyticsmetricsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+catalog}:exportAnalyticsMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"catalog": c.catalog,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.exportAnalyticsMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsExportAnalyticsMetricsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsGetAttributesConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAttributesConfig: Gets an AttributesConfig.
//
//   - name: Full AttributesConfig resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/at
//     tributesConfig`.
func (r *ProjectsLocationsCatalogsService) GetAttributesConfig(name string) *ProjectsLocationsCatalogsGetAttributesConfigCall {
	c := &ProjectsLocationsCatalogsGetAttributesConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsGetAttributesConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsGetAttributesConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsGetAttributesConfigCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsGetAttributesConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsGetAttributesConfigCall) Context(ctx context.Context) *ProjectsLocationsCatalogsGetAttributesConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsGetAttributesConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsGetAttributesConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.getAttributesConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaAttributesConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsGetAttributesConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaAttributesConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaAttributesConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsGetCompletionConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetCompletionConfig: Gets a CompletionConfig.
//
//   - name: Full CompletionConfig resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/co
//     mpletionConfig`.
func (r *ProjectsLocationsCatalogsService) GetCompletionConfig(name string) *ProjectsLocationsCatalogsGetCompletionConfigCall {
	c := &ProjectsLocationsCatalogsGetCompletionConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsGetCompletionConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsGetCompletionConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsGetCompletionConfigCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsGetCompletionConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsGetCompletionConfigCall) Context(ctx context.Context) *ProjectsLocationsCatalogsGetCompletionConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsGetCompletionConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsGetCompletionConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.getCompletionConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaCompletionConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsGetCompletionConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaCompletionConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaCompletionConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsGetDefaultBranchCall struct {
	s            *Service
	catalog      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDefaultBranch: Get which branch is currently default branch set by
// CatalogService.SetDefaultBranch method under a specified parent catalog.
//
//   - catalog: The parent catalog resource name, such as
//     `projects/*/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsService) GetDefaultBranch(catalog string) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c := &ProjectsLocationsCatalogsGetDefaultBranchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.catalog = catalog
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+catalog}:getDefaultBranch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"catalog": c.catalog,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.getDefaultBranch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaGetDefaultBranchResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaGetDefaultBranchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaGetDefaultBranchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the Catalogs associated with the project.
//
//   - parent: The account resource name with an associated location. If the
//     caller does not have permission to list Catalogs under this location,
//     regardless of whether or not this location exists, a PERMISSION_DENIED
//     error is returned.
func (r *ProjectsLocationsCatalogsService) List(parent string) *ProjectsLocationsCatalogsListCall {
	c := &ProjectsLocationsCatalogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Catalogs
// to return. If unspecified, defaults to 50. The maximum allowed value is
// 1000. Values above 1000 will be coerced to 1000. If this field is negative,
// an INVALID_ARGUMENT is returned.
func (c *ProjectsLocationsCatalogsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListCatalogsResponse.next_page_token, received from a previous
// CatalogService.ListCatalogs call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to
// CatalogService.ListCatalogs must match the call that provided the page
// token. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/catalogs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListCatalogsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListCatalogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListCatalogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaListCatalogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCatalogsPatchCall struct {
	s                               *Service
	name                            string
	googlecloudretailv2alphacatalog *GoogleCloudRetailV2alphaCatalog
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Updates the Catalogs.
//
// - name: Immutable. The fully qualified resource name of the catalog.
func (r *ProjectsLocationsCatalogsService) Patch(name string, googlecloudretailv2alphacatalog *GoogleCloudRetailV2alphaCatalog) *ProjectsLocationsCatalogsPatchCall {
	c := &ProjectsLocationsCatalogsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphacatalog = googlecloudretailv2alphacatalog
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided Catalog to update. If an unsupported or unknown field is
// provided, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphacatalog)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaCatalog.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaCatalog, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaCatalog{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsSetDefaultBranchCall struct {
	s                                               *Service
	catalog                                         string
	googlecloudretailv2alphasetdefaultbranchrequest *GoogleCloudRetailV2alphaSetDefaultBranchRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// SetDefaultBranch: Set a specified branch id as default branch. API methods
// such as SearchService.Search, ProductService.GetProduct,
// ProductService.ListProducts will treat requests using "default_branch" to
// the actual branch id set as default. For example, if
// `projects/*/locations/*/catalogs/*/branches/1` is set as default, setting
// SearchRequest.branch to
// `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent to
// setting SearchRequest.branch to
// `projects/*/locations/*/catalogs/*/branches/1`. Using multiple branches can
// be useful when developers would like to have a staging branch to test and
// verify for future usage. When it becomes ready, developers switch on the
// staging branch using this API while keeping using
// `projects/*/locations/*/catalogs/*/branches/default_branch` as
// SearchRequest.branch to route the traffic to this staging branch. CAUTION:
// If you have live predict/search traffic, switching the default branch could
// potentially cause outages if the ID space of the new branch is very
// different from the old one. More specifically: * PredictionService will only
// return product IDs from branch {newBranch}. * SearchService will only return
// product IDs from branch {newBranch} (if branch is not explicitly set). *
// UserEventService will only join events with products from branch
// {newBranch}.
//
//   - catalog: Full resource name of the catalog, such as
//     `projects/*/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsService) SetDefaultBranch(catalog string, googlecloudretailv2alphasetdefaultbranchrequest *GoogleCloudRetailV2alphaSetDefaultBranchRequest) *ProjectsLocationsCatalogsSetDefaultBranchCall {
	c := &ProjectsLocationsCatalogsSetDefaultBranchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.catalog = catalog
	c.googlecloudretailv2alphasetdefaultbranchrequest = googlecloudretailv2alphasetdefaultbranchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsSetDefaultBranchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsSetDefaultBranchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphasetdefaultbranchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+catalog}:setDefaultBranch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"catalog": c.catalog,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.setDefaultBranch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsUpdateAttributesConfigCall struct {
	s                                        *Service
	name                                     string
	googlecloudretailv2alphaattributesconfig *GoogleCloudRetailV2alphaAttributesConfig
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// UpdateAttributesConfig: Updates the AttributesConfig. The catalog attributes
// in the request will be updated in the catalog, or inserted if they do not
// exist. Existing catalog attributes not included in the request will remain
// unchanged. Attributes that are assigned to products, but do not exist at the
// catalog level, are always included in the response. The product attribute is
// assigned default values for missing catalog attribute fields, e.g.,
// searchable and dynamic facetable options.
//
//   - name: Immutable. The fully qualified resource name of the attribute
//     config. Format: `projects/*/locations/*/catalogs/*/attributesConfig`.
func (r *ProjectsLocationsCatalogsService) UpdateAttributesConfig(name string, googlecloudretailv2alphaattributesconfig *GoogleCloudRetailV2alphaAttributesConfig) *ProjectsLocationsCatalogsUpdateAttributesConfigCall {
	c := &ProjectsLocationsCatalogsUpdateAttributesConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphaattributesconfig = googlecloudretailv2alphaattributesconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided AttributesConfig to update. The following is the only
// supported field: * AttributesConfig.catalog_attributes If not set, all
// supported fields are updated.
func (c *ProjectsLocationsCatalogsUpdateAttributesConfigCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsUpdateAttributesConfigCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUpdateAttributesConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUpdateAttributesConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUpdateAttributesConfigCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUpdateAttributesConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUpdateAttributesConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUpdateAttributesConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaattributesconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.updateAttributesConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaAttributesConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUpdateAttributesConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaAttributesConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaAttributesConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsUpdateCompletionConfigCall struct {
	s                                        *Service
	name                                     string
	googlecloudretailv2alphacompletionconfig *GoogleCloudRetailV2alphaCompletionConfig
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// UpdateCompletionConfig: Updates the CompletionConfigs.
//
//   - name: Immutable. Fully qualified name
//     `projects/*/locations/*/catalogs/*/completionConfig`.
func (r *ProjectsLocationsCatalogsService) UpdateCompletionConfig(name string, googlecloudretailv2alphacompletionconfig *GoogleCloudRetailV2alphaCompletionConfig) *ProjectsLocationsCatalogsUpdateCompletionConfigCall {
	c := &ProjectsLocationsCatalogsUpdateCompletionConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphacompletionconfig = googlecloudretailv2alphacompletionconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided CompletionConfig to update. The following are the only
// supported fields: * CompletionConfig.matching_order *
// CompletionConfig.max_suggestions * CompletionConfig.min_prefix_length *
// CompletionConfig.auto_learning If not set, all supported fields are updated.
func (c *ProjectsLocationsCatalogsUpdateCompletionConfigCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsUpdateCompletionConfigCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUpdateCompletionConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUpdateCompletionConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUpdateCompletionConfigCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUpdateCompletionConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUpdateCompletionConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUpdateCompletionConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphacompletionconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.updateCompletionConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaCompletionConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUpdateCompletionConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaCompletionConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaCompletionConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall struct {
	s                                                  *Service
	attributesConfig                                   string
	googlecloudretailv2alphaaddcatalogattributerequest *GoogleCloudRetailV2alphaAddCatalogAttributeRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// AddCatalogAttribute: Adds the specified CatalogAttribute to the
// AttributesConfig. If the CatalogAttribute to add already exists, an
// ALREADY_EXISTS error is returned.
//
//   - attributesConfig: Full AttributesConfig resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/at
//     tributesConfig`.
func (r *ProjectsLocationsCatalogsAttributesConfigService) AddCatalogAttribute(attributesConfig string, googlecloudretailv2alphaaddcatalogattributerequest *GoogleCloudRetailV2alphaAddCatalogAttributeRequest) *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall {
	c := &ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.attributesConfig = attributesConfig
	c.googlecloudretailv2alphaaddcatalogattributerequest = googlecloudretailv2alphaaddcatalogattributerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaaddcatalogattributerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+attributesConfig}:addCatalogAttribute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"attributesConfig": c.attributesConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.attributesConfig.addCatalogAttribute" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaAttributesConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsAttributesConfigAddCatalogAttributeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaAttributesConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaAttributesConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall struct {
	s                                                           *Service
	attributesConfig                                            string
	googlecloudretailv2alphabatchremovecatalogattributesrequest *GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchRemoveCatalogAttributes: Removes all specified CatalogAttributes from
// the AttributesConfig.
//
//   - attributesConfig: The attributes config resource shared by all catalog
//     attributes being deleted. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/at
//     tributesConfig`.
func (r *ProjectsLocationsCatalogsAttributesConfigService) BatchRemoveCatalogAttributes(attributesConfig string, googlecloudretailv2alphabatchremovecatalogattributesrequest *GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesRequest) *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall {
	c := &ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.attributesConfig = attributesConfig
	c.googlecloudretailv2alphabatchremovecatalogattributesrequest = googlecloudretailv2alphabatchremovecatalogattributesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall) Context(ctx context.Context) *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphabatchremovecatalogattributesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+attributesConfig}:batchRemoveCatalogAttributes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"attributesConfig": c.attributesConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.attributesConfig.batchRemoveCatalogAttributes" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsAttributesConfigBatchRemoveCatalogAttributesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaBatchRemoveCatalogAttributesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall struct {
	s                                                     *Service
	attributesConfig                                      string
	googlecloudretailv2alpharemovecatalogattributerequest *GoogleCloudRetailV2alphaRemoveCatalogAttributeRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// RemoveCatalogAttribute: Removes the specified CatalogAttribute from the
// AttributesConfig. If the CatalogAttribute to remove does not exist, a
// NOT_FOUND error is returned.
//
//   - attributesConfig: Full AttributesConfig resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/at
//     tributesConfig`.
func (r *ProjectsLocationsCatalogsAttributesConfigService) RemoveCatalogAttribute(attributesConfig string, googlecloudretailv2alpharemovecatalogattributerequest *GoogleCloudRetailV2alphaRemoveCatalogAttributeRequest) *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall {
	c := &ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.attributesConfig = attributesConfig
	c.googlecloudretailv2alpharemovecatalogattributerequest = googlecloudretailv2alpharemovecatalogattributerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alpharemovecatalogattributerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+attributesConfig}:removeCatalogAttribute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"attributesConfig": c.attributesConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.attributesConfig.removeCatalogAttribute" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaAttributesConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsAttributesConfigRemoveCatalogAttributeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaAttributesConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaAttributesConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall struct {
	s                                                      *Service
	attributesConfig                                       string
	googlecloudretailv2alphareplacecatalogattributerequest *GoogleCloudRetailV2alphaReplaceCatalogAttributeRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// ReplaceCatalogAttribute: Replaces the specified CatalogAttribute in the
// AttributesConfig by updating the catalog attribute with the same
// CatalogAttribute.key. If the CatalogAttribute to replace does not exist, a
// NOT_FOUND error is returned.
//
//   - attributesConfig: Full AttributesConfig resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/at
//     tributesConfig`.
func (r *ProjectsLocationsCatalogsAttributesConfigService) ReplaceCatalogAttribute(attributesConfig string, googlecloudretailv2alphareplacecatalogattributerequest *GoogleCloudRetailV2alphaReplaceCatalogAttributeRequest) *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall {
	c := &ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.attributesConfig = attributesConfig
	c.googlecloudretailv2alphareplacecatalogattributerequest = googlecloudretailv2alphareplacecatalogattributerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphareplacecatalogattributerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+attributesConfig}:replaceCatalogAttribute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"attributesConfig": c.attributesConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.attributesConfig.replaceCatalogAttribute" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaAttributesConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsAttributesConfigReplaceCatalogAttributeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaAttributesConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaAttributesConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a Branch.
//
//   - name: The name of the branch to retrieve. Format:
//     `projects/*/locations/global/catalogs/default_catalog/branches/some_branch_
//     id`. "default_branch" can be used as a special branch_id, it returns the
//     default branch that has been set for the catalog.
func (r *ProjectsLocationsCatalogsBranchesService) Get(name string) *ProjectsLocationsCatalogsBranchesGetCall {
	c := &ProjectsLocationsCatalogsBranchesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The view to apply to the returned
// Branch. Defaults to [Branch.BranchView.BASIC] if unspecified. See
// documentation of fields of Branch to find what fields are excluded from
// BASIC view.
//
// Possible values:
//
//	"BRANCH_VIEW_UNSPECIFIED" - The value when it's unspecified. This defaults
//
// to the BASIC view.
//
//	"BRANCH_VIEW_BASIC" - Includes basic metadata about the branch, but not
//
// statistical fields. See documentation of fields of Branch to find what
// fields are excluded from BASIC view.
//
//	"BRANCH_VIEW_FULL" - Includes all fields of a Branch.
func (c *ProjectsLocationsCatalogsBranchesGetCall) View(view string) *ProjectsLocationsCatalogsBranchesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsBranchesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaBranch.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaBranch, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaBranch{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all instances of Branch under the specified parent Catalog.
//
// - parent: The parent catalog resource name.
func (r *ProjectsLocationsCatalogsBranchesService) List(parent string) *ProjectsLocationsCatalogsBranchesListCall {
	c := &ProjectsLocationsCatalogsBranchesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// View sets the optional parameter "view": The view to apply to the returned
// Branch. Defaults to [Branch.BranchView.BASIC] if unspecified. See
// documentation of fields of Branch to find what fields are excluded from
// BASIC view.
//
// Possible values:
//
//	"BRANCH_VIEW_UNSPECIFIED" - The value when it's unspecified. This defaults
//
// to the BASIC view.
//
//	"BRANCH_VIEW_BASIC" - Includes basic metadata about the branch, but not
//
// statistical fields. See documentation of fields of Branch to find what
// fields are excluded from BASIC view.
//
//	"BRANCH_VIEW_FULL" - Includes all fields of a Branch.
func (c *ProjectsLocationsCatalogsBranchesListCall) View(view string) *ProjectsLocationsCatalogsBranchesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsBranchesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/branches")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListBranchesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListBranchesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListBranchesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCatalogsBranchesOperationsService) Get(name string) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c := &ProjectsLocationsCatalogsBranchesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCatalogsBranchesPlacesOperationsService) Get(name string) *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall {
	c := &ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.places.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesPlacesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall struct {
	s                                                   *Service
	product                                             string
	googlecloudretailv2alphaaddfulfillmentplacesrequest *GoogleCloudRetailV2alphaAddFulfillmentPlacesRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// AddFulfillmentPlaces: We recommend that you use the
// ProductService.AddLocalInventories method instead of the
// ProductService.AddFulfillmentPlaces method.
// ProductService.AddLocalInventories achieves the same results but provides
// more fine-grained control over ingesting local inventory data. Incrementally
// adds place IDs to Product.fulfillment_info.place_ids. This process is
// asynchronous and does not require the Product to exist before updating
// fulfillment information. If the request is valid, the update will be
// enqueued and processed downstream. As a consequence, when a response is
// returned, the added place IDs are not immediately manifested in the Product
// queried by ProductService.GetProduct or ProductService.ListProducts. The
// returned Operations will be obsolete after 1 day, and GetOperation API will
// return NOT_FOUND afterwards. If conflicting updates are issued, the
// Operations associated with the stale updates will not be marked as done
// until being obsolete.
//
//   - product: Full resource name of Product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/some_product_id`. If the caller does not have permission to
//     access the Product, regardless of whether or not it exists, a
//     PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) AddFulfillmentPlaces(product string, googlecloudretailv2alphaaddfulfillmentplacesrequest *GoogleCloudRetailV2alphaAddFulfillmentPlacesRequest) *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall {
	c := &ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.product = product
	c.googlecloudretailv2alphaaddfulfillmentplacesrequest = googlecloudretailv2alphaaddfulfillmentplacesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaaddfulfillmentplacesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+product}:addFulfillmentPlaces")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"product": c.product,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.addFulfillmentPlaces" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall struct {
	s                                                  *Service
	product                                            string
	googlecloudretailv2alphaaddlocalinventoriesrequest *GoogleCloudRetailV2alphaAddLocalInventoriesRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// AddLocalInventories: Updates local inventory information for a Product at a
// list of places, while respecting the last update timestamps of each
// inventory field. This process is asynchronous and does not require the
// Product to exist before updating inventory information. If the request is
// valid, the update will be enqueued and processed downstream. As a
// consequence, when a response is returned, updates are not immediately
// manifested in the Product queried by ProductService.GetProduct or
// ProductService.ListProducts. Local inventory information can only be
// modified using this method. ProductService.CreateProduct and
// ProductService.UpdateProduct has no effect on local inventories. The
// returned Operations will be obsolete after 1 day, and GetOperation API will
// return NOT_FOUND afterwards. If conflicting updates are issued, the
// Operations associated with the stale updates will not be marked as done
// until being obsolete.
//
//   - product: Full resource name of Product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/some_product_id`. If the caller does not have permission to
//     access the Product, regardless of whether or not it exists, a
//     PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) AddLocalInventories(product string, googlecloudretailv2alphaaddlocalinventoriesrequest *GoogleCloudRetailV2alphaAddLocalInventoriesRequest) *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall {
	c := &ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.product = product
	c.googlecloudretailv2alphaaddlocalinventoriesrequest = googlecloudretailv2alphaaddlocalinventoriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaaddlocalinventoriesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+product}:addLocalInventories")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"product": c.product,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.addLocalInventories" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsAddLocalInventoriesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsCreateCall struct {
	s                               *Service
	parent                          string
	googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Create: Creates a Product.
//
//   - parent: The parent catalog resource name, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Create(parent string, googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c := &ProjectsLocationsCatalogsBranchesProductsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaproduct = googlecloudretailv2alphaproduct
	return c
}

// ProductId sets the optional parameter "productId": Required. The ID to use
// for the Product, which will become the final component of the Product.name.
// If the caller does not have permission to create the Product, regardless of
// whether or not it exists, a PERMISSION_DENIED error is returned. This field
// must be unique among all Products with the same parent. Otherwise, an
// ALREADY_EXISTS error is returned. This field must be a UTF-8 encoded string
// with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
// is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) ProductId(productId string) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.urlParams_.Set("productId", productId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaproduct)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/products")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaProduct.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Product.
//
//   - name: Full resource name of Product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/some_product_id`. If the caller does not have permission to
//     delete the Product, regardless of whether or not it exists, a
//     PERMISSION_DENIED error is returned. If the Product to delete does not
//     exist, a NOT_FOUND error is returned. The Product to delete can neither be
//     a Product.Type.COLLECTION Product member nor a Product.Type.PRIMARY
//     Product with more than one variants. Otherwise, an INVALID_ARGUMENT error
//     is returned. All inventory information for the named Product will be
//     deleted.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Delete(name string) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c := &ProjectsLocationsCatalogsBranchesProductsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": This value only applies to the
// case when the target product is of type PRIMARY. When deleting a product of
// VARIANT/COLLECTION type, this value will be ignored. When set to true, the
// subsequent variant products will be deleted. When set to false, if the
// primary product has active variant products, an error will be returned.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Force(force bool) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsExportCall struct {
	s                                             *Service
	parent                                        string
	googlecloudretailv2alphaexportproductsrequest *GoogleCloudRetailV2alphaExportProductsRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Export: Exports multiple Products.
//
//   - parent: Resource name of a Branch, and `default_branch` for branch_id
//     component is supported. For example
//     `projects/1234/locations/global/catalogs/default_catalog/branches/default_b
//     ranch`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Export(parent string, googlecloudretailv2alphaexportproductsrequest *GoogleCloudRetailV2alphaExportProductsRequest) *ProjectsLocationsCatalogsBranchesProductsExportCall {
	c := &ProjectsLocationsCatalogsBranchesProductsExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaexportproductsrequest = googlecloudretailv2alphaexportproductsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsExportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaexportproductsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/products:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Product.
//
//   - name: Full resource name of Product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/some_product_id`. If the caller does not have permission to
//     access the Product, regardless of whether or not it exists, a
//     PERMISSION_DENIED error is returned. If the requested Product does not
//     exist, a NOT_FOUND error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Get(name string) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c := &ProjectsLocationsCatalogsBranchesProductsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaProduct.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsImportCall struct {
	s                                             *Service
	parent                                        string
	googlecloudretailv2alphaimportproductsrequest *GoogleCloudRetailV2alphaImportProductsRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Import: Bulk import of multiple Products. Request processing may be
// synchronous. Non-existing items are created. Note that it is possible for a
// subset of the Products to be successfully updated.
//
//   - parent:
//     `projects/1234/locations/global/catalogs/default_catalog/branches/default_b
//     ranch` If no updateMask is specified, requires products.create permission.
//     If updateMask is specified, requires products.update permission.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Import(parent string, googlecloudretailv2alphaimportproductsrequest *GoogleCloudRetailV2alphaImportProductsRequest) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c := &ProjectsLocationsCatalogsBranchesProductsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaimportproductsrequest = googlecloudretailv2alphaimportproductsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaimportproductsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/products:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Products.
//
//   - parent: The parent branch resource name, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/0`. Use
//     `default_branch` as the branch ID, to list products under the default
//     branch. If the caller does not have permission to list Products under this
//     branch, regardless of whether or not this branch exists, a
//     PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) List(parent string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c := &ProjectsLocationsCatalogsBranchesProductsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the list
// results. Supported features: * List all the products under the parent branch
// if filter is unset. * List Product.Type.VARIANT Products sharing the same
// Product.Type.PRIMARY Product. For example: `primary_product_id =
// "some_product_id" * List Products bundled in a Product.Type.COLLECTION
// Product. For example: `collection_product_id = "some_product_id" * List
// Products with a partibular type. For example: `type = "PRIMARY" `type =
// "VARIANT" `type = "COLLECTION" If the field is unrecognizable, an
// INVALID_ARGUMENT error is returned. If the specified Product.Type.PRIMARY
// Product or Product.Type.COLLECTION Product does not exist, a NOT_FOUND error
// is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Filter(filter string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Products
// to return. If unspecified, defaults to 100. The maximum allowed value is
// 1000. Values above 1000 will be coerced to 1000. If this field is negative,
// an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListProductsResponse.next_page_token, received from a previous
// ProductService.ListProducts call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to
// ProductService.ListProducts must match the call that provided the page
// token. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadMask sets the optional parameter "readMask": The fields of Product to
// return in the responses. If not set or empty, the following fields are
// returned: * Product.name * Product.id * Product.title * Product.uri *
// Product.images * Product.price_info * Product.brands If "*" is provided, all
// fields are returned. Product.name is always returned no matter what mask is
// set. If an unsupported or unknown field is provided, an INVALID_ARGUMENT
// error is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) ReadMask(readMask string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// RequireTotalSize sets the optional parameter "requireTotalSize": If true and
// page_token is empty, ListProductsResponse.total_size is set to the total
// count of matched items irrespective of pagination. Notice that setting this
// field to true affects the performance.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) RequireTotalSize(requireTotalSize bool) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("requireTotalSize", fmt.Sprint(requireTotalSize))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/products")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListProductsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListProductsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListProductsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaListProductsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCatalogsBranchesProductsPatchCall struct {
	s                               *Service
	name                            string
	googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Updates a Product.
//
//   - name: Immutable. Full resource name of the product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/product_id`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Patch(name string, googlecloudretailv2alphaproduct *GoogleCloudRetailV2alphaProduct) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c := &ProjectsLocationsCatalogsBranchesProductsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphaproduct = googlecloudretailv2alphaproduct
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// the Product is not found, a new Product will be created. In this situation,
// `update_mask` is ignored.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided Product to update. The immutable and output only fields are
// NOT supported. If not set, all supported fields (the fields that are neither
// immutable nor output only) are updated. If an unsupported or unknown field
// is provided, an INVALID_ARGUMENT error is returned. The attribute key can be
// updated by setting the mask path as "attributes.${key_name}". If a key name
// is present in the mask but not in the patching product from the request,
// this key will be deleted after the update.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaproduct)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaProduct.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsPurgeCall struct {
	s                                            *Service
	parent                                       string
	googlecloudretailv2alphapurgeproductsrequest *GoogleCloudRetailV2alphaPurgeProductsRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Purge: Permanently deletes all selected Products under a branch. This
// process is asynchronous. If the request is valid, the removal will be
// enqueued and processed offline. Depending on the number of Products, this
// operation could take hours to complete. Before the operation completes, some
// Products may still be returned by ProductService.GetProduct or
// ProductService.ListProducts. Depending on the number of Products, this
// operation could take hours to complete. To get a sample of Products that
// would be deleted, set PurgeProductsRequest.force to false.
//
//   - parent: The resource name of the branch under which the products are
//     created. The format is
//     `projects/${projectId}/locations/global/catalogs/${catalogId}/branches/${br
//     anchId}`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Purge(parent string, googlecloudretailv2alphapurgeproductsrequest *GoogleCloudRetailV2alphaPurgeProductsRequest) *ProjectsLocationsCatalogsBranchesProductsPurgeCall {
	c := &ProjectsLocationsCatalogsBranchesProductsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphapurgeproductsrequest = googlecloudretailv2alphapurgeproductsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphapurgeproductsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/products:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.purge" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall struct {
	s                                                      *Service
	product                                                string
	googlecloudretailv2alpharemovefulfillmentplacesrequest *GoogleCloudRetailV2alphaRemoveFulfillmentPlacesRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// RemoveFulfillmentPlaces: We recommend that you use the
// ProductService.RemoveLocalInventories method instead of the
// ProductService.RemoveFulfillmentPlaces method.
// ProductService.RemoveLocalInventories achieves the same results but provides
// more fine-grained control over ingesting local inventory data. Incrementally
// removes place IDs from a Product.fulfillment_info.place_ids. This process is
// asynchronous and does not require the Product to exist before updating
// fulfillment information. If the request is valid, the update will be
// enqueued and processed downstream. As a consequence, when a response is
// returned, the removed place IDs are not immediately manifested in the
// Product queried by ProductService.GetProduct or ProductService.ListProducts.
// The returned Operations will be obsolete after 1 day, and GetOperation API
// will return NOT_FOUND afterwards. If conflicting updates are issued, the
// Operations associated with the stale updates will not be marked as done
// until being obsolete.
//
//   - product: Full resource name of Product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/some_product_id`. If the caller does not have permission to
//     access the Product, regardless of whether or not it exists, a
//     PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) RemoveFulfillmentPlaces(product string, googlecloudretailv2alpharemovefulfillmentplacesrequest *GoogleCloudRetailV2alphaRemoveFulfillmentPlacesRequest) *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall {
	c := &ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.product = product
	c.googlecloudretailv2alpharemovefulfillmentplacesrequest = googlecloudretailv2alpharemovefulfillmentplacesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alpharemovefulfillmentplacesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+product}:removeFulfillmentPlaces")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"product": c.product,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.removeFulfillmentPlaces" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall struct {
	s                                                     *Service
	product                                               string
	googlecloudretailv2alpharemovelocalinventoriesrequest *GoogleCloudRetailV2alphaRemoveLocalInventoriesRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// RemoveLocalInventories: Remove local inventory information for a Product at
// a list of places at a removal timestamp. This process is asynchronous. If
// the request is valid, the removal will be enqueued and processed downstream.
// As a consequence, when a response is returned, removals are not immediately
// manifested in the Product queried by ProductService.GetProduct or
// ProductService.ListProducts. Local inventory information can only be removed
// using this method. ProductService.CreateProduct and
// ProductService.UpdateProduct has no effect on local inventories. The
// returned Operations will be obsolete after 1 day, and GetOperation API will
// return NOT_FOUND afterwards. If conflicting updates are issued, the
// Operations associated with the stale updates will not be marked as done
// until being obsolete.
//
//   - product: Full resource name of Product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/some_product_id`. If the caller does not have permission to
//     access the Product, regardless of whether or not it exists, a
//     PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) RemoveLocalInventories(product string, googlecloudretailv2alpharemovelocalinventoriesrequest *GoogleCloudRetailV2alphaRemoveLocalInventoriesRequest) *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall {
	c := &ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.product = product
	c.googlecloudretailv2alpharemovelocalinventoriesrequest = googlecloudretailv2alpharemovelocalinventoriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alpharemovelocalinventoriesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+product}:removeLocalInventories")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"product": c.product,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.removeLocalInventories" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveLocalInventoriesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsBranchesProductsSetInventoryCall struct {
	s                                           *Service
	name                                        string
	googlecloudretailv2alphasetinventoryrequest *GoogleCloudRetailV2alphaSetInventoryRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// SetInventory: Updates inventory information for a Product while respecting
// the last update timestamps of each inventory field. This process is
// asynchronous and does not require the Product to exist before updating
// fulfillment information. If the request is valid, the update is enqueued and
// processed downstream. As a consequence, when a response is returned, updates
// are not immediately manifested in the Product queried by
// ProductService.GetProduct or ProductService.ListProducts. When inventory is
// updated with ProductService.CreateProduct and ProductService.UpdateProduct,
// the specified inventory field value(s) overwrite any existing value(s) while
// ignoring the last update time for this field. Furthermore, the last update
// times for the specified inventory fields are overwritten by the times of the
// ProductService.CreateProduct or ProductService.UpdateProduct request. If no
// inventory fields are set in CreateProductRequest.product, then any
// pre-existing inventory information for this product is used. If no inventory
// fields are set in SetInventoryRequest.set_mask, then any existing inventory
// information is preserved. Pre-existing inventory information can only be
// updated with ProductService.SetInventory,
// ProductService.AddFulfillmentPlaces, and
// ProductService.RemoveFulfillmentPlaces. The returned Operations is obsolete
// after one day, and the GetOperation API returns `NOT_FOUND` afterwards. If
// conflicting updates are issued, the Operations associated with the stale
// updates are not marked as done until they are obsolete.
//
//   - name: Immutable. Full resource name of the product, such as
//     `projects/*/locations/global/catalogs/default_catalog/branches/default_bran
//     ch/products/product_id`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) SetInventory(name string, googlecloudretailv2alphasetinventoryrequest *GoogleCloudRetailV2alphaSetInventoryRequest) *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall {
	c := &ProjectsLocationsCatalogsBranchesProductsSetInventoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphasetinventoryrequest = googlecloudretailv2alphasetinventoryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphasetinventoryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}:setInventory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.setInventory" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsCompletionDataImportCall struct {
	s                                                   *Service
	parent                                              string
	googlecloudretailv2alphaimportcompletiondatarequest *GoogleCloudRetailV2alphaImportCompletionDataRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Import: Bulk import of processed completion dataset. Request processing is
// asynchronous. Partial updating is not supported. The operation is
// successfully finished only after the imported suggestions are indexed
// successfully and ready for serving. The process takes hours. This feature is
// only available for users who have Retail Search enabled. Enable Retail
// Search on Cloud Console before using this feature.
//
//   - parent: The catalog which the suggestions dataset belongs to. Format:
//     `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsCompletionDataService) Import(parent string, googlecloudretailv2alphaimportcompletiondatarequest *GoogleCloudRetailV2alphaImportCompletionDataRequest) *ProjectsLocationsCatalogsCompletionDataImportCall {
	c := &ProjectsLocationsCatalogsCompletionDataImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaimportcompletiondatarequest = googlecloudretailv2alphaimportcompletiondatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsCompletionDataImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsCompletionDataImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsCompletionDataImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaimportcompletiondatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/completionData:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.completionData.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsControlsCreateCall struct {
	s                               *Service
	parent                          string
	googlecloudretailv2alphacontrol *GoogleCloudRetailV2alphaControl
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Create: Creates a Control. If the Control to create already exists, an
// ALREADY_EXISTS error is returned.
//
//   - parent: Full resource name of parent catalog. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`.
func (r *ProjectsLocationsCatalogsControlsService) Create(parent string, googlecloudretailv2alphacontrol *GoogleCloudRetailV2alphaControl) *ProjectsLocationsCatalogsControlsCreateCall {
	c := &ProjectsLocationsCatalogsControlsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphacontrol = googlecloudretailv2alphacontrol
	return c
}

// ControlId sets the optional parameter "controlId": Required. The ID to use
// for the Control, which will become the final component of the Control's
// resource name. This value should be 4-63 characters, and valid characters
// are /a-z-_/.
func (c *ProjectsLocationsCatalogsControlsCreateCall) ControlId(controlId string) *ProjectsLocationsCatalogsControlsCreateCall {
	c.urlParams_.Set("controlId", controlId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsControlsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsControlsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsControlsCreateCall) Context(ctx context.Context) *ProjectsLocationsCatalogsControlsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsControlsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsControlsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphacontrol)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/controls")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.controls.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaControl.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsControlsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaControl, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaControl{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsControlsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Control. If the Control to delete does not exist, a
// NOT_FOUND error is returned.
//
//   - name: The resource name of the Control to delete. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/co
//     ntrols/{control_id}`.
func (r *ProjectsLocationsCatalogsControlsService) Delete(name string) *ProjectsLocationsCatalogsControlsDeleteCall {
	c := &ProjectsLocationsCatalogsControlsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsControlsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsControlsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsControlsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsControlsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsControlsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsControlsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.controls.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsControlsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsControlsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Control.
//
//   - name: The resource name of the Control to get. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/co
//     ntrols/{control_id}`.
func (r *ProjectsLocationsCatalogsControlsService) Get(name string) *ProjectsLocationsCatalogsControlsGetCall {
	c := &ProjectsLocationsCatalogsControlsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsControlsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsControlsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsControlsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsControlsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsControlsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsControlsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsControlsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsControlsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.controls.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaControl.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsControlsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaControl, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaControl{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsControlsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Controls by their parent Catalog.
//
//   - parent: The catalog resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`.
func (r *ProjectsLocationsCatalogsControlsService) List(parent string) *ProjectsLocationsCatalogsControlsListCall {
	c := &ProjectsLocationsCatalogsControlsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the list
// results. Supported features: * List all the products under the parent branch
// if filter is unset. * List controls that are used in a single ServingConfig:
// 'serving_config = "boosted_home_page_cvr"'
func (c *ProjectsLocationsCatalogsControlsListCall) Filter(filter string) *ProjectsLocationsCatalogsControlsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. If unspecified, defaults to 50. Max allowed value is 1000.
func (c *ProjectsLocationsCatalogsControlsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsControlsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListControls` call. Provide this to retrieve the subsequent
// page.
func (c *ProjectsLocationsCatalogsControlsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsControlsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsControlsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsControlsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsControlsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsControlsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsControlsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsControlsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsControlsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsControlsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/controls")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.controls.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListControlsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsControlsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListControlsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListControlsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsControlsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaListControlsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCatalogsControlsPatchCall struct {
	s                               *Service
	name                            string
	googlecloudretailv2alphacontrol *GoogleCloudRetailV2alphaControl
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Updates a Control. Control cannot be set to a different oneof field,
// if so an INVALID_ARGUMENT is returned. If the Control to update does not
// exist, a NOT_FOUND error is returned.
//
//   - name: Immutable. Fully qualified name
//     `projects/*/locations/global/catalogs/*/controls/*`.
func (r *ProjectsLocationsCatalogsControlsService) Patch(name string, googlecloudretailv2alphacontrol *GoogleCloudRetailV2alphaControl) *ProjectsLocationsCatalogsControlsPatchCall {
	c := &ProjectsLocationsCatalogsControlsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphacontrol = googlecloudretailv2alphacontrol
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided Control to update. The following are NOT supported: *
// Control.name If not set or empty, all supported fields are updated.
func (c *ProjectsLocationsCatalogsControlsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsControlsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsControlsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsControlsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsControlsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsControlsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsControlsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsControlsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphacontrol)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.controls.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaControl.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsControlsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaControl, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaControl{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall struct {
	s                                                 *Service
	parent                                            string
	googlecloudretailv2alphamerchantcenteraccountlink *GoogleCloudRetailV2alphaMerchantCenterAccountLink
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Create: Creates a MerchantCenterAccountLink.
//
//   - parent: The branch resource where this MerchantCenterAccountLink will be
//     created. Format:
//     `projects/{PROJECT_NUMBER}/locations/global/catalogs/{CATALOG_ID}`.
func (r *ProjectsLocationsCatalogsMerchantCenterAccountLinksService) Create(parent string, googlecloudretailv2alphamerchantcenteraccountlink *GoogleCloudRetailV2alphaMerchantCenterAccountLink) *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall {
	c := &ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphamerchantcenteraccountlink = googlecloudretailv2alphamerchantcenteraccountlink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall) Context(ctx context.Context) *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphamerchantcenteraccountlink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/merchantCenterAccountLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.merchantCenterAccountLinks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a MerchantCenterAccountLink. If the
// MerchantCenterAccountLink to delete does not exist, a NOT_FOUND error is
// returned.
//
//   - name: Full resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/me
//     rchantCenterAccountLinks/{merchant_center_account_link_id}`.
func (r *ProjectsLocationsCatalogsMerchantCenterAccountLinksService) Delete(name string) *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall {
	c := &ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.merchantCenterAccountLinks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all MerchantCenterAccountLinks under the specified parent
// Catalog.
//
//   - parent: The parent Catalog of the resource. It must match this format:
//     `projects/{PROJECT_NUMBER}/locations/global/catalogs/{CATALOG_ID}`.
func (r *ProjectsLocationsCatalogsMerchantCenterAccountLinksService) List(parent string) *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall {
	c := &ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/merchantCenterAccountLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.merchantCenterAccountLinks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListMerchantCenterAccountLinksResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsMerchantCenterAccountLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListMerchantCenterAccountLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListMerchantCenterAccountLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsModelsCreateCall struct {
	s                             *Service
	parent                        string
	googlecloudretailv2alphamodel *GoogleCloudRetailV2alphaModel
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Create: Creates a new model.
//
//   - parent: The parent resource under which to create the model. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`.
func (r *ProjectsLocationsCatalogsModelsService) Create(parent string, googlecloudretailv2alphamodel *GoogleCloudRetailV2alphaModel) *ProjectsLocationsCatalogsModelsCreateCall {
	c := &ProjectsLocationsCatalogsModelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphamodel = googlecloudretailv2alphamodel
	return c
}

// DryRun sets the optional parameter "dryRun": Whether to run a dry run to
// validate the request (without actually creating the model).
func (c *ProjectsLocationsCatalogsModelsCreateCall) DryRun(dryRun bool) *ProjectsLocationsCatalogsModelsCreateCall {
	c.urlParams_.Set("dryRun", fmt.Sprint(dryRun))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsCreateCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphamodel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/models")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsModelsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsModelsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing model.
//
//   - name: The resource name of the Model to delete. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mo
//     dels/{model_id}`.
func (r *ProjectsLocationsCatalogsModelsService) Delete(name string) *ProjectsLocationsCatalogsModelsDeleteCall {
	c := &ProjectsLocationsCatalogsModelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsModelsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsModelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a model.
//
//   - name: The resource name of the Model to get. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog}/model
//     s/{model_id}`.
func (r *ProjectsLocationsCatalogsModelsService) Get(name string) *ProjectsLocationsCatalogsModelsGetCall {
	c := &ProjectsLocationsCatalogsModelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsModelsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsModelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaModel.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsModelsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsModelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the models linked to this event store.
//
//   - parent: The parent for which to list models. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`.
func (r *ProjectsLocationsCatalogsModelsService) List(parent string) *ProjectsLocationsCatalogsModelsListCall {
	c := &ProjectsLocationsCatalogsModelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. If unspecified, defaults to 50. Max allowed value is 1000.
func (c *ProjectsLocationsCatalogsModelsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsModelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListModels` call. Provide this to retrieve the subsequent
// page.
func (c *ProjectsLocationsCatalogsModelsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsModelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsModelsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsModelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/models")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListModelsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsModelsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsModelsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaListModelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCatalogsModelsPatchCall struct {
	s                             *Service
	name                          string
	googlecloudretailv2alphamodel *GoogleCloudRetailV2alphaModel
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Patch: Update of model metadata. Only fields that currently can be updated
// are: `filtering_option` and `periodic_tuning_state`. If other values are
// provided, this API method ignores them.
//
//   - name: The fully qualified resource name of the model. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mo
//     dels/{model_id}` catalog_id has char limit of 50. recommendation_model_id
//     has char limit of 40.
func (r *ProjectsLocationsCatalogsModelsService) Patch(name string, googlecloudretailv2alphamodel *GoogleCloudRetailV2alphaModel) *ProjectsLocationsCatalogsModelsPatchCall {
	c := &ProjectsLocationsCatalogsModelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphamodel = googlecloudretailv2alphamodel
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided 'model' to update. If not set, by default updates all
// fields.
func (c *ProjectsLocationsCatalogsModelsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsModelsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphamodel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaModel.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsModelsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsModelsPauseCall struct {
	s                                         *Service
	name                                      string
	googlecloudretailv2alphapausemodelrequest *GoogleCloudRetailV2alphaPauseModelRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Pause: Pauses the training of an existing model.
//
//   - name: The name of the model to pause. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mo
//     dels/{model_id}`.
func (r *ProjectsLocationsCatalogsModelsService) Pause(name string, googlecloudretailv2alphapausemodelrequest *GoogleCloudRetailV2alphaPauseModelRequest) *ProjectsLocationsCatalogsModelsPauseCall {
	c := &ProjectsLocationsCatalogsModelsPauseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphapausemodelrequest = googlecloudretailv2alphapausemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsPauseCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsPauseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsPauseCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsPauseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsPauseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsPauseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphapausemodelrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}:pause")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.pause" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaModel.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsModelsPauseCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsModelsResumeCall struct {
	s                                          *Service
	name                                       string
	googlecloudretailv2alpharesumemodelrequest *GoogleCloudRetailV2alphaResumeModelRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Resume: Resumes the training of an existing model.
//
//   - name: The name of the model to resume. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mo
//     dels/{model_id}`.
func (r *ProjectsLocationsCatalogsModelsService) Resume(name string, googlecloudretailv2alpharesumemodelrequest *GoogleCloudRetailV2alphaResumeModelRequest) *ProjectsLocationsCatalogsModelsResumeCall {
	c := &ProjectsLocationsCatalogsModelsResumeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alpharesumemodelrequest = googlecloudretailv2alpharesumemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsResumeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsResumeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsResumeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsResumeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsResumeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsResumeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alpharesumemodelrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}:resume")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.resume" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaModel.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsModelsResumeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsModelsTuneCall struct {
	s                                        *Service
	name                                     string
	googlecloudretailv2alphatunemodelrequest *GoogleCloudRetailV2alphaTuneModelRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Tune: Tunes an existing model.
//
//   - name: The resource name of the model to tune. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/mo
//     dels/{model_id}`.
func (r *ProjectsLocationsCatalogsModelsService) Tune(name string, googlecloudretailv2alphatunemodelrequest *GoogleCloudRetailV2alphaTuneModelRequest) *ProjectsLocationsCatalogsModelsTuneCall {
	c := &ProjectsLocationsCatalogsModelsTuneCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphatunemodelrequest = googlecloudretailv2alphatunemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsModelsTuneCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsModelsTuneCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsModelsTuneCall) Context(ctx context.Context) *ProjectsLocationsCatalogsModelsTuneCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsModelsTuneCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsModelsTuneCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphatunemodelrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}:tune")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.models.tune" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsModelsTuneCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCatalogsOperationsService) Get(name string) *ProjectsLocationsCatalogsOperationsGetCall {
	c := &ProjectsLocationsCatalogsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCatalogsOperationsService) List(name string) *ProjectsLocationsCatalogsOperationsListCall {
	c := &ProjectsLocationsCatalogsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsCatalogsOperationsListCall) Filter(filter string) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsCatalogsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsCatalogsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCatalogsPlacementsPredictCall struct {
	s                                      *Service
	placement                              string
	googlecloudretailv2alphapredictrequest *GoogleCloudRetailV2alphaPredictRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Predict: Makes a recommendation prediction.
//
//   - placement: Full resource name of the format:
//     `{placement=projects/*/locations/global/catalogs/default_catalog/servingCon
//     figs/*}` or
//     `{placement=projects/*/locations/global/catalogs/default_catalog/placements
//     /*}`. We recommend using the `servingConfigs` resource. `placements` is a
//     legacy resource. The ID of the Recommendations AI serving config or
//     placement. Before you can request predictions from your model, you must
//     create at least one serving config or placement for it. For more
//     information, see [Manage serving configs]
//     (https://cloud.google.com/retail/docs/manage-configs). The full list of
//     available serving configs can be seen at
//     https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs.
func (r *ProjectsLocationsCatalogsPlacementsService) Predict(placement string, googlecloudretailv2alphapredictrequest *GoogleCloudRetailV2alphaPredictRequest) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c := &ProjectsLocationsCatalogsPlacementsPredictCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.placement = placement
	c.googlecloudretailv2alphapredictrequest = googlecloudretailv2alphapredictrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPlacementsPredictCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphapredictrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+placement}:predict")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"placement": c.placement,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.placements.predict" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaPredictResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaPredictResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaPredictResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsPlacementsSearchCall struct {
	s                                     *Service
	placement                             string
	googlecloudretailv2alphasearchrequest *GoogleCloudRetailV2alphaSearchRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Search: Performs a search. This feature is only available for users who have
// Retail Search enabled. Enable Retail Search on Cloud Console before using
// this feature.
//
//   - placement: The resource name of the Retail Search serving config, such as
//     `projects/*/locations/global/catalogs/default_catalog/servingConfigs/defaul
//     t_serving_config` or the name of the legacy placement resource, such as
//     `projects/*/locations/global/catalogs/default_catalog/placements/default_se
//     arch`. This field is used to identify the serving config name and the set
//     of models that are used to make the search.
func (r *ProjectsLocationsCatalogsPlacementsService) Search(placement string, googlecloudretailv2alphasearchrequest *GoogleCloudRetailV2alphaSearchRequest) *ProjectsLocationsCatalogsPlacementsSearchCall {
	c := &ProjectsLocationsCatalogsPlacementsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.placement = placement
	c.googlecloudretailv2alphasearchrequest = googlecloudretailv2alphasearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPlacementsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPlacementsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPlacementsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphasearchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+placement}:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"placement": c.placement,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.placements.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaSearchResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaSearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaSearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaSearchResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlecloudretailv2alphasearchrequest.PageToken = pt }(c.googlecloudretailv2alphasearchrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlecloudretailv2alphasearchrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsCatalogsServingConfigsAddControlCall struct {
	s                                         *Service
	servingConfig                             string
	googlecloudretailv2alphaaddcontrolrequest *GoogleCloudRetailV2alphaAddControlRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// AddControl: Enables a Control on the specified ServingConfig. The control is
// added in the last position of the list of controls it belongs to (e.g. if
// it's a facet spec control it will be applied in the last position of
// servingConfig.facetSpecIds) Returns a ALREADY_EXISTS error if the control
// has already been applied. Returns a FAILED_PRECONDITION error if the
// addition could exceed maximum number of control allowed for that type of
// control.
//
//   - servingConfig: The source ServingConfig resource name . Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/se
//     rvingConfigs/{serving_config_id}`.
func (r *ProjectsLocationsCatalogsServingConfigsService) AddControl(servingConfig string, googlecloudretailv2alphaaddcontrolrequest *GoogleCloudRetailV2alphaAddControlRequest) *ProjectsLocationsCatalogsServingConfigsAddControlCall {
	c := &ProjectsLocationsCatalogsServingConfigsAddControlCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googlecloudretailv2alphaaddcontrolrequest = googlecloudretailv2alphaaddcontrolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsAddControlCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsAddControlCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsAddControlCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsAddControlCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsAddControlCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsAddControlCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaaddcontrolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+servingConfig}:addControl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.addControl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaServingConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsAddControlCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaServingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaServingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsServingConfigsCreateCall struct {
	s                                     *Service
	parent                                string
	googlecloudretailv2alphaservingconfig *GoogleCloudRetailV2alphaServingConfig
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates a ServingConfig. A maximum of 100 ServingConfigs are allowed
// in a Catalog, otherwise a FAILED_PRECONDITION error is returned.
//
//   - parent: Full resource name of parent. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`.
func (r *ProjectsLocationsCatalogsServingConfigsService) Create(parent string, googlecloudretailv2alphaservingconfig *GoogleCloudRetailV2alphaServingConfig) *ProjectsLocationsCatalogsServingConfigsCreateCall {
	c := &ProjectsLocationsCatalogsServingConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaservingconfig = googlecloudretailv2alphaservingconfig
	return c
}

// ServingConfigId sets the optional parameter "servingConfigId": Required. The
// ID to use for the ServingConfig, which will become the final component of
// the ServingConfig's resource name. This value should be 4-63 characters, and
// valid characters are /a-z-_/.
func (c *ProjectsLocationsCatalogsServingConfigsCreateCall) ServingConfigId(servingConfigId string) *ProjectsLocationsCatalogsServingConfigsCreateCall {
	c.urlParams_.Set("servingConfigId", servingConfigId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsCreateCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaservingconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/servingConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaServingConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaServingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaServingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsServingConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a ServingConfig. Returns a NotFound error if the
// ServingConfig does not exist.
//
//   - name: The resource name of the ServingConfig to delete. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/se
//     rvingConfigs/{serving_config_id}`.
func (r *ProjectsLocationsCatalogsServingConfigsService) Delete(name string) *ProjectsLocationsCatalogsServingConfigsDeleteCall {
	c := &ProjectsLocationsCatalogsServingConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsServingConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsServingConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a ServingConfig. Returns a NotFound error if the ServingConfig
// does not exist.
//
//   - name: The resource name of the ServingConfig to get. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/se
//     rvingConfigs/{serving_config_id}`.
func (r *ProjectsLocationsCatalogsServingConfigsService) Get(name string) *ProjectsLocationsCatalogsServingConfigsGetCall {
	c := &ProjectsLocationsCatalogsServingConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsServingConfigsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsServingConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaServingConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaServingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaServingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsServingConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all ServingConfigs linked to this catalog.
//
//   - parent: The catalog resource name. Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`.
func (r *ProjectsLocationsCatalogsServingConfigsService) List(parent string) *ProjectsLocationsCatalogsServingConfigsListCall {
	c := &ProjectsLocationsCatalogsServingConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. If unspecified, defaults to 100. If a value greater than 100 is
// provided, at most 100 results are returned.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsServingConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListServingConfigs` call. Provide this to retrieve the
// subsequent page.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsServingConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsServingConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/servingConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaListServingConfigsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaListServingConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaListServingConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsServingConfigsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaListServingConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCatalogsServingConfigsPatchCall struct {
	s                                     *Service
	name                                  string
	googlecloudretailv2alphaservingconfig *GoogleCloudRetailV2alphaServingConfig
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a ServingConfig.
//
//   - name: Immutable. Fully qualified name
//     `projects/*/locations/global/catalogs/*/servingConfig/*`.
func (r *ProjectsLocationsCatalogsServingConfigsService) Patch(name string, googlecloudretailv2alphaservingconfig *GoogleCloudRetailV2alphaServingConfig) *ProjectsLocationsCatalogsServingConfigsPatchCall {
	c := &ProjectsLocationsCatalogsServingConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2alphaservingconfig = googlecloudretailv2alphaservingconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which fields
// in the provided ServingConfig to update. The following are NOT supported: *
// ServingConfig.name If not set, all supported fields are updated.
func (c *ProjectsLocationsCatalogsServingConfigsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsServingConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaservingconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaServingConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaServingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaServingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsServingConfigsPredictCall struct {
	s                                      *Service
	placement                              string
	googlecloudretailv2alphapredictrequest *GoogleCloudRetailV2alphaPredictRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Predict: Makes a recommendation prediction.
//
//   - placement: Full resource name of the format:
//     `{placement=projects/*/locations/global/catalogs/default_catalog/servingCon
//     figs/*}` or
//     `{placement=projects/*/locations/global/catalogs/default_catalog/placements
//     /*}`. We recommend using the `servingConfigs` resource. `placements` is a
//     legacy resource. The ID of the Recommendations AI serving config or
//     placement. Before you can request predictions from your model, you must
//     create at least one serving config or placement for it. For more
//     information, see [Manage serving configs]
//     (https://cloud.google.com/retail/docs/manage-configs). The full list of
//     available serving configs can be seen at
//     https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs.
func (r *ProjectsLocationsCatalogsServingConfigsService) Predict(placement string, googlecloudretailv2alphapredictrequest *GoogleCloudRetailV2alphaPredictRequest) *ProjectsLocationsCatalogsServingConfigsPredictCall {
	c := &ProjectsLocationsCatalogsServingConfigsPredictCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.placement = placement
	c.googlecloudretailv2alphapredictrequest = googlecloudretailv2alphapredictrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsPredictCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsPredictCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsPredictCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsPredictCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsPredictCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsPredictCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphapredictrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+placement}:predict")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"placement": c.placement,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.predict" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaPredictResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsPredictCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaPredictResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaPredictResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsServingConfigsRemoveControlCall struct {
	s                                            *Service
	servingConfig                                string
	googlecloudretailv2alpharemovecontrolrequest *GoogleCloudRetailV2alphaRemoveControlRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// RemoveControl: Disables a Control on the specified ServingConfig. The
// control is removed from the ServingConfig. Returns a NOT_FOUND error if the
// Control is not enabled for the ServingConfig.
//
//   - servingConfig: The source ServingConfig resource name . Format:
//     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/se
//     rvingConfigs/{serving_config_id}`.
func (r *ProjectsLocationsCatalogsServingConfigsService) RemoveControl(servingConfig string, googlecloudretailv2alpharemovecontrolrequest *GoogleCloudRetailV2alphaRemoveControlRequest) *ProjectsLocationsCatalogsServingConfigsRemoveControlCall {
	c := &ProjectsLocationsCatalogsServingConfigsRemoveControlCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googlecloudretailv2alpharemovecontrolrequest = googlecloudretailv2alpharemovecontrolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsRemoveControlCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsRemoveControlCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsRemoveControlCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsRemoveControlCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsRemoveControlCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsRemoveControlCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alpharemovecontrolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+servingConfig}:removeControl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.removeControl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaServingConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsRemoveControlCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaServingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaServingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsServingConfigsSearchCall struct {
	s                                     *Service
	placement                             string
	googlecloudretailv2alphasearchrequest *GoogleCloudRetailV2alphaSearchRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Search: Performs a search. This feature is only available for users who have
// Retail Search enabled. Enable Retail Search on Cloud Console before using
// this feature.
//
//   - placement: The resource name of the Retail Search serving config, such as
//     `projects/*/locations/global/catalogs/default_catalog/servingConfigs/defaul
//     t_serving_config` or the name of the legacy placement resource, such as
//     `projects/*/locations/global/catalogs/default_catalog/placements/default_se
//     arch`. This field is used to identify the serving config name and the set
//     of models that are used to make the search.
func (r *ProjectsLocationsCatalogsServingConfigsService) Search(placement string, googlecloudretailv2alphasearchrequest *GoogleCloudRetailV2alphaSearchRequest) *ProjectsLocationsCatalogsServingConfigsSearchCall {
	c := &ProjectsLocationsCatalogsServingConfigsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.placement = placement
	c.googlecloudretailv2alphasearchrequest = googlecloudretailv2alphasearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsServingConfigsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsServingConfigsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsServingConfigsSearchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsServingConfigsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsServingConfigsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsServingConfigsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphasearchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+placement}:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"placement": c.placement,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.servingConfigs.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaSearchResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsServingConfigsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaSearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaSearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsServingConfigsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2alphaSearchResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlecloudretailv2alphasearchrequest.PageToken = pt }(c.googlecloudretailv2alphasearchrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlecloudretailv2alphasearchrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsCatalogsUserEventsCollectCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Collect: Writes a single user event from the browser. This uses a GET
// request to due to browser restriction of POST-ing to a 3rd party domain.
// This method is used only by the Retail API JavaScript pixel and Google Tag
// Manager. Users should not call this method directly.
//
//   - parent: The parent catalog name, such as
//     `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Collect(parent string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c := &ProjectsLocationsCatalogsUserEventsCollectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Ets sets the optional parameter "ets": The event timestamp in milliseconds.
// This prevents browser caching of otherwise identical get requests. The name
// is abbreviated to reduce the payload bytes.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Ets(ets int64) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("ets", fmt.Sprint(ets))
	return c
}

// PrebuiltRule sets the optional parameter "prebuiltRule": The prebuilt rule
// name that can convert a specific type of raw_json. For example: "ga4_bq"
// rule for the GA4 user event schema.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) PrebuiltRule(prebuiltRule string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("prebuiltRule", prebuiltRule)
	return c
}

// RawJson sets the optional parameter "rawJson": An arbitrary serialized JSON
// string that contains necessary information that can comprise a user event.
// When this field is specified, the user_event field will be ignored. Note:
// line-delimited JSON is not supported, a single JSON only.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) RawJson(rawJson string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("rawJson", rawJson)
	return c
}

// Uri sets the optional parameter "uri": The URL including cgi-parameters but
// excluding the hash fragment with a length limit of 5,000 characters. This is
// often more useful than the referer URL, because many browsers only send the
// domain for 3rd party requests.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Uri(uri string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("uri", uri)
	return c
}

// UserEvent sets the optional parameter "userEvent": Required. URL encoded
// UserEvent proto with a length limit of 2,000,000 characters.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) UserEvent(userEvent string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("userEvent", userEvent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsCollectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:collect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.collect" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleApiHttpBody.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Do(opts ...googleapi.CallOption) (*GoogleApiHttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleApiHttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsUserEventsExportCall struct {
	s                                               *Service
	parent                                          string
	googlecloudretailv2alphaexportusereventsrequest *GoogleCloudRetailV2alphaExportUserEventsRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Export: Exports user events. `Operation.response` is of type
// `ExportResponse`. `Operation.metadata` is of type `ExportMetadata`.
//
//   - parent: Resource name of a Catalog. For example
//     `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Export(parent string, googlecloudretailv2alphaexportusereventsrequest *GoogleCloudRetailV2alphaExportUserEventsRequest) *ProjectsLocationsCatalogsUserEventsExportCall {
	c := &ProjectsLocationsCatalogsUserEventsExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaexportusereventsrequest = googlecloudretailv2alphaexportusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUserEventsExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUserEventsExportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaexportusereventsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsUserEventsImportCall struct {
	s                                               *Service
	parent                                          string
	googlecloudretailv2alphaimportusereventsrequest *GoogleCloudRetailV2alphaImportUserEventsRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Import: Bulk import of User events. Request processing might be synchronous.
// Events that already exist are skipped. Use this method for backfilling
// historical user events. `Operation.response` is of type `ImportResponse`.
// Note that it is possible for a subset of the items to be successfully
// inserted. `Operation.metadata` is of type `ImportMetadata`.
//
// - parent: `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Import(parent string, googlecloudretailv2alphaimportusereventsrequest *GoogleCloudRetailV2alphaImportUserEventsRequest) *ProjectsLocationsCatalogsUserEventsImportCall {
	c := &ProjectsLocationsCatalogsUserEventsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphaimportusereventsrequest = googlecloudretailv2alphaimportusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaimportusereventsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsUserEventsPurgeCall struct {
	s                                              *Service
	parent                                         string
	googlecloudretailv2alphapurgeusereventsrequest *GoogleCloudRetailV2alphaPurgeUserEventsRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Purge: Deletes permanently all user events specified by the filter provided.
// Depending on the number of events specified by the filter, this operation
// could take hours or days to complete. To test a filter, use the list command
// first.
//
//   - parent: The resource name of the catalog under which the events are
//     created. The format is
//     `projects/${projectId}/locations/global/catalogs/${catalogId}`.
func (r *ProjectsLocationsCatalogsUserEventsService) Purge(parent string, googlecloudretailv2alphapurgeusereventsrequest *GoogleCloudRetailV2alphaPurgeUserEventsRequest) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c := &ProjectsLocationsCatalogsUserEventsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphapurgeusereventsrequest = googlecloudretailv2alphapurgeusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphapurgeusereventsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.purge" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsUserEventsRejoinCall struct {
	s                                               *Service
	parent                                          string
	googlecloudretailv2alpharejoinusereventsrequest *GoogleCloudRetailV2alphaRejoinUserEventsRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Rejoin: Starts a user-event rejoin operation with latest product catalog.
// Events are not annotated with detailed product information for products that
// are missing from the catalog when the user event is ingested. These events
// are stored as unjoined events with limited usage on training and serving.
// You can use this method to start a join operation on specified events with
// the latest version of product catalog. You can also use this method to
// correct events joined with the wrong product catalog. A rejoin operation can
// take hours or days to complete.
//
//   - parent: The parent catalog resource name, such as
//     `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Rejoin(parent string, googlecloudretailv2alpharejoinusereventsrequest *GoogleCloudRetailV2alphaRejoinUserEventsRequest) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c := &ProjectsLocationsCatalogsUserEventsRejoinCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alpharejoinusereventsrequest = googlecloudretailv2alpharejoinusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alpharejoinusereventsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:rejoin")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.rejoin" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsCatalogsUserEventsWriteCall struct {
	s                                 *Service
	parent                            string
	googlecloudretailv2alphauserevent *GoogleCloudRetailV2alphaUserEvent
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Write: Writes a single user event.
//
//   - parent: The parent catalog resource name, such as
//     `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Write(parent string, googlecloudretailv2alphauserevent *GoogleCloudRetailV2alphaUserEvent) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c := &ProjectsLocationsCatalogsUserEventsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2alphauserevent = googlecloudretailv2alphauserevent
	return c
}

// WriteAsync sets the optional parameter "writeAsync": If set to true, the
// user event will be written asynchronously after validation, and the API will
// respond without waiting for the write. Therefore, silent failures can occur
// even if the API returns success. In case of silent failures, error messages
// can be found in Stackdriver logs.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) WriteAsync(writeAsync bool) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c.urlParams_.Set("writeAsync", fmt.Sprint(writeAsync))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphauserevent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+parent}/userEvents:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.write" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaUserEvent.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaUserEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaUserEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsOperationsService) Get(name string) *ProjectsOperationsGetCall {
	c := &ProjectsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsGetCall) Context(ctx context.Context) *ProjectsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsOperationsService) List(name string) *ProjectsOperationsListCall {
	c := &ProjectsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsOperationsListCall) Filter(filter string) *ProjectsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsOperationsListCall) PageSize(pageSize int64) *ProjectsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsOperationsListCall) PageToken(pageToken string) *ProjectsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsListCall) Context(ctx context.Context) *ProjectsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsRetailProjectAcceptTermsCall struct {
	s                                          *Service
	project                                    string
	googlecloudretailv2alphaaccepttermsrequest *GoogleCloudRetailV2alphaAcceptTermsRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// AcceptTerms: Accepts service terms for this project. By making requests to
// this API, you agree to the terms of service linked below.
// https://cloud.google.com/retail/data-use-terms
//
//   - project: Full resource name of the project. Format:
//     `projects/{project_number_or_id}/retailProject`.
func (r *ProjectsRetailProjectService) AcceptTerms(project string, googlecloudretailv2alphaaccepttermsrequest *GoogleCloudRetailV2alphaAcceptTermsRequest) *ProjectsRetailProjectAcceptTermsCall {
	c := &ProjectsRetailProjectAcceptTermsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.googlecloudretailv2alphaaccepttermsrequest = googlecloudretailv2alphaaccepttermsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRetailProjectAcceptTermsCall) Fields(s ...googleapi.Field) *ProjectsRetailProjectAcceptTermsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRetailProjectAcceptTermsCall) Context(ctx context.Context) *ProjectsRetailProjectAcceptTermsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRetailProjectAcceptTermsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRetailProjectAcceptTermsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2alphaaccepttermsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2alpha/{+project}:acceptTerms")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.retailProject.acceptTerms" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2alphaProject.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsRetailProjectAcceptTermsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2alphaProject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRetailV2alphaProject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
