// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package transcoder provides access to the Transcoder API.
//
// For product documentation, see: https://cloud.google.com/transcoder/docs/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/transcoder/v1"
//	...
//	ctx := context.Background()
//	transcoderService, err := transcoder.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	transcoderService, err := transcoder.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	transcoderService, err := transcoder.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package transcoder // import "google.golang.org/api/transcoder/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "transcoder:v1"
const apiName = "transcoder"
const apiVersion = "v1"
const basePath = "https://transcoder.googleapis.com/"
const mtlsBasePath = "https://transcoder.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.JobTemplates = NewProjectsLocationsJobTemplatesService(s)
	rs.Jobs = NewProjectsLocationsJobsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	JobTemplates *ProjectsLocationsJobTemplatesService

	Jobs *ProjectsLocationsJobsService
}

func NewProjectsLocationsJobTemplatesService(s *Service) *ProjectsLocationsJobTemplatesService {
	rs := &ProjectsLocationsJobTemplatesService{s: s}
	return rs
}

type ProjectsLocationsJobTemplatesService struct {
	s *Service
}

func NewProjectsLocationsJobsService(s *Service) *ProjectsLocationsJobsService {
	rs := &ProjectsLocationsJobsService{s: s}
	return rs
}

type ProjectsLocationsJobsService struct {
	s *Service
}

// AdBreak: Ad break.
type AdBreak struct {
	// StartTimeOffset: Start time in seconds for the ad break, relative to
	// the output file timeline. The default is `0s`.
	StartTimeOffset string `json:"startTimeOffset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StartTimeOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StartTimeOffset") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AdBreak) MarshalJSON() ([]byte, error) {
	type NoMethod AdBreak
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Animation: Animation types.
type Animation struct {
	// AnimationEnd: End previous animation.
	AnimationEnd *AnimationEnd `json:"animationEnd,omitempty"`

	// AnimationFade: Display overlay object with fade animation.
	AnimationFade *AnimationFade `json:"animationFade,omitempty"`

	// AnimationStatic: Display static overlay object.
	AnimationStatic *AnimationStatic `json:"animationStatic,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnimationEnd") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnimationEnd") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Animation) MarshalJSON() ([]byte, error) {
	type NoMethod Animation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnimationEnd: End previous overlay animation from the video. Without
// AnimationEnd, the overlay object will keep the state of previous
// animation until the end of the video.
type AnimationEnd struct {
	// StartTimeOffset: The time to end overlay object, in seconds. Default:
	// 0
	StartTimeOffset string `json:"startTimeOffset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StartTimeOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StartTimeOffset") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AnimationEnd) MarshalJSON() ([]byte, error) {
	type NoMethod AnimationEnd
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnimationFade: Display overlay object with fade animation.
type AnimationFade struct {
	// EndTimeOffset: The time to end the fade animation, in seconds.
	// Default: `start_time_offset` + 1s
	EndTimeOffset string `json:"endTimeOffset,omitempty"`

	// FadeType: Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
	//
	// Possible values:
	//   "FADE_TYPE_UNSPECIFIED" - The fade type is not specified.
	//   "FADE_IN" - Fade the overlay object into view.
	//   "FADE_OUT" - Fade the overlay object out of view.
	FadeType string `json:"fadeType,omitempty"`

	// StartTimeOffset: The time to start the fade animation, in seconds.
	// Default: 0
	StartTimeOffset string `json:"startTimeOffset,omitempty"`

	// Xy: Normalized coordinates based on output video resolution. Valid
	// values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the
	// overlay object. For example, use the x and y coordinates {0,0} to
	// position the top-left corner of the overlay animation in the top-left
	// corner of the output video.
	Xy *NormalizedCoordinate `json:"xy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTimeOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTimeOffset") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AnimationFade) MarshalJSON() ([]byte, error) {
	type NoMethod AnimationFade
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnimationStatic: Display static overlay object.
type AnimationStatic struct {
	// StartTimeOffset: The time to start displaying the overlay object, in
	// seconds. Default: 0
	StartTimeOffset string `json:"startTimeOffset,omitempty"`

	// Xy: Normalized coordinates based on output video resolution. Valid
	// values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the
	// overlay object. For example, use the x and y coordinates {0,0} to
	// position the top-left corner of the overlay animation in the top-left
	// corner of the output video.
	Xy *NormalizedCoordinate `json:"xy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StartTimeOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StartTimeOffset") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AnimationStatic) MarshalJSON() ([]byte, error) {
	type NoMethod AnimationStatic
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Audio: Audio preprocessing configuration.
type Audio struct {
	// HighBoost: Enable boosting high frequency components. The default is
	// `false`. **Note:** This field is not supported.
	HighBoost bool `json:"highBoost,omitempty"`

	// LowBoost: Enable boosting low frequency components. The default is
	// `false`. **Note:** This field is not supported.
	LowBoost bool `json:"lowBoost,omitempty"`

	// Lufs: Specify audio loudness normalization in loudness units relative
	// to full scale (LUFS). Enter a value between -24 and 0 (the default),
	// where: * -24 is the Advanced Television Systems Committee (ATSC A/85)
	// standard * -23 is the EU R128 broadcast standard * -19 is the prior
	// standard for online mono audio * -18 is the ReplayGain standard * -16
	// is the prior standard for stereo audio * -14 is the new online audio
	// standard recommended by Spotify, as well as Amazon Echo * 0 disables
	// normalization
	Lufs float64 `json:"lufs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HighBoost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HighBoost") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Audio) MarshalJSON() ([]byte, error) {
	type NoMethod Audio
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Audio) UnmarshalJSON(data []byte) error {
	type NoMethod Audio
	var s1 struct {
		Lufs gensupport.JSONFloat64 `json:"lufs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Lufs = float64(s1.Lufs)
	return nil
}

// AudioMapping: The mapping for the `Job.edit_list` atoms with audio
// `EditAtom.inputs`.
type AudioMapping struct {
	// AtomKey: Required. The `EditAtom.key` that references the atom with
	// audio inputs in the `Job.edit_list`.
	AtomKey string `json:"atomKey,omitempty"`

	// GainDb: Audio volume control in dB. Negative values decrease volume,
	// positive values increase. The default is 0.
	GainDb float64 `json:"gainDb,omitempty"`

	// InputChannel: Required. The zero-based index of the channel in the
	// input audio stream.
	InputChannel int64 `json:"inputChannel,omitempty"`

	// InputKey: Required. The `Input.key` that identifies the input file.
	InputKey string `json:"inputKey,omitempty"`

	// InputTrack: Required. The zero-based index of the track in the input
	// file.
	InputTrack int64 `json:"inputTrack,omitempty"`

	// OutputChannel: Required. The zero-based index of the channel in the
	// output audio stream.
	OutputChannel int64 `json:"outputChannel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AtomKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AtomKey") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AudioMapping) MarshalJSON() ([]byte, error) {
	type NoMethod AudioMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AudioMapping) UnmarshalJSON(data []byte) error {
	type NoMethod AudioMapping
	var s1 struct {
		GainDb gensupport.JSONFloat64 `json:"gainDb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GainDb = float64(s1.GainDb)
	return nil
}

// AudioStream: Audio stream resource.
type AudioStream struct {
	// BitrateBps: Required. Audio bitrate in bits per second. Must be
	// between 1 and 10,000,000.
	BitrateBps int64 `json:"bitrateBps,omitempty"`

	// ChannelCount: Number of audio channels. Must be between 1 and 6. The
	// default is 2.
	ChannelCount int64 `json:"channelCount,omitempty"`

	// ChannelLayout: A list of channel names specifying layout of the audio
	// channels. This only affects the metadata embedded in the container
	// headers, if supported by the specified format. The default is `["fl",
	// "fr"]`. Supported channel names: - `fl` - Front left channel - `fr` -
	// Front right channel - `sl` - Side left channel - `sr` - Side right
	// channel - `fc` - Front center channel - `lfe` - Low frequency
	ChannelLayout []string `json:"channelLayout,omitempty"`

	// Codec: The codec for this audio stream. The default is `aac`.
	// Supported audio codecs: - `aac` - `aac-he` - `aac-he-v2` - `mp3` -
	// `ac3` - `eac3`
	Codec string `json:"codec,omitempty"`

	// Mapping: The mapping for the `Job.edit_list` atoms with audio
	// `EditAtom.inputs`.
	Mapping []*AudioMapping `json:"mapping,omitempty"`

	// SampleRateHertz: The audio sample rate in Hertz. The default is 48000
	// Hertz.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BitrateBps") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BitrateBps") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AudioStream) MarshalJSON() ([]byte, error) {
	type NoMethod AudioStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BwdifConfig: Bob Weaver Deinterlacing Filter Configuration.
type BwdifConfig struct {
	// DeinterlaceAllFrames: Deinterlace all frames rather than just the
	// frames identified as interlaced. The default is `false`.
	DeinterlaceAllFrames bool `json:"deinterlaceAllFrames,omitempty"`

	// Mode: Specifies the deinterlacing mode to adopt. The default is
	// `send_frame`. Supported values: - `send_frame`: Output one frame for
	// each frame - `send_field`: Output one frame for each field
	Mode string `json:"mode,omitempty"`

	// Parity: The picture field parity assumed for the input interlaced
	// video. The default is `auto`. Supported values: - `tff`: Assume the
	// top field is first - `bff`: Assume the bottom field is first -
	// `auto`: Enable automatic detection of field parity
	Parity string `json:"parity,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeinterlaceAllFrames") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeinterlaceAllFrames") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BwdifConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BwdifConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Color: Color preprocessing configuration. **Note:** This
// configuration is not supported.
type Color struct {
	// Brightness: Control brightness of the video. Enter a value between -1
	// and 1, where -1 is minimum brightness and 1 is maximum brightness. 0
	// is no change. The default is 0.
	Brightness float64 `json:"brightness,omitempty"`

	// Contrast: Control black and white contrast of the video. Enter a
	// value between -1 and 1, where -1 is minimum contrast and 1 is maximum
	// contrast. 0 is no change. The default is 0.
	Contrast float64 `json:"contrast,omitempty"`

	// Saturation: Control color saturation of the video. Enter a value
	// between -1 and 1, where -1 is fully desaturated and 1 is maximum
	// saturation. 0 is no change. The default is 0.
	Saturation float64 `json:"saturation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Brightness") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Brightness") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Color) MarshalJSON() ([]byte, error) {
	type NoMethod Color
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Color) UnmarshalJSON(data []byte) error {
	type NoMethod Color
	var s1 struct {
		Brightness gensupport.JSONFloat64 `json:"brightness"`
		Contrast   gensupport.JSONFloat64 `json:"contrast"`
		Saturation gensupport.JSONFloat64 `json:"saturation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Brightness = float64(s1.Brightness)
	s.Contrast = float64(s1.Contrast)
	s.Saturation = float64(s1.Saturation)
	return nil
}

// Crop: Video cropping configuration for the input video. The cropped
// input video is scaled to match the output resolution.
type Crop struct {
	// BottomPixels: The number of pixels to crop from the bottom. The
	// default is 0.
	BottomPixels int64 `json:"bottomPixels,omitempty"`

	// LeftPixels: The number of pixels to crop from the left. The default
	// is 0.
	LeftPixels int64 `json:"leftPixels,omitempty"`

	// RightPixels: The number of pixels to crop from the right. The default
	// is 0.
	RightPixels int64 `json:"rightPixels,omitempty"`

	// TopPixels: The number of pixels to crop from the top. The default is
	// 0.
	TopPixels int64 `json:"topPixels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BottomPixels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BottomPixels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Crop) MarshalJSON() ([]byte, error) {
	type NoMethod Crop
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Deblock: Deblock preprocessing configuration. **Note:** This
// configuration is not supported.
type Deblock struct {
	// Enabled: Enable deblocker. The default is `false`.
	Enabled bool `json:"enabled,omitempty"`

	// Strength: Set strength of the deblocker. Enter a value between 0 and
	// 1. The higher the value, the stronger the block removal. 0 is no
	// deblocking. The default is 0.
	Strength float64 `json:"strength,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Deblock) MarshalJSON() ([]byte, error) {
	type NoMethod Deblock
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Deblock) UnmarshalJSON(data []byte) error {
	type NoMethod Deblock
	var s1 struct {
		Strength gensupport.JSONFloat64 `json:"strength"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Strength = float64(s1.Strength)
	return nil
}

// Deinterlace: Deinterlace configuration for input video.
type Deinterlace struct {
	// Bwdif: Specifies the Bob Weaver Deinterlacing Filter Configuration.
	Bwdif *BwdifConfig `json:"bwdif,omitempty"`

	// Yadif: Specifies the Yet Another Deinterlacing Filter Configuration.
	Yadif *YadifConfig `json:"yadif,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bwdif") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bwdif") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Deinterlace) MarshalJSON() ([]byte, error) {
	type NoMethod Deinterlace
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Denoise: Denoise preprocessing configuration. **Note:** This
// configuration is not supported.
type Denoise struct {
	// Strength: Set strength of the denoise. Enter a value between 0 and 1.
	// The higher the value, the smoother the image. 0 is no denoising. The
	// default is 0.
	Strength float64 `json:"strength,omitempty"`

	// Tune: Set the denoiser mode. The default is `standard`. Supported
	// denoiser modes: - `standard` - `grain`
	Tune string `json:"tune,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Strength") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Strength") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Denoise) MarshalJSON() ([]byte, error) {
	type NoMethod Denoise
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Denoise) UnmarshalJSON(data []byte) error {
	type NoMethod Denoise
	var s1 struct {
		Strength gensupport.JSONFloat64 `json:"strength"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Strength = float64(s1.Strength)
	return nil
}

// EditAtom: Edit atom.
type EditAtom struct {
	// EndTimeOffset: End time in seconds for the atom, relative to the
	// input file timeline. When `end_time_offset` is not specified, the
	// `inputs` are used until the end of the atom.
	EndTimeOffset string `json:"endTimeOffset,omitempty"`

	// Inputs: List of `Input.key`s identifying files that should be used in
	// this atom. The listed `inputs` must have the same timeline.
	Inputs []string `json:"inputs,omitempty"`

	// Key: A unique key for this atom. Must be specified when using
	// advanced mapping.
	Key string `json:"key,omitempty"`

	// StartTimeOffset: Start time in seconds for the atom, relative to the
	// input file timeline. The default is `0s`.
	StartTimeOffset string `json:"startTimeOffset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTimeOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTimeOffset") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EditAtom) MarshalJSON() ([]byte, error) {
	type NoMethod EditAtom
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ElementaryStream: Encoding of an input file such as an audio, video,
// or text track. Elementary streams must be packaged before mapping and
// sharing between different output formats.
type ElementaryStream struct {
	// AudioStream: Encoding of an audio stream.
	AudioStream *AudioStream `json:"audioStream,omitempty"`

	// Key: A unique key for this elementary stream.
	Key string `json:"key,omitempty"`

	// TextStream: Encoding of a text stream. For example, closed captions
	// or subtitles.
	TextStream *TextStream `json:"textStream,omitempty"`

	// VideoStream: Encoding of a video stream.
	VideoStream *VideoStream `json:"videoStream,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AudioStream") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AudioStream") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ElementaryStream) MarshalJSON() ([]byte, error) {
	type NoMethod ElementaryStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// H264CodecSettings: H264 codec settings.
type H264CodecSettings struct {
	// AllowOpenGop: Specifies whether an open Group of Pictures (GOP)
	// structure should be allowed or not. The default is `false`.
	AllowOpenGop bool `json:"allowOpenGop,omitempty"`

	// AqStrength: Specify the intensity of the adaptive quantizer (AQ).
	// Must be between 0 and 1, where 0 disables the quantizer and 1
	// maximizes the quantizer. A higher value equals a lower bitrate but
	// smoother image. The default is 0.
	AqStrength float64 `json:"aqStrength,omitempty"`

	// BFrameCount: The number of consecutive B-frames. Must be greater than
	// or equal to zero. Must be less than `VideoStream.gop_frame_count` if
	// set. The default is 0.
	BFrameCount int64 `json:"bFrameCount,omitempty"`

	// BPyramid: Allow B-pyramid for reference frame selection. This may not
	// be supported on all decoders. The default is `false`.
	BPyramid bool `json:"bPyramid,omitempty"`

	// BitrateBps: Required. The video bitrate in bits per second. The
	// minimum value is 1,000. The maximum value is 800,000,000.
	BitrateBps int64 `json:"bitrateBps,omitempty"`

	// CrfLevel: Target CRF level. Must be between 10 and 36, where 10 is
	// the highest quality and 36 is the most efficient compression. The
	// default is 21.
	CrfLevel int64 `json:"crfLevel,omitempty"`

	// EnableTwoPass: Use two-pass encoding strategy to achieve better video
	// quality. `VideoStream.rate_control_mode` must be `vbr`. The default
	// is `false`.
	EnableTwoPass bool `json:"enableTwoPass,omitempty"`

	// EntropyCoder: The entropy coder to use. The default is `cabac`.
	// Supported entropy coders: - `cavlc` - `cabac`
	EntropyCoder string `json:"entropyCoder,omitempty"`

	// FrameRate: Required. The target video frame rate in frames per second
	// (FPS). Must be less than or equal to 120. Will default to the input
	// frame rate if larger than the input frame rate. The API will generate
	// an output FPS that is divisible by the input FPS, and smaller or
	// equal to the target FPS. See Calculating frame rate
	// (https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
	// more information.
	FrameRate float64 `json:"frameRate,omitempty"`

	// GopDuration: Select the GOP size based on the specified duration. The
	// default is `3s`. Note that `gopDuration` must be less than or equal
	// to `segmentDuration` (#SegmentSettings), and `segmentDuration`
	// (#SegmentSettings) must be divisible by `gopDuration`.
	GopDuration string `json:"gopDuration,omitempty"`

	// GopFrameCount: Select the GOP size based on the specified frame
	// count. Must be greater than zero.
	GopFrameCount int64 `json:"gopFrameCount,omitempty"`

	// HeightPixels: The height of the video in pixels. Must be an even
	// integer. When not specified, the height is adjusted to match the
	// specified width and input aspect ratio. If both are omitted, the
	// input height is used. For portrait videos that contain horizontal ASR
	// and rotation metadata, provide the height, in pixels, per the
	// horizontal ASR. The API calculates the width per the horizontal ASR.
	// The API detects any rotation metadata and swaps the requested height
	// and width for the output.
	HeightPixels int64 `json:"heightPixels,omitempty"`

	// PixelFormat: Pixel format to use. The default is `yuv420p`. Supported
	// pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format -
	// `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format -
	// `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel
	// format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR
	// pixel format - `yuv444p12` 12-bit HDR pixel format
	PixelFormat string `json:"pixelFormat,omitempty"`

	// Preset: Enforces the specified codec preset. The default is
	// `veryfast`. The available options are FFmpeg-compatible
	// (https://trac.ffmpeg.org/wiki/Encode/H.264#Preset). Note that certain
	// values for this field may cause the transcoder to override other
	// fields you set in the `H264CodecSettings` message.
	Preset string `json:"preset,omitempty"`

	// Profile: Enforces the specified codec profile. The following profiles
	// are supported: * `baseline` * `main` * `high` (default) The available
	// options are FFmpeg-compatible
	// (https://trac.ffmpeg.org/wiki/Encode/H.264#Tune). Note that certain
	// values for this field may cause the transcoder to override other
	// fields you set in the `H264CodecSettings` message.
	Profile string `json:"profile,omitempty"`

	// RateControlMode: Specify the `rate_control_mode`. The default is
	// `vbr`. Supported rate control modes: - `vbr` - variable bitrate -
	// `crf` - constant rate factor
	RateControlMode string `json:"rateControlMode,omitempty"`

	// Tune: Enforces the specified codec tune. The available options are
	// FFmpeg-compatible (https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
	// Note that certain values for this field may cause the transcoder to
	// override other fields you set in the `H264CodecSettings` message.
	Tune string `json:"tune,omitempty"`

	// VbvFullnessBits: Initial fullness of the Video Buffering Verifier
	// (VBV) buffer in bits. Must be greater than zero. The default is equal
	// to 90% of `VideoStream.vbv_size_bits`.
	VbvFullnessBits int64 `json:"vbvFullnessBits,omitempty"`

	// VbvSizeBits: Size of the Video Buffering Verifier (VBV) buffer in
	// bits. Must be greater than zero. The default is equal to
	// `VideoStream.bitrate_bps`.
	VbvSizeBits int64 `json:"vbvSizeBits,omitempty"`

	// WidthPixels: The width of the video in pixels. Must be an even
	// integer. When not specified, the width is adjusted to match the
	// specified height and input aspect ratio. If both are omitted, the
	// input width is used. For portrait videos that contain horizontal ASR
	// and rotation metadata, provide the width, in pixels, per the
	// horizontal ASR. The API calculates the height per the horizontal ASR.
	// The API detects any rotation metadata and swaps the requested height
	// and width for the output.
	WidthPixels int64 `json:"widthPixels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowOpenGop") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowOpenGop") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *H264CodecSettings) MarshalJSON() ([]byte, error) {
	type NoMethod H264CodecSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *H264CodecSettings) UnmarshalJSON(data []byte) error {
	type NoMethod H264CodecSettings
	var s1 struct {
		AqStrength gensupport.JSONFloat64 `json:"aqStrength"`
		FrameRate  gensupport.JSONFloat64 `json:"frameRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AqStrength = float64(s1.AqStrength)
	s.FrameRate = float64(s1.FrameRate)
	return nil
}

// H265CodecSettings: H265 codec settings.
type H265CodecSettings struct {
	// AllowOpenGop: Specifies whether an open Group of Pictures (GOP)
	// structure should be allowed or not. The default is `false`.
	AllowOpenGop bool `json:"allowOpenGop,omitempty"`

	// AqStrength: Specify the intensity of the adaptive quantizer (AQ).
	// Must be between 0 and 1, where 0 disables the quantizer and 1
	// maximizes the quantizer. A higher value equals a lower bitrate but
	// smoother image. The default is 0.
	AqStrength float64 `json:"aqStrength,omitempty"`

	// BFrameCount: The number of consecutive B-frames. Must be greater than
	// or equal to zero. Must be less than `VideoStream.gop_frame_count` if
	// set. The default is 0.
	BFrameCount int64 `json:"bFrameCount,omitempty"`

	// BPyramid: Allow B-pyramid for reference frame selection. This may not
	// be supported on all decoders. The default is `false`.
	BPyramid bool `json:"bPyramid,omitempty"`

	// BitrateBps: Required. The video bitrate in bits per second. The
	// minimum value is 1,000. The maximum value is 800,000,000.
	BitrateBps int64 `json:"bitrateBps,omitempty"`

	// CrfLevel: Target CRF level. Must be between 10 and 36, where 10 is
	// the highest quality and 36 is the most efficient compression. The
	// default is 21.
	CrfLevel int64 `json:"crfLevel,omitempty"`

	// EnableTwoPass: Use two-pass encoding strategy to achieve better video
	// quality. `VideoStream.rate_control_mode` must be `vbr`. The default
	// is `false`.
	EnableTwoPass bool `json:"enableTwoPass,omitempty"`

	// FrameRate: Required. The target video frame rate in frames per second
	// (FPS). Must be less than or equal to 120. Will default to the input
	// frame rate if larger than the input frame rate. The API will generate
	// an output FPS that is divisible by the input FPS, and smaller or
	// equal to the target FPS. See Calculating frame rate
	// (https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
	// more information.
	FrameRate float64 `json:"frameRate,omitempty"`

	// GopDuration: Select the GOP size based on the specified duration. The
	// default is `3s`. Note that `gopDuration` must be less than or equal
	// to `segmentDuration` (#SegmentSettings), and `segmentDuration`
	// (#SegmentSettings) must be divisible by `gopDuration`.
	GopDuration string `json:"gopDuration,omitempty"`

	// GopFrameCount: Select the GOP size based on the specified frame
	// count. Must be greater than zero.
	GopFrameCount int64 `json:"gopFrameCount,omitempty"`

	// HeightPixels: The height of the video in pixels. Must be an even
	// integer. When not specified, the height is adjusted to match the
	// specified width and input aspect ratio. If both are omitted, the
	// input height is used. For portrait videos that contain horizontal ASR
	// and rotation metadata, provide the height, in pixels, per the
	// horizontal ASR. The API calculates the width per the horizontal ASR.
	// The API detects any rotation metadata and swaps the requested height
	// and width for the output.
	HeightPixels int64 `json:"heightPixels,omitempty"`

	// PixelFormat: Pixel format to use. The default is `yuv420p`. Supported
	// pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format -
	// `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format -
	// `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel
	// format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR
	// pixel format - `yuv444p12` 12-bit HDR pixel format
	PixelFormat string `json:"pixelFormat,omitempty"`

	// Preset: Enforces the specified codec preset. The default is
	// `veryfast`. The available options are FFmpeg-compatible
	// (https://trac.ffmpeg.org/wiki/Encode/H.265). Note that certain values
	// for this field may cause the transcoder to override other fields you
	// set in the `H265CodecSettings` message.
	Preset string `json:"preset,omitempty"`

	// Profile: Enforces the specified codec profile. The following profiles
	// are supported: * 8-bit profiles * `main` (default) * `main-intra` *
	// `mainstillpicture` * 10-bit profiles * `main10` (default) *
	// `main10-intra` * `main422-10` * `main422-10-intra` * `main444-10` *
	// `main444-10-intra` * 12-bit profiles * `main12` (default) *
	// `main12-intra` * `main422-12` * `main422-12-intra` * `main444-12` *
	// `main444-12-intra` The available options are FFmpeg-compatible
	// (https://x265.readthedocs.io/). Note that certain values for this
	// field may cause the transcoder to override other fields you set in
	// the `H265CodecSettings` message.
	Profile string `json:"profile,omitempty"`

	// RateControlMode: Specify the `rate_control_mode`. The default is
	// `vbr`. Supported rate control modes: - `vbr` - variable bitrate -
	// `crf` - constant rate factor
	RateControlMode string `json:"rateControlMode,omitempty"`

	// Tune: Enforces the specified codec tune. The available options are
	// FFmpeg-compatible (https://trac.ffmpeg.org/wiki/Encode/H.265). Note
	// that certain values for this field may cause the transcoder to
	// override other fields you set in the `H265CodecSettings` message.
	Tune string `json:"tune,omitempty"`

	// VbvFullnessBits: Initial fullness of the Video Buffering Verifier
	// (VBV) buffer in bits. Must be greater than zero. The default is equal
	// to 90% of `VideoStream.vbv_size_bits`.
	VbvFullnessBits int64 `json:"vbvFullnessBits,omitempty"`

	// VbvSizeBits: Size of the Video Buffering Verifier (VBV) buffer in
	// bits. Must be greater than zero. The default is equal to
	// `VideoStream.bitrate_bps`.
	VbvSizeBits int64 `json:"vbvSizeBits,omitempty"`

	// WidthPixels: The width of the video in pixels. Must be an even
	// integer. When not specified, the width is adjusted to match the
	// specified height and input aspect ratio. If both are omitted, the
	// input width is used. For portrait videos that contain horizontal ASR
	// and rotation metadata, provide the width, in pixels, per the
	// horizontal ASR. The API calculates the height per the horizontal ASR.
	// The API detects any rotation metadata and swaps the requested height
	// and width for the output.
	WidthPixels int64 `json:"widthPixels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowOpenGop") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowOpenGop") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *H265CodecSettings) MarshalJSON() ([]byte, error) {
	type NoMethod H265CodecSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *H265CodecSettings) UnmarshalJSON(data []byte) error {
	type NoMethod H265CodecSettings
	var s1 struct {
		AqStrength gensupport.JSONFloat64 `json:"aqStrength"`
		FrameRate  gensupport.JSONFloat64 `json:"frameRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AqStrength = float64(s1.AqStrength)
	s.FrameRate = float64(s1.FrameRate)
	return nil
}

// Image: Overlaid jpeg image.
type Image struct {
	// Alpha: Target image opacity. Valid values are from `1.0` (solid,
	// default) to `0.0` (transparent), exclusive. Set this to a value
	// greater than `0.0`.
	Alpha float64 `json:"alpha,omitempty"`

	// Resolution: Normalized image resolution, based on output video
	// resolution. Valid values: `0.0`–`1.0`. To respect the original
	// image aspect ratio, set either `x` or `y` to `0.0`. To use the
	// original image resolution, set both `x` and `y` to `0.0`.
	Resolution *NormalizedCoordinate `json:"resolution,omitempty"`

	// Uri: Required. URI of the JPEG image in Cloud Storage. For example,
	// `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image
	// type.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alpha") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Image) UnmarshalJSON(data []byte) error {
	type NoMethod Image
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	return nil
}

// Input: Input asset.
type Input struct {
	// Key: A unique key for this input. Must be specified when using
	// advanced mapping and edit lists.
	Key string `json:"key,omitempty"`

	// PreprocessingConfig: Preprocessing configurations.
	PreprocessingConfig *PreprocessingConfig `json:"preprocessingConfig,omitempty"`

	// Uri: URI of the media. Input files must be at least 5 seconds in
	// duration and stored in Cloud Storage (for example,
	// `gs://bucket/inputs/file.mp4`). If empty, the value is populated from
	// `Job.input_uri`. See Supported input and output formats
	// (https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Input) MarshalJSON() ([]byte, error) {
	type NoMethod Input
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Job: Transcoding job resource.
type Job struct {
	// Config: The configuration for this job.
	Config *JobConfig `json:"config,omitempty"`

	// CreateTime: Output only. The time the job was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the transcoding finished.
	EndTime string `json:"endTime,omitempty"`

	// Error: Output only. An error object that describes the reason for the
	// failure. This property is always present when `state` is `FAILED`.
	Error *Status `json:"error,omitempty"`

	// InputUri: Input only. Specify the `input_uri` to populate empty `uri`
	// fields in each element of `Job.config.inputs` or
	// `JobTemplate.config.inputs` when using template. URI of the media.
	// Input files must be at least 5 seconds in duration and stored in
	// Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
	// Supported input and output formats
	// (https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	InputUri string `json:"inputUri,omitempty"`

	// Labels: The labels associated with this job. You can use these to
	// organize and group your jobs.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: The resource name of the job. Format:
	// `projects/{project_number}/locations/{location}/jobs/{job}`
	Name string `json:"name,omitempty"`

	// OutputUri: Input only. Specify the `output_uri` to populate an empty
	// `Job.config.output.uri` or `JobTemplate.config.output.uri` when using
	// template. URI for the output file(s). For example,
	// `gs://my-bucket/outputs/`. See Supported input and output formats
	// (https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	OutputUri string `json:"outputUri,omitempty"`

	// StartTime: Output only. The time the transcoding started.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The current state of the job.
	//
	// Possible values:
	//   "PROCESSING_STATE_UNSPECIFIED" - The processing state is not
	// specified.
	//   "PENDING" - The job is enqueued and will be picked up for
	// processing soon.
	//   "RUNNING" - The job is being processed.
	//   "SUCCEEDED" - The job has been completed successfully.
	//   "FAILED" - The job has failed. For additional information, see
	// `failure_reason` and `failure_details`
	State string `json:"state,omitempty"`

	// TemplateId: Input only. Specify the `template_id` to use for
	// populating `Job.config`. The default is `preset/web-hd`. Preset
	// Transcoder templates: - `preset/{preset_id}` - User defined
	// JobTemplate: `{job_template_id}`
	TemplateId string `json:"templateId,omitempty"`

	// TtlAfterCompletionDays: Job time to live value in days, which will be
	// effective after job completion. Job should be deleted automatically
	// after the given TTL. Enter a value between 1 and 90. The default is
	// 30.
	TtlAfterCompletionDays int64 `json:"ttlAfterCompletionDays,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Job) MarshalJSON() ([]byte, error) {
	type NoMethod Job
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobConfig: Job configuration
type JobConfig struct {
	// AdBreaks: List of ad breaks. Specifies where to insert ad break tags
	// in the output manifests.
	AdBreaks []*AdBreak `json:"adBreaks,omitempty"`

	// EditList: List of `Edit atom`s. Defines the ultimate timeline of the
	// resulting file or manifest.
	EditList []*EditAtom `json:"editList,omitempty"`

	// ElementaryStreams: List of elementary streams.
	ElementaryStreams []*ElementaryStream `json:"elementaryStreams,omitempty"`

	// Inputs: List of input assets stored in Cloud Storage.
	Inputs []*Input `json:"inputs,omitempty"`

	// Manifests: List of output manifests.
	Manifests []*Manifest `json:"manifests,omitempty"`

	// MuxStreams: List of multiplexing settings for output streams.
	MuxStreams []*MuxStream `json:"muxStreams,omitempty"`

	// Output: Output configuration.
	Output *Output `json:"output,omitempty"`

	// Overlays: List of overlays on the output video, in descending
	// Z-order.
	Overlays []*Overlay `json:"overlays,omitempty"`

	// PubsubDestination: Destination on Pub/Sub.
	PubsubDestination *PubsubDestination `json:"pubsubDestination,omitempty"`

	// SpriteSheets: List of output sprite sheets. Spritesheets require at
	// least one VideoStream in the Jobconfig.
	SpriteSheets []*SpriteSheet `json:"spriteSheets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdBreaks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdBreaks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *JobConfig) MarshalJSON() ([]byte, error) {
	type NoMethod JobConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobTemplate: Transcoding job template resource.
type JobTemplate struct {
	// Config: The configuration for this template.
	Config *JobConfig `json:"config,omitempty"`

	// Labels: The labels associated with this job template. You can use
	// these to organize and group your job templates.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: The resource name of the job template. Format:
	// `projects/{project_number}/locations/{location}/jobTemplates/{job_temp
	// late}`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *JobTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod JobTemplate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListJobTemplatesResponse: Response message for
// `TranscoderService.ListJobTemplates`.
type ListJobTemplatesResponse struct {
	// JobTemplates: List of job templates in the specified region.
	JobTemplates []*JobTemplate `json:"jobTemplates,omitempty"`

	// NextPageToken: The pagination token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: List of regions that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "JobTemplates") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JobTemplates") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListJobTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListJobTemplatesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListJobsResponse: Response message for `TranscoderService.ListJobs`.
type ListJobsResponse struct {
	// Jobs: List of jobs in the specified region.
	Jobs []*Job `json:"jobs,omitempty"`

	// NextPageToken: The pagination token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: List of regions that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Jobs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Jobs") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Manifest: Manifest configuration.
type Manifest struct {
	// FileName: The name of the generated file. The default is `manifest`
	// with the extension suffix corresponding to the `Manifest.type`.
	FileName string `json:"fileName,omitempty"`

	// MuxStreams: Required. List of user given `MuxStream.key`s that should
	// appear in this manifest. When `Manifest.type` is `HLS`, a media
	// manifest with name `MuxStream.key` and `.m3u8` extension is generated
	// for each element of the `Manifest.mux_streams`.
	MuxStreams []string `json:"muxStreams,omitempty"`

	// Type: Required. Type of the manifest, can be `HLS` or `DASH`.
	//
	// Possible values:
	//   "MANIFEST_TYPE_UNSPECIFIED" - The manifest type is not specified.
	//   "HLS" - Create `HLS` manifest. The corresponding file extension is
	// `.m3u8`.
	//   "DASH" - Create `DASH` manifest. The corresponding file extension
	// is `.mpd`.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Manifest) MarshalJSON() ([]byte, error) {
	type NoMethod Manifest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MuxStream: Multiplexing settings for output stream.
type MuxStream struct {
	// Container: The container format. The default is `mp4` Supported
	// container formats: - `ts` - `fmp4`- the corresponding file extension
	// is `.m4s` - `mp4` - `vtt` See also: Supported input and output
	// formats
	// (https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
	Container string `json:"container,omitempty"`

	// ElementaryStreams: List of `ElementaryStream.key`s multiplexed in
	// this stream.
	ElementaryStreams []string `json:"elementaryStreams,omitempty"`

	// FileName: The name of the generated file. The default is
	// `MuxStream.key` with the extension suffix corresponding to the
	// `MuxStream.container`. Individual segments also have an incremental
	// 10-digit zero-padded suffix starting from 0 before the extension,
	// such as `mux_stream0000000123.ts`.
	FileName string `json:"fileName,omitempty"`

	// Key: A unique key for this multiplexed stream. HLS media manifests
	// will be named `MuxStream.key` with the `.m3u8` extension suffix.
	Key string `json:"key,omitempty"`

	// SegmentSettings: Segment settings for `ts`, `fmp4` and `vtt`.
	SegmentSettings *SegmentSettings `json:"segmentSettings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Container") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Container") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MuxStream) MarshalJSON() ([]byte, error) {
	type NoMethod MuxStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NormalizedCoordinate: 2D normalized coordinates. Default: `{0.0,
// 0.0}`
type NormalizedCoordinate struct {
	// X: Normalized x coordinate.
	X float64 `json:"x,omitempty"`

	// Y: Normalized y coordinate.
	Y float64 `json:"y,omitempty"`

	// ForceSendFields is a list of field names (e.g. "X") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "X") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NormalizedCoordinate) MarshalJSON() ([]byte, error) {
	type NoMethod NormalizedCoordinate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *NormalizedCoordinate) UnmarshalJSON(data []byte) error {
	type NoMethod NormalizedCoordinate
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// Output: Location of output file(s) in a Cloud Storage bucket.
type Output struct {
	// Uri: URI for the output file(s). For example,
	// `gs://my-bucket/outputs/`. If empty, the value is populated from
	// `Job.output_uri`. See Supported input and output formats
	// (https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Output) MarshalJSON() ([]byte, error) {
	type NoMethod Output
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Overlay: Overlay configuration.
type Overlay struct {
	// Animations: List of Animations. The list should be chronological,
	// without any time overlap.
	Animations []*Animation `json:"animations,omitempty"`

	// Image: Image overlay.
	Image *Image `json:"image,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Animations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Animations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Overlay) MarshalJSON() ([]byte, error) {
	type NoMethod Overlay
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Pad: Pad filter configuration for the input video. The padded input
// video is scaled after padding with black to match the output
// resolution.
type Pad struct {
	// BottomPixels: The number of pixels to add to the bottom. The default
	// is 0.
	BottomPixels int64 `json:"bottomPixels,omitempty"`

	// LeftPixels: The number of pixels to add to the left. The default is
	// 0.
	LeftPixels int64 `json:"leftPixels,omitempty"`

	// RightPixels: The number of pixels to add to the right. The default is
	// 0.
	RightPixels int64 `json:"rightPixels,omitempty"`

	// TopPixels: The number of pixels to add to the top. The default is 0.
	TopPixels int64 `json:"topPixels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BottomPixels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BottomPixels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Pad) MarshalJSON() ([]byte, error) {
	type NoMethod Pad
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PreprocessingConfig: Preprocessing configurations.
type PreprocessingConfig struct {
	// Audio: Audio preprocessing configuration.
	Audio *Audio `json:"audio,omitempty"`

	// Color: Color preprocessing configuration.
	Color *Color `json:"color,omitempty"`

	// Crop: Specify the video cropping configuration.
	Crop *Crop `json:"crop,omitempty"`

	// Deblock: Deblock preprocessing configuration.
	Deblock *Deblock `json:"deblock,omitempty"`

	// Deinterlace: Specify the video deinterlace configuration.
	Deinterlace *Deinterlace `json:"deinterlace,omitempty"`

	// Denoise: Denoise preprocessing configuration.
	Denoise *Denoise `json:"denoise,omitempty"`

	// Pad: Specify the video pad filter configuration.
	Pad *Pad `json:"pad,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PreprocessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PreprocessingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PubsubDestination: A Pub/Sub destination.
type PubsubDestination struct {
	// Topic: The name of the Pub/Sub topic to publish job completion
	// notification to. For example: `projects/{project}/topics/{topic}`.
	Topic string `json:"topic,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Topic") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Topic") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PubsubDestination) MarshalJSON() ([]byte, error) {
	type NoMethod PubsubDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SegmentSettings: Segment settings for `ts`, `fmp4` and `vtt`.
type SegmentSettings struct {
	// IndividualSegments: Required. Create an individual segment file. The
	// default is `false`.
	IndividualSegments bool `json:"individualSegments,omitempty"`

	// SegmentDuration: Duration of the segments in seconds. The default is
	// `6.0s`. Note that `segmentDuration` must be greater than or equal to
	// `gopDuration` (#videostream), and `segmentDuration` must be divisible
	// by `gopDuration` (#videostream).
	SegmentDuration string `json:"segmentDuration,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IndividualSegments")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IndividualSegments") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SegmentSettings) MarshalJSON() ([]byte, error) {
	type NoMethod SegmentSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SpriteSheet: Sprite sheet configuration.
type SpriteSheet struct {
	// ColumnCount: The maximum number of sprites per row in a sprite sheet.
	// The default is 0, which indicates no maximum limit.
	ColumnCount int64 `json:"columnCount,omitempty"`

	// EndTimeOffset: End time in seconds, relative to the output file
	// timeline. When `end_time_offset` is not specified, the sprites are
	// generated until the end of the output file.
	EndTimeOffset string `json:"endTimeOffset,omitempty"`

	// FilePrefix: Required. File name prefix for the generated sprite
	// sheets. Each sprite sheet has an incremental 10-digit zero-padded
	// suffix starting from 0 before the extension, such as
	// `sprite_sheet0000000123.jpeg`.
	FilePrefix string `json:"filePrefix,omitempty"`

	// Format: Format type. The default is `jpeg`. Supported formats: -
	// `jpeg`
	Format string `json:"format,omitempty"`

	// Interval: Starting from `0s`, create sprites at regular intervals.
	// Specify the interval value in seconds.
	Interval string `json:"interval,omitempty"`

	// Quality: The quality of the generated sprite sheet. Enter a value
	// between 1 and 100, where 1 is the lowest quality and 100 is the
	// highest quality. The default is 100. A high quality value corresponds
	// to a low image data compression ratio.
	Quality int64 `json:"quality,omitempty"`

	// RowCount: The maximum number of rows per sprite sheet. When the
	// sprite sheet is full, a new sprite sheet is created. The default is
	// 0, which indicates no maximum limit.
	RowCount int64 `json:"rowCount,omitempty"`

	// SpriteHeightPixels: Required. The height of sprite in pixels. Must be
	// an even integer. To preserve the source aspect ratio, set the
	// SpriteSheet.sprite_height_pixels field or the
	// SpriteSheet.sprite_width_pixels field, but not both (the API will
	// automatically calculate the missing field). For portrait videos that
	// contain horizontal ASR and rotation metadata, provide the height, in
	// pixels, per the horizontal ASR. The API calculates the width per the
	// horizontal ASR. The API detects any rotation metadata and swaps the
	// requested height and width for the output.
	SpriteHeightPixels int64 `json:"spriteHeightPixels,omitempty"`

	// SpriteWidthPixels: Required. The width of sprite in pixels. Must be
	// an even integer. To preserve the source aspect ratio, set the
	// SpriteSheet.sprite_width_pixels field or the
	// SpriteSheet.sprite_height_pixels field, but not both (the API will
	// automatically calculate the missing field). For portrait videos that
	// contain horizontal ASR and rotation metadata, provide the width, in
	// pixels, per the horizontal ASR. The API calculates the height per the
	// horizontal ASR. The API detects any rotation metadata and swaps the
	// requested height and width for the output.
	SpriteWidthPixels int64 `json:"spriteWidthPixels,omitempty"`

	// StartTimeOffset: Start time in seconds, relative to the output file
	// timeline. Determines the first sprite to pick. The default is `0s`.
	StartTimeOffset string `json:"startTimeOffset,omitempty"`

	// TotalCount: Total number of sprites. Create the specified number of
	// sprites distributed evenly across the timeline of the output media.
	// The default is 100.
	TotalCount int64 `json:"totalCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColumnCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColumnCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SpriteSheet) MarshalJSON() ([]byte, error) {
	type NoMethod SpriteSheet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TextMapping: The mapping for the `Job.edit_list` atoms with text
// `EditAtom.inputs`.
type TextMapping struct {
	// AtomKey: Required. The `EditAtom.key` that references atom with text
	// inputs in the `Job.edit_list`.
	AtomKey string `json:"atomKey,omitempty"`

	// InputKey: Required. The `Input.key` that identifies the input file.
	InputKey string `json:"inputKey,omitempty"`

	// InputTrack: Required. The zero-based index of the track in the input
	// file.
	InputTrack int64 `json:"inputTrack,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AtomKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AtomKey") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TextMapping) MarshalJSON() ([]byte, error) {
	type NoMethod TextMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TextStream: Encoding of a text stream. For example, closed captions
// or subtitles.
type TextStream struct {
	// Codec: The codec for this text stream. The default is `webvtt`.
	// Supported text codecs: - `srt` - `ttml` - `cea608` - `cea708` -
	// `webvtt`
	Codec string `json:"codec,omitempty"`

	// Mapping: The mapping for the `Job.edit_list` atoms with text
	// `EditAtom.inputs`.
	Mapping []*TextMapping `json:"mapping,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Codec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Codec") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TextStream) MarshalJSON() ([]byte, error) {
	type NoMethod TextStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VideoStream: Video stream resource.
type VideoStream struct {
	// H264: H264 codec settings.
	H264 *H264CodecSettings `json:"h264,omitempty"`

	// H265: H265 codec settings.
	H265 *H265CodecSettings `json:"h265,omitempty"`

	// Vp9: VP9 codec settings.
	Vp9 *Vp9CodecSettings `json:"vp9,omitempty"`

	// ForceSendFields is a list of field names (e.g. "H264") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "H264") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VideoStream) MarshalJSON() ([]byte, error) {
	type NoMethod VideoStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Vp9CodecSettings: VP9 codec settings.
type Vp9CodecSettings struct {
	// BitrateBps: Required. The video bitrate in bits per second. The
	// minimum value is 1,000. The maximum value is 480,000,000.
	BitrateBps int64 `json:"bitrateBps,omitempty"`

	// CrfLevel: Target CRF level. Must be between 10 and 36, where 10 is
	// the highest quality and 36 is the most efficient compression. The
	// default is 21. **Note:** This field is not supported.
	CrfLevel int64 `json:"crfLevel,omitempty"`

	// FrameRate: Required. The target video frame rate in frames per second
	// (FPS). Must be less than or equal to 120. Will default to the input
	// frame rate if larger than the input frame rate. The API will generate
	// an output FPS that is divisible by the input FPS, and smaller or
	// equal to the target FPS. See Calculating frame rate
	// (https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
	// more information.
	FrameRate float64 `json:"frameRate,omitempty"`

	// GopDuration: Select the GOP size based on the specified duration. The
	// default is `3s`. Note that `gopDuration` must be less than or equal
	// to `segmentDuration` (#SegmentSettings), and `segmentDuration`
	// (#SegmentSettings) must be divisible by `gopDuration`.
	GopDuration string `json:"gopDuration,omitempty"`

	// GopFrameCount: Select the GOP size based on the specified frame
	// count. Must be greater than zero.
	GopFrameCount int64 `json:"gopFrameCount,omitempty"`

	// HeightPixels: The height of the video in pixels. Must be an even
	// integer. When not specified, the height is adjusted to match the
	// specified width and input aspect ratio. If both are omitted, the
	// input height is used. For portrait videos that contain horizontal ASR
	// and rotation metadata, provide the height, in pixels, per the
	// horizontal ASR. The API calculates the width per the horizontal ASR.
	// The API detects any rotation metadata and swaps the requested height
	// and width for the output.
	HeightPixels int64 `json:"heightPixels,omitempty"`

	// PixelFormat: Pixel format to use. The default is `yuv420p`. Supported
	// pixel formats: - `yuv420p` pixel format - `yuv422p` pixel format -
	// `yuv444p` pixel format - `yuv420p10` 10-bit HDR pixel format -
	// `yuv422p10` 10-bit HDR pixel format - `yuv444p10` 10-bit HDR pixel
	// format - `yuv420p12` 12-bit HDR pixel format - `yuv422p12` 12-bit HDR
	// pixel format - `yuv444p12` 12-bit HDR pixel format
	PixelFormat string `json:"pixelFormat,omitempty"`

	// Profile: Enforces the specified codec profile. The following profiles
	// are supported: * `profile0` (default) * `profile1` * `profile2` *
	// `profile3` The available options are WebM-compatible
	// (https://www.webmproject.org/vp9/profiles/). Note that certain values
	// for this field may cause the transcoder to override other fields you
	// set in the `Vp9CodecSettings` message.
	Profile string `json:"profile,omitempty"`

	// RateControlMode: Specify the `rate_control_mode`. The default is
	// `vbr`. Supported rate control modes: - `vbr` - variable bitrate
	RateControlMode string `json:"rateControlMode,omitempty"`

	// WidthPixels: The width of the video in pixels. Must be an even
	// integer. When not specified, the width is adjusted to match the
	// specified height and input aspect ratio. If both are omitted, the
	// input width is used. For portrait videos that contain horizontal ASR
	// and rotation metadata, provide the width, in pixels, per the
	// horizontal ASR. The API calculates the height per the horizontal ASR.
	// The API detects any rotation metadata and swaps the requested height
	// and width for the output.
	WidthPixels int64 `json:"widthPixels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BitrateBps") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BitrateBps") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Vp9CodecSettings) MarshalJSON() ([]byte, error) {
	type NoMethod Vp9CodecSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Vp9CodecSettings) UnmarshalJSON(data []byte) error {
	type NoMethod Vp9CodecSettings
	var s1 struct {
		FrameRate gensupport.JSONFloat64 `json:"frameRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FrameRate = float64(s1.FrameRate)
	return nil
}

// YadifConfig: Yet Another Deinterlacing Filter Configuration.
type YadifConfig struct {
	// DeinterlaceAllFrames: Deinterlace all frames rather than just the
	// frames identified as interlaced. The default is `false`.
	DeinterlaceAllFrames bool `json:"deinterlaceAllFrames,omitempty"`

	// DisableSpatialInterlacing: Disable spacial interlacing. The default
	// is `false`.
	DisableSpatialInterlacing bool `json:"disableSpatialInterlacing,omitempty"`

	// Mode: Specifies the deinterlacing mode to adopt. The default is
	// `send_frame`. Supported values: - `send_frame`: Output one frame for
	// each frame - `send_field`: Output one frame for each field
	Mode string `json:"mode,omitempty"`

	// Parity: The picture field parity assumed for the input interlaced
	// video. The default is `auto`. Supported values: - `tff`: Assume the
	// top field is first - `bff`: Assume the bottom field is first -
	// `auto`: Enable automatic detection of field parity
	Parity string `json:"parity,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeinterlaceAllFrames") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeinterlaceAllFrames") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *YadifConfig) MarshalJSON() ([]byte, error) {
	type NoMethod YadifConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "transcoder.projects.locations.jobTemplates.create":

type ProjectsLocationsJobTemplatesCreateCall struct {
	s           *Service
	parent      string
	jobtemplate *JobTemplate
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a job template in the specified region.
//
//   - parent: The parent location to create this job template. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsJobTemplatesService) Create(parent string, jobtemplate *JobTemplate) *ProjectsLocationsJobTemplatesCreateCall {
	c := &ProjectsLocationsJobTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.jobtemplate = jobtemplate
	return c
}

// JobTemplateId sets the optional parameter "jobTemplateId": Required.
// The ID to use for the job template, which will become the final
// component of the job template's resource name. This value should be
// 4-63 characters, and valid characters must match the regular
// expression `a-zA-Z*`.
func (c *ProjectsLocationsJobTemplatesCreateCall) JobTemplateId(jobTemplateId string) *ProjectsLocationsJobTemplatesCreateCall {
	c.urlParams_.Set("jobTemplateId", jobTemplateId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobTemplatesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobTemplatesCreateCall) Context(ctx context.Context) *ProjectsLocationsJobTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.jobtemplate)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/jobTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobTemplates.create" call.
// Exactly one of *JobTemplate or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *JobTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*JobTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &JobTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a job template in the specified region.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobTemplates",
	//   "httpMethod": "POST",
	//   "id": "transcoder.projects.locations.jobTemplates.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "jobTemplateId": {
	//       "description": "Required. The ID to use for the job template, which will become the final component of the job template's resource name. This value should be 4-63 characters, and valid characters must match the regular expression `a-zA-Z*`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent location to create this job template. Format: `projects/{project}/locations/{location}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/jobTemplates",
	//   "request": {
	//     "$ref": "JobTemplate"
	//   },
	//   "response": {
	//     "$ref": "JobTemplate"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "transcoder.projects.locations.jobTemplates.delete":

type ProjectsLocationsJobTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a job template.
//
//   - name: The name of the job template to delete.
//     `projects/{project}/locations/{location}/jobTemplates/{job_template}
//     `.
func (r *ProjectsLocationsJobTemplatesService) Delete(name string) *ProjectsLocationsJobTemplatesDeleteCall {
	c := &ProjectsLocationsJobTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the job template is not found, the request will succeed but
// no action will be taken on the server.
func (c *ProjectsLocationsJobTemplatesDeleteCall) AllowMissing(allowMissing bool) *ProjectsLocationsJobTemplatesDeleteCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobTemplatesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobTemplatesDeleteCall) Context(ctx context.Context) *ProjectsLocationsJobTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobTemplates.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsJobTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a job template.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobTemplates/{jobTemplatesId}",
	//   "httpMethod": "DELETE",
	//   "id": "transcoder.projects.locations.jobTemplates.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the job template is not found, the request will succeed but no action will be taken on the server.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. The name of the job template to delete. `projects/{project}/locations/{location}/jobTemplates/{job_template}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/jobTemplates/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "transcoder.projects.locations.jobTemplates.get":

type ProjectsLocationsJobTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the job template data.
//
//   - name: The name of the job template to retrieve. Format:
//     `projects/{project}/locations/{location}/jobTemplates/{job_template}
//     `.
func (r *ProjectsLocationsJobTemplatesService) Get(name string) *ProjectsLocationsJobTemplatesGetCall {
	c := &ProjectsLocationsJobTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobTemplatesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsJobTemplatesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobTemplatesGetCall) Context(ctx context.Context) *ProjectsLocationsJobTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobTemplates.get" call.
// Exactly one of *JobTemplate or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *JobTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobTemplatesGetCall) Do(opts ...googleapi.CallOption) (*JobTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &JobTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the job template data.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobTemplates/{jobTemplatesId}",
	//   "httpMethod": "GET",
	//   "id": "transcoder.projects.locations.jobTemplates.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the job template to retrieve. Format: `projects/{project}/locations/{location}/jobTemplates/{job_template}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/jobTemplates/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "JobTemplate"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "transcoder.projects.locations.jobTemplates.list":

type ProjectsLocationsJobTemplatesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists job templates in the specified region.
//
//   - parent: The parent location from which to retrieve the collection
//     of job templates. Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsJobTemplatesService) List(parent string) *ProjectsLocationsJobTemplatesListCall {
	c := &ProjectsLocationsJobTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter expression,
// following the syntax outlined in https://google.aip.dev/160.
func (c *ProjectsLocationsJobTemplatesListCall) Filter(filter string) *ProjectsLocationsJobTemplatesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": One or more fields to
// compare and use to sort the output. See
// https://google.aip.dev/132#ordering.
func (c *ProjectsLocationsJobTemplatesListCall) OrderBy(orderBy string) *ProjectsLocationsJobTemplatesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of items to return.
func (c *ProjectsLocationsJobTemplatesListCall) PageSize(pageSize int64) *ProjectsLocationsJobTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// `next_page_token` value returned from a previous List request, if
// any.
func (c *ProjectsLocationsJobTemplatesListCall) PageToken(pageToken string) *ProjectsLocationsJobTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobTemplatesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsJobTemplatesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobTemplatesListCall) Context(ctx context.Context) *ProjectsLocationsJobTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/jobTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobTemplates.list" call.
// Exactly one of *ListJobTemplatesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListJobTemplatesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsJobTemplatesListCall) Do(opts ...googleapi.CallOption) (*ListJobTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListJobTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists job templates in the specified region.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobTemplates",
	//   "httpMethod": "GET",
	//   "id": "transcoder.projects.locations.jobTemplates.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The filter expression, following the syntax outlined in https://google.aip.dev/160.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "One or more fields to compare and use to sort the output. See https://google.aip.dev/132#ordering.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of items to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The `next_page_token` value returned from a previous List request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent location from which to retrieve the collection of job templates. Format: `projects/{project}/locations/{location}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/jobTemplates",
	//   "response": {
	//     "$ref": "ListJobTemplatesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsJobTemplatesListCall) Pages(ctx context.Context, f func(*ListJobTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "transcoder.projects.locations.jobs.create":

type ProjectsLocationsJobsCreateCall struct {
	s          *Service
	parent     string
	job        *Job
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a job in the specified region.
//
//   - parent: The parent location to create and process this job. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsJobsService) Create(parent string, job *Job) *ProjectsLocationsJobsCreateCall {
	c := &ProjectsLocationsJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.job = job
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobsCreateCall) Context(ctx context.Context) *ProjectsLocationsJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.job)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobs.create" call.
// Exactly one of *Job or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsJobsCreateCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a job in the specified region.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobs",
	//   "httpMethod": "POST",
	//   "id": "transcoder.projects.locations.jobs.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent location to create and process this job. Format: `projects/{project}/locations/{location}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/jobs",
	//   "request": {
	//     "$ref": "Job"
	//   },
	//   "response": {
	//     "$ref": "Job"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "transcoder.projects.locations.jobs.delete":

type ProjectsLocationsJobsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a job.
//
//   - name: The name of the job to delete. Format:
//     `projects/{project}/locations/{location}/jobs/{job}`.
func (r *ProjectsLocationsJobsService) Delete(name string) *ProjectsLocationsJobsDeleteCall {
	c := &ProjectsLocationsJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the job is not found, the request will succeed but no
// action will be taken on the server.
func (c *ProjectsLocationsJobsDeleteCall) AllowMissing(allowMissing bool) *ProjectsLocationsJobsDeleteCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobsDeleteCall) Context(ctx context.Context) *ProjectsLocationsJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobs.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsJobsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a job.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobs/{jobsId}",
	//   "httpMethod": "DELETE",
	//   "id": "transcoder.projects.locations.jobs.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the job is not found, the request will succeed but no action will be taken on the server.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. The name of the job to delete. Format: `projects/{project}/locations/{location}/jobs/{job}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "transcoder.projects.locations.jobs.get":

type ProjectsLocationsJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the job data.
//
//   - name: The name of the job to retrieve. Format:
//     `projects/{project}/locations/{location}/jobs/{job}`.
func (r *ProjectsLocationsJobsService) Get(name string) *ProjectsLocationsJobsGetCall {
	c := &ProjectsLocationsJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsJobsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobsGetCall) Context(ctx context.Context) *ProjectsLocationsJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobs.get" call.
// Exactly one of *Job or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsJobsGetCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the job data.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobs/{jobsId}",
	//   "httpMethod": "GET",
	//   "id": "transcoder.projects.locations.jobs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the job to retrieve. Format: `projects/{project}/locations/{location}/jobs/{job}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Job"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "transcoder.projects.locations.jobs.list":

type ProjectsLocationsJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists jobs in the specified region.
//
// - parent: Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsJobsService) List(parent string) *ProjectsLocationsJobsListCall {
	c := &ProjectsLocationsJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter expression,
// following the syntax outlined in https://google.aip.dev/160.
func (c *ProjectsLocationsJobsListCall) Filter(filter string) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": One or more fields to
// compare and use to sort the output. See
// https://google.aip.dev/132#ordering.
func (c *ProjectsLocationsJobsListCall) OrderBy(orderBy string) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of items to return.
func (c *ProjectsLocationsJobsListCall) PageSize(pageSize int64) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// `next_page_token` value returned from a previous List request, if
// any.
func (c *ProjectsLocationsJobsListCall) PageToken(pageToken string) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsJobsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsJobsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsJobsListCall) Context(ctx context.Context) *ProjectsLocationsJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "transcoder.projects.locations.jobs.list" call.
// Exactly one of *ListJobsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListJobsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsListCall) Do(opts ...googleapi.CallOption) (*ListJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists jobs in the specified region.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/jobs",
	//   "httpMethod": "GET",
	//   "id": "transcoder.projects.locations.jobs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The filter expression, following the syntax outlined in https://google.aip.dev/160.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "One or more fields to compare and use to sort the output. See https://google.aip.dev/132#ordering.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of items to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The `next_page_token` value returned from a previous List request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Format: `projects/{project}/locations/{location}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/jobs",
	//   "response": {
	//     "$ref": "ListJobsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsJobsListCall) Pages(ctx context.Context, f func(*ListJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
