"""
Check that "gnatcov coverage" properly rejects mismatching SID files and source
trace files (i.e. source traces generated by an instrumented program, and SID
files created by an incompatible instrumentation of this program).
"""

from SCOV.instr import xcov_instrument
from SCOV.minicheck import build_and_run, check_xcov_reports
from SUITE.context import thistest
from SUITE.gprutils import GPRswitches
from SUITE.cutils import Wdir, contents_of
from SUITE.tutils import gprfor, xcov


wd = Wdir("tmp_")

gpr = gprfor(mains=["main.adb"], srcdirs=[".."])
gprsw = GPRswitches(root_project=gpr)

# Go through the instrument/build/run cycle in stmt+mcdc mode
xcov_args = build_and_run(
    gprsw=gprsw,
    covlevel="stmt+mcdc",
    mains=["main"],
    extra_coverage_args=["--annotate=xcov"],
    trace_mode="src",
)

# Re-instrument in stmt mode
xcov_instrument(gprsw=gprsw, covlevel="stmt")

# Now compute code coverage using 1) the old trace 2) the new SIDs. We expect a
# warning about inconsistent Source Instrumentation Data and discarded coverage
# info (i.e. code not covered).
level_arg = xcov_args.index("--level=stmt+mcdc")
xcov_args[level_arg] = "--level=stmt"
xcov(xcov_args, out="coverage.log")
thistest.fail_if_no_match(
    "'gnatcov coverage' output",
    r"warning: traces for body of main \(from main.*\.srctrace\) are"
    " inconsistent with the corresponding Source Instrumentation Data",
    contents_of("coverage.log").strip(),
)
check_xcov_reports("obj", {"main.adb.xcov": {"-": {4, 5, 7, 11, 12, 14}}})

thistest.result()
