package testutils

import (
	"strings"

	"github.com/projectdiscovery/utils/errkit"
)

type TestCase struct {
	Target      string
	Args        string
	Expected    []string
	CompareFunc func(target string, got []string) error
}

var TestCases = []TestCase{
	{Target: "2400:cb00::1", Expected: []string{"2400:cb00::1 [waf] [cloudflare]"}, Args: "-resp -waf -nc"},
	{Target: "2400:cb00::1", Expected: []string{"2400:cb00::1"}, Args: "-nc"},
	{Target: "2600:9000:5206::1", Expected: []string{"2600:9000:5206::1 [cloud] [aws]"}, Args: "-resp -nc"},
	{Target: "2600:9000:5206::1", Expected: []string{"2600:9000:5206::1 [cloud] [aws]"}, Args: "-resp -cloud -nc"},

	{Target: "52.60.165.183", Expected: []string{"52.60.165.183"}, Args: "-nc"},
	{Target: "cloudflare.com", Expected: []string{"cloudflare.com"}, Args: "-nc"},
	{Target: "gslink.hackerone.com", Expected: []string{"gslink.hackerone.com"}, Args: "-nc"},
	{Target: "52.60.165.183", Expected: []string{"52.60.165.183 [cloud] [aws]"}, Args: "-resp -nc"},
	{Target: "52.60.165.183", Expected: []string{"52.60.165.183 [cloud] [aws]"}, Args: "-resp -cloud -nc"},
	{Target: "104.16.51.111", Expected: []string{"104.16.51.111 [waf] [cloudflare]"}, Args: "-resp -waf -nc"},
	{Target: "54.192.171.16", Expected: []string{"54.192.171.16 [cdn] [cloudfront]"}, Args: "-resp -cdn -nc"},
	{Target: "185.199.109.153", Expected: []string{}, Args: "-nc"},
	{Target: "185.199.109.153", Expected: []string{}, Args: "-resp -nc"},
	{Target: "54.192.171.16", Expected: []string{"54.192.171.16 [cdn] [cloudfront]"}, Args: "-resp -mcdn cloudfront -nc"},
	{Target: "54.192.171.16", Expected: []string{}, Args: "-resp -fcdn cloudfront -mcloud aws -nc"},
	{Target: "gslink.hackerone.com", Expected: []string{"gslink.hackerone.com"}, Args: "-nc"},
	{Target: "cloudflare.com", Expected: nil, Args: "-resp -nc", CompareFunc: func(target string, got []string) error {
		cdn := "cloudflare"
		if len(got) == 1 && strings.Contains(got[0], cdn) {
			return nil
		}
		return errkit.Newf("expected %v belong to %v cdn but got: %v", target, cdn, got)
	}},
}
