// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// License Manager API
//
// Use the License Manager API to manage product licenses and license records. For more information, see License Manager Overview (https://docs.oracle.com/iaas/Content/LicenseManager/Concepts/licensemanageroverview.htm).
//

package licensemanager

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ImageResponse The collection of image details for the product license.
type ImageResponse struct {

	// The image ID associated with the product license.
	Id *string `mandatory:"false" json:"id"`

	// The listing name associated with the product license.
	ListingName *string `mandatory:"false" json:"listingName"`

	// The image publisher.
	Publisher *string `mandatory:"false" json:"publisher"`

	// The image listing ID.
	ListingId *string `mandatory:"false" json:"listingId"`

	// The image package version.
	PackageVersion *string `mandatory:"false" json:"packageVersion"`
}

func (m ImageResponse) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ImageResponse) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
