// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// License Manager API
//
// Use the License Manager API to manage product licenses and license records. For more information, see License Manager Overview (https://docs.cloud.oracle.com/iaas/Content/LicenseManager/Concepts/licensemanageroverview.htm).
//

package licensemanager

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// BulkUploadValidationErrorInfo Detailed error information corresponding to each column for a particular supported license record that could not be uploaded.
type BulkUploadValidationErrorInfo struct {

	// Refers to the license record number as provided in the bulk upload file.
	RowNumber *int `mandatory:"true" json:"rowNumber"`

	// Product name of invalid row.
	ProductName *string `mandatory:"true" json:"productName"`

	// Error information corresponding to each column.
	RowError []BulkUploadCellInfo `mandatory:"true" json:"rowError"`
}

func (m BulkUploadValidationErrorInfo) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m BulkUploadValidationErrorInfo) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
