// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Oracle Delegate Access Control API
//
// Oracle Delegate Access Control allows ExaCC and ExaCS customers to delegate management of their Exadata resources operators outside their tenancies.
// With Delegate Access Control, Support Providers can deliver managed services using comprehensive and robust tooling built on the OCI platform.
// Customers maintain control over who has access to the delegated resources in their tenancy and what actions can be taken.
// Enterprises managing resources across multiple tenants can use Delegate Access Control to streamline management tasks.
// Using logging service, customers can view a near real-time audit report of all actions performed by a Service Provider operator.
//

package delegateaccesscontrol

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DelegatedResourceAccessRequestSummary Summary of Delegated Resource Access Request.
type DelegatedResourceAccessRequestSummary struct {

	// The OCID of the Delegated Resource Access Request.
	Id *string `mandatory:"true" json:"id"`

	// The OCID of the compartment that contains the Delegated Resource Access Request.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// A short description explaining why this Delegated Resource Access Request is needed by the support operator.
	ReasonForRequest *string `mandatory:"true" json:"reasonForRequest"`

	// The OCID of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
	// access the target resource.
	ResourceId *string `mandatory:"true" json:"resourceId"`

	// The OCID of the Delegation Control governing the target resource.
	DelegationControlId *string `mandatory:"true" json:"delegationControlId"`

	// Display name. This is generated by the system automatically.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.
	TicketNumbers []string `mandatory:"false" json:"ticketNumbers"`

	// Requested access start time in UTC.
	TimeAccessRequested *common.SDKTime `mandatory:"false" json:"timeAccessRequested"`

	// The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
	// access the target resource.
	ResourceName *string `mandatory:"false" json:"resourceName"`

	// Resource type for which the associated Delegation Control is applicable to.
	ResourceType DelegationControlResourceTypeEnum `mandatory:"false" json:"resourceType,omitempty"`

	// List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.
	RequestedActionNames []string `mandatory:"false" json:"requestedActionNames"`

	// Requester type
	RequesterType DelegatedResourceAccessRequesterTypeEnum `mandatory:"false" json:"requesterType,omitempty"`

	// Priority assigned to the Delegated Resource Access Request by the support operator
	Severity DelegatedResourceAccessRequestSeverityEnum `mandatory:"false" json:"severity,omitempty"`

	// Duration in hours for which access is sought on the target resource.
	DurationInHours *int `mandatory:"false" json:"durationInHours"`

	// Duration in hours for which extension access is sought on the target resource.
	ExtendDurationInHours *int `mandatory:"false" json:"extendDurationInHours"`

	// Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.
	IsAutoApproved *bool `mandatory:"false" json:"isAutoApproved"`

	// The current lifecycle state of the Delegated Resource Access Request.
	LifecycleState DelegatedResourceAccessRequestLifecycleStateEnum `mandatory:"false" json:"lifecycleState,omitempty"`

	// Description of the current lifecycle state in more detail.
	LifecycleStateDetails *string `mandatory:"false" json:"lifecycleStateDetails"`

	// The current status of the Delegated Resource Access Request.
	RequestStatus DelegatedResourceAccessRequestStatusEnum `mandatory:"false" json:"requestStatus,omitempty"`

	// Time when the Delegated Resource Access Request was created by the support operator user in RFC 3339 (https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
	TimeCreated *common.SDKTime `mandatory:"false" json:"timeCreated"`

	// Time when the Delegated Resource Access Request was last modified in RFC 3339 (https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
	TimeUpdated *common.SDKTime `mandatory:"false" json:"timeUpdated"`

	// Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
	// For more information, see Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Department": "Finance"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// For more information, see Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Operations": {"CostCenter": "42"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m DelegatedResourceAccessRequestSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DelegatedResourceAccessRequestSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingDelegationControlResourceTypeEnum(string(m.ResourceType)); !ok && m.ResourceType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for ResourceType: %s. Supported values are: %s.", m.ResourceType, strings.Join(GetDelegationControlResourceTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDelegatedResourceAccessRequesterTypeEnum(string(m.RequesterType)); !ok && m.RequesterType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for RequesterType: %s. Supported values are: %s.", m.RequesterType, strings.Join(GetDelegatedResourceAccessRequesterTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDelegatedResourceAccessRequestSeverityEnum(string(m.Severity)); !ok && m.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", m.Severity, strings.Join(GetDelegatedResourceAccessRequestSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDelegatedResourceAccessRequestLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetDelegatedResourceAccessRequestLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDelegatedResourceAccessRequestStatusEnum(string(m.RequestStatus)); !ok && m.RequestStatus != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for RequestStatus: %s. Supported values are: %s.", m.RequestStatus, strings.Join(GetDelegatedResourceAccessRequestStatusEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
