// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Catalog API
//
// Use the Data Catalog APIs to collect, organize, find, access, understand, enrich, and activate technical, business, and operational metadata.
//

package datacatalog

import (
	"github.com/oracle/oci-go-sdk/v32/common"
)

// RuleAttribute Object that defines a usage of an attribute in the context of a rule.
// Example: For a UNIQUEKEY rule, declares the attribute in a table whose value must be unique.
type RuleAttribute struct {

	// Immutable unique key of the attribute.
	Key *string `mandatory:"true" json:"key"`

	// A user-friendly display name. Does not have to be unique, and it's changeable.
	// Avoid entering confidential information.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// Position of the attribute in the record definition.
	Position *int `mandatory:"false" json:"position"`
}

func (m RuleAttribute) String() string {
	return common.PointerString(m)
}
