// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/feed"
	"github.com/mrusme/journalist/ent/item"
	"github.com/mrusme/journalist/ent/predicate"
	"github.com/mrusme/journalist/ent/subscription"
	"github.com/mrusme/journalist/ent/user"
)

// FeedUpdate is the builder for updating Feed entities.
type FeedUpdate struct {
	config
	hooks    []Hook
	mutation *FeedMutation
}

// Where appends a list predicates to the FeedUpdate builder.
func (fu *FeedUpdate) Where(ps ...predicate.Feed) *FeedUpdate {
	fu.mutation.Where(ps...)
	return fu
}

// SetURL sets the "url" field.
func (fu *FeedUpdate) SetURL(s string) *FeedUpdate {
	fu.mutation.SetURL(s)
	return fu
}

// SetNillableURL sets the "url" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableURL(s *string) *FeedUpdate {
	if s != nil {
		fu.SetURL(*s)
	}
	return fu
}

// SetUsername sets the "username" field.
func (fu *FeedUpdate) SetUsername(s string) *FeedUpdate {
	fu.mutation.SetUsername(s)
	return fu
}

// SetNillableUsername sets the "username" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableUsername(s *string) *FeedUpdate {
	if s != nil {
		fu.SetUsername(*s)
	}
	return fu
}

// SetPassword sets the "password" field.
func (fu *FeedUpdate) SetPassword(s string) *FeedUpdate {
	fu.mutation.SetPassword(s)
	return fu
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (fu *FeedUpdate) SetNillablePassword(s *string) *FeedUpdate {
	if s != nil {
		fu.SetPassword(*s)
	}
	return fu
}

// SetFeedTitle sets the "feed_title" field.
func (fu *FeedUpdate) SetFeedTitle(s string) *FeedUpdate {
	fu.mutation.SetFeedTitle(s)
	return fu
}

// SetNillableFeedTitle sets the "feed_title" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedTitle(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedTitle(*s)
	}
	return fu
}

// SetFeedDescription sets the "feed_description" field.
func (fu *FeedUpdate) SetFeedDescription(s string) *FeedUpdate {
	fu.mutation.SetFeedDescription(s)
	return fu
}

// SetNillableFeedDescription sets the "feed_description" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedDescription(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedDescription(*s)
	}
	return fu
}

// SetFeedLink sets the "feed_link" field.
func (fu *FeedUpdate) SetFeedLink(s string) *FeedUpdate {
	fu.mutation.SetFeedLink(s)
	return fu
}

// SetNillableFeedLink sets the "feed_link" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedLink(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedLink(*s)
	}
	return fu
}

// SetFeedFeedLink sets the "feed_feed_link" field.
func (fu *FeedUpdate) SetFeedFeedLink(s string) *FeedUpdate {
	fu.mutation.SetFeedFeedLink(s)
	return fu
}

// SetNillableFeedFeedLink sets the "feed_feed_link" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedFeedLink(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedFeedLink(*s)
	}
	return fu
}

// SetFeedUpdated sets the "feed_updated" field.
func (fu *FeedUpdate) SetFeedUpdated(t time.Time) *FeedUpdate {
	fu.mutation.SetFeedUpdated(t)
	return fu
}

// SetNillableFeedUpdated sets the "feed_updated" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedUpdated(t *time.Time) *FeedUpdate {
	if t != nil {
		fu.SetFeedUpdated(*t)
	}
	return fu
}

// SetFeedPublished sets the "feed_published" field.
func (fu *FeedUpdate) SetFeedPublished(t time.Time) *FeedUpdate {
	fu.mutation.SetFeedPublished(t)
	return fu
}

// SetNillableFeedPublished sets the "feed_published" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedPublished(t *time.Time) *FeedUpdate {
	if t != nil {
		fu.SetFeedPublished(*t)
	}
	return fu
}

// SetFeedAuthorName sets the "feed_author_name" field.
func (fu *FeedUpdate) SetFeedAuthorName(s string) *FeedUpdate {
	fu.mutation.SetFeedAuthorName(s)
	return fu
}

// SetNillableFeedAuthorName sets the "feed_author_name" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedAuthorName(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedAuthorName(*s)
	}
	return fu
}

// ClearFeedAuthorName clears the value of the "feed_author_name" field.
func (fu *FeedUpdate) ClearFeedAuthorName() *FeedUpdate {
	fu.mutation.ClearFeedAuthorName()
	return fu
}

// SetFeedAuthorEmail sets the "feed_author_email" field.
func (fu *FeedUpdate) SetFeedAuthorEmail(s string) *FeedUpdate {
	fu.mutation.SetFeedAuthorEmail(s)
	return fu
}

// SetNillableFeedAuthorEmail sets the "feed_author_email" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedAuthorEmail(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedAuthorEmail(*s)
	}
	return fu
}

// ClearFeedAuthorEmail clears the value of the "feed_author_email" field.
func (fu *FeedUpdate) ClearFeedAuthorEmail() *FeedUpdate {
	fu.mutation.ClearFeedAuthorEmail()
	return fu
}

// SetFeedLanguage sets the "feed_language" field.
func (fu *FeedUpdate) SetFeedLanguage(s string) *FeedUpdate {
	fu.mutation.SetFeedLanguage(s)
	return fu
}

// SetNillableFeedLanguage sets the "feed_language" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedLanguage(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedLanguage(*s)
	}
	return fu
}

// SetFeedImageTitle sets the "feed_image_title" field.
func (fu *FeedUpdate) SetFeedImageTitle(s string) *FeedUpdate {
	fu.mutation.SetFeedImageTitle(s)
	return fu
}

// SetNillableFeedImageTitle sets the "feed_image_title" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedImageTitle(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedImageTitle(*s)
	}
	return fu
}

// ClearFeedImageTitle clears the value of the "feed_image_title" field.
func (fu *FeedUpdate) ClearFeedImageTitle() *FeedUpdate {
	fu.mutation.ClearFeedImageTitle()
	return fu
}

// SetFeedImageURL sets the "feed_image_url" field.
func (fu *FeedUpdate) SetFeedImageURL(s string) *FeedUpdate {
	fu.mutation.SetFeedImageURL(s)
	return fu
}

// SetNillableFeedImageURL sets the "feed_image_url" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedImageURL(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedImageURL(*s)
	}
	return fu
}

// ClearFeedImageURL clears the value of the "feed_image_url" field.
func (fu *FeedUpdate) ClearFeedImageURL() *FeedUpdate {
	fu.mutation.ClearFeedImageURL()
	return fu
}

// SetFeedCopyright sets the "feed_copyright" field.
func (fu *FeedUpdate) SetFeedCopyright(s string) *FeedUpdate {
	fu.mutation.SetFeedCopyright(s)
	return fu
}

// SetNillableFeedCopyright sets the "feed_copyright" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedCopyright(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedCopyright(*s)
	}
	return fu
}

// SetFeedGenerator sets the "feed_generator" field.
func (fu *FeedUpdate) SetFeedGenerator(s string) *FeedUpdate {
	fu.mutation.SetFeedGenerator(s)
	return fu
}

// SetNillableFeedGenerator sets the "feed_generator" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedGenerator(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedGenerator(*s)
	}
	return fu
}

// SetFeedCategories sets the "feed_categories" field.
func (fu *FeedUpdate) SetFeedCategories(s string) *FeedUpdate {
	fu.mutation.SetFeedCategories(s)
	return fu
}

// SetNillableFeedCategories sets the "feed_categories" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableFeedCategories(s *string) *FeedUpdate {
	if s != nil {
		fu.SetFeedCategories(*s)
	}
	return fu
}

// SetCreatedAt sets the "created_at" field.
func (fu *FeedUpdate) SetCreatedAt(t time.Time) *FeedUpdate {
	fu.mutation.SetCreatedAt(t)
	return fu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableCreatedAt(t *time.Time) *FeedUpdate {
	if t != nil {
		fu.SetCreatedAt(*t)
	}
	return fu
}

// SetUpdatedAt sets the "updated_at" field.
func (fu *FeedUpdate) SetUpdatedAt(t time.Time) *FeedUpdate {
	fu.mutation.SetUpdatedAt(t)
	return fu
}

// SetDeletedAt sets the "deleted_at" field.
func (fu *FeedUpdate) SetDeletedAt(t time.Time) *FeedUpdate {
	fu.mutation.SetDeletedAt(t)
	return fu
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (fu *FeedUpdate) SetNillableDeletedAt(t *time.Time) *FeedUpdate {
	if t != nil {
		fu.SetDeletedAt(*t)
	}
	return fu
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (fu *FeedUpdate) ClearDeletedAt() *FeedUpdate {
	fu.mutation.ClearDeletedAt()
	return fu
}

// AddItemIDs adds the "items" edge to the Item entity by IDs.
func (fu *FeedUpdate) AddItemIDs(ids ...uuid.UUID) *FeedUpdate {
	fu.mutation.AddItemIDs(ids...)
	return fu
}

// AddItems adds the "items" edges to the Item entity.
func (fu *FeedUpdate) AddItems(i ...*Item) *FeedUpdate {
	ids := make([]uuid.UUID, len(i))
	for j := range i {
		ids[j] = i[j].ID
	}
	return fu.AddItemIDs(ids...)
}

// AddSubscribedUserIDs adds the "subscribed_users" edge to the User entity by IDs.
func (fu *FeedUpdate) AddSubscribedUserIDs(ids ...uuid.UUID) *FeedUpdate {
	fu.mutation.AddSubscribedUserIDs(ids...)
	return fu
}

// AddSubscribedUsers adds the "subscribed_users" edges to the User entity.
func (fu *FeedUpdate) AddSubscribedUsers(u ...*User) *FeedUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return fu.AddSubscribedUserIDs(ids...)
}

// AddSubscriptionIDs adds the "subscriptions" edge to the Subscription entity by IDs.
func (fu *FeedUpdate) AddSubscriptionIDs(ids ...uuid.UUID) *FeedUpdate {
	fu.mutation.AddSubscriptionIDs(ids...)
	return fu
}

// AddSubscriptions adds the "subscriptions" edges to the Subscription entity.
func (fu *FeedUpdate) AddSubscriptions(s ...*Subscription) *FeedUpdate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return fu.AddSubscriptionIDs(ids...)
}

// Mutation returns the FeedMutation object of the builder.
func (fu *FeedUpdate) Mutation() *FeedMutation {
	return fu.mutation
}

// ClearItems clears all "items" edges to the Item entity.
func (fu *FeedUpdate) ClearItems() *FeedUpdate {
	fu.mutation.ClearItems()
	return fu
}

// RemoveItemIDs removes the "items" edge to Item entities by IDs.
func (fu *FeedUpdate) RemoveItemIDs(ids ...uuid.UUID) *FeedUpdate {
	fu.mutation.RemoveItemIDs(ids...)
	return fu
}

// RemoveItems removes "items" edges to Item entities.
func (fu *FeedUpdate) RemoveItems(i ...*Item) *FeedUpdate {
	ids := make([]uuid.UUID, len(i))
	for j := range i {
		ids[j] = i[j].ID
	}
	return fu.RemoveItemIDs(ids...)
}

// ClearSubscribedUsers clears all "subscribed_users" edges to the User entity.
func (fu *FeedUpdate) ClearSubscribedUsers() *FeedUpdate {
	fu.mutation.ClearSubscribedUsers()
	return fu
}

// RemoveSubscribedUserIDs removes the "subscribed_users" edge to User entities by IDs.
func (fu *FeedUpdate) RemoveSubscribedUserIDs(ids ...uuid.UUID) *FeedUpdate {
	fu.mutation.RemoveSubscribedUserIDs(ids...)
	return fu
}

// RemoveSubscribedUsers removes "subscribed_users" edges to User entities.
func (fu *FeedUpdate) RemoveSubscribedUsers(u ...*User) *FeedUpdate {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return fu.RemoveSubscribedUserIDs(ids...)
}

// ClearSubscriptions clears all "subscriptions" edges to the Subscription entity.
func (fu *FeedUpdate) ClearSubscriptions() *FeedUpdate {
	fu.mutation.ClearSubscriptions()
	return fu
}

// RemoveSubscriptionIDs removes the "subscriptions" edge to Subscription entities by IDs.
func (fu *FeedUpdate) RemoveSubscriptionIDs(ids ...uuid.UUID) *FeedUpdate {
	fu.mutation.RemoveSubscriptionIDs(ids...)
	return fu
}

// RemoveSubscriptions removes "subscriptions" edges to Subscription entities.
func (fu *FeedUpdate) RemoveSubscriptions(s ...*Subscription) *FeedUpdate {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return fu.RemoveSubscriptionIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (fu *FeedUpdate) Save(ctx context.Context) (int, error) {
	fu.defaults()
	return withHooks(ctx, fu.sqlSave, fu.mutation, fu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (fu *FeedUpdate) SaveX(ctx context.Context) int {
	affected, err := fu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (fu *FeedUpdate) Exec(ctx context.Context) error {
	_, err := fu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (fu *FeedUpdate) ExecX(ctx context.Context) {
	if err := fu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (fu *FeedUpdate) defaults() {
	if _, ok := fu.mutation.UpdatedAt(); !ok {
		v := feed.UpdateDefaultUpdatedAt()
		fu.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (fu *FeedUpdate) check() error {
	if v, ok := fu.mutation.URL(); ok {
		if err := feed.URLValidator(v); err != nil {
			return &ValidationError{Name: "url", err: fmt.Errorf(`ent: validator failed for field "Feed.url": %w`, err)}
		}
	}
	return nil
}

func (fu *FeedUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := fu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(feed.Table, feed.Columns, sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID))
	if ps := fu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := fu.mutation.URL(); ok {
		_spec.SetField(feed.FieldURL, field.TypeString, value)
	}
	if value, ok := fu.mutation.Username(); ok {
		_spec.SetField(feed.FieldUsername, field.TypeString, value)
	}
	if value, ok := fu.mutation.Password(); ok {
		_spec.SetField(feed.FieldPassword, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedTitle(); ok {
		_spec.SetField(feed.FieldFeedTitle, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedDescription(); ok {
		_spec.SetField(feed.FieldFeedDescription, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedLink(); ok {
		_spec.SetField(feed.FieldFeedLink, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedFeedLink(); ok {
		_spec.SetField(feed.FieldFeedFeedLink, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedUpdated(); ok {
		_spec.SetField(feed.FieldFeedUpdated, field.TypeTime, value)
	}
	if value, ok := fu.mutation.FeedPublished(); ok {
		_spec.SetField(feed.FieldFeedPublished, field.TypeTime, value)
	}
	if value, ok := fu.mutation.FeedAuthorName(); ok {
		_spec.SetField(feed.FieldFeedAuthorName, field.TypeString, value)
	}
	if fu.mutation.FeedAuthorNameCleared() {
		_spec.ClearField(feed.FieldFeedAuthorName, field.TypeString)
	}
	if value, ok := fu.mutation.FeedAuthorEmail(); ok {
		_spec.SetField(feed.FieldFeedAuthorEmail, field.TypeString, value)
	}
	if fu.mutation.FeedAuthorEmailCleared() {
		_spec.ClearField(feed.FieldFeedAuthorEmail, field.TypeString)
	}
	if value, ok := fu.mutation.FeedLanguage(); ok {
		_spec.SetField(feed.FieldFeedLanguage, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedImageTitle(); ok {
		_spec.SetField(feed.FieldFeedImageTitle, field.TypeString, value)
	}
	if fu.mutation.FeedImageTitleCleared() {
		_spec.ClearField(feed.FieldFeedImageTitle, field.TypeString)
	}
	if value, ok := fu.mutation.FeedImageURL(); ok {
		_spec.SetField(feed.FieldFeedImageURL, field.TypeString, value)
	}
	if fu.mutation.FeedImageURLCleared() {
		_spec.ClearField(feed.FieldFeedImageURL, field.TypeString)
	}
	if value, ok := fu.mutation.FeedCopyright(); ok {
		_spec.SetField(feed.FieldFeedCopyright, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedGenerator(); ok {
		_spec.SetField(feed.FieldFeedGenerator, field.TypeString, value)
	}
	if value, ok := fu.mutation.FeedCategories(); ok {
		_spec.SetField(feed.FieldFeedCategories, field.TypeString, value)
	}
	if value, ok := fu.mutation.CreatedAt(); ok {
		_spec.SetField(feed.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := fu.mutation.UpdatedAt(); ok {
		_spec.SetField(feed.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := fu.mutation.DeletedAt(); ok {
		_spec.SetField(feed.FieldDeletedAt, field.TypeTime, value)
	}
	if fu.mutation.DeletedAtCleared() {
		_spec.ClearField(feed.FieldDeletedAt, field.TypeTime)
	}
	if fu.mutation.ItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   feed.ItemsTable,
			Columns: []string{feed.ItemsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fu.mutation.RemovedItemsIDs(); len(nodes) > 0 && !fu.mutation.ItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   feed.ItemsTable,
			Columns: []string{feed.ItemsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fu.mutation.ItemsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   feed.ItemsTable,
			Columns: []string{feed.ItemsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if fu.mutation.SubscribedUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   feed.SubscribedUsersTable,
			Columns: feed.SubscribedUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		createE := &SubscriptionCreate{config: fu.config, mutation: newSubscriptionMutation(fu.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fu.mutation.RemovedSubscribedUsersIDs(); len(nodes) > 0 && !fu.mutation.SubscribedUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   feed.SubscribedUsersTable,
			Columns: feed.SubscribedUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &SubscriptionCreate{config: fu.config, mutation: newSubscriptionMutation(fu.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fu.mutation.SubscribedUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   feed.SubscribedUsersTable,
			Columns: feed.SubscribedUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &SubscriptionCreate{config: fu.config, mutation: newSubscriptionMutation(fu.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if fu.mutation.SubscriptionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   feed.SubscriptionsTable,
			Columns: []string{feed.SubscriptionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(subscription.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fu.mutation.RemovedSubscriptionsIDs(); len(nodes) > 0 && !fu.mutation.SubscriptionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   feed.SubscriptionsTable,
			Columns: []string{feed.SubscriptionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(subscription.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fu.mutation.SubscriptionsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   feed.SubscriptionsTable,
			Columns: []string{feed.SubscriptionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(subscription.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, fu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{feed.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	fu.mutation.done = true
	return n, nil
}

// FeedUpdateOne is the builder for updating a single Feed entity.
type FeedUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *FeedMutation
}

// SetURL sets the "url" field.
func (fuo *FeedUpdateOne) SetURL(s string) *FeedUpdateOne {
	fuo.mutation.SetURL(s)
	return fuo
}

// SetNillableURL sets the "url" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableURL(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetURL(*s)
	}
	return fuo
}

// SetUsername sets the "username" field.
func (fuo *FeedUpdateOne) SetUsername(s string) *FeedUpdateOne {
	fuo.mutation.SetUsername(s)
	return fuo
}

// SetNillableUsername sets the "username" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableUsername(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetUsername(*s)
	}
	return fuo
}

// SetPassword sets the "password" field.
func (fuo *FeedUpdateOne) SetPassword(s string) *FeedUpdateOne {
	fuo.mutation.SetPassword(s)
	return fuo
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillablePassword(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetPassword(*s)
	}
	return fuo
}

// SetFeedTitle sets the "feed_title" field.
func (fuo *FeedUpdateOne) SetFeedTitle(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedTitle(s)
	return fuo
}

// SetNillableFeedTitle sets the "feed_title" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedTitle(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedTitle(*s)
	}
	return fuo
}

// SetFeedDescription sets the "feed_description" field.
func (fuo *FeedUpdateOne) SetFeedDescription(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedDescription(s)
	return fuo
}

// SetNillableFeedDescription sets the "feed_description" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedDescription(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedDescription(*s)
	}
	return fuo
}

// SetFeedLink sets the "feed_link" field.
func (fuo *FeedUpdateOne) SetFeedLink(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedLink(s)
	return fuo
}

// SetNillableFeedLink sets the "feed_link" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedLink(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedLink(*s)
	}
	return fuo
}

// SetFeedFeedLink sets the "feed_feed_link" field.
func (fuo *FeedUpdateOne) SetFeedFeedLink(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedFeedLink(s)
	return fuo
}

// SetNillableFeedFeedLink sets the "feed_feed_link" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedFeedLink(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedFeedLink(*s)
	}
	return fuo
}

// SetFeedUpdated sets the "feed_updated" field.
func (fuo *FeedUpdateOne) SetFeedUpdated(t time.Time) *FeedUpdateOne {
	fuo.mutation.SetFeedUpdated(t)
	return fuo
}

// SetNillableFeedUpdated sets the "feed_updated" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedUpdated(t *time.Time) *FeedUpdateOne {
	if t != nil {
		fuo.SetFeedUpdated(*t)
	}
	return fuo
}

// SetFeedPublished sets the "feed_published" field.
func (fuo *FeedUpdateOne) SetFeedPublished(t time.Time) *FeedUpdateOne {
	fuo.mutation.SetFeedPublished(t)
	return fuo
}

// SetNillableFeedPublished sets the "feed_published" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedPublished(t *time.Time) *FeedUpdateOne {
	if t != nil {
		fuo.SetFeedPublished(*t)
	}
	return fuo
}

// SetFeedAuthorName sets the "feed_author_name" field.
func (fuo *FeedUpdateOne) SetFeedAuthorName(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedAuthorName(s)
	return fuo
}

// SetNillableFeedAuthorName sets the "feed_author_name" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedAuthorName(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedAuthorName(*s)
	}
	return fuo
}

// ClearFeedAuthorName clears the value of the "feed_author_name" field.
func (fuo *FeedUpdateOne) ClearFeedAuthorName() *FeedUpdateOne {
	fuo.mutation.ClearFeedAuthorName()
	return fuo
}

// SetFeedAuthorEmail sets the "feed_author_email" field.
func (fuo *FeedUpdateOne) SetFeedAuthorEmail(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedAuthorEmail(s)
	return fuo
}

// SetNillableFeedAuthorEmail sets the "feed_author_email" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedAuthorEmail(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedAuthorEmail(*s)
	}
	return fuo
}

// ClearFeedAuthorEmail clears the value of the "feed_author_email" field.
func (fuo *FeedUpdateOne) ClearFeedAuthorEmail() *FeedUpdateOne {
	fuo.mutation.ClearFeedAuthorEmail()
	return fuo
}

// SetFeedLanguage sets the "feed_language" field.
func (fuo *FeedUpdateOne) SetFeedLanguage(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedLanguage(s)
	return fuo
}

// SetNillableFeedLanguage sets the "feed_language" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedLanguage(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedLanguage(*s)
	}
	return fuo
}

// SetFeedImageTitle sets the "feed_image_title" field.
func (fuo *FeedUpdateOne) SetFeedImageTitle(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedImageTitle(s)
	return fuo
}

// SetNillableFeedImageTitle sets the "feed_image_title" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedImageTitle(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedImageTitle(*s)
	}
	return fuo
}

// ClearFeedImageTitle clears the value of the "feed_image_title" field.
func (fuo *FeedUpdateOne) ClearFeedImageTitle() *FeedUpdateOne {
	fuo.mutation.ClearFeedImageTitle()
	return fuo
}

// SetFeedImageURL sets the "feed_image_url" field.
func (fuo *FeedUpdateOne) SetFeedImageURL(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedImageURL(s)
	return fuo
}

// SetNillableFeedImageURL sets the "feed_image_url" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedImageURL(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedImageURL(*s)
	}
	return fuo
}

// ClearFeedImageURL clears the value of the "feed_image_url" field.
func (fuo *FeedUpdateOne) ClearFeedImageURL() *FeedUpdateOne {
	fuo.mutation.ClearFeedImageURL()
	return fuo
}

// SetFeedCopyright sets the "feed_copyright" field.
func (fuo *FeedUpdateOne) SetFeedCopyright(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedCopyright(s)
	return fuo
}

// SetNillableFeedCopyright sets the "feed_copyright" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedCopyright(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedCopyright(*s)
	}
	return fuo
}

// SetFeedGenerator sets the "feed_generator" field.
func (fuo *FeedUpdateOne) SetFeedGenerator(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedGenerator(s)
	return fuo
}

// SetNillableFeedGenerator sets the "feed_generator" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedGenerator(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedGenerator(*s)
	}
	return fuo
}

// SetFeedCategories sets the "feed_categories" field.
func (fuo *FeedUpdateOne) SetFeedCategories(s string) *FeedUpdateOne {
	fuo.mutation.SetFeedCategories(s)
	return fuo
}

// SetNillableFeedCategories sets the "feed_categories" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableFeedCategories(s *string) *FeedUpdateOne {
	if s != nil {
		fuo.SetFeedCategories(*s)
	}
	return fuo
}

// SetCreatedAt sets the "created_at" field.
func (fuo *FeedUpdateOne) SetCreatedAt(t time.Time) *FeedUpdateOne {
	fuo.mutation.SetCreatedAt(t)
	return fuo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableCreatedAt(t *time.Time) *FeedUpdateOne {
	if t != nil {
		fuo.SetCreatedAt(*t)
	}
	return fuo
}

// SetUpdatedAt sets the "updated_at" field.
func (fuo *FeedUpdateOne) SetUpdatedAt(t time.Time) *FeedUpdateOne {
	fuo.mutation.SetUpdatedAt(t)
	return fuo
}

// SetDeletedAt sets the "deleted_at" field.
func (fuo *FeedUpdateOne) SetDeletedAt(t time.Time) *FeedUpdateOne {
	fuo.mutation.SetDeletedAt(t)
	return fuo
}

// SetNillableDeletedAt sets the "deleted_at" field if the given value is not nil.
func (fuo *FeedUpdateOne) SetNillableDeletedAt(t *time.Time) *FeedUpdateOne {
	if t != nil {
		fuo.SetDeletedAt(*t)
	}
	return fuo
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (fuo *FeedUpdateOne) ClearDeletedAt() *FeedUpdateOne {
	fuo.mutation.ClearDeletedAt()
	return fuo
}

// AddItemIDs adds the "items" edge to the Item entity by IDs.
func (fuo *FeedUpdateOne) AddItemIDs(ids ...uuid.UUID) *FeedUpdateOne {
	fuo.mutation.AddItemIDs(ids...)
	return fuo
}

// AddItems adds the "items" edges to the Item entity.
func (fuo *FeedUpdateOne) AddItems(i ...*Item) *FeedUpdateOne {
	ids := make([]uuid.UUID, len(i))
	for j := range i {
		ids[j] = i[j].ID
	}
	return fuo.AddItemIDs(ids...)
}

// AddSubscribedUserIDs adds the "subscribed_users" edge to the User entity by IDs.
func (fuo *FeedUpdateOne) AddSubscribedUserIDs(ids ...uuid.UUID) *FeedUpdateOne {
	fuo.mutation.AddSubscribedUserIDs(ids...)
	return fuo
}

// AddSubscribedUsers adds the "subscribed_users" edges to the User entity.
func (fuo *FeedUpdateOne) AddSubscribedUsers(u ...*User) *FeedUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return fuo.AddSubscribedUserIDs(ids...)
}

// AddSubscriptionIDs adds the "subscriptions" edge to the Subscription entity by IDs.
func (fuo *FeedUpdateOne) AddSubscriptionIDs(ids ...uuid.UUID) *FeedUpdateOne {
	fuo.mutation.AddSubscriptionIDs(ids...)
	return fuo
}

// AddSubscriptions adds the "subscriptions" edges to the Subscription entity.
func (fuo *FeedUpdateOne) AddSubscriptions(s ...*Subscription) *FeedUpdateOne {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return fuo.AddSubscriptionIDs(ids...)
}

// Mutation returns the FeedMutation object of the builder.
func (fuo *FeedUpdateOne) Mutation() *FeedMutation {
	return fuo.mutation
}

// ClearItems clears all "items" edges to the Item entity.
func (fuo *FeedUpdateOne) ClearItems() *FeedUpdateOne {
	fuo.mutation.ClearItems()
	return fuo
}

// RemoveItemIDs removes the "items" edge to Item entities by IDs.
func (fuo *FeedUpdateOne) RemoveItemIDs(ids ...uuid.UUID) *FeedUpdateOne {
	fuo.mutation.RemoveItemIDs(ids...)
	return fuo
}

// RemoveItems removes "items" edges to Item entities.
func (fuo *FeedUpdateOne) RemoveItems(i ...*Item) *FeedUpdateOne {
	ids := make([]uuid.UUID, len(i))
	for j := range i {
		ids[j] = i[j].ID
	}
	return fuo.RemoveItemIDs(ids...)
}

// ClearSubscribedUsers clears all "subscribed_users" edges to the User entity.
func (fuo *FeedUpdateOne) ClearSubscribedUsers() *FeedUpdateOne {
	fuo.mutation.ClearSubscribedUsers()
	return fuo
}

// RemoveSubscribedUserIDs removes the "subscribed_users" edge to User entities by IDs.
func (fuo *FeedUpdateOne) RemoveSubscribedUserIDs(ids ...uuid.UUID) *FeedUpdateOne {
	fuo.mutation.RemoveSubscribedUserIDs(ids...)
	return fuo
}

// RemoveSubscribedUsers removes "subscribed_users" edges to User entities.
func (fuo *FeedUpdateOne) RemoveSubscribedUsers(u ...*User) *FeedUpdateOne {
	ids := make([]uuid.UUID, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return fuo.RemoveSubscribedUserIDs(ids...)
}

// ClearSubscriptions clears all "subscriptions" edges to the Subscription entity.
func (fuo *FeedUpdateOne) ClearSubscriptions() *FeedUpdateOne {
	fuo.mutation.ClearSubscriptions()
	return fuo
}

// RemoveSubscriptionIDs removes the "subscriptions" edge to Subscription entities by IDs.
func (fuo *FeedUpdateOne) RemoveSubscriptionIDs(ids ...uuid.UUID) *FeedUpdateOne {
	fuo.mutation.RemoveSubscriptionIDs(ids...)
	return fuo
}

// RemoveSubscriptions removes "subscriptions" edges to Subscription entities.
func (fuo *FeedUpdateOne) RemoveSubscriptions(s ...*Subscription) *FeedUpdateOne {
	ids := make([]uuid.UUID, len(s))
	for i := range s {
		ids[i] = s[i].ID
	}
	return fuo.RemoveSubscriptionIDs(ids...)
}

// Where appends a list predicates to the FeedUpdate builder.
func (fuo *FeedUpdateOne) Where(ps ...predicate.Feed) *FeedUpdateOne {
	fuo.mutation.Where(ps...)
	return fuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (fuo *FeedUpdateOne) Select(field string, fields ...string) *FeedUpdateOne {
	fuo.fields = append([]string{field}, fields...)
	return fuo
}

// Save executes the query and returns the updated Feed entity.
func (fuo *FeedUpdateOne) Save(ctx context.Context) (*Feed, error) {
	fuo.defaults()
	return withHooks(ctx, fuo.sqlSave, fuo.mutation, fuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (fuo *FeedUpdateOne) SaveX(ctx context.Context) *Feed {
	node, err := fuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (fuo *FeedUpdateOne) Exec(ctx context.Context) error {
	_, err := fuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (fuo *FeedUpdateOne) ExecX(ctx context.Context) {
	if err := fuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (fuo *FeedUpdateOne) defaults() {
	if _, ok := fuo.mutation.UpdatedAt(); !ok {
		v := feed.UpdateDefaultUpdatedAt()
		fuo.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (fuo *FeedUpdateOne) check() error {
	if v, ok := fuo.mutation.URL(); ok {
		if err := feed.URLValidator(v); err != nil {
			return &ValidationError{Name: "url", err: fmt.Errorf(`ent: validator failed for field "Feed.url": %w`, err)}
		}
	}
	return nil
}

func (fuo *FeedUpdateOne) sqlSave(ctx context.Context) (_node *Feed, err error) {
	if err := fuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(feed.Table, feed.Columns, sqlgraph.NewFieldSpec(feed.FieldID, field.TypeUUID))
	id, ok := fuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Feed.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := fuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, feed.FieldID)
		for _, f := range fields {
			if !feed.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != feed.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := fuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := fuo.mutation.URL(); ok {
		_spec.SetField(feed.FieldURL, field.TypeString, value)
	}
	if value, ok := fuo.mutation.Username(); ok {
		_spec.SetField(feed.FieldUsername, field.TypeString, value)
	}
	if value, ok := fuo.mutation.Password(); ok {
		_spec.SetField(feed.FieldPassword, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedTitle(); ok {
		_spec.SetField(feed.FieldFeedTitle, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedDescription(); ok {
		_spec.SetField(feed.FieldFeedDescription, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedLink(); ok {
		_spec.SetField(feed.FieldFeedLink, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedFeedLink(); ok {
		_spec.SetField(feed.FieldFeedFeedLink, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedUpdated(); ok {
		_spec.SetField(feed.FieldFeedUpdated, field.TypeTime, value)
	}
	if value, ok := fuo.mutation.FeedPublished(); ok {
		_spec.SetField(feed.FieldFeedPublished, field.TypeTime, value)
	}
	if value, ok := fuo.mutation.FeedAuthorName(); ok {
		_spec.SetField(feed.FieldFeedAuthorName, field.TypeString, value)
	}
	if fuo.mutation.FeedAuthorNameCleared() {
		_spec.ClearField(feed.FieldFeedAuthorName, field.TypeString)
	}
	if value, ok := fuo.mutation.FeedAuthorEmail(); ok {
		_spec.SetField(feed.FieldFeedAuthorEmail, field.TypeString, value)
	}
	if fuo.mutation.FeedAuthorEmailCleared() {
		_spec.ClearField(feed.FieldFeedAuthorEmail, field.TypeString)
	}
	if value, ok := fuo.mutation.FeedLanguage(); ok {
		_spec.SetField(feed.FieldFeedLanguage, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedImageTitle(); ok {
		_spec.SetField(feed.FieldFeedImageTitle, field.TypeString, value)
	}
	if fuo.mutation.FeedImageTitleCleared() {
		_spec.ClearField(feed.FieldFeedImageTitle, field.TypeString)
	}
	if value, ok := fuo.mutation.FeedImageURL(); ok {
		_spec.SetField(feed.FieldFeedImageURL, field.TypeString, value)
	}
	if fuo.mutation.FeedImageURLCleared() {
		_spec.ClearField(feed.FieldFeedImageURL, field.TypeString)
	}
	if value, ok := fuo.mutation.FeedCopyright(); ok {
		_spec.SetField(feed.FieldFeedCopyright, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedGenerator(); ok {
		_spec.SetField(feed.FieldFeedGenerator, field.TypeString, value)
	}
	if value, ok := fuo.mutation.FeedCategories(); ok {
		_spec.SetField(feed.FieldFeedCategories, field.TypeString, value)
	}
	if value, ok := fuo.mutation.CreatedAt(); ok {
		_spec.SetField(feed.FieldCreatedAt, field.TypeTime, value)
	}
	if value, ok := fuo.mutation.UpdatedAt(); ok {
		_spec.SetField(feed.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := fuo.mutation.DeletedAt(); ok {
		_spec.SetField(feed.FieldDeletedAt, field.TypeTime, value)
	}
	if fuo.mutation.DeletedAtCleared() {
		_spec.ClearField(feed.FieldDeletedAt, field.TypeTime)
	}
	if fuo.mutation.ItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   feed.ItemsTable,
			Columns: []string{feed.ItemsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fuo.mutation.RemovedItemsIDs(); len(nodes) > 0 && !fuo.mutation.ItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   feed.ItemsTable,
			Columns: []string{feed.ItemsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fuo.mutation.ItemsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   feed.ItemsTable,
			Columns: []string{feed.ItemsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if fuo.mutation.SubscribedUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   feed.SubscribedUsersTable,
			Columns: feed.SubscribedUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		createE := &SubscriptionCreate{config: fuo.config, mutation: newSubscriptionMutation(fuo.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fuo.mutation.RemovedSubscribedUsersIDs(); len(nodes) > 0 && !fuo.mutation.SubscribedUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   feed.SubscribedUsersTable,
			Columns: feed.SubscribedUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &SubscriptionCreate{config: fuo.config, mutation: newSubscriptionMutation(fuo.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fuo.mutation.SubscribedUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   feed.SubscribedUsersTable,
			Columns: feed.SubscribedUsersPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		createE := &SubscriptionCreate{config: fuo.config, mutation: newSubscriptionMutation(fuo.config, OpCreate)}
		createE.defaults()
		_, specE := createE.createSpec()
		edge.Target.Fields = specE.Fields
		if specE.ID.Value != nil {
			edge.Target.Fields = append(edge.Target.Fields, specE.ID)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if fuo.mutation.SubscriptionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   feed.SubscriptionsTable,
			Columns: []string{feed.SubscriptionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(subscription.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fuo.mutation.RemovedSubscriptionsIDs(); len(nodes) > 0 && !fuo.mutation.SubscriptionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   feed.SubscriptionsTable,
			Columns: []string{feed.SubscriptionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(subscription.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := fuo.mutation.SubscriptionsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   feed.SubscriptionsTable,
			Columns: []string{feed.SubscriptionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(subscription.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Feed{config: fuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, fuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{feed.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	fuo.mutation.done = true
	return _node, nil
}
