// Code generated by NodeGenerator. DO NOT EDIT.

// Package node is a generated by the generator.
package node

import (
	"sync/atomic"
	"unsafe"
)

// BSR is a cache entry that provide the following features:
//
// 1. Base
//
// 2. Size
//
// 3. Refresh
type BSR[K comparable, V any] struct {
	key           K
	value         V
	prev          *BSR[K, V]
	next          *BSR[K, V]
	refreshableAt atomic.Int64
	state         atomic.Uint32
	queueType     uint8
}

// NewBSR creates a new BSR.
func NewBSR[K comparable, V any](key K, value V, expiresAt, refreshableAt int64, weight uint32) Node[K, V] {
	n := &BSR[K, V]{
		key:   key,
		value: value,
	}
	n.refreshableAt.Store(refreshableAt)
	n.state.Store(aliveState)

	return n
}

// CastPointerToBSR casts a pointer to BSR.
func CastPointerToBSR[K comparable, V any](ptr unsafe.Pointer) Node[K, V] {
	return (*BSR[K, V])(ptr)
}

func (n *BSR[K, V]) Key() K {
	return n.key
}

func (n *BSR[K, V]) Value() V {
	return n.value
}

func (n *BSR[K, V]) AsPointer() unsafe.Pointer {
	return unsafe.Pointer(n)
}

func (n *BSR[K, V]) Prev() Node[K, V] {
	return n.prev
}

func (n *BSR[K, V]) SetPrev(v Node[K, V]) {
	if v == nil {
		n.prev = nil
		return
	}
	n.prev = (*BSR[K, V])(v.AsPointer())
}

func (n *BSR[K, V]) Next() Node[K, V] {
	return n.next
}

func (n *BSR[K, V]) SetNext(v Node[K, V]) {
	if v == nil {
		n.next = nil
		return
	}
	n.next = (*BSR[K, V])(v.AsPointer())
}

func (n *BSR[K, V]) PrevExp() Node[K, V] {
	panic("not implemented")
}

func (n *BSR[K, V]) SetPrevExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BSR[K, V]) NextExp() Node[K, V] {
	panic("not implemented")
}

func (n *BSR[K, V]) SetNextExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BSR[K, V]) HasExpired(now int64) bool {
	return false
}

func (n *BSR[K, V]) ExpiresAt() int64 {
	panic("not implemented")
}

func (n *BSR[K, V]) CASExpiresAt(old, new int64) bool {
	panic("not implemented")
}

func (n *BSR[K, V]) SetExpiresAt(new int64) {
	panic("not implemented")
}

func (n *BSR[K, V]) RefreshableAt() int64 {
	return n.refreshableAt.Load()
}

func (n *BSR[K, V]) CASRefreshableAt(old, new int64) bool {
	return n.refreshableAt.CompareAndSwap(old, new)
}

func (n *BSR[K, V]) SetRefreshableAt(new int64) {
	n.refreshableAt.Store(new)
}

func (n *BSR[K, V]) IsFresh(now int64) bool {
	return n.IsAlive() && n.RefreshableAt() > now
}

func (n *BSR[K, V]) Weight() uint32 {
	return 1
}

func (n *BSR[K, V]) IsAlive() bool {
	return n.state.Load() == aliveState
}

func (n *BSR[K, V]) IsRetired() bool {
	return n.state.Load() == retiredState
}

func (n *BSR[K, V]) Retire() {
	n.state.Store(retiredState)
}

func (n *BSR[K, V]) IsDead() bool {
	return n.state.Load() == deadState
}

func (n *BSR[K, V]) Die() {
	n.state.Store(deadState)
}

func (n *BSR[K, V]) GetQueueType() uint8 {
	return n.queueType
}

func (n *BSR[K, V]) SetQueueType(queueType uint8) {
	n.queueType = queueType
}

func (n *BSR[K, V]) InWindow() bool {
	return n.GetQueueType() == InWindowQueue
}

func (n *BSR[K, V]) MakeWindow() {
	n.SetQueueType(InWindowQueue)
}

func (n *BSR[K, V]) InMainProbation() bool {
	return n.GetQueueType() == InMainProbationQueue
}

func (n *BSR[K, V]) MakeMainProbation() {
	n.SetQueueType(InMainProbationQueue)
}

func (n *BSR[K, V]) InMainProtected() bool {
	return n.GetQueueType() == InMainProtectedQueue
}

func (n *BSR[K, V]) MakeMainProtected() {
	n.SetQueueType(InMainProtectedQueue)
}
