// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package generate

import (
	"sync"
)

// Ensure, that MyInterfaceMock does implement MyInterface.
// If this is not the case, regenerate this file with moq.
var _ MyInterface = &MyInterfaceMock{}

// MyInterfaceMock is a mock implementation of MyInterface.
//
// 	func TestSomethingThatUsesMyInterface(t *testing.T) {
//
// 		// make and configure a mocked MyInterface
// 		mockedMyInterface := &MyInterfaceMock{
// 			OneFunc: func() bool {
// 				panic("mock out the One method")
// 			},
// 			ThreeFunc: func() string {
// 				panic("mock out the Three method")
// 			},
// 			TwoFunc: func() int {
// 				panic("mock out the Two method")
// 			},
// 		}
//
// 		// use mockedMyInterface in code that requires MyInterface
// 		// and then make assertions.
//
// 	}
type MyInterfaceMock struct {
	// OneFunc mocks the One method.
	OneFunc func() bool

	// ThreeFunc mocks the Three method.
	ThreeFunc func() string

	// TwoFunc mocks the Two method.
	TwoFunc func() int

	// calls tracks calls to the methods.
	calls struct {
		// One holds details about calls to the One method.
		One []struct {
		}
		// Three holds details about calls to the Three method.
		Three []struct {
		}
		// Two holds details about calls to the Two method.
		Two []struct {
		}
	}
	lockOne   sync.RWMutex
	lockThree sync.RWMutex
	lockTwo   sync.RWMutex
}

// One calls OneFunc.
func (mock *MyInterfaceMock) One() bool {
	if mock.OneFunc == nil {
		panic("MyInterfaceMock.OneFunc: method is nil but MyInterface.One was just called")
	}
	callInfo := struct {
	}{}
	mock.lockOne.Lock()
	mock.calls.One = append(mock.calls.One, callInfo)
	mock.lockOne.Unlock()
	return mock.OneFunc()
}

// OneCalls gets all the calls that were made to One.
// Check the length with:
//     len(mockedMyInterface.OneCalls())
func (mock *MyInterfaceMock) OneCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockOne.RLock()
	calls = mock.calls.One
	mock.lockOne.RUnlock()
	return calls
}

// Three calls ThreeFunc.
func (mock *MyInterfaceMock) Three() string {
	if mock.ThreeFunc == nil {
		panic("MyInterfaceMock.ThreeFunc: method is nil but MyInterface.Three was just called")
	}
	callInfo := struct {
	}{}
	mock.lockThree.Lock()
	mock.calls.Three = append(mock.calls.Three, callInfo)
	mock.lockThree.Unlock()
	return mock.ThreeFunc()
}

// ThreeCalls gets all the calls that were made to Three.
// Check the length with:
//     len(mockedMyInterface.ThreeCalls())
func (mock *MyInterfaceMock) ThreeCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockThree.RLock()
	calls = mock.calls.Three
	mock.lockThree.RUnlock()
	return calls
}

// Two calls TwoFunc.
func (mock *MyInterfaceMock) Two() int {
	if mock.TwoFunc == nil {
		panic("MyInterfaceMock.TwoFunc: method is nil but MyInterface.Two was just called")
	}
	callInfo := struct {
	}{}
	mock.lockTwo.Lock()
	mock.calls.Two = append(mock.calls.Two, callInfo)
	mock.lockTwo.Unlock()
	return mock.TwoFunc()
}

// TwoCalls gets all the calls that were made to Two.
// Check the length with:
//     len(mockedMyInterface.TwoCalls())
func (mock *MyInterfaceMock) TwoCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockTwo.RLock()
	calls = mock.calls.Two
	mock.lockTwo.RUnlock()
	return calls
}
