// DO NOT EDIT: This file is autogenerated via the builtin command.

package v1

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 51,
					Line:   45,
				},
				File:   "v1.flux",
				Source: "package v1\n\n// Json parses an InfluxDB 1.x json result into a table stream.\nbuiltin json\n\n// Databases returns the list of available databases, it has no parameters.\nbuiltin databases\n\n// fieldsAsCols is a special application of pivot that will automatically align fields within each measurement that have the same timestamp.\nfieldsAsCols = (tables=<-) =>\n    tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")\n\n// TagValues returns the unique values for a given tag.\n// The return value is always a single table with a single column \"_value\".\ntagValues = (bucket, tag, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)\n\n// MeasurementTagValues returns a single table with a single column \"_value\" that contains the\n// The return value is always a single table with a single column \"_value\".\nmeasurementTagValues = (bucket, measurement, tag) =>\n    tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)\n\n// TagKeys returns the list of tag keys for all series that match the predicate.\n// The return value is always a single table with a single column \"_value\".\ntagKeys = (bucket, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()\n\n// MeasurementTagKeys returns the list of tag keys for a specific measurement.\nmeasurementTagKeys = (bucket, measurement) =>\n    tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)\n\n// Measurements returns the list of measurements in a specific bucket.\nmeasurements = (bucket) =>\n    tagValues(bucket: bucket, tag: \"_measurement\")",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   4,
					},
					File:   "v1.flux",
					Source: "builtin json",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   4,
						},
						File:   "v1.flux",
						Source: "json",
						Start: ast.Position{
							Column: 9,
							Line:   4,
						},
					},
				},
				Name: "json",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   7,
					},
					File:   "v1.flux",
					Source: "builtin databases",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   7,
						},
						File:   "v1.flux",
						Source: "databases",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Name: "databases",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   12,
					},
					File:   "v1.flux",
					Source: "fieldsAsCols = (tables=<-) =>\n    tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   10,
						},
						File:   "v1.flux",
						Source: "fieldsAsCols",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "fieldsAsCols",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   12,
						},
						File:   "v1.flux",
						Source: "(tables=<-) =>\n    tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
						Start: ast.Position{
							Column: 16,
							Line:   10,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   11,
								},
								File:   "v1.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   11,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   12,
							},
							File:   "v1.flux",
							Source: "tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
							Start: ast.Position{
								Column: 5,
								Line:   11,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   12,
									},
									File:   "v1.flux",
									Source: "rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\"",
									Start: ast.Position{
										Column: 18,
										Line:   12,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   12,
										},
										File:   "v1.flux",
										Source: "rowKey:[\"_time\"]",
										Start: ast.Position{
											Column: 18,
											Line:   12,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   12,
											},
											File:   "v1.flux",
											Source: "rowKey",
											Start: ast.Position{
												Column: 18,
												Line:   12,
											},
										},
									},
									Name: "rowKey",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   12,
											},
											File:   "v1.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 25,
												Line:   12,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   12,
												},
												File:   "v1.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 26,
													Line:   12,
												},
											},
										},
										Value: "_time",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   12,
										},
										File:   "v1.flux",
										Source: "columnKey: [\"_field\"]",
										Start: ast.Position{
											Column: 36,
											Line:   12,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   12,
											},
											File:   "v1.flux",
											Source: "columnKey",
											Start: ast.Position{
												Column: 36,
												Line:   12,
											},
										},
									},
									Name: "columnKey",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   12,
											},
											File:   "v1.flux",
											Source: "[\"_field\"]",
											Start: ast.Position{
												Column: 47,
												Line:   12,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   12,
												},
												File:   "v1.flux",
												Source: "\"_field\"",
												Start: ast.Position{
													Column: 48,
													Line:   12,
												},
											},
										},
										Value: "_field",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   12,
										},
										File:   "v1.flux",
										Source: "valueColumn: \"_value\"",
										Start: ast.Position{
											Column: 59,
											Line:   12,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   12,
											},
											File:   "v1.flux",
											Source: "valueColumn",
											Start: ast.Position{
												Column: 59,
												Line:   12,
											},
										},
									},
									Name: "valueColumn",
								},
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   12,
											},
											File:   "v1.flux",
											Source: "\"_value\"",
											Start: ast.Position{
												Column: 72,
												Line:   12,
											},
										},
									},
									Value: "_value",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   12,
								},
								File:   "v1.flux",
								Source: "pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
								Start: ast.Position{
									Column: 12,
									Line:   12,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   12,
									},
									File:   "v1.flux",
									Source: "pivot",
									Start: ast.Position{
										Column: 12,
										Line:   12,
									},
								},
							},
							Name: "pivot",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   10,
							},
							File:   "v1.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   10,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   10,
								},
								File:   "v1.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   10,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   10,
							},
							File:   "v1.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   10,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 31,
						Line:   22,
					},
					File:   "v1.flux",
					Source: "tagValues = (bucket, tag, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   16,
						},
						File:   "v1.flux",
						Source: "tagValues",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "tagValues",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 31,
							Line:   22,
						},
						File:   "v1.flux",
						Source: "(bucket, tag, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)",
						Start: ast.Position{
							Column: 13,
							Line:   16,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   17,
													},
													File:   "v1.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 10,
														Line:   17,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   17,
														},
														File:   "v1.flux",
														Source: "bucket: bucket",
														Start: ast.Position{
															Column: 10,
															Line:   17,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   17,
															},
															File:   "v1.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 10,
																Line:   17,
															},
														},
													},
													Name: "bucket",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   17,
															},
															File:   "v1.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 18,
																Line:   17,
															},
														},
													},
													Name: "bucket",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   17,
												},
												File:   "v1.flux",
												Source: "from(bucket: bucket)",
												Start: ast.Position{
													Column: 5,
													Line:   17,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   17,
													},
													File:   "v1.flux",
													Source: "from",
													Start: ast.Position{
														Column: 5,
														Line:   17,
													},
												},
											},
											Name: "from",
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   18,
											},
											File:   "v1.flux",
											Source: "from(bucket: bucket)\n      |> range(start: start)",
											Start: ast.Position{
												Column: 5,
												Line:   17,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   18,
													},
													File:   "v1.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 16,
														Line:   18,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   18,
														},
														File:   "v1.flux",
														Source: "start: start",
														Start: ast.Position{
															Column: 16,
															Line:   18,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   18,
															},
															File:   "v1.flux",
															Source: "start",
															Start: ast.Position{
																Column: 16,
																Line:   18,
															},
														},
													},
													Name: "start",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   18,
															},
															File:   "v1.flux",
															Source: "start",
															Start: ast.Position{
																Column: 23,
																Line:   18,
															},
														},
													},
													Name: "start",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   18,
												},
												File:   "v1.flux",
												Source: "range(start: start)",
												Start: ast.Position{
													Column: 10,
													Line:   18,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   18,
													},
													File:   "v1.flux",
													Source: "range",
													Start: ast.Position{
														Column: 10,
														Line:   18,
													},
												},
											},
											Name: "range",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   19,
										},
										File:   "v1.flux",
										Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)",
										Start: ast.Position{
											Column: 5,
											Line:   17,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   19,
												},
												File:   "v1.flux",
												Source: "fn: predicate",
												Start: ast.Position{
													Column: 17,
													Line:   19,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   19,
													},
													File:   "v1.flux",
													Source: "fn: predicate",
													Start: ast.Position{
														Column: 17,
														Line:   19,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   19,
														},
														File:   "v1.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 17,
															Line:   19,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   19,
														},
														File:   "v1.flux",
														Source: "predicate",
														Start: ast.Position{
															Column: 21,
															Line:   19,
														},
													},
												},
												Name: "predicate",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   19,
											},
											File:   "v1.flux",
											Source: "filter(fn: predicate)",
											Start: ast.Position{
												Column: 10,
												Line:   19,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   19,
												},
												File:   "v1.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 10,
													Line:   19,
												},
											},
										},
										Name: "filter",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   20,
									},
									File:   "v1.flux",
									Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   20,
											},
											File:   "v1.flux",
											Source: "columns: [tag]",
											Start: ast.Position{
												Column: 15,
												Line:   20,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   20,
												},
												File:   "v1.flux",
												Source: "columns: [tag]",
												Start: ast.Position{
													Column: 15,
													Line:   20,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   20,
													},
													File:   "v1.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 15,
														Line:   20,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   20,
													},
													File:   "v1.flux",
													Source: "[tag]",
													Start: ast.Position{
														Column: 24,
														Line:   20,
													},
												},
											},
											Elements: []ast.Expression{&ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   20,
														},
														File:   "v1.flux",
														Source: "tag",
														Start: ast.Position{
															Column: 25,
															Line:   20,
														},
													},
												},
												Name: "tag",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   20,
										},
										File:   "v1.flux",
										Source: "keep(columns: [tag])",
										Start: ast.Position{
											Column: 10,
											Line:   20,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   20,
											},
											File:   "v1.flux",
											Source: "keep",
											Start: ast.Position{
												Column: 10,
												Line:   20,
											},
										},
									},
									Name: "keep",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   21,
								},
								File:   "v1.flux",
								Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   21,
									},
									File:   "v1.flux",
									Source: "group()",
									Start: ast.Position{
										Column: 10,
										Line:   21,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   21,
										},
										File:   "v1.flux",
										Source: "group",
										Start: ast.Position{
											Column: 10,
											Line:   21,
										},
									},
								},
								Name: "group",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   22,
							},
							File:   "v1.flux",
							Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)",
							Start: ast.Position{
								Column: 5,
								Line:   17,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   22,
									},
									File:   "v1.flux",
									Source: "column: tag",
									Start: ast.Position{
										Column: 19,
										Line:   22,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   22,
										},
										File:   "v1.flux",
										Source: "column: tag",
										Start: ast.Position{
											Column: 19,
											Line:   22,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   22,
											},
											File:   "v1.flux",
											Source: "column",
											Start: ast.Position{
												Column: 19,
												Line:   22,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   22,
											},
											File:   "v1.flux",
											Source: "tag",
											Start: ast.Position{
												Column: 27,
												Line:   22,
											},
										},
									},
									Name: "tag",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   22,
								},
								File:   "v1.flux",
								Source: "distinct(column: tag)",
								Start: ast.Position{
									Column: 10,
									Line:   22,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   22,
									},
									File:   "v1.flux",
									Source: "distinct",
									Start: ast.Position{
										Column: 10,
										Line:   22,
									},
								},
							},
							Name: "distinct",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   16,
							},
							File:   "v1.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 14,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   16,
								},
								File:   "v1.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 14,
									Line:   16,
								},
							},
						},
						Name: "bucket",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   16,
							},
							File:   "v1.flux",
							Source: "tag",
							Start: ast.Position{
								Column: 22,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   16,
								},
								File:   "v1.flux",
								Source: "tag",
								Start: ast.Position{
									Column: 22,
									Line:   16,
								},
							},
						},
						Name: "tag",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   16,
							},
							File:   "v1.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 27,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   16,
								},
								File:   "v1.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 27,
									Line:   16,
								},
							},
						},
						Name: "predicate",
					},
					Value: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   16,
								},
								File:   "v1.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 37,
									Line:   16,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   16,
									},
									File:   "v1.flux",
									Source: "true",
									Start: ast.Position{
										Column: 44,
										Line:   16,
									},
								},
							},
							Name: "true",
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   16,
									},
									File:   "v1.flux",
									Source: "r",
									Start: ast.Position{
										Column: 38,
										Line:   16,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   16,
										},
										File:   "v1.flux",
										Source: "r",
										Start: ast.Position{
											Column: 38,
											Line:   16,
										},
									},
								},
								Name: "r",
							},
							Value: nil,
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   16,
							},
							File:   "v1.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 50,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   16,
								},
								File:   "v1.flux",
								Source: "start",
								Start: ast.Position{
									Column: 50,
									Line:   16,
								},
							},
						},
						Name: "start",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   16,
									},
									File:   "v1.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 57,
										Line:   16,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   16,
								},
								File:   "v1.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 56,
									Line:   16,
								},
							},
						},
						Operator: 6,
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 89,
						Line:   27,
					},
					File:   "v1.flux",
					Source: "measurementTagValues = (bucket, measurement, tag) =>\n    tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   26,
						},
						File:   "v1.flux",
						Source: "measurementTagValues",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "measurementTagValues",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   27,
						},
						File:   "v1.flux",
						Source: "(bucket, measurement, tag) =>\n    tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
						Start: ast.Position{
							Column: 24,
							Line:   26,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   27,
								},
								File:   "v1.flux",
								Source: "bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement",
								Start: ast.Position{
									Column: 15,
									Line:   27,
								},
							},
						},
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   27,
									},
									File:   "v1.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 15,
										Line:   27,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   27,
										},
										File:   "v1.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 15,
											Line:   27,
										},
									},
								},
								Name: "bucket",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   27,
										},
										File:   "v1.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 23,
											Line:   27,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   27,
									},
									File:   "v1.flux",
									Source: "tag: tag",
									Start: ast.Position{
										Column: 31,
										Line:   27,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   27,
										},
										File:   "v1.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 31,
											Line:   27,
										},
									},
								},
								Name: "tag",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   27,
										},
										File:   "v1.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 36,
											Line:   27,
										},
									},
								},
								Name: "tag",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   27,
									},
									File:   "v1.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 41,
										Line:   27,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   27,
										},
										File:   "v1.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 41,
											Line:   27,
										},
									},
								},
								Name: "predicate",
							},
							Value: &ast.FunctionExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   27,
										},
										File:   "v1.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 52,
											Line:   27,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   27,
											},
											File:   "v1.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 59,
												Line:   27,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   27,
												},
												File:   "v1.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 59,
													Line:   27,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   27,
													},
													File:   "v1.flux",
													Source: "r",
													Start: ast.Position{
														Column: 59,
														Line:   27,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   27,
													},
													File:   "v1.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 61,
														Line:   27,
													},
												},
											},
											Name: "_measurement",
										},
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   27,
												},
												File:   "v1.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 77,
													Line:   27,
												},
											},
										},
										Name: "measurement",
									},
								},
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   27,
											},
											File:   "v1.flux",
											Source: "r",
											Start: ast.Position{
												Column: 53,
												Line:   27,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   27,
												},
												File:   "v1.flux",
												Source: "r",
												Start: ast.Position{
													Column: 53,
													Line:   27,
												},
											},
										},
										Name: "r",
									},
									Value: nil,
								}},
							},
						}},
						With: nil,
					}},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   27,
							},
							File:   "v1.flux",
							Source: "tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
							Start: ast.Position{
								Column: 5,
								Line:   27,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   27,
								},
								File:   "v1.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
						Name: "tagValues",
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   26,
							},
							File:   "v1.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 25,
								Line:   26,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   26,
								},
								File:   "v1.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 25,
									Line:   26,
								},
							},
						},
						Name: "bucket",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   26,
							},
							File:   "v1.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 33,
								Line:   26,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   26,
								},
								File:   "v1.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 33,
									Line:   26,
								},
							},
						},
						Name: "measurement",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   26,
							},
							File:   "v1.flux",
							Source: "tag",
							Start: ast.Position{
								Column: 46,
								Line:   26,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   26,
								},
								File:   "v1.flux",
								Source: "tag",
								Start: ast.Position{
									Column: 46,
									Line:   26,
								},
							},
						},
						Name: "tag",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   37,
					},
					File:   "v1.flux",
					Source: "tagKeys = (bucket, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   31,
						},
						File:   "v1.flux",
						Source: "tagKeys",
						Start: ast.Position{
							Column: 1,
							Line:   31,
						},
					},
				},
				Name: "tagKeys",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   37,
						},
						File:   "v1.flux",
						Source: "(bucket, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()",
						Start: ast.Position{
							Column: 11,
							Line:   31,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   32,
													},
													File:   "v1.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 10,
														Line:   32,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   32,
														},
														File:   "v1.flux",
														Source: "bucket: bucket",
														Start: ast.Position{
															Column: 10,
															Line:   32,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   32,
															},
															File:   "v1.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 10,
																Line:   32,
															},
														},
													},
													Name: "bucket",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   32,
															},
															File:   "v1.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 18,
																Line:   32,
															},
														},
													},
													Name: "bucket",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   32,
												},
												File:   "v1.flux",
												Source: "from(bucket: bucket)",
												Start: ast.Position{
													Column: 5,
													Line:   32,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   32,
													},
													File:   "v1.flux",
													Source: "from",
													Start: ast.Position{
														Column: 5,
														Line:   32,
													},
												},
											},
											Name: "from",
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   33,
											},
											File:   "v1.flux",
											Source: "from(bucket: bucket)\n        |> range(start: start)",
											Start: ast.Position{
												Column: 5,
												Line:   32,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   33,
													},
													File:   "v1.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 18,
														Line:   33,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   33,
														},
														File:   "v1.flux",
														Source: "start: start",
														Start: ast.Position{
															Column: 18,
															Line:   33,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   33,
															},
															File:   "v1.flux",
															Source: "start",
															Start: ast.Position{
																Column: 18,
																Line:   33,
															},
														},
													},
													Name: "start",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   33,
															},
															File:   "v1.flux",
															Source: "start",
															Start: ast.Position{
																Column: 25,
																Line:   33,
															},
														},
													},
													Name: "start",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   33,
												},
												File:   "v1.flux",
												Source: "range(start: start)",
												Start: ast.Position{
													Column: 12,
													Line:   33,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   33,
													},
													File:   "v1.flux",
													Source: "range",
													Start: ast.Position{
														Column: 12,
														Line:   33,
													},
												},
											},
											Name: "range",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   34,
										},
										File:   "v1.flux",
										Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)",
										Start: ast.Position{
											Column: 5,
											Line:   32,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   34,
												},
												File:   "v1.flux",
												Source: "fn: predicate",
												Start: ast.Position{
													Column: 19,
													Line:   34,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   34,
													},
													File:   "v1.flux",
													Source: "fn: predicate",
													Start: ast.Position{
														Column: 19,
														Line:   34,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   34,
														},
														File:   "v1.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   34,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   34,
														},
														File:   "v1.flux",
														Source: "predicate",
														Start: ast.Position{
															Column: 23,
															Line:   34,
														},
													},
												},
												Name: "predicate",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   34,
											},
											File:   "v1.flux",
											Source: "filter(fn: predicate)",
											Start: ast.Position{
												Column: 12,
												Line:   34,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   34,
												},
												File:   "v1.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 12,
													Line:   34,
												},
											},
										},
										Name: "filter",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   35,
									},
									File:   "v1.flux",
									Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()",
									Start: ast.Position{
										Column: 5,
										Line:   32,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   35,
										},
										File:   "v1.flux",
										Source: "keys()",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   35,
											},
											File:   "v1.flux",
											Source: "keys",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "keys",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   36,
								},
								File:   "v1.flux",
								Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])",
								Start: ast.Position{
									Column: 5,
									Line:   32,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   36,
										},
										File:   "v1.flux",
										Source: "columns: [\"_value\"]",
										Start: ast.Position{
											Column: 17,
											Line:   36,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   36,
											},
											File:   "v1.flux",
											Source: "columns: [\"_value\"]",
											Start: ast.Position{
												Column: 17,
												Line:   36,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   36,
												},
												File:   "v1.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 17,
													Line:   36,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   36,
												},
												File:   "v1.flux",
												Source: "[\"_value\"]",
												Start: ast.Position{
													Column: 26,
													Line:   36,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   36,
													},
													File:   "v1.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 27,
														Line:   36,
													},
												},
											},
											Value: "_value",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   36,
									},
									File:   "v1.flux",
									Source: "keep(columns: [\"_value\"])",
									Start: ast.Position{
										Column: 12,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   36,
										},
										File:   "v1.flux",
										Source: "keep",
										Start: ast.Position{
											Column: 12,
											Line:   36,
										},
									},
								},
								Name: "keep",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   37,
							},
							File:   "v1.flux",
							Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()",
							Start: ast.Position{
								Column: 5,
								Line:   32,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   37,
								},
								File:   "v1.flux",
								Source: "distinct()",
								Start: ast.Position{
									Column: 12,
									Line:   37,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   37,
									},
									File:   "v1.flux",
									Source: "distinct",
									Start: ast.Position{
										Column: 12,
										Line:   37,
									},
								},
							},
							Name: "distinct",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   31,
							},
							File:   "v1.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 12,
								Line:   31,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   31,
								},
								File:   "v1.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 12,
									Line:   31,
								},
							},
						},
						Name: "bucket",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   31,
							},
							File:   "v1.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 20,
								Line:   31,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   31,
								},
								File:   "v1.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 20,
									Line:   31,
								},
							},
						},
						Name: "predicate",
					},
					Value: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   31,
								},
								File:   "v1.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 30,
									Line:   31,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   31,
									},
									File:   "v1.flux",
									Source: "true",
									Start: ast.Position{
										Column: 37,
										Line:   31,
									},
								},
							},
							Name: "true",
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   31,
									},
									File:   "v1.flux",
									Source: "r",
									Start: ast.Position{
										Column: 31,
										Line:   31,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   31,
										},
										File:   "v1.flux",
										Source: "r",
										Start: ast.Position{
											Column: 31,
											Line:   31,
										},
									},
								},
								Name: "r",
							},
							Value: nil,
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   31,
							},
							File:   "v1.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 43,
								Line:   31,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   31,
								},
								File:   "v1.flux",
								Source: "start",
								Start: ast.Position{
									Column: 43,
									Line:   31,
								},
							},
						},
						Name: "start",
					},
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   31,
									},
									File:   "v1.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 50,
										Line:   31,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   31,
								},
								File:   "v1.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 49,
									Line:   31,
								},
							},
						},
						Operator: 6,
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 77,
						Line:   41,
					},
					File:   "v1.flux",
					Source: "measurementTagKeys = (bucket, measurement) =>\n    tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   40,
						},
						File:   "v1.flux",
						Source: "measurementTagKeys",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "measurementTagKeys",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 77,
							Line:   41,
						},
						File:   "v1.flux",
						Source: "(bucket, measurement) =>\n    tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
						Start: ast.Position{
							Column: 22,
							Line:   40,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   41,
								},
								File:   "v1.flux",
								Source: "bucket: bucket, predicate: (r) => r._measurement == measurement",
								Start: ast.Position{
									Column: 13,
									Line:   41,
								},
							},
						},
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   41,
									},
									File:   "v1.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 13,
										Line:   41,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   41,
										},
										File:   "v1.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 13,
											Line:   41,
										},
									},
								},
								Name: "bucket",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   41,
										},
										File:   "v1.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 21,
											Line:   41,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   41,
									},
									File:   "v1.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 29,
										Line:   41,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   41,
										},
										File:   "v1.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 29,
											Line:   41,
										},
									},
								},
								Name: "predicate",
							},
							Value: &ast.FunctionExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   41,
										},
										File:   "v1.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 40,
											Line:   41,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   41,
											},
											File:   "v1.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 47,
												Line:   41,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   41,
												},
												File:   "v1.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 47,
													Line:   41,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   41,
													},
													File:   "v1.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   41,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   41,
													},
													File:   "v1.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 49,
														Line:   41,
													},
												},
											},
											Name: "_measurement",
										},
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   41,
												},
												File:   "v1.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 65,
													Line:   41,
												},
											},
										},
										Name: "measurement",
									},
								},
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   41,
											},
											File:   "v1.flux",
											Source: "r",
											Start: ast.Position{
												Column: 41,
												Line:   41,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   41,
												},
												File:   "v1.flux",
												Source: "r",
												Start: ast.Position{
													Column: 41,
													Line:   41,
												},
											},
										},
										Name: "r",
									},
									Value: nil,
								}},
							},
						}},
						With: nil,
					}},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   41,
							},
							File:   "v1.flux",
							Source: "tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
							Start: ast.Position{
								Column: 5,
								Line:   41,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   41,
								},
								File:   "v1.flux",
								Source: "tagKeys",
								Start: ast.Position{
									Column: 5,
									Line:   41,
								},
							},
						},
						Name: "tagKeys",
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   40,
							},
							File:   "v1.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 23,
								Line:   40,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   40,
								},
								File:   "v1.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 23,
									Line:   40,
								},
							},
						},
						Name: "bucket",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   40,
							},
							File:   "v1.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 31,
								Line:   40,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   40,
								},
								File:   "v1.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 31,
									Line:   40,
								},
							},
						},
						Name: "measurement",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 51,
						Line:   45,
					},
					File:   "v1.flux",
					Source: "measurements = (bucket) =>\n    tagValues(bucket: bucket, tag: \"_measurement\")",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   44,
						},
						File:   "v1.flux",
						Source: "measurements",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "measurements",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   45,
						},
						File:   "v1.flux",
						Source: "(bucket) =>\n    tagValues(bucket: bucket, tag: \"_measurement\")",
						Start: ast.Position{
							Column: 16,
							Line:   44,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   45,
								},
								File:   "v1.flux",
								Source: "bucket: bucket, tag: \"_measurement\"",
								Start: ast.Position{
									Column: 15,
									Line:   45,
								},
							},
						},
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   45,
									},
									File:   "v1.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 15,
										Line:   45,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   45,
										},
										File:   "v1.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 15,
											Line:   45,
										},
									},
								},
								Name: "bucket",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   45,
										},
										File:   "v1.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 23,
											Line:   45,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   45,
									},
									File:   "v1.flux",
									Source: "tag: \"_measurement\"",
									Start: ast.Position{
										Column: 31,
										Line:   45,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   45,
										},
										File:   "v1.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 31,
											Line:   45,
										},
									},
								},
								Name: "tag",
							},
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   45,
										},
										File:   "v1.flux",
										Source: "\"_measurement\"",
										Start: ast.Position{
											Column: 36,
											Line:   45,
										},
									},
								},
								Value: "_measurement",
							},
						}},
						With: nil,
					}},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   45,
							},
							File:   "v1.flux",
							Source: "tagValues(bucket: bucket, tag: \"_measurement\")",
							Start: ast.Position{
								Column: 5,
								Line:   45,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   45,
								},
								File:   "v1.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Name: "tagValues",
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   44,
							},
							File:   "v1.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 17,
								Line:   44,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   44,
								},
								File:   "v1.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 17,
									Line:   44,
								},
							},
						},
						Name: "bucket",
					},
					Value: nil,
				}},
			},
		}},
		Imports:  nil,
		Metadata: "parser-type=go",
		Name:     "v1.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   1,
					},
					File:   "v1.flux",
					Source: "package v1",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   1,
						},
						File:   "v1.flux",
						Source: "v1",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "v1",
			},
		},
	}},
	Package: "v1",
	Path:    "influxdata/influxdb/v1",
}
