package ansible

import (
	_ "embed"
	"fmt"
	"io/ioutil"
	"os"
	"os/exec"
	"regexp"
	"testing"

	"github.com/hashicorp/packer-plugin-sdk/acctest"
)

//go:embed test-fixtures/docker_playbookfile_template.pkr.hcl
var testPlaybookFileTemplate string

// Run with: PACKER_ACC=1 go test -count 1 -v ./provisioner/ansible/provisioner_acc_test.go  -timeout=120m
func TestAccAnsibleProvisioner_basic(t *testing.T) {
	testCase := &acctest.PluginTestCase{
		Name: "ansible_provisioner_docker_playbookfile_test",
		Init: true,
		Setup: func() error {
			var p Provisioner
			p.config.Command = "ansible-playbook"
			return p.getVersion()
		},
		Template: testPlaybookFileTemplate,
		Type:     "ansible",
		Check: func(buildCommand *exec.Cmd, logfile string) error {
			if buildCommand.ProcessState != nil {
				if buildCommand.ProcessState.ExitCode() != 0 {
					return fmt.Errorf("Bad exit code. Logfile: %s", logfile)
				}
			}

			logs, err := os.Open(logfile)
			if err != nil {
				return fmt.Errorf("Unable find %s", logfile)
			}
			defer logs.Close()

			logsBytes, err := ioutil.ReadAll(logs)
			if err != nil {
				return fmt.Errorf("Unable to read %s", logfile)
			}
			logsString := string(logsBytes)

			provisionerOutputLog := "docker.autogenerated_1: PLAY RECAP"
			if matched, _ := regexp.MatchString(provisionerOutputLog+".*", logsString); !matched {
				t.Fatalf("logs doesn't contain expected foo value %q", logsString)
			}
			return nil
		},
	}
	acctest.TestPlugin(t, testCase)
}
