// Code generated by go-swagger; DO NOT EDIT.

package tasks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AddCommentToTaskHandlerFunc turns a function with the right signature into a add comment to task handler
type AddCommentToTaskHandlerFunc func(AddCommentToTaskParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn AddCommentToTaskHandlerFunc) Handle(params AddCommentToTaskParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// AddCommentToTaskHandler interface for that can handle valid add comment to task params
type AddCommentToTaskHandler interface {
	Handle(AddCommentToTaskParams, interface{}) middleware.Responder
}

// NewAddCommentToTask creates a new http.Handler for the add comment to task operation
func NewAddCommentToTask(ctx *middleware.Context, handler AddCommentToTaskHandler) *AddCommentToTask {
	return &AddCommentToTask{Context: ctx, Handler: handler}
}

/*
	AddCommentToTask swagger:route POST /tasks/{id}/comments tasks addCommentToTask

# Adds a comment to a task

The comment can contain ___github markdown___ syntax.
Fenced codeblocks etc are supported through pygments.
*/
type AddCommentToTask struct {
	Context *middleware.Context
	Handler AddCommentToTaskHandler
}

func (o *AddCommentToTask) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewAddCommentToTaskParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// AddCommentToTaskBody A comment to create
//
// These values can have github flavored markdown.
//
// swagger:model AddCommentToTaskBody
type AddCommentToTaskBody struct {

	// content
	// Required: true
	Content *string `json:"content"`

	// user Id
	// Required: true
	UserID *int64 `json:"userId"`
}

// Validate validates this add comment to task body
func (o *AddCommentToTaskBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUserID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AddCommentToTaskBody) validateContent(formats strfmt.Registry) error {

	if err := validate.Required("body"+"."+"content", "body", o.Content); err != nil {
		return err
	}

	return nil
}

func (o *AddCommentToTaskBody) validateUserID(formats strfmt.Registry) error {

	if err := validate.Required("body"+"."+"userId", "body", o.UserID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this add comment to task body based on context it is used
func (o *AddCommentToTaskBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *AddCommentToTaskBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AddCommentToTaskBody) UnmarshalBinary(b []byte) error {
	var res AddCommentToTaskBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
