// This file is generated by "./lib/proto/generate"

package proto

/*

Page

Actions and events related to the inspected page belong to the page domain.

*/

// PageFrameID Unique frame identifier.
type PageFrameID string

// PageAdFrameType (experimental) Indicates whether a frame has been identified as an ad.
type PageAdFrameType string

const (
	// PageAdFrameTypeNone enum const.
	PageAdFrameTypeNone PageAdFrameType = "none"

	// PageAdFrameTypeChild enum const.
	PageAdFrameTypeChild PageAdFrameType = "child"

	// PageAdFrameTypeRoot enum const.
	PageAdFrameTypeRoot PageAdFrameType = "root"
)

// PageAdFrameExplanation (experimental) ...
type PageAdFrameExplanation string

const (
	// PageAdFrameExplanationParentIsAd enum const.
	PageAdFrameExplanationParentIsAd PageAdFrameExplanation = "ParentIsAd"

	// PageAdFrameExplanationCreatedByAdScript enum const.
	PageAdFrameExplanationCreatedByAdScript PageAdFrameExplanation = "CreatedByAdScript"

	// PageAdFrameExplanationMatchedBlockingRule enum const.
	PageAdFrameExplanationMatchedBlockingRule PageAdFrameExplanation = "MatchedBlockingRule"
)

// PageAdFrameStatus (experimental) Indicates whether a frame has been identified as an ad and why.
type PageAdFrameStatus struct {
	// AdFrameType ...
	AdFrameType PageAdFrameType `json:"adFrameType"`

	// Explanations (optional) ...
	Explanations []PageAdFrameExplanation `json:"explanations,omitempty"`
}

// PageAdScriptID (experimental) Identifies the bottom-most script which caused the frame to be labelled
// as an ad.
type PageAdScriptID struct {
	// ScriptID Script Id of the bottom-most script which caused the frame to be labelled
	// as an ad.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// DebuggerID Id of adScriptId's debugger.
	DebuggerID RuntimeUniqueDebuggerID `json:"debuggerId"`
}

// PageSecureContextType (experimental) Indicates whether the frame is a secure context and why it is the case.
type PageSecureContextType string

const (
	// PageSecureContextTypeSecure enum const.
	PageSecureContextTypeSecure PageSecureContextType = "Secure"

	// PageSecureContextTypeSecureLocalhost enum const.
	PageSecureContextTypeSecureLocalhost PageSecureContextType = "SecureLocalhost"

	// PageSecureContextTypeInsecureScheme enum const.
	PageSecureContextTypeInsecureScheme PageSecureContextType = "InsecureScheme"

	// PageSecureContextTypeInsecureAncestor enum const.
	PageSecureContextTypeInsecureAncestor PageSecureContextType = "InsecureAncestor"
)

// PageCrossOriginIsolatedContextType (experimental) Indicates whether the frame is cross-origin isolated and why it is the case.
type PageCrossOriginIsolatedContextType string

const (
	// PageCrossOriginIsolatedContextTypeIsolated enum const.
	PageCrossOriginIsolatedContextTypeIsolated PageCrossOriginIsolatedContextType = "Isolated"

	// PageCrossOriginIsolatedContextTypeNotIsolated enum const.
	PageCrossOriginIsolatedContextTypeNotIsolated PageCrossOriginIsolatedContextType = "NotIsolated"

	// PageCrossOriginIsolatedContextTypeNotIsolatedFeatureDisabled enum const.
	PageCrossOriginIsolatedContextTypeNotIsolatedFeatureDisabled PageCrossOriginIsolatedContextType = "NotIsolatedFeatureDisabled"
)

// PageGatedAPIFeatures (experimental) ...
type PageGatedAPIFeatures string

const (
	// PageGatedAPIFeaturesSharedArrayBuffers enum const.
	PageGatedAPIFeaturesSharedArrayBuffers PageGatedAPIFeatures = "SharedArrayBuffers"

	// PageGatedAPIFeaturesSharedArrayBuffersTransferAllowed enum const.
	PageGatedAPIFeaturesSharedArrayBuffersTransferAllowed PageGatedAPIFeatures = "SharedArrayBuffersTransferAllowed"

	// PageGatedAPIFeaturesPerformanceMeasureMemory enum const.
	PageGatedAPIFeaturesPerformanceMeasureMemory PageGatedAPIFeatures = "PerformanceMeasureMemory"

	// PageGatedAPIFeaturesPerformanceProfile enum const.
	PageGatedAPIFeaturesPerformanceProfile PageGatedAPIFeatures = "PerformanceProfile"
)

// PagePermissionsPolicyFeature (experimental) All Permissions Policy features. This enum should match the one defined
// in third_party/blink/renderer/core/permissions_policy/permissions_policy_features.json5.
type PagePermissionsPolicyFeature string

const (
	// PagePermissionsPolicyFeatureAccelerometer enum const.
	PagePermissionsPolicyFeatureAccelerometer PagePermissionsPolicyFeature = "accelerometer"

	// PagePermissionsPolicyFeatureAmbientLightSensor enum const.
	PagePermissionsPolicyFeatureAmbientLightSensor PagePermissionsPolicyFeature = "ambient-light-sensor"

	// PagePermissionsPolicyFeatureAttributionReporting enum const.
	PagePermissionsPolicyFeatureAttributionReporting PagePermissionsPolicyFeature = "attribution-reporting"

	// PagePermissionsPolicyFeatureAutoplay enum const.
	PagePermissionsPolicyFeatureAutoplay PagePermissionsPolicyFeature = "autoplay"

	// PagePermissionsPolicyFeatureBluetooth enum const.
	PagePermissionsPolicyFeatureBluetooth PagePermissionsPolicyFeature = "bluetooth"

	// PagePermissionsPolicyFeatureBrowsingTopics enum const.
	PagePermissionsPolicyFeatureBrowsingTopics PagePermissionsPolicyFeature = "browsing-topics"

	// PagePermissionsPolicyFeatureCamera enum const.
	PagePermissionsPolicyFeatureCamera PagePermissionsPolicyFeature = "camera"

	// PagePermissionsPolicyFeatureCapturedSurfaceControl enum const.
	PagePermissionsPolicyFeatureCapturedSurfaceControl PagePermissionsPolicyFeature = "captured-surface-control"

	// PagePermissionsPolicyFeatureChDpr enum const.
	PagePermissionsPolicyFeatureChDpr PagePermissionsPolicyFeature = "ch-dpr"

	// PagePermissionsPolicyFeatureChDeviceMemory enum const.
	PagePermissionsPolicyFeatureChDeviceMemory PagePermissionsPolicyFeature = "ch-device-memory"

	// PagePermissionsPolicyFeatureChDownlink enum const.
	PagePermissionsPolicyFeatureChDownlink PagePermissionsPolicyFeature = "ch-downlink"

	// PagePermissionsPolicyFeatureChEct enum const.
	PagePermissionsPolicyFeatureChEct PagePermissionsPolicyFeature = "ch-etc"

	// PagePermissionsPolicyFeatureChPrefersColorScheme enum const.
	PagePermissionsPolicyFeatureChPrefersColorScheme PagePermissionsPolicyFeature = "ch-prefers-color-scheme"

	// PagePermissionsPolicyFeatureChPrefersReducedMotion enum const.
	PagePermissionsPolicyFeatureChPrefersReducedMotion PagePermissionsPolicyFeature = "ch-prefers-reduced-motion"

	// PagePermissionsPolicyFeatureChPrefersReducedTransparency enum const.
	PagePermissionsPolicyFeatureChPrefersReducedTransparency PagePermissionsPolicyFeature = "ch-prefers-reduced-transparency"

	// PagePermissionsPolicyFeatureChRtt enum const.
	PagePermissionsPolicyFeatureChRtt PagePermissionsPolicyFeature = "ch-rtt"

	// PagePermissionsPolicyFeatureChSaveData enum const.
	PagePermissionsPolicyFeatureChSaveData PagePermissionsPolicyFeature = "ch-save-data"

	// PagePermissionsPolicyFeatureChUa enum const.
	PagePermissionsPolicyFeatureChUa PagePermissionsPolicyFeature = "ch-ua"

	// PagePermissionsPolicyFeatureChUaArch enum const.
	PagePermissionsPolicyFeatureChUaArch PagePermissionsPolicyFeature = "ch-ua-arch"

	// PagePermissionsPolicyFeatureChUaBitness enum const.
	PagePermissionsPolicyFeatureChUaBitness PagePermissionsPolicyFeature = "ch-ua-bitness"

	// PagePermissionsPolicyFeatureChUaPlatform enum const.
	PagePermissionsPolicyFeatureChUaPlatform PagePermissionsPolicyFeature = "ch-ua-platform"

	// PagePermissionsPolicyFeatureChUaModel enum const.
	PagePermissionsPolicyFeatureChUaModel PagePermissionsPolicyFeature = "ch-ua-model"

	// PagePermissionsPolicyFeatureChUaMobile enum const.
	PagePermissionsPolicyFeatureChUaMobile PagePermissionsPolicyFeature = "ch-ua-mobile"

	// PagePermissionsPolicyFeatureChUaFormFactors enum const.
	PagePermissionsPolicyFeatureChUaFormFactors PagePermissionsPolicyFeature = "ch-ua-form-factors"

	// PagePermissionsPolicyFeatureChUaFullVersion enum const.
	PagePermissionsPolicyFeatureChUaFullVersion PagePermissionsPolicyFeature = "ch-ua-full-version"

	// PagePermissionsPolicyFeatureChUaFullVersionList enum const.
	PagePermissionsPolicyFeatureChUaFullVersionList PagePermissionsPolicyFeature = "ch-ua-full-version-list"

	// PagePermissionsPolicyFeatureChUaPlatformVersion enum const.
	PagePermissionsPolicyFeatureChUaPlatformVersion PagePermissionsPolicyFeature = "ch-ua-platform-version"

	// PagePermissionsPolicyFeatureChUaWow64 enum const.
	PagePermissionsPolicyFeatureChUaWow64 PagePermissionsPolicyFeature = "ch-ua-wow64"

	// PagePermissionsPolicyFeatureChViewportHeight enum const.
	PagePermissionsPolicyFeatureChViewportHeight PagePermissionsPolicyFeature = "ch-viewport-height"

	// PagePermissionsPolicyFeatureChViewportWidth enum const.
	PagePermissionsPolicyFeatureChViewportWidth PagePermissionsPolicyFeature = "ch-viewport-width"

	// PagePermissionsPolicyFeatureChWidth enum const.
	PagePermissionsPolicyFeatureChWidth PagePermissionsPolicyFeature = "ch-width"

	// PagePermissionsPolicyFeatureClipboardRead enum const.
	PagePermissionsPolicyFeatureClipboardRead PagePermissionsPolicyFeature = "clipboard-read"

	// PagePermissionsPolicyFeatureClipboardWrite enum const.
	PagePermissionsPolicyFeatureClipboardWrite PagePermissionsPolicyFeature = "clipboard-write"

	// PagePermissionsPolicyFeatureComputePressure enum const.
	PagePermissionsPolicyFeatureComputePressure PagePermissionsPolicyFeature = "compute-pressure"

	// PagePermissionsPolicyFeatureCrossOriginIsolated enum const.
	PagePermissionsPolicyFeatureCrossOriginIsolated PagePermissionsPolicyFeature = "cross-origin-isolated"

	// PagePermissionsPolicyFeatureDirectSockets enum const.
	PagePermissionsPolicyFeatureDirectSockets PagePermissionsPolicyFeature = "direct-sockets"

	// PagePermissionsPolicyFeatureDisplayCapture enum const.
	PagePermissionsPolicyFeatureDisplayCapture PagePermissionsPolicyFeature = "display-capture"

	// PagePermissionsPolicyFeatureDocumentDomain enum const.
	PagePermissionsPolicyFeatureDocumentDomain PagePermissionsPolicyFeature = "document-domain"

	// PagePermissionsPolicyFeatureEncryptedMedia enum const.
	PagePermissionsPolicyFeatureEncryptedMedia PagePermissionsPolicyFeature = "encrypted-media"

	// PagePermissionsPolicyFeatureExecutionWhileOutOfViewport enum const.
	PagePermissionsPolicyFeatureExecutionWhileOutOfViewport PagePermissionsPolicyFeature = "execution-while-out-of-viewport"

	// PagePermissionsPolicyFeatureExecutionWhileNotRendered enum const.
	PagePermissionsPolicyFeatureExecutionWhileNotRendered PagePermissionsPolicyFeature = "execution-while-not-rendered"

	// PagePermissionsPolicyFeatureFocusWithoutUserActivation enum const.
	PagePermissionsPolicyFeatureFocusWithoutUserActivation PagePermissionsPolicyFeature = "focus-without-user-activation"

	// PagePermissionsPolicyFeatureFullscreen enum const.
	PagePermissionsPolicyFeatureFullscreen PagePermissionsPolicyFeature = "fullscreen"

	// PagePermissionsPolicyFeatureFrobulate enum const.
	PagePermissionsPolicyFeatureFrobulate PagePermissionsPolicyFeature = "frobulate"

	// PagePermissionsPolicyFeatureGamepad enum const.
	PagePermissionsPolicyFeatureGamepad PagePermissionsPolicyFeature = "gamepad"

	// PagePermissionsPolicyFeatureGeolocation enum const.
	PagePermissionsPolicyFeatureGeolocation PagePermissionsPolicyFeature = "geolocation"

	// PagePermissionsPolicyFeatureGyroscope enum const.
	PagePermissionsPolicyFeatureGyroscope PagePermissionsPolicyFeature = "gyroscope"

	// PagePermissionsPolicyFeatureHid enum const.
	PagePermissionsPolicyFeatureHid PagePermissionsPolicyFeature = "hid"

	// PagePermissionsPolicyFeatureIdentityCredentialsGet enum const.
	PagePermissionsPolicyFeatureIdentityCredentialsGet PagePermissionsPolicyFeature = "identity-credentials-get"

	// PagePermissionsPolicyFeatureIdleDetection enum const.
	PagePermissionsPolicyFeatureIdleDetection PagePermissionsPolicyFeature = "idle-detection"

	// PagePermissionsPolicyFeatureInterestCohort enum const.
	PagePermissionsPolicyFeatureInterestCohort PagePermissionsPolicyFeature = "interest-cohort"

	// PagePermissionsPolicyFeatureJoinAdInterestGroup enum const.
	PagePermissionsPolicyFeatureJoinAdInterestGroup PagePermissionsPolicyFeature = "join-ad-interest-group"

	// PagePermissionsPolicyFeatureKeyboardMap enum const.
	PagePermissionsPolicyFeatureKeyboardMap PagePermissionsPolicyFeature = "keyboard-map"

	// PagePermissionsPolicyFeatureLocalFonts enum const.
	PagePermissionsPolicyFeatureLocalFonts PagePermissionsPolicyFeature = "local-fonts"

	// PagePermissionsPolicyFeatureMagnetometer enum const.
	PagePermissionsPolicyFeatureMagnetometer PagePermissionsPolicyFeature = "magnetometer"

	// PagePermissionsPolicyFeatureMicrophone enum const.
	PagePermissionsPolicyFeatureMicrophone PagePermissionsPolicyFeature = "microphone"

	// PagePermissionsPolicyFeatureMidi enum const.
	PagePermissionsPolicyFeatureMidi PagePermissionsPolicyFeature = "midi"

	// PagePermissionsPolicyFeatureOtpCredentials enum const.
	PagePermissionsPolicyFeatureOtpCredentials PagePermissionsPolicyFeature = "otp-credentials"

	// PagePermissionsPolicyFeaturePayment enum const.
	PagePermissionsPolicyFeaturePayment PagePermissionsPolicyFeature = "payment"

	// PagePermissionsPolicyFeaturePictureInPicture enum const.
	PagePermissionsPolicyFeaturePictureInPicture PagePermissionsPolicyFeature = "picture-in-picture"

	// PagePermissionsPolicyFeaturePrivateAggregation enum const.
	PagePermissionsPolicyFeaturePrivateAggregation PagePermissionsPolicyFeature = "private-aggregation"

	// PagePermissionsPolicyFeaturePrivateStateTokenIssuance enum const.
	PagePermissionsPolicyFeaturePrivateStateTokenIssuance PagePermissionsPolicyFeature = "private-state-token-issuance"

	// PagePermissionsPolicyFeaturePrivateStateTokenRedemption enum const.
	PagePermissionsPolicyFeaturePrivateStateTokenRedemption PagePermissionsPolicyFeature = "private-state-token-redemption"

	// PagePermissionsPolicyFeaturePublickeyCredentialsCreate enum const.
	PagePermissionsPolicyFeaturePublickeyCredentialsCreate PagePermissionsPolicyFeature = "publickey-credentials-create"

	// PagePermissionsPolicyFeaturePublickeyCredentialsGet enum const.
	PagePermissionsPolicyFeaturePublickeyCredentialsGet PagePermissionsPolicyFeature = "publickey-credentials-get"

	// PagePermissionsPolicyFeatureRunAdAuction enum const.
	PagePermissionsPolicyFeatureRunAdAuction PagePermissionsPolicyFeature = "run-ad-auction"

	// PagePermissionsPolicyFeatureScreenWakeLock enum const.
	PagePermissionsPolicyFeatureScreenWakeLock PagePermissionsPolicyFeature = "screen-wake-lock"

	// PagePermissionsPolicyFeatureSerial enum const.
	PagePermissionsPolicyFeatureSerial PagePermissionsPolicyFeature = "serial"

	// PagePermissionsPolicyFeatureSharedAutofill enum const.
	PagePermissionsPolicyFeatureSharedAutofill PagePermissionsPolicyFeature = "shared-autofill"

	// PagePermissionsPolicyFeatureSharedStorage enum const.
	PagePermissionsPolicyFeatureSharedStorage PagePermissionsPolicyFeature = "shared-storage"

	// PagePermissionsPolicyFeatureSharedStorageSelectURL enum const.
	PagePermissionsPolicyFeatureSharedStorageSelectURL PagePermissionsPolicyFeature = "shared-storage-select-url"

	// PagePermissionsPolicyFeatureSmartCard enum const.
	PagePermissionsPolicyFeatureSmartCard PagePermissionsPolicyFeature = "smart-card"

	// PagePermissionsPolicyFeatureSpeakerSelection enum const.
	PagePermissionsPolicyFeatureSpeakerSelection PagePermissionsPolicyFeature = "speaker-selection"

	// PagePermissionsPolicyFeatureStorageAccess enum const.
	PagePermissionsPolicyFeatureStorageAccess PagePermissionsPolicyFeature = "storage-access"

	// PagePermissionsPolicyFeatureSubApps enum const.
	PagePermissionsPolicyFeatureSubApps PagePermissionsPolicyFeature = "sub-apps"

	// PagePermissionsPolicyFeatureSyncXhr enum const.
	PagePermissionsPolicyFeatureSyncXhr PagePermissionsPolicyFeature = "sync-xhr"

	// PagePermissionsPolicyFeatureUnload enum const.
	PagePermissionsPolicyFeatureUnload PagePermissionsPolicyFeature = "unload"

	// PagePermissionsPolicyFeatureUsb enum const.
	PagePermissionsPolicyFeatureUsb PagePermissionsPolicyFeature = "usb"

	// PagePermissionsPolicyFeatureUsbUnrestricted enum const.
	PagePermissionsPolicyFeatureUsbUnrestricted PagePermissionsPolicyFeature = "usb-unrestricted"

	// PagePermissionsPolicyFeatureVerticalScroll enum const.
	PagePermissionsPolicyFeatureVerticalScroll PagePermissionsPolicyFeature = "vertical-scroll"

	// PagePermissionsPolicyFeatureWebPrinting enum const.
	PagePermissionsPolicyFeatureWebPrinting PagePermissionsPolicyFeature = "web-printing"

	// PagePermissionsPolicyFeatureWebShare enum const.
	PagePermissionsPolicyFeatureWebShare PagePermissionsPolicyFeature = "web-share"

	// PagePermissionsPolicyFeatureWindowManagement enum const.
	PagePermissionsPolicyFeatureWindowManagement PagePermissionsPolicyFeature = "window-management"

	// PagePermissionsPolicyFeatureXrSpatialTracking enum const.
	PagePermissionsPolicyFeatureXrSpatialTracking PagePermissionsPolicyFeature = "xr-spatial-tracking"
)

// PagePermissionsPolicyBlockReason (experimental) Reason for a permissions policy feature to be disabled.
type PagePermissionsPolicyBlockReason string

const (
	// PagePermissionsPolicyBlockReasonHeader enum const.
	PagePermissionsPolicyBlockReasonHeader PagePermissionsPolicyBlockReason = "Header"

	// PagePermissionsPolicyBlockReasonIframeAttribute enum const.
	PagePermissionsPolicyBlockReasonIframeAttribute PagePermissionsPolicyBlockReason = "IframeAttribute"

	// PagePermissionsPolicyBlockReasonInFencedFrameTree enum const.
	PagePermissionsPolicyBlockReasonInFencedFrameTree PagePermissionsPolicyBlockReason = "InFencedFrameTree"

	// PagePermissionsPolicyBlockReasonInIsolatedApp enum const.
	PagePermissionsPolicyBlockReasonInIsolatedApp PagePermissionsPolicyBlockReason = "InIsolatedApp"
)

// PagePermissionsPolicyBlockLocator (experimental) ...
type PagePermissionsPolicyBlockLocator struct {
	// FrameID ...
	FrameID PageFrameID `json:"frameId"`

	// BlockReason ...
	BlockReason PagePermissionsPolicyBlockReason `json:"blockReason"`
}

// PagePermissionsPolicyFeatureState (experimental) ...
type PagePermissionsPolicyFeatureState struct {
	// Feature ...
	Feature PagePermissionsPolicyFeature `json:"feature"`

	// Allowed ...
	Allowed bool `json:"allowed"`

	// Locator (optional) ...
	Locator *PagePermissionsPolicyBlockLocator `json:"locator,omitempty"`
}

// PageOriginTrialTokenStatus (experimental) Origin Trial(https://www.chromium.org/blink/origin-trials) support.
// Status for an Origin Trial token.
type PageOriginTrialTokenStatus string

const (
	// PageOriginTrialTokenStatusSuccess enum const.
	PageOriginTrialTokenStatusSuccess PageOriginTrialTokenStatus = "Success"

	// PageOriginTrialTokenStatusNotSupported enum const.
	PageOriginTrialTokenStatusNotSupported PageOriginTrialTokenStatus = "NotSupported"

	// PageOriginTrialTokenStatusInsecure enum const.
	PageOriginTrialTokenStatusInsecure PageOriginTrialTokenStatus = "Insecure"

	// PageOriginTrialTokenStatusExpired enum const.
	PageOriginTrialTokenStatusExpired PageOriginTrialTokenStatus = "Expired"

	// PageOriginTrialTokenStatusWrongOrigin enum const.
	PageOriginTrialTokenStatusWrongOrigin PageOriginTrialTokenStatus = "WrongOrigin"

	// PageOriginTrialTokenStatusInvalidSignature enum const.
	PageOriginTrialTokenStatusInvalidSignature PageOriginTrialTokenStatus = "InvalidSignature"

	// PageOriginTrialTokenStatusMalformed enum const.
	PageOriginTrialTokenStatusMalformed PageOriginTrialTokenStatus = "Malformed"

	// PageOriginTrialTokenStatusWrongVersion enum const.
	PageOriginTrialTokenStatusWrongVersion PageOriginTrialTokenStatus = "WrongVersion"

	// PageOriginTrialTokenStatusFeatureDisabled enum const.
	PageOriginTrialTokenStatusFeatureDisabled PageOriginTrialTokenStatus = "FeatureDisabled"

	// PageOriginTrialTokenStatusTokenDisabled enum const.
	PageOriginTrialTokenStatusTokenDisabled PageOriginTrialTokenStatus = "TokenDisabled"

	// PageOriginTrialTokenStatusFeatureDisabledForUser enum const.
	PageOriginTrialTokenStatusFeatureDisabledForUser PageOriginTrialTokenStatus = "FeatureDisabledForUser"

	// PageOriginTrialTokenStatusUnknownTrial enum const.
	PageOriginTrialTokenStatusUnknownTrial PageOriginTrialTokenStatus = "UnknownTrial"
)

// PageOriginTrialStatus (experimental) Status for an Origin Trial.
type PageOriginTrialStatus string

const (
	// PageOriginTrialStatusEnabled enum const.
	PageOriginTrialStatusEnabled PageOriginTrialStatus = "Enabled"

	// PageOriginTrialStatusValidTokenNotProvided enum const.
	PageOriginTrialStatusValidTokenNotProvided PageOriginTrialStatus = "ValidTokenNotProvided"

	// PageOriginTrialStatusOSNotSupported enum const.
	PageOriginTrialStatusOSNotSupported PageOriginTrialStatus = "OSNotSupported"

	// PageOriginTrialStatusTrialNotAllowed enum const.
	PageOriginTrialStatusTrialNotAllowed PageOriginTrialStatus = "TrialNotAllowed"
)

// PageOriginTrialUsageRestriction (experimental) ...
type PageOriginTrialUsageRestriction string

const (
	// PageOriginTrialUsageRestrictionNone enum const.
	PageOriginTrialUsageRestrictionNone PageOriginTrialUsageRestriction = "None"

	// PageOriginTrialUsageRestrictionSubset enum const.
	PageOriginTrialUsageRestrictionSubset PageOriginTrialUsageRestriction = "Subset"
)

// PageOriginTrialToken (experimental) ...
type PageOriginTrialToken struct {
	// Origin ...
	Origin string `json:"origin"`

	// MatchSubDomains ...
	MatchSubDomains bool `json:"matchSubDomains"`

	// TrialName ...
	TrialName string `json:"trialName"`

	// ExpiryTime ...
	ExpiryTime TimeSinceEpoch `json:"expiryTime"`

	// IsThirdParty ...
	IsThirdParty bool `json:"isThirdParty"`

	// UsageRestriction ...
	UsageRestriction PageOriginTrialUsageRestriction `json:"usageRestriction"`
}

// PageOriginTrialTokenWithStatus (experimental) ...
type PageOriginTrialTokenWithStatus struct {
	// RawTokenText ...
	RawTokenText string `json:"rawTokenText"`

	// ParsedToken (optional) `parsedToken` is present only when the token is extractable and
	// parsable.
	ParsedToken *PageOriginTrialToken `json:"parsedToken,omitempty"`

	// Status ...
	Status PageOriginTrialTokenStatus `json:"status"`
}

// PageOriginTrial (experimental) ...
type PageOriginTrial struct {
	// TrialName ...
	TrialName string `json:"trialName"`

	// Status ...
	Status PageOriginTrialStatus `json:"status"`

	// TokensWithStatus ...
	TokensWithStatus []*PageOriginTrialTokenWithStatus `json:"tokensWithStatus"`
}

// PageFrame Information about the Frame on the page.
type PageFrame struct {
	// ID Frame unique identifier.
	ID PageFrameID `json:"id"`

	// ParentID (optional) Parent frame identifier.
	ParentID PageFrameID `json:"parentId,omitempty"`

	// LoaderID Identifier of the loader associated with this frame.
	LoaderID NetworkLoaderID `json:"loaderId"`

	// Name (optional) Frame's name as specified in the tag.
	Name string `json:"name,omitempty"`

	// URL Frame document's URL without fragment.
	URL string `json:"url"`

	// URLFragment (experimental) (optional) Frame document's URL fragment including the '#'.
	URLFragment string `json:"urlFragment,omitempty"`

	// DomainAndRegistry (experimental) Frame document's registered domain, taking the public suffixes list into account.
	// Extracted from the Frame's url.
	// Example URLs: http://www.google.com/file.html -> "google.com"
	//               http://a.b.co.uk/file.html      -> "b.co.uk"
	DomainAndRegistry string `json:"domainAndRegistry"`

	// SecurityOrigin Frame document's security origin.
	SecurityOrigin string `json:"securityOrigin"`

	// MIMEType Frame document's mimeType as determined by the browser.
	MIMEType string `json:"mimeType"`

	// UnreachableURL (experimental) (optional) If the frame failed to load, this contains the URL that could not be loaded. Note that unlike url above, this URL may contain a fragment.
	UnreachableURL string `json:"unreachableUrl,omitempty"`

	// AdFrameStatus (experimental) (optional) Indicates whether this frame was tagged as an ad and why.
	AdFrameStatus *PageAdFrameStatus `json:"adFrameStatus,omitempty"`

	// SecureContextType (experimental) Indicates whether the main document is a secure context and explains why that is the case.
	SecureContextType PageSecureContextType `json:"secureContextType"`

	// CrossOriginIsolatedContextType (experimental) Indicates whether this is a cross origin isolated context.
	CrossOriginIsolatedContextType PageCrossOriginIsolatedContextType `json:"crossOriginIsolatedContextType"`

	// GatedAPIFeatures (experimental) Indicated which gated APIs / features are available.
	GatedAPIFeatures []PageGatedAPIFeatures `json:"gatedAPIFeatures"`
}

// PageFrameResource (experimental) Information about the Resource on the page.
type PageFrameResource struct {
	// URL Resource URL.
	URL string `json:"url"`

	// Type of this resource.
	Type NetworkResourceType `json:"type"`

	// MIMEType Resource mimeType as determined by the browser.
	MIMEType string `json:"mimeType"`

	// LastModified (optional) last-modified timestamp as reported by server.
	LastModified TimeSinceEpoch `json:"lastModified,omitempty"`

	// ContentSize (optional) Resource content size.
	ContentSize *float64 `json:"contentSize,omitempty"`

	// Failed (optional) True if the resource failed to load.
	Failed bool `json:"failed,omitempty"`

	// Canceled (optional) True if the resource was canceled during loading.
	Canceled bool `json:"canceled,omitempty"`
}

// PageFrameResourceTree (experimental) Information about the Frame hierarchy along with their cached resources.
type PageFrameResourceTree struct {
	// Frame information for this tree item.
	Frame *PageFrame `json:"frame"`

	// ChildFrames (optional) Child frames.
	ChildFrames []*PageFrameResourceTree `json:"childFrames,omitempty"`

	// Resources Information about frame resources.
	Resources []*PageFrameResource `json:"resources"`
}

// PageFrameTree Information about the Frame hierarchy.
type PageFrameTree struct {
	// Frame information for this tree item.
	Frame *PageFrame `json:"frame"`

	// ChildFrames (optional) Child frames.
	ChildFrames []*PageFrameTree `json:"childFrames,omitempty"`
}

// PageScriptIdentifier Unique script identifier.
type PageScriptIdentifier string

// PageTransitionType Transition type.
type PageTransitionType string

const (
	// PageTransitionTypeLink enum const.
	PageTransitionTypeLink PageTransitionType = "link"

	// PageTransitionTypeTyped enum const.
	PageTransitionTypeTyped PageTransitionType = "typed"

	// PageTransitionTypeAddressBar enum const.
	PageTransitionTypeAddressBar PageTransitionType = "address_bar"

	// PageTransitionTypeAutoBookmark enum const.
	PageTransitionTypeAutoBookmark PageTransitionType = "auto_bookmark"

	// PageTransitionTypeAutoSubframe enum const.
	PageTransitionTypeAutoSubframe PageTransitionType = "auto_subframe"

	// PageTransitionTypeManualSubframe enum const.
	PageTransitionTypeManualSubframe PageTransitionType = "manual_subframe"

	// PageTransitionTypeGenerated enum const.
	PageTransitionTypeGenerated PageTransitionType = "generated"

	// PageTransitionTypeAutoToplevel enum const.
	PageTransitionTypeAutoToplevel PageTransitionType = "auto_toplevel"

	// PageTransitionTypeFormSubmit enum const.
	PageTransitionTypeFormSubmit PageTransitionType = "form_submit"

	// PageTransitionTypeReload enum const.
	PageTransitionTypeReload PageTransitionType = "reload"

	// PageTransitionTypeKeyword enum const.
	PageTransitionTypeKeyword PageTransitionType = "keyword"

	// PageTransitionTypeKeywordGenerated enum const.
	PageTransitionTypeKeywordGenerated PageTransitionType = "keyword_generated"

	// PageTransitionTypeOther enum const.
	PageTransitionTypeOther PageTransitionType = "other"
)

// PageNavigationEntry Navigation history entry.
type PageNavigationEntry struct {
	// ID Unique id of the navigation history entry.
	ID int `json:"id"`

	// URL of the navigation history entry.
	URL string `json:"url"`

	// UserTypedURL URL that the user typed in the url bar.
	UserTypedURL string `json:"userTypedURL"`

	// Title of the navigation history entry.
	Title string `json:"title"`

	// TransitionType Transition type.
	TransitionType PageTransitionType `json:"transitionType"`
}

// PageScreencastFrameMetadata (experimental) Screencast frame metadata.
type PageScreencastFrameMetadata struct {
	// OffsetTop Top offset in DIP.
	OffsetTop float64 `json:"offsetTop"`

	// PageScaleFactor Page scale factor.
	PageScaleFactor float64 `json:"pageScaleFactor"`

	// DeviceWidth Device screen width in DIP.
	DeviceWidth float64 `json:"deviceWidth"`

	// DeviceHeight Device screen height in DIP.
	DeviceHeight float64 `json:"deviceHeight"`

	// ScrollOffsetX Position of horizontal scroll in CSS pixels.
	ScrollOffsetX float64 `json:"scrollOffsetX"`

	// ScrollOffsetY Position of vertical scroll in CSS pixels.
	ScrollOffsetY float64 `json:"scrollOffsetY"`

	// Timestamp (optional) Frame swap timestamp.
	Timestamp TimeSinceEpoch `json:"timestamp,omitempty"`
}

// PageDialogType Javascript dialog type.
type PageDialogType string

const (
	// PageDialogTypeAlert enum const.
	PageDialogTypeAlert PageDialogType = "alert"

	// PageDialogTypeConfirm enum const.
	PageDialogTypeConfirm PageDialogType = "confirm"

	// PageDialogTypePrompt enum const.
	PageDialogTypePrompt PageDialogType = "prompt"

	// PageDialogTypeBeforeunload enum const.
	PageDialogTypeBeforeunload PageDialogType = "beforeunload"
)

// PageAppManifestError Error while paring app manifest.
type PageAppManifestError struct {
	// Message Error message.
	Message string `json:"message"`

	// Critical If critical, this is a non-recoverable parse error.
	Critical int `json:"critical"`

	// Line Error line.
	Line int `json:"line"`

	// Column Error column.
	Column int `json:"column"`
}

// PageAppManifestParsedProperties (experimental) Parsed app manifest properties.
type PageAppManifestParsedProperties struct {
	// Scope Computed scope value
	Scope string `json:"scope"`
}

// PageLayoutViewport Layout viewport position and dimensions.
type PageLayoutViewport struct {
	// PageX Horizontal offset relative to the document (CSS pixels).
	PageX int `json:"pageX"`

	// PageY Vertical offset relative to the document (CSS pixels).
	PageY int `json:"pageY"`

	// ClientWidth Width (CSS pixels), excludes scrollbar if present.
	ClientWidth int `json:"clientWidth"`

	// ClientHeight Height (CSS pixels), excludes scrollbar if present.
	ClientHeight int `json:"clientHeight"`
}

// PageVisualViewport Visual viewport position, dimensions, and scale.
type PageVisualViewport struct {
	// OffsetX Horizontal offset relative to the layout viewport (CSS pixels).
	OffsetX float64 `json:"offsetX"`

	// OffsetY Vertical offset relative to the layout viewport (CSS pixels).
	OffsetY float64 `json:"offsetY"`

	// PageX Horizontal offset relative to the document (CSS pixels).
	PageX float64 `json:"pageX"`

	// PageY Vertical offset relative to the document (CSS pixels).
	PageY float64 `json:"pageY"`

	// ClientWidth Width (CSS pixels), excludes scrollbar if present.
	ClientWidth float64 `json:"clientWidth"`

	// ClientHeight Height (CSS pixels), excludes scrollbar if present.
	ClientHeight float64 `json:"clientHeight"`

	// Scale relative to the ideal viewport (size at width=device-width).
	Scale float64 `json:"scale"`

	// Zoom (optional) Page zoom factor (CSS to device independent pixels ratio).
	Zoom *float64 `json:"zoom,omitempty"`
}

// PageViewport Viewport for capturing screenshot.
type PageViewport struct {
	// X offset in device independent pixels (dip).
	X float64 `json:"x"`

	// Y offset in device independent pixels (dip).
	Y float64 `json:"y"`

	// Width Rectangle width in device independent pixels (dip).
	Width float64 `json:"width"`

	// Height Rectangle height in device independent pixels (dip).
	Height float64 `json:"height"`

	// Scale Page scale factor.
	Scale float64 `json:"scale"`
}

// PageFontFamilies (experimental) Generic font families collection.
type PageFontFamilies struct {
	// Standard (optional) The standard font-family.
	Standard string `json:"standard,omitempty"`

	// Fixed (optional) The fixed font-family.
	Fixed string `json:"fixed,omitempty"`

	// Serif (optional) The serif font-family.
	Serif string `json:"serif,omitempty"`

	// SansSerif (optional) The sansSerif font-family.
	SansSerif string `json:"sansSerif,omitempty"`

	// Cursive (optional) The cursive font-family.
	Cursive string `json:"cursive,omitempty"`

	// Fantasy (optional) The fantasy font-family.
	Fantasy string `json:"fantasy,omitempty"`

	// Math (optional) The math font-family.
	Math string `json:"math,omitempty"`
}

// PageScriptFontFamilies (experimental) Font families collection for a script.
type PageScriptFontFamilies struct {
	// Script Name of the script which these font families are defined for.
	Script string `json:"script"`

	// FontFamilies Generic font families collection for the script.
	FontFamilies *PageFontFamilies `json:"fontFamilies"`
}

// PageFontSizes (experimental) Default font sizes.
type PageFontSizes struct {
	// Standard (optional) Default standard font size.
	Standard *int `json:"standard,omitempty"`

	// Fixed (optional) Default fixed font size.
	Fixed *int `json:"fixed,omitempty"`
}

// PageClientNavigationReason (experimental) ...
type PageClientNavigationReason string

const (
	// PageClientNavigationReasonFormSubmissionGet enum const.
	PageClientNavigationReasonFormSubmissionGet PageClientNavigationReason = "formSubmissionGet"

	// PageClientNavigationReasonFormSubmissionPost enum const.
	PageClientNavigationReasonFormSubmissionPost PageClientNavigationReason = "formSubmissionPost"

	// PageClientNavigationReasonHTTPHeaderRefresh enum const.
	PageClientNavigationReasonHTTPHeaderRefresh PageClientNavigationReason = "httpHeaderRefresh"

	// PageClientNavigationReasonScriptInitiated enum const.
	PageClientNavigationReasonScriptInitiated PageClientNavigationReason = "scriptInitiated"

	// PageClientNavigationReasonMetaTagRefresh enum const.
	PageClientNavigationReasonMetaTagRefresh PageClientNavigationReason = "metaTagRefresh"

	// PageClientNavigationReasonPageBlockInterstitial enum const.
	PageClientNavigationReasonPageBlockInterstitial PageClientNavigationReason = "pageBlockInterstitial"

	// PageClientNavigationReasonReload enum const.
	PageClientNavigationReasonReload PageClientNavigationReason = "reload"

	// PageClientNavigationReasonAnchorClick enum const.
	PageClientNavigationReasonAnchorClick PageClientNavigationReason = "anchorClick"
)

// PageClientNavigationDisposition (experimental) ...
type PageClientNavigationDisposition string

const (
	// PageClientNavigationDispositionCurrentTab enum const.
	PageClientNavigationDispositionCurrentTab PageClientNavigationDisposition = "currentTab"

	// PageClientNavigationDispositionNewTab enum const.
	PageClientNavigationDispositionNewTab PageClientNavigationDisposition = "newTab"

	// PageClientNavigationDispositionNewWindow enum const.
	PageClientNavigationDispositionNewWindow PageClientNavigationDisposition = "newWindow"

	// PageClientNavigationDispositionDownload enum const.
	PageClientNavigationDispositionDownload PageClientNavigationDisposition = "download"
)

// PageInstallabilityErrorArgument (experimental) ...
type PageInstallabilityErrorArgument struct {
	// Name Argument name (e.g. name:'minimum-icon-size-in-pixels').
	Name string `json:"name"`

	// Value Argument value (e.g. value:'64').
	Value string `json:"value"`
}

// PageInstallabilityError (experimental) The installability error.
type PageInstallabilityError struct {
	// ErrorID The error id (e.g. 'manifest-missing-suitable-icon').
	ErrorID string `json:"errorId"`

	// ErrorArguments The list of error arguments (e.g. {name:'minimum-icon-size-in-pixels', value:'64'}).
	ErrorArguments []*PageInstallabilityErrorArgument `json:"errorArguments"`
}

// PageReferrerPolicy (experimental) The referring-policy used for the navigation.
type PageReferrerPolicy string

const (
	// PageReferrerPolicyNoReferrer enum const.
	PageReferrerPolicyNoReferrer PageReferrerPolicy = "noReferrer"

	// PageReferrerPolicyNoReferrerWhenDowngrade enum const.
	PageReferrerPolicyNoReferrerWhenDowngrade PageReferrerPolicy = "noReferrerWhenDowngrade"

	// PageReferrerPolicyOrigin enum const.
	PageReferrerPolicyOrigin PageReferrerPolicy = "origin"

	// PageReferrerPolicyOriginWhenCrossOrigin enum const.
	PageReferrerPolicyOriginWhenCrossOrigin PageReferrerPolicy = "originWhenCrossOrigin"

	// PageReferrerPolicySameOrigin enum const.
	PageReferrerPolicySameOrigin PageReferrerPolicy = "sameOrigin"

	// PageReferrerPolicyStrictOrigin enum const.
	PageReferrerPolicyStrictOrigin PageReferrerPolicy = "strictOrigin"

	// PageReferrerPolicyStrictOriginWhenCrossOrigin enum const.
	PageReferrerPolicyStrictOriginWhenCrossOrigin PageReferrerPolicy = "strictOriginWhenCrossOrigin"

	// PageReferrerPolicyUnsafeURL enum const.
	PageReferrerPolicyUnsafeURL PageReferrerPolicy = "unsafeUrl"
)

// PageCompilationCacheParams (experimental) Per-script compilation cache parameters for `Page.produceCompilationCache`.
type PageCompilationCacheParams struct {
	// URL The URL of the script to produce a compilation cache entry for.
	URL string `json:"url"`

	// Eager (optional) A hint to the backend whether eager compilation is recommended.
	// (the actual compilation mode used is upon backend discretion).
	Eager bool `json:"eager,omitempty"`
}

// PageFileFilter (experimental) ...
type PageFileFilter struct {
	// Name (optional) ...
	Name string `json:"name,omitempty"`

	// Accepts (optional) ...
	Accepts []string `json:"accepts,omitempty"`
}

// PageFileHandler (experimental) ...
type PageFileHandler struct {
	// Action ...
	Action string `json:"action"`

	// Name ...
	Name string `json:"name"`

	// Icons (optional) ...
	Icons []*PageImageResource `json:"icons,omitempty"`

	// Accepts (optional) Mimic a map, name is the key, accepts is the value.
	Accepts []*PageFileFilter `json:"accepts,omitempty"`

	// LaunchType Won't repeat the enums, using string for easy comparison. Same as the
	// other enums below.
	LaunchType string `json:"launchType"`
}

// PageImageResource (experimental) The image definition used in both icon and screenshot.
type PageImageResource struct {
	// URL The src field in the definition, but changing to url in favor of
	// consistency.
	URL string `json:"url"`

	// Sizes (optional) ...
	Sizes string `json:"sizes,omitempty"`

	// Type (optional) ...
	Type string `json:"type,omitempty"`
}

// PageLaunchHandler (experimental) ...
type PageLaunchHandler struct {
	// ClientMode ...
	ClientMode string `json:"clientMode"`
}

// PageProtocolHandler (experimental) ...
type PageProtocolHandler struct {
	// Protocol ...
	Protocol string `json:"protocol"`

	// URL ...
	URL string `json:"url"`
}

// PageRelatedApplication (experimental) ...
type PageRelatedApplication struct {
	// ID (optional) ...
	ID string `json:"id,omitempty"`

	// URL ...
	URL string `json:"url"`
}

// PageScopeExtension (experimental) ...
type PageScopeExtension struct {
	// Origin Instead of using tuple, this field always returns the serialized string
	// for easy understanding and comparison.
	Origin string `json:"origin"`

	// HasOriginWildcard ...
	HasOriginWildcard bool `json:"hasOriginWildcard"`
}

// PageScreenshot (experimental) ...
type PageScreenshot struct {
	// Image ...
	Image *PageImageResource `json:"image"`

	// FormFactor ...
	FormFactor string `json:"formFactor"`

	// Label (optional) ...
	Label string `json:"label,omitempty"`
}

// PageShareTarget (experimental) ...
type PageShareTarget struct {
	// Action ...
	Action string `json:"action"`

	// Method ...
	Method string `json:"method"`

	// Enctype ...
	Enctype string `json:"enctype"`

	// Title (optional) Embed the ShareTargetParams
	Title string `json:"title,omitempty"`

	// Text (optional) ...
	Text string `json:"text,omitempty"`

	// URL (optional) ...
	URL string `json:"url,omitempty"`

	// Files (optional) ...
	Files []*PageFileFilter `json:"files,omitempty"`
}

// PageShortcut (experimental) ...
type PageShortcut struct {
	// Name ...
	Name string `json:"name"`

	// URL ...
	URL string `json:"url"`
}

// PageWebAppManifest (experimental) ...
type PageWebAppManifest struct {
	// BackgroundColor (optional) ...
	BackgroundColor string `json:"backgroundColor,omitempty"`

	// Description (optional) The extra description provided by the manifest.
	Description string `json:"description,omitempty"`

	// Dir (optional) ...
	Dir string `json:"dir,omitempty"`

	// Display (optional) ...
	Display string `json:"display,omitempty"`

	// DisplayOverrides (optional) The overrided display mode controlled by the user.
	DisplayOverrides []string `json:"displayOverrides,omitempty"`

	// FileHandlers (optional) The handlers to open files.
	FileHandlers []*PageFileHandler `json:"fileHandlers,omitempty"`

	// Icons (optional) ...
	Icons []*PageImageResource `json:"icons,omitempty"`

	// ID (optional) ...
	ID string `json:"id,omitempty"`

	// Lang (optional) ...
	Lang string `json:"lang,omitempty"`

	// LaunchHandler (optional) TODO(crbug.com/1231886): This field is non-standard and part of a Chrome
	// experiment. See:
	// https://github.com/WICG/web-app-launch/blob/main/launch_handler.md
	LaunchHandler *PageLaunchHandler `json:"launchHandler,omitempty"`

	// Name (optional) ...
	Name string `json:"name,omitempty"`

	// Orientation (optional) ...
	Orientation string `json:"orientation,omitempty"`

	// PreferRelatedApplications (optional) ...
	PreferRelatedApplications bool `json:"preferRelatedApplications,omitempty"`

	// ProtocolHandlers (optional) The handlers to open protocols.
	ProtocolHandlers []*PageProtocolHandler `json:"protocolHandlers,omitempty"`

	// RelatedApplications (optional) ...
	RelatedApplications []*PageRelatedApplication `json:"relatedApplications,omitempty"`

	// Scope (optional) ...
	Scope string `json:"scope,omitempty"`

	// ScopeExtensions (optional) Non-standard, see
	// https://github.com/WICG/manifest-incubations/blob/gh-pages/scope_extensions-explainer.md
	ScopeExtensions []*PageScopeExtension `json:"scopeExtensions,omitempty"`

	// Screenshots (optional) The screenshots used by chromium.
	Screenshots []*PageScreenshot `json:"screenshots,omitempty"`

	// ShareTarget (optional) ...
	ShareTarget *PageShareTarget `json:"shareTarget,omitempty"`

	// ShortName (optional) ...
	ShortName string `json:"shortName,omitempty"`

	// Shortcuts (optional) ...
	Shortcuts []*PageShortcut `json:"shortcuts,omitempty"`

	// StartURL (optional) ...
	StartURL string `json:"startUrl,omitempty"`

	// ThemeColor (optional) ...
	ThemeColor string `json:"themeColor,omitempty"`
}

// PageAutoResponseMode (experimental) Enum of possible auto-response for permission / prompt dialogs.
type PageAutoResponseMode string

const (
	// PageAutoResponseModeNone enum const.
	PageAutoResponseModeNone PageAutoResponseMode = "none"

	// PageAutoResponseModeAutoAccept enum const.
	PageAutoResponseModeAutoAccept PageAutoResponseMode = "autoAccept"

	// PageAutoResponseModeAutoReject enum const.
	PageAutoResponseModeAutoReject PageAutoResponseMode = "autoReject"

	// PageAutoResponseModeAutoOptOut enum const.
	PageAutoResponseModeAutoOptOut PageAutoResponseMode = "autoOptOut"
)

// PageNavigationType (experimental) The type of a frameNavigated event.
type PageNavigationType string

const (
	// PageNavigationTypeNavigation enum const.
	PageNavigationTypeNavigation PageNavigationType = "Navigation"

	// PageNavigationTypeBackForwardCacheRestore enum const.
	PageNavigationTypeBackForwardCacheRestore PageNavigationType = "BackForwardCacheRestore"
)

// PageBackForwardCacheNotRestoredReason (experimental) List of not restored reasons for back-forward cache.
type PageBackForwardCacheNotRestoredReason string

const (
	// PageBackForwardCacheNotRestoredReasonNotPrimaryMainFrame enum const.
	PageBackForwardCacheNotRestoredReasonNotPrimaryMainFrame PageBackForwardCacheNotRestoredReason = "NotPrimaryMainFrame"

	// PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabled enum const.
	PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabled PageBackForwardCacheNotRestoredReason = "BackForwardCacheDisabled"

	// PageBackForwardCacheNotRestoredReasonRelatedActiveContentsExist enum const.
	PageBackForwardCacheNotRestoredReasonRelatedActiveContentsExist PageBackForwardCacheNotRestoredReason = "RelatedActiveContentsExist"

	// PageBackForwardCacheNotRestoredReasonHTTPStatusNotOK enum const.
	PageBackForwardCacheNotRestoredReasonHTTPStatusNotOK PageBackForwardCacheNotRestoredReason = "HTTPStatusNotOK"

	// PageBackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS enum const.
	PageBackForwardCacheNotRestoredReasonSchemeNotHTTPOrHTTPS PageBackForwardCacheNotRestoredReason = "SchemeNotHTTPOrHTTPS"

	// PageBackForwardCacheNotRestoredReasonLoading enum const.
	PageBackForwardCacheNotRestoredReasonLoading PageBackForwardCacheNotRestoredReason = "Loading"

	// PageBackForwardCacheNotRestoredReasonWasGrantedMediaAccess enum const.
	PageBackForwardCacheNotRestoredReasonWasGrantedMediaAccess PageBackForwardCacheNotRestoredReason = "WasGrantedMediaAccess"

	// PageBackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled enum const.
	PageBackForwardCacheNotRestoredReasonDisableForRenderFrameHostCalled PageBackForwardCacheNotRestoredReason = "DisableForRenderFrameHostCalled"

	// PageBackForwardCacheNotRestoredReasonDomainNotAllowed enum const.
	PageBackForwardCacheNotRestoredReasonDomainNotAllowed PageBackForwardCacheNotRestoredReason = "DomainNotAllowed"

	// PageBackForwardCacheNotRestoredReasonHTTPMethodNotGET enum const.
	PageBackForwardCacheNotRestoredReasonHTTPMethodNotGET PageBackForwardCacheNotRestoredReason = "HTTPMethodNotGET"

	// PageBackForwardCacheNotRestoredReasonSubframeIsNavigating enum const.
	PageBackForwardCacheNotRestoredReasonSubframeIsNavigating PageBackForwardCacheNotRestoredReason = "SubframeIsNavigating"

	// PageBackForwardCacheNotRestoredReasonTimeout enum const.
	PageBackForwardCacheNotRestoredReasonTimeout PageBackForwardCacheNotRestoredReason = "Timeout"

	// PageBackForwardCacheNotRestoredReasonCacheLimit enum const.
	PageBackForwardCacheNotRestoredReasonCacheLimit PageBackForwardCacheNotRestoredReason = "CacheLimit"

	// PageBackForwardCacheNotRestoredReasonJavaScriptExecution enum const.
	PageBackForwardCacheNotRestoredReasonJavaScriptExecution PageBackForwardCacheNotRestoredReason = "JavaScriptExecution"

	// PageBackForwardCacheNotRestoredReasonRendererProcessKilled enum const.
	PageBackForwardCacheNotRestoredReasonRendererProcessKilled PageBackForwardCacheNotRestoredReason = "RendererProcessKilled"

	// PageBackForwardCacheNotRestoredReasonRendererProcessCrashed enum const.
	PageBackForwardCacheNotRestoredReasonRendererProcessCrashed PageBackForwardCacheNotRestoredReason = "RendererProcessCrashed"

	// PageBackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed enum const.
	PageBackForwardCacheNotRestoredReasonSchedulerTrackedFeatureUsed PageBackForwardCacheNotRestoredReason = "SchedulerTrackedFeatureUsed"

	// PageBackForwardCacheNotRestoredReasonConflictingBrowsingInstance enum const.
	PageBackForwardCacheNotRestoredReasonConflictingBrowsingInstance PageBackForwardCacheNotRestoredReason = "ConflictingBrowsingInstance"

	// PageBackForwardCacheNotRestoredReasonCacheFlushed enum const.
	PageBackForwardCacheNotRestoredReasonCacheFlushed PageBackForwardCacheNotRestoredReason = "CacheFlushed"

	// PageBackForwardCacheNotRestoredReasonServiceWorkerVersionActivation enum const.
	PageBackForwardCacheNotRestoredReasonServiceWorkerVersionActivation PageBackForwardCacheNotRestoredReason = "ServiceWorkerVersionActivation"

	// PageBackForwardCacheNotRestoredReasonSessionRestored enum const.
	PageBackForwardCacheNotRestoredReasonSessionRestored PageBackForwardCacheNotRestoredReason = "SessionRestored"

	// PageBackForwardCacheNotRestoredReasonServiceWorkerPostMessage enum const.
	PageBackForwardCacheNotRestoredReasonServiceWorkerPostMessage PageBackForwardCacheNotRestoredReason = "ServiceWorkerPostMessage"

	// PageBackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded enum const.
	PageBackForwardCacheNotRestoredReasonEnteredBackForwardCacheBeforeServiceWorkerHostAdded PageBackForwardCacheNotRestoredReason = "EnteredBackForwardCacheBeforeServiceWorkerHostAdded"

	// PageBackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite enum const.
	PageBackForwardCacheNotRestoredReasonRenderFrameHostReusedSameSite PageBackForwardCacheNotRestoredReason = "RenderFrameHostReused_SameSite"

	// PageBackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite enum const.
	PageBackForwardCacheNotRestoredReasonRenderFrameHostReusedCrossSite PageBackForwardCacheNotRestoredReason = "RenderFrameHostReused_CrossSite"

	// PageBackForwardCacheNotRestoredReasonServiceWorkerClaim enum const.
	PageBackForwardCacheNotRestoredReasonServiceWorkerClaim PageBackForwardCacheNotRestoredReason = "ServiceWorkerClaim"

	// PageBackForwardCacheNotRestoredReasonIgnoreEventAndEvict enum const.
	PageBackForwardCacheNotRestoredReasonIgnoreEventAndEvict PageBackForwardCacheNotRestoredReason = "IgnoreEventAndEvict"

	// PageBackForwardCacheNotRestoredReasonHaveInnerContents enum const.
	PageBackForwardCacheNotRestoredReasonHaveInnerContents PageBackForwardCacheNotRestoredReason = "HaveInnerContents"

	// PageBackForwardCacheNotRestoredReasonTimeoutPuttingInCache enum const.
	PageBackForwardCacheNotRestoredReasonTimeoutPuttingInCache PageBackForwardCacheNotRestoredReason = "TimeoutPuttingInCache"

	// PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory enum const.
	PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledByLowMemory PageBackForwardCacheNotRestoredReason = "BackForwardCacheDisabledByLowMemory"

	// PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine enum const.
	PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledByCommandLine PageBackForwardCacheNotRestoredReason = "BackForwardCacheDisabledByCommandLine"

	// PageBackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer enum const.
	PageBackForwardCacheNotRestoredReasonNetworkRequestDatapipeDrainedAsBytesConsumer PageBackForwardCacheNotRestoredReason = "NetworkRequestDatapipeDrainedAsBytesConsumer"

	// PageBackForwardCacheNotRestoredReasonNetworkRequestRedirected enum const.
	PageBackForwardCacheNotRestoredReasonNetworkRequestRedirected PageBackForwardCacheNotRestoredReason = "NetworkRequestRedirected"

	// PageBackForwardCacheNotRestoredReasonNetworkRequestTimeout enum const.
	PageBackForwardCacheNotRestoredReasonNetworkRequestTimeout PageBackForwardCacheNotRestoredReason = "NetworkRequestTimeout"

	// PageBackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit enum const.
	PageBackForwardCacheNotRestoredReasonNetworkExceedsBufferLimit PageBackForwardCacheNotRestoredReason = "NetworkExceedsBufferLimit"

	// PageBackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring enum const.
	PageBackForwardCacheNotRestoredReasonNavigationCancelledWhileRestoring PageBackForwardCacheNotRestoredReason = "NavigationCancelledWhileRestoring"

	// PageBackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry enum const.
	PageBackForwardCacheNotRestoredReasonNotMostRecentNavigationEntry PageBackForwardCacheNotRestoredReason = "NotMostRecentNavigationEntry"

	// PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender enum const.
	PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledForPrerender PageBackForwardCacheNotRestoredReason = "BackForwardCacheDisabledForPrerender"

	// PageBackForwardCacheNotRestoredReasonUserAgentOverrideDiffers enum const.
	PageBackForwardCacheNotRestoredReasonUserAgentOverrideDiffers PageBackForwardCacheNotRestoredReason = "UserAgentOverrideDiffers"

	// PageBackForwardCacheNotRestoredReasonForegroundCacheLimit enum const.
	PageBackForwardCacheNotRestoredReasonForegroundCacheLimit PageBackForwardCacheNotRestoredReason = "ForegroundCacheLimit"

	// PageBackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped enum const.
	PageBackForwardCacheNotRestoredReasonBrowsingInstanceNotSwapped PageBackForwardCacheNotRestoredReason = "BrowsingInstanceNotSwapped"

	// PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate enum const.
	PageBackForwardCacheNotRestoredReasonBackForwardCacheDisabledForDelegate PageBackForwardCacheNotRestoredReason = "BackForwardCacheDisabledForDelegate"

	// PageBackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame enum const.
	PageBackForwardCacheNotRestoredReasonUnloadHandlerExistsInMainFrame PageBackForwardCacheNotRestoredReason = "UnloadHandlerExistsInMainFrame"

	// PageBackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame enum const.
	PageBackForwardCacheNotRestoredReasonUnloadHandlerExistsInSubFrame PageBackForwardCacheNotRestoredReason = "UnloadHandlerExistsInSubFrame"

	// PageBackForwardCacheNotRestoredReasonServiceWorkerUnregistration enum const.
	PageBackForwardCacheNotRestoredReasonServiceWorkerUnregistration PageBackForwardCacheNotRestoredReason = "ServiceWorkerUnregistration"

	// PageBackForwardCacheNotRestoredReasonCacheControlNoStore enum const.
	PageBackForwardCacheNotRestoredReasonCacheControlNoStore PageBackForwardCacheNotRestoredReason = "CacheControlNoStore"

	// PageBackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified enum const.
	PageBackForwardCacheNotRestoredReasonCacheControlNoStoreCookieModified PageBackForwardCacheNotRestoredReason = "CacheControlNoStoreCookieModified"

	// PageBackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified enum const.
	PageBackForwardCacheNotRestoredReasonCacheControlNoStoreHTTPOnlyCookieModified PageBackForwardCacheNotRestoredReason = "CacheControlNoStoreHTTPOnlyCookieModified"

	// PageBackForwardCacheNotRestoredReasonNoResponseHead enum const.
	PageBackForwardCacheNotRestoredReasonNoResponseHead PageBackForwardCacheNotRestoredReason = "NoResponseHead"

	// PageBackForwardCacheNotRestoredReasonUnknown enum const.
	PageBackForwardCacheNotRestoredReasonUnknown PageBackForwardCacheNotRestoredReason = "Unknown"

	// PageBackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857 enum const.
	PageBackForwardCacheNotRestoredReasonActivationNavigationsDisallowedForBug1234857 PageBackForwardCacheNotRestoredReason = "ActivationNavigationsDisallowedForBug1234857"

	// PageBackForwardCacheNotRestoredReasonErrorDocument enum const.
	PageBackForwardCacheNotRestoredReasonErrorDocument PageBackForwardCacheNotRestoredReason = "ErrorDocument"

	// PageBackForwardCacheNotRestoredReasonFencedFramesEmbedder enum const.
	PageBackForwardCacheNotRestoredReasonFencedFramesEmbedder PageBackForwardCacheNotRestoredReason = "FencedFramesEmbedder"

	// PageBackForwardCacheNotRestoredReasonCookieDisabled enum const.
	PageBackForwardCacheNotRestoredReasonCookieDisabled PageBackForwardCacheNotRestoredReason = "CookieDisabled"

	// PageBackForwardCacheNotRestoredReasonHTTPAuthRequired enum const.
	PageBackForwardCacheNotRestoredReasonHTTPAuthRequired PageBackForwardCacheNotRestoredReason = "HTTPAuthRequired"

	// PageBackForwardCacheNotRestoredReasonCookieFlushed enum const.
	PageBackForwardCacheNotRestoredReasonCookieFlushed PageBackForwardCacheNotRestoredReason = "CookieFlushed"

	// PageBackForwardCacheNotRestoredReasonBroadcastChannelOnMessage enum const.
	PageBackForwardCacheNotRestoredReasonBroadcastChannelOnMessage PageBackForwardCacheNotRestoredReason = "BroadcastChannelOnMessage"

	// PageBackForwardCacheNotRestoredReasonWebSocket enum const.
	PageBackForwardCacheNotRestoredReasonWebSocket PageBackForwardCacheNotRestoredReason = "WebSocket"

	// PageBackForwardCacheNotRestoredReasonWebTransport enum const.
	PageBackForwardCacheNotRestoredReasonWebTransport PageBackForwardCacheNotRestoredReason = "WebTransport"

	// PageBackForwardCacheNotRestoredReasonWebRTC enum const.
	PageBackForwardCacheNotRestoredReasonWebRTC PageBackForwardCacheNotRestoredReason = "WebRTC"

	// PageBackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore enum const.
	PageBackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoStore PageBackForwardCacheNotRestoredReason = "MainResourceHasCacheControlNoStore"

	// PageBackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache enum const.
	PageBackForwardCacheNotRestoredReasonMainResourceHasCacheControlNoCache PageBackForwardCacheNotRestoredReason = "MainResourceHasCacheControlNoCache"

	// PageBackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore enum const.
	PageBackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoStore PageBackForwardCacheNotRestoredReason = "SubresourceHasCacheControlNoStore"

	// PageBackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache enum const.
	PageBackForwardCacheNotRestoredReasonSubresourceHasCacheControlNoCache PageBackForwardCacheNotRestoredReason = "SubresourceHasCacheControlNoCache"

	// PageBackForwardCacheNotRestoredReasonContainsPlugins enum const.
	PageBackForwardCacheNotRestoredReasonContainsPlugins PageBackForwardCacheNotRestoredReason = "ContainsPlugins"

	// PageBackForwardCacheNotRestoredReasonDocumentLoaded enum const.
	PageBackForwardCacheNotRestoredReasonDocumentLoaded PageBackForwardCacheNotRestoredReason = "DocumentLoaded"

	// PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers enum const.
	PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestOthers PageBackForwardCacheNotRestoredReason = "OutstandingNetworkRequestOthers"

	// PageBackForwardCacheNotRestoredReasonRequestedMIDIPermission enum const.
	PageBackForwardCacheNotRestoredReasonRequestedMIDIPermission PageBackForwardCacheNotRestoredReason = "RequestedMIDIPermission"

	// PageBackForwardCacheNotRestoredReasonRequestedAudioCapturePermission enum const.
	PageBackForwardCacheNotRestoredReasonRequestedAudioCapturePermission PageBackForwardCacheNotRestoredReason = "RequestedAudioCapturePermission"

	// PageBackForwardCacheNotRestoredReasonRequestedVideoCapturePermission enum const.
	PageBackForwardCacheNotRestoredReasonRequestedVideoCapturePermission PageBackForwardCacheNotRestoredReason = "RequestedVideoCapturePermission"

	// PageBackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors enum const.
	PageBackForwardCacheNotRestoredReasonRequestedBackForwardCacheBlockedSensors PageBackForwardCacheNotRestoredReason = "RequestedBackForwardCacheBlockedSensors"

	// PageBackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission enum const.
	PageBackForwardCacheNotRestoredReasonRequestedBackgroundWorkPermission PageBackForwardCacheNotRestoredReason = "RequestedBackgroundWorkPermission"

	// PageBackForwardCacheNotRestoredReasonBroadcastChannel enum const.
	PageBackForwardCacheNotRestoredReasonBroadcastChannel PageBackForwardCacheNotRestoredReason = "BroadcastChannel"

	// PageBackForwardCacheNotRestoredReasonWebXR enum const.
	PageBackForwardCacheNotRestoredReasonWebXR PageBackForwardCacheNotRestoredReason = "WebXR"

	// PageBackForwardCacheNotRestoredReasonSharedWorker enum const.
	PageBackForwardCacheNotRestoredReasonSharedWorker PageBackForwardCacheNotRestoredReason = "SharedWorker"

	// PageBackForwardCacheNotRestoredReasonWebLocks enum const.
	PageBackForwardCacheNotRestoredReasonWebLocks PageBackForwardCacheNotRestoredReason = "WebLocks"

	// PageBackForwardCacheNotRestoredReasonWebHID enum const.
	PageBackForwardCacheNotRestoredReasonWebHID PageBackForwardCacheNotRestoredReason = "WebHID"

	// PageBackForwardCacheNotRestoredReasonWebShare enum const.
	PageBackForwardCacheNotRestoredReasonWebShare PageBackForwardCacheNotRestoredReason = "WebShare"

	// PageBackForwardCacheNotRestoredReasonRequestedStorageAccessGrant enum const.
	PageBackForwardCacheNotRestoredReasonRequestedStorageAccessGrant PageBackForwardCacheNotRestoredReason = "RequestedStorageAccessGrant"

	// PageBackForwardCacheNotRestoredReasonWebNfc enum const.
	PageBackForwardCacheNotRestoredReasonWebNfc PageBackForwardCacheNotRestoredReason = "WebNfc"

	// PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch enum const.
	PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestFetch PageBackForwardCacheNotRestoredReason = "OutstandingNetworkRequestFetch"

	// PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR enum const.
	PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestXHR PageBackForwardCacheNotRestoredReason = "OutstandingNetworkRequestXHR"

	// PageBackForwardCacheNotRestoredReasonAppBanner enum const.
	PageBackForwardCacheNotRestoredReasonAppBanner PageBackForwardCacheNotRestoredReason = "AppBanner"

	// PageBackForwardCacheNotRestoredReasonPrinting enum const.
	PageBackForwardCacheNotRestoredReasonPrinting PageBackForwardCacheNotRestoredReason = "Printing"

	// PageBackForwardCacheNotRestoredReasonWebDatabase enum const.
	PageBackForwardCacheNotRestoredReasonWebDatabase PageBackForwardCacheNotRestoredReason = "WebDatabase"

	// PageBackForwardCacheNotRestoredReasonPictureInPicture enum const.
	PageBackForwardCacheNotRestoredReasonPictureInPicture PageBackForwardCacheNotRestoredReason = "PictureInPicture"

	// PageBackForwardCacheNotRestoredReasonPortal enum const.
	PageBackForwardCacheNotRestoredReasonPortal PageBackForwardCacheNotRestoredReason = "Portal"

	// PageBackForwardCacheNotRestoredReasonSpeechRecognizer enum const.
	PageBackForwardCacheNotRestoredReasonSpeechRecognizer PageBackForwardCacheNotRestoredReason = "SpeechRecognizer"

	// PageBackForwardCacheNotRestoredReasonIdleManager enum const.
	PageBackForwardCacheNotRestoredReasonIdleManager PageBackForwardCacheNotRestoredReason = "IdleManager"

	// PageBackForwardCacheNotRestoredReasonPaymentManager enum const.
	PageBackForwardCacheNotRestoredReasonPaymentManager PageBackForwardCacheNotRestoredReason = "PaymentManager"

	// PageBackForwardCacheNotRestoredReasonSpeechSynthesis enum const.
	PageBackForwardCacheNotRestoredReasonSpeechSynthesis PageBackForwardCacheNotRestoredReason = "SpeechSynthesis"

	// PageBackForwardCacheNotRestoredReasonKeyboardLock enum const.
	PageBackForwardCacheNotRestoredReasonKeyboardLock PageBackForwardCacheNotRestoredReason = "KeyboardLock"

	// PageBackForwardCacheNotRestoredReasonWebOTPService enum const.
	PageBackForwardCacheNotRestoredReasonWebOTPService PageBackForwardCacheNotRestoredReason = "WebOTPService"

	// PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket enum const.
	PageBackForwardCacheNotRestoredReasonOutstandingNetworkRequestDirectSocket PageBackForwardCacheNotRestoredReason = "OutstandingNetworkRequestDirectSocket"

	// PageBackForwardCacheNotRestoredReasonInjectedJavascript enum const.
	PageBackForwardCacheNotRestoredReasonInjectedJavascript PageBackForwardCacheNotRestoredReason = "InjectedJavascript"

	// PageBackForwardCacheNotRestoredReasonInjectedStyleSheet enum const.
	PageBackForwardCacheNotRestoredReasonInjectedStyleSheet PageBackForwardCacheNotRestoredReason = "InjectedStyleSheet"

	// PageBackForwardCacheNotRestoredReasonKeepaliveRequest enum const.
	PageBackForwardCacheNotRestoredReasonKeepaliveRequest PageBackForwardCacheNotRestoredReason = "KeepaliveRequest"

	// PageBackForwardCacheNotRestoredReasonIndexedDBEvent enum const.
	PageBackForwardCacheNotRestoredReasonIndexedDBEvent PageBackForwardCacheNotRestoredReason = "IndexedDBEvent"

	// PageBackForwardCacheNotRestoredReasonDummy enum const.
	PageBackForwardCacheNotRestoredReasonDummy PageBackForwardCacheNotRestoredReason = "Dummy"

	// PageBackForwardCacheNotRestoredReasonJsNetworkRequestReceivedCacheControlNoStoreResource enum const.
	PageBackForwardCacheNotRestoredReasonJsNetworkRequestReceivedCacheControlNoStoreResource PageBackForwardCacheNotRestoredReason = "JsNetworkRequestReceivedCacheControlNoStoreResource"

	// PageBackForwardCacheNotRestoredReasonWebRTCSticky enum const.
	PageBackForwardCacheNotRestoredReasonWebRTCSticky PageBackForwardCacheNotRestoredReason = "WebRTCSticky"

	// PageBackForwardCacheNotRestoredReasonWebTransportSticky enum const.
	PageBackForwardCacheNotRestoredReasonWebTransportSticky PageBackForwardCacheNotRestoredReason = "WebTransportSticky"

	// PageBackForwardCacheNotRestoredReasonWebSocketSticky enum const.
	PageBackForwardCacheNotRestoredReasonWebSocketSticky PageBackForwardCacheNotRestoredReason = "WebSocketSticky"

	// PageBackForwardCacheNotRestoredReasonSmartCard enum const.
	PageBackForwardCacheNotRestoredReasonSmartCard PageBackForwardCacheNotRestoredReason = "SmartCard"

	// PageBackForwardCacheNotRestoredReasonLiveMediaStreamTrack enum const.
	PageBackForwardCacheNotRestoredReasonLiveMediaStreamTrack PageBackForwardCacheNotRestoredReason = "LiveMediaStreamTrack"

	// PageBackForwardCacheNotRestoredReasonUnloadHandler enum const.
	PageBackForwardCacheNotRestoredReasonUnloadHandler PageBackForwardCacheNotRestoredReason = "UnloadHandler"

	// PageBackForwardCacheNotRestoredReasonParserAborted enum const.
	PageBackForwardCacheNotRestoredReasonParserAborted PageBackForwardCacheNotRestoredReason = "ParserAborted"

	// PageBackForwardCacheNotRestoredReasonContentSecurityHandler enum const.
	PageBackForwardCacheNotRestoredReasonContentSecurityHandler PageBackForwardCacheNotRestoredReason = "ContentSecurityHandler"

	// PageBackForwardCacheNotRestoredReasonContentWebAuthenticationAPI enum const.
	PageBackForwardCacheNotRestoredReasonContentWebAuthenticationAPI PageBackForwardCacheNotRestoredReason = "ContentWebAuthenticationAPI"

	// PageBackForwardCacheNotRestoredReasonContentFileChooser enum const.
	PageBackForwardCacheNotRestoredReasonContentFileChooser PageBackForwardCacheNotRestoredReason = "ContentFileChooser"

	// PageBackForwardCacheNotRestoredReasonContentSerial enum const.
	PageBackForwardCacheNotRestoredReasonContentSerial PageBackForwardCacheNotRestoredReason = "ContentSerial"

	// PageBackForwardCacheNotRestoredReasonContentFileSystemAccess enum const.
	PageBackForwardCacheNotRestoredReasonContentFileSystemAccess PageBackForwardCacheNotRestoredReason = "ContentFileSystemAccess"

	// PageBackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost enum const.
	PageBackForwardCacheNotRestoredReasonContentMediaDevicesDispatcherHost PageBackForwardCacheNotRestoredReason = "ContentMediaDevicesDispatcherHost"

	// PageBackForwardCacheNotRestoredReasonContentWebBluetooth enum const.
	PageBackForwardCacheNotRestoredReasonContentWebBluetooth PageBackForwardCacheNotRestoredReason = "ContentWebBluetooth"

	// PageBackForwardCacheNotRestoredReasonContentWebUSB enum const.
	PageBackForwardCacheNotRestoredReasonContentWebUSB PageBackForwardCacheNotRestoredReason = "ContentWebUSB"

	// PageBackForwardCacheNotRestoredReasonContentMediaSessionService enum const.
	PageBackForwardCacheNotRestoredReasonContentMediaSessionService PageBackForwardCacheNotRestoredReason = "ContentMediaSessionService"

	// PageBackForwardCacheNotRestoredReasonContentScreenReader enum const.
	PageBackForwardCacheNotRestoredReasonContentScreenReader PageBackForwardCacheNotRestoredReason = "ContentScreenReader"

	// PageBackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderPopupBlockerTabHelper PageBackForwardCacheNotRestoredReason = "EmbedderPopupBlockerTabHelper"

	// PageBackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderSafeBrowsingTriggeredPopupBlocker PageBackForwardCacheNotRestoredReason = "EmbedderSafeBrowsingTriggeredPopupBlocker"

	// PageBackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderSafeBrowsingThreatDetails PageBackForwardCacheNotRestoredReason = "EmbedderSafeBrowsingThreatDetails"

	// PageBackForwardCacheNotRestoredReasonEmbedderAppBannerManager enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderAppBannerManager PageBackForwardCacheNotRestoredReason = "EmbedderAppBannerManager"

	// PageBackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderDomDistillerViewerSource PageBackForwardCacheNotRestoredReason = "EmbedderDomDistillerViewerSource"

	// PageBackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderDomDistillerSelfDeletingRequestDelegate PageBackForwardCacheNotRestoredReason = "EmbedderDomDistillerSelfDeletingRequestDelegate"

	// PageBackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderOomInterventionTabHelper PageBackForwardCacheNotRestoredReason = "EmbedderOomInterventionTabHelper"

	// PageBackForwardCacheNotRestoredReasonEmbedderOfflinePage enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderOfflinePage PageBackForwardCacheNotRestoredReason = "EmbedderOfflinePage"

	// PageBackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderChromePasswordManagerClientBindCredentialManager PageBackForwardCacheNotRestoredReason = "EmbedderChromePasswordManagerClientBindCredentialManager"

	// PageBackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderPermissionRequestManager PageBackForwardCacheNotRestoredReason = "EmbedderPermissionRequestManager"

	// PageBackForwardCacheNotRestoredReasonEmbedderModalDialog enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderModalDialog PageBackForwardCacheNotRestoredReason = "EmbedderModalDialog"

	// PageBackForwardCacheNotRestoredReasonEmbedderExtensions enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderExtensions PageBackForwardCacheNotRestoredReason = "EmbedderExtensions"

	// PageBackForwardCacheNotRestoredReasonEmbedderExtensionMessaging enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderExtensionMessaging PageBackForwardCacheNotRestoredReason = "EmbedderExtensionMessaging"

	// PageBackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderExtensionMessagingForOpenPort PageBackForwardCacheNotRestoredReason = "EmbedderExtensionMessagingForOpenPort"

	// PageBackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame enum const.
	PageBackForwardCacheNotRestoredReasonEmbedderExtensionSentMessageToCachedFrame PageBackForwardCacheNotRestoredReason = "EmbedderExtensionSentMessageToCachedFrame"

	// PageBackForwardCacheNotRestoredReasonRequestedByWebViewClient enum const.
	PageBackForwardCacheNotRestoredReasonRequestedByWebViewClient PageBackForwardCacheNotRestoredReason = "RequestedByWebViewClient"
)

// PageBackForwardCacheNotRestoredReasonType (experimental) Types of not restored reasons for back-forward cache.
type PageBackForwardCacheNotRestoredReasonType string

const (
	// PageBackForwardCacheNotRestoredReasonTypeSupportPending enum const.
	PageBackForwardCacheNotRestoredReasonTypeSupportPending PageBackForwardCacheNotRestoredReasonType = "SupportPending"

	// PageBackForwardCacheNotRestoredReasonTypePageSupportNeeded enum const.
	PageBackForwardCacheNotRestoredReasonTypePageSupportNeeded PageBackForwardCacheNotRestoredReasonType = "PageSupportNeeded"

	// PageBackForwardCacheNotRestoredReasonTypeCircumstantial enum const.
	PageBackForwardCacheNotRestoredReasonTypeCircumstantial PageBackForwardCacheNotRestoredReasonType = "Circumstantial"
)

// PageBackForwardCacheBlockingDetails (experimental) ...
type PageBackForwardCacheBlockingDetails struct {
	// URL (optional) Url of the file where blockage happened. Optional because of tests.
	URL string `json:"url,omitempty"`

	// Function (optional) Function name where blockage happened. Optional because of anonymous functions and tests.
	Function string `json:"function,omitempty"`

	// LineNumber Line number in the script (0-based).
	LineNumber int `json:"lineNumber"`

	// ColumnNumber Column number in the script (0-based).
	ColumnNumber int `json:"columnNumber"`
}

// PageBackForwardCacheNotRestoredExplanation (experimental) ...
type PageBackForwardCacheNotRestoredExplanation struct {
	// Type of the reason
	Type PageBackForwardCacheNotRestoredReasonType `json:"type"`

	// Reason Not restored reason
	Reason PageBackForwardCacheNotRestoredReason `json:"reason"`

	// Context (optional) Context associated with the reason. The meaning of this context is
	// dependent on the reason:
	// - EmbedderExtensionSentMessageToCachedFrame: the extension ID.
	Context string `json:"context,omitempty"`

	// Details (optional) ...
	Details []*PageBackForwardCacheBlockingDetails `json:"details,omitempty"`
}

// PageBackForwardCacheNotRestoredExplanationTree (experimental) ...
type PageBackForwardCacheNotRestoredExplanationTree struct {
	// URL of each frame
	URL string `json:"url"`

	// Explanations Not restored reasons of each frame
	Explanations []*PageBackForwardCacheNotRestoredExplanation `json:"explanations"`

	// Children Array of children frame
	Children []*PageBackForwardCacheNotRestoredExplanationTree `json:"children"`
}

// PageAddScriptToEvaluateOnLoad (deprecated) (experimental) Deprecated, please use addScriptToEvaluateOnNewDocument instead.
type PageAddScriptToEvaluateOnLoad struct {
	// ScriptSource ...
	ScriptSource string `json:"scriptSource"`
}

// ProtoReq name.
func (m PageAddScriptToEvaluateOnLoad) ProtoReq() string { return "Page.addScriptToEvaluateOnLoad" }

// Call the request.
func (m PageAddScriptToEvaluateOnLoad) Call(c Client) (*PageAddScriptToEvaluateOnLoadResult, error) {
	var res PageAddScriptToEvaluateOnLoadResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageAddScriptToEvaluateOnLoadResult (deprecated) (experimental) ...
type PageAddScriptToEvaluateOnLoadResult struct {
	// Identifier of the added script.
	Identifier PageScriptIdentifier `json:"identifier"`
}

// PageAddScriptToEvaluateOnNewDocument Evaluates given script in every frame upon creation (before loading frame's scripts).
type PageAddScriptToEvaluateOnNewDocument struct {
	// Source ...
	Source string `json:"source"`

	// WorldName (experimental) (optional) If specified, creates an isolated world with the given name and evaluates given script in it.
	// This world name will be used as the ExecutionContextDescription::name when the corresponding
	// event is emitted.
	WorldName string `json:"worldName,omitempty"`

	// IncludeCommandLineAPI (experimental) (optional) Specifies whether command line API should be available to the script, defaults
	// to false.
	IncludeCommandLineAPI bool `json:"includeCommandLineAPI,omitempty"`

	// RunImmediately (experimental) (optional) If true, runs the script immediately on existing execution contexts or worlds.
	// Default: false.
	RunImmediately bool `json:"runImmediately,omitempty"`
}

// ProtoReq name.
func (m PageAddScriptToEvaluateOnNewDocument) ProtoReq() string {
	return "Page.addScriptToEvaluateOnNewDocument"
}

// Call the request.
func (m PageAddScriptToEvaluateOnNewDocument) Call(c Client) (*PageAddScriptToEvaluateOnNewDocumentResult, error) {
	var res PageAddScriptToEvaluateOnNewDocumentResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageAddScriptToEvaluateOnNewDocumentResult ...
type PageAddScriptToEvaluateOnNewDocumentResult struct {
	// Identifier of the added script.
	Identifier PageScriptIdentifier `json:"identifier"`
}

// PageBringToFront Brings page to front (activates tab).
type PageBringToFront struct{}

// ProtoReq name.
func (m PageBringToFront) ProtoReq() string { return "Page.bringToFront" }

// Call sends the request.
func (m PageBringToFront) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageCaptureScreenshotFormat enum.
type PageCaptureScreenshotFormat string

const (
	// PageCaptureScreenshotFormatJpeg enum const.
	PageCaptureScreenshotFormatJpeg PageCaptureScreenshotFormat = "jpeg"

	// PageCaptureScreenshotFormatPng enum const.
	PageCaptureScreenshotFormatPng PageCaptureScreenshotFormat = "png"

	// PageCaptureScreenshotFormatWebp enum const.
	PageCaptureScreenshotFormatWebp PageCaptureScreenshotFormat = "webp"
)

// PageCaptureScreenshot Capture page screenshot.
type PageCaptureScreenshot struct {
	// Format (optional) Image compression format (defaults to png).
	Format PageCaptureScreenshotFormat `json:"format,omitempty"`

	// Quality (optional) Compression quality from range [0..100] (jpeg only).
	Quality *int `json:"quality,omitempty"`

	// Clip (optional) Capture the screenshot of a given region only.
	Clip *PageViewport `json:"clip,omitempty"`

	// FromSurface (experimental) (optional) Capture the screenshot from the surface, rather than the view. Defaults to true.
	FromSurface bool `json:"fromSurface,omitempty"`

	// CaptureBeyondViewport (experimental) (optional) Capture the screenshot beyond the viewport. Defaults to false.
	CaptureBeyondViewport bool `json:"captureBeyondViewport,omitempty"`

	// OptimizeForSpeed (experimental) (optional) Optimize image encoding for speed, not for resulting size (defaults to false)
	OptimizeForSpeed bool `json:"optimizeForSpeed,omitempty"`
}

// ProtoReq name.
func (m PageCaptureScreenshot) ProtoReq() string { return "Page.captureScreenshot" }

// Call the request.
func (m PageCaptureScreenshot) Call(c Client) (*PageCaptureScreenshotResult, error) {
	var res PageCaptureScreenshotResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageCaptureScreenshotResult ...
type PageCaptureScreenshotResult struct {
	// Data Base64-encoded image data.
	Data []byte `json:"data"`
}

// PageCaptureSnapshotFormat enum.
type PageCaptureSnapshotFormat string

const (
	// PageCaptureSnapshotFormatMhtml enum const.
	PageCaptureSnapshotFormatMhtml PageCaptureSnapshotFormat = "mhtml"
)

// PageCaptureSnapshot (experimental) Returns a snapshot of the page as a string. For MHTML format, the serialization includes
// iframes, shadow DOM, external resources, and element-inline styles.
type PageCaptureSnapshot struct {
	// Format (optional) Format (defaults to mhtml).
	Format PageCaptureSnapshotFormat `json:"format,omitempty"`
}

// ProtoReq name.
func (m PageCaptureSnapshot) ProtoReq() string { return "Page.captureSnapshot" }

// Call the request.
func (m PageCaptureSnapshot) Call(c Client) (*PageCaptureSnapshotResult, error) {
	var res PageCaptureSnapshotResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageCaptureSnapshotResult (experimental) ...
type PageCaptureSnapshotResult struct {
	// Data Serialized page data.
	Data string `json:"data"`
}

// PageClearDeviceMetricsOverride (deprecated) (experimental) Clears the overridden device metrics.
type PageClearDeviceMetricsOverride struct{}

// ProtoReq name.
func (m PageClearDeviceMetricsOverride) ProtoReq() string { return "Page.clearDeviceMetricsOverride" }

// Call sends the request.
func (m PageClearDeviceMetricsOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageClearDeviceOrientationOverride (deprecated) (experimental) Clears the overridden Device Orientation.
type PageClearDeviceOrientationOverride struct{}

// ProtoReq name.
func (m PageClearDeviceOrientationOverride) ProtoReq() string {
	return "Page.clearDeviceOrientationOverride"
}

// Call sends the request.
func (m PageClearDeviceOrientationOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageClearGeolocationOverride (deprecated) Clears the overridden Geolocation Position and Error.
type PageClearGeolocationOverride struct{}

// ProtoReq name.
func (m PageClearGeolocationOverride) ProtoReq() string { return "Page.clearGeolocationOverride" }

// Call sends the request.
func (m PageClearGeolocationOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageCreateIsolatedWorld Creates an isolated world for the given frame.
type PageCreateIsolatedWorld struct {
	// FrameID Id of the frame in which the isolated world should be created.
	FrameID PageFrameID `json:"frameId"`

	// WorldName (optional) An optional name which is reported in the Execution Context.
	WorldName string `json:"worldName,omitempty"`

	// GrantUniveralAccess (optional) Whether or not universal access should be granted to the isolated world. This is a powerful
	// option, use with caution.
	GrantUniveralAccess bool `json:"grantUniveralAccess,omitempty"`
}

// ProtoReq name.
func (m PageCreateIsolatedWorld) ProtoReq() string { return "Page.createIsolatedWorld" }

// Call the request.
func (m PageCreateIsolatedWorld) Call(c Client) (*PageCreateIsolatedWorldResult, error) {
	var res PageCreateIsolatedWorldResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageCreateIsolatedWorldResult ...
type PageCreateIsolatedWorldResult struct {
	// ExecutionContextID Execution context of the isolated world.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId"`
}

// PageDeleteCookie (deprecated) (experimental) Deletes browser cookie with given name, domain and path.
type PageDeleteCookie struct {
	// CookieName Name of the cookie to remove.
	CookieName string `json:"cookieName"`

	// URL to match cooke domain and path.
	URL string `json:"url"`
}

// ProtoReq name.
func (m PageDeleteCookie) ProtoReq() string { return "Page.deleteCookie" }

// Call sends the request.
func (m PageDeleteCookie) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageDisable Disables page domain notifications.
type PageDisable struct{}

// ProtoReq name.
func (m PageDisable) ProtoReq() string { return "Page.disable" }

// Call sends the request.
func (m PageDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageEnable Enables page domain notifications.
type PageEnable struct{}

// ProtoReq name.
func (m PageEnable) ProtoReq() string { return "Page.enable" }

// Call sends the request.
func (m PageEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageGetAppManifest Gets the processed manifest for this current document.
//
//	This API always waits for the manifest to be loaded.
//	If manifestId is provided, and it does not match the manifest of the
//	  current document, this API errors out.
//	If there is not a loaded page, this API errors out immediately.
type PageGetAppManifest struct {
	// ManifestID (optional) ...
	ManifestID string `json:"manifestId,omitempty"`
}

// ProtoReq name.
func (m PageGetAppManifest) ProtoReq() string { return "Page.getAppManifest" }

// Call the request.
func (m PageGetAppManifest) Call(c Client) (*PageGetAppManifestResult, error) {
	var res PageGetAppManifestResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetAppManifestResult ...
type PageGetAppManifestResult struct {
	// URL Manifest location.
	URL string `json:"url"`

	// Errors ...
	Errors []*PageAppManifestError `json:"errors"`

	// Data (optional) Manifest content.
	Data string `json:"data,omitempty"`

	// Parsed (deprecated) (experimental) (optional) Parsed manifest properties. Deprecated, use manifest instead.
	Parsed *PageAppManifestParsedProperties `json:"parsed,omitempty"`

	// Manifest (experimental) ...
	Manifest *PageWebAppManifest `json:"manifest"`
}

// PageGetInstallabilityErrors (experimental) ...
type PageGetInstallabilityErrors struct{}

// ProtoReq name.
func (m PageGetInstallabilityErrors) ProtoReq() string { return "Page.getInstallabilityErrors" }

// Call the request.
func (m PageGetInstallabilityErrors) Call(c Client) (*PageGetInstallabilityErrorsResult, error) {
	var res PageGetInstallabilityErrorsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetInstallabilityErrorsResult (experimental) ...
type PageGetInstallabilityErrorsResult struct {
	// InstallabilityErrors ...
	InstallabilityErrors []*PageInstallabilityError `json:"installabilityErrors"`
}

// PageGetManifestIcons (deprecated) (experimental) Deprecated because it's not guaranteed that the returned icon is in fact the one used for PWA installation.
type PageGetManifestIcons struct{}

// ProtoReq name.
func (m PageGetManifestIcons) ProtoReq() string { return "Page.getManifestIcons" }

// Call the request.
func (m PageGetManifestIcons) Call(c Client) (*PageGetManifestIconsResult, error) {
	var res PageGetManifestIconsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetManifestIconsResult (deprecated) (experimental) ...
type PageGetManifestIconsResult struct {
	// PrimaryIcon (optional) ...
	PrimaryIcon []byte `json:"primaryIcon,omitempty"`
}

// PageGetAppID (experimental) Returns the unique (PWA) app id.
// Only returns values if the feature flag 'WebAppEnableManifestId' is enabled.
type PageGetAppID struct{}

// ProtoReq name.
func (m PageGetAppID) ProtoReq() string { return "Page.getAppId" }

// Call the request.
func (m PageGetAppID) Call(c Client) (*PageGetAppIDResult, error) {
	var res PageGetAppIDResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetAppIDResult (experimental) ...
type PageGetAppIDResult struct {
	// AppID (optional) App id, either from manifest's id attribute or computed from start_url
	AppID string `json:"appId,omitempty"`

	// RecommendedID (optional) Recommendation for manifest's id attribute to match current id computed from start_url
	RecommendedID string `json:"recommendedId,omitempty"`
}

// PageGetAdScriptID (experimental) ...
type PageGetAdScriptID struct {
	// FrameID ...
	FrameID PageFrameID `json:"frameId"`
}

// ProtoReq name.
func (m PageGetAdScriptID) ProtoReq() string { return "Page.getAdScriptId" }

// Call the request.
func (m PageGetAdScriptID) Call(c Client) (*PageGetAdScriptIDResult, error) {
	var res PageGetAdScriptIDResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetAdScriptIDResult (experimental) ...
type PageGetAdScriptIDResult struct {
	// AdScriptID (optional) Identifies the bottom-most script which caused the frame to be labelled
	// as an ad. Only sent if frame is labelled as an ad and id is available.
	AdScriptID *PageAdScriptID `json:"adScriptId,omitempty"`
}

// PageGetFrameTree Returns present frame tree structure.
type PageGetFrameTree struct{}

// ProtoReq name.
func (m PageGetFrameTree) ProtoReq() string { return "Page.getFrameTree" }

// Call the request.
func (m PageGetFrameTree) Call(c Client) (*PageGetFrameTreeResult, error) {
	var res PageGetFrameTreeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetFrameTreeResult ...
type PageGetFrameTreeResult struct {
	// FrameTree Present frame tree structure.
	FrameTree *PageFrameTree `json:"frameTree"`
}

// PageGetLayoutMetrics Returns metrics relating to the layouting of the page, such as viewport bounds/scale.
type PageGetLayoutMetrics struct{}

// ProtoReq name.
func (m PageGetLayoutMetrics) ProtoReq() string { return "Page.getLayoutMetrics" }

// Call the request.
func (m PageGetLayoutMetrics) Call(c Client) (*PageGetLayoutMetricsResult, error) {
	var res PageGetLayoutMetricsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetLayoutMetricsResult ...
type PageGetLayoutMetricsResult struct {
	// LayoutViewport (deprecated) Deprecated metrics relating to the layout viewport. Is in device pixels. Use `cssLayoutViewport` instead.
	LayoutViewport *PageLayoutViewport `json:"layoutViewport"`

	// VisualViewport (deprecated) Deprecated metrics relating to the visual viewport. Is in device pixels. Use `cssVisualViewport` instead.
	VisualViewport *PageVisualViewport `json:"visualViewport"`

	// ContentSize (deprecated) Deprecated size of scrollable area. Is in DP. Use `cssContentSize` instead.
	ContentSize *DOMRect `json:"contentSize"`

	// CSSLayoutViewport Metrics relating to the layout viewport in CSS pixels.
	CSSLayoutViewport *PageLayoutViewport `json:"cssLayoutViewport"`

	// CSSVisualViewport Metrics relating to the visual viewport in CSS pixels.
	CSSVisualViewport *PageVisualViewport `json:"cssVisualViewport"`

	// CSSContentSize Size of scrollable area in CSS pixels.
	CSSContentSize *DOMRect `json:"cssContentSize"`
}

// PageGetNavigationHistory Returns navigation history for the current page.
type PageGetNavigationHistory struct{}

// ProtoReq name.
func (m PageGetNavigationHistory) ProtoReq() string { return "Page.getNavigationHistory" }

// Call the request.
func (m PageGetNavigationHistory) Call(c Client) (*PageGetNavigationHistoryResult, error) {
	var res PageGetNavigationHistoryResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetNavigationHistoryResult ...
type PageGetNavigationHistoryResult struct {
	// CurrentIndex Index of the current navigation history entry.
	CurrentIndex int `json:"currentIndex"`

	// Entries Array of navigation history entries.
	Entries []*PageNavigationEntry `json:"entries"`
}

// PageResetNavigationHistory Resets navigation history for the current page.
type PageResetNavigationHistory struct{}

// ProtoReq name.
func (m PageResetNavigationHistory) ProtoReq() string { return "Page.resetNavigationHistory" }

// Call sends the request.
func (m PageResetNavigationHistory) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageGetResourceContent (experimental) Returns content of the given resource.
type PageGetResourceContent struct {
	// FrameID Frame id to get resource for.
	FrameID PageFrameID `json:"frameId"`

	// URL of the resource to get content for.
	URL string `json:"url"`
}

// ProtoReq name.
func (m PageGetResourceContent) ProtoReq() string { return "Page.getResourceContent" }

// Call the request.
func (m PageGetResourceContent) Call(c Client) (*PageGetResourceContentResult, error) {
	var res PageGetResourceContentResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetResourceContentResult (experimental) ...
type PageGetResourceContentResult struct {
	// Content Resource content.
	Content string `json:"content"`

	// Base64Encoded True, if content was served as base64.
	Base64Encoded bool `json:"base64Encoded"`
}

// PageGetResourceTree (experimental) Returns present frame / resource tree structure.
type PageGetResourceTree struct{}

// ProtoReq name.
func (m PageGetResourceTree) ProtoReq() string { return "Page.getResourceTree" }

// Call the request.
func (m PageGetResourceTree) Call(c Client) (*PageGetResourceTreeResult, error) {
	var res PageGetResourceTreeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetResourceTreeResult (experimental) ...
type PageGetResourceTreeResult struct {
	// FrameTree Present frame / resource tree structure.
	FrameTree *PageFrameResourceTree `json:"frameTree"`
}

// PageHandleJavaScriptDialog Accepts or dismisses a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload).
type PageHandleJavaScriptDialog struct {
	// Accept Whether to accept or dismiss the dialog.
	Accept bool `json:"accept"`

	// PromptText (optional) The text to enter into the dialog prompt before accepting. Used only if this is a prompt
	// dialog.
	PromptText string `json:"promptText,omitempty"`
}

// ProtoReq name.
func (m PageHandleJavaScriptDialog) ProtoReq() string { return "Page.handleJavaScriptDialog" }

// Call sends the request.
func (m PageHandleJavaScriptDialog) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageNavigate Navigates current page to the given URL.
type PageNavigate struct {
	// URL to navigate the page to.
	URL string `json:"url"`

	// Referrer (optional) Referrer URL.
	Referrer string `json:"referrer,omitempty"`

	// TransitionType (optional) Intended transition type.
	TransitionType PageTransitionType `json:"transitionType,omitempty"`

	// FrameID (optional) Frame id to navigate, if not specified navigates the top frame.
	FrameID PageFrameID `json:"frameId,omitempty"`

	// ReferrerPolicy (experimental) (optional) Referrer-policy used for the navigation.
	ReferrerPolicy PageReferrerPolicy `json:"referrerPolicy,omitempty"`
}

// ProtoReq name.
func (m PageNavigate) ProtoReq() string { return "Page.navigate" }

// Call the request.
func (m PageNavigate) Call(c Client) (*PageNavigateResult, error) {
	var res PageNavigateResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageNavigateResult ...
type PageNavigateResult struct {
	// FrameID Frame id that has navigated (or failed to navigate)
	FrameID PageFrameID `json:"frameId"`

	// LoaderID (optional) Loader identifier. This is omitted in case of same-document navigation,
	// as the previously committed loaderId would not change.
	LoaderID NetworkLoaderID `json:"loaderId,omitempty"`

	// ErrorText (optional) User friendly error message, present if and only if navigation has failed.
	ErrorText string `json:"errorText,omitempty"`
}

// PageNavigateToHistoryEntry Navigates current page to the given history entry.
type PageNavigateToHistoryEntry struct {
	// EntryID Unique id of the entry to navigate to.
	EntryID int `json:"entryId"`
}

// ProtoReq name.
func (m PageNavigateToHistoryEntry) ProtoReq() string { return "Page.navigateToHistoryEntry" }

// Call sends the request.
func (m PageNavigateToHistoryEntry) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PagePrintToPDFTransferMode enum.
type PagePrintToPDFTransferMode string

const (
	// PagePrintToPDFTransferModeReturnAsBase64 enum const.
	PagePrintToPDFTransferModeReturnAsBase64 PagePrintToPDFTransferMode = "ReturnAsBase64"

	// PagePrintToPDFTransferModeReturnAsStream enum const.
	PagePrintToPDFTransferModeReturnAsStream PagePrintToPDFTransferMode = "ReturnAsStream"
)

// PagePrintToPDF Print page as PDF.
type PagePrintToPDF struct {
	// Landscape (optional) Paper orientation. Defaults to false.
	Landscape bool `json:"landscape,omitempty"`

	// DisplayHeaderFooter (optional) Display header and footer. Defaults to false.
	DisplayHeaderFooter bool `json:"displayHeaderFooter,omitempty"`

	// PrintBackground (optional) Print background graphics. Defaults to false.
	PrintBackground bool `json:"printBackground,omitempty"`

	// Scale (optional) Scale of the webpage rendering. Defaults to 1.
	Scale *float64 `json:"scale,omitempty"`

	// PaperWidth (optional) Paper width in inches. Defaults to 8.5 inches.
	PaperWidth *float64 `json:"paperWidth,omitempty"`

	// PaperHeight (optional) Paper height in inches. Defaults to 11 inches.
	PaperHeight *float64 `json:"paperHeight,omitempty"`

	// MarginTop (optional) Top margin in inches. Defaults to 1cm (~0.4 inches).
	MarginTop *float64 `json:"marginTop,omitempty"`

	// MarginBottom (optional) Bottom margin in inches. Defaults to 1cm (~0.4 inches).
	MarginBottom *float64 `json:"marginBottom,omitempty"`

	// MarginLeft (optional) Left margin in inches. Defaults to 1cm (~0.4 inches).
	MarginLeft *float64 `json:"marginLeft,omitempty"`

	// MarginRight (optional) Right margin in inches. Defaults to 1cm (~0.4 inches).
	MarginRight *float64 `json:"marginRight,omitempty"`

	// PageRanges (optional) Paper ranges to print, one based, e.g., '1-5, 8, 11-13'. Pages are
	// printed in the document order, not in the order specified, and no
	// more than once.
	// Defaults to empty string, which implies the entire document is printed.
	// The page numbers are quietly capped to actual page count of the
	// document, and ranges beyond the end of the document are ignored.
	// If this results in no pages to print, an error is reported.
	// It is an error to specify a range with start greater than end.
	PageRanges string `json:"pageRanges,omitempty"`

	// HeaderTemplate (optional) HTML template for the print header. Should be valid HTML markup with following
	// classes used to inject printing values into them:
	// - `date`: formatted print date
	// - `title`: document title
	// - `url`: document location
	// - `pageNumber`: current page number
	// - `totalPages`: total pages in the document
	//
	// For example, `<span class=title></span>` would generate span containing the title.
	HeaderTemplate string `json:"headerTemplate,omitempty"`

	// FooterTemplate (optional) HTML template for the print footer. Should use the same format as the `headerTemplate`.
	FooterTemplate string `json:"footerTemplate,omitempty"`

	// PreferCSSPageSize (optional) Whether or not to prefer page size as defined by css. Defaults to false,
	// in which case the content will be scaled to fit the paper size.
	PreferCSSPageSize bool `json:"preferCSSPageSize,omitempty"`

	// TransferMode (experimental) (optional) return as stream
	TransferMode PagePrintToPDFTransferMode `json:"transferMode,omitempty"`

	// GenerateTaggedPDF (experimental) (optional) Whether or not to generate tagged (accessible) PDF. Defaults to embedder choice.
	GenerateTaggedPDF bool `json:"generateTaggedPDF,omitempty"`

	// GenerateDocumentOutline (experimental) (optional) Whether or not to embed the document outline into the PDF.
	GenerateDocumentOutline bool `json:"generateDocumentOutline,omitempty"`
}

// ProtoReq name.
func (m PagePrintToPDF) ProtoReq() string { return "Page.printToPDF" }

// Call the request.
func (m PagePrintToPDF) Call(c Client) (*PagePrintToPDFResult, error) {
	var res PagePrintToPDFResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PagePrintToPDFResult ...
type PagePrintToPDFResult struct {
	// Data Base64-encoded pdf data. Empty if |returnAsStream| is specified.
	Data []byte `json:"data"`

	// Stream (experimental) (optional) A handle of the stream that holds resulting PDF data.
	Stream IOStreamHandle `json:"stream,omitempty"`
}

// PageReload Reloads given page optionally ignoring the cache.
type PageReload struct {
	// IgnoreCache (optional) If true, browser cache is ignored (as if the user pressed Shift+refresh).
	IgnoreCache bool `json:"ignoreCache,omitempty"`

	// ScriptToEvaluateOnLoad (optional) If set, the script will be injected into all frames of the inspected page after reload.
	// Argument will be ignored if reloading dataURL origin.
	ScriptToEvaluateOnLoad string `json:"scriptToEvaluateOnLoad,omitempty"`
}

// ProtoReq name.
func (m PageReload) ProtoReq() string { return "Page.reload" }

// Call sends the request.
func (m PageReload) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageRemoveScriptToEvaluateOnLoad (deprecated) (experimental) Deprecated, please use removeScriptToEvaluateOnNewDocument instead.
type PageRemoveScriptToEvaluateOnLoad struct {
	// Identifier ...
	Identifier PageScriptIdentifier `json:"identifier"`
}

// ProtoReq name.
func (m PageRemoveScriptToEvaluateOnLoad) ProtoReq() string {
	return "Page.removeScriptToEvaluateOnLoad"
}

// Call sends the request.
func (m PageRemoveScriptToEvaluateOnLoad) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageRemoveScriptToEvaluateOnNewDocument Removes given script from the list.
type PageRemoveScriptToEvaluateOnNewDocument struct {
	// Identifier ...
	Identifier PageScriptIdentifier `json:"identifier"`
}

// ProtoReq name.
func (m PageRemoveScriptToEvaluateOnNewDocument) ProtoReq() string {
	return "Page.removeScriptToEvaluateOnNewDocument"
}

// Call sends the request.
func (m PageRemoveScriptToEvaluateOnNewDocument) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageScreencastFrameAck (experimental) Acknowledges that a screencast frame has been received by the frontend.
type PageScreencastFrameAck struct {
	// SessionID Frame number.
	SessionID int `json:"sessionId"`
}

// ProtoReq name.
func (m PageScreencastFrameAck) ProtoReq() string { return "Page.screencastFrameAck" }

// Call sends the request.
func (m PageScreencastFrameAck) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSearchInResource (experimental) Searches for given string in resource content.
type PageSearchInResource struct {
	// FrameID Frame id for resource to search in.
	FrameID PageFrameID `json:"frameId"`

	// URL of the resource to search in.
	URL string `json:"url"`

	// Query String to search for.
	Query string `json:"query"`

	// CaseSensitive (optional) If true, search is case sensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// IsRegex (optional) If true, treats string parameter as regex.
	IsRegex bool `json:"isRegex,omitempty"`
}

// ProtoReq name.
func (m PageSearchInResource) ProtoReq() string { return "Page.searchInResource" }

// Call the request.
func (m PageSearchInResource) Call(c Client) (*PageSearchInResourceResult, error) {
	var res PageSearchInResourceResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageSearchInResourceResult (experimental) ...
type PageSearchInResourceResult struct {
	// Result List of search matches.
	Result []*DebuggerSearchMatch `json:"result"`
}

// PageSetAdBlockingEnabled (experimental) Enable Chrome's experimental ad filter on all sites.
type PageSetAdBlockingEnabled struct {
	// Enabled Whether to block ads.
	Enabled bool `json:"enabled"`
}

// ProtoReq name.
func (m PageSetAdBlockingEnabled) ProtoReq() string { return "Page.setAdBlockingEnabled" }

// Call sends the request.
func (m PageSetAdBlockingEnabled) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetBypassCSP Enable page Content Security Policy by-passing.
type PageSetBypassCSP struct {
	// Enabled Whether to bypass page CSP.
	Enabled bool `json:"enabled"`
}

// ProtoReq name.
func (m PageSetBypassCSP) ProtoReq() string { return "Page.setBypassCSP" }

// Call sends the request.
func (m PageSetBypassCSP) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageGetPermissionsPolicyState (experimental) Get Permissions Policy state on given frame.
type PageGetPermissionsPolicyState struct {
	// FrameID ...
	FrameID PageFrameID `json:"frameId"`
}

// ProtoReq name.
func (m PageGetPermissionsPolicyState) ProtoReq() string { return "Page.getPermissionsPolicyState" }

// Call the request.
func (m PageGetPermissionsPolicyState) Call(c Client) (*PageGetPermissionsPolicyStateResult, error) {
	var res PageGetPermissionsPolicyStateResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetPermissionsPolicyStateResult (experimental) ...
type PageGetPermissionsPolicyStateResult struct {
	// States ...
	States []*PagePermissionsPolicyFeatureState `json:"states"`
}

// PageGetOriginTrials (experimental) Get Origin Trials on given frame.
type PageGetOriginTrials struct {
	// FrameID ...
	FrameID PageFrameID `json:"frameId"`
}

// ProtoReq name.
func (m PageGetOriginTrials) ProtoReq() string { return "Page.getOriginTrials" }

// Call the request.
func (m PageGetOriginTrials) Call(c Client) (*PageGetOriginTrialsResult, error) {
	var res PageGetOriginTrialsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PageGetOriginTrialsResult (experimental) ...
type PageGetOriginTrialsResult struct {
	// OriginTrials ...
	OriginTrials []*PageOriginTrial `json:"originTrials"`
}

// PageSetDeviceMetricsOverride (deprecated) (experimental) Overrides the values of device screen dimensions (window.screen.width, window.screen.height,
// window.innerWidth, window.innerHeight, and "device-width"/"device-height"-related CSS media
// query results).
type PageSetDeviceMetricsOverride struct {
	// Width Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the override.
	Width int `json:"width"`

	// Height Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the override.
	Height int `json:"height"`

	// DeviceScaleFactor Overriding device scale factor value. 0 disables the override.
	DeviceScaleFactor float64 `json:"deviceScaleFactor"`

	// Mobile Whether to emulate mobile device. This includes viewport meta tag, overlay scrollbars, text
	// autosizing and more.
	Mobile bool `json:"mobile"`

	// Scale (optional) Scale to apply to resulting view image.
	Scale *float64 `json:"scale,omitempty"`

	// ScreenWidth (optional) Overriding screen width value in pixels (minimum 0, maximum 10000000).
	ScreenWidth *int `json:"screenWidth,omitempty"`

	// ScreenHeight (optional) Overriding screen height value in pixels (minimum 0, maximum 10000000).
	ScreenHeight *int `json:"screenHeight,omitempty"`

	// PositionX (optional) Overriding view X position on screen in pixels (minimum 0, maximum 10000000).
	PositionX *int `json:"positionX,omitempty"`

	// PositionY (optional) Overriding view Y position on screen in pixels (minimum 0, maximum 10000000).
	PositionY *int `json:"positionY,omitempty"`

	// DontSetVisibleSize (optional) Do not set visible view size, rely upon explicit setVisibleSize call.
	DontSetVisibleSize bool `json:"dontSetVisibleSize,omitempty"`

	// ScreenOrientation (optional) Screen orientation override.
	ScreenOrientation *EmulationScreenOrientation `json:"screenOrientation,omitempty"`

	// Viewport (optional) The viewport dimensions and scale. If not set, the override is cleared.
	Viewport *PageViewport `json:"viewport,omitempty"`
}

// ProtoReq name.
func (m PageSetDeviceMetricsOverride) ProtoReq() string { return "Page.setDeviceMetricsOverride" }

// Call sends the request.
func (m PageSetDeviceMetricsOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetDeviceOrientationOverride (deprecated) (experimental) Overrides the Device Orientation.
type PageSetDeviceOrientationOverride struct {
	// Alpha Mock alpha
	Alpha float64 `json:"alpha"`

	// Beta Mock beta
	Beta float64 `json:"beta"`

	// Gamma Mock gamma
	Gamma float64 `json:"gamma"`
}

// ProtoReq name.
func (m PageSetDeviceOrientationOverride) ProtoReq() string {
	return "Page.setDeviceOrientationOverride"
}

// Call sends the request.
func (m PageSetDeviceOrientationOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetFontFamilies (experimental) Set generic font families.
type PageSetFontFamilies struct {
	// FontFamilies Specifies font families to set. If a font family is not specified, it won't be changed.
	FontFamilies *PageFontFamilies `json:"fontFamilies"`

	// ForScripts (optional) Specifies font families to set for individual scripts.
	ForScripts []*PageScriptFontFamilies `json:"forScripts,omitempty"`
}

// ProtoReq name.
func (m PageSetFontFamilies) ProtoReq() string { return "Page.setFontFamilies" }

// Call sends the request.
func (m PageSetFontFamilies) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetFontSizes (experimental) Set default font sizes.
type PageSetFontSizes struct {
	// FontSizes Specifies font sizes to set. If a font size is not specified, it won't be changed.
	FontSizes *PageFontSizes `json:"fontSizes"`
}

// ProtoReq name.
func (m PageSetFontSizes) ProtoReq() string { return "Page.setFontSizes" }

// Call sends the request.
func (m PageSetFontSizes) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetDocumentContent Sets given markup as the document's HTML.
type PageSetDocumentContent struct {
	// FrameID Frame id to set HTML for.
	FrameID PageFrameID `json:"frameId"`

	// HTML content to set.
	HTML string `json:"html"`
}

// ProtoReq name.
func (m PageSetDocumentContent) ProtoReq() string { return "Page.setDocumentContent" }

// Call sends the request.
func (m PageSetDocumentContent) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetDownloadBehaviorBehavior enum.
type PageSetDownloadBehaviorBehavior string

const (
	// PageSetDownloadBehaviorBehaviorDeny enum const.
	PageSetDownloadBehaviorBehaviorDeny PageSetDownloadBehaviorBehavior = "deny"

	// PageSetDownloadBehaviorBehaviorAllow enum const.
	PageSetDownloadBehaviorBehaviorAllow PageSetDownloadBehaviorBehavior = "allow"

	// PageSetDownloadBehaviorBehaviorDefault enum const.
	PageSetDownloadBehaviorBehaviorDefault PageSetDownloadBehaviorBehavior = "default"
)

// PageSetDownloadBehavior (deprecated) (experimental) Set the behavior when downloading a file.
type PageSetDownloadBehavior struct {
	// Behavior Whether to allow all or deny all download requests, or use default Chrome behavior if
	// available (otherwise deny).
	Behavior PageSetDownloadBehaviorBehavior `json:"behavior"`

	// DownloadPath (optional) The default path to save downloaded files to. This is required if behavior is set to 'allow'
	DownloadPath string `json:"downloadPath,omitempty"`
}

// ProtoReq name.
func (m PageSetDownloadBehavior) ProtoReq() string { return "Page.setDownloadBehavior" }

// Call sends the request.
func (m PageSetDownloadBehavior) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetGeolocationOverride (deprecated) Overrides the Geolocation Position or Error. Omitting any of the parameters emulates position
// unavailable.
type PageSetGeolocationOverride struct {
	// Latitude (optional) Mock latitude
	Latitude *float64 `json:"latitude,omitempty"`

	// Longitude (optional) Mock longitude
	Longitude *float64 `json:"longitude,omitempty"`

	// Accuracy (optional) Mock accuracy
	Accuracy *float64 `json:"accuracy,omitempty"`
}

// ProtoReq name.
func (m PageSetGeolocationOverride) ProtoReq() string { return "Page.setGeolocationOverride" }

// Call sends the request.
func (m PageSetGeolocationOverride) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetLifecycleEventsEnabled Controls whether page will emit lifecycle events.
type PageSetLifecycleEventsEnabled struct {
	// Enabled If true, starts emitting lifecycle events.
	Enabled bool `json:"enabled"`
}

// ProtoReq name.
func (m PageSetLifecycleEventsEnabled) ProtoReq() string { return "Page.setLifecycleEventsEnabled" }

// Call sends the request.
func (m PageSetLifecycleEventsEnabled) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetTouchEmulationEnabledConfiguration enum.
type PageSetTouchEmulationEnabledConfiguration string

const (
	// PageSetTouchEmulationEnabledConfigurationMobile enum const.
	PageSetTouchEmulationEnabledConfigurationMobile PageSetTouchEmulationEnabledConfiguration = "mobile"

	// PageSetTouchEmulationEnabledConfigurationDesktop enum const.
	PageSetTouchEmulationEnabledConfigurationDesktop PageSetTouchEmulationEnabledConfiguration = "desktop"
)

// PageSetTouchEmulationEnabled (deprecated) (experimental) Toggles mouse event-based touch event emulation.
type PageSetTouchEmulationEnabled struct {
	// Enabled Whether the touch event emulation should be enabled.
	Enabled bool `json:"enabled"`

	// Configuration (optional) Touch/gesture events configuration. Default: current platform.
	Configuration PageSetTouchEmulationEnabledConfiguration `json:"configuration,omitempty"`
}

// ProtoReq name.
func (m PageSetTouchEmulationEnabled) ProtoReq() string { return "Page.setTouchEmulationEnabled" }

// Call sends the request.
func (m PageSetTouchEmulationEnabled) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageStartScreencastFormat enum.
type PageStartScreencastFormat string

const (
	// PageStartScreencastFormatJpeg enum const.
	PageStartScreencastFormatJpeg PageStartScreencastFormat = "jpeg"

	// PageStartScreencastFormatPng enum const.
	PageStartScreencastFormatPng PageStartScreencastFormat = "png"
)

// PageStartScreencast (experimental) Starts sending each frame using the `screencastFrame` event.
type PageStartScreencast struct {
	// Format (optional) Image compression format.
	Format PageStartScreencastFormat `json:"format,omitempty"`

	// Quality (optional) Compression quality from range [0..100].
	Quality *int `json:"quality,omitempty"`

	// MaxWidth (optional) Maximum screenshot width.
	MaxWidth *int `json:"maxWidth,omitempty"`

	// MaxHeight (optional) Maximum screenshot height.
	MaxHeight *int `json:"maxHeight,omitempty"`

	// EveryNthFrame (optional) Send every n-th frame.
	EveryNthFrame *int `json:"everyNthFrame,omitempty"`
}

// ProtoReq name.
func (m PageStartScreencast) ProtoReq() string { return "Page.startScreencast" }

// Call sends the request.
func (m PageStartScreencast) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageStopLoading Force the page stop all navigations and pending resource fetches.
type PageStopLoading struct{}

// ProtoReq name.
func (m PageStopLoading) ProtoReq() string { return "Page.stopLoading" }

// Call sends the request.
func (m PageStopLoading) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageCrash (experimental) Crashes renderer on the IO thread, generates minidumps.
type PageCrash struct{}

// ProtoReq name.
func (m PageCrash) ProtoReq() string { return "Page.crash" }

// Call sends the request.
func (m PageCrash) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageClose Tries to close page, running its beforeunload hooks, if any.
type PageClose struct{}

// ProtoReq name.
func (m PageClose) ProtoReq() string { return "Page.close" }

// Call sends the request.
func (m PageClose) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetWebLifecycleStateState enum.
type PageSetWebLifecycleStateState string

const (
	// PageSetWebLifecycleStateStateFrozen enum const.
	PageSetWebLifecycleStateStateFrozen PageSetWebLifecycleStateState = "frozen"

	// PageSetWebLifecycleStateStateActive enum const.
	PageSetWebLifecycleStateStateActive PageSetWebLifecycleStateState = "active"
)

// PageSetWebLifecycleState (experimental) Tries to update the web lifecycle state of the page.
// It will transition the page to the given state according to:
// https://github.com/WICG/web-lifecycle/
type PageSetWebLifecycleState struct {
	// State Target lifecycle state
	State PageSetWebLifecycleStateState `json:"state"`
}

// ProtoReq name.
func (m PageSetWebLifecycleState) ProtoReq() string { return "Page.setWebLifecycleState" }

// Call sends the request.
func (m PageSetWebLifecycleState) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageStopScreencast (experimental) Stops sending each frame in the `screencastFrame`.
type PageStopScreencast struct{}

// ProtoReq name.
func (m PageStopScreencast) ProtoReq() string { return "Page.stopScreencast" }

// Call sends the request.
func (m PageStopScreencast) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageProduceCompilationCache (experimental) Requests backend to produce compilation cache for the specified scripts.
// `scripts` are appended to the list of scripts for which the cache
// would be produced. The list may be reset during page navigation.
// When script with a matching URL is encountered, the cache is optionally
// produced upon backend discretion, based on internal heuristics.
// See also: `Page.compilationCacheProduced`.
type PageProduceCompilationCache struct {
	// Scripts ...
	Scripts []*PageCompilationCacheParams `json:"scripts"`
}

// ProtoReq name.
func (m PageProduceCompilationCache) ProtoReq() string { return "Page.produceCompilationCache" }

// Call sends the request.
func (m PageProduceCompilationCache) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageAddCompilationCache (experimental) Seeds compilation cache for given url. Compilation cache does not survive
// cross-process navigation.
type PageAddCompilationCache struct {
	// URL ...
	URL string `json:"url"`

	// Data Base64-encoded data
	Data []byte `json:"data"`
}

// ProtoReq name.
func (m PageAddCompilationCache) ProtoReq() string { return "Page.addCompilationCache" }

// Call sends the request.
func (m PageAddCompilationCache) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageClearCompilationCache (experimental) Clears seeded compilation cache.
type PageClearCompilationCache struct{}

// ProtoReq name.
func (m PageClearCompilationCache) ProtoReq() string { return "Page.clearCompilationCache" }

// Call sends the request.
func (m PageClearCompilationCache) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetSPCTransactionMode (experimental) Sets the Secure Payment Confirmation transaction mode.
// https://w3c.github.io/secure-payment-confirmation/#sctn-automation-set-spc-transaction-mode
type PageSetSPCTransactionMode struct {
	// Mode ...
	Mode PageAutoResponseMode `json:"mode"`
}

// ProtoReq name.
func (m PageSetSPCTransactionMode) ProtoReq() string { return "Page.setSPCTransactionMode" }

// Call sends the request.
func (m PageSetSPCTransactionMode) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetRPHRegistrationMode (experimental) Extensions for Custom Handlers API:
// https://html.spec.whatwg.org/multipage/system-state.html#rph-automation
type PageSetRPHRegistrationMode struct {
	// Mode ...
	Mode PageAutoResponseMode `json:"mode"`
}

// ProtoReq name.
func (m PageSetRPHRegistrationMode) ProtoReq() string { return "Page.setRPHRegistrationMode" }

// Call sends the request.
func (m PageSetRPHRegistrationMode) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageGenerateTestReport (experimental) Generates a report for testing.
type PageGenerateTestReport struct {
	// Message to be displayed in the report.
	Message string `json:"message"`

	// Group (optional) Specifies the endpoint group to deliver the report to.
	Group string `json:"group,omitempty"`
}

// ProtoReq name.
func (m PageGenerateTestReport) ProtoReq() string { return "Page.generateTestReport" }

// Call sends the request.
func (m PageGenerateTestReport) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageWaitForDebugger (experimental) Pauses page execution. Can be resumed using generic Runtime.runIfWaitingForDebugger.
type PageWaitForDebugger struct{}

// ProtoReq name.
func (m PageWaitForDebugger) ProtoReq() string { return "Page.waitForDebugger" }

// Call sends the request.
func (m PageWaitForDebugger) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetInterceptFileChooserDialog Intercept file chooser requests and transfer control to protocol clients.
// When file chooser interception is enabled, native file chooser dialog is not shown.
// Instead, a protocol event `Page.fileChooserOpened` is emitted.
type PageSetInterceptFileChooserDialog struct {
	// Enabled ...
	Enabled bool `json:"enabled"`
}

// ProtoReq name.
func (m PageSetInterceptFileChooserDialog) ProtoReq() string {
	return "Page.setInterceptFileChooserDialog"
}

// Call sends the request.
func (m PageSetInterceptFileChooserDialog) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageSetPrerenderingAllowed (experimental) Enable/disable prerendering manually.
//
// This command is a short-term solution for https://crbug.com/1440085.
// See https://docs.google.com/document/d/12HVmFxYj5Jc-eJr5OmWsa2bqTJsbgGLKI6ZIyx0_wpA
// for more details.
//
// TODO(https://crbug.com/1440085): Remove this once Puppeteer supports tab targets.
type PageSetPrerenderingAllowed struct {
	// IsAllowed ...
	IsAllowed bool `json:"isAllowed"`
}

// ProtoReq name.
func (m PageSetPrerenderingAllowed) ProtoReq() string { return "Page.setPrerenderingAllowed" }

// Call sends the request.
func (m PageSetPrerenderingAllowed) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PageDomContentEventFired ...
type PageDomContentEventFired struct {
	// Timestamp ...
	Timestamp MonotonicTime `json:"timestamp"`
}

// ProtoEvent name.
func (evt PageDomContentEventFired) ProtoEvent() string {
	return "Page.domContentEventFired"
}

// PageFileChooserOpenedMode enum.
type PageFileChooserOpenedMode string

const (
	// PageFileChooserOpenedModeSelectSingle enum const.
	PageFileChooserOpenedModeSelectSingle PageFileChooserOpenedMode = "selectSingle"

	// PageFileChooserOpenedModeSelectMultiple enum const.
	PageFileChooserOpenedModeSelectMultiple PageFileChooserOpenedMode = "selectMultiple"
)

// PageFileChooserOpened Emitted only when `page.interceptFileChooser` is enabled.
type PageFileChooserOpened struct {
	// FrameID (experimental) Id of the frame containing input node.
	FrameID PageFrameID `json:"frameId"`

	// Mode Input mode.
	Mode PageFileChooserOpenedMode `json:"mode"`

	// BackendNodeID (experimental) (optional) Input node id. Only present for file choosers opened via an `<input type="file">` element.
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`
}

// ProtoEvent name.
func (evt PageFileChooserOpened) ProtoEvent() string {
	return "Page.fileChooserOpened"
}

// PageFrameAttached Fired when frame has been attached to its parent.
type PageFrameAttached struct {
	// FrameID Id of the frame that has been attached.
	FrameID PageFrameID `json:"frameId"`

	// ParentFrameID Parent frame identifier.
	ParentFrameID PageFrameID `json:"parentFrameId"`

	// Stack (optional) JavaScript stack trace of when frame was attached, only set if frame initiated from script.
	Stack *RuntimeStackTrace `json:"stack,omitempty"`
}

// ProtoEvent name.
func (evt PageFrameAttached) ProtoEvent() string {
	return "Page.frameAttached"
}

// PageFrameClearedScheduledNavigation (deprecated) Fired when frame no longer has a scheduled navigation.
type PageFrameClearedScheduledNavigation struct {
	// FrameID Id of the frame that has cleared its scheduled navigation.
	FrameID PageFrameID `json:"frameId"`
}

// ProtoEvent name.
func (evt PageFrameClearedScheduledNavigation) ProtoEvent() string {
	return "Page.frameClearedScheduledNavigation"
}

// PageFrameDetachedReason enum.
type PageFrameDetachedReason string

const (
	// PageFrameDetachedReasonRemove enum const.
	PageFrameDetachedReasonRemove PageFrameDetachedReason = "remove"

	// PageFrameDetachedReasonSwap enum const.
	PageFrameDetachedReasonSwap PageFrameDetachedReason = "swap"
)

// PageFrameDetached Fired when frame has been detached from its parent.
type PageFrameDetached struct {
	// FrameID Id of the frame that has been detached.
	FrameID PageFrameID `json:"frameId"`

	// Reason (experimental) ...
	Reason PageFrameDetachedReason `json:"reason"`
}

// ProtoEvent name.
func (evt PageFrameDetached) ProtoEvent() string {
	return "Page.frameDetached"
}

// PageFrameNavigated Fired once navigation of the frame has completed. Frame is now associated with the new loader.
type PageFrameNavigated struct {
	// Frame object.
	Frame *PageFrame `json:"frame"`

	// Type (experimental) ...
	Type PageNavigationType `json:"type"`
}

// ProtoEvent name.
func (evt PageFrameNavigated) ProtoEvent() string {
	return "Page.frameNavigated"
}

// PageDocumentOpened (experimental) Fired when opening document to write to.
type PageDocumentOpened struct {
	// Frame object.
	Frame *PageFrame `json:"frame"`
}

// ProtoEvent name.
func (evt PageDocumentOpened) ProtoEvent() string {
	return "Page.documentOpened"
}

// PageFrameResized (experimental) ...
type PageFrameResized struct{}

// ProtoEvent name.
func (evt PageFrameResized) ProtoEvent() string {
	return "Page.frameResized"
}

// PageFrameRequestedNavigation (experimental) Fired when a renderer-initiated navigation is requested.
// Navigation may still be cancelled after the event is issued.
type PageFrameRequestedNavigation struct {
	// FrameID Id of the frame that is being navigated.
	FrameID PageFrameID `json:"frameId"`

	// Reason The reason for the navigation.
	Reason PageClientNavigationReason `json:"reason"`

	// URL The destination URL for the requested navigation.
	URL string `json:"url"`

	// Disposition The disposition for the navigation.
	Disposition PageClientNavigationDisposition `json:"disposition"`
}

// ProtoEvent name.
func (evt PageFrameRequestedNavigation) ProtoEvent() string {
	return "Page.frameRequestedNavigation"
}

// PageFrameScheduledNavigation (deprecated) Fired when frame schedules a potential navigation.
type PageFrameScheduledNavigation struct {
	// FrameID Id of the frame that has scheduled a navigation.
	FrameID PageFrameID `json:"frameId"`

	// Delay (in seconds) until the navigation is scheduled to begin. The navigation is not
	// guaranteed to start.
	Delay float64 `json:"delay"`

	// Reason The reason for the navigation.
	Reason PageClientNavigationReason `json:"reason"`

	// URL The destination URL for the scheduled navigation.
	URL string `json:"url"`
}

// ProtoEvent name.
func (evt PageFrameScheduledNavigation) ProtoEvent() string {
	return "Page.frameScheduledNavigation"
}

// PageFrameStartedLoading (experimental) Fired when frame has started loading.
type PageFrameStartedLoading struct {
	// FrameID Id of the frame that has started loading.
	FrameID PageFrameID `json:"frameId"`
}

// ProtoEvent name.
func (evt PageFrameStartedLoading) ProtoEvent() string {
	return "Page.frameStartedLoading"
}

// PageFrameStoppedLoading (experimental) Fired when frame has stopped loading.
type PageFrameStoppedLoading struct {
	// FrameID Id of the frame that has stopped loading.
	FrameID PageFrameID `json:"frameId"`
}

// ProtoEvent name.
func (evt PageFrameStoppedLoading) ProtoEvent() string {
	return "Page.frameStoppedLoading"
}

// PageDownloadWillBegin (deprecated) (experimental) Fired when page is about to start a download.
// Deprecated. Use Browser.downloadWillBegin instead.
type PageDownloadWillBegin struct {
	// FrameID Id of the frame that caused download to begin.
	FrameID PageFrameID `json:"frameId"`

	// GUID Global unique identifier of the download.
	GUID string `json:"guid"`

	// URL of the resource being downloaded.
	URL string `json:"url"`

	// SuggestedFilename Suggested file name of the resource (the actual name of the file saved on disk may differ).
	SuggestedFilename string `json:"suggestedFilename"`
}

// ProtoEvent name.
func (evt PageDownloadWillBegin) ProtoEvent() string {
	return "Page.downloadWillBegin"
}

// PageDownloadProgressState enum.
type PageDownloadProgressState string

const (
	// PageDownloadProgressStateInProgress enum const.
	PageDownloadProgressStateInProgress PageDownloadProgressState = "inProgress"

	// PageDownloadProgressStateCompleted enum const.
	PageDownloadProgressStateCompleted PageDownloadProgressState = "completed"

	// PageDownloadProgressStateCanceled enum const.
	PageDownloadProgressStateCanceled PageDownloadProgressState = "canceled"
)

// PageDownloadProgress (deprecated) (experimental) Fired when download makes progress. Last call has |done| == true.
// Deprecated. Use Browser.downloadProgress instead.
type PageDownloadProgress struct {
	// GUID Global unique identifier of the download.
	GUID string `json:"guid"`

	// TotalBytes Total expected bytes to download.
	TotalBytes float64 `json:"totalBytes"`

	// ReceivedBytes Total bytes received.
	ReceivedBytes float64 `json:"receivedBytes"`

	// State Download status.
	State PageDownloadProgressState `json:"state"`
}

// ProtoEvent name.
func (evt PageDownloadProgress) ProtoEvent() string {
	return "Page.downloadProgress"
}

// PageInterstitialHidden Fired when interstitial page was hidden.
type PageInterstitialHidden struct{}

// ProtoEvent name.
func (evt PageInterstitialHidden) ProtoEvent() string {
	return "Page.interstitialHidden"
}

// PageInterstitialShown Fired when interstitial page was shown.
type PageInterstitialShown struct{}

// ProtoEvent name.
func (evt PageInterstitialShown) ProtoEvent() string {
	return "Page.interstitialShown"
}

// PageJavascriptDialogClosed Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) has been
// closed.
type PageJavascriptDialogClosed struct {
	// Result Whether dialog was confirmed.
	Result bool `json:"result"`

	// UserInput User input in case of prompt.
	UserInput string `json:"userInput"`
}

// ProtoEvent name.
func (evt PageJavascriptDialogClosed) ProtoEvent() string {
	return "Page.javascriptDialogClosed"
}

// PageJavascriptDialogOpening Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) is about to
// open.
type PageJavascriptDialogOpening struct {
	// URL Frame url.
	URL string `json:"url"`

	// Message that will be displayed by the dialog.
	Message string `json:"message"`

	// Type Dialog type.
	Type PageDialogType `json:"type"`

	// HasBrowserHandler True iff browser is capable showing or acting on the given dialog. When browser has no
	// dialog handler for given target, calling alert while Page domain is engaged will stall
	// the page execution. Execution can be resumed via calling Page.handleJavaScriptDialog.
	HasBrowserHandler bool `json:"hasBrowserHandler"`

	// DefaultPrompt (optional) Default dialog prompt.
	DefaultPrompt string `json:"defaultPrompt,omitempty"`
}

// ProtoEvent name.
func (evt PageJavascriptDialogOpening) ProtoEvent() string {
	return "Page.javascriptDialogOpening"
}

// PageLifecycleEventName enum.
type PageLifecycleEventName string

const (
	// PageLifecycleEventNameInit enum const.
	PageLifecycleEventNameInit PageLifecycleEventName = "init"

	// PageLifecycleEventNameFirstPaint enum const.
	PageLifecycleEventNameFirstPaint PageLifecycleEventName = "firstPaint"

	// PageLifecycleEventNameFirstContentfulPaint enum const.
	PageLifecycleEventNameFirstContentfulPaint PageLifecycleEventName = "firstContentfulPaint"

	// PageLifecycleEventNameFirstImagePaint enum const.
	PageLifecycleEventNameFirstImagePaint PageLifecycleEventName = "firstImagePaint"

	// PageLifecycleEventNameFirstMeaningfulPaintCandidate enum const.
	PageLifecycleEventNameFirstMeaningfulPaintCandidate PageLifecycleEventName = "firstMeaningfulPaintCandidate"

	// PageLifecycleEventNameDOMContentLoaded enum const.
	PageLifecycleEventNameDOMContentLoaded PageLifecycleEventName = "DOMContentLoaded"

	// PageLifecycleEventNameLoad enum const.
	PageLifecycleEventNameLoad PageLifecycleEventName = "load"

	// PageLifecycleEventNameNetworkAlmostIdle enum const.
	PageLifecycleEventNameNetworkAlmostIdle PageLifecycleEventName = "networkAlmostIdle"

	// PageLifecycleEventNameFirstMeaningfulPaint enum const.
	PageLifecycleEventNameFirstMeaningfulPaint PageLifecycleEventName = "firstMeaningfulPaint"

	// PageLifecycleEventNameNetworkIdle enum const.
	PageLifecycleEventNameNetworkIdle PageLifecycleEventName = "networkIdle"
)

// PageLifecycleEvent Fired for top level page lifecycle events such as navigation, load, paint, etc.
type PageLifecycleEvent struct {
	// FrameID Id of the frame.
	FrameID PageFrameID `json:"frameId"`

	// LoaderID Loader identifier. Empty string if the request is fetched from worker.
	LoaderID NetworkLoaderID `json:"loaderId"`

	// Name ...
	Name PageLifecycleEventName `json:"name"`

	// Timestamp ...
	Timestamp MonotonicTime `json:"timestamp"`
}

// ProtoEvent name.
func (evt PageLifecycleEvent) ProtoEvent() string {
	return "Page.lifecycleEvent"
}

// PageBackForwardCacheNotUsed (experimental) Fired for failed bfcache history navigations if BackForwardCache feature is enabled. Do
// not assume any ordering with the Page.frameNavigated event. This event is fired only for
// main-frame history navigation where the document changes (non-same-document navigations),
// when bfcache navigation fails.
type PageBackForwardCacheNotUsed struct {
	// LoaderID The loader id for the associated navigation.
	LoaderID NetworkLoaderID `json:"loaderId"`

	// FrameID The frame id of the associated frame.
	FrameID PageFrameID `json:"frameId"`

	// NotRestoredExplanations Array of reasons why the page could not be cached. This must not be empty.
	NotRestoredExplanations []*PageBackForwardCacheNotRestoredExplanation `json:"notRestoredExplanations"`

	// NotRestoredExplanationsTree (optional) Tree structure of reasons why the page could not be cached for each frame.
	NotRestoredExplanationsTree *PageBackForwardCacheNotRestoredExplanationTree `json:"notRestoredExplanationsTree,omitempty"`
}

// ProtoEvent name.
func (evt PageBackForwardCacheNotUsed) ProtoEvent() string {
	return "Page.backForwardCacheNotUsed"
}

// PageLoadEventFired ...
type PageLoadEventFired struct {
	// Timestamp ...
	Timestamp MonotonicTime `json:"timestamp"`
}

// ProtoEvent name.
func (evt PageLoadEventFired) ProtoEvent() string {
	return "Page.loadEventFired"
}

// PageNavigatedWithinDocument (experimental) Fired when same-document navigation happens, e.g. due to history API usage or anchor navigation.
type PageNavigatedWithinDocument struct {
	// FrameID Id of the frame.
	FrameID PageFrameID `json:"frameId"`

	// URL Frame's new url.
	URL string `json:"url"`
}

// ProtoEvent name.
func (evt PageNavigatedWithinDocument) ProtoEvent() string {
	return "Page.navigatedWithinDocument"
}

// PageScreencastFrame (experimental) Compressed image data requested by the `startScreencast`.
type PageScreencastFrame struct {
	// Data Base64-encoded compressed image.
	Data []byte `json:"data"`

	// Metadata Screencast frame metadata.
	Metadata *PageScreencastFrameMetadata `json:"metadata"`

	// SessionID Frame number.
	SessionID int `json:"sessionId"`
}

// ProtoEvent name.
func (evt PageScreencastFrame) ProtoEvent() string {
	return "Page.screencastFrame"
}

// PageScreencastVisibilityChanged (experimental) Fired when the page with currently enabled screencast was shown or hidden `.
type PageScreencastVisibilityChanged struct {
	// Visible True if the page is visible.
	Visible bool `json:"visible"`
}

// ProtoEvent name.
func (evt PageScreencastVisibilityChanged) ProtoEvent() string {
	return "Page.screencastVisibilityChanged"
}

// PageWindowOpen Fired when a new window is going to be opened, via window.open(), link click, form submission,
// etc.
type PageWindowOpen struct {
	// URL The URL for the new window.
	URL string `json:"url"`

	// WindowName Window name.
	WindowName string `json:"windowName"`

	// WindowFeatures An array of enabled window features.
	WindowFeatures []string `json:"windowFeatures"`

	// UserGesture Whether or not it was triggered by user gesture.
	UserGesture bool `json:"userGesture"`
}

// ProtoEvent name.
func (evt PageWindowOpen) ProtoEvent() string {
	return "Page.windowOpen"
}

// PageCompilationCacheProduced (experimental) Issued for every compilation cache generated. Is only available
// if Page.setGenerateCompilationCache is enabled.
type PageCompilationCacheProduced struct {
	// URL ...
	URL string `json:"url"`

	// Data Base64-encoded data
	Data []byte `json:"data"`
}

// ProtoEvent name.
func (evt PageCompilationCacheProduced) ProtoEvent() string {
	return "Page.compilationCacheProduced"
}
