#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag / commit.
REPO='https://github.com/pnggroup/libpng'; TAG='v1.6.47'
git clone "$REPO" --depth=1 --branch="${TAG}" /png
cd /png

# Make modifications to flags.
export CFLAGS=$(trim_spaces ${CFLAGS} \
-mllvm \
-wasm-enable-sjlj \
)

# Configure build parameters.
./configure --host=x86-gnu \
            --prefix=/vendor \
            --exec-prefix=/vendor \
            --enable-static \
            --disable-hardware-optimizations \
            --disable-tests \
            --disable-tools \
|| { cat config.log; exit 1; }

# Copy zlib install across
# otherwise it fails to find...
cp /vendor/include/zlib.h \
   /vendor/include/zconf.h \
   .

# Perform library install.
make -j $(nproc) install
